"""quarterly

Revision ID: 03025f750d7f
Revises: 24acb0e30023
Create Date: 2025-04-05 07:31:15.820710

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import sqlmodel

# revision identifiers, used by Alembic.
revision: str = "03025f750d7f"
down_revision: Union[str, None] = "24acb0e30023"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "quarterlybalancesheet",
        sa.Column("symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("exchange", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("source", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("date", sa.DateTime(), nullable=False),
        sa.Column("created_at", sa.Date(), nullable=False),
        sa.Column("treasury_stock", sa.Float(), nullable=True),
        sa.Column("common_stock_shares_outstanding", sa.Float(), nullable=True),
        sa.Column("common_stock", sa.Float(), nullable=True),
        sa.Column("short_long_term_debt_total", sa.Float(), nullable=True),
        sa.Column("capital_lease_obligations", sa.Float(), nullable=True),
        sa.Column("total_shareholder_equity", sa.Float(), nullable=True),
        sa.Column("retained_earnings", sa.Float(), nullable=True),
        sa.Column("total_liabilities", sa.Float(), nullable=True),
        sa.Column("total_non_current_liabilities", sa.Float(), nullable=True),
        sa.Column("other_non_current_liabilities", sa.Float(), nullable=True),
        sa.Column("long_term_debt", sa.Float(), nullable=True),
        sa.Column("total_current_liabilities", sa.Float(), nullable=True),
        sa.Column("other_current_liabilities", sa.Float(), nullable=True),
        sa.Column("current_debt", sa.Float(), nullable=True),
        sa.Column("current_accounts_payable", sa.Float(), nullable=True),
        sa.Column("total_assets", sa.Float(), nullable=True),
        sa.Column("total_non_current_assets", sa.Float(), nullable=True),
        sa.Column("other_non_current_assets", sa.Float(), nullable=True),
        sa.Column(
            "accumulated_depreciation_amortization_ppe", sa.Float(), nullable=True
        ),
        sa.Column("property_plant_equipment", sa.Float(), nullable=True),
        sa.Column("total_current_assets", sa.Float(), nullable=True),
        sa.Column("other_current_assets", sa.Float(), nullable=True),
        sa.Column("inventory", sa.Float(), nullable=True),
        sa.Column("current_net_receivables", sa.Float(), nullable=True),
        sa.Column("cash_and_short_term_investments", sa.Float(), nullable=True),
        sa.Column(
            "cash_and_cash_equivalents_at_carrying_value", sa.Float(), nullable=True
        ),
        sa.PrimaryKeyConstraint("symbol", "source", "date"),
    )
    with op.batch_alter_table("quarterlybalancesheet", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_quarterlybalancesheet_date"), ["date"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_quarterlybalancesheet_source"), ["source"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_quarterlybalancesheet_symbol"), ["symbol"], unique=False
        )

    op.create_table(
        "quarterlycashflow",
        sa.Column("symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("exchange", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("source", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("date", sa.DateTime(), nullable=False),
        sa.Column("created_at", sa.Date(), nullable=False),
        sa.Column("operating_cash_flow", sa.Float(), nullable=True),
        sa.Column("change_in_operating_liabilities", sa.Float(), nullable=True),
        sa.Column("change_in_working_capital", sa.Float(), nullable=True),
        sa.Column("change_in_other_working_capital", sa.Float(), nullable=True),
        sa.Column("change_in_receivables", sa.Float(), nullable=True),
        sa.Column("change_in_inventory", sa.Float(), nullable=True),
        sa.Column("depreciation_amortization_depletion", sa.Float(), nullable=True),
        sa.Column("capital_expenditure", sa.Float(), nullable=True),
        sa.Column("cash_flow_from_investing_activities", sa.Float(), nullable=True),
        sa.Column("financing_cash_flow", sa.Float(), nullable=True),
        sa.Column("repurchase_of_capital_stock", sa.Float(), nullable=True),
        sa.Column("cash_dividends_paid", sa.Float(), nullable=True),
        sa.Column("common_stock_dividend_paid", sa.Float(), nullable=True),
        sa.Column("proceeds_from_issuance_of_common_stock", sa.Float(), nullable=True),
        sa.Column("changes_in_cash", sa.Float(), nullable=True),
        sa.Column("net_income_from_continuing_operations", sa.Float(), nullable=True),
        sa.PrimaryKeyConstraint("symbol", "source", "date"),
    )
    with op.batch_alter_table("quarterlycashflow", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_quarterlycashflow_date"), ["date"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_quarterlycashflow_source"), ["source"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_quarterlycashflow_symbol"), ["symbol"], unique=False
        )

    op.create_table(
        "quarterlyfinancialmetrics",
        sa.Column("symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("exchange", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("source", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("date", sa.DateTime(), nullable=False),
        sa.Column("created_at", sa.Date(), nullable=False),
        sa.Column("ebitda", sa.Float(), nullable=True),
        sa.Column("net_income", sa.Float(), nullable=True),
        sa.Column("pe_ratio", sa.Float(), nullable=True),
        sa.Column("market_capitalization", sa.Float(), nullable=True),
        sa.Column("basic_eps", sa.Float(), nullable=True),
        sa.Column("diluted_eps", sa.Float(), nullable=True),
        sa.Column("total_revenue", sa.Float(), nullable=True),
        sa.Column("operating_revenue", sa.Float(), nullable=True),
        sa.Column("gross_profit", sa.Float(), nullable=True),
        sa.Column("total_expenses", sa.Float(), nullable=True),
        sa.Column("operating_income", sa.Float(), nullable=True),
        sa.Column("profit_margin", sa.Float(), nullable=True),
        sa.Column("cost_of_revenue", sa.Float(), nullable=True),
        sa.Column("tax_provision", sa.Float(), nullable=True),
        sa.Column("tax_rate", sa.Float(), nullable=True),
        sa.PrimaryKeyConstraint("symbol", "source", "date"),
    )
    with op.batch_alter_table("quarterlyfinancialmetrics", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_quarterlyfinancialmetrics_date"), ["date"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_quarterlyfinancialmetrics_source"), ["source"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_quarterlyfinancialmetrics_symbol"), ["symbol"], unique=False
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("quarterlyfinancialmetrics", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_quarterlyfinancialmetrics_symbol"))
        batch_op.drop_index(batch_op.f("ix_quarterlyfinancialmetrics_source"))
        batch_op.drop_index(batch_op.f("ix_quarterlyfinancialmetrics_date"))

    op.drop_table("quarterlyfinancialmetrics")
    with op.batch_alter_table("quarterlycashflow", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_quarterlycashflow_symbol"))
        batch_op.drop_index(batch_op.f("ix_quarterlycashflow_source"))
        batch_op.drop_index(batch_op.f("ix_quarterlycashflow_date"))

    op.drop_table("quarterlycashflow")
    with op.batch_alter_table("quarterlybalancesheet", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_quarterlybalancesheet_symbol"))
        batch_op.drop_index(batch_op.f("ix_quarterlybalancesheet_source"))
        batch_op.drop_index(batch_op.f("ix_quarterlybalancesheet_date"))

    op.drop_table("quarterlybalancesheet")
    # ### end Alembic commands ###
