"""Update analysis

Revision ID: 24acb0e30023
Revises: 732544581a65
Create Date: 2025-04-02 21:58:07.479662

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = "24acb0e30023"
down_revision: Union[str, None] = "732544581a65"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("positive_free_cash_flow", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("growing_operating_cash_flow", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column(
                "operating_cash_flow_is_higher_than_net_income",
                sa.Float(),
                nullable=True,
            )
        )
        batch_op.add_column(sa.Column("mean_capex_ratio", sa.Float(), nullable=True))
        batch_op.add_column(sa.Column("max_capex_ratio", sa.Float(), nullable=True))
        batch_op.add_column(sa.Column("min_capex_ratio", sa.Float(), nullable=True))
        batch_op.add_column(
            sa.Column("mean_dividend_payout_ratio", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("max_dividend_payout_ratio", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("min_dividend_payout_ratio", sa.Float(), nullable=True)
        )
        batch_op.add_column(sa.Column("positive_net_income", sa.Float(), nullable=True))
        batch_op.add_column(
            sa.Column("positive_operating_income", sa.Float(), nullable=True)
        )
        batch_op.add_column(sa.Column("growing_net_income", sa.Float(), nullable=True))
        batch_op.add_column(
            sa.Column("growing_operating_income", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("positive_diluted_eps", sa.Float(), nullable=True)
        )
        batch_op.add_column(sa.Column("positive_basic_eps", sa.Float(), nullable=True))
        batch_op.add_column(sa.Column("growing_basic_eps", sa.Float(), nullable=True))
        batch_op.add_column(sa.Column("growing_diluted_eps", sa.Float(), nullable=True))
        batch_op.add_column(
            sa.Column("positive_debt_to_equity", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("positive_return_on_assets", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("positive_return_on_equity", sa.Float(), nullable=True)
        )
        batch_op.add_column(sa.Column("earning_per_share", sa.Float(), nullable=True))
        batch_op.add_column(
            sa.Column("price_per_earning_ratio", sa.Float(), nullable=True)
        )
        batch_op.drop_column("net_income_growth_2")
        batch_op.drop_column("net_income_growth_3")
        batch_op.drop_column("net_income_growth_0")
        batch_op.drop_column("net_income_growth_1")

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.add_column(sa.Column("net_income_growth_1", sa.FLOAT(), nullable=True))
        batch_op.add_column(sa.Column("net_income_growth_0", sa.FLOAT(), nullable=True))
        batch_op.add_column(sa.Column("net_income_growth_3", sa.FLOAT(), nullable=True))
        batch_op.add_column(sa.Column("net_income_growth_2", sa.FLOAT(), nullable=True))
        batch_op.drop_column("price_per_earning_ratio")
        batch_op.drop_column("earning_per_share")
        batch_op.drop_column("positive_return_on_equity")
        batch_op.drop_column("positive_return_on_assets")
        batch_op.drop_column("positive_debt_to_equity")
        batch_op.drop_column("growing_diluted_eps")
        batch_op.drop_column("growing_basic_eps")
        batch_op.drop_column("positive_basic_eps")
        batch_op.drop_column("positive_diluted_eps")
        batch_op.drop_column("growing_operating_income")
        batch_op.drop_column("growing_net_income")
        batch_op.drop_column("positive_operating_income")
        batch_op.drop_column("positive_net_income")
        batch_op.drop_column("min_dividend_payout_ratio")
        batch_op.drop_column("max_dividend_payout_ratio")
        batch_op.drop_column("mean_dividend_payout_ratio")
        batch_op.drop_column("min_capex_ratio")
        batch_op.drop_column("max_capex_ratio")
        batch_op.drop_column("mean_capex_ratio")
        batch_op.drop_column("operating_cash_flow_is_higher_than_net_income")
        batch_op.drop_column("growing_operating_cash_flow")
        batch_op.drop_column("positive_free_cash_flow")

    # ### end Alembic commands ###
