"""Add columns

Revision ID: 51d6e76a514e
Revises: 
Create Date: 2025-03-27 17:46:47.394356

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import sqlmodel

# revision identifiers, used by Alembic.
revision: str = "51d6e76a514e"
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "analysis",
        sa.Column("net_income_growth_0", sa.Float(), nullable=True),
        sa.Column("net_income_growth_1", sa.Float(), nullable=True),
        sa.Column("net_income_growth_2", sa.Float(), nullable=True),
        sa.Column("net_income_growth_3", sa.Float(), nullable=True),
        sa.Column("rsi_last_value", sa.Float(), nullable=True),
        sa.Column("macd_12_26_9_buy_date", sa.Date(), nullable=True),
        sa.Column("ma_50_200_buy_date", sa.Date(), nullable=True),
        sa.Column("slope_7", sa.Float(), nullable=True),
        sa.Column("slope_14", sa.Float(), nullable=True),
        sa.Column("slope_30", sa.Float(), nullable=True),
        sa.Column("slope_60", sa.Float(), nullable=True),
        sa.Column("last_adx", sa.Float(), nullable=True),
        sa.Column("last_dmp", sa.Float(), nullable=True),
        sa.Column("last_dmn", sa.Float(), nullable=True),
        sa.Column("last_price", sa.Float(), nullable=True),
        sa.Column("last_price_date", sa.Date(), nullable=True),
        sa.Column("symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("exchange", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("source", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("date", sa.Date(), nullable=False),
        sa.Column("created_at", sa.Date(), nullable=False),
        sa.Column("base_symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("modifier", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("name", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("summary", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("currency", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("market", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("isin", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("country", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("sector", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("industry_group", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("industry", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("website", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("market_capitalization", sa.Float(), nullable=True),
        sa.Column("book_value", sa.Float(), nullable=True),
        sa.Column("price_to_book", sa.Float(), nullable=True),
        sa.Column("trailing_price_to_earnings", sa.Float(), nullable=True),
        sa.Column("dividend_yield", sa.Float(), nullable=True),
        sa.Column("dividend_rate", sa.Float(), nullable=True),
        sa.Column("trailing_earnings_per_share", sa.Float(), nullable=True),
        sa.Column("forward_earnings_per_share", sa.Float(), nullable=True),
        sa.Column("return_on_equity", sa.Float(), nullable=True),
        sa.Column("operating_margins", sa.Float(), nullable=True),
        sa.Column("gross_margins", sa.Float(), nullable=True),
        sa.Column("revenue_growth", sa.Float(), nullable=True),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sqlite_autoincrement=True,
    )
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_analysis_source"), ["source"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_analysis_symbol"), ["symbol"], unique=False
        )

    op.create_table(
        "balancesheet",
        sa.Column("symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("exchange", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("source", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("date", sa.DateTime(), nullable=False),
        sa.Column("created_at", sa.Date(), nullable=False),
        sa.Column("treasury_stock", sa.Float(), nullable=True),
        sa.Column("common_stock_shares_outstanding", sa.Float(), nullable=True),
        sa.Column("common_stock", sa.Float(), nullable=True),
        sa.Column("short_long_term_debt_total", sa.Float(), nullable=True),
        sa.Column("capital_lease_obligations", sa.Float(), nullable=True),
        sa.Column("total_shareholder_equity", sa.Float(), nullable=True),
        sa.Column("retained_earnings", sa.Float(), nullable=True),
        sa.Column("total_liabilities", sa.Float(), nullable=True),
        sa.Column("total_non_current_liabilities", sa.Float(), nullable=True),
        sa.Column("other_non_current_liabilities", sa.Float(), nullable=True),
        sa.Column("long_term_debt", sa.Float(), nullable=True),
        sa.Column("total_current_liabilities", sa.Float(), nullable=True),
        sa.Column("other_current_liabilities", sa.Float(), nullable=True),
        sa.Column("current_debt", sa.Float(), nullable=True),
        sa.Column("current_accounts_payable", sa.Float(), nullable=True),
        sa.Column("total_assets", sa.Float(), nullable=True),
        sa.Column("total_non_current_assets", sa.Float(), nullable=True),
        sa.Column("other_non_current_assets", sa.Float(), nullable=True),
        sa.Column(
            "accumulated_depreciation_amortization_ppe", sa.Float(), nullable=True
        ),
        sa.Column("property_plant_equipment", sa.Float(), nullable=True),
        sa.Column("total_current_assets", sa.Float(), nullable=True),
        sa.Column("other_current_assets", sa.Float(), nullable=True),
        sa.Column("inventory", sa.Float(), nullable=True),
        sa.Column("current_net_receivables", sa.Float(), nullable=True),
        sa.Column("cash_and_short_term_investments", sa.Float(), nullable=True),
        sa.Column(
            "cash_and_cash_equivalents_at_carrying_value", sa.Float(), nullable=True
        ),
        sa.PrimaryKeyConstraint("symbol", "source", "date"),
    )
    with op.batch_alter_table("balancesheet", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_balancesheet_date"), ["date"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_balancesheet_source"), ["source"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_balancesheet_symbol"), ["symbol"], unique=False
        )

    op.create_table(
        "cashflow",
        sa.Column("symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("exchange", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("source", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("date", sa.DateTime(), nullable=False),
        sa.Column("created_at", sa.Date(), nullable=False),
        sa.Column("operating_cash_flow", sa.Float(), nullable=True),
        sa.Column("change_in_operating_liabilities", sa.Float(), nullable=True),
        sa.Column("change_in_working_capital", sa.Float(), nullable=True),
        sa.Column("change_in_other_working_capital", sa.Float(), nullable=True),
        sa.Column("change_in_receivables", sa.Float(), nullable=True),
        sa.Column("change_in_inventory", sa.Float(), nullable=True),
        sa.Column("depreciation_amortization_depletion", sa.Float(), nullable=True),
        sa.Column("capital_expenditure", sa.Float(), nullable=True),
        sa.Column("cash_flow_from_investing_activities", sa.Float(), nullable=True),
        sa.Column("financing_cash_flow", sa.Float(), nullable=True),
        sa.Column("repurchase_of_capital_stock", sa.Float(), nullable=True),
        sa.Column("cash_dividends_paid", sa.Float(), nullable=True),
        sa.Column("common_stock_dividend_paid", sa.Float(), nullable=True),
        sa.Column("proceeds_from_issuance_of_common_stock", sa.Float(), nullable=True),
        sa.Column("changes_in_cash", sa.Float(), nullable=True),
        sa.Column("net_income_from_continuing_operations", sa.Float(), nullable=True),
        sa.PrimaryKeyConstraint("symbol", "source", "date"),
    )
    with op.batch_alter_table("cashflow", schema=None) as batch_op:
        batch_op.create_index(batch_op.f("ix_cashflow_date"), ["date"], unique=False)
        batch_op.create_index(
            batch_op.f("ix_cashflow_source"), ["source"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_cashflow_symbol"), ["symbol"], unique=False
        )

    op.create_table(
        "crypto",
        sa.Column("symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("exchange", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("source", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("date", sa.Date(), nullable=False),
        sa.Column("created_at", sa.Date(), nullable=False),
        sa.Column("base_symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("modifier", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("name", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("summary", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("currency", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("market", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("isin", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("country", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("cryptocurrency", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sqlite_autoincrement=True,
    )
    with op.batch_alter_table("crypto", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_crypto_cryptocurrency"), ["cryptocurrency"], unique=False
        )
        batch_op.create_index(batch_op.f("ix_crypto_source"), ["source"], unique=False)
        batch_op.create_index(batch_op.f("ix_crypto_symbol"), ["symbol"], unique=False)

    op.create_table(
        "currency",
        sa.Column("symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("exchange", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("source", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("date", sa.Date(), nullable=False),
        sa.Column("created_at", sa.Date(), nullable=False),
        sa.Column("base_symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("modifier", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("name", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("summary", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("currency", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("market", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("isin", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("country", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("base_currency", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("quote_currency", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sqlite_autoincrement=True,
    )
    with op.batch_alter_table("currency", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_currency_base_currency"), ["base_currency"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_currency_source"), ["source"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_currency_symbol"), ["symbol"], unique=False
        )

    op.create_table(
        "earningsdate",
        sa.Column("symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("exchange", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("source", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("date", sa.DateTime(), nullable=False),
        sa.Column("created_at", sa.Date(), nullable=False),
        sa.Column("eps_estimate", sa.Float(), nullable=True),
        sa.Column("eps_reported", sa.Float(), nullable=True),
        sa.Column("revenue_estimate", sa.Float(), nullable=True),
        sa.Column("revenue_reported", sa.Float(), nullable=True),
        sa.PrimaryKeyConstraint("symbol", "source", "date"),
    )
    with op.batch_alter_table("earningsdate", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_earningsdate_date"), ["date"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_earningsdate_source"), ["source"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_earningsdate_symbol"), ["symbol"], unique=False
        )

    op.create_table(
        "equity",
        sa.Column("symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("exchange", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("source", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("date", sa.Date(), nullable=False),
        sa.Column("created_at", sa.Date(), nullable=False),
        sa.Column("base_symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("modifier", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("name", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("summary", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("currency", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("market", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("isin", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("country", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("sector", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("industry_group", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("industry", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("website", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("market_capitalization", sa.Float(), nullable=True),
        sa.Column("book_value", sa.Float(), nullable=True),
        sa.Column("price_to_book", sa.Float(), nullable=True),
        sa.Column("trailing_price_to_earnings", sa.Float(), nullable=True),
        sa.Column("dividend_yield", sa.Float(), nullable=True),
        sa.Column("dividend_rate", sa.Float(), nullable=True),
        sa.Column("trailing_earnings_per_share", sa.Float(), nullable=True),
        sa.Column("forward_earnings_per_share", sa.Float(), nullable=True),
        sa.Column("return_on_equity", sa.Float(), nullable=True),
        sa.Column("operating_margins", sa.Float(), nullable=True),
        sa.Column("gross_margins", sa.Float(), nullable=True),
        sa.Column("revenue_growth", sa.Float(), nullable=True),
        sa.Column("state", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("city", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("zipcode", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("market_cap", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("shares_outstanding", sa.Float(), nullable=True),
        sa.Column("float_shares", sa.Float(), nullable=True),
        sa.Column("short_shares", sa.Float(), nullable=True),
        sa.Column("forward_price_to_earnings", sa.Float(), nullable=True),
        sa.Column("revenue_per_share", sa.Float(), nullable=True),
        sa.Column("quick_ratio", sa.Float(), nullable=True),
        sa.Column("current_ratio", sa.Float(), nullable=True),
        sa.Column("earning_growth", sa.Float(), nullable=True),
        sa.Column("trailing_peg_ratio", sa.Float(), nullable=True),
        sa.Column("trailing_price_to_sales", sa.Float(), nullable=True),
        sa.Column("return_on_assets", sa.Float(), nullable=True),
        sa.Column("short_ratio", sa.Float(), nullable=True),
        sa.Column("timezone", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("cusip", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("figi", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("composite_figi", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("shareclass_figi", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sqlite_autoincrement=True,
    )
    with op.batch_alter_table("equity", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_equity_country"), ["country"], unique=False
        )
        batch_op.create_index(batch_op.f("ix_equity_source"), ["source"], unique=False)
        batch_op.create_index(batch_op.f("ix_equity_symbol"), ["symbol"], unique=False)

    op.create_table(
        "etf",
        sa.Column("symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("exchange", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("source", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("date", sa.Date(), nullable=False),
        sa.Column("created_at", sa.Date(), nullable=False),
        sa.Column("base_symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("modifier", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("name", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("summary", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("currency", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("market", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("isin", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("country", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("category_group", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("family", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("three_year_earnings_growth", sa.Float(), nullable=True),
        sa.Column("annual_holdings_turnover", sa.Float(), nullable=True),
        sa.Column("annual_report_expense_ratio", sa.Float(), nullable=True),
        sa.Column("holding_percent", sa.JSON(), nullable=True),
        sa.Column("median_market_cap", sa.Float(), nullable=True),
        sa.Column("price_to_book", sa.Float(), nullable=True),
        sa.Column("price_to_cashflow", sa.Float(), nullable=True),
        sa.Column("price_to_earnings", sa.Float(), nullable=True),
        sa.Column("price_to_sales", sa.Float(), nullable=True),
        sa.Column("sector_weightings", sa.JSON(), nullable=True),
        sa.Column("total_net_assets", sa.Float(), nullable=True),
        sa.Column("beta_3_year", sa.Float(), nullable=True),
        sa.Column("category", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("fund_family", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("fund_inception_date", sa.Float(), nullable=True),
        sa.Column("legal_type", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column(
            "long_business_summary", sqlmodel.sql.sqltypes.AutoString(), nullable=True
        ),
        sa.Column("long_name", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("nav_price", sa.Float(), nullable=True),
        sa.Column("quote_type", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("short_name", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("three_year_average_return", sa.Float(), nullable=True),
        sa.Column("trailing_annual_dividend_rate", sa.Float(), nullable=True),
        sa.Column("trailing_annual_dividend_yield", sa.Float(), nullable=True),
        sa.Column("trailing_pe", sa.Float(), nullable=True),
        sa.Column("yield_", sa.Float(), nullable=True),
        sa.Column("ytd_return", sa.Float(), nullable=True),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sqlite_autoincrement=True,
    )
    with op.batch_alter_table("etf", schema=None) as batch_op:
        batch_op.create_index(batch_op.f("ix_etf_source"), ["source"], unique=False)
        batch_op.create_index(batch_op.f("ix_etf_symbol"), ["symbol"], unique=False)

    op.create_table(
        "financialmetrics",
        sa.Column("symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("exchange", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("source", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("date", sa.DateTime(), nullable=False),
        sa.Column("created_at", sa.Date(), nullable=False),
        sa.Column("ebitda", sa.Float(), nullable=True),
        sa.Column("net_income", sa.Float(), nullable=True),
        sa.Column("pe_ratio", sa.Float(), nullable=True),
        sa.Column("market_capitalization", sa.Float(), nullable=True),
        sa.Column("basic_eps", sa.Float(), nullable=True),
        sa.Column("diluted_eps", sa.Float(), nullable=True),
        sa.Column("total_revenue", sa.Float(), nullable=True),
        sa.Column("operating_revenue", sa.Float(), nullable=True),
        sa.Column("gross_profit", sa.Float(), nullable=True),
        sa.Column("total_expenses", sa.Float(), nullable=True),
        sa.Column("operating_income", sa.Float(), nullable=True),
        sa.Column("profit_margin", sa.Float(), nullable=True),
        sa.Column("cost_of_revenue", sa.Float(), nullable=True),
        sa.Column("tax_provision", sa.Float(), nullable=True),
        sa.Column("tax_rate", sa.Float(), nullable=True),
        sa.PrimaryKeyConstraint("symbol", "source", "date"),
    )
    with op.batch_alter_table("financialmetrics", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_financialmetrics_date"), ["date"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_financialmetrics_source"), ["source"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_financialmetrics_symbol"), ["symbol"], unique=False
        )

    op.create_table(
        "price",
        sa.Column("exchange", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("source", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("date", sa.DateTime(), nullable=False),
        sa.Column("created_at", sa.Date(), nullable=False),
        sa.Column("open", sa.Float(), nullable=False),
        sa.Column("high", sa.Float(), nullable=False),
        sa.Column("low", sa.Float(), nullable=False),
        sa.Column("close", sa.Float(), nullable=False),
        sa.Column("volume", sa.Float(), nullable=False),
        sa.Column("dividends", sa.Float(), nullable=True),
        sa.Column("stock_splits", sa.Float(), nullable=True),
        sa.PrimaryKeyConstraint("symbol", "source", "date"),
    )
    with op.batch_alter_table("price", schema=None) as batch_op:
        batch_op.create_index(batch_op.f("ix_price_date"), ["date"], unique=False)
        batch_op.create_index(batch_op.f("ix_price_source"), ["source"], unique=False)
        batch_op.create_index(batch_op.f("ix_price_symbol"), ["symbol"], unique=False)

    op.create_table(
        "sources",
        sa.Column("source", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.PrimaryKeyConstraint("source"),
    )
    with op.batch_alter_table("sources", schema=None) as batch_op:
        batch_op.create_index(batch_op.f("ix_sources_source"), ["source"], unique=False)

    op.create_table(
        "tracker",
        sa.Column("financials", sa.Boolean(), nullable=False),
        sa.Column("price", sa.Boolean(), nullable=False),
        sa.Column("exchange", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("source", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("price_date", sa.Date(), nullable=True),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sqlite_autoincrement=True,
    )
    with op.batch_alter_table("tracker", schema=None) as batch_op:
        batch_op.create_index(batch_op.f("ix_tracker_source"), ["source"], unique=False)
        batch_op.create_index(batch_op.f("ix_tracker_symbol"), ["symbol"], unique=False)

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("tracker", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_tracker_symbol"))
        batch_op.drop_index(batch_op.f("ix_tracker_source"))

    op.drop_table("tracker")
    with op.batch_alter_table("sources", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_sources_source"))

    op.drop_table("sources")
    with op.batch_alter_table("price", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_price_symbol"))
        batch_op.drop_index(batch_op.f("ix_price_source"))
        batch_op.drop_index(batch_op.f("ix_price_date"))

    op.drop_table("price")
    with op.batch_alter_table("financialmetrics", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_financialmetrics_symbol"))
        batch_op.drop_index(batch_op.f("ix_financialmetrics_source"))
        batch_op.drop_index(batch_op.f("ix_financialmetrics_date"))

    op.drop_table("financialmetrics")
    with op.batch_alter_table("etf", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_etf_symbol"))
        batch_op.drop_index(batch_op.f("ix_etf_source"))

    op.drop_table("etf")
    with op.batch_alter_table("equity", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_equity_symbol"))
        batch_op.drop_index(batch_op.f("ix_equity_source"))
        batch_op.drop_index(batch_op.f("ix_equity_country"))

    op.drop_table("equity")
    with op.batch_alter_table("earningsdate", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_earningsdate_symbol"))
        batch_op.drop_index(batch_op.f("ix_earningsdate_source"))
        batch_op.drop_index(batch_op.f("ix_earningsdate_date"))

    op.drop_table("earningsdate")
    with op.batch_alter_table("currency", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_currency_symbol"))
        batch_op.drop_index(batch_op.f("ix_currency_source"))
        batch_op.drop_index(batch_op.f("ix_currency_base_currency"))

    op.drop_table("currency")
    with op.batch_alter_table("crypto", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_crypto_symbol"))
        batch_op.drop_index(batch_op.f("ix_crypto_source"))
        batch_op.drop_index(batch_op.f("ix_crypto_cryptocurrency"))

    op.drop_table("crypto")
    with op.batch_alter_table("cashflow", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_cashflow_symbol"))
        batch_op.drop_index(batch_op.f("ix_cashflow_source"))
        batch_op.drop_index(batch_op.f("ix_cashflow_date"))

    op.drop_table("cashflow")
    with op.batch_alter_table("balancesheet", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_balancesheet_symbol"))
        batch_op.drop_index(batch_op.f("ix_balancesheet_source"))
        batch_op.drop_index(batch_op.f("ix_balancesheet_date"))

    op.drop_table("balancesheet")
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_analysis_symbol"))
        batch_op.drop_index(batch_op.f("ix_analysis_source"))

    op.drop_table("analysis")
    # ### end Alembic commands ###
