"""prices

Revision ID: c32ee728030b
Revises: cdd35bc43771
Create Date: 2025-04-08 21:35:54.813418

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = "c32ee728030b"
down_revision: Union[str, None] = "cdd35bc43771"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("year_to_date_max_growth", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("last_week_max_growth", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("last_month_max_growth", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("last_year_max_growth", sa.Float(), nullable=True)
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.drop_column("last_year_max_growth")
        batch_op.drop_column("last_month_max_growth")
        batch_op.drop_column("last_week_max_growth")
        batch_op.drop_column("year_to_date_max_growth")

    # ### end Alembic commands ###
