# Generated by Django 4.0.2 on 2022-02-27 02:16

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="BuildLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("logs", models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name="BuildModel",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("machine", models.CharField(db_index=True, max_length=255)),
                ("number", models.PositiveIntegerField()),
                ("submitted", models.DateTimeField()),
                ("completed", models.DateTimeField(null=True)),
                ("built", models.DateTimeField(null=True)),
            ],
            options={"verbose_name": "Build", "verbose_name_plural": "Builds"},
        ),
        migrations.CreateModel(
            name="KeptBuild",
            fields=[
                (
                    "build_model",
                    models.OneToOneField(
                        db_column="id",
                        on_delete=django.db.models.deletion.CASCADE,
                        primary_key=True,
                        serialize=False,
                        to="gentoo_build_publisher.buildmodel",
                    ),
                )
            ],
        ),
        migrations.CreateModel(
            name="BuildNote",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("note", models.TextField()),
                (
                    "build_model",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="gentoo_build_publisher.buildmodel",
                    ),
                ),
            ],
        ),
        migrations.AddIndex(
            model_name="buildmodel",
            index=models.Index(
                fields=["machine"], name="gentoo_buil_machine_a71829_idx"
            ),
        ),
        migrations.AddConstraint(
            model_name="buildmodel",
            constraint=models.UniqueConstraint(
                fields=("machine", "number"), name="unique_build"
            ),
        ),
        migrations.AddField(
            model_name="buildlog",
            name="build_model",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                to="gentoo_build_publisher.buildmodel",
            ),
        ),
    ]
