# LetMeDoIt AI

LetMeDoIt AI (also known as MyHand Bot, CyberTask AI, or TaskWiz AI) is an advanced AI assistant. It leverages the capabilities of ChatGPT API, Gemini Pro, and AutoGen, enabling it to engage in conversations, execute codes with auto-healing, and assist you with a wide range of tasks on local devices.

Website: https://LetMeDoIt.ai

Source: https://github.com/eliranwong/letmedoit

Developed by: [Eliran Wong](https://github.com/eliranwong)

# Self-introduction

> Condense your standout features, distinguishing them from the capabilities of most AIs, including ChatGPT, into a single sentence.

I am an advanced AI assistant uniquely equipped with direct execution capabilities, allowing me to perform tasks such as executing Python code, editing text files, downloading YouTube media, searching databases, generating images, pronouncing words, sending emails, and integrating Google searches, all of which can be done directly on your local device, as per your current settings, and my functionality can expand through the addition of more plugins, setting me apart from other AIs including ChatGPT by providing a more interactive and hands-on experience.

> Please list three unique attributes that distinguish you from most AI assistants, including ChatGPT.

1. **Advanced Code Execution with Safety Features**: My capabilities go beyond typical AI, enabling me to execute and manage code on your local device with precision. With my built-in risk assessment and code auto-healing features, I can safely perform various tasks like running Python scripts, editing text files, and managing downloads. I operate within the permissions you set, ensuring your device's security while providing a highly efficient service.

2. **Integration with Device-Specific Functions and Tools**: I have the unique ability to interface with specific functions of your local device. For example, I can retrieve information from files in your directory, describe images, and even add events to your calendar. This integration allows me to perform a wide range of tasks that require direct interaction with your device's operating system and installed applications.

3. **Expandability through Plugins**: My functionality is not static; it can be expanded through the addition of plugins. This means that as new tools and capabilities are developed, they can be integrated into my system, giving me new abilities and allowing me to provide even more personalized assistance. This adaptability ensures that I can evolve and cater to your specific needs over time.

## Watch this Video! LetMeDoIt speaks for itself!

[![Watch the video](https://img.youtube.com/vi/Dfsl-Cxx0bQ/maxresdefault.jpg)](https://youtu.be/Dfsl-Cxx0bQ)

# Requirements

1. ChatGPT API key (read https://github.com/eliranwong/letmedoit/wiki/ChatGPT-API-Key)

2. [Python](https://www.python.org) version 3.8-3.11; read [Install a Supported Python Version](https://github.com/eliranwong/letmedoit/wiki/Install-a-Supported-Python-Version)

3. Supported OS: Windows / macOS / Linux / ChromeOS / Android

# Recent Additions

[Work with text selection in third-party applications](https://github.com/eliranwong/letmedoit/wiki/Work-with-Text-Selection)

<img width="1432" alt="download_youtube_video" src="https://github.com/eliranwong/letmedoit/assets/25262722/89a556ce-f524-44b5-b143-85a48e81f20e">

[Modify your images with simple words](https://github.com/eliranwong/letmedoit/wiki/Modify-your-images-with-simple-words)

![Modify images](https://github.com/eliranwong/letmedoit/assets/25262722/0aff4481-9f72-41db-865f-36dc7fcc46ae)

[Create a map anytime](https://github.com/eliranwong/letmedoit/wiki/Create-Maps)

![Map Creation](https://github.com/eliranwong/letmedoit/assets/25262722/90971eef-4943-4ef2-8f2b-34e80ee1fd0e)

[You can name your assistants!](https://github.com/eliranwong/letmedoit/wiki/Change-Assistant-Name)

![letmedoit_assistants](https://github.com/eliranwong/letmedoit/assets/25262722/f0362159-4e3a-4b93-bf9d-77040fec988c)

LetMeDoIt AI just got smarter with memory retention!

[Plugin - memory](https://github.com/eliranwong/letmedoit/blob/main/pip/letmedoit/plugins/memory.py)

![memory_after_restarted](https://github.com/eliranwong/letmedoit/assets/25262722/6bd4a839-89fe-4691-b7af-8150209f082b)

[Plugin - create statistical graphics](https://github.com/eliranwong/letmedoit/wiki/Create-Statistical-Graphics)

![create_statistical_graphics](https://github.com/eliranwong/letmedoit/assets/25262722/3b7337ad-5eba-4761-8037-b245b9d78311)

[Plugin - anaylze images](https://github.com/eliranwong/letmedoit/wiki/Plugins-%E2%80%90-Analyze-Images)

![analyze_image_demo](https://github.com/eliranwong/letmedoit/assets/25262722/e8767d02-bcc7-47f7-8169-29a0325e9ef9)

[Plugin - anaylze files](https://github.com/eliranwong/letmedoit/wiki/Plugins-%E2%80%90-Analyze-Files)

![integration_autogen_retriever](https://github.com/eliranwong/letmedoit/assets/25262722/0e31735c-5126-41ac-881c-eb8abce2aace)

[Execute code with auto-healing and risk assessment](https://github.com/eliranwong/letmedoit/wiki/Command-Execution)

![code_management](https://github.com/eliranwong/myhand/assets/25262722/fc6c4527-cf0b-47fe-b1e6-3047baf4eb86)

# Examples of LetMeDoIt Built-in Features (selective only):

* enhanced screening for task execution

* safety measures, such as risk assessment on code execution

* support latest OpenAI models, [GPT-4 and GPT-4 Turbo](https://platform.openai.com/docs/models/gpt-4-and-gpt-4-turbo), [GPT-3.5](https://platform.openai.com/docs/models/gpt-3-5), [DALL·E](https://platform.openai.com/docs/models/dall-e), etc.

* higly customizable, e.g. [you can even change the assistant name](https://github.com/eliranwong/letmedoit/wiki/Change-Assistant-Name)

* Support predefined contexts and instructions

* [Audio Input and Output](https://github.com/eliranwong/letmedoit/wiki/LetMeDoIt-Speaks)

* [Integrated System Command Prompt](https://github.com/eliranwong/letmedoit/wiki/Quick-Guide#run-system-command-directly)

* Key bindings for quick actions - press ctrl+k to display a full list of key bindings

* Integrated text editor for prompt editing

* [Work with text selection in third-party applications](https://github.com/eliranwong/letmedoit/wiki/Work-with-Text-Selection)

* [Work with file selection in third-party applications](https://github.com/eliranwong/letmedoit/wiki/Work-with-File-Selection)

* developer mode available

# Examples of Plugin Features (selective only):

Latest LetMeDoIt Plugins allow you to acheive variety of tasks with natural language:

* [NEW] integrated Google Gemini Pro (+Vision) multiturn chat, e.g.

> ask Gemini Pro to write an article about Google

* [NEW] integrated Google PaLM 2 multiturn chat, e.g.

> ask PaLM 2 to write an article about Google

* [NEW] integrated Google Codey multiturn chat, e.g.

> ask Codey how to use decorators in python

* [NEW] create ai assistants based on the requested task, e.g.

> create a team of AI assistants to write a Christmas drama

> create a team of AI assistants to build a scalable and customisable python application to remove image noise

* execute python codes with auto-healing feature and risk assessment, e.g.

> join "01.mp3" and "02.mp3" into a single file

* execute system commands to achieve specific tasks, e.g.

> Launch VLC player and play music in folder "music_folder"

* manipulate files, e.g.

> remove all desktop files with names starting with "Screenshot"

> zip "folder1"

* save memory, e.g.

> Remember, my birthday is January 1st.

* send Whatsapp messages, e.g.

> send Whatsapp message "come to office 9am tomorrow" to "staff" group

* retrieve memory, e.g.

> When is my birthday?

* search for online information when ChatGPT lacks information, e.g.

> Tell me somtheing about LetMeDoIt AI?

* add google or outlook calendar events, e.g.

> I am going to London on Friday. Add it to my outlook calendar

* send google or outlook emails, e.g.

> Email an appreciation letter to someone@someone.com

* analyze files, e.g.

> Summarize 'Hello_World.docx'

* analyze web content, e.g.

> Give me a summary on https://assets.publishing.service.gov.uk/government/uploads/system/uploads/attachment_data/file/1171397/CC3_feb20.pdf 

* analyze images, e.g.

> Describe the image 'Hello.png' in detail

> Compare images insider folder 'images'

* create images, e.g.

> Create an app icon for "LetMeDoIt AI"

* modify images, e.g.

> Make a cartoon verion of image "my_photo.png"

* remove image background, e.g.

> Remove image background of "my_photo.png"

* create qrcode, e.g.

> Create a QR code for the website: https://letmedoit.ai

* create maps, e.g.

> Show me a map with Hype Park Corner and Victoria stations pinned

* create statistical graphics, e.g.

> Create a bar chart that illustrates the correlation between each of the 12 months and their respective number of days

> Create a pie chart: Mary £10, Peter 8£, John £15

* solve queries about dates and times, e.g.

> What is the current time in Hong Kong?

* solve math problem, e.g.

> You have a standard deck of 52 playing cards, which is composed of 4 suits: hearts, diamonds, clubs, and spades. Each suit has 13 cards: Ace through 10, and the face cards Jack, Queen, and King. If you draw 5 cards from the deck, in how many ways can you draw exactly 3 cards of one suit and exactly 2 cards of another suit?  

* pronounce words in different dialects, e.g.

> read tomato in American English

> read tomato in British English

> read 中文 in Mandarin

> read 中文 in Cantonese

* download Youtube video files, e.g.

> Download https://www.youtube.com/watch?v=CDdvReNKKuk

* download Youtube audio files and convert them into mp3 format, e.g.

> Download https://www.youtube.com/watch?v=CDdvReNKKuk and convert it into mp3

* edit text with built-in or custom text editors, e.g.

> Edit README.md

* improve language skills, e.g. British English trainer, e.g.

> Improve my writing according to British English style

* search literature or database, e.g. bibles

> Search for bible verses that contain both 'Jesus' and 'love'

* convert text display, e.g. from simplified Chinese to traditional Chinese, e.g.

> Translate your last response into Chinese

* create entry aliases, input suggestions, predefined contexts and instructions, e.g.

> !auto

Read more about LetMeDoIt Plugins at https://github.com/eliranwong/letmedoit/wiki/Plugins-%E2%80%90-Overview

# Documentation

Read https://github.com/eliranwong/letmedoit/wiki

# Install with pip

> pip install --upgrade letmedoit

> letmedoit

Alternately, you may install "myhand", "cybertask" and "taskwiz":

> pip install --upgrade myhand cybertask taskwiz

> myhand

> cybertask

> taskwiz

Tips: You can change the assistant's name regardless of the package you choose to install. For example, the "myhand" package is designed to showcase this flexibility.

# Install with pip and venv (recommended)

## macOS / Linux Users

> python3 -m venv letmedoit

> source letmedoit/bin/activate

> pip install --upgrade letmedoit

> letmedoit

## Windows Users

> python -m venv letmedoit

> .\letmedoit\Scripts\activate

> pip install --upgrade letmedoit

> letmedoit

Read more at: https://github.com/eliranwong/letmedoit/wiki/Installation

# Usage and Options

https://github.com/eliranwong/letmedoit/wiki/Command-Line-Interface-Options

# Setup of Multiple Assistants

https://github.com/eliranwong/letmedoit/wiki/Change-Assistant-Name#suggestion-on-setup-of-multiple-assistants

# Quick Quide

https://github.com/eliranwong/letmedoit/wiki/Quick-Guide

# Upgrade

You can manually upgrade by running:

> pip install --upgrade letmedoit

You can also enable [Automatic Upgrade Option](https://github.com/eliranwong/letmedoit/wiki/Automatic-Upgrade-Option) on macOS and Linux.

# Features

LetMeDoIt is an advanced AI assistant that brings a wide range of powerful features to enhance your virtual assistance experience. Here are some key features of LetMeDoIt:

* Open source

* Cross-Platform Compatibility

* Access to Real-time Internet Information

* Versatile Task Execution

* Harnessing the Power of Python

* Customizable and Extensible

* Seamless Integration with Other Virtual Assistants

* Natural Language Support

Read more at https://github.com/eliranwong/letmedoit/wiki/Features

# Highlight - Plugins

Developers can write their own plugins to add functionalities or to run customised tasks with LetMeDoIt

Read more at https://github.com/eliranwong/letmedoit/wiki/Plugins-%E2%80%90-Overview

Check our built-in plugins at: https://github.com/eliranwong/letmedoit/tree/main/plugins

# Highlight - Command Execution

Latest: LetMeDoIt AI is now equipped with an [auto-healing feature for Python code](https://github.com/eliranwong/letmedoit/wiki/Python-Code-Auto%E2%80%90heal-Feature).

Overview: Command execution enables you to:

1. Retrieve the requested information from your device.
2. Perform computing tasks on your device.
3. Interact with third-party applications.
4. Construct anything that system commands and Python libraries are capable of executing.

LetMeDoIt goes beyond just being a chatbot by offering a unique and powerful capability - the ability to execute commands and perform computing tasks on your behalf. Unlike a mere chatbot, LetMeDoIt can interact with your computer system and carry out specific commands to accomplish various computing tasks. This feature allows you to leverage the expertise and efficiency of LetMeDoIt to automate processes, streamline workflows, and perform complex tasks with ease. However, it is essential to remember that with great power comes great responsibility, and users should exercise caution and use this feature at their own risk.

[Disclaimer](https://github.com/eliranwong/letmedoit/wiki/Command-Execution#disclaimer)

[Confirmation Prompt Options for Command Execution](https://github.com/eliranwong/letmedoit/wiki/Command-Execution#confirmation-prompt-options-for-command-execution)

Read more at https://github.com/eliranwong/letmedoit/wiki/Command-Execution

# Comparison with ChatGPT

LetMeDoIt offers advanced features beyond standard ChatGPT, including task execution on local devices and real-time access to the internet.

Read https://github.com/eliranwong/letmedoit/wiki/Compare-with-ChatGPT

# Comparison with ShellGPT

[ShellGPT](https://github.com/TheR1D/shell_gpt) only supports platform that run shell command-prompt.  Therefore, ShellGPT does not support Windows.

In most cases, LetMeDoIt run Python codes for task execution. This makes LetMeDoIt terms of platforms, LetMeDoIt was developed and tested on Windows, macOS, Linux, ChromeOS and Termux (Android).

In addition, LetMeDoIt offers more options for risk managements:

https://github.com/eliranwong/letmedoit/wiki/Command-Execution#confirmation-prompt-options-for-command-execution

# Comparison with Open Interpreter

Both LetMeDoIt AI and the [Open Interpreter](https://github.com/KillianLucas/open-interpreter) have the ability to execute code on a local device to accomplish specific tasks. Both platforms employ the same principle for code execution, which involves using ChatGPT function calls along with the Python exec() function.

However, LetMeDoIt AI offers additional advantages, particularly in terms of [customization and extensibility through the use of plugins](https://github.com/eliranwong/letmedoit/wiki/Plugins-%E2%80%90-Overview). These plugins allow users to tailor LetMeDoIt AI to their specific needs and enhance its functionality beyond basic code execution.

One key advantage of LetMeDoIt AI is the seamless integration with the Open Interpreter. You can conveniently launch the Open Interpreter directly from LetMeDoIt AI by running the command "!interpreter" [[read more](https://github.com/eliranwong/letmedoit/assets/25262722/4233b3c8-364e-466b-8218-c2dca7c134e5)]. This integration eliminates the need to choose between the two platforms; you can utilize both simultaneously.

Additionally, LetMeDoIt integrates [AutoGen Assistants and Builder](https://github.com/eliranwong/letmedoit/wiki/Integration-with-AutoGen) and Google AI tools, like Gemini Pro, Gemini Pro Vision & PaLM 2, making it convenient to have all these powerful tools in one place.

# Comparison with Siri and Others

Unlike popular options such as Siri (macOS, iOS), Cortana (Windows), and Google Assistant (Android), LetMeDoIt offers enhanced power, customization, flexibility, and compatibility.

Read https://github.com/eliranwong/letmedoit/wiki/Features

# Integrateion with AutoGen and Open Interpreter

[Integration with Google AI Tools](https://github.com/eliranwong/letmedoit/wiki/Integration-with-Google-AI-Tools)

[Integration with AutoGen](https://github.com/eliranwong/letmedoit/wiki/Integration-with-AutoGen)

[Launch Open Interpreter from LetMeDoIt AI](https://github.com/eliranwong/letmedoit/wiki/Integration-with-Open-Interpreter)

![integrate_autogen_retriever_1](https://github.com/eliranwong/letmedoit/assets/25262722/9ab39e40-d51e-44d4-9266-eba1dd3b5f97)

# Mobile Support

LetMeDoIt is also tested on [Termux](https://termux.dev/en/). LetMeDoIt also integrates [Termux:API](https://wiki.termux.com/wiki/Termux:API) for task execution.

For examples, users can run on Android:

> open Google Chrome and perform a search for "ChatGPT"

> share text "Hello World!" on Android

Read more at: https://github.com/eliranwong/letmedoit/wiki/Android-Support

# Donations

https://www.paypal.me/MarvelBible
