
# Autogenerated by mlir-tblgen; don't manually edit.

from ._ods_common import _cext as _ods_cext
from ._ods_common import (
    equally_sized_accessor as _ods_equally_sized_accessor,
    get_default_loc_context as _ods_get_default_loc_context,
    get_op_result_or_op_results as _get_op_result_or_op_results,
    get_op_result_or_value as _get_op_result_or_value,
    get_op_results_or_values as _get_op_results_or_values,
    segmented_accessor as _ods_segmented_accessor,
)
_ods_ir = _ods_cext.ir

import builtins
from typing import Sequence as _Sequence, Union as _Union


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "sv"

@_ods_cext.register_operation(_Dialect)
class AliasOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.alias"

  _ODS_REGIONS = (0, True)

  def __init__(self, aliases, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(aliases))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def aliases(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def alias(aliases, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(AliasOp(aliases=aliases, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AlwaysCombOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.alwayscomb"

  _ODS_REGIONS = (1, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def body(self):
    return self.regions[0]

def alwayscomb(*, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(AlwaysCombOp(loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AlwaysFFOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.alwaysff"

  _ODS_REGIONS = (2, True)

  def __init__(self, clockEdge, clock, *, resetStyle=None, resetEdge=None, reset=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(clock))
    if reset is not None: operands.append(_get_op_result_or_value(reset))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["clockEdge"] = (clockEdge if (
    isinstance(clockEdge, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('EventControlAttr')) else
      _ods_ir.AttrBuilder.get('EventControlAttr')(clockEdge, context=_ods_context))
    if resetStyle is not None: attributes["resetStyle"] = (resetStyle if (
        isinstance(resetStyle, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('ResetTypeAttr')) else
          _ods_ir.AttrBuilder.get('ResetTypeAttr')(resetStyle, context=_ods_context))
    if resetEdge is not None: attributes["resetEdge"] = (resetEdge if (
        isinstance(resetEdge, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('EventControlAttr')) else
          _ods_ir.AttrBuilder.get('EventControlAttr')(resetEdge, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def clock(self):
    return self.operation.operands[0]

  @builtins.property
  def reset(self):
    return None if len(self.operation.operands) < 2 else self.operation.operands[1]

  @builtins.property
  def clockEdge(self):
    return self.operation.attributes["clockEdge"]

  @clockEdge.setter
  def clockEdge(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["clockEdge"] = value

  @builtins.property
  def resetStyle(self):
    return self.operation.attributes["resetStyle"]

  @resetStyle.setter
  def resetStyle(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["resetStyle"] = value

  @builtins.property
  def resetEdge(self):
    if "resetEdge" not in self.operation.attributes:
      return None
    return self.operation.attributes["resetEdge"]

  @resetEdge.setter
  def resetEdge(self, value):
    if value is not None:
      self.operation.attributes["resetEdge"] = value
    elif "resetEdge" in self.operation.attributes:
      del self.operation.attributes["resetEdge"]

  @resetEdge.deleter
  def resetEdge(self):
    del self.operation.attributes["resetEdge"]

  @builtins.property
  def bodyBlk(self):
    return self.regions[0]

  @builtins.property
  def resetBlk(self):
    return self.regions[1]

def alwaysff(clock_edge, clock, *, reset_style=None, reset_edge=None, reset=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(AlwaysFFOp(clockEdge=clock_edge, clock=clock, resetStyle=reset_style, resetEdge=reset_edge, reset=reset, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AlwaysOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.always"

  _ODS_REGIONS = (1, True)

  def __init__(self, events, clocks, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(clocks))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["events"] = (events if (
    isinstance(events, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('anonymous_542')) else
      _ods_ir.AttrBuilder.get('anonymous_542')(events, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def clocks(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def events(self):
    return self.operation.attributes["events"]

  @events.setter
  def events(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["events"] = value

  @builtins.property
  def body(self):
    return self.regions[0]

def always(events, clocks, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(AlwaysOp(events=events, clocks=clocks, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ArrayIndexInOutOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.array_index_inout"

  _ODS_REGIONS = (0, True)

  def __init__(self, input, index, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    operands.append(_get_op_result_or_value(index))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def index(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def array_index_inout(input, index, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ArrayIndexInOutOp(input=input, index=index, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AssertConcurrentOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.assert.concurrent"

  _ODS_REGIONS = (0, True)

  def __init__(self, event, clock, property, substitutions, *, label=None, message=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(clock))
    operands.append(_get_op_result_or_value(property))
    operands.extend(_get_op_results_or_values(substitutions))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["event"] = (event if (
    isinstance(event, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('EventControlAttr')) else
      _ods_ir.AttrBuilder.get('EventControlAttr')(event, context=_ods_context))
    if label is not None: attributes["label"] = (label if (
        isinstance(label, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(label, context=_ods_context))
    if message is not None: attributes["message"] = (message if (
        isinstance(message, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(message, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def clock(self):
    return self.operation.operands[0]

  @builtins.property
  def property(self):
    return self.operation.operands[1]

  @builtins.property
  def substitutions(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2:2 + _ods_variadic_group_length]

  @builtins.property
  def event(self):
    return self.operation.attributes["event"]

  @event.setter
  def event(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["event"] = value

  @builtins.property
  def label(self):
    if "label" not in self.operation.attributes:
      return None
    return self.operation.attributes["label"]

  @label.setter
  def label(self, value):
    if value is not None:
      self.operation.attributes["label"] = value
    elif "label" in self.operation.attributes:
      del self.operation.attributes["label"]

  @label.deleter
  def label(self):
    del self.operation.attributes["label"]

  @builtins.property
  def message(self):
    if "message" not in self.operation.attributes:
      return None
    return self.operation.attributes["message"]

  @message.setter
  def message(self, value):
    if value is not None:
      self.operation.attributes["message"] = value
    elif "message" in self.operation.attributes:
      del self.operation.attributes["message"]

  @message.deleter
  def message(self):
    del self.operation.attributes["message"]

def assert_concurrent(event, clock, property, substitutions, *, label=None, message=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(AssertConcurrentOp(event=event, clock=clock, property=property, substitutions=substitutions, label=label, message=message, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AssertOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.assert"

  _ODS_REGIONS = (0, True)

  def __init__(self, expression, defer, substitutions, *, label=None, message=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(expression))
    operands.extend(_get_op_results_or_values(substitutions))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["defer"] = (defer if (
    isinstance(defer, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DeferAssertAttr')) else
      _ods_ir.AttrBuilder.get('DeferAssertAttr')(defer, context=_ods_context))
    if label is not None: attributes["label"] = (label if (
        isinstance(label, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(label, context=_ods_context))
    if message is not None: attributes["message"] = (message if (
        isinstance(message, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(message, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def expression(self):
    return self.operation.operands[0]

  @builtins.property
  def substitutions(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def defer(self):
    return self.operation.attributes["defer"]

  @defer.setter
  def defer(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["defer"] = value

  @builtins.property
  def label(self):
    if "label" not in self.operation.attributes:
      return None
    return self.operation.attributes["label"]

  @label.setter
  def label(self, value):
    if value is not None:
      self.operation.attributes["label"] = value
    elif "label" in self.operation.attributes:
      del self.operation.attributes["label"]

  @label.deleter
  def label(self):
    del self.operation.attributes["label"]

  @builtins.property
  def message(self):
    if "message" not in self.operation.attributes:
      return None
    return self.operation.attributes["message"]

  @message.setter
  def message(self, value):
    if value is not None:
      self.operation.attributes["message"] = value
    elif "message" in self.operation.attributes:
      del self.operation.attributes["message"]

  @message.deleter
  def message(self):
    del self.operation.attributes["message"]

def assert_(expression, defer, substitutions, *, label=None, message=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(AssertOp(expression=expression, defer=defer, substitutions=substitutions, label=label, message=message, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AssertPropertyOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.assert_property"

  _ODS_OPERAND_SEGMENTS = [1,0,0,]

  _ODS_REGIONS = (0, True)

  def __init__(self, property, *, event=None, clock=None, disable=None, label=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(property))
    operands.append(_get_op_result_or_value(clock) if clock is not None else None)
    operands.append(_get_op_result_or_value(disable) if disable is not None else None)
    _ods_context = _ods_get_default_loc_context(loc)
    if event is not None: attributes["event"] = (event if (
        isinstance(event, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('EventControlAttr')) else
          _ods_ir.AttrBuilder.get('EventControlAttr')(event, context=_ods_context))
    if label is not None: attributes["label"] = (label if (
        isinstance(label, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(label, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def property(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def clock(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def disable(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def event(self):
    if "event" not in self.operation.attributes:
      return None
    return self.operation.attributes["event"]

  @event.setter
  def event(self, value):
    if value is not None:
      self.operation.attributes["event"] = value
    elif "event" in self.operation.attributes:
      del self.operation.attributes["event"]

  @event.deleter
  def event(self):
    del self.operation.attributes["event"]

  @builtins.property
  def label(self):
    if "label" not in self.operation.attributes:
      return None
    return self.operation.attributes["label"]

  @label.setter
  def label(self, value):
    if value is not None:
      self.operation.attributes["label"] = value
    elif "label" in self.operation.attributes:
      del self.operation.attributes["label"]

  @label.deleter
  def label(self):
    del self.operation.attributes["label"]

def assert_property(property, *, event=None, clock=None, disable=None, label=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(AssertPropertyOp(property=property, event=event, clock=clock, disable=disable, label=label, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AssignInterfaceSignalOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.interface.signal.assign"

  _ODS_REGIONS = (0, True)

  def __init__(self, iface, signalName, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(iface))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["signalName"] = (signalName if (
    isinstance(signalName, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
      _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(signalName, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def iface(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def signalName(self):
    return self.operation.attributes["signalName"]

  @signalName.setter
  def signalName(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["signalName"] = value

def interface_signal_assign(iface, signal_name, rhs, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(AssignInterfaceSignalOp(iface=iface, signalName=signal_name, rhs=rhs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AssignOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.assign"

  _ODS_REGIONS = (0, True)

  def __init__(self, dest, src, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(dest))
    operands.append(_get_op_result_or_value(src))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def dest(self):
    return self.operation.operands[0]

  @builtins.property
  def src(self):
    return self.operation.operands[1]

def assign(dest, src, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(AssignOp(dest=dest, src=src, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AssumeConcurrentOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.assume.concurrent"

  _ODS_REGIONS = (0, True)

  def __init__(self, event, clock, property, substitutions, *, label=None, message=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(clock))
    operands.append(_get_op_result_or_value(property))
    operands.extend(_get_op_results_or_values(substitutions))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["event"] = (event if (
    isinstance(event, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('EventControlAttr')) else
      _ods_ir.AttrBuilder.get('EventControlAttr')(event, context=_ods_context))
    if label is not None: attributes["label"] = (label if (
        isinstance(label, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(label, context=_ods_context))
    if message is not None: attributes["message"] = (message if (
        isinstance(message, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(message, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def clock(self):
    return self.operation.operands[0]

  @builtins.property
  def property(self):
    return self.operation.operands[1]

  @builtins.property
  def substitutions(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2:2 + _ods_variadic_group_length]

  @builtins.property
  def event(self):
    return self.operation.attributes["event"]

  @event.setter
  def event(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["event"] = value

  @builtins.property
  def label(self):
    if "label" not in self.operation.attributes:
      return None
    return self.operation.attributes["label"]

  @label.setter
  def label(self, value):
    if value is not None:
      self.operation.attributes["label"] = value
    elif "label" in self.operation.attributes:
      del self.operation.attributes["label"]

  @label.deleter
  def label(self):
    del self.operation.attributes["label"]

  @builtins.property
  def message(self):
    if "message" not in self.operation.attributes:
      return None
    return self.operation.attributes["message"]

  @message.setter
  def message(self, value):
    if value is not None:
      self.operation.attributes["message"] = value
    elif "message" in self.operation.attributes:
      del self.operation.attributes["message"]

  @message.deleter
  def message(self):
    del self.operation.attributes["message"]

def assume_concurrent(event, clock, property, substitutions, *, label=None, message=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(AssumeConcurrentOp(event=event, clock=clock, property=property, substitutions=substitutions, label=label, message=message, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AssumeOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.assume"

  _ODS_REGIONS = (0, True)

  def __init__(self, expression, defer, substitutions, *, label=None, message=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(expression))
    operands.extend(_get_op_results_or_values(substitutions))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["defer"] = (defer if (
    isinstance(defer, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DeferAssertAttr')) else
      _ods_ir.AttrBuilder.get('DeferAssertAttr')(defer, context=_ods_context))
    if label is not None: attributes["label"] = (label if (
        isinstance(label, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(label, context=_ods_context))
    if message is not None: attributes["message"] = (message if (
        isinstance(message, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(message, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def expression(self):
    return self.operation.operands[0]

  @builtins.property
  def substitutions(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def defer(self):
    return self.operation.attributes["defer"]

  @defer.setter
  def defer(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["defer"] = value

  @builtins.property
  def label(self):
    if "label" not in self.operation.attributes:
      return None
    return self.operation.attributes["label"]

  @label.setter
  def label(self, value):
    if value is not None:
      self.operation.attributes["label"] = value
    elif "label" in self.operation.attributes:
      del self.operation.attributes["label"]

  @label.deleter
  def label(self):
    del self.operation.attributes["label"]

  @builtins.property
  def message(self):
    if "message" not in self.operation.attributes:
      return None
    return self.operation.attributes["message"]

  @message.setter
  def message(self, value):
    if value is not None:
      self.operation.attributes["message"] = value
    elif "message" in self.operation.attributes:
      del self.operation.attributes["message"]

  @message.deleter
  def message(self):
    del self.operation.attributes["message"]

def assume(expression, defer, substitutions, *, label=None, message=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(AssumeOp(expression=expression, defer=defer, substitutions=substitutions, label=label, message=message, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class AssumePropertyOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.assume_property"

  _ODS_OPERAND_SEGMENTS = [1,0,0,]

  _ODS_REGIONS = (0, True)

  def __init__(self, property, *, event=None, clock=None, disable=None, label=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(property))
    operands.append(_get_op_result_or_value(clock) if clock is not None else None)
    operands.append(_get_op_result_or_value(disable) if disable is not None else None)
    _ods_context = _ods_get_default_loc_context(loc)
    if event is not None: attributes["event"] = (event if (
        isinstance(event, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('EventControlAttr')) else
          _ods_ir.AttrBuilder.get('EventControlAttr')(event, context=_ods_context))
    if label is not None: attributes["label"] = (label if (
        isinstance(label, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(label, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def property(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def clock(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def disable(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def event(self):
    if "event" not in self.operation.attributes:
      return None
    return self.operation.attributes["event"]

  @event.setter
  def event(self, value):
    if value is not None:
      self.operation.attributes["event"] = value
    elif "event" in self.operation.attributes:
      del self.operation.attributes["event"]

  @event.deleter
  def event(self):
    del self.operation.attributes["event"]

  @builtins.property
  def label(self):
    if "label" not in self.operation.attributes:
      return None
    return self.operation.attributes["label"]

  @label.setter
  def label(self, value):
    if value is not None:
      self.operation.attributes["label"] = value
    elif "label" in self.operation.attributes:
      del self.operation.attributes["label"]

  @label.deleter
  def label(self):
    del self.operation.attributes["label"]

def assume_property(property, *, event=None, clock=None, disable=None, label=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(AssumePropertyOp(property=property, event=event, clock=clock, disable=disable, label=label, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class BPAssignOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.bpassign"

  _ODS_REGIONS = (0, True)

  def __init__(self, dest, src, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(dest))
    operands.append(_get_op_result_or_value(src))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def dest(self):
    return self.operation.operands[0]

  @builtins.property
  def src(self):
    return self.operation.operands[1]

def bpassign(dest, src, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(BPAssignOp(dest=dest, src=src, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class BindInterfaceOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.bind.interface"

  _ODS_REGIONS = (0, True)

  def __init__(self, instance, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["instance"] = (instance if (
    isinstance(instance, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('InnerRefAttr')) else
      _ods_ir.AttrBuilder.get('InnerRefAttr')(instance, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def instance(self):
    return self.operation.attributes["instance"]

  @instance.setter
  def instance(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["instance"] = value

def bind_interface(instance, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(BindInterfaceOp(instance=instance, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class BindOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.bind"

  _ODS_REGIONS = (0, True)

  def __init__(self, instance, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["instance"] = (instance if (
    isinstance(instance, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('InnerRefAttr')) else
      _ods_ir.AttrBuilder.get('InnerRefAttr')(instance, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def instance(self):
    return self.operation.attributes["instance"]

  @instance.setter
  def instance(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["instance"] = value

def bind(instance, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(BindOp(instance=instance, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CaseOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.case"

  _ODS_REGIONS = (0, False)

  def __init__(self, cond, casePatterns, num_caseRegions, *, caseStyle=None, validationQualifier=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(cond))
    _ods_context = _ods_get_default_loc_context(loc)
    if caseStyle is not None: attributes["caseStyle"] = (caseStyle if (
        isinstance(caseStyle, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('CaseStmtTypeAttr')) else
          _ods_ir.AttrBuilder.get('CaseStmtTypeAttr')(caseStyle, context=_ods_context))
    attributes["casePatterns"] = (casePatterns if (
    isinstance(casePatterns, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('ArrayAttr')) else
      _ods_ir.AttrBuilder.get('ArrayAttr')(casePatterns, context=_ods_context))
    if validationQualifier is not None: attributes["validationQualifier"] = (validationQualifier if (
        isinstance(validationQualifier, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('ValidationQualifierTypeAttr')) else
          _ods_ir.AttrBuilder.get('ValidationQualifierTypeAttr')(validationQualifier, context=_ods_context))
    _ods_successors = None
    regions = 0 + num_caseRegions
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def cond(self):
    return self.operation.operands[0]

  @builtins.property
  def caseStyle(self):
    return self.operation.attributes["caseStyle"]

  @caseStyle.setter
  def caseStyle(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["caseStyle"] = value

  @builtins.property
  def casePatterns(self):
    return self.operation.attributes["casePatterns"]

  @casePatterns.setter
  def casePatterns(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["casePatterns"] = value

  @builtins.property
  def validationQualifier(self):
    return self.operation.attributes["validationQualifier"]

  @validationQualifier.setter
  def validationQualifier(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["validationQualifier"] = value

  @builtins.property
  def caseRegions(self):
    return self.regions[0:]

def case(cond, case_patterns, num_case_regions, *, case_style=None, validation_qualifier=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(CaseOp(cond=cond, casePatterns=case_patterns, num_caseRegions=num_case_regions, caseStyle=case_style, validationQualifier=validation_qualifier, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ConstantStrOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.constantStr"

  _ODS_REGIONS = (0, True)

  def __init__(self, str, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["str"] = (str if (
    isinstance(str, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(str, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def str(self):
    return self.operation.attributes["str"]

  @str.setter
  def str(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["str"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def constantStr(str, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ConstantStrOp(str=str, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ConstantXOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.constantX"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def result(self):
    return self.operation.results[0]

def constantX(result, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ConstantXOp(result=result, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ConstantZOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.constantZ"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def result(self):
    return self.operation.results[0]

def constantZ(result, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ConstantZOp(result=result, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CoverConcurrentOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.cover.concurrent"

  _ODS_REGIONS = (0, True)

  def __init__(self, event, clock, property, substitutions, *, label=None, message=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(clock))
    operands.append(_get_op_result_or_value(property))
    operands.extend(_get_op_results_or_values(substitutions))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["event"] = (event if (
    isinstance(event, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('EventControlAttr')) else
      _ods_ir.AttrBuilder.get('EventControlAttr')(event, context=_ods_context))
    if label is not None: attributes["label"] = (label if (
        isinstance(label, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(label, context=_ods_context))
    if message is not None: attributes["message"] = (message if (
        isinstance(message, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(message, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def clock(self):
    return self.operation.operands[0]

  @builtins.property
  def property(self):
    return self.operation.operands[1]

  @builtins.property
  def substitutions(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2:2 + _ods_variadic_group_length]

  @builtins.property
  def event(self):
    return self.operation.attributes["event"]

  @event.setter
  def event(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["event"] = value

  @builtins.property
  def label(self):
    if "label" not in self.operation.attributes:
      return None
    return self.operation.attributes["label"]

  @label.setter
  def label(self, value):
    if value is not None:
      self.operation.attributes["label"] = value
    elif "label" in self.operation.attributes:
      del self.operation.attributes["label"]

  @label.deleter
  def label(self):
    del self.operation.attributes["label"]

  @builtins.property
  def message(self):
    if "message" not in self.operation.attributes:
      return None
    return self.operation.attributes["message"]

  @message.setter
  def message(self, value):
    if value is not None:
      self.operation.attributes["message"] = value
    elif "message" in self.operation.attributes:
      del self.operation.attributes["message"]

  @message.deleter
  def message(self):
    del self.operation.attributes["message"]

def cover_concurrent(event, clock, property, substitutions, *, label=None, message=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(CoverConcurrentOp(event=event, clock=clock, property=property, substitutions=substitutions, label=label, message=message, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CoverOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.cover"

  _ODS_REGIONS = (0, True)

  def __init__(self, expression, defer, substitutions, *, label=None, message=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(expression))
    operands.extend(_get_op_results_or_values(substitutions))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["defer"] = (defer if (
    isinstance(defer, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DeferAssertAttr')) else
      _ods_ir.AttrBuilder.get('DeferAssertAttr')(defer, context=_ods_context))
    if label is not None: attributes["label"] = (label if (
        isinstance(label, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(label, context=_ods_context))
    if message is not None: attributes["message"] = (message if (
        isinstance(message, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(message, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def expression(self):
    return self.operation.operands[0]

  @builtins.property
  def substitutions(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def defer(self):
    return self.operation.attributes["defer"]

  @defer.setter
  def defer(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["defer"] = value

  @builtins.property
  def label(self):
    if "label" not in self.operation.attributes:
      return None
    return self.operation.attributes["label"]

  @label.setter
  def label(self, value):
    if value is not None:
      self.operation.attributes["label"] = value
    elif "label" in self.operation.attributes:
      del self.operation.attributes["label"]

  @label.deleter
  def label(self):
    del self.operation.attributes["label"]

  @builtins.property
  def message(self):
    if "message" not in self.operation.attributes:
      return None
    return self.operation.attributes["message"]

  @message.setter
  def message(self, value):
    if value is not None:
      self.operation.attributes["message"] = value
    elif "message" in self.operation.attributes:
      del self.operation.attributes["message"]

  @message.deleter
  def message(self):
    del self.operation.attributes["message"]

def cover(expression, defer, substitutions, *, label=None, message=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(CoverOp(expression=expression, defer=defer, substitutions=substitutions, label=label, message=message, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class CoverPropertyOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.cover_property"

  _ODS_OPERAND_SEGMENTS = [1,0,0,]

  _ODS_REGIONS = (0, True)

  def __init__(self, property, *, event=None, clock=None, disable=None, label=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(property))
    operands.append(_get_op_result_or_value(clock) if clock is not None else None)
    operands.append(_get_op_result_or_value(disable) if disable is not None else None)
    _ods_context = _ods_get_default_loc_context(loc)
    if event is not None: attributes["event"] = (event if (
        isinstance(event, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('EventControlAttr')) else
          _ods_ir.AttrBuilder.get('EventControlAttr')(event, context=_ods_context))
    if label is not None: attributes["label"] = (label if (
        isinstance(label, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(label, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def property(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def clock(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def disable(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def event(self):
    if "event" not in self.operation.attributes:
      return None
    return self.operation.attributes["event"]

  @event.setter
  def event(self, value):
    if value is not None:
      self.operation.attributes["event"] = value
    elif "event" in self.operation.attributes:
      del self.operation.attributes["event"]

  @event.deleter
  def event(self):
    del self.operation.attributes["event"]

  @builtins.property
  def label(self):
    if "label" not in self.operation.attributes:
      return None
    return self.operation.attributes["label"]

  @label.setter
  def label(self, value):
    if value is not None:
      self.operation.attributes["label"] = value
    elif "label" in self.operation.attributes:
      del self.operation.attributes["label"]

  @label.deleter
  def label(self):
    del self.operation.attributes["label"]

def cover_property(property, *, event=None, clock=None, disable=None, label=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(CoverPropertyOp(property=property, event=event, clock=clock, disable=disable, label=label, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class DepositOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.nonstandard.deposit"

  _ODS_REGIONS = (0, True)

  def __init__(self, dest, src, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(dest))
    operands.append(_get_op_result_or_value(src))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def dest(self):
    return self.operation.operands[0]

  @builtins.property
  def src(self):
    return self.operation.operands[1]

def nonstandard_deposit(dest, src, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(DepositOp(dest=dest, src=src, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ErrorOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.error"

  _ODS_REGIONS = (0, True)

  def __init__(self, substitutions, *, message=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(substitutions))
    _ods_context = _ods_get_default_loc_context(loc)
    if message is not None: attributes["message"] = (message if (
        isinstance(message, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(message, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def substitutions(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def message(self):
    if "message" not in self.operation.attributes:
      return None
    return self.operation.attributes["message"]

  @message.setter
  def message(self, value):
    if value is not None:
      self.operation.attributes["message"] = value
    elif "message" in self.operation.attributes:
      del self.operation.attributes["message"]

  @message.deleter
  def message(self):
    del self.operation.attributes["message"]

def error(substitutions, *, message=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ErrorOp(substitutions=substitutions, message=message, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ExitOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.exit"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

def exit(*, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ExitOp(loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FWriteOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.fwrite"

  _ODS_REGIONS = (0, True)

  def __init__(self, fd, format_string, substitutions, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(fd))
    operands.extend(_get_op_results_or_values(substitutions))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["format_string"] = (format_string if (
    isinstance(format_string, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(format_string, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def fd(self):
    return self.operation.operands[0]

  @builtins.property
  def substitutions(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def format_string(self):
    return self.operation.attributes["format_string"]

  @format_string.setter
  def format_string(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["format_string"] = value

def fwrite(fd, format_string, substitutions, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(FWriteOp(fd=fd, format_string=format_string, substitutions=substitutions, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FatalOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.fatal"

  _ODS_REGIONS = (0, True)

  def __init__(self, substitutions, *, verbosity=None, message=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(substitutions))
    _ods_context = _ods_get_default_loc_context(loc)
    if verbosity is not None: attributes["verbosity"] = (verbosity if (
        isinstance(verbosity, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('VerbosityIntAttr')) else
          _ods_ir.AttrBuilder.get('VerbosityIntAttr')(verbosity, context=_ods_context))
    if message is not None: attributes["message"] = (message if (
        isinstance(message, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(message, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def substitutions(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def verbosity(self):
    return self.operation.attributes["verbosity"]

  @verbosity.setter
  def verbosity(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["verbosity"] = value

  @builtins.property
  def message(self):
    if "message" not in self.operation.attributes:
      return None
    return self.operation.attributes["message"]

  @message.setter
  def message(self, value):
    if value is not None:
      self.operation.attributes["message"] = value
    elif "message" in self.operation.attributes:
      del self.operation.attributes["message"]

  @message.deleter
  def message(self):
    del self.operation.attributes["message"]

def fatal(substitutions, *, verbosity=None, message=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(FatalOp(substitutions=substitutions, verbosity=verbosity, message=message, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FinishOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.finish"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, verbosity=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    if verbosity is not None: attributes["verbosity"] = (verbosity if (
        isinstance(verbosity, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('VerbosityIntAttr')) else
          _ods_ir.AttrBuilder.get('VerbosityIntAttr')(verbosity, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def verbosity(self):
    return self.operation.attributes["verbosity"]

  @verbosity.setter
  def verbosity(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["verbosity"] = value

def finish(*, verbosity=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(FinishOp(verbosity=verbosity, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ForOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.for"

  _ODS_REGIONS = (1, True)

  def __init__(self, lowerBound, upperBound, step, *, inductionVarName=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lowerBound))
    operands.append(_get_op_result_or_value(upperBound))
    operands.append(_get_op_result_or_value(step))
    _ods_context = _ods_get_default_loc_context(loc)
    if inductionVarName is not None: attributes["inductionVarName"] = (inductionVarName if (
        isinstance(inductionVarName, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(inductionVarName, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lowerBound(self):
    return self.operation.operands[0]

  @builtins.property
  def upperBound(self):
    return self.operation.operands[1]

  @builtins.property
  def step(self):
    return self.operation.operands[2]

  @builtins.property
  def inductionVarName(self):
    return self.operation.attributes["inductionVarName"]

  @inductionVarName.setter
  def inductionVarName(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["inductionVarName"] = value

  @builtins.property
  def body(self):
    return self.regions[0]

def for_(lower_bound, upper_bound, step, *, induction_var_name=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ForOp(lowerBound=lower_bound, upperBound=upper_bound, step=step, inductionVarName=induction_var_name, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ForceOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.force"

  _ODS_REGIONS = (0, True)

  def __init__(self, dest, src, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(dest))
    operands.append(_get_op_result_or_value(src))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def dest(self):
    return self.operation.operands[0]

  @builtins.property
  def src(self):
    return self.operation.operands[1]

def force(dest, src, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ForceOp(dest=dest, src=src, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FuncCallOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.func.call"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, callee, inputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["callee"] = (callee if (
    isinstance(callee, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
      _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(callee, context=_ods_context))
    results.extend(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def callee(self):
    return self.operation.attributes["callee"]

  @callee.setter
  def callee(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["callee"] = value

def func_call(result, callee, inputs, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(FuncCallOp(result=result, callee=callee, inputs=inputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FuncCallProceduralOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.func.call.procedural"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, callee, inputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["callee"] = (callee if (
    isinstance(callee, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
      _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(callee, context=_ods_context))
    results.extend(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def callee(self):
    return self.operation.attributes["callee"]

  @callee.setter
  def callee(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["callee"] = value

def func_call_procedural(result, callee, inputs, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(FuncCallProceduralOp(result=result, callee=callee, inputs=inputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FuncDPIImportOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.func.dpi.import"

  _ODS_REGIONS = (0, True)

  def __init__(self, callee, *, linkage_name=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["callee"] = (callee if (
    isinstance(callee, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
      _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(callee, context=_ods_context))
    if linkage_name is not None: attributes["linkage_name"] = (linkage_name if (
        isinstance(linkage_name, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(linkage_name, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def callee(self):
    return self.operation.attributes["callee"]

  @callee.setter
  def callee(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["callee"] = value

  @builtins.property
  def linkage_name(self):
    if "linkage_name" not in self.operation.attributes:
      return None
    return self.operation.attributes["linkage_name"]

  @linkage_name.setter
  def linkage_name(self, value):
    if value is not None:
      self.operation.attributes["linkage_name"] = value
    elif "linkage_name" in self.operation.attributes:
      del self.operation.attributes["linkage_name"]

  @linkage_name.deleter
  def linkage_name(self):
    del self.operation.attributes["linkage_name"]

def func_dpi_import(callee, *, linkage_name=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(FuncDPIImportOp(callee=callee, linkage_name=linkage_name, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class FuncOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.func"

  _ODS_REGIONS = (1, True)

  def __init__(self, sym_name, module_type, *, per_argument_attrs=None, input_locs=None, result_locs=None, verilogName=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    attributes["module_type"] = (module_type if (
    isinstance(module_type, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('anonymous_604')) else
      _ods_ir.AttrBuilder.get('anonymous_604')(module_type, context=_ods_context))
    if per_argument_attrs is not None: attributes["per_argument_attrs"] = (per_argument_attrs if (
        isinstance(per_argument_attrs, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DictArrayAttr')) else
          _ods_ir.AttrBuilder.get('DictArrayAttr')(per_argument_attrs, context=_ods_context))
    if input_locs is not None: attributes["input_locs"] = (input_locs if (
        isinstance(input_locs, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LocationArrayAttr')) else
          _ods_ir.AttrBuilder.get('LocationArrayAttr')(input_locs, context=_ods_context))
    if result_locs is not None: attributes["result_locs"] = (result_locs if (
        isinstance(result_locs, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LocationArrayAttr')) else
          _ods_ir.AttrBuilder.get('LocationArrayAttr')(result_locs, context=_ods_context))
    if verilogName is not None: attributes["verilogName"] = (verilogName if (
        isinstance(verilogName, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(verilogName, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def module_type(self):
    return self.operation.attributes["module_type"]

  @module_type.setter
  def module_type(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["module_type"] = value

  @builtins.property
  def per_argument_attrs(self):
    if "per_argument_attrs" not in self.operation.attributes:
      return None
    return self.operation.attributes["per_argument_attrs"]

  @per_argument_attrs.setter
  def per_argument_attrs(self, value):
    if value is not None:
      self.operation.attributes["per_argument_attrs"] = value
    elif "per_argument_attrs" in self.operation.attributes:
      del self.operation.attributes["per_argument_attrs"]

  @per_argument_attrs.deleter
  def per_argument_attrs(self):
    del self.operation.attributes["per_argument_attrs"]

  @builtins.property
  def input_locs(self):
    if "input_locs" not in self.operation.attributes:
      return None
    return self.operation.attributes["input_locs"]

  @input_locs.setter
  def input_locs(self, value):
    if value is not None:
      self.operation.attributes["input_locs"] = value
    elif "input_locs" in self.operation.attributes:
      del self.operation.attributes["input_locs"]

  @input_locs.deleter
  def input_locs(self):
    del self.operation.attributes["input_locs"]

  @builtins.property
  def result_locs(self):
    if "result_locs" not in self.operation.attributes:
      return None
    return self.operation.attributes["result_locs"]

  @result_locs.setter
  def result_locs(self, value):
    if value is not None:
      self.operation.attributes["result_locs"] = value
    elif "result_locs" in self.operation.attributes:
      del self.operation.attributes["result_locs"]

  @result_locs.deleter
  def result_locs(self):
    del self.operation.attributes["result_locs"]

  @builtins.property
  def verilogName(self):
    if "verilogName" not in self.operation.attributes:
      return None
    return self.operation.attributes["verilogName"]

  @verilogName.setter
  def verilogName(self, value):
    if value is not None:
      self.operation.attributes["verilogName"] = value
    elif "verilogName" in self.operation.attributes:
      del self.operation.attributes["verilogName"]

  @verilogName.deleter
  def verilogName(self):
    del self.operation.attributes["verilogName"]

  @builtins.property
  def body(self):
    return self.regions[0]

def func(sym_name, module_type, *, per_argument_attrs=None, input_locs=None, result_locs=None, verilog_name=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(FuncOp(sym_name=sym_name, module_type=module_type, per_argument_attrs=per_argument_attrs, input_locs=input_locs, result_locs=result_locs, verilogName=verilog_name, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class GenerateCaseOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.generate.case"

  _ODS_REGIONS = (0, False)

  def __init__(self, cond, casePatterns, caseNames, num_caseRegions, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["cond"] = (cond if (
    isinstance(cond, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypedAttrInterface')) else
      _ods_ir.AttrBuilder.get('TypedAttrInterface')(cond, context=_ods_context))
    attributes["casePatterns"] = (casePatterns if (
    isinstance(casePatterns, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('PatternArrayAttr')) else
      _ods_ir.AttrBuilder.get('PatternArrayAttr')(casePatterns, context=_ods_context))
    attributes["caseNames"] = (caseNames if (
    isinstance(caseNames, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrArrayAttr')) else
      _ods_ir.AttrBuilder.get('StrArrayAttr')(caseNames, context=_ods_context))
    _ods_successors = None
    regions = 0 + num_caseRegions
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def cond(self):
    return self.operation.attributes["cond"]

  @cond.setter
  def cond(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["cond"] = value

  @builtins.property
  def casePatterns(self):
    return self.operation.attributes["casePatterns"]

  @casePatterns.setter
  def casePatterns(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["casePatterns"] = value

  @builtins.property
  def caseNames(self):
    return self.operation.attributes["caseNames"]

  @caseNames.setter
  def caseNames(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["caseNames"] = value

  @builtins.property
  def caseRegions(self):
    return self.regions[0:]

def generate_case(cond, case_patterns, case_names, num_case_regions, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(GenerateCaseOp(cond=cond, casePatterns=case_patterns, caseNames=case_names, num_caseRegions=num_case_regions, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class GenerateOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.generate"

  _ODS_REGIONS = (1, True)

  def __init__(self, sym_name, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(sym_name, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def body(self):
    return self.regions[0]

def generate(sym_name, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(GenerateOp(sym_name=sym_name, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class GetModportOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.modport.get"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, iface, field, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(iface))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["field"] = (field if (
    isinstance(field, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
      _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(field, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def iface(self):
    return self.operation.operands[0]

  @builtins.property
  def field(self):
    return self.operation.attributes["field"]

  @field.setter
  def field(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["field"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def modport_get(result, iface, field, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(GetModportOp(result=result, iface=iface, field=field, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class IfDefOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.ifdef"

  _ODS_REGIONS = (2, True)

  def __init__(self, cond, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["cond"] = (cond if (
    isinstance(cond, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('MacroIdentAttr')) else
      _ods_ir.AttrBuilder.get('MacroIdentAttr')(cond, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def cond(self):
    return self.operation.attributes["cond"]

  @cond.setter
  def cond(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["cond"] = value

  @builtins.property
  def thenRegion(self):
    return self.regions[0]

  @builtins.property
  def elseRegion(self):
    return self.regions[1]

def ifdef(cond, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(IfDefOp(cond=cond, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class IfDefProceduralOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.ifdef.procedural"

  _ODS_REGIONS = (2, True)

  def __init__(self, cond, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["cond"] = (cond if (
    isinstance(cond, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('MacroIdentAttr')) else
      _ods_ir.AttrBuilder.get('MacroIdentAttr')(cond, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def cond(self):
    return self.operation.attributes["cond"]

  @cond.setter
  def cond(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["cond"] = value

  @builtins.property
  def thenRegion(self):
    return self.regions[0]

  @builtins.property
  def elseRegion(self):
    return self.regions[1]

def ifdef_procedural(cond, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(IfDefProceduralOp(cond=cond, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class IfOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.if"

  _ODS_REGIONS = (2, True)

  def __init__(self, cond, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(cond))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def cond(self):
    return self.operation.operands[0]

  @builtins.property
  def thenRegion(self):
    return self.regions[0]

  @builtins.property
  def elseRegion(self):
    return self.regions[1]

def if_(cond, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(IfOp(cond=cond, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class IndexedPartSelectInOutOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.indexed_part_select_inout"

  _ODS_REGIONS = (0, True)

  def __init__(self, input, base, width, *, decrement=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    operands.append(_get_op_result_or_value(base))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["width"] = (width if (
    isinstance(width, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(width, context=_ods_context))
    if bool(decrement): attributes["decrement"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def base(self):
    return self.operation.operands[1]

  @builtins.property
  def width(self):
    return self.operation.attributes["width"]

  @width.setter
  def width(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["width"] = value

  @builtins.property
  def decrement(self):
    return "decrement" in self.operation.attributes

  @decrement.setter
  def decrement(self, value):
    if bool(value):
      self.operation.attributes["decrement"] = _ods_ir.UnitAttr.get()
    elif "decrement" in self.operation.attributes:
      del self.operation.attributes["decrement"]

  @decrement.deleter
  def decrement(self):
    del self.operation.attributes["decrement"]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def indexed_part_select_inout(input, base, width, *, decrement=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(IndexedPartSelectInOutOp(input=input, base=base, width=width, decrement=decrement, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class IndexedPartSelectOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.indexed_part_select"

  _ODS_REGIONS = (0, True)

  def __init__(self, input, base, width, *, decrement=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    operands.append(_get_op_result_or_value(base))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["width"] = (width if (
    isinstance(width, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(width, context=_ods_context))
    if bool(decrement): attributes["decrement"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def base(self):
    return self.operation.operands[1]

  @builtins.property
  def width(self):
    return self.operation.attributes["width"]

  @width.setter
  def width(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["width"] = value

  @builtins.property
  def decrement(self):
    return "decrement" in self.operation.attributes

  @decrement.setter
  def decrement(self, value):
    if bool(value):
      self.operation.attributes["decrement"] = _ods_ir.UnitAttr.get()
    elif "decrement" in self.operation.attributes:
      del self.operation.attributes["decrement"]

  @decrement.deleter
  def decrement(self):
    del self.operation.attributes["decrement"]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def indexed_part_select(input, base, width, *, decrement=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(IndexedPartSelectOp(input=input, base=base, width=width, decrement=decrement, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class InfoOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.info"

  _ODS_REGIONS = (0, True)

  def __init__(self, substitutions, *, message=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(substitutions))
    _ods_context = _ods_get_default_loc_context(loc)
    if message is not None: attributes["message"] = (message if (
        isinstance(message, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(message, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def substitutions(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def message(self):
    if "message" not in self.operation.attributes:
      return None
    return self.operation.attributes["message"]

  @message.setter
  def message(self, value):
    if value is not None:
      self.operation.attributes["message"] = value
    elif "message" in self.operation.attributes:
      del self.operation.attributes["message"]

  @message.deleter
  def message(self):
    del self.operation.attributes["message"]

def info(substitutions, *, message=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(InfoOp(substitutions=substitutions, message=message, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class InitialOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.initial"

  _ODS_REGIONS = (1, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def body(self):
    return self.regions[0]

def initial(*, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(InitialOp(loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class InterfaceInstanceOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.interface.instance"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, name, *, inner_sym=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["name"] = (name if (
    isinstance(name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(name, context=_ods_context))
    if inner_sym is not None: attributes["inner_sym"] = (inner_sym if (
        isinstance(inner_sym, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('InnerSymAttr')) else
          _ods_ir.AttrBuilder.get('InnerSymAttr')(inner_sym, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def name(self):
    return self.operation.attributes["name"]

  @name.setter
  def name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["name"] = value

  @builtins.property
  def inner_sym(self):
    if "inner_sym" not in self.operation.attributes:
      return None
    return self.operation.attributes["inner_sym"]

  @inner_sym.setter
  def inner_sym(self, value):
    if value is not None:
      self.operation.attributes["inner_sym"] = value
    elif "inner_sym" in self.operation.attributes:
      del self.operation.attributes["inner_sym"]

  @inner_sym.deleter
  def inner_sym(self):
    del self.operation.attributes["inner_sym"]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def interface_instance(result, name, *, inner_sym=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(InterfaceInstanceOp(result=result, name=name, inner_sym=inner_sym, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class InterfaceModportOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.interface.modport"

  _ODS_REGIONS = (0, True)

  def __init__(self, sym_name, ports, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    attributes["ports"] = (ports if (
    isinstance(ports, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('ModportStructArrayAttr')) else
      _ods_ir.AttrBuilder.get('ModportStructArrayAttr')(ports, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def ports(self):
    return self.operation.attributes["ports"]

  @ports.setter
  def ports(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["ports"] = value

def interface_modport(sym_name, ports, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(InterfaceModportOp(sym_name=sym_name, ports=ports, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class InterfaceOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.interface"

  _ODS_REGIONS = (1, True)

  def __init__(self, sym_name, *, comment=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    if comment is not None: attributes["comment"] = (comment if (
        isinstance(comment, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(comment, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def comment(self):
    if "comment" not in self.operation.attributes:
      return None
    return self.operation.attributes["comment"]

  @comment.setter
  def comment(self, value):
    if value is not None:
      self.operation.attributes["comment"] = value
    elif "comment" in self.operation.attributes:
      del self.operation.attributes["comment"]

  @comment.deleter
  def comment(self):
    del self.operation.attributes["comment"]

  @builtins.property
  def body(self):
    return self.regions[0]

def interface(sym_name, *, comment=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(InterfaceOp(sym_name=sym_name, comment=comment, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class InterfaceSignalOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.interface.signal"

  _ODS_REGIONS = (0, True)

  def __init__(self, sym_name, type_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    attributes["type"] = (type_ if (
    isinstance(type_, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SignalTypeAttr')) else
      _ods_ir.AttrBuilder.get('SignalTypeAttr')(type_, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def type_(self):
    return self.operation.attributes["type"]

  @type_.setter
  def type_(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["type"] = value

def interface_signal(sym_name, type_, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(InterfaceSignalOp(sym_name=sym_name, type_=type_, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class LocalParamOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.localparam"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, name, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["value"] = (value if (
    isinstance(value, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AnyAttr')) else
      _ods_ir.AttrBuilder.get('AnyAttr')(value, context=_ods_context))
    attributes["name"] = (name if (
    isinstance(name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(name, context=_ods_context))
    _ods_result_type_source_attr = attributes["value"]
    _ods_derived_result_type = (
        _ods_ir.TypeAttr(_ods_result_type_source_attr).value
        if _ods_ir.TypeAttr.isinstance(_ods_result_type_source_attr) else
        _ods_result_type_source_attr.type)
    results.extend([_ods_derived_result_type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def value(self):
    return self.operation.attributes["value"]

  @value.setter
  def value(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["value"] = value

  @builtins.property
  def name(self):
    return self.operation.attributes["name"]

  @name.setter
  def name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["name"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def localparam(value, name, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(LocalParamOp(value=value, name=name, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class LogicOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.logic"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, name, *, inner_sym=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["name"] = (name if (
    isinstance(name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(name, context=_ods_context))
    if inner_sym is not None: attributes["inner_sym"] = (inner_sym if (
        isinstance(inner_sym, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('InnerSymAttr')) else
          _ods_ir.AttrBuilder.get('InnerSymAttr')(inner_sym, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def name(self):
    return self.operation.attributes["name"]

  @name.setter
  def name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["name"] = value

  @builtins.property
  def inner_sym(self):
    if "inner_sym" not in self.operation.attributes:
      return None
    return self.operation.attributes["inner_sym"]

  @inner_sym.setter
  def inner_sym(self, value):
    if value is not None:
      self.operation.attributes["inner_sym"] = value
    elif "inner_sym" in self.operation.attributes:
      del self.operation.attributes["inner_sym"]

  @inner_sym.deleter
  def inner_sym(self):
    del self.operation.attributes["inner_sym"]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def logic(result, name, *, inner_sym=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(LogicOp(result=result, name=name, inner_sym=inner_sym, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MacroDeclOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.macro.decl"

  _ODS_REGIONS = (0, True)

  def __init__(self, sym_name, *, args=None, verilogName=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    if args is not None: attributes["args"] = (args if (
        isinstance(args, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrArrayAttr')) else
          _ods_ir.AttrBuilder.get('StrArrayAttr')(args, context=_ods_context))
    if verilogName is not None: attributes["verilogName"] = (verilogName if (
        isinstance(verilogName, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(verilogName, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def args(self):
    if "args" not in self.operation.attributes:
      return None
    return self.operation.attributes["args"]

  @args.setter
  def args(self, value):
    if value is not None:
      self.operation.attributes["args"] = value
    elif "args" in self.operation.attributes:
      del self.operation.attributes["args"]

  @args.deleter
  def args(self):
    del self.operation.attributes["args"]

  @builtins.property
  def verilogName(self):
    if "verilogName" not in self.operation.attributes:
      return None
    return self.operation.attributes["verilogName"]

  @verilogName.setter
  def verilogName(self, value):
    if value is not None:
      self.operation.attributes["verilogName"] = value
    elif "verilogName" in self.operation.attributes:
      del self.operation.attributes["verilogName"]

  @verilogName.deleter
  def verilogName(self):
    del self.operation.attributes["verilogName"]

def macro_decl(sym_name, *, args=None, verilog_name=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(MacroDeclOp(sym_name=sym_name, args=args, verilogName=verilog_name, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MacroDefOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.macro.def"

  _ODS_REGIONS = (0, True)

  def __init__(self, macroName, format_string, *, symbols=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["macroName"] = (macroName if (
    isinstance(macroName, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
      _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(macroName, context=_ods_context))
    attributes["format_string"] = (format_string if (
    isinstance(format_string, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(format_string, context=_ods_context))
    if symbols is not None: attributes["symbols"] = (symbols if (
        isinstance(symbols, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('NameRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('NameRefArrayAttr')(symbols, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def macroName(self):
    return self.operation.attributes["macroName"]

  @macroName.setter
  def macroName(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["macroName"] = value

  @builtins.property
  def format_string(self):
    return self.operation.attributes["format_string"]

  @format_string.setter
  def format_string(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["format_string"] = value

  @builtins.property
  def symbols(self):
    return self.operation.attributes["symbols"]

  @symbols.setter
  def symbols(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["symbols"] = value

def macro_def(macro_name, format_string, *, symbols=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(MacroDefOp(macroName=macro_name, format_string=format_string, symbols=symbols, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MacroRefExprOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.macro.ref"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, macroName, inputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["macroName"] = (macroName if (
    isinstance(macroName, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
      _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(macroName, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def macroName(self):
    return self.operation.attributes["macroName"]

  @macroName.setter
  def macroName(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["macroName"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def macro_ref(result, macro_name, inputs, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(MacroRefExprOp(result=result, macroName=macro_name, inputs=inputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class MacroRefExprSEOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.macro.ref.se"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, macroName, inputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["macroName"] = (macroName if (
    isinstance(macroName, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
      _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(macroName, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def macroName(self):
    return self.operation.attributes["macroName"]

  @macroName.setter
  def macroName(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["macroName"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def macro_ref_se(result, macro_name, inputs, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(MacroRefExprSEOp(result=result, macroName=macro_name, inputs=inputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class OrderedOutputOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.ordered"

  _ODS_REGIONS = (1, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def body(self):
    return self.regions[0]

def ordered(*, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(OrderedOutputOp(loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class PAssignOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.passign"

  _ODS_REGIONS = (0, True)

  def __init__(self, dest, src, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(dest))
    operands.append(_get_op_result_or_value(src))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def dest(self):
    return self.operation.operands[0]

  @builtins.property
  def src(self):
    return self.operation.operands[1]

def passign(dest, src, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(PAssignOp(dest=dest, src=src, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ReadInOutOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.read_inout"

  _ODS_REGIONS = (0, True)

  def __init__(self, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def read_inout(input, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ReadInOutOp(input=input, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ReadInterfaceSignalOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.interface.signal.read"

  _ODS_REGIONS = (0, True)

  def __init__(self, signalData, iface, signalName, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(iface))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["signalName"] = (signalName if (
    isinstance(signalName, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
      _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(signalName, context=_ods_context))
    results.append(signalData)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def iface(self):
    return self.operation.operands[0]

  @builtins.property
  def signalName(self):
    return self.operation.attributes["signalName"]

  @signalName.setter
  def signalName(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["signalName"] = value

  @builtins.property
  def signalData(self):
    return self.operation.results[0]

def interface_signal_read(signal_data, iface, signal_name, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ReadInterfaceSignalOp(signalData=signal_data, iface=iface, signalName=signal_name, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ReadMemOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.readmem"

  _ODS_REGIONS = (0, True)

  def __init__(self, dest, filename, base, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(dest))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["filename"] = (filename if (
    isinstance(filename, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(filename, context=_ods_context))
    attributes["base"] = (base if (
    isinstance(base, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('MemBaseTypeAttr')) else
      _ods_ir.AttrBuilder.get('MemBaseTypeAttr')(base, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def dest(self):
    return self.operation.operands[0]

  @builtins.property
  def filename(self):
    return self.operation.attributes["filename"]

  @filename.setter
  def filename(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["filename"] = value

  @builtins.property
  def base(self):
    return self.operation.attributes["base"]

  @base.setter
  def base(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["base"] = value

def readmem(dest, filename, base, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ReadMemOp(dest=dest, filename=filename, base=base, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class RegOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.reg"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, name, *, init=None, inner_sym=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    if init is not None: operands.append(_get_op_result_or_value(init))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["name"] = (name if (
    isinstance(name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(name, context=_ods_context))
    if inner_sym is not None: attributes["inner_sym"] = (inner_sym if (
        isinstance(inner_sym, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('InnerSymAttr')) else
          _ods_ir.AttrBuilder.get('InnerSymAttr')(inner_sym, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def init(self):
    return None if len(self.operation.operands) < 1 else self.operation.operands[0]

  @builtins.property
  def name(self):
    return self.operation.attributes["name"]

  @name.setter
  def name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["name"] = value

  @builtins.property
  def inner_sym(self):
    if "inner_sym" not in self.operation.attributes:
      return None
    return self.operation.attributes["inner_sym"]

  @inner_sym.setter
  def inner_sym(self, value):
    if value is not None:
      self.operation.attributes["inner_sym"] = value
    elif "inner_sym" in self.operation.attributes:
      del self.operation.attributes["inner_sym"]

  @inner_sym.deleter
  def inner_sym(self):
    del self.operation.attributes["inner_sym"]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def reg(result, name, *, init=None, inner_sym=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(RegOp(result=result, name=name, init=init, inner_sym=inner_sym, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ReleaseOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.release"

  _ODS_REGIONS = (0, True)

  def __init__(self, dest, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(dest))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def dest(self):
    return self.operation.operands[0]

def release(dest, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ReleaseOp(dest=dest, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ReserveNamesOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.reserve_names"

  _ODS_REGIONS = (0, True)

  def __init__(self, reservedNames, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["reservedNames"] = (reservedNames if (
    isinstance(reservedNames, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrArrayAttr')) else
      _ods_ir.AttrBuilder.get('StrArrayAttr')(reservedNames, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def reservedNames(self):
    return self.operation.attributes["reservedNames"]

  @reservedNames.setter
  def reservedNames(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["reservedNames"] = value

def reserve_names(reserved_names, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ReserveNamesOp(reservedNames=reserved_names, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ReturnOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.return"

  _ODS_REGIONS = (0, True)

  def __init__(self, operands_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(operands_))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operands_(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def return_(operands_, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(ReturnOp(operands_=operands_, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SampledOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.system.sampled"

  _ODS_REGIONS = (0, True)

  def __init__(self, expression, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(expression))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def expression(self):
    return self.operation.operands[0]

  @builtins.property
  def sampledValue(self):
    return self.operation.results[0]

def system_sampled(expression, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(SampledOp(expression=expression, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class StopOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.stop"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, verbosity=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    if verbosity is not None: attributes["verbosity"] = (verbosity if (
        isinstance(verbosity, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('VerbosityIntAttr')) else
          _ods_ir.AttrBuilder.get('VerbosityIntAttr')(verbosity, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def verbosity(self):
    return self.operation.attributes["verbosity"]

  @verbosity.setter
  def verbosity(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["verbosity"] = value

def stop(*, verbosity=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(StopOp(verbosity=verbosity, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class StructFieldInOutOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.struct_field_inout"

  _ODS_REGIONS = (0, True)

  def __init__(self, input, field, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["field"] = (field if (
    isinstance(field, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(field, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def field(self):
    return self.operation.attributes["field"]

  @field.setter
  def field(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["field"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def struct_field_inout(input, field, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(StructFieldInOutOp(input=input, field=field, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class SystemFunctionOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.system"

  _ODS_REGIONS = (0, True)

  def __init__(self, out, fnName, args, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(args))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["fnName"] = (fnName if (
    isinstance(fnName, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(fnName, context=_ods_context))
    results.append(out)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def args(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def fnName(self):
    return self.operation.attributes["fnName"]

  @fnName.setter
  def fnName(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fnName"] = value

  @builtins.property
  def out(self):
    return self.operation.results[0]

def system(out, fn_name, args, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(SystemFunctionOp(out=out, fnName=fn_name, args=args, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class UnpackedArrayCreateOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.unpacked_array_create"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, inputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def unpacked_array_create(result, inputs, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(UnpackedArrayCreateOp(result=result, inputs=inputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class UnpackedOpenArrayCastOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.unpacked_open_array_cast"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def unpacked_open_array_cast(result, input, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(UnpackedOpenArrayCastOp(result=result, input=input, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VerbatimExprOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.verbatim.expr"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, format_string, substitutions, *, symbols=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(substitutions))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["format_string"] = (format_string if (
    isinstance(format_string, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(format_string, context=_ods_context))
    if symbols is not None: attributes["symbols"] = (symbols if (
        isinstance(symbols, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('NameRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('NameRefArrayAttr')(symbols, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def substitutions(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def format_string(self):
    return self.operation.attributes["format_string"]

  @format_string.setter
  def format_string(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["format_string"] = value

  @builtins.property
  def symbols(self):
    return self.operation.attributes["symbols"]

  @symbols.setter
  def symbols(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["symbols"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def verbatim_expr(result, format_string, substitutions, *, symbols=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VerbatimExprOp(result=result, format_string=format_string, substitutions=substitutions, symbols=symbols, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VerbatimExprSEOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.verbatim.expr.se"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, format_string, substitutions, *, symbols=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(substitutions))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["format_string"] = (format_string if (
    isinstance(format_string, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(format_string, context=_ods_context))
    if symbols is not None: attributes["symbols"] = (symbols if (
        isinstance(symbols, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('NameRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('NameRefArrayAttr')(symbols, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def substitutions(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def format_string(self):
    return self.operation.attributes["format_string"]

  @format_string.setter
  def format_string(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["format_string"] = value

  @builtins.property
  def symbols(self):
    return self.operation.attributes["symbols"]

  @symbols.setter
  def symbols(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["symbols"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def verbatim_expr_se(result, format_string, substitutions, *, symbols=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(VerbatimExprSEOp(result=result, format_string=format_string, substitutions=substitutions, symbols=symbols, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class VerbatimOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.verbatim"

  _ODS_REGIONS = (0, True)

  def __init__(self, format_string, substitutions, *, symbols=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(substitutions))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["format_string"] = (format_string if (
    isinstance(format_string, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(format_string, context=_ods_context))
    if symbols is not None: attributes["symbols"] = (symbols if (
        isinstance(symbols, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('NameRefArrayAttr')) else
          _ods_ir.AttrBuilder.get('NameRefArrayAttr')(symbols, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def substitutions(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def format_string(self):
    return self.operation.attributes["format_string"]

  @format_string.setter
  def format_string(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["format_string"] = value

  @builtins.property
  def symbols(self):
    return self.operation.attributes["symbols"]

  @symbols.setter
  def symbols(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["symbols"] = value

def verbatim(format_string, substitutions, *, symbols=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(VerbatimOp(format_string=format_string, substitutions=substitutions, symbols=symbols, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class WarningOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.warning"

  _ODS_REGIONS = (0, True)

  def __init__(self, substitutions, *, message=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(substitutions))
    _ods_context = _ods_get_default_loc_context(loc)
    if message is not None: attributes["message"] = (message if (
        isinstance(message, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(message, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def substitutions(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def message(self):
    if "message" not in self.operation.attributes:
      return None
    return self.operation.attributes["message"]

  @message.setter
  def message(self, value):
    if value is not None:
      self.operation.attributes["message"] = value
    elif "message" in self.operation.attributes:
      del self.operation.attributes["message"]

  @message.deleter
  def message(self):
    del self.operation.attributes["message"]

def warning(substitutions, *, message=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(WarningOp(substitutions=substitutions, message=message, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class WireOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.wire"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, name, *, inner_sym=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["name"] = (name if (
    isinstance(name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(name, context=_ods_context))
    if inner_sym is not None: attributes["inner_sym"] = (inner_sym if (
        isinstance(inner_sym, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('InnerSymAttr')) else
          _ods_ir.AttrBuilder.get('InnerSymAttr')(inner_sym, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def name(self):
    return self.operation.attributes["name"]

  @name.setter
  def name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["name"] = value

  @builtins.property
  def inner_sym(self):
    if "inner_sym" not in self.operation.attributes:
      return None
    return self.operation.attributes["inner_sym"]

  @inner_sym.setter
  def inner_sym(self, value):
    if value is not None:
      self.operation.attributes["inner_sym"] = value
    elif "inner_sym" in self.operation.attributes:
      del self.operation.attributes["inner_sym"]

  @inner_sym.deleter
  def inner_sym(self):
    del self.operation.attributes["inner_sym"]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def wire(result, name, *, inner_sym=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(WireOp(result=result, name=name, inner_sym=inner_sym, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class XMROp(_ods_ir.OpView):
  OPERATION_NAME = "sv.xmr"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, path, terminal, *, isRooted=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(isRooted): attributes["isRooted"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    attributes["path"] = (path if (
    isinstance(path, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrArrayAttr')) else
      _ods_ir.AttrBuilder.get('StrArrayAttr')(path, context=_ods_context))
    attributes["terminal"] = (terminal if (
    isinstance(terminal, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(terminal, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def isRooted(self):
    return "isRooted" in self.operation.attributes

  @isRooted.setter
  def isRooted(self, value):
    if bool(value):
      self.operation.attributes["isRooted"] = _ods_ir.UnitAttr.get()
    elif "isRooted" in self.operation.attributes:
      del self.operation.attributes["isRooted"]

  @isRooted.deleter
  def isRooted(self):
    del self.operation.attributes["isRooted"]

  @builtins.property
  def path(self):
    return self.operation.attributes["path"]

  @path.setter
  def path(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["path"] = value

  @builtins.property
  def terminal(self):
    return self.operation.attributes["terminal"]

  @terminal.setter
  def terminal(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["terminal"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def xmr(result, path, terminal, *, is_rooted=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(XMROp(result=result, path=path, terminal=terminal, isRooted=is_rooted, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class XMRRefOp(_ods_ir.OpView):
  OPERATION_NAME = "sv.xmr.ref"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, ref, *, verbatimSuffix=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["ref"] = (ref if (
    isinstance(ref, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
      _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(ref, context=_ods_context))
    if verbatimSuffix is not None: attributes["verbatimSuffix"] = (verbatimSuffix if (
        isinstance(verbatimSuffix, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(verbatimSuffix, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def ref(self):
    return self.operation.attributes["ref"]

  @ref.setter
  def ref(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["ref"] = value

  @builtins.property
  def verbatimSuffix(self):
    return self.operation.attributes["verbatimSuffix"]

  @verbatimSuffix.setter
  def verbatimSuffix(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["verbatimSuffix"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def xmr_ref(result, ref, *, verbatim_suffix=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(XMRRefOp(result=result, ref=ref, verbatimSuffix=verbatim_suffix, loc=loc, ip=ip))
