# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.appendix_google_business_data_price_data_info import AppendixGoogleBusinessDataPriceDataInfo
from dataforseo_client.models.appendix_hotel_info_google_business_data_price_data import AppendixHotelInfoGoogleBusinessDataPriceData
from dataforseo_client.models.appendix_keywords_data_price_data_info import AppendixKeywordsDataPriceDataInfo
from typing import Optional, Set
from typing_extensions import Self

class AppendixGoogleBusinessDataPriceData(BaseModel):
    """
    AppendixGoogleBusinessDataPriceData
    """ # noqa: E501
    extended_reviews: Optional[AppendixKeywordsDataPriceDataInfo] = None
    hotel_info: Optional[AppendixHotelInfoGoogleBusinessDataPriceData] = None
    hotel_searches: Optional[AppendixGoogleBusinessDataPriceDataInfo] = None
    my_business_info: Optional[AppendixGoogleBusinessDataPriceDataInfo] = None
    my_business_updates: Optional[AppendixGoogleBusinessDataPriceDataInfo] = None
    questions_and_answers: Optional[AppendixGoogleBusinessDataPriceDataInfo] = None
    reviews: Optional[AppendixGoogleBusinessDataPriceDataInfo] = None
    __properties: ClassVar[List[str]] = ["extended_reviews", "hotel_info", "hotel_searches", "my_business_info", "my_business_updates", "questions_and_answers", "reviews"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AppendixGoogleBusinessDataPriceData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of extended_reviews
        if self.extended_reviews:
            _dict['extended_reviews'] = self.extended_reviews.to_dict()
        # override the default output from pydantic by calling `to_dict()` of hotel_info
        if self.hotel_info:
            _dict['hotel_info'] = self.hotel_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of hotel_searches
        if self.hotel_searches:
            _dict['hotel_searches'] = self.hotel_searches.to_dict()
        # override the default output from pydantic by calling `to_dict()` of my_business_info
        if self.my_business_info:
            _dict['my_business_info'] = self.my_business_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of my_business_updates
        if self.my_business_updates:
            _dict['my_business_updates'] = self.my_business_updates.to_dict()
        # override the default output from pydantic by calling `to_dict()` of questions_and_answers
        if self.questions_and_answers:
            _dict['questions_and_answers'] = self.questions_and_answers.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reviews
        if self.reviews:
            _dict['reviews'] = self.reviews.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AppendixGoogleBusinessDataPriceData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "extended_reviews": AppendixKeywordsDataPriceDataInfo.from_dict(obj["extended_reviews"]) if obj.get("extended_reviews") is not None else None,
            "hotel_info": AppendixHotelInfoGoogleBusinessDataPriceData.from_dict(obj["hotel_info"]) if obj.get("hotel_info") is not None else None,
            "hotel_searches": AppendixGoogleBusinessDataPriceDataInfo.from_dict(obj["hotel_searches"]) if obj.get("hotel_searches") is not None else None,
            "my_business_info": AppendixGoogleBusinessDataPriceDataInfo.from_dict(obj["my_business_info"]) if obj.get("my_business_info") is not None else None,
            "my_business_updates": AppendixGoogleBusinessDataPriceDataInfo.from_dict(obj["my_business_updates"]) if obj.get("my_business_updates") is not None else None,
            "questions_and_answers": AppendixGoogleBusinessDataPriceDataInfo.from_dict(obj["questions_and_answers"]) if obj.get("questions_and_answers") is not None else None,
            "reviews": AppendixGoogleBusinessDataPriceDataInfo.from_dict(obj["reviews"]) if obj.get("reviews") is not None else None
        })
        return _obj


