# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.appendix_sellers_google_merchant_limits_rates_data_info import AppendixSellersGoogleMerchantLimitsRatesDataInfo
from dataforseo_client.models.appendix_serp_limits_rates_data_info import AppendixSerpLimitsRatesDataInfo
from typing import Optional, Set
from typing_extensions import Self

class AppendixMerchantGoogleInfo(BaseModel):
    """
    AppendixMerchantGoogleInfo
    """ # noqa: E501
    products: Optional[AppendixSerpLimitsRatesDataInfo] = None
    sellers: Optional[AppendixSellersGoogleMerchantLimitsRatesDataInfo] = None
    product_spec: Optional[AppendixSerpLimitsRatesDataInfo] = None
    product_info: Optional[AppendixSerpLimitsRatesDataInfo] = None
    __properties: ClassVar[List[str]] = ["products", "sellers", "product_spec", "product_info"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AppendixMerchantGoogleInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of products
        if self.products:
            _dict['products'] = self.products.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sellers
        if self.sellers:
            _dict['sellers'] = self.sellers.to_dict()
        # override the default output from pydantic by calling `to_dict()` of product_spec
        if self.product_spec:
            _dict['product_spec'] = self.product_spec.to_dict()
        # override the default output from pydantic by calling `to_dict()` of product_info
        if self.product_info:
            _dict['product_info'] = self.product_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AppendixMerchantGoogleInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "products": AppendixSerpLimitsRatesDataInfo.from_dict(obj["products"]) if obj.get("products") is not None else None,
            "sellers": AppendixSellersGoogleMerchantLimitsRatesDataInfo.from_dict(obj["sellers"]) if obj.get("sellers") is not None else None,
            "product_spec": AppendixSerpLimitsRatesDataInfo.from_dict(obj["product_spec"]) if obj.get("product_spec") is not None else None,
            "product_info": AppendixSerpLimitsRatesDataInfo.from_dict(obj["product_info"]) if obj.get("product_info") is not None else None
        })
        return _obj


