# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.appendix_money_data import AppendixMoneyData
from dataforseo_client.models.appendix_price_data import AppendixPriceData
from dataforseo_client.models.appendix_rates_data import AppendixRatesData
from typing import Optional, Set
from typing_extensions import Self

class AppendixUserDataResultInfo(BaseModel):
    """
    AppendixUserDataResultInfo
    """ # noqa: E501
    login: Optional[StrictStr] = Field(default=None, description="your login")
    timezone: Optional[StrictStr] = Field(default=None, description="your time zone can be set in your profile settings")
    rates: Optional[AppendixRatesData] = None
    money: Optional[AppendixMoneyData] = None
    price: Optional[AppendixPriceData] = None
    __properties: ClassVar[List[str]] = ["login", "timezone", "rates", "money", "price"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AppendixUserDataResultInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of rates
        if self.rates:
            _dict['rates'] = self.rates.to_dict()
        # override the default output from pydantic by calling `to_dict()` of money
        if self.money:
            _dict['money'] = self.money.to_dict()
        # override the default output from pydantic by calling `to_dict()` of price
        if self.price:
            _dict['price'] = self.price.to_dict()
        # set to None if login (nullable) is None
        # and model_fields_set contains the field
        if self.login is None and "login" in self.model_fields_set:
            _dict['login'] = None

        # set to None if timezone (nullable) is None
        # and model_fields_set contains the field
        if self.timezone is None and "timezone" in self.model_fields_set:
            _dict['timezone'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AppendixUserDataResultInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "login": obj.get("login"),
            "timezone": obj.get("timezone"),
            "rates": AppendixRatesData.from_dict(obj["rates"]) if obj.get("rates") is not None else None,
            "money": AppendixMoneyData.from_dict(obj["money"]) if obj.get("money") is not None else None,
            "price": AppendixPriceData.from_dict(obj["price"]) if obj.get("price") is not None else None
        })
        return _obj


