# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class BacklinksTimeseriesNewLostSummaryLiveItem(BaseModel):
    """
    BacklinksTimeseriesNewLostSummaryLiveItem
    """ # noqa: E501
    type: Optional[StrictStr] = Field(default=None, description="type of element")
    var_date: Optional[StrictStr] = Field(default=None, description="date and time when the data for the target was stored in the UTC format: “yyyy-mm-dd hh-mm-ss +00:00” example: 2019-11-15 12:57:46 +00:00", alias="date")
    new_backlinks: Optional[StrictInt] = Field(default=None, description="number of new backlinks number of new backlinks pointing to the target")
    lost_backlinks: Optional[StrictInt] = Field(default=None, description="number of lost backlinks number of lost backlinks of the target")
    new_referring_domains: Optional[StrictInt] = Field(default=None, description="number of new referring domains number of new referring domains pointing to the target")
    lost_referring_domains: Optional[StrictInt] = Field(default=None, description="number of lost referring domains number of lost referring domains of the target")
    new_referring_main_domains: Optional[StrictInt] = Field(default=None, description="number of new referring main domains number of new referring main domains pointing to the target")
    lost_referring_main_domains: Optional[StrictInt] = Field(default=None, description="number of lost referring main domains number of lost referring main domains of the target")
    __properties: ClassVar[List[str]] = ["type", "date", "new_backlinks", "lost_backlinks", "new_referring_domains", "lost_referring_domains", "new_referring_main_domains", "lost_referring_main_domains"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BacklinksTimeseriesNewLostSummaryLiveItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if var_date (nullable) is None
        # and model_fields_set contains the field
        if self.var_date is None and "var_date" in self.model_fields_set:
            _dict['date'] = None

        # set to None if new_backlinks (nullable) is None
        # and model_fields_set contains the field
        if self.new_backlinks is None and "new_backlinks" in self.model_fields_set:
            _dict['new_backlinks'] = None

        # set to None if lost_backlinks (nullable) is None
        # and model_fields_set contains the field
        if self.lost_backlinks is None and "lost_backlinks" in self.model_fields_set:
            _dict['lost_backlinks'] = None

        # set to None if new_referring_domains (nullable) is None
        # and model_fields_set contains the field
        if self.new_referring_domains is None and "new_referring_domains" in self.model_fields_set:
            _dict['new_referring_domains'] = None

        # set to None if lost_referring_domains (nullable) is None
        # and model_fields_set contains the field
        if self.lost_referring_domains is None and "lost_referring_domains" in self.model_fields_set:
            _dict['lost_referring_domains'] = None

        # set to None if new_referring_main_domains (nullable) is None
        # and model_fields_set contains the field
        if self.new_referring_main_domains is None and "new_referring_main_domains" in self.model_fields_set:
            _dict['new_referring_main_domains'] = None

        # set to None if lost_referring_main_domains (nullable) is None
        # and model_fields_set contains the field
        if self.lost_referring_main_domains is None and "lost_referring_main_domains" in self.model_fields_set:
            _dict['lost_referring_main_domains'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BacklinksTimeseriesNewLostSummaryLiveItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "date": obj.get("date"),
            "new_backlinks": obj.get("new_backlinks"),
            "lost_backlinks": obj.get("lost_backlinks"),
            "new_referring_domains": obj.get("new_referring_domains"),
            "lost_referring_domains": obj.get("lost_referring_domains"),
            "new_referring_main_domains": obj.get("new_referring_main_domains"),
            "lost_referring_main_domains": obj.get("lost_referring_main_domains")
        })
        return _obj


