# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from importlib import import_module
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from dataforseo_client.models.ai_overview_serp_element_item import AiOverviewSerpElementItem
    from dataforseo_client.models.q_answer_box_serp_element_item import QAnswerBoxSerpElementItem
    from dataforseo_client.models.data_app_serp_element_item import DataAppSerpElementItem
    from dataforseo_client.models.carousel_serp_element_item import CarouselSerpElementItem
    from dataforseo_client.models.commercial_units_serp_element_item import CommercialUnitsSerpElementItem
    from dataforseo_client.models.compare_sites_serp_element_item import CompareSitesSerpElementItem
    from dataforseo_client.models.courses_serp_element_item import CoursesSerpElementItem
    from dataforseo_client.models.currency_box_serp_element_item import CurrencyBoxSerpElementItem
    from dataforseo_client.models.dictionary_serp_element_item import DictionarySerpElementItem
    from dataforseo_client.models.discussions_and_forums_serp_element_item import DiscussionsAndForumsSerpElementItem
    from dataforseo_client.models.event_item_serp_element_item import EventItemSerpElementItem
    from dataforseo_client.models.events_serp_element_item import EventsSerpElementItem
    from dataforseo_client.models.explore_brands_serp_element_item import ExploreBrandsSerpElementItem
    from dataforseo_client.models.featured_snippet_serp_element_item import FeaturedSnippetSerpElementItem
    from dataforseo_client.models.find_results_on_serp_element_item import FindResultsOnSerpElementItem
    from dataforseo_client.models.found_on_web_serp_element_item import FoundOnWebSerpElementItem
    from dataforseo_client.models.google_flights_serp_element_item import GoogleFlightsSerpElementItem
    from dataforseo_client.models.google_hotels_serp_element_item import GoogleHotelsSerpElementItem
    from dataforseo_client.models.google_posts_serp_element_item import GooglePostsSerpElementItem
    from dataforseo_client.models.google_reviews_serp_element_item import GoogleReviewsSerpElementItem
    from dataforseo_client.models.hotels_pack_serp_element_item import HotelsPackSerpElementItem
    from dataforseo_client.models.images_serp_element_item import ImagesSerpElementItem
    from dataforseo_client.models.jobs_serp_element_item import JobsSerpElementItem
    from dataforseo_client.models.knowledge_graph_serp_element_item import KnowledgeGraphSerpElementItem
    from dataforseo_client.models.knowledge_graph_ai_overview_item_serp_element_item import KnowledgeGraphAiOverviewItemSerpElementItem
    from dataforseo_client.models.knowledge_graph_carousel_item_serp_element_item import KnowledgeGraphCarouselItemSerpElementItem
    from dataforseo_client.models.knowledge_graph_description_item_serp_element_item import KnowledgeGraphDescriptionItemSerpElementItem
    from dataforseo_client.models.knowledge_graph_expanded_item_serp_element_item import KnowledgeGraphExpandedItemSerpElementItem
    from dataforseo_client.models.knowledge_graph_hotels_booking_item_serp_element_item import KnowledgeGraphHotelsBookingItemSerpElementItem
    from dataforseo_client.models.knowledge_graph_images_item_serp_element_item import KnowledgeGraphImagesItemSerpElementItem
    from dataforseo_client.models.knowledge_graph_list_item_serp_element_item import KnowledgeGraphListItemSerpElementItem
    from dataforseo_client.models.knowledge_graph_part_item_serp_element_item import KnowledgeGraphPartItemSerpElementItem
    from dataforseo_client.models.knowledge_graph_row_item_serp_element_item import KnowledgeGraphRowItemSerpElementItem
    from dataforseo_client.models.knowledge_graph_shopping_item_serp_element_item import KnowledgeGraphShoppingItemSerpElementItem
    from dataforseo_client.models.local_pack_serp_element_item import LocalPackSerpElementItem
    from dataforseo_client.models.local_services_serp_element_item import LocalServicesSerpElementItem
    from dataforseo_client.models.map_serp_element_item import MapSerpElementItem
    from dataforseo_client.models.math_solver_serp_element_item import MathSolverSerpElementItem
    from dataforseo_client.models.mention_carousel_serp_element_item import MentionCarouselSerpElementItem
    from dataforseo_client.models.multi_carousel_serp_element_item import MultiCarouselSerpElementItem
    from dataforseo_client.models.organic_serp_element_item import OrganicSerpElementItem
    from dataforseo_client.models.paid_serp_element_item import PaidSerpElementItem
    from dataforseo_client.models.people_also_ask_serp_element_item import PeopleAlsoAskSerpElementItem
    from dataforseo_client.models.people_also_search_serp_element_item import PeopleAlsoSearchSerpElementItem
    from dataforseo_client.models.perspectives_serp_element_item import PerspectivesSerpElementItem
    from dataforseo_client.models.podcasts_serp_element_item import PodcastsSerpElementItem
    from dataforseo_client.models.popular_products_serp_element_item import PopularProductsSerpElementItem
    from dataforseo_client.models.product_considerations_serp_element_item import ProductConsiderationsSerpElementItem
    from dataforseo_client.models.questions_and_answers_serp_element_item import QuestionsAndAnswersSerpElementItem
    from dataforseo_client.models.recipes_serp_element_item import RecipesSerpElementItem
    from dataforseo_client.models.refine_products_serp_element_item import RefineProductsSerpElementItem
    from dataforseo_client.models.related_searches_serp_element_item import RelatedSearchesSerpElementItem
    from dataforseo_client.models.scholarly_articles_serp_element_item import ScholarlyArticlesSerpElementItem
    from dataforseo_client.models.shopping_serp_element_item import ShoppingSerpElementItem
    from dataforseo_client.models.short_videos_serp_element_item import ShortVideosSerpElementItem
    from dataforseo_client.models.stocks_box_serp_element_item import StocksBoxSerpElementItem
    from dataforseo_client.models.top_sights_serp_element_item import TopSightsSerpElementItem
    from dataforseo_client.models.top_stories_serp_element_item import TopStoriesSerpElementItem
    from dataforseo_client.models.twitter_serp_element_item import TwitterSerpElementItem
    from dataforseo_client.models.video_serp_element_item import VideoSerpElementItem
    from dataforseo_client.models.visual_stories_serp_element_item import VisualStoriesSerpElementItem

class BaseSerpElementItem(BaseModel):
    """
    BaseSerpElementItem
    """ # noqa: E501
    type: Optional[StrictStr] = Field(default=None, description="type of element")
    rank_group: Optional[StrictInt] = Field(default=None, description="group rank in SERP position within a group of elements with identical type values positions of elements with different type values are omitted from rank_group")
    rank_absolute: Optional[StrictInt] = Field(default=None, description="absolute rank in SERP absolute position among all the elements in SERP")
    position: Optional[StrictStr] = Field(default=None, description="the alignment of the element in SERP can take the following values: left, right")
    xpath: Optional[StrictStr] = Field(default=None, description="the XPath of the element")
    __properties: ClassVar[List[str]] = ["type", "rank_group", "rank_absolute", "position", "xpath"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = 'type'

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        'ai_overview': 'AiOverviewSerpElementItem','answer_box': 'QAnswerBoxSerpElementItem','app': 'DataAppSerpElementItem','carousel': 'CarouselSerpElementItem','commercial_units': 'CommercialUnitsSerpElementItem','compare_sites': 'CompareSitesSerpElementItem','courses': 'CoursesSerpElementItem','currency_box': 'CurrencyBoxSerpElementItem','dictionary': 'DictionarySerpElementItem','discussions_and_forums': 'DiscussionsAndForumsSerpElementItem','event_item': 'EventItemSerpElementItem','events': 'EventsSerpElementItem','explore_brands': 'ExploreBrandsSerpElementItem','featured_snippet': 'FeaturedSnippetSerpElementItem','find_results_on': 'FindResultsOnSerpElementItem','found_on_web': 'FoundOnWebSerpElementItem','google_flights': 'GoogleFlightsSerpElementItem','google_hotels': 'GoogleHotelsSerpElementItem','google_posts': 'GooglePostsSerpElementItem','google_reviews': 'GoogleReviewsSerpElementItem','hotels_pack': 'HotelsPackSerpElementItem','images': 'ImagesSerpElementItem','jobs': 'JobsSerpElementItem','knowledge_graph': 'KnowledgeGraphSerpElementItem','knowledge_graph_ai_overview_item': 'KnowledgeGraphAiOverviewItemSerpElementItem','knowledge_graph_carousel_item': 'KnowledgeGraphCarouselItemSerpElementItem','knowledge_graph_description_item': 'KnowledgeGraphDescriptionItemSerpElementItem','knowledge_graph_expanded_item': 'KnowledgeGraphExpandedItemSerpElementItem','knowledge_graph_hotels_booking_item': 'KnowledgeGraphHotelsBookingItemSerpElementItem','knowledge_graph_images_item': 'KnowledgeGraphImagesItemSerpElementItem','knowledge_graph_list_item': 'KnowledgeGraphListItemSerpElementItem','knowledge_graph_part_item': 'KnowledgeGraphPartItemSerpElementItem','knowledge_graph_row_item': 'KnowledgeGraphRowItemSerpElementItem','knowledge_graph_shopping_item': 'KnowledgeGraphShoppingItemSerpElementItem','local_pack': 'LocalPackSerpElementItem','local_services': 'LocalServicesSerpElementItem','map': 'MapSerpElementItem','math_solver': 'MathSolverSerpElementItem','mention_carousel': 'MentionCarouselSerpElementItem','multi_carousel': 'MultiCarouselSerpElementItem','organic': 'OrganicSerpElementItem','paid': 'PaidSerpElementItem','people_also_ask': 'PeopleAlsoAskSerpElementItem','people_also_search': 'PeopleAlsoSearchSerpElementItem','perspectives': 'PerspectivesSerpElementItem','podcasts': 'PodcastsSerpElementItem','popular_products': 'PopularProductsSerpElementItem','product_considerations': 'ProductConsiderationsSerpElementItem','questions_and_answers': 'QuestionsAndAnswersSerpElementItem','recipes': 'RecipesSerpElementItem','refine_products': 'RefineProductsSerpElementItem','related_searches': 'RelatedSearchesSerpElementItem','scholarly_articles': 'ScholarlyArticlesSerpElementItem','shopping': 'ShoppingSerpElementItem','short_videos': 'ShortVideosSerpElementItem','stocks_box': 'StocksBoxSerpElementItem','top_sights': 'TopSightsSerpElementItem','top_stories': 'TopStoriesSerpElementItem','twitter': 'TwitterSerpElementItem','video': 'VideoSerpElementItem','visual_stories': 'VisualStoriesSerpElementItem'
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Union[AiOverviewSerpElementItem, QAnswerBoxSerpElementItem, DataAppSerpElementItem, CarouselSerpElementItem, CommercialUnitsSerpElementItem, CompareSitesSerpElementItem, CoursesSerpElementItem, CurrencyBoxSerpElementItem, DictionarySerpElementItem, DiscussionsAndForumsSerpElementItem, EventItemSerpElementItem, EventsSerpElementItem, ExploreBrandsSerpElementItem, FeaturedSnippetSerpElementItem, FindResultsOnSerpElementItem, FoundOnWebSerpElementItem, GoogleFlightsSerpElementItem, GoogleHotelsSerpElementItem, GooglePostsSerpElementItem, GoogleReviewsSerpElementItem, HotelsPackSerpElementItem, ImagesSerpElementItem, JobsSerpElementItem, KnowledgeGraphSerpElementItem, KnowledgeGraphAiOverviewItemSerpElementItem, KnowledgeGraphCarouselItemSerpElementItem, KnowledgeGraphDescriptionItemSerpElementItem, KnowledgeGraphExpandedItemSerpElementItem, KnowledgeGraphHotelsBookingItemSerpElementItem, KnowledgeGraphImagesItemSerpElementItem, KnowledgeGraphListItemSerpElementItem, KnowledgeGraphPartItemSerpElementItem, KnowledgeGraphRowItemSerpElementItem, KnowledgeGraphShoppingItemSerpElementItem, LocalPackSerpElementItem, LocalServicesSerpElementItem, MapSerpElementItem, MathSolverSerpElementItem, MentionCarouselSerpElementItem, MultiCarouselSerpElementItem, OrganicSerpElementItem, PaidSerpElementItem, PeopleAlsoAskSerpElementItem, PeopleAlsoSearchSerpElementItem, PerspectivesSerpElementItem, PodcastsSerpElementItem, PopularProductsSerpElementItem, ProductConsiderationsSerpElementItem, QuestionsAndAnswersSerpElementItem, RecipesSerpElementItem, RefineProductsSerpElementItem, RelatedSearchesSerpElementItem, ScholarlyArticlesSerpElementItem, ShoppingSerpElementItem, ShortVideosSerpElementItem, StocksBoxSerpElementItem, TopSightsSerpElementItem, TopStoriesSerpElementItem, TwitterSerpElementItem, VideoSerpElementItem, VisualStoriesSerpElementItem]]:
        """Create an instance of BaseSerpElementItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if rank_group (nullable) is None
        # and model_fields_set contains the field
        if self.rank_group is None and "rank_group" in self.model_fields_set:
            _dict['rank_group'] = None

        # set to None if rank_absolute (nullable) is None
        # and model_fields_set contains the field
        if self.rank_absolute is None and "rank_absolute" in self.model_fields_set:
            _dict['rank_absolute'] = None

        # set to None if position (nullable) is None
        # and model_fields_set contains the field
        if self.position is None and "position" in self.model_fields_set:
            _dict['position'] = None

        # set to None if xpath (nullable) is None
        # and model_fields_set contains the field
        if self.xpath is None and "xpath" in self.model_fields_set:
            _dict['xpath'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Optional[Union[AiOverviewSerpElementItem, QAnswerBoxSerpElementItem, DataAppSerpElementItem, CarouselSerpElementItem, CommercialUnitsSerpElementItem, CompareSitesSerpElementItem, CoursesSerpElementItem, CurrencyBoxSerpElementItem, DictionarySerpElementItem, DiscussionsAndForumsSerpElementItem, EventItemSerpElementItem, EventsSerpElementItem, ExploreBrandsSerpElementItem, FeaturedSnippetSerpElementItem, FindResultsOnSerpElementItem, FoundOnWebSerpElementItem, GoogleFlightsSerpElementItem, GoogleHotelsSerpElementItem, GooglePostsSerpElementItem, GoogleReviewsSerpElementItem, HotelsPackSerpElementItem, ImagesSerpElementItem, JobsSerpElementItem, KnowledgeGraphSerpElementItem, KnowledgeGraphAiOverviewItemSerpElementItem, KnowledgeGraphCarouselItemSerpElementItem, KnowledgeGraphDescriptionItemSerpElementItem, KnowledgeGraphExpandedItemSerpElementItem, KnowledgeGraphHotelsBookingItemSerpElementItem, KnowledgeGraphImagesItemSerpElementItem, KnowledgeGraphListItemSerpElementItem, KnowledgeGraphPartItemSerpElementItem, KnowledgeGraphRowItemSerpElementItem, KnowledgeGraphShoppingItemSerpElementItem, LocalPackSerpElementItem, LocalServicesSerpElementItem, MapSerpElementItem, MathSolverSerpElementItem, MentionCarouselSerpElementItem, MultiCarouselSerpElementItem, OrganicSerpElementItem, PaidSerpElementItem, PeopleAlsoAskSerpElementItem, PeopleAlsoSearchSerpElementItem, PerspectivesSerpElementItem, PodcastsSerpElementItem, PopularProductsSerpElementItem, ProductConsiderationsSerpElementItem, QuestionsAndAnswersSerpElementItem, RecipesSerpElementItem, RefineProductsSerpElementItem, RelatedSearchesSerpElementItem, ScholarlyArticlesSerpElementItem, ShoppingSerpElementItem, ShortVideosSerpElementItem, StocksBoxSerpElementItem, TopSightsSerpElementItem, TopStoriesSerpElementItem, TwitterSerpElementItem, VideoSerpElementItem, VisualStoriesSerpElementItem]]:
        """Create an instance of BaseSerpElementItem from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type ==  'AiOverviewSerpElementItem':
            return import_module("dataforseo_client.models.ai_overview_serp_element_item").AiOverviewSerpElementItem.from_dict(obj)
        if object_type ==  'QAnswerBoxSerpElementItem':
            return import_module("dataforseo_client.models.q_answer_box_serp_element_item").QAnswerBoxSerpElementItem.from_dict(obj)
        if object_type ==  'DataAppSerpElementItem':
            return import_module("dataforseo_client.models.data_app_serp_element_item").DataAppSerpElementItem.from_dict(obj)
        if object_type ==  'CarouselSerpElementItem':
            return import_module("dataforseo_client.models.carousel_serp_element_item").CarouselSerpElementItem.from_dict(obj)
        if object_type ==  'CommercialUnitsSerpElementItem':
            return import_module("dataforseo_client.models.commercial_units_serp_element_item").CommercialUnitsSerpElementItem.from_dict(obj)
        if object_type ==  'CompareSitesSerpElementItem':
            return import_module("dataforseo_client.models.compare_sites_serp_element_item").CompareSitesSerpElementItem.from_dict(obj)
        if object_type ==  'CoursesSerpElementItem':
            return import_module("dataforseo_client.models.courses_serp_element_item").CoursesSerpElementItem.from_dict(obj)
        if object_type ==  'CurrencyBoxSerpElementItem':
            return import_module("dataforseo_client.models.currency_box_serp_element_item").CurrencyBoxSerpElementItem.from_dict(obj)
        if object_type ==  'DictionarySerpElementItem':
            return import_module("dataforseo_client.models.dictionary_serp_element_item").DictionarySerpElementItem.from_dict(obj)
        if object_type ==  'DiscussionsAndForumsSerpElementItem':
            return import_module("dataforseo_client.models.discussions_and_forums_serp_element_item").DiscussionsAndForumsSerpElementItem.from_dict(obj)
        if object_type ==  'EventItemSerpElementItem':
            return import_module("dataforseo_client.models.event_item_serp_element_item").EventItemSerpElementItem.from_dict(obj)
        if object_type ==  'EventsSerpElementItem':
            return import_module("dataforseo_client.models.events_serp_element_item").EventsSerpElementItem.from_dict(obj)
        if object_type ==  'ExploreBrandsSerpElementItem':
            return import_module("dataforseo_client.models.explore_brands_serp_element_item").ExploreBrandsSerpElementItem.from_dict(obj)
        if object_type ==  'FeaturedSnippetSerpElementItem':
            return import_module("dataforseo_client.models.featured_snippet_serp_element_item").FeaturedSnippetSerpElementItem.from_dict(obj)
        if object_type ==  'FindResultsOnSerpElementItem':
            return import_module("dataforseo_client.models.find_results_on_serp_element_item").FindResultsOnSerpElementItem.from_dict(obj)
        if object_type ==  'FoundOnWebSerpElementItem':
            return import_module("dataforseo_client.models.found_on_web_serp_element_item").FoundOnWebSerpElementItem.from_dict(obj)
        if object_type ==  'GoogleFlightsSerpElementItem':
            return import_module("dataforseo_client.models.google_flights_serp_element_item").GoogleFlightsSerpElementItem.from_dict(obj)
        if object_type ==  'GoogleHotelsSerpElementItem':
            return import_module("dataforseo_client.models.google_hotels_serp_element_item").GoogleHotelsSerpElementItem.from_dict(obj)
        if object_type ==  'GooglePostsSerpElementItem':
            return import_module("dataforseo_client.models.google_posts_serp_element_item").GooglePostsSerpElementItem.from_dict(obj)
        if object_type ==  'GoogleReviewsSerpElementItem':
            return import_module("dataforseo_client.models.google_reviews_serp_element_item").GoogleReviewsSerpElementItem.from_dict(obj)
        if object_type ==  'HotelsPackSerpElementItem':
            return import_module("dataforseo_client.models.hotels_pack_serp_element_item").HotelsPackSerpElementItem.from_dict(obj)
        if object_type ==  'ImagesSerpElementItem':
            return import_module("dataforseo_client.models.images_serp_element_item").ImagesSerpElementItem.from_dict(obj)
        if object_type ==  'JobsSerpElementItem':
            return import_module("dataforseo_client.models.jobs_serp_element_item").JobsSerpElementItem.from_dict(obj)
        if object_type ==  'KnowledgeGraphSerpElementItem':
            return import_module("dataforseo_client.models.knowledge_graph_serp_element_item").KnowledgeGraphSerpElementItem.from_dict(obj)
        if object_type ==  'KnowledgeGraphAiOverviewItemSerpElementItem':
            return import_module("dataforseo_client.models.knowledge_graph_ai_overview_item_serp_element_item").KnowledgeGraphAiOverviewItemSerpElementItem.from_dict(obj)
        if object_type ==  'KnowledgeGraphCarouselItemSerpElementItem':
            return import_module("dataforseo_client.models.knowledge_graph_carousel_item_serp_element_item").KnowledgeGraphCarouselItemSerpElementItem.from_dict(obj)
        if object_type ==  'KnowledgeGraphDescriptionItemSerpElementItem':
            return import_module("dataforseo_client.models.knowledge_graph_description_item_serp_element_item").KnowledgeGraphDescriptionItemSerpElementItem.from_dict(obj)
        if object_type ==  'KnowledgeGraphExpandedItemSerpElementItem':
            return import_module("dataforseo_client.models.knowledge_graph_expanded_item_serp_element_item").KnowledgeGraphExpandedItemSerpElementItem.from_dict(obj)
        if object_type ==  'KnowledgeGraphHotelsBookingItemSerpElementItem':
            return import_module("dataforseo_client.models.knowledge_graph_hotels_booking_item_serp_element_item").KnowledgeGraphHotelsBookingItemSerpElementItem.from_dict(obj)
        if object_type ==  'KnowledgeGraphImagesItemSerpElementItem':
            return import_module("dataforseo_client.models.knowledge_graph_images_item_serp_element_item").KnowledgeGraphImagesItemSerpElementItem.from_dict(obj)
        if object_type ==  'KnowledgeGraphListItemSerpElementItem':
            return import_module("dataforseo_client.models.knowledge_graph_list_item_serp_element_item").KnowledgeGraphListItemSerpElementItem.from_dict(obj)
        if object_type ==  'KnowledgeGraphPartItemSerpElementItem':
            return import_module("dataforseo_client.models.knowledge_graph_part_item_serp_element_item").KnowledgeGraphPartItemSerpElementItem.from_dict(obj)
        if object_type ==  'KnowledgeGraphRowItemSerpElementItem':
            return import_module("dataforseo_client.models.knowledge_graph_row_item_serp_element_item").KnowledgeGraphRowItemSerpElementItem.from_dict(obj)
        if object_type ==  'KnowledgeGraphShoppingItemSerpElementItem':
            return import_module("dataforseo_client.models.knowledge_graph_shopping_item_serp_element_item").KnowledgeGraphShoppingItemSerpElementItem.from_dict(obj)
        if object_type ==  'LocalPackSerpElementItem':
            return import_module("dataforseo_client.models.local_pack_serp_element_item").LocalPackSerpElementItem.from_dict(obj)
        if object_type ==  'LocalServicesSerpElementItem':
            return import_module("dataforseo_client.models.local_services_serp_element_item").LocalServicesSerpElementItem.from_dict(obj)
        if object_type ==  'MapSerpElementItem':
            return import_module("dataforseo_client.models.map_serp_element_item").MapSerpElementItem.from_dict(obj)
        if object_type ==  'MathSolverSerpElementItem':
            return import_module("dataforseo_client.models.math_solver_serp_element_item").MathSolverSerpElementItem.from_dict(obj)
        if object_type ==  'MentionCarouselSerpElementItem':
            return import_module("dataforseo_client.models.mention_carousel_serp_element_item").MentionCarouselSerpElementItem.from_dict(obj)
        if object_type ==  'MultiCarouselSerpElementItem':
            return import_module("dataforseo_client.models.multi_carousel_serp_element_item").MultiCarouselSerpElementItem.from_dict(obj)
        if object_type ==  'OrganicSerpElementItem':
            return import_module("dataforseo_client.models.organic_serp_element_item").OrganicSerpElementItem.from_dict(obj)
        if object_type ==  'PaidSerpElementItem':
            return import_module("dataforseo_client.models.paid_serp_element_item").PaidSerpElementItem.from_dict(obj)
        if object_type ==  'PeopleAlsoAskSerpElementItem':
            return import_module("dataforseo_client.models.people_also_ask_serp_element_item").PeopleAlsoAskSerpElementItem.from_dict(obj)
        if object_type ==  'PeopleAlsoSearchSerpElementItem':
            return import_module("dataforseo_client.models.people_also_search_serp_element_item").PeopleAlsoSearchSerpElementItem.from_dict(obj)
        if object_type ==  'PerspectivesSerpElementItem':
            return import_module("dataforseo_client.models.perspectives_serp_element_item").PerspectivesSerpElementItem.from_dict(obj)
        if object_type ==  'PodcastsSerpElementItem':
            return import_module("dataforseo_client.models.podcasts_serp_element_item").PodcastsSerpElementItem.from_dict(obj)
        if object_type ==  'PopularProductsSerpElementItem':
            return import_module("dataforseo_client.models.popular_products_serp_element_item").PopularProductsSerpElementItem.from_dict(obj)
        if object_type ==  'ProductConsiderationsSerpElementItem':
            return import_module("dataforseo_client.models.product_considerations_serp_element_item").ProductConsiderationsSerpElementItem.from_dict(obj)
        if object_type ==  'QuestionsAndAnswersSerpElementItem':
            return import_module("dataforseo_client.models.questions_and_answers_serp_element_item").QuestionsAndAnswersSerpElementItem.from_dict(obj)
        if object_type ==  'RecipesSerpElementItem':
            return import_module("dataforseo_client.models.recipes_serp_element_item").RecipesSerpElementItem.from_dict(obj)
        if object_type ==  'RefineProductsSerpElementItem':
            return import_module("dataforseo_client.models.refine_products_serp_element_item").RefineProductsSerpElementItem.from_dict(obj)
        if object_type ==  'RelatedSearchesSerpElementItem':
            return import_module("dataforseo_client.models.related_searches_serp_element_item").RelatedSearchesSerpElementItem.from_dict(obj)
        if object_type ==  'ScholarlyArticlesSerpElementItem':
            return import_module("dataforseo_client.models.scholarly_articles_serp_element_item").ScholarlyArticlesSerpElementItem.from_dict(obj)
        if object_type ==  'ShoppingSerpElementItem':
            return import_module("dataforseo_client.models.shopping_serp_element_item").ShoppingSerpElementItem.from_dict(obj)
        if object_type ==  'ShortVideosSerpElementItem':
            return import_module("dataforseo_client.models.short_videos_serp_element_item").ShortVideosSerpElementItem.from_dict(obj)
        if object_type ==  'StocksBoxSerpElementItem':
            return import_module("dataforseo_client.models.stocks_box_serp_element_item").StocksBoxSerpElementItem.from_dict(obj)
        if object_type ==  'TopSightsSerpElementItem':
            return import_module("dataforseo_client.models.top_sights_serp_element_item").TopSightsSerpElementItem.from_dict(obj)
        if object_type ==  'TopStoriesSerpElementItem':
            return import_module("dataforseo_client.models.top_stories_serp_element_item").TopStoriesSerpElementItem.from_dict(obj)
        if object_type ==  'TwitterSerpElementItem':
            return import_module("dataforseo_client.models.twitter_serp_element_item").TwitterSerpElementItem.from_dict(obj)
        if object_type ==  'VideoSerpElementItem':
            return import_module("dataforseo_client.models.video_serp_element_item").VideoSerpElementItem.from_dict(obj)
        if object_type ==  'VisualStoriesSerpElementItem':
            return import_module("dataforseo_client.models.visual_stories_serp_element_item").VisualStoriesSerpElementItem.from_dict(obj)

        raise ValueError("BaseSerpElementItem failed to lookup discriminator value from " +
                            json.dumps(obj) + ". Discriminator property name: " + cls.__discriminator_property_name +
                            ", mapping: " + json.dumps(cls.__discriminator_value_class_map))


