# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.available_languages import AvailableLanguages
from typing import Optional, Set
from typing_extensions import Self

class DataforseoLabsLocationsAndLanguagesResultInfo(BaseModel):
    """
    DataforseoLabsLocationsAndLanguagesResultInfo
    """ # noqa: E501
    location_code: Optional[StrictInt] = Field(default=None, description="location code")
    location_name: Optional[StrictStr] = Field(default=None, description="full name of the location")
    location_code_parent: Optional[StrictInt] = Field(default=None, description="the code of the superordinate location the value will be null as Country is the only supported location_type for this API")
    country_iso_code: Optional[StrictStr] = Field(default=None, description="ISO country code of the location")
    location_type: Optional[StrictStr] = Field(default=None, description="location type possible values: Country")
    available_languages: Optional[List[AvailableLanguages]] = Field(default=None, description="supported languages contains the languages which are supported for a specific location")
    __properties: ClassVar[List[str]] = ["location_code", "location_name", "location_code_parent", "country_iso_code", "location_type", "available_languages"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DataforseoLabsLocationsAndLanguagesResultInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in available_languages (list)
        _items = []
        if self.available_languages:
            for _item_available_languages in self.available_languages:
                if _item_available_languages:
                    _items.append(_item_available_languages.to_dict())
            _dict['available_languages'] = _items
        # set to None if location_name (nullable) is None
        # and model_fields_set contains the field
        if self.location_name is None and "location_name" in self.model_fields_set:
            _dict['location_name'] = None

        # set to None if location_code_parent (nullable) is None
        # and model_fields_set contains the field
        if self.location_code_parent is None and "location_code_parent" in self.model_fields_set:
            _dict['location_code_parent'] = None

        # set to None if country_iso_code (nullable) is None
        # and model_fields_set contains the field
        if self.country_iso_code is None and "country_iso_code" in self.model_fields_set:
            _dict['country_iso_code'] = None

        # set to None if location_type (nullable) is None
        # and model_fields_set contains the field
        if self.location_type is None and "location_type" in self.model_fields_set:
            _dict['location_type'] = None

        # set to None if available_languages (nullable) is None
        # and model_fields_set contains the field
        if self.available_languages is None and "available_languages" in self.model_fields_set:
            _dict['available_languages'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DataforseoLabsLocationsAndLanguagesResultInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "location_code": obj.get("location_code"),
            "location_name": obj.get("location_name"),
            "location_code_parent": obj.get("location_code_parent"),
            "country_iso_code": obj.get("country_iso_code"),
            "location_type": obj.get("location_type"),
            "available_languages": [AvailableLanguages.from_dict(_item) for _item in obj["available_languages"]] if obj.get("available_languages") is not None else None
        })
        return _obj


