# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class DomainAnalyticsTechnologiesAvailableFiltersResultInfo(BaseModel):
    """
    DomainAnalyticsTechnologiesAvailableFiltersResultInfo
    """ # noqa: E501
    domains_by_technology: Optional[Dict[str, Optional[StrictStr]]] = None
    aggregation_technologies: Optional[Dict[str, Optional[StrictStr]]] = None
    technologies_summary: Optional[Dict[str, Optional[StrictStr]]] = None
    domains_by_html_terms: Optional[Dict[str, Optional[StrictStr]]] = None
    __properties: ClassVar[List[str]] = ["domains_by_technology", "aggregation_technologies", "technologies_summary", "domains_by_html_terms"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DomainAnalyticsTechnologiesAvailableFiltersResultInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if domains_by_technology (nullable) is None
        # and model_fields_set contains the field
        if self.domains_by_technology is None and "domains_by_technology" in self.model_fields_set:
            _dict['domains_by_technology'] = None

        # set to None if aggregation_technologies (nullable) is None
        # and model_fields_set contains the field
        if self.aggregation_technologies is None and "aggregation_technologies" in self.model_fields_set:
            _dict['aggregation_technologies'] = None

        # set to None if technologies_summary (nullable) is None
        # and model_fields_set contains the field
        if self.technologies_summary is None and "technologies_summary" in self.model_fields_set:
            _dict['technologies_summary'] = None

        # set to None if domains_by_html_terms (nullable) is None
        # and model_fields_set contains the field
        if self.domains_by_html_terms is None and "domains_by_html_terms" in self.model_fields_set:
            _dict['domains_by_html_terms'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DomainAnalyticsTechnologiesAvailableFiltersResultInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "domains_by_technology": obj.get("domains_by_technology"),
            "aggregation_technologies": obj.get("aggregation_technologies"),
            "technologies_summary": obj.get("technologies_summary"),
            "domains_by_html_terms": obj.get("domains_by_html_terms")
        })
        return _obj


