# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.backlinks_info import BacklinksInfo
from dataforseo_client.models.metrics_bundle_info import MetricsBundleInfo
from typing import Optional, Set
from typing_extensions import Self

class DomainAnalyticsWhoisOverviewLiveItem(BaseModel):
    """
    items array
    """ # noqa: E501
    domain: Optional[StrictStr] = Field(default=None, description="domain name")
    created_datetime: Optional[StrictStr] = Field(default=None, description="date and time of registration date and time (in the ISO 8601 format) when the domain was first registered example: \"1997-03-29 03:00:00 +00:00\"")
    changed_datetime: Optional[StrictStr] = Field(default=None, description="date and time when the domain entry was changed date and time (in the ISO 8601 format) when the domain entry was last modified example: \"2021-01-14 08:36:28 +00:00\"")
    expiration_datetime: Optional[StrictStr] = Field(default=None, description="date and time when the domain will expire date and time (in the ISO 8601 format) when the domain is due to expire example: \"2022-11-26 17:21:23 +00:00\"")
    updated_datetime: Optional[StrictStr] = Field(default=None, description="date and time when the domain was updated date and time (in the ISO 8601 format) when the domain was last updated example: \"2021-01-29 13:59:38 +00:00\"")
    first_seen: Optional[StrictStr] = Field(default=None, description="date and time when our crawler found the domain for the first time in the UTC format: “yyyy-mm-dd hh-mm-ss +00:00” example: \"2019-11-15 12:57:46 +00:00\"")
    epp_status_codes: Optional[List[Optional[StrictStr]]] = Field(default=None, description="extensive provisioning protocol status codes the status of a domain name registration as defined by ICANN")
    tld: Optional[StrictStr] = Field(default=None, description="top-level domain top-level domain in the DNS root zone")
    registered: Optional[StrictBool] = Field(default=None, description="domain registration status if false, the domain name registration has expired Note: expired domains will remain in the database for only a short period of time")
    registrar: Optional[StrictStr] = Field(default=None, description="domain registrar if null, the domain registrar is unknown example: NameCheap, Inc.")
    metrics: Optional[MetricsBundleInfo] = None
    backlinks_info: Optional[BacklinksInfo] = None
    __properties: ClassVar[List[str]] = ["domain", "created_datetime", "changed_datetime", "expiration_datetime", "updated_datetime", "first_seen", "epp_status_codes", "tld", "registered", "registrar", "metrics", "backlinks_info"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DomainAnalyticsWhoisOverviewLiveItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of metrics
        if self.metrics:
            _dict['metrics'] = self.metrics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of backlinks_info
        if self.backlinks_info:
            _dict['backlinks_info'] = self.backlinks_info.to_dict()
        # set to None if domain (nullable) is None
        # and model_fields_set contains the field
        if self.domain is None and "domain" in self.model_fields_set:
            _dict['domain'] = None

        # set to None if created_datetime (nullable) is None
        # and model_fields_set contains the field
        if self.created_datetime is None and "created_datetime" in self.model_fields_set:
            _dict['created_datetime'] = None

        # set to None if changed_datetime (nullable) is None
        # and model_fields_set contains the field
        if self.changed_datetime is None and "changed_datetime" in self.model_fields_set:
            _dict['changed_datetime'] = None

        # set to None if expiration_datetime (nullable) is None
        # and model_fields_set contains the field
        if self.expiration_datetime is None and "expiration_datetime" in self.model_fields_set:
            _dict['expiration_datetime'] = None

        # set to None if updated_datetime (nullable) is None
        # and model_fields_set contains the field
        if self.updated_datetime is None and "updated_datetime" in self.model_fields_set:
            _dict['updated_datetime'] = None

        # set to None if first_seen (nullable) is None
        # and model_fields_set contains the field
        if self.first_seen is None and "first_seen" in self.model_fields_set:
            _dict['first_seen'] = None

        # set to None if epp_status_codes (nullable) is None
        # and model_fields_set contains the field
        if self.epp_status_codes is None and "epp_status_codes" in self.model_fields_set:
            _dict['epp_status_codes'] = None

        # set to None if tld (nullable) is None
        # and model_fields_set contains the field
        if self.tld is None and "tld" in self.model_fields_set:
            _dict['tld'] = None

        # set to None if registered (nullable) is None
        # and model_fields_set contains the field
        if self.registered is None and "registered" in self.model_fields_set:
            _dict['registered'] = None

        # set to None if registrar (nullable) is None
        # and model_fields_set contains the field
        if self.registrar is None and "registrar" in self.model_fields_set:
            _dict['registrar'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DomainAnalyticsWhoisOverviewLiveItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "domain": obj.get("domain"),
            "created_datetime": obj.get("created_datetime"),
            "changed_datetime": obj.get("changed_datetime"),
            "expiration_datetime": obj.get("expiration_datetime"),
            "updated_datetime": obj.get("updated_datetime"),
            "first_seen": obj.get("first_seen"),
            "epp_status_codes": obj.get("epp_status_codes"),
            "tld": obj.get("tld"),
            "registered": obj.get("registered"),
            "registrar": obj.get("registrar"),
            "metrics": MetricsBundleInfo.from_dict(obj["metrics"]) if obj.get("metrics") is not None else None,
            "backlinks_info": BacklinksInfo.from_dict(obj["backlinks_info"]) if obj.get("backlinks_info") is not None else None
        })
        return _obj


