# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from dataforseo_client.models.delivery_info import DeliveryInfo
from dataforseo_client.models.rating_element import RatingElement
from typing import Optional, Set
from typing_extensions import Self

class GoogleShoppingSponsoredCarouselElement(BaseModel):
    """
    GoogleShoppingSponsoredCarouselElement
    """ # noqa: E501
    type: Optional[StrictStr] = Field(default=None, description="type of element")
    xpath: Optional[StrictStr] = Field(default=None, description="XPath of the element")
    title: Optional[StrictStr] = Field(default=None, description="product title")
    tags: Optional[List[Optional[StrictStr]]] = Field(default=None, description="tags assigned to the product")
    seller: Optional[StrictStr] = Field(default=None, description="name of the seller the name of the company that placed a corresponding product on Google Shopping")
    price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="product price example: 384.99")
    currency: Optional[StrictStr] = Field(default=None, description="currency in the ISO format example: USD")
    product_rating: Optional[RatingElement] = None
    product_images: Optional[List[Optional[StrictStr]]] = Field(default=None, description="URLs to the images of the product the first URL in the array is the featured image of the product")
    shop_ad_aclk: Optional[StrictStr] = Field(default=None, description="unique ad click referral parameter using this parameter you can get a URL of the advertisement in Google Shopping Sellers Ad URL")
    delivery_info: Optional[DeliveryInfo] = None
    __properties: ClassVar[List[str]] = ["type", "xpath", "title", "tags", "seller", "price", "currency", "product_rating", "product_images", "shop_ad_aclk", "delivery_info"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GoogleShoppingSponsoredCarouselElement from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of product_rating
        if self.product_rating:
            _dict['product_rating'] = self.product_rating.to_dict()
        # override the default output from pydantic by calling `to_dict()` of delivery_info
        if self.delivery_info:
            _dict['delivery_info'] = self.delivery_info.to_dict()
        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if xpath (nullable) is None
        # and model_fields_set contains the field
        if self.xpath is None and "xpath" in self.model_fields_set:
            _dict['xpath'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if tags (nullable) is None
        # and model_fields_set contains the field
        if self.tags is None and "tags" in self.model_fields_set:
            _dict['tags'] = None

        # set to None if seller (nullable) is None
        # and model_fields_set contains the field
        if self.seller is None and "seller" in self.model_fields_set:
            _dict['seller'] = None

        # set to None if price (nullable) is None
        # and model_fields_set contains the field
        if self.price is None and "price" in self.model_fields_set:
            _dict['price'] = None

        # set to None if currency (nullable) is None
        # and model_fields_set contains the field
        if self.currency is None and "currency" in self.model_fields_set:
            _dict['currency'] = None

        # set to None if product_images (nullable) is None
        # and model_fields_set contains the field
        if self.product_images is None and "product_images" in self.model_fields_set:
            _dict['product_images'] = None

        # set to None if shop_ad_aclk (nullable) is None
        # and model_fields_set contains the field
        if self.shop_ad_aclk is None and "shop_ad_aclk" in self.model_fields_set:
            _dict['shop_ad_aclk'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GoogleShoppingSponsoredCarouselElement from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "xpath": obj.get("xpath"),
            "title": obj.get("title"),
            "tags": obj.get("tags"),
            "seller": obj.get("seller"),
            "price": obj.get("price"),
            "currency": obj.get("currency"),
            "product_rating": RatingElement.from_dict(obj["product_rating"]) if obj.get("product_rating") is not None else None,
            "product_images": obj.get("product_images"),
            "shop_ad_aclk": obj.get("shop_ad_aclk"),
            "delivery_info": DeliveryInfo.from_dict(obj["delivery_info"]) if obj.get("delivery_info") is not None else None
        })
        return _obj


