# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.hotel_info_price_offer import HotelInfoPriceOffer
from typing import Optional, Set
from typing_extensions import Self

class HotelPriceItemInfo(BaseModel):
    """
    HotelPriceItemInfo
    """ # noqa: E501
    type: Optional[StrictStr] = Field(default=None, description="type of element")
    title: Optional[StrictStr] = Field(default=None, description="title of the hotel")
    price: Optional[StrictInt] = Field(default=None, description="price per night")
    currency: Optional[StrictStr] = Field(default=None, description="price currency USD is applied by default, unless specified in the POST array")
    url: Optional[StrictStr] = Field(default=None, description="third-party page url URL to the third-party website page with pricing information")
    domain: Optional[StrictStr] = Field(default=None, description="third-party domain domain of the third-party website page with pricing information")
    is_paid: Optional[StrictBool] = Field(default=None, description="indicates a paid hotel listing if true, related hotel_search_item is a paid ad if false, related hotel_search_item is an organic hotel listing")
    free_cancellation_until: Optional[StrictStr] = Field(default=None, description="date until which free cancellation is available in the UTC format: “yyyy-mm-dd hh-mm-ss +00:00” equals null if free cancellation is not available for the selected dates")
    offers: Optional[List[HotelInfoPriceOffer]] = Field(default=None, description="featured price offers")
    __properties: ClassVar[List[str]] = ["type", "title", "price", "currency", "url", "domain", "is_paid", "free_cancellation_until", "offers"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HotelPriceItemInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in offers (list)
        _items = []
        if self.offers:
            for _item_offers in self.offers:
                if _item_offers:
                    _items.append(_item_offers.to_dict())
            _dict['offers'] = _items
        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if price (nullable) is None
        # and model_fields_set contains the field
        if self.price is None and "price" in self.model_fields_set:
            _dict['price'] = None

        # set to None if currency (nullable) is None
        # and model_fields_set contains the field
        if self.currency is None and "currency" in self.model_fields_set:
            _dict['currency'] = None

        # set to None if url (nullable) is None
        # and model_fields_set contains the field
        if self.url is None and "url" in self.model_fields_set:
            _dict['url'] = None

        # set to None if domain (nullable) is None
        # and model_fields_set contains the field
        if self.domain is None and "domain" in self.model_fields_set:
            _dict['domain'] = None

        # set to None if is_paid (nullable) is None
        # and model_fields_set contains the field
        if self.is_paid is None and "is_paid" in self.model_fields_set:
            _dict['is_paid'] = None

        # set to None if free_cancellation_until (nullable) is None
        # and model_fields_set contains the field
        if self.free_cancellation_until is None and "free_cancellation_until" in self.model_fields_set:
            _dict['free_cancellation_until'] = None

        # set to None if offers (nullable) is None
        # and model_fields_set contains the field
        if self.offers is None and "offers" in self.model_fields_set:
            _dict['offers'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HotelPriceItemInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "title": obj.get("title"),
            "price": obj.get("price"),
            "currency": obj.get("currency"),
            "url": obj.get("url"),
            "domain": obj.get("domain"),
            "is_paid": obj.get("is_paid"),
            "free_cancellation_until": obj.get("free_cancellation_until"),
            "offers": [HotelInfoPriceOffer.from_dict(_item) for _item in obj["offers"]] if obj.get("offers") is not None else None
        })
        return _obj


