# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ImpressionsInfo(BaseModel):
    """
    ImpressionsInfo
    """ # noqa: E501
    se_type: Optional[StrictStr] = Field(default=None, description="search engine type")
    last_updated_time: Optional[StrictStr] = Field(default=None, description="date and time when SERP data was updated in the UTC format: “yyyy-mm-dd hh-mm-ss +00:00” example: 2019-11-15 12:57:46 +00:00")
    bid: Optional[StrictInt] = Field(default=None, description="the maximum CPC it stands for the price you are willing to pay for an ad. The higher value, the higher positions and price you will getwe return the results for the 999 bid value to provide the highest number of impressions and level down the account-specific factors")
    match_type: Optional[StrictStr] = Field(default=None, description="type of keyword match can take the following values: exact, broad, phrase")
    ad_position_min: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="the minimum ad position represents the minimum position of the advertisement")
    ad_position_max: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="the maximum ad position represents the maximum position of the advertisement")
    ad_position_average: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="the average ad position represents the average position of the advertisement")
    cpc_min: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="the minimum value of cost-per-click the minimum cost-per-click (USD) for the keyword given that a bid is set to 999; note: this field does not represent an actual CPC value; you can find an actual CPC value for a keyword in the cpc field of the keyword_info object")
    cpc_max: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="the maximum value of cost-per-click the maximum cost-per-click (USD) for the keyword given that a bid is set to 999; note: this field does not represent an actual CPC value; you can find an actual CPC value for a keyword in the cpc field of the keyword_info object")
    cpc_average: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="the average value of cost-per-click the average cost-per-click (USD) for the keyword given that a bid is set to 999; note: this field does not represent an actual CPC value; you can find an actual CPC value for a keyword in the cpc field of the keyword_info object")
    daily_impressions_min: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="the minimum value of daily impressions represents the minimum number of daily impressions of the advertisement given that that a bid is set to 999; provides a more accurate alternative to Google search volume data")
    daily_impressions_max: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="the maximum value of daily impressions represents the maximum number of daily impressions of the advertisement given that that a bid is set to 999; provides a more accurate alternative to Google search volume data")
    daily_impressions_average: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="the average value of daily impressions represents the average number of daily impressions of the advertisement given that that a bid is set to 999; provides a more accurate alternative to Google search volume data")
    daily_clicks_min: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="the minimum value of daily clicks represents the minimum number of daily clicks on the advertisement")
    daily_clicks_max: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="the maximum value of daily clicks represents the maximum number of daily clicks on the advertisement")
    daily_clicks_average: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="the average value of daily clicks represents the average number of daily clicks on the advertisement")
    daily_cost_min: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="the minimum daily charge value represents the minimum daily cost of the advertisement (USD)")
    daily_cost_max: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="the maximum daily charge value represents the maximum daily cost of the advertisement (USD)")
    daily_cost_average: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="the average daily charge value represents the average daily cost of the advertisement (USD)")
    __properties: ClassVar[List[str]] = ["se_type", "last_updated_time", "bid", "match_type", "ad_position_min", "ad_position_max", "ad_position_average", "cpc_min", "cpc_max", "cpc_average", "daily_impressions_min", "daily_impressions_max", "daily_impressions_average", "daily_clicks_min", "daily_clicks_max", "daily_clicks_average", "daily_cost_min", "daily_cost_max", "daily_cost_average"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ImpressionsInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if se_type (nullable) is None
        # and model_fields_set contains the field
        if self.se_type is None and "se_type" in self.model_fields_set:
            _dict['se_type'] = None

        # set to None if last_updated_time (nullable) is None
        # and model_fields_set contains the field
        if self.last_updated_time is None and "last_updated_time" in self.model_fields_set:
            _dict['last_updated_time'] = None

        # set to None if bid (nullable) is None
        # and model_fields_set contains the field
        if self.bid is None and "bid" in self.model_fields_set:
            _dict['bid'] = None

        # set to None if match_type (nullable) is None
        # and model_fields_set contains the field
        if self.match_type is None and "match_type" in self.model_fields_set:
            _dict['match_type'] = None

        # set to None if ad_position_min (nullable) is None
        # and model_fields_set contains the field
        if self.ad_position_min is None and "ad_position_min" in self.model_fields_set:
            _dict['ad_position_min'] = None

        # set to None if ad_position_max (nullable) is None
        # and model_fields_set contains the field
        if self.ad_position_max is None and "ad_position_max" in self.model_fields_set:
            _dict['ad_position_max'] = None

        # set to None if ad_position_average (nullable) is None
        # and model_fields_set contains the field
        if self.ad_position_average is None and "ad_position_average" in self.model_fields_set:
            _dict['ad_position_average'] = None

        # set to None if cpc_min (nullable) is None
        # and model_fields_set contains the field
        if self.cpc_min is None and "cpc_min" in self.model_fields_set:
            _dict['cpc_min'] = None

        # set to None if cpc_max (nullable) is None
        # and model_fields_set contains the field
        if self.cpc_max is None and "cpc_max" in self.model_fields_set:
            _dict['cpc_max'] = None

        # set to None if cpc_average (nullable) is None
        # and model_fields_set contains the field
        if self.cpc_average is None and "cpc_average" in self.model_fields_set:
            _dict['cpc_average'] = None

        # set to None if daily_impressions_min (nullable) is None
        # and model_fields_set contains the field
        if self.daily_impressions_min is None and "daily_impressions_min" in self.model_fields_set:
            _dict['daily_impressions_min'] = None

        # set to None if daily_impressions_max (nullable) is None
        # and model_fields_set contains the field
        if self.daily_impressions_max is None and "daily_impressions_max" in self.model_fields_set:
            _dict['daily_impressions_max'] = None

        # set to None if daily_impressions_average (nullable) is None
        # and model_fields_set contains the field
        if self.daily_impressions_average is None and "daily_impressions_average" in self.model_fields_set:
            _dict['daily_impressions_average'] = None

        # set to None if daily_clicks_min (nullable) is None
        # and model_fields_set contains the field
        if self.daily_clicks_min is None and "daily_clicks_min" in self.model_fields_set:
            _dict['daily_clicks_min'] = None

        # set to None if daily_clicks_max (nullable) is None
        # and model_fields_set contains the field
        if self.daily_clicks_max is None and "daily_clicks_max" in self.model_fields_set:
            _dict['daily_clicks_max'] = None

        # set to None if daily_clicks_average (nullable) is None
        # and model_fields_set contains the field
        if self.daily_clicks_average is None and "daily_clicks_average" in self.model_fields_set:
            _dict['daily_clicks_average'] = None

        # set to None if daily_cost_min (nullable) is None
        # and model_fields_set contains the field
        if self.daily_cost_min is None and "daily_cost_min" in self.model_fields_set:
            _dict['daily_cost_min'] = None

        # set to None if daily_cost_max (nullable) is None
        # and model_fields_set contains the field
        if self.daily_cost_max is None and "daily_cost_max" in self.model_fields_set:
            _dict['daily_cost_max'] = None

        # set to None if daily_cost_average (nullable) is None
        # and model_fields_set contains the field
        if self.daily_cost_average is None and "daily_cost_average" in self.model_fields_set:
            _dict['daily_cost_average'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ImpressionsInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "se_type": obj.get("se_type"),
            "last_updated_time": obj.get("last_updated_time"),
            "bid": obj.get("bid"),
            "match_type": obj.get("match_type"),
            "ad_position_min": obj.get("ad_position_min"),
            "ad_position_max": obj.get("ad_position_max"),
            "ad_position_average": obj.get("ad_position_average"),
            "cpc_min": obj.get("cpc_min"),
            "cpc_max": obj.get("cpc_max"),
            "cpc_average": obj.get("cpc_average"),
            "daily_impressions_min": obj.get("daily_impressions_min"),
            "daily_impressions_max": obj.get("daily_impressions_max"),
            "daily_impressions_average": obj.get("daily_impressions_average"),
            "daily_clicks_min": obj.get("daily_clicks_min"),
            "daily_clicks_max": obj.get("daily_clicks_max"),
            "daily_clicks_average": obj.get("daily_clicks_average"),
            "daily_cost_min": obj.get("daily_cost_min"),
            "daily_cost_max": obj.get("daily_cost_max"),
            "daily_cost_average": obj.get("daily_cost_average")
        })
        return _obj


