# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.country_distribution import CountryDistribution
from typing import Optional, Set
from typing_extensions import Self

class KeywordsDataClickstreamDataGlobalSearchVolumeLiveItem(BaseModel):
    """
    KeywordsDataClickstreamDataGlobalSearchVolumeLiveItem
    """ # noqa: E501
    keyword: Optional[StrictStr] = Field(default=None, description="keyword keyword is returned with decoded %## (plus symbol ‘+’ will be decoded to a space character)")
    search_volume: Optional[StrictInt] = Field(default=None, description="clickstream-based average monthly search volume rate represents the (approximate) number of searches for the given keyword idea based on clickstream you can learn more about clickstream search volume in this Help Center article")
    country_distribution: Optional[List[CountryDistribution]] = Field(default=None, description="distribution of clickstream by countries represents clickstream-based search volume in available countries, as well as its respective percentage of global search volume")
    __properties: ClassVar[List[str]] = ["keyword", "search_volume", "country_distribution"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of KeywordsDataClickstreamDataGlobalSearchVolumeLiveItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in country_distribution (list)
        _items = []
        if self.country_distribution:
            for _item_country_distribution in self.country_distribution:
                if _item_country_distribution:
                    _items.append(_item_country_distribution.to_dict())
            _dict['country_distribution'] = _items
        # set to None if keyword (nullable) is None
        # and model_fields_set contains the field
        if self.keyword is None and "keyword" in self.model_fields_set:
            _dict['keyword'] = None

        # set to None if search_volume (nullable) is None
        # and model_fields_set contains the field
        if self.search_volume is None and "search_volume" in self.model_fields_set:
            _dict['search_volume'] = None

        # set to None if country_distribution (nullable) is None
        # and model_fields_set contains the field
        if self.country_distribution is None and "country_distribution" in self.model_fields_set:
            _dict['country_distribution'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of KeywordsDataClickstreamDataGlobalSearchVolumeLiveItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "keyword": obj.get("keyword"),
            "search_volume": obj.get("search_volume"),
            "country_distribution": [CountryDistribution.from_dict(_item) for _item in obj["country_distribution"]] if obj.get("country_distribution") is not None else None
        })
        return _obj


