# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class OnPageAvailableFiltersResultInfo(BaseModel):
    """
    OnPageAvailableFiltersResultInfo
    """ # noqa: E501
    resources: Optional[Dict[str, Optional[StrictStr]]] = None
    pages: Optional[Dict[str, Optional[StrictStr]]] = None
    non_indexable: Optional[Dict[str, Optional[StrictStr]]] = None
    links: Optional[Dict[str, Optional[StrictStr]]] = None
    pages_by_resource: Optional[Dict[str, Optional[StrictStr]]] = None
    redirect_chains: Optional[Dict[str, Optional[StrictStr]]] = None
    keyword_density: Optional[Dict[str, Optional[StrictStr]]] = None
    __properties: ClassVar[List[str]] = ["resources", "pages", "non_indexable", "links", "pages_by_resource", "redirect_chains", "keyword_density"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OnPageAvailableFiltersResultInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if resources (nullable) is None
        # and model_fields_set contains the field
        if self.resources is None and "resources" in self.model_fields_set:
            _dict['resources'] = None

        # set to None if pages (nullable) is None
        # and model_fields_set contains the field
        if self.pages is None and "pages" in self.model_fields_set:
            _dict['pages'] = None

        # set to None if non_indexable (nullable) is None
        # and model_fields_set contains the field
        if self.non_indexable is None and "non_indexable" in self.model_fields_set:
            _dict['non_indexable'] = None

        # set to None if links (nullable) is None
        # and model_fields_set contains the field
        if self.links is None and "links" in self.model_fields_set:
            _dict['links'] = None

        # set to None if pages_by_resource (nullable) is None
        # and model_fields_set contains the field
        if self.pages_by_resource is None and "pages_by_resource" in self.model_fields_set:
            _dict['pages_by_resource'] = None

        # set to None if redirect_chains (nullable) is None
        # and model_fields_set contains the field
        if self.redirect_chains is None and "redirect_chains" in self.model_fields_set:
            _dict['redirect_chains'] = None

        # set to None if keyword_density (nullable) is None
        # and model_fields_set contains the field
        if self.keyword_density is None and "keyword_density" in self.model_fields_set:
            _dict['keyword_density'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OnPageAvailableFiltersResultInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "resources": obj.get("resources"),
            "pages": obj.get("pages"),
            "non_indexable": obj.get("non_indexable"),
            "links": obj.get("links"),
            "pages_by_resource": obj.get("pages_by_resource"),
            "redirect_chains": obj.get("redirect_chains"),
            "keyword_density": obj.get("keyword_density")
        })
        return _obj


