# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class PageMetrics(BaseModel):
    """
    PageMetrics
    """ # noqa: E501
    links_external: Optional[StrictInt] = Field(default=None, description="number of external links the number of links pointing to other websites")
    links_internal: Optional[StrictInt] = Field(default=None, description="number of internal links the number of links pointing to other pages within the target website")
    duplicate_title: Optional[StrictInt] = Field(default=None, description="number of pages with duplicate titles")
    duplicate_description: Optional[StrictInt] = Field(default=None, description="number of pages with duplicate descriptions")
    duplicate_content: Optional[StrictInt] = Field(default=None, description="number of pages with duplicate content")
    broken_links: Optional[StrictInt] = Field(default=None, description="number of broken links number of broken links across all crawled pages on a target website")
    broken_resources: Optional[StrictInt] = Field(default=None, description="number of broken resources the number of images and other resources with broken links")
    links_relation_conflict: Optional[StrictInt] = Field(default=None, description="number of links present on the target website that may have a conflict for example, if \"links_relation_conflict\": 2, the target website is referring to the same source by at least one internal link with the rel=\"nofollow\" attribute and by at least one dofollow link")
    redirect_loop: Optional[StrictInt] = Field(default=None, description="number of redirect chains that start and end at the same URL number of redirect chains where the destination URL redirects back to the original URL")
    onpage_score: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="shows how website is optimized on a 100-point scale this field shows how website is optimized considering critical on-page issues and warnings detected; 100 is the highest possible score that means website does not have any critical on-page issues and important warnings; note that this value depends on the number of crawled pages; learn more about how the metric is calculated in this help center article")
    non_indexable: Optional[StrictInt] = Field(default=None, description="number of non-indexable pages number of pages that are blocked from being indexed by Google and other search engines by robots.txt, HTTP headers, or meta tags settings; you can receive a list of non-indexable URLs using this endpoint")
    checks: Optional[Dict[str, Optional[StrictInt]]] = Field(default=None, description="page-specific on-page check-ups")
    __properties: ClassVar[List[str]] = ["links_external", "links_internal", "duplicate_title", "duplicate_description", "duplicate_content", "broken_links", "broken_resources", "links_relation_conflict", "redirect_loop", "onpage_score", "non_indexable", "checks"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PageMetrics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if links_external (nullable) is None
        # and model_fields_set contains the field
        if self.links_external is None and "links_external" in self.model_fields_set:
            _dict['links_external'] = None

        # set to None if links_internal (nullable) is None
        # and model_fields_set contains the field
        if self.links_internal is None and "links_internal" in self.model_fields_set:
            _dict['links_internal'] = None

        # set to None if duplicate_title (nullable) is None
        # and model_fields_set contains the field
        if self.duplicate_title is None and "duplicate_title" in self.model_fields_set:
            _dict['duplicate_title'] = None

        # set to None if duplicate_description (nullable) is None
        # and model_fields_set contains the field
        if self.duplicate_description is None and "duplicate_description" in self.model_fields_set:
            _dict['duplicate_description'] = None

        # set to None if duplicate_content (nullable) is None
        # and model_fields_set contains the field
        if self.duplicate_content is None and "duplicate_content" in self.model_fields_set:
            _dict['duplicate_content'] = None

        # set to None if broken_links (nullable) is None
        # and model_fields_set contains the field
        if self.broken_links is None and "broken_links" in self.model_fields_set:
            _dict['broken_links'] = None

        # set to None if broken_resources (nullable) is None
        # and model_fields_set contains the field
        if self.broken_resources is None and "broken_resources" in self.model_fields_set:
            _dict['broken_resources'] = None

        # set to None if links_relation_conflict (nullable) is None
        # and model_fields_set contains the field
        if self.links_relation_conflict is None and "links_relation_conflict" in self.model_fields_set:
            _dict['links_relation_conflict'] = None

        # set to None if redirect_loop (nullable) is None
        # and model_fields_set contains the field
        if self.redirect_loop is None and "redirect_loop" in self.model_fields_set:
            _dict['redirect_loop'] = None

        # set to None if onpage_score (nullable) is None
        # and model_fields_set contains the field
        if self.onpage_score is None and "onpage_score" in self.model_fields_set:
            _dict['onpage_score'] = None

        # set to None if non_indexable (nullable) is None
        # and model_fields_set contains the field
        if self.non_indexable is None and "non_indexable" in self.model_fields_set:
            _dict['non_indexable'] = None

        # set to None if checks (nullable) is None
        # and model_fields_set contains the field
        if self.checks is None and "checks" in self.model_fields_set:
            _dict['checks'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PageMetrics from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "links_external": obj.get("links_external"),
            "links_internal": obj.get("links_internal"),
            "duplicate_title": obj.get("duplicate_title"),
            "duplicate_description": obj.get("duplicate_description"),
            "duplicate_content": obj.get("duplicate_content"),
            "broken_links": obj.get("broken_links"),
            "broken_resources": obj.get("broken_resources"),
            "links_relation_conflict": obj.get("links_relation_conflict"),
            "redirect_loop": obj.get("redirect_loop"),
            "onpage_score": obj.get("onpage_score"),
            "non_indexable": obj.get("non_indexable"),
            "checks": obj.get("checks")
        })
        return _obj


