# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class RankChanges(BaseModel):
    """
    RankChanges
    """ # noqa: E501
    previous_rank_absolute: Optional[StrictInt] = Field(default=None, description="previous absolute rank in SERP indicates previous rank of the element in Google SERP; if this element is new, the value will be null")
    is_new: Optional[StrictBool] = Field(default=None, description="element was previously present in SERP if the value is true, previously collected SERP didn’t contain this element")
    is_up: Optional[StrictBool] = Field(default=None, description="rank of this element went up if the value is true, position of the element in SERP is higher compared to the previous check")
    is_down: Optional[StrictBool] = Field(default=None, description="rank of this element went down if the value is true, position of the element in SERP is lower compared to the previous check")
    __properties: ClassVar[List[str]] = ["previous_rank_absolute", "is_new", "is_up", "is_down"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RankChanges from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if previous_rank_absolute (nullable) is None
        # and model_fields_set contains the field
        if self.previous_rank_absolute is None and "previous_rank_absolute" in self.model_fields_set:
            _dict['previous_rank_absolute'] = None

        # set to None if is_new (nullable) is None
        # and model_fields_set contains the field
        if self.is_new is None and "is_new" in self.model_fields_set:
            _dict['is_new'] = None

        # set to None if is_up (nullable) is None
        # and model_fields_set contains the field
        if self.is_up is None and "is_up" in self.model_fields_set:
            _dict['is_up'] = None

        # set to None if is_down (nullable) is None
        # and model_fields_set contains the field
        if self.is_down is None and "is_down" in self.model_fields_set:
            _dict['is_down'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RankChanges from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "previous_rank_absolute": obj.get("previous_rank_absolute"),
            "is_new": obj.get("is_new"),
            "is_up": obj.get("is_up"),
            "is_down": obj.get("is_down")
        })
        return _obj


