# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.preview_image import PreviewImage
from typing import Optional, Set
from typing_extensions import Self

class SerpGoogleAdsSearchTaskGetAdvancedItem(BaseModel):
    """
    SerpGoogleAdsSearchTaskGetAdvancedItem
    """ # noqa: E501
    type: Optional[StrictStr] = Field(default=None, description="type of element")
    rank_group: Optional[StrictInt] = Field(default=None, description="group rank in SERP position within a group of elements with identical type values positions of elements with different type values are omitted from rank_group")
    rank_absolute: Optional[StrictInt] = Field(default=None, description="absolute rank in SERP absolute position among all the elements in SERP")
    advertiser_id: Optional[StrictStr] = Field(default=None, description="unique identifier of the advertiser account")
    creative_id: Optional[StrictStr] = Field(default=None, description="unique identifier of the advertisement")
    title: Optional[StrictStr] = Field(default=None, description="title of the element")
    url: Optional[StrictStr] = Field(default=None, description="search URL with refinement parameters")
    verified: Optional[StrictBool] = Field(default=None, description="verified advertiser account equals true if advertiser account is verified by Google Ads")
    format: Optional[StrictStr] = Field(default=None, description="format of the advertisement possible values: text, image, video")
    preview_image: Optional[PreviewImage] = None
    preview_url: Optional[StrictStr] = Field(default=None, description="url pointing to the ad preview")
    first_shown: Optional[StrictStr] = Field(default=None, description="date and time when the ad was shown for the first time in the UTC format: “yyyy-mm-dd hh-mm-ss +00:00”")
    last_shown: Optional[StrictStr] = Field(default=None, description="date and time when the ad was shown the last time in the UTC format: “yyyy-mm-dd hh-mm-ss +00:00”")
    __properties: ClassVar[List[str]] = ["type", "rank_group", "rank_absolute", "advertiser_id", "creative_id", "title", "url", "verified", "format", "preview_image", "preview_url", "first_shown", "last_shown"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SerpGoogleAdsSearchTaskGetAdvancedItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of preview_image
        if self.preview_image:
            _dict['preview_image'] = self.preview_image.to_dict()
        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if rank_group (nullable) is None
        # and model_fields_set contains the field
        if self.rank_group is None and "rank_group" in self.model_fields_set:
            _dict['rank_group'] = None

        # set to None if rank_absolute (nullable) is None
        # and model_fields_set contains the field
        if self.rank_absolute is None and "rank_absolute" in self.model_fields_set:
            _dict['rank_absolute'] = None

        # set to None if advertiser_id (nullable) is None
        # and model_fields_set contains the field
        if self.advertiser_id is None and "advertiser_id" in self.model_fields_set:
            _dict['advertiser_id'] = None

        # set to None if creative_id (nullable) is None
        # and model_fields_set contains the field
        if self.creative_id is None and "creative_id" in self.model_fields_set:
            _dict['creative_id'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if url (nullable) is None
        # and model_fields_set contains the field
        if self.url is None and "url" in self.model_fields_set:
            _dict['url'] = None

        # set to None if verified (nullable) is None
        # and model_fields_set contains the field
        if self.verified is None and "verified" in self.model_fields_set:
            _dict['verified'] = None

        # set to None if format (nullable) is None
        # and model_fields_set contains the field
        if self.format is None and "format" in self.model_fields_set:
            _dict['format'] = None

        # set to None if preview_url (nullable) is None
        # and model_fields_set contains the field
        if self.preview_url is None and "preview_url" in self.model_fields_set:
            _dict['preview_url'] = None

        # set to None if first_shown (nullable) is None
        # and model_fields_set contains the field
        if self.first_shown is None and "first_shown" in self.model_fields_set:
            _dict['first_shown'] = None

        # set to None if last_shown (nullable) is None
        # and model_fields_set contains the field
        if self.last_shown is None and "last_shown" in self.model_fields_set:
            _dict['last_shown'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SerpGoogleAdsSearchTaskGetAdvancedItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "rank_group": obj.get("rank_group"),
            "rank_absolute": obj.get("rank_absolute"),
            "advertiser_id": obj.get("advertiser_id"),
            "creative_id": obj.get("creative_id"),
            "title": obj.get("title"),
            "url": obj.get("url"),
            "verified": obj.get("verified"),
            "format": obj.get("format"),
            "preview_image": PreviewImage.from_dict(obj["preview_image"]) if obj.get("preview_image") is not None else None,
            "preview_url": obj.get("preview_url"),
            "first_shown": obj.get("first_shown"),
            "last_shown": obj.get("last_shown")
        })
        return _obj


