# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.authors_element import AuthorsElement
from dataforseo_client.models.dataset_description import DatasetDescription
from dataforseo_client.models.formats_element import FormatsElement
from dataforseo_client.models.licenses_element import LicensesElement
from dataforseo_client.models.link_element import LinkElement
from dataforseo_client.models.period_covered import PeriodCovered
from typing import Optional, Set
from typing_extensions import Self

class SerpGoogleDatasetAdvancedItem(BaseModel):
    """
    SerpGoogleDatasetAdvancedItem
    """ # noqa: E501
    type: Optional[StrictStr] = Field(default=None, description="type of element")
    rank_group: Optional[StrictInt] = Field(default=None, description="group rank in SERP position within a group of elements with identical type values positions of elements with different type values are omitted from rank_group")
    rank_absolute: Optional[StrictInt] = Field(default=None, description="absolute rank in SERP absolute position among all the elements in SERP")
    position: Optional[StrictStr] = Field(default=None, description="the alignment of the element in SERP can take the following values: left, right")
    xpath: Optional[StrictStr] = Field(default=None, description="the XPath of the element")
    dataset_id: Optional[StrictStr] = Field(default=None, description="ID of the dataset")
    title: Optional[StrictStr] = Field(default=None, description="title of the element")
    image_url: Optional[StrictStr] = Field(default=None, description="URL of the image the URL leading to the image on the original resource or DataForSEO storage (in case the original source is not available)")
    scholarly_citations_count: Optional[StrictInt] = Field(default=None, description="count of articles that refer to the dataset")
    scholarly_articles_url: Optional[StrictStr] = Field(default=None, description="url of scholarly articles link to the list of scholarly articles on Google Scholar example: https://scholar.google.com/scholar?q=%2210.6084%20m9%20figshare%207427933%20v1%22")
    unique_identifier: Optional[StrictStr] = Field(default=None, description="digital identifier of an object unique digital identifier of the dataset example: https://doi.org/10.5061/dryad.hmgqnk9m3")
    related_article: Optional[StrictStr] = Field(default=None, description="link to related article link to the published article that is related to the dataset")
    links: Optional[List[LinkElement]] = Field(default=None, description="sitelinks the links shown below some of Google Dataset’s search results if there are none, equals null")
    dataset_providers: Optional[List[LicensesElement]] = Field(default=None, description="the list of institutions that provided the dataset")
    formats: Optional[List[FormatsElement]] = Field(default=None, description="the list of file formats of the dataset")
    authors: Optional[List[AuthorsElement]] = Field(default=None, description="the list of authors of the dataset")
    licenses: Optional[List[LicensesElement]] = Field(default=None, description="the list of licenses issued to the dataset")
    updated_date: Optional[StrictStr] = Field(default=None, description="date and time when the result was last updated in the UTC format: “yyyy-mm-dd hh-mm-ss +00:00” example: 2022-11-27 02:00:00 +00:00")
    area_covered: Optional[List[Optional[StrictStr]]] = Field(default=None, description="the list of areas covered in the dataset for example: Africa, Global")
    period_covered: Optional[PeriodCovered] = None
    dataset_description: Optional[DatasetDescription] = None
    __properties: ClassVar[List[str]] = ["type", "rank_group", "rank_absolute", "position", "xpath", "dataset_id", "title", "image_url", "scholarly_citations_count", "scholarly_articles_url", "unique_identifier", "related_article", "links", "dataset_providers", "formats", "authors", "licenses", "updated_date", "area_covered", "period_covered", "dataset_description"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SerpGoogleDatasetAdvancedItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item_links in self.links:
                if _item_links:
                    _items.append(_item_links.to_dict())
            _dict['links'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in dataset_providers (list)
        _items = []
        if self.dataset_providers:
            for _item_dataset_providers in self.dataset_providers:
                if _item_dataset_providers:
                    _items.append(_item_dataset_providers.to_dict())
            _dict['dataset_providers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in formats (list)
        _items = []
        if self.formats:
            for _item_formats in self.formats:
                if _item_formats:
                    _items.append(_item_formats.to_dict())
            _dict['formats'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in authors (list)
        _items = []
        if self.authors:
            for _item_authors in self.authors:
                if _item_authors:
                    _items.append(_item_authors.to_dict())
            _dict['authors'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in licenses (list)
        _items = []
        if self.licenses:
            for _item_licenses in self.licenses:
                if _item_licenses:
                    _items.append(_item_licenses.to_dict())
            _dict['licenses'] = _items
        # override the default output from pydantic by calling `to_dict()` of period_covered
        if self.period_covered:
            _dict['period_covered'] = self.period_covered.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dataset_description
        if self.dataset_description:
            _dict['dataset_description'] = self.dataset_description.to_dict()
        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if rank_group (nullable) is None
        # and model_fields_set contains the field
        if self.rank_group is None and "rank_group" in self.model_fields_set:
            _dict['rank_group'] = None

        # set to None if rank_absolute (nullable) is None
        # and model_fields_set contains the field
        if self.rank_absolute is None and "rank_absolute" in self.model_fields_set:
            _dict['rank_absolute'] = None

        # set to None if position (nullable) is None
        # and model_fields_set contains the field
        if self.position is None and "position" in self.model_fields_set:
            _dict['position'] = None

        # set to None if xpath (nullable) is None
        # and model_fields_set contains the field
        if self.xpath is None and "xpath" in self.model_fields_set:
            _dict['xpath'] = None

        # set to None if dataset_id (nullable) is None
        # and model_fields_set contains the field
        if self.dataset_id is None and "dataset_id" in self.model_fields_set:
            _dict['dataset_id'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if image_url (nullable) is None
        # and model_fields_set contains the field
        if self.image_url is None and "image_url" in self.model_fields_set:
            _dict['image_url'] = None

        # set to None if scholarly_citations_count (nullable) is None
        # and model_fields_set contains the field
        if self.scholarly_citations_count is None and "scholarly_citations_count" in self.model_fields_set:
            _dict['scholarly_citations_count'] = None

        # set to None if scholarly_articles_url (nullable) is None
        # and model_fields_set contains the field
        if self.scholarly_articles_url is None and "scholarly_articles_url" in self.model_fields_set:
            _dict['scholarly_articles_url'] = None

        # set to None if unique_identifier (nullable) is None
        # and model_fields_set contains the field
        if self.unique_identifier is None and "unique_identifier" in self.model_fields_set:
            _dict['unique_identifier'] = None

        # set to None if related_article (nullable) is None
        # and model_fields_set contains the field
        if self.related_article is None and "related_article" in self.model_fields_set:
            _dict['related_article'] = None

        # set to None if links (nullable) is None
        # and model_fields_set contains the field
        if self.links is None and "links" in self.model_fields_set:
            _dict['links'] = None

        # set to None if dataset_providers (nullable) is None
        # and model_fields_set contains the field
        if self.dataset_providers is None and "dataset_providers" in self.model_fields_set:
            _dict['dataset_providers'] = None

        # set to None if formats (nullable) is None
        # and model_fields_set contains the field
        if self.formats is None and "formats" in self.model_fields_set:
            _dict['formats'] = None

        # set to None if authors (nullable) is None
        # and model_fields_set contains the field
        if self.authors is None and "authors" in self.model_fields_set:
            _dict['authors'] = None

        # set to None if licenses (nullable) is None
        # and model_fields_set contains the field
        if self.licenses is None and "licenses" in self.model_fields_set:
            _dict['licenses'] = None

        # set to None if updated_date (nullable) is None
        # and model_fields_set contains the field
        if self.updated_date is None and "updated_date" in self.model_fields_set:
            _dict['updated_date'] = None

        # set to None if area_covered (nullable) is None
        # and model_fields_set contains the field
        if self.area_covered is None and "area_covered" in self.model_fields_set:
            _dict['area_covered'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SerpGoogleDatasetAdvancedItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "rank_group": obj.get("rank_group"),
            "rank_absolute": obj.get("rank_absolute"),
            "position": obj.get("position"),
            "xpath": obj.get("xpath"),
            "dataset_id": obj.get("dataset_id"),
            "title": obj.get("title"),
            "image_url": obj.get("image_url"),
            "scholarly_citations_count": obj.get("scholarly_citations_count"),
            "scholarly_articles_url": obj.get("scholarly_articles_url"),
            "unique_identifier": obj.get("unique_identifier"),
            "related_article": obj.get("related_article"),
            "links": [LinkElement.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None,
            "dataset_providers": [LicensesElement.from_dict(_item) for _item in obj["dataset_providers"]] if obj.get("dataset_providers") is not None else None,
            "formats": [FormatsElement.from_dict(_item) for _item in obj["formats"]] if obj.get("formats") is not None else None,
            "authors": [AuthorsElement.from_dict(_item) for _item in obj["authors"]] if obj.get("authors") is not None else None,
            "licenses": [LicensesElement.from_dict(_item) for _item in obj["licenses"]] if obj.get("licenses") is not None else None,
            "updated_date": obj.get("updated_date"),
            "area_covered": obj.get("area_covered"),
            "period_covered": PeriodCovered.from_dict(obj["period_covered"]) if obj.get("period_covered") is not None else None,
            "dataset_description": DatasetDescription.from_dict(obj["dataset_description"]) if obj.get("dataset_description") is not None else None
        })
        return _obj


