# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.rectangle import Rectangle
from typing import Optional, Set
from typing_extensions import Self

class SerpGoogleJobsTaskGetAdvancedItem(BaseModel):
    """
    SerpGoogleJobsTaskGetAdvancedItem
    """ # noqa: E501
    type: Optional[StrictStr] = Field(default=None, description="type of element")
    rank_group: Optional[StrictInt] = Field(default=None, description="group rank in SERP position within a group of elements with identical type values positions of elements with different type values are omitted from rank_group")
    rank_absolute: Optional[StrictInt] = Field(default=None, description="absolute rank in SERP absolute position among all the elements in SERP")
    position: Optional[StrictStr] = Field(default=None, description="the alignment of the element in SERP can take the following values: left, right")
    xpath: Optional[StrictStr] = Field(default=None, description="the XPath of the element")
    job_id: Optional[StrictStr] = Field(default=None, description="ID of the job on Google Jobs")
    title: Optional[StrictStr] = Field(default=None, description="title of the element")
    employer_name: Optional[StrictStr] = Field(default=None, description="name of the employer")
    employer_url: Optional[StrictStr] = Field(default=None, description="URL to the employer’s website")
    employer_image_url: Optional[StrictStr] = Field(default=None, description="URL to the image used in the job posting")
    location: Optional[StrictStr] = Field(default=None, description="location for which the job vacancy is posted")
    source_name: Optional[StrictStr] = Field(default=None, description="original source of the job vacancy")
    source_url: Optional[StrictStr] = Field(default=None, description="URL to the original source of the job vacancy")
    salary: Optional[StrictStr] = Field(default=None, description="the salary indicated in the job vacancy if the salary isn’t indicated, this field will equal null")
    contract_type: Optional[StrictStr] = Field(default=None, description="employment contract type")
    timestamp: Optional[StrictStr] = Field(default=None, description="date and time when the result was published in the UTC format: “yyyy-mm-dd hh-mm-ss +00:00” example: 2019-11-15 12:57:46 +00:00")
    time_ago: Optional[StrictStr] = Field(default=None, description="indicates how long ago the job vacancy was posted")
    rectangle: Optional[Rectangle] = None
    __properties: ClassVar[List[str]] = ["type", "rank_group", "rank_absolute", "position", "xpath", "job_id", "title", "employer_name", "employer_url", "employer_image_url", "location", "source_name", "source_url", "salary", "contract_type", "timestamp", "time_ago", "rectangle"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SerpGoogleJobsTaskGetAdvancedItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of rectangle
        if self.rectangle:
            _dict['rectangle'] = self.rectangle.to_dict()
        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if rank_group (nullable) is None
        # and model_fields_set contains the field
        if self.rank_group is None and "rank_group" in self.model_fields_set:
            _dict['rank_group'] = None

        # set to None if rank_absolute (nullable) is None
        # and model_fields_set contains the field
        if self.rank_absolute is None and "rank_absolute" in self.model_fields_set:
            _dict['rank_absolute'] = None

        # set to None if position (nullable) is None
        # and model_fields_set contains the field
        if self.position is None and "position" in self.model_fields_set:
            _dict['position'] = None

        # set to None if xpath (nullable) is None
        # and model_fields_set contains the field
        if self.xpath is None and "xpath" in self.model_fields_set:
            _dict['xpath'] = None

        # set to None if job_id (nullable) is None
        # and model_fields_set contains the field
        if self.job_id is None and "job_id" in self.model_fields_set:
            _dict['job_id'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if employer_name (nullable) is None
        # and model_fields_set contains the field
        if self.employer_name is None and "employer_name" in self.model_fields_set:
            _dict['employer_name'] = None

        # set to None if employer_url (nullable) is None
        # and model_fields_set contains the field
        if self.employer_url is None and "employer_url" in self.model_fields_set:
            _dict['employer_url'] = None

        # set to None if employer_image_url (nullable) is None
        # and model_fields_set contains the field
        if self.employer_image_url is None and "employer_image_url" in self.model_fields_set:
            _dict['employer_image_url'] = None

        # set to None if location (nullable) is None
        # and model_fields_set contains the field
        if self.location is None and "location" in self.model_fields_set:
            _dict['location'] = None

        # set to None if source_name (nullable) is None
        # and model_fields_set contains the field
        if self.source_name is None and "source_name" in self.model_fields_set:
            _dict['source_name'] = None

        # set to None if source_url (nullable) is None
        # and model_fields_set contains the field
        if self.source_url is None and "source_url" in self.model_fields_set:
            _dict['source_url'] = None

        # set to None if salary (nullable) is None
        # and model_fields_set contains the field
        if self.salary is None and "salary" in self.model_fields_set:
            _dict['salary'] = None

        # set to None if contract_type (nullable) is None
        # and model_fields_set contains the field
        if self.contract_type is None and "contract_type" in self.model_fields_set:
            _dict['contract_type'] = None

        # set to None if timestamp (nullable) is None
        # and model_fields_set contains the field
        if self.timestamp is None and "timestamp" in self.model_fields_set:
            _dict['timestamp'] = None

        # set to None if time_ago (nullable) is None
        # and model_fields_set contains the field
        if self.time_ago is None and "time_ago" in self.model_fields_set:
            _dict['time_ago'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SerpGoogleJobsTaskGetAdvancedItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "rank_group": obj.get("rank_group"),
            "rank_absolute": obj.get("rank_absolute"),
            "position": obj.get("position"),
            "xpath": obj.get("xpath"),
            "job_id": obj.get("job_id"),
            "title": obj.get("title"),
            "employer_name": obj.get("employer_name"),
            "employer_url": obj.get("employer_url"),
            "employer_image_url": obj.get("employer_image_url"),
            "location": obj.get("location"),
            "source_name": obj.get("source_name"),
            "source_url": obj.get("source_url"),
            "salary": obj.get("salary"),
            "contract_type": obj.get("contract_type"),
            "timestamp": obj.get("timestamp"),
            "time_ago": obj.get("time_ago"),
            "rectangle": Rectangle.from_dict(obj["rectangle"]) if obj.get("rectangle") is not None else None
        })
        return _obj


