# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class SerpScreenshotRequestInfo(BaseModel):
    """
    SerpScreenshotRequestInfo
    """ # noqa: E501
    task_id: Optional[StrictStr] = Field(default=None, description="task identifier required field unique identifier of the associated task in the UUID format you will be able to use it within 7 days to request the results of the task at any time")
    browser_preset: Optional[StrictStr] = Field(default=None, description="browser resolution preset optional field browser preset associated with a certain device type can take the following values: desktop, tablet, mobile note: by default, browser preset corresponds to the device type specified in the POST request")
    browser_screen_width: Optional[StrictInt] = Field(default=None, description="width of the browser resolution optional field can be specified in the following range: 240-9999")
    browser_screen_height: Optional[StrictInt] = Field(default=None, description="height of the browser resolution optional field can be specified in the following range: 240-9999")
    browser_screen_scale_factor: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="browser scale factor optional field can be specified in the following range: 0.5-3")
    __properties: ClassVar[List[str]] = ["task_id", "browser_preset", "browser_screen_width", "browser_screen_height", "browser_screen_scale_factor"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SerpScreenshotRequestInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if browser_preset (nullable) is None
        # and model_fields_set contains the field
        if self.browser_preset is None and "browser_preset" in self.model_fields_set:
            _dict['browser_preset'] = None

        # set to None if browser_screen_width (nullable) is None
        # and model_fields_set contains the field
        if self.browser_screen_width is None and "browser_screen_width" in self.model_fields_set:
            _dict['browser_screen_width'] = None

        # set to None if browser_screen_height (nullable) is None
        # and model_fields_set contains the field
        if self.browser_screen_height is None and "browser_screen_height" in self.model_fields_set:
            _dict['browser_screen_height'] = None

        # set to None if browser_screen_scale_factor (nullable) is None
        # and model_fields_set contains the field
        if self.browser_screen_scale_factor is None and "browser_screen_scale_factor" in self.model_fields_set:
            _dict['browser_screen_scale_factor'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SerpScreenshotRequestInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "task_id": obj.get("task_id"),
            "browser_preset": obj.get("browser_preset"),
            "browser_screen_width": obj.get("browser_screen_width"),
            "browser_screen_height": obj.get("browser_screen_height"),
            "browser_screen_scale_factor": obj.get("browser_screen_scale_factor")
        })
        return _obj


