# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.base_youtube_serp_element_item import BaseYoutubeSerpElementItem
from typing import Optional, Set
from typing_extensions import Self

class YoutubeCommentSerpElementItem(BaseYoutubeSerpElementItem):
    """
    YoutubeCommentSerpElementItem
    """ # noqa: E501
    author_name: Optional[StrictStr] = Field(default=None, description="name of the author of the comment")
    author_thumbnail: Optional[StrictStr] = Field(default=None, description="the URL of the page where the author’s channel logo is hosted")
    author_url: Optional[StrictStr] = Field(default=None, description="URL of the author’s channel")
    text: Optional[StrictStr] = Field(default=None, description="text of the comment")
    publication_date: Optional[StrictStr] = Field(default=None, description="displayed publication date")
    timestamp: Optional[StrictStr] = Field(default=None, description="date and time when the result was published in the UTC format: “yyyy-mm-dd hh-mm-ss +00:00” example: 2022-11-15 12:57:46 +00:00")
    likes_count: Optional[StrictInt] = Field(default=None, description="number of likes on the comment")
    reply_count: Optional[StrictInt] = Field(default=None, description="number of replies on the comment")
    __properties: ClassVar[List[str]] = ["type", "rank_group", "rank_absolute", "author_name", "author_thumbnail", "author_url", "text", "publication_date", "timestamp", "likes_count", "reply_count"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of YoutubeCommentSerpElementItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if rank_group (nullable) is None
        # and model_fields_set contains the field
        if self.rank_group is None and "rank_group" in self.model_fields_set:
            _dict['rank_group'] = None

        # set to None if rank_absolute (nullable) is None
        # and model_fields_set contains the field
        if self.rank_absolute is None and "rank_absolute" in self.model_fields_set:
            _dict['rank_absolute'] = None

        # set to None if author_name (nullable) is None
        # and model_fields_set contains the field
        if self.author_name is None and "author_name" in self.model_fields_set:
            _dict['author_name'] = None

        # set to None if author_thumbnail (nullable) is None
        # and model_fields_set contains the field
        if self.author_thumbnail is None and "author_thumbnail" in self.model_fields_set:
            _dict['author_thumbnail'] = None

        # set to None if author_url (nullable) is None
        # and model_fields_set contains the field
        if self.author_url is None and "author_url" in self.model_fields_set:
            _dict['author_url'] = None

        # set to None if text (nullable) is None
        # and model_fields_set contains the field
        if self.text is None and "text" in self.model_fields_set:
            _dict['text'] = None

        # set to None if publication_date (nullable) is None
        # and model_fields_set contains the field
        if self.publication_date is None and "publication_date" in self.model_fields_set:
            _dict['publication_date'] = None

        # set to None if timestamp (nullable) is None
        # and model_fields_set contains the field
        if self.timestamp is None and "timestamp" in self.model_fields_set:
            _dict['timestamp'] = None

        # set to None if likes_count (nullable) is None
        # and model_fields_set contains the field
        if self.likes_count is None and "likes_count" in self.model_fields_set:
            _dict['likes_count'] = None

        # set to None if reply_count (nullable) is None
        # and model_fields_set contains the field
        if self.reply_count is None and "reply_count" in self.model_fields_set:
            _dict['reply_count'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of YoutubeCommentSerpElementItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "rank_group": obj.get("rank_group"),
            "rank_absolute": obj.get("rank_absolute"),
            "author_name": obj.get("author_name"),
            "author_thumbnail": obj.get("author_thumbnail"),
            "author_url": obj.get("author_url"),
            "text": obj.get("text"),
            "publication_date": obj.get("publication_date"),
            "timestamp": obj.get("timestamp"),
            "likes_count": obj.get("likes_count"),
            "reply_count": obj.get("reply_count")
        })
        return _obj


