"use strict";
(self["webpackChunktvb_ext_xircuits"] = self["webpackChunktvb_ext_xircuits"] || []).push([["vendors-node_modules_react-collapsed_dist_index_mjs"],{

/***/ "./node_modules/tiny-warning/dist/tiny-warning.esm.js":
/*!************************************************************!*\
  !*** ./node_modules/tiny-warning/dist/tiny-warning.esm.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var isProduction = "development" === 'production';
function warning(condition, message) {
  if (!isProduction) {
    if (condition) {
      return;
    }

    var text = "Warning: " + message;

    if (typeof console !== 'undefined') {
      console.warn(text);
    }

    try {
      throw Error(text);
    } catch (x) {}
  }
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (warning);


/***/ }),

/***/ "./node_modules/react-collapsed/dist/index.mjs":
/*!*****************************************************!*\
  !*** ./node_modules/react-collapsed/dist/index.mjs ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useCollapse: () => (/* binding */ useCollapse)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var tiny_warning__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tiny-warning */ "./node_modules/tiny-warning/dist/tiny-warning.esm.js");
/**
  * react-collapsed v4.1.2
  *
  * Copyright (c) 2019-2023, Rogin Farrer
  *
  * This source code is licensed under the MIT license found in the
  * LICENSE.md file in the root directory of this source tree.
  *
  * @license MIT
  */


// src/index.ts


// src/utils/index.ts


// src/utils/CollapseError.ts

var CollapseError = class extends Error {
  constructor(message) {
    super(`react-collapsed: ${message}`);
  }
};
var collapseWarning = (...args) => {
  return (0,tiny_warning__WEBPACK_IMPORTED_MODULE_1__["default"])(args[0], `[react-collapsed] -- ${args[1]}`);
};

// src/utils/useEvent.ts

function useEvent(callback) {
  const ref = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(callback);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    ref.current = callback;
  });
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((...args) => ref.current?.(...args), []);
}

// src/utils/useControlledState.ts

function useControlledState(value, defaultValue, callback) {
  const [state, setState] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(defaultValue);
  const initiallyControlled = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(typeof value !== "undefined");
  const effectiveValue = initiallyControlled.current ? value : state;
  const cb = useEvent(callback);
  const onChange = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(
    (update) => {
      const setter = update;
      const newValue = typeof update === "function" ? setter(effectiveValue) : update;
      if (!initiallyControlled.current) {
        setState(newValue);
      }
      cb?.(newValue);
    },
    [cb, effectiveValue]
  );
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    collapseWarning(
      !(initiallyControlled.current && value == null),
      "`isExpanded` state is changing from controlled to uncontrolled. useCollapse should not switch from controlled to uncontrolled (or vice versa). Decide between using a controlled or uncontrolled collapse for the lifetime of the component. Check the `isExpanded` prop."
    );
    collapseWarning(
      !(!initiallyControlled.current && value != null),
      "`isExpanded` state is changing from uncontrolled to controlled. useCollapse should not switch from uncontrolled to controlled (or vice versa). Decide between using a controlled or uncontrolled collapse for the lifetime of the component. Check the `isExpanded` prop."
    );
  }, [value]);
  return [effectiveValue, onChange];
}

// src/utils/usePrefersReducedMotion.ts

var QUERY = "(prefers-reduced-motion: reduce)";
function usePrefersReducedMotion() {
  const [prefersReducedMotion, setPrefersReducedMotion] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (typeof window === "undefined" || typeof window.matchMedia !== "function") {
      return;
    }
    const mediaQueryList = window.matchMedia(QUERY);
    setPrefersReducedMotion(mediaQueryList.matches);
    const listener = (event) => {
      setPrefersReducedMotion(event.matches);
    };
    if (mediaQueryList.addEventListener) {
      mediaQueryList.addEventListener("change", listener);
      return () => {
        mediaQueryList.removeEventListener("change", listener);
      };
    } else if (mediaQueryList.addListener) {
      mediaQueryList.addListener(listener);
      return () => {
        mediaQueryList.removeListener(listener);
      };
    }
    return void 0;
  }, []);
  return prefersReducedMotion;
}

// src/utils/useId.ts

var __useId = react__WEBPACK_IMPORTED_MODULE_0__["useId".toString()] || (() => void 0);
function useReactId() {
  const id2 = __useId();
  return id2 ?? "";
}
var useIsomorphicLayoutEffect = typeof window !== "undefined" ? react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect : react__WEBPACK_IMPORTED_MODULE_0__.useEffect;
var serverHandoffComplete = false;
var id = 0;
var genId = () => ++id;
function useUniqueId(idFromProps) {
  const initialId = idFromProps || (serverHandoffComplete ? genId() : null);
  const [id2, setId] = react__WEBPACK_IMPORTED_MODULE_0__.useState(initialId);
  useIsomorphicLayoutEffect(() => {
    if (id2 === null) {
      setId(genId());
    }
  }, []);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (serverHandoffComplete === false) {
      serverHandoffComplete = true;
    }
  }, []);
  return id2 != null ? String(id2) : void 0;
}
function useId(idOverride) {
  const reactId = useReactId();
  const uniqueId = useUniqueId(idOverride);
  if (typeof idOverride === "string") {
    return idOverride;
  }
  if (typeof reactId === "string") {
    return reactId;
  }
  return uniqueId;
}

// src/utils/setAnimationTimeout.ts
function setAnimationTimeout(callback, timeout) {
  const startTime = performance.now();
  const frame = {};
  function call() {
    frame.id = requestAnimationFrame((now) => {
      if (now - startTime > timeout) {
        callback();
      } else {
        call();
      }
    });
  }
  call();
  return frame;
}
function clearAnimationTimeout(frame) {
  if (frame.id)
    cancelAnimationFrame(frame.id);
}

// src/utils/index.ts
function getElementHeight(el) {
  if (!el?.current) {
    collapseWarning(
      true,
      `Was not able to find a ref to the collapse element via \`getCollapseProps\`. Ensure that the element exposes its \`ref\` prop. If it exposes the ref prop under a different name (like \`innerRef\`), use the \`refKey\` property to change it. Example:

const collapseProps = getCollapseProps({refKey: 'innerRef'})`
    );
    return 0;
  }
  return el.current.scrollHeight;
}
function getAutoHeightDuration(height) {
  if (!height || typeof height === "string") {
    return 0;
  }
  const constant = height / 36;
  return Math.round((4 + 15 * constant ** 0.25 + constant / 5) * 10);
}
function assignRef(ref, value) {
  if (ref == null)
    return;
  if (typeof ref === "function") {
    ref(value);
  } else {
    try {
      ref.current = value;
    } catch (error) {
      throw new CollapseError(`Cannot assign value "${value}" to ref "${ref}"`);
    }
  }
}
function mergeRefs(...refs) {
  if (refs.every((ref) => ref == null)) {
    return null;
  }
  return (node) => {
    refs.forEach((ref) => {
      assignRef(ref, node);
    });
  };
}
function usePaddingWarning(element) {
  let warn = (el) => {
  };
  if (true) {
    warn = (el) => {
      if (!el?.current) {
        return;
      }
      const { paddingTop, paddingBottom } = window.getComputedStyle(el.current);
      const hasPadding = paddingTop && paddingTop !== "0px" || paddingBottom && paddingBottom !== "0px";
      collapseWarning(
        !hasPadding,
        `Padding applied to the collapse element will cause the animation to break and not perform as expected. To fix, apply equivalent padding to the direct descendent of the collapse element. Example:

Before:   <div {...getCollapseProps({style: {padding: 10}})}>{children}</div>

After:   <div {...getCollapseProps()}>
             <div style={{padding: 10}}>
                 {children}
             </div>
          </div>`
      );
    };
  }
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    warn(element);
  }, [element]);
}

// src/index.ts
var useLayoutEffect2 = typeof window === "undefined" ? react__WEBPACK_IMPORTED_MODULE_0__.useEffect : react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect;
function useCollapse({
  duration,
  easing = "cubic-bezier(0.4, 0, 0.2, 1)",
  onTransitionStateChange: propOnTransitionStateChange = () => {
  },
  isExpanded: configIsExpanded,
  defaultExpanded = false,
  hasDisabledAnimation,
  id: id2,
  ...initialConfig
} = {}) {
  const onTransitionStateChange = useEvent(propOnTransitionStateChange);
  const uniqueId = useId(id2 ? `${id2}` : void 0);
  const [isExpanded, setExpanded] = useControlledState(
    configIsExpanded,
    defaultExpanded
  );
  const prevExpanded = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(isExpanded);
  const [isAnimating, setIsAnimating] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const prefersReducedMotion = usePrefersReducedMotion();
  const disableAnimation = hasDisabledAnimation ?? prefersReducedMotion;
  const frameId = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)();
  const endFrameId = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)();
  const collapseElRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  const [toggleEl, setToggleEl] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null);
  usePaddingWarning(collapseElRef);
  const collapsedHeight = `${initialConfig.collapsedHeight || 0}px`;
  function setStyles(newStyles) {
    if (!collapseElRef.current)
      return;
    const target = collapseElRef.current;
    for (const property in newStyles) {
      const value = newStyles[property];
      if (value) {
        target.style[property] = value;
      } else {
        target.style.removeProperty(property);
      }
    }
  }
  useLayoutEffect2(() => {
    const collapse = collapseElRef.current;
    if (!collapse)
      return;
    if (isExpanded === prevExpanded.current)
      return;
    prevExpanded.current = isExpanded;
    function getDuration(height) {
      if (disableAnimation) {
        return 0;
      }
      return duration ?? getAutoHeightDuration(height);
    }
    const getTransitionStyles = (height) => `height ${getDuration(height)}ms ${easing}`;
    const setTransitionEndTimeout = (duration2) => {
      function endTransition() {
        if (isExpanded) {
          setStyles({
            height: "",
            overflow: "",
            transition: "",
            display: ""
          });
          onTransitionStateChange("expandEnd");
        } else {
          setStyles({ transition: "" });
          onTransitionStateChange("collapseEnd");
        }
        setIsAnimating(false);
      }
      if (endFrameId.current) {
        clearAnimationTimeout(endFrameId.current);
      }
      endFrameId.current = setAnimationTimeout(endTransition, duration2);
    };
    setIsAnimating(true);
    if (isExpanded) {
      frameId.current = requestAnimationFrame(() => {
        onTransitionStateChange("expandStart");
        setStyles({
          display: "block",
          overflow: "hidden",
          height: collapsedHeight
        });
        frameId.current = requestAnimationFrame(() => {
          onTransitionStateChange("expanding");
          const height = getElementHeight(collapseElRef);
          setTransitionEndTimeout(getDuration(height));
          if (collapseElRef.current) {
            collapseElRef.current.style.transition = getTransitionStyles(height);
            collapseElRef.current.style.height = `${height}px`;
          }
        });
      });
    } else {
      frameId.current = requestAnimationFrame(() => {
        onTransitionStateChange("collapseStart");
        const height = getElementHeight(collapseElRef);
        setTransitionEndTimeout(getDuration(height));
        setStyles({
          transition: getTransitionStyles(height),
          height: `${height}px`
        });
        frameId.current = requestAnimationFrame(() => {
          onTransitionStateChange("collapsing");
          setStyles({
            height: collapsedHeight,
            overflow: "hidden"
          });
        });
      });
    }
    return () => {
      if (frameId.current)
        cancelAnimationFrame(frameId.current);
      if (endFrameId.current)
        clearAnimationTimeout(endFrameId.current);
    };
  }, [
    isExpanded,
    collapsedHeight,
    disableAnimation,
    duration,
    easing,
    onTransitionStateChange
  ]);
  return {
    isExpanded,
    setExpanded,
    getToggleProps(args) {
      const { disabled, onClick, refKey, ...rest } = {
        refKey: "ref",
        onClick() {
        },
        disabled: false,
        ...args
      };
      const isButton = toggleEl ? toggleEl.tagName === "BUTTON" : void 0;
      const theirRef = args?.[refKey || "ref"];
      const props = {
        id: `react-collapsed-toggle-${uniqueId}`,
        "aria-controls": `react-collapsed-panel-${uniqueId}`,
        "aria-expanded": isExpanded,
        onClick(evt) {
          if (disabled)
            return;
          onClick?.(evt);
          setExpanded((n) => !n);
        },
        [refKey || "ref"]: mergeRefs(theirRef, setToggleEl)
      };
      const buttonProps = {
        type: "button",
        disabled: disabled ? true : void 0
      };
      const fakeButtonProps = {
        "aria-disabled": disabled ? true : void 0,
        role: "button",
        tabIndex: disabled ? -1 : 0
      };
      if (isButton === false) {
        return { ...props, ...fakeButtonProps, ...rest };
      } else if (isButton === true) {
        return { ...props, ...buttonProps, ...rest };
      } else {
        return {
          ...props,
          ...buttonProps,
          ...fakeButtonProps,
          ...rest
        };
      }
    },
    getCollapseProps(args) {
      const { style, refKey } = { refKey: "ref", style: {}, ...args };
      const theirRef = args?.[refKey || "ref"];
      return {
        id: `react-collapsed-panel-${uniqueId}`,
        "aria-hidden": !isExpanded,
        "aria-labelledby": `react-collapsed-toggle-${uniqueId}`,
        role: "region",
        ...args,
        [refKey || "ref"]: mergeRefs(collapseElRef, theirRef),
        style: {
          boxSizing: "border-box",
          ...!isAnimating && !isExpanded ? {
            display: collapsedHeight === "0px" ? "none" : "block",
            height: collapsedHeight,
            overflow: "hidden"
          } : {},
          ...style
        }
      };
    }
  };
}



/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_react-collapsed_dist_index_mjs.f991f5a8e0da1e867315.js.map