"use strict";
(self["webpackChunktvb_ext_xircuits"] = self["webpackChunktvb_ext_xircuits"] || []).push([["vendors-node_modules_projectstorm_react-diagrams-core_dist_index_js"],{

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/CanvasEngine.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/CanvasEngine.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CanvasEngine: () => (/* binding */ CanvasEngine)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _core_FactoryBank__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./core/FactoryBank */ "./node_modules/@projectstorm/react-canvas-core/dist/core/FactoryBank.js");
/* harmony import */ var _core_BaseObserver__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./core/BaseObserver */ "./node_modules/@projectstorm/react-canvas-core/dist/core/BaseObserver.js");
/* harmony import */ var _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @projectstorm/geometry */ "webpack/sharing/consume/default/@projectstorm/geometry/@projectstorm/geometry?b1e3");
/* harmony import */ var _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_projectstorm_geometry__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _core_actions_ActionEventBus__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./core-actions/ActionEventBus */ "./node_modules/@projectstorm/react-canvas-core/dist/core-actions/ActionEventBus.js");
/* harmony import */ var _actions_PanAndZoomCanvasAction__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./actions/PanAndZoomCanvasAction */ "./node_modules/@projectstorm/react-canvas-core/dist/actions/PanAndZoomCanvasAction.js");
/* harmony import */ var _actions_ZoomCanvasAction__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./actions/ZoomCanvasAction */ "./node_modules/@projectstorm/react-canvas-core/dist/actions/ZoomCanvasAction.js");
/* harmony import */ var _actions_DeleteItemsAction__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./actions/DeleteItemsAction */ "./node_modules/@projectstorm/react-canvas-core/dist/actions/DeleteItemsAction.js");
/* harmony import */ var _core_state_StateMachine__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./core-state/StateMachine */ "./node_modules/@projectstorm/react-canvas-core/dist/core-state/StateMachine.js");









class CanvasEngine extends _core_BaseObserver__WEBPACK_IMPORTED_MODULE_2__.BaseObserver {
    constructor(options = {}) {
        super();
        this.model = null;
        this.eventBus = new _core_actions_ActionEventBus__WEBPACK_IMPORTED_MODULE_4__.ActionEventBus(this);
        this.stateMachine = new _core_state_StateMachine__WEBPACK_IMPORTED_MODULE_8__.StateMachine(this);
        this.layerFactories = new _core_FactoryBank__WEBPACK_IMPORTED_MODULE_1__.FactoryBank();
        this.registerFactoryBank(this.layerFactories);
        /**
         * Overrides the standard options with the possible given options
         */
        this.options = Object.assign({ registerDefaultDeleteItemsAction: true, registerDefaultZoomCanvasAction: true, repaintDebounceMs: 0 }, options);
        if (this.options.registerDefaultZoomCanvasAction === true) {
            this.eventBus.registerAction(new _actions_ZoomCanvasAction__WEBPACK_IMPORTED_MODULE_6__.ZoomCanvasAction());
        }
        else if (this.options.registerDefaultPanAndZoomCanvasAction === true) {
            this.eventBus.registerAction(new _actions_PanAndZoomCanvasAction__WEBPACK_IMPORTED_MODULE_5__.PanAndZoomCanvasAction());
        }
        if (this.options.registerDefaultDeleteItemsAction === true) {
            this.eventBus.registerAction(new _actions_DeleteItemsAction__WEBPACK_IMPORTED_MODULE_7__.DeleteItemsAction());
        }
    }
    getStateMachine() {
        return this.stateMachine;
    }
    getRelativeMousePoint(event) {
        const point = this.getRelativePoint(event.clientX, event.clientY);
        return new _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_3__.Point((point.x - this.model.getOffsetX()) / (this.model.getZoomLevel() / 100.0), (point.y - this.model.getOffsetY()) / (this.model.getZoomLevel() / 100.0));
    }
    getRelativePoint(x, y) {
        const canvasRect = this.canvas.getBoundingClientRect();
        return new _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_3__.Point(x - canvasRect.left, y - canvasRect.top);
    }
    registerFactoryBank(factory) {
        factory.registerListener({
            factoryAdded: (event) => {
                event.factory.setDiagramEngine(this);
            },
            factoryRemoved: (event) => {
                event.factory.setDiagramEngine(null);
            }
        });
    }
    getActionEventBus() {
        return this.eventBus;
    }
    getLayerFactories() {
        return this.layerFactories;
    }
    getFactoryForLayer(layer) {
        if (typeof layer === 'string') {
            return this.layerFactories.getFactory(layer);
        }
        return this.layerFactories.getFactory(layer.getType());
    }
    setModel(model) {
        this.model = model;
        if (this.canvas) {
            requestAnimationFrame(() => {
                this.repaintCanvas();
            });
        }
    }
    getModel() {
        return this.model;
    }
    repaintCanvas(promise) {
        const { repaintDebounceMs } = this.options;
        /**
         * The actual repaint function
         */
        const repaint = () => {
            this.iterateListeners((listener) => {
                if (listener.repaintCanvas) {
                    listener.repaintCanvas();
                }
            });
        };
        // if the `repaintDebounceMs` option is > 0, then apply the debounce
        let repaintFn = repaint;
        if (repaintDebounceMs > 0) {
            repaintFn = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.debounce)(repaint, repaintDebounceMs);
        }
        if (promise) {
            return new Promise((resolve) => {
                const l = this.registerListener({
                    rendered: () => {
                        resolve();
                        l.deregister();
                    }
                });
                repaintFn();
            });
        }
        repaintFn();
    }
    setCanvas(canvas) {
        if (this.canvas !== canvas) {
            this.canvas = canvas;
            if (canvas) {
                this.fireEvent({}, 'canvasReady');
            }
        }
    }
    getCanvas() {
        return this.canvas;
    }
    getMouseElement(event) {
        return null;
    }
    zoomToFit() {
        const xFactor = this.canvas.clientWidth / this.canvas.scrollWidth;
        const yFactor = this.canvas.clientHeight / this.canvas.scrollHeight;
        const zoomFactor = xFactor < yFactor ? xFactor : yFactor;
        this.model.setZoomLevel(this.model.getZoomLevel() * zoomFactor);
        this.model.setOffset(0, 0);
        this.repaintCanvas();
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/Toolkit.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/Toolkit.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Toolkit: () => (/* binding */ Toolkit)
/* harmony export */ });
class Toolkit {
    /**
     * Generats a unique ID (thanks Stack overflow :3)
     * @returns {String}
     */
    static UID() {
        if (Toolkit.TESTING) {
            Toolkit.TESTING_UID++;
            return `${Toolkit.TESTING_UID}`;
        }
        return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, (c) => {
            const r = (Math.random() * 16) | 0;
            const v = c === 'x' ? r : (r & 0x3) | 0x8;
            return v.toString(16);
        });
    }
    static closest(element, selector) {
        if (!Element.prototype.closest) {
            Element.prototype.closest = function (s) {
                var el = this;
                do {
                    if (Element.prototype.matches.call(el, s))
                        return el;
                    el = el.parentElement || el.parentNode;
                } while (el !== null && el.nodeType === 1);
                return null;
            };
        }
        return element.closest(selector);
    }
}
Toolkit.TESTING = false;
Toolkit.TESTING_UID = 0;


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/actions/DeleteItemsAction.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/actions/DeleteItemsAction.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DeleteItemsAction: () => (/* binding */ DeleteItemsAction)
/* harmony export */ });
/* harmony import */ var _core_actions_Action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../core-actions/Action */ "./node_modules/@projectstorm/react-canvas-core/dist/core-actions/Action.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);


/**
 * Deletes all selected items
 */
class DeleteItemsAction extends _core_actions_Action__WEBPACK_IMPORTED_MODULE_0__.Action {
    constructor(options = {}) {
        const keyCodes = options.keyCodes || [46, 8];
        const modifiers = Object.assign({ ctrlKey: false, shiftKey: false, altKey: false, metaKey: false }, options.modifiers);
        super({
            type: _core_actions_Action__WEBPACK_IMPORTED_MODULE_0__.InputType.KEY_DOWN,
            fire: (event) => {
                const { keyCode, ctrlKey, shiftKey, altKey, metaKey } = event.event;
                if (keyCodes.indexOf(keyCode) !== -1 && lodash__WEBPACK_IMPORTED_MODULE_1__.isEqual({ ctrlKey, shiftKey, altKey, metaKey }, modifiers)) {
                    lodash__WEBPACK_IMPORTED_MODULE_1__.forEach(this.engine.getModel().getSelectedEntities(), (model) => {
                        // only delete items which are not locked
                        if (!model.isLocked()) {
                            model.remove();
                        }
                    });
                    this.engine.repaintCanvas();
                }
            }
        });
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/actions/PanAndZoomCanvasAction.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/actions/PanAndZoomCanvasAction.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PanAndZoomCanvasAction: () => (/* binding */ PanAndZoomCanvasAction)
/* harmony export */ });
/* harmony import */ var _core_actions_Action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../core-actions/Action */ "./node_modules/@projectstorm/react-canvas-core/dist/core-actions/Action.js");

class PanAndZoomCanvasAction extends _core_actions_Action__WEBPACK_IMPORTED_MODULE_0__.Action {
    constructor(options = {}) {
        super({
            type: _core_actions_Action__WEBPACK_IMPORTED_MODULE_0__.InputType.MOUSE_WHEEL,
            fire: (actionEvent) => {
                const { event } = actionEvent;
                // we can block layer rendering because we are only targeting the transforms
                for (let layer of this.engine.getModel().getLayers()) {
                    layer.allowRepaint(false);
                }
                const model = this.engine.getModel();
                event.stopPropagation();
                if (event.ctrlKey) {
                    // Pinch and zoom gesture
                    const oldZoomFactor = this.engine.getModel().getZoomLevel() / 100;
                    let scrollDelta = options.inverseZoom ? event.deltaY : -event.deltaY;
                    scrollDelta /= 3;
                    if (model.getZoomLevel() + scrollDelta > 10) {
                        model.setZoomLevel(model.getZoomLevel() + scrollDelta);
                    }
                    const zoomFactor = model.getZoomLevel() / 100;
                    const boundingRect = event.currentTarget.getBoundingClientRect();
                    const clientWidth = boundingRect.width;
                    const clientHeight = boundingRect.height;
                    // compute difference between rect before and after scroll
                    const widthDiff = clientWidth * zoomFactor - clientWidth * oldZoomFactor;
                    const heightDiff = clientHeight * zoomFactor - clientHeight * oldZoomFactor;
                    // compute mouse coords relative to canvas
                    const clientX = event.clientX - boundingRect.left;
                    const clientY = event.clientY - boundingRect.top;
                    // compute width and height increment factor
                    const xFactor = (clientX - model.getOffsetX()) / oldZoomFactor / clientWidth;
                    const yFactor = (clientY - model.getOffsetY()) / oldZoomFactor / clientHeight;
                    model.setOffset(model.getOffsetX() - widthDiff * xFactor, model.getOffsetY() - heightDiff * yFactor);
                }
                else {
                    // Pan gesture
                    let yDelta = options.inverseZoom ? -event.deltaY : event.deltaY;
                    let xDelta = options.inverseZoom ? -event.deltaX : event.deltaX;
                    model.setOffset(model.getOffsetX() - xDelta, model.getOffsetY() - yDelta);
                }
                this.engine.repaintCanvas();
                // re-enable rendering
                for (let layer of this.engine.getModel().getLayers()) {
                    layer.allowRepaint(true);
                }
            }
        });
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/actions/ZoomCanvasAction.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/actions/ZoomCanvasAction.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ZoomCanvasAction: () => (/* binding */ ZoomCanvasAction)
/* harmony export */ });
/* harmony import */ var _core_actions_Action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../core-actions/Action */ "./node_modules/@projectstorm/react-canvas-core/dist/core-actions/Action.js");

class ZoomCanvasAction extends _core_actions_Action__WEBPACK_IMPORTED_MODULE_0__.Action {
    constructor(options = {}) {
        super({
            type: _core_actions_Action__WEBPACK_IMPORTED_MODULE_0__.InputType.MOUSE_WHEEL,
            fire: (actionEvent) => {
                const { event } = actionEvent;
                // we can block layer rendering because we are only targeting the transforms
                for (let layer of this.engine.getModel().getLayers()) {
                    layer.allowRepaint(false);
                }
                const model = this.engine.getModel();
                event.stopPropagation();
                const oldZoomFactor = this.engine.getModel().getZoomLevel() / 100;
                let scrollDelta = options.inverseZoom ? -event.deltaY : event.deltaY;
                //check if it is pinch gesture
                if (event.ctrlKey && scrollDelta % 1 !== 0) {
                    /*
                        Chrome and Firefox sends wheel event with deltaY that
                        have fractional part, also `ctrlKey` prop of the event is true
                        though ctrl isn't pressed
                    */
                    scrollDelta /= 3;
                }
                else {
                    scrollDelta /= 60;
                }
                if (model.getZoomLevel() + scrollDelta > 10) {
                    model.setZoomLevel(model.getZoomLevel() + scrollDelta);
                }
                const zoomFactor = model.getZoomLevel() / 100;
                const boundingRect = event.currentTarget.getBoundingClientRect();
                const clientWidth = boundingRect.width;
                const clientHeight = boundingRect.height;
                // compute difference between rect before and after scroll
                const widthDiff = clientWidth * zoomFactor - clientWidth * oldZoomFactor;
                const heightDiff = clientHeight * zoomFactor - clientHeight * oldZoomFactor;
                // compute mouse coords relative to canvas
                const clientX = event.clientX - boundingRect.left;
                const clientY = event.clientY - boundingRect.top;
                // compute width and height increment factor
                const xFactor = (clientX - model.getOffsetX()) / oldZoomFactor / clientWidth;
                const yFactor = (clientY - model.getOffsetY()) / oldZoomFactor / clientHeight;
                model.setOffset(model.getOffsetX() - widthDiff * xFactor, model.getOffsetY() - heightDiff * yFactor);
                this.engine.repaintCanvas();
                // re-enable rendering
                for (let layer of this.engine.getModel().getLayers()) {
                    layer.allowRepaint(true);
                }
            }
        });
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/core-actions/Action.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/core-actions/Action.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Action: () => (/* binding */ Action),
/* harmony export */   InputType: () => (/* binding */ InputType)
/* harmony export */ });
/* harmony import */ var _Toolkit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Toolkit */ "./node_modules/@projectstorm/react-canvas-core/dist/Toolkit.js");

var InputType;
(function (InputType) {
    InputType["MOUSE_DOWN"] = "mouse-down";
    InputType["MOUSE_UP"] = "mouse-up";
    InputType["MOUSE_MOVE"] = "mouse-move";
    InputType["MOUSE_WHEEL"] = "mouse-wheel";
    InputType["KEY_DOWN"] = "key-down";
    InputType["KEY_UP"] = "key-up";
    InputType["TOUCH_START"] = "touch-start";
    InputType["TOUCH_END"] = "touch-end";
    InputType["TOUCH_MOVE"] = "touch-move";
})(InputType || (InputType = {}));
class Action {
    constructor(options) {
        this.options = options;
        this.id = _Toolkit__WEBPACK_IMPORTED_MODULE_0__.Toolkit.UID();
    }
    setEngine(engine) {
        this.engine = engine;
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/core-actions/ActionEventBus.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/core-actions/ActionEventBus.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ActionEventBus: () => (/* binding */ ActionEventBus)
/* harmony export */ });
/* harmony import */ var _Action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Action */ "./node_modules/@projectstorm/react-canvas-core/dist/core-actions/Action.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);


class ActionEventBus {
    constructor(engine) {
        this.actions = {};
        this.engine = engine;
        this.keys = {};
    }
    getKeys() {
        return lodash__WEBPACK_IMPORTED_MODULE_1__.keys(this.keys);
    }
    registerAction(action) {
        action.setEngine(this.engine);
        this.actions[action.id] = action;
        return () => {
            this.deregisterAction(action);
        };
    }
    deregisterAction(action) {
        action.setEngine(null);
        delete this.actions[action.id];
    }
    getActionsForType(type) {
        return lodash__WEBPACK_IMPORTED_MODULE_1__.filter(this.actions, (action) => {
            return action.options.type === type;
        });
    }
    getModelForEvent(actionEvent) {
        if (actionEvent.model) {
            return actionEvent.model;
        }
        return this.engine.getMouseElement(actionEvent.event);
    }
    getActionsForEvent(actionEvent) {
        const { event } = actionEvent;
        if (event.type === 'mousedown') {
            return this.getActionsForType(_Action__WEBPACK_IMPORTED_MODULE_0__.InputType.MOUSE_DOWN);
        }
        else if (event.type === 'mouseup') {
            return this.getActionsForType(_Action__WEBPACK_IMPORTED_MODULE_0__.InputType.MOUSE_UP);
        }
        else if (event.type === 'keydown') {
            // store the recorded key
            this.keys[event.key.toLowerCase()] = true;
            return this.getActionsForType(_Action__WEBPACK_IMPORTED_MODULE_0__.InputType.KEY_DOWN);
        }
        else if (event.type === 'keyup') {
            // delete the recorded key
            delete this.keys[event.key.toLowerCase()];
            return this.getActionsForType(_Action__WEBPACK_IMPORTED_MODULE_0__.InputType.KEY_UP);
        }
        else if (event.type === 'mousemove') {
            return this.getActionsForType(_Action__WEBPACK_IMPORTED_MODULE_0__.InputType.MOUSE_MOVE);
        }
        else if (event.type === 'wheel') {
            return this.getActionsForType(_Action__WEBPACK_IMPORTED_MODULE_0__.InputType.MOUSE_WHEEL);
        }
        else if (event.type === 'touchstart') {
            return this.getActionsForType(_Action__WEBPACK_IMPORTED_MODULE_0__.InputType.TOUCH_START);
        }
        else if (event.type === 'touchend') {
            return this.getActionsForType(_Action__WEBPACK_IMPORTED_MODULE_0__.InputType.TOUCH_END);
        }
        else if (event.type === 'touchmove') {
            return this.getActionsForType(_Action__WEBPACK_IMPORTED_MODULE_0__.InputType.TOUCH_MOVE);
        }
        return [];
    }
    fireAction(actionEvent) {
        const actions = this.getActionsForEvent(actionEvent);
        for (let action of actions) {
            action.options.fire(actionEvent);
        }
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/core-models/BaseEntity.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/core-models/BaseEntity.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BaseEntity: () => (/* binding */ BaseEntity)
/* harmony export */ });
/* harmony import */ var _Toolkit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Toolkit */ "./node_modules/@projectstorm/react-canvas-core/dist/Toolkit.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _core_BaseObserver__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/BaseObserver */ "./node_modules/@projectstorm/react-canvas-core/dist/core/BaseObserver.js");



class BaseEntity extends _core_BaseObserver__WEBPACK_IMPORTED_MODULE_2__.BaseObserver {
    constructor(options = {}) {
        super();
        this.options = Object.assign({ id: _Toolkit__WEBPACK_IMPORTED_MODULE_0__.Toolkit.UID() }, options);
    }
    getOptions() {
        return this.options;
    }
    getID() {
        return this.options.id;
    }
    doClone(lookupTable = {}, clone) {
        /*noop*/
    }
    clone(lookupTable = {}) {
        // try and use an existing clone first
        if (lookupTable[this.options.id]) {
            return lookupTable[this.options.id];
        }
        let clone = lodash__WEBPACK_IMPORTED_MODULE_1__.cloneDeep(this);
        clone.options = Object.assign(Object.assign({}, this.options), { id: _Toolkit__WEBPACK_IMPORTED_MODULE_0__.Toolkit.UID() });
        clone.clearListeners();
        lookupTable[this.options.id] = clone;
        this.doClone(lookupTable, clone);
        return clone;
    }
    clearListeners() {
        this.listeners = {};
    }
    deserialize(event) {
        this.options.id = event.data.id;
        this.options.locked = event.data.locked;
    }
    serialize() {
        return {
            id: this.options.id,
            locked: this.options.locked
        };
    }
    fireEvent(event, k) {
        super.fireEvent(Object.assign({ entity: this }, event), k);
    }
    isLocked() {
        return this.options.locked;
    }
    setLocked(locked = true) {
        this.options.locked = locked;
        this.fireEvent({
            locked: locked
        }, 'lockChanged');
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/core-models/BaseModel.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/core-models/BaseModel.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BaseModel: () => (/* binding */ BaseModel)
/* harmony export */ });
/* harmony import */ var _BaseEntity__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseEntity */ "./node_modules/@projectstorm/react-canvas-core/dist/core-models/BaseEntity.js");
/* harmony import */ var _entities_canvas_CanvasModel__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../entities/canvas/CanvasModel */ "./node_modules/@projectstorm/react-canvas-core/dist/entities/canvas/CanvasModel.js");


class BaseModel extends _BaseEntity__WEBPACK_IMPORTED_MODULE_0__.BaseEntity {
    constructor(options) {
        super(options);
    }
    performanceTune() {
        return true;
    }
    getParentCanvasModel() {
        if (!this.parent) {
            return null;
        }
        if (this.parent instanceof _entities_canvas_CanvasModel__WEBPACK_IMPORTED_MODULE_1__.CanvasModel) {
            return this.parent;
        }
        else if (this.parent instanceof BaseModel) {
            return this.parent.getParentCanvasModel();
        }
        return null;
    }
    getParent() {
        return this.parent;
    }
    setParent(parent) {
        this.parent = parent;
    }
    getSelectionEntities() {
        return [this];
    }
    serialize() {
        return Object.assign(Object.assign({}, super.serialize()), { type: this.options.type, selected: this.options.selected, extras: this.options.extras });
    }
    deserialize(event) {
        super.deserialize(event);
        this.options.extras = event.data.extras;
        this.options.selected = event.data.selected;
    }
    getType() {
        return this.options.type;
    }
    isSelected() {
        return this.options.selected;
    }
    isLocked() {
        const locked = super.isLocked();
        if (locked) {
            return true;
        }
        // delegate this call up to the parent
        if (this.parent) {
            return this.parent.isLocked();
        }
        return false;
    }
    setSelected(selected = true) {
        if (this.options.selected !== selected) {
            this.options.selected = selected;
            this.fireEvent({
                isSelected: selected
            }, 'selectionChanged');
        }
    }
    remove() {
        this.fireEvent({}, 'entityRemoved');
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/core-models/BasePositionModel.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/core-models/BasePositionModel.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BasePositionModel: () => (/* binding */ BasePositionModel)
/* harmony export */ });
/* harmony import */ var _BaseModel__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseModel */ "./node_modules/@projectstorm/react-canvas-core/dist/core-models/BaseModel.js");
/* harmony import */ var _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @projectstorm/geometry */ "webpack/sharing/consume/default/@projectstorm/geometry/@projectstorm/geometry?b1e3");
/* harmony import */ var _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_projectstorm_geometry__WEBPACK_IMPORTED_MODULE_1__);


class BasePositionModel extends _BaseModel__WEBPACK_IMPORTED_MODULE_0__.BaseModel {
    constructor(options) {
        super(options);
        this.position = options.position || new _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_1__.Point(0, 0);
    }
    setPosition(x, y) {
        if (x instanceof _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_1__.Point) {
            this.position = x;
        }
        else {
            this.position = new _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_1__.Point(x, y);
        }
        this.fireEvent({}, 'positionChanged');
    }
    getBoundingBox() {
        return _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_1__.Rectangle.fromPointAndSize(this.position, 0, 0);
    }
    deserialize(event) {
        super.deserialize(event);
        this.position = new _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_1__.Point(event.data.x, event.data.y);
    }
    serialize() {
        return Object.assign(Object.assign({}, super.serialize()), { x: this.position.x, y: this.position.y });
    }
    getPosition() {
        return this.position;
    }
    getX() {
        return this.position.x;
    }
    getY() {
        return this.position.y;
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/core-state/AbstractDisplacementState.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/core-state/AbstractDisplacementState.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AbstractDisplacementState: () => (/* binding */ AbstractDisplacementState)
/* harmony export */ });
/* harmony import */ var _State__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./State */ "./node_modules/@projectstorm/react-canvas-core/dist/core-state/State.js");
/* harmony import */ var _core_actions_Action__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../core-actions/Action */ "./node_modules/@projectstorm/react-canvas-core/dist/core-actions/Action.js");


class AbstractDisplacementState extends _State__WEBPACK_IMPORTED_MODULE_0__.State {
    constructor(options) {
        super(options);
        this.registerAction(new _core_actions_Action__WEBPACK_IMPORTED_MODULE_1__.Action({
            type: _core_actions_Action__WEBPACK_IMPORTED_MODULE_1__.InputType.MOUSE_DOWN,
            fire: (actionEvent) => {
                const { clientX, clientY } = actionEvent.event;
                this.handleMoveStart(clientX, clientY);
            }
        }));
        this.registerAction(new _core_actions_Action__WEBPACK_IMPORTED_MODULE_1__.Action({
            type: _core_actions_Action__WEBPACK_IMPORTED_MODULE_1__.InputType.MOUSE_MOVE,
            fire: (actionEvent) => {
                const { event } = actionEvent;
                if (event.buttons === 0) {
                    // If buttons is 0, it means the mouse is not down, the user may have released it
                    // outside of the canvas, then we eject the state
                    this.eject();
                    return;
                }
                const { clientX, clientY } = event;
                this.handleMove(clientX, clientY, event);
            }
        }));
        this.registerAction(new _core_actions_Action__WEBPACK_IMPORTED_MODULE_1__.Action({
            type: _core_actions_Action__WEBPACK_IMPORTED_MODULE_1__.InputType.MOUSE_UP,
            fire: () => this.handleMoveEnd()
        }));
        this.registerAction(new _core_actions_Action__WEBPACK_IMPORTED_MODULE_1__.Action({
            type: _core_actions_Action__WEBPACK_IMPORTED_MODULE_1__.InputType.TOUCH_START,
            fire: (actionEvent) => {
                const { clientX, clientY } = actionEvent.event.touches[0];
                this.handleMoveStart(clientX, clientY);
            }
        }));
        this.registerAction(new _core_actions_Action__WEBPACK_IMPORTED_MODULE_1__.Action({
            type: _core_actions_Action__WEBPACK_IMPORTED_MODULE_1__.InputType.TOUCH_MOVE,
            fire: (actionEvent) => {
                const { event } = actionEvent;
                const { clientX, clientY } = event.touches[0];
                this.handleMove(clientX, clientY, event);
            }
        }));
        this.registerAction(new _core_actions_Action__WEBPACK_IMPORTED_MODULE_1__.Action({
            type: _core_actions_Action__WEBPACK_IMPORTED_MODULE_1__.InputType.TOUCH_END,
            fire: () => this.handleMoveEnd()
        }));
    }
    handleMoveStart(x, y) {
        this.initialX = x;
        this.initialY = y;
        const rel = this.engine.getRelativePoint(x, y);
        this.initialXRelative = rel.x;
        this.initialYRelative = rel.y;
    }
    handleMove(x, y, event) {
        this.fireMouseMoved({
            displacementX: x - this.initialX,
            displacementY: y - this.initialY,
            virtualDisplacementX: (x - this.initialX) / (this.engine.getModel().getZoomLevel() / 100.0),
            virtualDisplacementY: (y - this.initialY) / (this.engine.getModel().getZoomLevel() / 100.0),
            event
        });
    }
    handleMoveEnd() {
        this.eject();
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/core-state/State.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/core-state/State.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   State: () => (/* binding */ State)
/* harmony export */ });
/* harmony import */ var _core_actions_Action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../core-actions/Action */ "./node_modules/@projectstorm/react-canvas-core/dist/core-actions/Action.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);


class State {
    constructor(options) {
        this.actions = [];
        this.keys = [];
        this.childStates = [];
        this.options = options;
    }
    setEngine(engine) {
        this.engine = engine;
    }
    getOptions() {
        return this.options;
    }
    eject() {
        this.engine.getStateMachine().popState();
    }
    transitionWithEvent(state, event) {
        this.engine.getStateMachine().pushState(state);
        this.engine.getActionEventBus().fireAction(event);
    }
    registerAction(action) {
        this.actions.push(action);
    }
    tryActivateParentState(keys) {
        if (this.keys.length > 0 && !this.isKeysFullfilled(keys)) {
            this.eject();
            return true;
        }
        return false;
    }
    tryActivateChildState(keys) {
        const state = this.findStateToActivate(keys);
        if (state) {
            this.engine.getStateMachine().pushState(state);
            return true;
        }
        return false;
    }
    findStateToActivate(keys) {
        for (let child of this.childStates) {
            if (child.isKeysFullfilled(keys)) {
                return child;
            }
        }
        return null;
    }
    isKeysFullfilled(keys) {
        return lodash__WEBPACK_IMPORTED_MODULE_1__.intersection(this.keys, keys).length === this.keys.length;
    }
    activated(previous) {
        const keys = this.engine.getActionEventBus().getKeys();
        if (this.tryActivateParentState(keys) || this.tryActivateChildState(keys)) {
            return;
        }
        // perhaps we need to pop again?
        this.handler1 = this.engine.getActionEventBus().registerAction(new _core_actions_Action__WEBPACK_IMPORTED_MODULE_0__.Action({
            type: _core_actions_Action__WEBPACK_IMPORTED_MODULE_0__.InputType.KEY_DOWN,
            fire: () => {
                this.tryActivateChildState(this.engine.getActionEventBus().getKeys());
            }
        }));
        this.handler2 = this.engine.getActionEventBus().registerAction(new _core_actions_Action__WEBPACK_IMPORTED_MODULE_0__.Action({
            type: _core_actions_Action__WEBPACK_IMPORTED_MODULE_0__.InputType.KEY_UP,
            fire: () => {
                this.tryActivateParentState(this.engine.getActionEventBus().getKeys());
            }
        }));
        for (let action of this.actions) {
            this.engine.getActionEventBus().registerAction(action);
        }
    }
    deactivated(next) {
        if (this.handler1) {
            this.handler1();
        }
        if (this.handler2) {
            this.handler2();
        }
        // if this happens, we are going into heirachial state machine mode
        for (let action of this.actions) {
            this.engine.getActionEventBus().deregisterAction(action);
        }
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/core-state/StateMachine.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/core-state/StateMachine.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   StateMachine: () => (/* binding */ StateMachine)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _core_BaseObserver__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../core/BaseObserver */ "./node_modules/@projectstorm/react-canvas-core/dist/core/BaseObserver.js");


class StateMachine extends _core_BaseObserver__WEBPACK_IMPORTED_MODULE_1__.BaseObserver {
    constructor(engine) {
        super();
        this.engine = engine;
        this.stateStack = [];
    }
    getCurrentState() {
        return this.currentState;
    }
    pushState(state) {
        this.stateStack.push(state);
        this.setState(state);
    }
    popState() {
        this.stateStack.pop();
        this.setState(lodash__WEBPACK_IMPORTED_MODULE_0__.last(this.stateStack));
    }
    setState(state) {
        state.setEngine(this.engine);
        // if no state object, get the initial state
        if (this.currentState) {
            this.currentState.deactivated(state);
        }
        const old = this.currentState;
        this.currentState = state;
        if (this.currentState) {
            this.currentState.activated(old);
            this.fireEvent({
                newState: state
            }, 'stateChanged');
        }
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/core/AbstractFactory.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/core/AbstractFactory.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AbstractFactory: () => (/* binding */ AbstractFactory)
/* harmony export */ });
/**
 * Base factory for all the different types of entities.
 * Gets registered with the engine, and is used to generate models
 */
class AbstractFactory {
    constructor(type) {
        this.type = type;
    }
    setDiagramEngine(engine) {
        this.engine = engine;
    }
    setFactoryBank(bank) {
        this.bank = bank;
    }
    getType() {
        return this.type;
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/core/AbstractModelFactory.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/core/AbstractModelFactory.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AbstractModelFactory: () => (/* binding */ AbstractModelFactory)
/* harmony export */ });
/* harmony import */ var _AbstractFactory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AbstractFactory */ "./node_modules/@projectstorm/react-canvas-core/dist/core/AbstractFactory.js");

class AbstractModelFactory extends _AbstractFactory__WEBPACK_IMPORTED_MODULE_0__.AbstractFactory {
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/core/AbstractReactFactory.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/core/AbstractReactFactory.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AbstractReactFactory: () => (/* binding */ AbstractReactFactory)
/* harmony export */ });
/* harmony import */ var _AbstractModelFactory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AbstractModelFactory */ "./node_modules/@projectstorm/react-canvas-core/dist/core/AbstractModelFactory.js");

/**
 * Further extends the AbstractFactory to add widget generation capability.
 */
class AbstractReactFactory extends _AbstractModelFactory__WEBPACK_IMPORTED_MODULE_0__.AbstractModelFactory {
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/core/BaseObserver.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/core/BaseObserver.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BaseObserver: () => (/* binding */ BaseObserver)
/* harmony export */ });
/* harmony import */ var _Toolkit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Toolkit */ "./node_modules/@projectstorm/react-canvas-core/dist/Toolkit.js");

/**
 * Base observer pattern class for working with listeners
 */
class BaseObserver {
    constructor() {
        this.listeners = {};
    }
    fireEventInternal(fire, k, event) {
        this.iterateListeners((listener) => {
            // returning false here will instruct itteration to stop
            if (!fire && !event.firing) {
                return false;
            }
            // fire selected listener
            if (listener[k]) {
                listener[k](event);
            }
        });
    }
    fireEvent(event, k) {
        event = Object.assign({ firing: true, stopPropagation: () => {
                event.firing = false;
            } }, event);
        // fire pre
        this.fireEventInternal(true, 'eventWillFire', Object.assign(Object.assign({}, event), { function: k }));
        // fire main event
        this.fireEventInternal(false, k, event);
        // fire post
        this.fireEventInternal(true, 'eventDidFire', Object.assign(Object.assign({}, event), { function: k }));
    }
    iterateListeners(cb) {
        for (let id in this.listeners) {
            const res = cb(this.listeners[id]);
            // cancel itteration on false
            if (res === false) {
                return;
            }
        }
    }
    getListenerHandle(listener) {
        for (let id in this.listeners) {
            if (this.listeners[id] === listener) {
                return {
                    id: id,
                    listener: listener,
                    deregister: () => {
                        delete this.listeners[id];
                    }
                };
            }
        }
    }
    registerListener(listener) {
        const id = _Toolkit__WEBPACK_IMPORTED_MODULE_0__.Toolkit.UID();
        this.listeners[id] = listener;
        return {
            id: id,
            listener: listener,
            deregister: () => {
                delete this.listeners[id];
            }
        };
    }
    deregisterListener(listener) {
        if (typeof listener === 'object') {
            listener.deregister();
            return true;
        }
        const handle = this.getListenerHandle(listener);
        if (handle) {
            handle.deregister();
            return true;
        }
        return false;
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/core/FactoryBank.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/core/FactoryBank.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FactoryBank: () => (/* binding */ FactoryBank)
/* harmony export */ });
/* harmony import */ var _BaseObserver__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseObserver */ "./node_modules/@projectstorm/react-canvas-core/dist/core/BaseObserver.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);


/**
 * Store and managed Factories that extend from Abstractfactory
 */
class FactoryBank extends _BaseObserver__WEBPACK_IMPORTED_MODULE_0__.BaseObserver {
    constructor() {
        super();
        this.factories = {};
    }
    getFactories() {
        return lodash__WEBPACK_IMPORTED_MODULE_1__.values(this.factories);
    }
    clearFactories() {
        for (let factory in this.factories) {
            this.deregisterFactory(factory);
        }
    }
    getFactory(type) {
        if (!this.factories[type]) {
            throw new Error(`Cannot find factory with type [${type}]`);
        }
        return this.factories[type];
    }
    registerFactory(factory) {
        factory.setFactoryBank(this);
        this.factories[factory.getType()] = factory;
        // todo fixme
        this.fireEvent({ factory }, 'factoryAdded');
    }
    deregisterFactory(type) {
        const factory = this.factories[type];
        factory.setFactoryBank(null);
        delete this.factories[type];
        // todo fixme
        this.fireEvent({ factory }, 'factoryRemoved');
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/core/ModelGeometryInterface.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/core/ModelGeometryInterface.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);



/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/entities/canvas/CanvasModel.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/entities/canvas/CanvasModel.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CanvasModel: () => (/* binding */ CanvasModel)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _core_models_BaseEntity__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core-models/BaseEntity */ "./node_modules/@projectstorm/react-canvas-core/dist/core-models/BaseEntity.js");


class CanvasModel extends _core_models_BaseEntity__WEBPACK_IMPORTED_MODULE_1__.BaseEntity {
    constructor(options = {}) {
        super(Object.assign({ zoom: 100, gridSize: 0, offsetX: 0, offsetY: 0 }, options));
        this.layers = [];
    }
    getSelectionEntities() {
        return lodash__WEBPACK_IMPORTED_MODULE_0__.flatMap(this.layers, (layer) => {
            return layer.getSelectionEntities();
        });
    }
    getSelectedEntities() {
        return lodash__WEBPACK_IMPORTED_MODULE_0__.filter(this.getSelectionEntities(), (ob) => {
            return ob.isSelected();
        });
    }
    clearSelection() {
        lodash__WEBPACK_IMPORTED_MODULE_0__.forEach(this.getSelectedEntities(), (element) => {
            element.setSelected(false);
        });
    }
    getModels() {
        return lodash__WEBPACK_IMPORTED_MODULE_0__.flatMap(this.layers, (layer) => {
            return lodash__WEBPACK_IMPORTED_MODULE_0__.values(layer.getModels());
        });
    }
    addLayer(layer) {
        layer.setParent(this);
        layer.registerListener({
            entityRemoved: (event) => { }
        });
        this.layers.push(layer);
    }
    removeLayer(layer) {
        const index = this.layers.indexOf(layer);
        if (index !== -1) {
            this.layers.splice(index, 1);
            return true;
        }
        return false;
    }
    getLayers() {
        return this.layers;
    }
    setGridSize(size = 0) {
        this.options.gridSize = size;
        this.fireEvent({ size: size }, 'gridUpdated');
    }
    getGridPosition(pos) {
        if (this.options.gridSize === 0) {
            return pos;
        }
        return this.options.gridSize * Math.floor((pos + this.options.gridSize / 2) / this.options.gridSize);
    }
    deserializeModel(data, engine) {
        const models = {};
        const promises = {};
        const resolvers = {};
        const event = {
            data: data,
            engine: engine,
            registerModel: (model) => {
                models[model.getID()] = model;
                if (resolvers[model.getID()]) {
                    resolvers[model.getID()](model);
                }
            },
            getModel(id) {
                if (models[id]) {
                    return Promise.resolve(models[id]);
                }
                if (!promises[id]) {
                    promises[id] = new Promise((resolve) => {
                        resolvers[id] = resolve;
                    });
                }
                return promises[id];
            }
        };
        this.deserialize(event);
    }
    deserialize(event) {
        super.deserialize(event);
        this.options.offsetX = event.data.offsetX;
        this.options.offsetY = event.data.offsetY;
        this.options.zoom = event.data.zoom;
        this.options.gridSize = event.data.gridSize;
        lodash__WEBPACK_IMPORTED_MODULE_0__.forEach(event.data.layers, (layer) => {
            const layerOb = event.engine.getFactoryForLayer(layer.type).generateModel({
                initialConfig: layer
            });
            layerOb.deserialize(Object.assign(Object.assign({}, event), { data: layer }));
            this.addLayer(layerOb);
        });
    }
    serialize() {
        return Object.assign(Object.assign({}, super.serialize()), { offsetX: this.options.offsetX, offsetY: this.options.offsetY, zoom: this.options.zoom, gridSize: this.options.gridSize, layers: lodash__WEBPACK_IMPORTED_MODULE_0__.map(this.layers, (layer) => {
                return layer.serialize();
            }) });
    }
    setZoomLevel(zoom) {
        this.options.zoom = zoom;
        this.fireEvent({ zoom }, 'zoomUpdated');
    }
    setOffset(offsetX, offsetY) {
        this.options.offsetX = offsetX;
        this.options.offsetY = offsetY;
        this.fireEvent({ offsetX, offsetY }, 'offsetUpdated');
    }
    setOffsetX(offsetX) {
        this.setOffset(offsetX, this.options.offsetY);
    }
    setOffsetY(offsetY) {
        this.setOffset(this.options.offsetX, offsetY);
    }
    getOffsetY() {
        return this.options.offsetY;
    }
    getOffsetX() {
        return this.options.offsetX;
    }
    getZoomLevel() {
        return this.options.zoom;
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/entities/canvas/CanvasWidget.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/entities/canvas/CanvasWidget.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CanvasWidget: () => (/* binding */ CanvasWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _layer_TransformLayerWidget__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../layer/TransformLayerWidget */ "./node_modules/@projectstorm/react-canvas-core/dist/entities/layer/TransformLayerWidget.js");
/* harmony import */ var _emotion_styled__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @emotion/styled */ "webpack/sharing/consume/default/@emotion/styled/@emotion/styled?5d9f");
/* harmony import */ var _emotion_styled__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_emotion_styled__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _layer_SmartLayerWidget__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../layer/SmartLayerWidget */ "./node_modules/@projectstorm/react-canvas-core/dist/entities/layer/SmartLayerWidget.js");




var S;
(function (S) {
    S.Canvas = (_emotion_styled__WEBPACK_IMPORTED_MODULE_2___default().div) `
		position: relative;
		cursor: move;
		overflow: hidden;
	`;
})(S || (S = {}));
class CanvasWidget extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.ref = react__WEBPACK_IMPORTED_MODULE_0__.createRef();
        this.state = {
            action: null,
            diagramEngineListener: null
        };
    }
    componentWillUnmount() {
        this.props.engine.deregisterListener(this.canvasListener);
        this.props.engine.setCanvas(null);
        document.removeEventListener('keyup', this.keyUp);
        document.removeEventListener('keydown', this.keyDown);
    }
    registerCanvas() {
        this.props.engine.setCanvas(this.ref.current);
        this.props.engine.iterateListeners((list) => {
            list.rendered && list.rendered();
        });
    }
    componentDidUpdate() {
        this.registerCanvas();
    }
    componentDidMount() {
        this.canvasListener = this.props.engine.registerListener({
            repaintCanvas: () => {
                this.forceUpdate();
            }
        });
        this.keyDown = (event) => {
            this.props.engine.getActionEventBus().fireAction({ event });
        };
        this.keyUp = (event) => {
            this.props.engine.getActionEventBus().fireAction({ event });
        };
        document.addEventListener('keyup', this.keyUp);
        document.addEventListener('keydown', this.keyDown);
        this.registerCanvas();
    }
    render() {
        const engine = this.props.engine;
        const model = engine.getModel();
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(S.Canvas, { className: this.props.className, ref: this.ref, onWheel: (event) => {
                this.props.engine.getActionEventBus().fireAction({ event });
            }, onMouseDown: (event) => {
                this.props.engine.getActionEventBus().fireAction({ event });
            }, onMouseUp: (event) => {
                this.props.engine.getActionEventBus().fireAction({ event });
            }, onMouseMove: (event) => {
                this.props.engine.getActionEventBus().fireAction({ event });
            }, onTouchStart: (event) => {
                this.props.engine.getActionEventBus().fireAction({ event });
            }, onTouchEnd: (event) => {
                this.props.engine.getActionEventBus().fireAction({ event });
            }, onTouchMove: (event) => {
                this.props.engine.getActionEventBus().fireAction({ event });
            } }, model.getLayers().map((layer) => {
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_layer_TransformLayerWidget__WEBPACK_IMPORTED_MODULE_1__.TransformLayerWidget, { layer: layer, key: layer.getID() },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_layer_SmartLayerWidget__WEBPACK_IMPORTED_MODULE_3__.SmartLayerWidget, { layer: layer, engine: this.props.engine, key: layer.getID() })));
        })));
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/entities/layer/LayerModel.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/entities/layer/LayerModel.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LayerModel: () => (/* binding */ LayerModel)
/* harmony export */ });
/* harmony import */ var _core_models_BaseModel__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core-models/BaseModel */ "./node_modules/@projectstorm/react-canvas-core/dist/core-models/BaseModel.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);


class LayerModel extends _core_models_BaseModel__WEBPACK_IMPORTED_MODULE_0__.BaseModel {
    constructor(options = {}) {
        super(options);
        this.models = {};
        this.repaintEnabled = true;
    }
    deserialize(event) {
        super.deserialize(event);
        this.options.isSvg = !!event.data.isSvg;
        this.options.transformed = !!event.data.transformed;
        lodash__WEBPACK_IMPORTED_MODULE_1__.forEach(event.data.models, (model) => {
            const modelOb = this.getChildModelFactoryBank(event.engine).getFactory(model.type).generateModel({
                initialConfig: model
            });
            modelOb.deserialize(Object.assign(Object.assign({}, event), { data: model }));
            this.addModel(modelOb);
        });
    }
    serialize() {
        return Object.assign(Object.assign({}, super.serialize()), { isSvg: this.options.isSvg, transformed: this.options.transformed, models: lodash__WEBPACK_IMPORTED_MODULE_1__.mapValues(this.models, (model) => {
                return model.serialize();
            }) });
    }
    isRepaintEnabled() {
        return this.repaintEnabled;
    }
    allowRepaint(allow = true) {
        this.repaintEnabled = allow;
    }
    remove() {
        if (this.parent) {
            this.parent.removeLayer(this);
        }
        super.remove();
    }
    addModel(model) {
        model.setParent(this);
        this.models[model.getID()] = model;
    }
    getSelectionEntities() {
        return lodash__WEBPACK_IMPORTED_MODULE_1__.flatMap(this.models, (model) => {
            return model.getSelectionEntities();
        });
    }
    getModels() {
        return this.models;
    }
    getModel(id) {
        return this.models[id];
    }
    removeModel(id) {
        const _id = typeof id === 'string' ? id : id.getID();
        if (this.models[_id]) {
            delete this.models[_id];
            return true;
        }
        return false;
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/entities/layer/SmartLayerWidget.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/entities/layer/SmartLayerWidget.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SmartLayerWidget: () => (/* binding */ SmartLayerWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

class SmartLayerWidget extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    shouldComponentUpdate() {
        return this.props.layer.isRepaintEnabled();
    }
    render() {
        return this.props.engine.getFactoryForLayer(this.props.layer).generateReactWidget({ model: this.props.layer });
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/entities/layer/TransformLayerWidget.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/entities/layer/TransformLayerWidget.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TransformLayerWidget: () => (/* binding */ TransformLayerWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _emotion_styled__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/styled */ "webpack/sharing/consume/default/@emotion/styled/@emotion/styled?5d9f");
/* harmony import */ var _emotion_styled__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_emotion_styled__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @emotion/react */ "webpack/sharing/consume/default/@emotion/react/@emotion/react?fbe7");
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_emotion_react__WEBPACK_IMPORTED_MODULE_2__);



var S;
(function (S) {
    const shared = (0,_emotion_react__WEBPACK_IMPORTED_MODULE_2__.css) `
		top: 0;
		left: 0;
		right: 0;
		bottom: 0;
		position: absolute;
		pointer-events: none;
		transform-origin: 0 0;
		width: 100%;
		height: 100%;
		overflow: visible;
	`;
    S.DivLayer = (_emotion_styled__WEBPACK_IMPORTED_MODULE_1___default().div) `
		${shared}
	`;
    S.SvgLayer = (_emotion_styled__WEBPACK_IMPORTED_MODULE_1___default().svg) `
		${shared}
	`;
})(S || (S = {}));
class TransformLayerWidget extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.state = {};
    }
    getTransform() {
        const model = this.props.layer.getParent();
        return `
			translate(
				${model.getOffsetX()}px,
				${model.getOffsetY()}px)
			scale(
				${model.getZoomLevel() / 100.0}
			)
  	`;
    }
    getTransformStyle() {
        if (this.props.layer.getOptions().transformed) {
            return {
                transform: this.getTransform()
            };
        }
        return {};
    }
    render() {
        if (this.props.layer.getOptions().isSvg) {
            return react__WEBPACK_IMPORTED_MODULE_0__.createElement(S.SvgLayer, { style: this.getTransformStyle() }, this.props.children);
        }
        return react__WEBPACK_IMPORTED_MODULE_0__.createElement(S.DivLayer, { style: this.getTransformStyle() }, this.props.children);
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/entities/selection/SelectionBoxLayerFactory.js":
/*!**********************************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/entities/selection/SelectionBoxLayerFactory.js ***!
  \**********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SelectionBoxLayerFactory: () => (/* binding */ SelectionBoxLayerFactory)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _core_AbstractReactFactory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/AbstractReactFactory */ "./node_modules/@projectstorm/react-canvas-core/dist/core/AbstractReactFactory.js");
/* harmony import */ var _SelectionLayerModel__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SelectionLayerModel */ "./node_modules/@projectstorm/react-canvas-core/dist/entities/selection/SelectionLayerModel.js");
/* harmony import */ var _SelectionBoxWidget__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./SelectionBoxWidget */ "./node_modules/@projectstorm/react-canvas-core/dist/entities/selection/SelectionBoxWidget.js");




class SelectionBoxLayerFactory extends _core_AbstractReactFactory__WEBPACK_IMPORTED_MODULE_1__.AbstractReactFactory {
    constructor() {
        super('selection');
    }
    generateModel(event) {
        return new _SelectionLayerModel__WEBPACK_IMPORTED_MODULE_2__.SelectionLayerModel();
    }
    generateReactWidget(event) {
        return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_SelectionBoxWidget__WEBPACK_IMPORTED_MODULE_3__.SelectionBoxWidget, { rect: event.model.box });
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/entities/selection/SelectionBoxWidget.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/entities/selection/SelectionBoxWidget.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SelectionBoxWidget: () => (/* binding */ SelectionBoxWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _emotion_styled__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/styled */ "webpack/sharing/consume/default/@emotion/styled/@emotion/styled?5d9f");
/* harmony import */ var _emotion_styled__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_emotion_styled__WEBPACK_IMPORTED_MODULE_1__);


var S;
(function (S) {
    S.Container = (_emotion_styled__WEBPACK_IMPORTED_MODULE_1___default().div) `
		position: absolute;
		background-color: rgba(0, 192, 255, 0.2);
		border: solid 2px rgb(0, 192, 255);
	`;
})(S || (S = {}));
class SelectionBoxWidget extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    render() {
        const { rect } = this.props;
        if (!rect)
            return null;
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(S.Container, { style: {
                top: rect.top,
                left: rect.left,
                width: rect.width,
                height: rect.height
            } }));
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/entities/selection/SelectionLayerModel.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/entities/selection/SelectionLayerModel.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SelectionLayerModel: () => (/* binding */ SelectionLayerModel)
/* harmony export */ });
/* harmony import */ var _layer_LayerModel__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../layer/LayerModel */ "./node_modules/@projectstorm/react-canvas-core/dist/entities/layer/LayerModel.js");

class SelectionLayerModel extends _layer_LayerModel__WEBPACK_IMPORTED_MODULE_0__.LayerModel {
    constructor() {
        super({
            transformed: false,
            isSvg: false,
            type: 'selection'
        });
    }
    setBox(rect) {
        this.box = rect;
    }
    getChildModelFactoryBank() {
        // is not used as it doesnt serialize
        return null;
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/index.js":
/*!********************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/index.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AbstractDisplacementState: () => (/* reexport safe */ _core_state_AbstractDisplacementState__WEBPACK_IMPORTED_MODULE_22__.AbstractDisplacementState),
/* harmony export */   AbstractFactory: () => (/* reexport safe */ _core_AbstractFactory__WEBPACK_IMPORTED_MODULE_3__.AbstractFactory),
/* harmony export */   AbstractModelFactory: () => (/* reexport safe */ _core_AbstractModelFactory__WEBPACK_IMPORTED_MODULE_4__.AbstractModelFactory),
/* harmony export */   AbstractReactFactory: () => (/* reexport safe */ _core_AbstractReactFactory__WEBPACK_IMPORTED_MODULE_5__.AbstractReactFactory),
/* harmony export */   Action: () => (/* reexport safe */ _core_actions_Action__WEBPACK_IMPORTED_MODULE_9__.Action),
/* harmony export */   ActionEventBus: () => (/* reexport safe */ _core_actions_ActionEventBus__WEBPACK_IMPORTED_MODULE_10__.ActionEventBus),
/* harmony export */   BaseEntity: () => (/* reexport safe */ _core_models_BaseEntity__WEBPACK_IMPORTED_MODULE_11__.BaseEntity),
/* harmony export */   BaseModel: () => (/* reexport safe */ _core_models_BaseModel__WEBPACK_IMPORTED_MODULE_12__.BaseModel),
/* harmony export */   BaseObserver: () => (/* reexport safe */ _core_BaseObserver__WEBPACK_IMPORTED_MODULE_6__.BaseObserver),
/* harmony export */   BasePositionModel: () => (/* reexport safe */ _core_models_BasePositionModel__WEBPACK_IMPORTED_MODULE_13__.BasePositionModel),
/* harmony export */   CanvasEngine: () => (/* reexport safe */ _CanvasEngine__WEBPACK_IMPORTED_MODULE_0__.CanvasEngine),
/* harmony export */   CanvasModel: () => (/* reexport safe */ _entities_canvas_CanvasModel__WEBPACK_IMPORTED_MODULE_2__.CanvasModel),
/* harmony export */   CanvasWidget: () => (/* reexport safe */ _entities_canvas_CanvasWidget__WEBPACK_IMPORTED_MODULE_14__.CanvasWidget),
/* harmony export */   DefaultState: () => (/* reexport safe */ _states_DefaultState__WEBPACK_IMPORTED_MODULE_25__.DefaultState),
/* harmony export */   DeleteItemsAction: () => (/* reexport safe */ _actions_DeleteItemsAction__WEBPACK_IMPORTED_MODULE_30__.DeleteItemsAction),
/* harmony export */   DragCanvasState: () => (/* reexport safe */ _states_DragCanvasState__WEBPACK_IMPORTED_MODULE_26__.DragCanvasState),
/* harmony export */   FactoryBank: () => (/* reexport safe */ _core_FactoryBank__WEBPACK_IMPORTED_MODULE_7__.FactoryBank),
/* harmony export */   InputType: () => (/* reexport safe */ _core_actions_Action__WEBPACK_IMPORTED_MODULE_9__.InputType),
/* harmony export */   LayerModel: () => (/* reexport safe */ _entities_layer_LayerModel__WEBPACK_IMPORTED_MODULE_15__.LayerModel),
/* harmony export */   MoveItemsState: () => (/* reexport safe */ _states_MoveItemsState__WEBPACK_IMPORTED_MODULE_29__.MoveItemsState),
/* harmony export */   PanAndZoomCanvasAction: () => (/* reexport safe */ _actions_PanAndZoomCanvasAction__WEBPACK_IMPORTED_MODULE_32__.PanAndZoomCanvasAction),
/* harmony export */   PeformanceWidget: () => (/* reexport safe */ _widgets_PeformanceWidget__WEBPACK_IMPORTED_MODULE_21__.PeformanceWidget),
/* harmony export */   SelectingState: () => (/* reexport safe */ _states_SelectingState__WEBPACK_IMPORTED_MODULE_27__.SelectingState),
/* harmony export */   SelectionBoxLayerFactory: () => (/* reexport safe */ _entities_selection_SelectionBoxLayerFactory__WEBPACK_IMPORTED_MODULE_18__.SelectionBoxLayerFactory),
/* harmony export */   SelectionBoxState: () => (/* reexport safe */ _states_SelectionBoxState__WEBPACK_IMPORTED_MODULE_28__.SelectionBoxState),
/* harmony export */   SelectionBoxWidget: () => (/* reexport safe */ _entities_selection_SelectionBoxWidget__WEBPACK_IMPORTED_MODULE_19__.SelectionBoxWidget),
/* harmony export */   SelectionLayerModel: () => (/* reexport safe */ _entities_selection_SelectionLayerModel__WEBPACK_IMPORTED_MODULE_20__.SelectionLayerModel),
/* harmony export */   SmartLayerWidget: () => (/* reexport safe */ _entities_layer_SmartLayerWidget__WEBPACK_IMPORTED_MODULE_17__.SmartLayerWidget),
/* harmony export */   State: () => (/* reexport safe */ _core_state_State__WEBPACK_IMPORTED_MODULE_23__.State),
/* harmony export */   StateMachine: () => (/* reexport safe */ _core_state_StateMachine__WEBPACK_IMPORTED_MODULE_24__.StateMachine),
/* harmony export */   Toolkit: () => (/* reexport safe */ _Toolkit__WEBPACK_IMPORTED_MODULE_1__.Toolkit),
/* harmony export */   TransformLayerWidget: () => (/* reexport safe */ _entities_layer_TransformLayerWidget__WEBPACK_IMPORTED_MODULE_16__.TransformLayerWidget),
/* harmony export */   ZoomCanvasAction: () => (/* reexport safe */ _actions_ZoomCanvasAction__WEBPACK_IMPORTED_MODULE_31__.ZoomCanvasAction)
/* harmony export */ });
/* harmony import */ var _CanvasEngine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CanvasEngine */ "./node_modules/@projectstorm/react-canvas-core/dist/CanvasEngine.js");
/* harmony import */ var _Toolkit__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Toolkit */ "./node_modules/@projectstorm/react-canvas-core/dist/Toolkit.js");
/* harmony import */ var _entities_canvas_CanvasModel__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./entities/canvas/CanvasModel */ "./node_modules/@projectstorm/react-canvas-core/dist/entities/canvas/CanvasModel.js");
/* harmony import */ var _core_AbstractFactory__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./core/AbstractFactory */ "./node_modules/@projectstorm/react-canvas-core/dist/core/AbstractFactory.js");
/* harmony import */ var _core_AbstractModelFactory__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./core/AbstractModelFactory */ "./node_modules/@projectstorm/react-canvas-core/dist/core/AbstractModelFactory.js");
/* harmony import */ var _core_AbstractReactFactory__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./core/AbstractReactFactory */ "./node_modules/@projectstorm/react-canvas-core/dist/core/AbstractReactFactory.js");
/* harmony import */ var _core_BaseObserver__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./core/BaseObserver */ "./node_modules/@projectstorm/react-canvas-core/dist/core/BaseObserver.js");
/* harmony import */ var _core_FactoryBank__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./core/FactoryBank */ "./node_modules/@projectstorm/react-canvas-core/dist/core/FactoryBank.js");
/* harmony import */ var _core_ModelGeometryInterface__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./core/ModelGeometryInterface */ "./node_modules/@projectstorm/react-canvas-core/dist/core/ModelGeometryInterface.js");
/* harmony import */ var _core_actions_Action__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./core-actions/Action */ "./node_modules/@projectstorm/react-canvas-core/dist/core-actions/Action.js");
/* harmony import */ var _core_actions_ActionEventBus__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./core-actions/ActionEventBus */ "./node_modules/@projectstorm/react-canvas-core/dist/core-actions/ActionEventBus.js");
/* harmony import */ var _core_models_BaseEntity__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./core-models/BaseEntity */ "./node_modules/@projectstorm/react-canvas-core/dist/core-models/BaseEntity.js");
/* harmony import */ var _core_models_BaseModel__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./core-models/BaseModel */ "./node_modules/@projectstorm/react-canvas-core/dist/core-models/BaseModel.js");
/* harmony import */ var _core_models_BasePositionModel__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./core-models/BasePositionModel */ "./node_modules/@projectstorm/react-canvas-core/dist/core-models/BasePositionModel.js");
/* harmony import */ var _entities_canvas_CanvasWidget__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./entities/canvas/CanvasWidget */ "./node_modules/@projectstorm/react-canvas-core/dist/entities/canvas/CanvasWidget.js");
/* harmony import */ var _entities_layer_LayerModel__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./entities/layer/LayerModel */ "./node_modules/@projectstorm/react-canvas-core/dist/entities/layer/LayerModel.js");
/* harmony import */ var _entities_layer_TransformLayerWidget__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./entities/layer/TransformLayerWidget */ "./node_modules/@projectstorm/react-canvas-core/dist/entities/layer/TransformLayerWidget.js");
/* harmony import */ var _entities_layer_SmartLayerWidget__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./entities/layer/SmartLayerWidget */ "./node_modules/@projectstorm/react-canvas-core/dist/entities/layer/SmartLayerWidget.js");
/* harmony import */ var _entities_selection_SelectionBoxLayerFactory__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./entities/selection/SelectionBoxLayerFactory */ "./node_modules/@projectstorm/react-canvas-core/dist/entities/selection/SelectionBoxLayerFactory.js");
/* harmony import */ var _entities_selection_SelectionBoxWidget__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./entities/selection/SelectionBoxWidget */ "./node_modules/@projectstorm/react-canvas-core/dist/entities/selection/SelectionBoxWidget.js");
/* harmony import */ var _entities_selection_SelectionLayerModel__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./entities/selection/SelectionLayerModel */ "./node_modules/@projectstorm/react-canvas-core/dist/entities/selection/SelectionLayerModel.js");
/* harmony import */ var _widgets_PeformanceWidget__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./widgets/PeformanceWidget */ "./node_modules/@projectstorm/react-canvas-core/dist/widgets/PeformanceWidget.js");
/* harmony import */ var _core_state_AbstractDisplacementState__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./core-state/AbstractDisplacementState */ "./node_modules/@projectstorm/react-canvas-core/dist/core-state/AbstractDisplacementState.js");
/* harmony import */ var _core_state_State__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./core-state/State */ "./node_modules/@projectstorm/react-canvas-core/dist/core-state/State.js");
/* harmony import */ var _core_state_StateMachine__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./core-state/StateMachine */ "./node_modules/@projectstorm/react-canvas-core/dist/core-state/StateMachine.js");
/* harmony import */ var _states_DefaultState__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./states/DefaultState */ "./node_modules/@projectstorm/react-canvas-core/dist/states/DefaultState.js");
/* harmony import */ var _states_DragCanvasState__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./states/DragCanvasState */ "./node_modules/@projectstorm/react-canvas-core/dist/states/DragCanvasState.js");
/* harmony import */ var _states_SelectingState__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./states/SelectingState */ "./node_modules/@projectstorm/react-canvas-core/dist/states/SelectingState.js");
/* harmony import */ var _states_SelectionBoxState__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./states/SelectionBoxState */ "./node_modules/@projectstorm/react-canvas-core/dist/states/SelectionBoxState.js");
/* harmony import */ var _states_MoveItemsState__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./states/MoveItemsState */ "./node_modules/@projectstorm/react-canvas-core/dist/states/MoveItemsState.js");
/* harmony import */ var _actions_DeleteItemsAction__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./actions/DeleteItemsAction */ "./node_modules/@projectstorm/react-canvas-core/dist/actions/DeleteItemsAction.js");
/* harmony import */ var _actions_ZoomCanvasAction__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./actions/ZoomCanvasAction */ "./node_modules/@projectstorm/react-canvas-core/dist/actions/ZoomCanvasAction.js");
/* harmony import */ var _actions_PanAndZoomCanvasAction__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./actions/PanAndZoomCanvasAction */ "./node_modules/@projectstorm/react-canvas-core/dist/actions/PanAndZoomCanvasAction.js");




































/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/states/DefaultState.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/states/DefaultState.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DefaultState: () => (/* binding */ DefaultState)
/* harmony export */ });
/* harmony import */ var _core_state_State__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../core-state/State */ "./node_modules/@projectstorm/react-canvas-core/dist/core-state/State.js");
/* harmony import */ var _core_actions_Action__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../core-actions/Action */ "./node_modules/@projectstorm/react-canvas-core/dist/core-actions/Action.js");
/* harmony import */ var _DragCanvasState__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./DragCanvasState */ "./node_modules/@projectstorm/react-canvas-core/dist/states/DragCanvasState.js");
/* harmony import */ var _SelectingState__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./SelectingState */ "./node_modules/@projectstorm/react-canvas-core/dist/states/SelectingState.js");
/* harmony import */ var _MoveItemsState__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./MoveItemsState */ "./node_modules/@projectstorm/react-canvas-core/dist/states/MoveItemsState.js");





class DefaultState extends _core_state_State__WEBPACK_IMPORTED_MODULE_0__.State {
    constructor() {
        super({
            name: 'default'
        });
        this.childStates = [new _SelectingState__WEBPACK_IMPORTED_MODULE_3__.SelectingState()];
        // determine what was clicked on
        this.registerAction(new _core_actions_Action__WEBPACK_IMPORTED_MODULE_1__.Action({
            type: _core_actions_Action__WEBPACK_IMPORTED_MODULE_1__.InputType.MOUSE_DOWN,
            fire: (event) => {
                const element = this.engine.getActionEventBus().getModelForEvent(event);
                // the canvas was clicked on, transition to the dragging canvas state
                if (!element) {
                    this.transitionWithEvent(new _DragCanvasState__WEBPACK_IMPORTED_MODULE_2__.DragCanvasState(), event);
                }
                else {
                    this.transitionWithEvent(new _MoveItemsState__WEBPACK_IMPORTED_MODULE_4__.MoveItemsState(), event);
                }
            }
        }));
        // touch drags the canvas
        this.registerAction(new _core_actions_Action__WEBPACK_IMPORTED_MODULE_1__.Action({
            type: _core_actions_Action__WEBPACK_IMPORTED_MODULE_1__.InputType.TOUCH_START,
            fire: (event) => {
                this.transitionWithEvent(new _DragCanvasState__WEBPACK_IMPORTED_MODULE_2__.DragCanvasState(), event);
            }
        }));
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/states/DragCanvasState.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/states/DragCanvasState.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DragCanvasState: () => (/* binding */ DragCanvasState)
/* harmony export */ });
/* harmony import */ var _core_state_AbstractDisplacementState__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../core-state/AbstractDisplacementState */ "./node_modules/@projectstorm/react-canvas-core/dist/core-state/AbstractDisplacementState.js");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class DragCanvasState extends _core_state_AbstractDisplacementState__WEBPACK_IMPORTED_MODULE_0__.AbstractDisplacementState {
    constructor(options = {}) {
        super({
            name: 'drag-canvas'
        });
        this.config = Object.assign({ allowDrag: true }, options);
    }
    activated(prev) {
        const _super = Object.create(null, {
            activated: { get: () => super.activated }
        });
        return __awaiter(this, void 0, void 0, function* () {
            _super.activated.call(this, prev);
            this.engine.getModel().clearSelection();
            yield this.engine.repaintCanvas(true);
            // we can block layer rendering because we are only targeting the transforms
            for (let layer of this.engine.getModel().getLayers()) {
                layer.allowRepaint(false);
            }
            this.initialCanvasX = this.engine.getModel().getOffsetX();
            this.initialCanvasY = this.engine.getModel().getOffsetY();
        });
    }
    deactivated(next) {
        super.deactivated(next);
        for (let layer of this.engine.getModel().getLayers()) {
            layer.allowRepaint(true);
        }
    }
    fireMouseMoved(event) {
        if (this.config.allowDrag) {
            this.engine
                .getModel()
                .setOffset(this.initialCanvasX + event.displacementX, this.initialCanvasY + event.displacementY);
            this.engine.repaintCanvas();
        }
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/states/MoveItemsState.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/states/MoveItemsState.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MoveItemsState: () => (/* binding */ MoveItemsState)
/* harmony export */ });
/* harmony import */ var _core_state_AbstractDisplacementState__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../core-state/AbstractDisplacementState */ "./node_modules/@projectstorm/react-canvas-core/dist/core-state/AbstractDisplacementState.js");
/* harmony import */ var _core_actions_Action__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../core-actions/Action */ "./node_modules/@projectstorm/react-canvas-core/dist/core-actions/Action.js");
/* harmony import */ var _core_models_BasePositionModel__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core-models/BasePositionModel */ "./node_modules/@projectstorm/react-canvas-core/dist/core-models/BasePositionModel.js");



class MoveItemsState extends _core_state_AbstractDisplacementState__WEBPACK_IMPORTED_MODULE_0__.AbstractDisplacementState {
    constructor() {
        super({
            name: 'move-items'
        });
        this.registerAction(new _core_actions_Action__WEBPACK_IMPORTED_MODULE_1__.Action({
            type: _core_actions_Action__WEBPACK_IMPORTED_MODULE_1__.InputType.MOUSE_DOWN,
            fire: (event) => {
                const element = this.engine.getActionEventBus().getModelForEvent(event);
                if (!element) {
                    return;
                }
                if (!element.isSelected()) {
                    this.engine.getModel().clearSelection();
                }
                element.setSelected(true);
                this.engine.repaintCanvas();
            }
        }));
    }
    activated(previous) {
        super.activated(previous);
        this.initialPositions = {};
    }
    fireMouseMoved(event) {
        const items = this.engine.getModel().getSelectedEntities();
        const model = this.engine.getModel();
        for (let item of items) {
            if (item instanceof _core_models_BasePositionModel__WEBPACK_IMPORTED_MODULE_2__.BasePositionModel) {
                if (item.isLocked()) {
                    continue;
                }
                if (!this.initialPositions[item.getID()]) {
                    this.initialPositions[item.getID()] = {
                        point: item.getPosition(),
                        item: item
                    };
                }
                const pos = this.initialPositions[item.getID()].point;
                item.setPosition(model.getGridPosition(pos.x + event.virtualDisplacementX), model.getGridPosition(pos.y + event.virtualDisplacementY));
            }
        }
        this.engine.repaintCanvas();
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/states/SelectingState.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/states/SelectingState.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SelectingState: () => (/* binding */ SelectingState)
/* harmony export */ });
/* harmony import */ var _core_state_State__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../core-state/State */ "./node_modules/@projectstorm/react-canvas-core/dist/core-state/State.js");
/* harmony import */ var _core_actions_Action__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../core-actions/Action */ "./node_modules/@projectstorm/react-canvas-core/dist/core-actions/Action.js");
/* harmony import */ var _SelectionBoxState__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SelectionBoxState */ "./node_modules/@projectstorm/react-canvas-core/dist/states/SelectionBoxState.js");



class SelectingState extends _core_state_State__WEBPACK_IMPORTED_MODULE_0__.State {
    constructor() {
        super({
            name: 'selecting'
        });
        this.keys = ['shift'];
        this.registerAction(new _core_actions_Action__WEBPACK_IMPORTED_MODULE_1__.Action({
            type: _core_actions_Action__WEBPACK_IMPORTED_MODULE_1__.InputType.MOUSE_DOWN,
            fire: (event) => {
                const element = this.engine.getActionEventBus().getModelForEvent(event);
                // go into a selection box on the canvas state
                if (!element) {
                    this.transitionWithEvent(new _SelectionBoxState__WEBPACK_IMPORTED_MODULE_2__.SelectionBoxState(), event);
                }
                else {
                    element.setSelected(true);
                    this.engine.repaintCanvas();
                }
            }
        }));
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/states/SelectionBoxState.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/states/SelectionBoxState.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SelectionBoxState: () => (/* binding */ SelectionBoxState)
/* harmony export */ });
/* harmony import */ var _core_state_AbstractDisplacementState__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../core-state/AbstractDisplacementState */ "./node_modules/@projectstorm/react-canvas-core/dist/core-state/AbstractDisplacementState.js");
/* harmony import */ var _entities_selection_SelectionLayerModel__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../entities/selection/SelectionLayerModel */ "./node_modules/@projectstorm/react-canvas-core/dist/entities/selection/SelectionLayerModel.js");
/* harmony import */ var _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @projectstorm/geometry */ "webpack/sharing/consume/default/@projectstorm/geometry/@projectstorm/geometry?b1e3");
/* harmony import */ var _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_projectstorm_geometry__WEBPACK_IMPORTED_MODULE_2__);



class SelectionBoxState extends _core_state_AbstractDisplacementState__WEBPACK_IMPORTED_MODULE_0__.AbstractDisplacementState {
    constructor() {
        super({
            name: 'selection-box'
        });
    }
    activated(previous) {
        super.activated(previous);
        this.layer = new _entities_selection_SelectionLayerModel__WEBPACK_IMPORTED_MODULE_1__.SelectionLayerModel();
        this.engine.getModel().addLayer(this.layer);
    }
    deactivated(next) {
        super.deactivated(next);
        this.layer.remove();
        this.engine.repaintCanvas();
    }
    getBoxDimensions(event) {
        let rel;
        if ('touches' in event.event) {
            const touch = event.event.touches[0];
            rel = this.engine.getRelativePoint(touch.clientX, touch.clientY);
        }
        else {
            rel = this.engine.getRelativePoint(event.event.clientX, event.event.clientY);
        }
        return {
            left: rel.x > this.initialXRelative ? this.initialXRelative : rel.x,
            top: rel.y > this.initialYRelative ? this.initialYRelative : rel.y,
            width: Math.abs(rel.x - this.initialXRelative),
            height: Math.abs(rel.y - this.initialYRelative),
            right: rel.x < this.initialXRelative ? this.initialXRelative : rel.x,
            bottom: rel.y < this.initialYRelative ? this.initialYRelative : rel.y
        };
    }
    fireMouseMoved(event) {
        this.layer.setBox(this.getBoxDimensions(event));
        const relative = this.engine.getRelativeMousePoint({
            clientX: this.initialX,
            clientY: this.initialY
        });
        if (event.virtualDisplacementX < 0) {
            relative.x -= Math.abs(event.virtualDisplacementX);
        }
        if (event.virtualDisplacementY < 0) {
            relative.y -= Math.abs(event.virtualDisplacementY);
        }
        const rect = _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_2__.Rectangle.fromPointAndSize(relative, Math.abs(event.virtualDisplacementX), Math.abs(event.virtualDisplacementY));
        for (let model of this.engine.getModel().getSelectionEntities()) {
            if (model.getBoundingBox) {
                const bounds = model.getBoundingBox();
                if (rect.containsPoint(bounds.getTopLeft()) && rect.containsPoint(bounds.getBottomRight())) {
                    model.setSelected(true);
                }
                else {
                    model.setSelected(false);
                }
            }
        }
        this.engine.repaintCanvas();
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-canvas-core/dist/widgets/PeformanceWidget.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-canvas-core/dist/widgets/PeformanceWidget.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PeformanceWidget: () => (/* binding */ PeformanceWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);


class PeformanceWidget extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    shouldComponentUpdate(nextProps, nextState, nextContext) {
        if (!this.props.model.performanceTune()) {
            return true;
        }
        // deserialization event
        if (this.props.model !== nextProps.model) {
            return true;
        }
        // change event
        return !lodash__WEBPACK_IMPORTED_MODULE_1__.isEqual(this.props.serialized, nextProps.serialized);
    }
    render() {
        return this.props.children();
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/DiagramEngine.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/DiagramEngine.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DiagramEngine: () => (/* binding */ DiagramEngine)
/* harmony export */ });
/* harmony import */ var _entities_node_NodeModel__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./entities/node/NodeModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node/NodeModel.js");
/* harmony import */ var _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @projectstorm/geometry */ "webpack/sharing/consume/default/@projectstorm/geometry/@projectstorm/geometry?ae79");
/* harmony import */ var _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_projectstorm_geometry__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @projectstorm/react-canvas-core */ "./node_modules/@projectstorm/react-canvas-core/dist/index.js");



/**
 * Passed as a parameter to the DiagramWidget
 */
class DiagramEngine extends _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_2__.CanvasEngine {
    constructor(options = {}) {
        super(options);
        this.maxNumberPointsPerLink = 1000;
        // create banks for the different factory types
        this.nodeFactories = new _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_2__.FactoryBank();
        this.linkFactories = new _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_2__.FactoryBank();
        this.portFactories = new _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_2__.FactoryBank();
        this.labelFactories = new _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_2__.FactoryBank();
        const setup = (factory) => {
            factory.registerListener({
                factoryAdded: (event) => {
                    event.factory.setDiagramEngine(this);
                },
                factoryRemoved: (event) => {
                    event.factory.setDiagramEngine(null);
                }
            });
        };
        setup(this.nodeFactories);
        setup(this.linkFactories);
        setup(this.portFactories);
        setup(this.labelFactories);
    }
    /**
     * Gets a model and element under the mouse cursor
     */
    getMouseElement(event) {
        var target = event.target;
        var diagramModel = this.model;
        //is it a port
        var element = _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_2__.Toolkit.closest(target, '.port[data-name]');
        if (element) {
            var nodeElement = _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_2__.Toolkit.closest(target, '.node[data-nodeid]');
            return diagramModel.getNode(nodeElement.getAttribute('data-nodeid')).getPort(element.getAttribute('data-name'));
        }
        //look for a point
        element = _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_2__.Toolkit.closest(target, '.point[data-id]');
        if (element) {
            return diagramModel.getLink(element.getAttribute('data-linkid')).getPointModel(element.getAttribute('data-id'));
        }
        //look for a link
        element = _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_2__.Toolkit.closest(target, '[data-linkid]');
        if (element) {
            return diagramModel.getLink(element.getAttribute('data-linkid'));
        }
        //look for a node
        element = _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_2__.Toolkit.closest(target, '.node[data-nodeid]');
        if (element) {
            return diagramModel.getNode(element.getAttribute('data-nodeid'));
        }
        return null;
    }
    //!-------------- FACTORIES ------------
    getNodeFactories() {
        return this.nodeFactories;
    }
    getLinkFactories() {
        return this.linkFactories;
    }
    getLabelFactories() {
        return this.labelFactories;
    }
    getPortFactories() {
        return this.portFactories;
    }
    getFactoryForNode(node) {
        if (typeof node === 'string') {
            return this.nodeFactories.getFactory(node);
        }
        return this.nodeFactories.getFactory(node.getType());
    }
    getFactoryForLink(link) {
        if (typeof link === 'string') {
            return this.linkFactories.getFactory(link);
        }
        return this.linkFactories.getFactory(link.getType());
    }
    getFactoryForLabel(label) {
        if (typeof label === 'string') {
            return this.labelFactories.getFactory(label);
        }
        return this.labelFactories.getFactory(label.getType());
    }
    getFactoryForPort(port) {
        if (typeof port === 'string') {
            return this.portFactories.getFactory(port);
        }
        return this.portFactories.getFactory(port.getType());
    }
    generateWidgetForLink(link) {
        return this.getFactoryForLink(link).generateReactWidget({ model: link });
    }
    generateWidgetForNode(node) {
        return this.getFactoryForNode(node).generateReactWidget({ model: node });
    }
    getNodeElement(node) {
        const selector = this.canvas.querySelector(`.node[data-nodeid="${node.getID()}"]`);
        if (selector === null) {
            throw new Error('Cannot find Node element with nodeID: [' + node.getID() + ']');
        }
        return selector;
    }
    getNodePortElement(port) {
        var selector = this.canvas.querySelector(`.port[data-name="${port.getName()}"][data-nodeid="${port.getParent().getID()}"]`);
        if (selector === null) {
            throw new Error('Cannot find Node Port element with nodeID: [' +
                port.getParent().getID() +
                '] and name: [' +
                port.getName() +
                ']');
        }
        return selector;
    }
    getPortCenter(port) {
        return this.getPortCoords(port).getOrigin();
    }
    /**
     * Calculate rectangular coordinates of the port passed in.
     */
    getPortCoords(port, element) {
        if (!this.canvas) {
            throw new Error('Canvas needs to be set first');
        }
        if (!element) {
            element = this.getNodePortElement(port);
        }
        const sourceRect = element.getBoundingClientRect();
        const point = this.getRelativeMousePoint({
            clientX: sourceRect.left,
            clientY: sourceRect.top
        });
        const zoom = this.model.getZoomLevel() / 100.0;
        return _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_1__.Rectangle.fromPointAndSize(point, sourceRect.width / zoom, sourceRect.height / zoom);
    }
    /**
     * Determine the width and height of the node passed in.
     * It currently assumes nodes have a rectangular shape, can be overriden for customised shapes.
     */
    getNodeDimensions(node) {
        if (!this.canvas) {
            return {
                width: 0,
                height: 0
            };
        }
        const nodeElement = this.getNodeElement(node);
        const nodeRect = nodeElement.getBoundingClientRect();
        return {
            width: nodeRect.width,
            height: nodeRect.height
        };
    }
    getBoundingNodesRect(nodes) {
        if (nodes) {
            if (nodes.length === 0) {
                return new _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_1__.Rectangle();
            }
            return new _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_1__.Rectangle((0,_projectstorm_geometry__WEBPACK_IMPORTED_MODULE_1__.boundingBoxFromPolygons)(nodes.map((node) => node.getBoundingBox())));
        }
    }
    zoomToFitSelectedNodes(options) {
        const nodes = this.model
            .getSelectedEntities()
            .filter((entity) => entity instanceof _entities_node_NodeModel__WEBPACK_IMPORTED_MODULE_0__.NodeModel);
        this.zoomToFitNodes({
            margin: options.margin,
            maxZoom: options.maxZoom,
            nodes: nodes.length > 0 ? nodes : null
        });
    }
    zoomToFitNodes(options) {
        let margin = options || 0;
        let nodes = [];
        let maxZoom = null;
        if (!!options && typeof options == 'object') {
            margin = options.margin || 0;
            nodes = options.nodes || [];
            maxZoom = options.maxZoom || null;
        }
        // no node selected
        if (nodes.length === 0) {
            nodes = this.model.getNodes();
        }
        const nodesRect = this.getBoundingNodesRect(nodes);
        if (nodesRect) {
            // there is something we should zoom on
            let canvasRect = this.canvas.getBoundingClientRect();
            const calculate = (margin = 0) => {
                // work out zoom
                const xFactor = this.canvas.clientWidth / (nodesRect.getWidth() + margin * 2);
                const yFactor = this.canvas.clientHeight / (nodesRect.getHeight() + margin * 2);
                let zoomFactor = xFactor < yFactor ? xFactor : yFactor;
                if (maxZoom && zoomFactor > maxZoom) {
                    zoomFactor = maxZoom;
                }
                return {
                    zoom: zoomFactor,
                    x: canvasRect.width / 2 -
                        ((nodesRect.getWidth() + margin * 2) / 2 + nodesRect.getTopLeft().x) * zoomFactor +
                        margin,
                    y: canvasRect.height / 2 -
                        ((nodesRect.getHeight() + margin * 2) / 2 + nodesRect.getTopLeft().y) * zoomFactor +
                        margin
                };
            };
            let params = calculate(0);
            if (margin) {
                if (params.x < margin || params.y < margin) {
                    params = calculate(margin);
                }
            }
            // apply
            this.model.setZoomLevel(params.zoom * 100);
            this.model.setOffset(params.x, params.y);
            this.repaintCanvas();
        }
    }
    getMaxNumberPointsPerLink() {
        return this.maxNumberPointsPerLink;
    }
    setMaxNumberPointsPerLink(max) {
        this.maxNumberPointsPerLink = max;
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/label/LabelModel.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/label/LabelModel.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LabelModel: () => (/* binding */ LabelModel)
/* harmony export */ });
/* harmony import */ var _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @projectstorm/react-canvas-core */ "./node_modules/@projectstorm/react-canvas-core/dist/index.js");

class LabelModel extends _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_0__.BaseModel {
    constructor(options) {
        super(Object.assign(Object.assign({}, options), { offsetX: options.offsetX || 0, offsetY: options.offsetY || 0 }));
    }
    deserialize(event) {
        super.deserialize(event);
        this.options.offsetX = event.data.offsetX;
        this.options.offsetY = event.data.offsetY;
    }
    serialize() {
        return Object.assign(Object.assign({}, super.serialize()), { offsetX: this.options.offsetX, offsetY: this.options.offsetY });
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/label/LabelWidget.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/label/LabelWidget.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LabelWidget: () => (/* binding */ LabelWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _emotion_styled__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/styled */ "webpack/sharing/consume/default/@emotion/styled/@emotion/styled?5d9f");
/* harmony import */ var _emotion_styled__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_emotion_styled__WEBPACK_IMPORTED_MODULE_1__);


var S;
(function (S) {
    S.Label = (_emotion_styled__WEBPACK_IMPORTED_MODULE_1___default().div) `
		display: inline-block;
		position: absolute;
	`;
    S.Foreign = (_emotion_styled__WEBPACK_IMPORTED_MODULE_1___default().foreignObject) `
		pointer-events: none;
		overflow: visible;
	`;
})(S || (S = {}));
class LabelWidget extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.findPathAndRelativePositionToRenderLabel = (index) => {
            // an array to hold all path lengths, making sure we hit the DOM only once to fetch this information
            const link = this.props.label.getParent();
            const lengths = link.getRenderedPath().map((path) => path.getTotalLength());
            // calculate the point where we want to display the label
            let labelPosition = lengths.reduce((previousValue, currentValue) => previousValue + currentValue, 0) *
                (index / (link.getLabels().length + 1));
            // find the path where the label will be rendered and calculate the relative position
            let pathIndex = 0;
            while (pathIndex < link.getRenderedPath().length) {
                if (labelPosition - lengths[pathIndex] < 0) {
                    return {
                        path: link.getRenderedPath()[pathIndex],
                        position: labelPosition
                    };
                }
                // keep searching
                labelPosition -= lengths[pathIndex];
                pathIndex++;
            }
        };
        this.calculateLabelPosition = () => {
            const found = this.findPathAndRelativePositionToRenderLabel(this.props.index + 1);
            if (!found) {
                return;
            }
            const { path, position } = found;
            const labelDimensions = {
                width: this.ref.current.offsetWidth,
                height: this.ref.current.offsetHeight
            };
            const pathCentre = path.getPointAtLength(position);
            const labelCoordinates = {
                x: pathCentre.x - labelDimensions.width / 2 + this.props.label.getOptions().offsetX,
                y: pathCentre.y - labelDimensions.height / 2 + this.props.label.getOptions().offsetY
            };
            this.ref.current.style.transform = `translate(${labelCoordinates.x}px, ${labelCoordinates.y}px)`;
        };
        this.ref = react__WEBPACK_IMPORTED_MODULE_0__.createRef();
    }
    componentDidUpdate() {
        window.requestAnimationFrame(this.calculateLabelPosition);
    }
    componentDidMount() {
        window.requestAnimationFrame(this.calculateLabelPosition);
    }
    render() {
        const canvas = this.props.engine.getCanvas();
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(S.Foreign, { key: this.props.label.getID(), width: canvas === null || canvas === void 0 ? void 0 : canvas.offsetWidth, height: canvas === null || canvas === void 0 ? void 0 : canvas.offsetHeight },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(S.Label, { ref: this.ref }, this.props.engine.getFactoryForLabel(this.props.label).generateReactWidget({ model: this.props.label }))));
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link-layer/LinkLayerFactory.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/link-layer/LinkLayerFactory.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LinkLayerFactory: () => (/* binding */ LinkLayerFactory)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @projectstorm/react-canvas-core */ "./node_modules/@projectstorm/react-canvas-core/dist/index.js");
/* harmony import */ var _LinkLayerModel__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./LinkLayerModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link-layer/LinkLayerModel.js");
/* harmony import */ var _LinkLayerWidget__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./LinkLayerWidget */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link-layer/LinkLayerWidget.js");




class LinkLayerFactory extends _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_1__.AbstractReactFactory {
    constructor() {
        super('diagram-links');
    }
    generateModel(event) {
        return new _LinkLayerModel__WEBPACK_IMPORTED_MODULE_2__.LinkLayerModel();
    }
    generateReactWidget(event) {
        return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_LinkLayerWidget__WEBPACK_IMPORTED_MODULE_3__.LinkLayerWidget, { layer: event.model, engine: this.engine });
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link-layer/LinkLayerModel.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/link-layer/LinkLayerModel.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LinkLayerModel: () => (/* binding */ LinkLayerModel)
/* harmony export */ });
/* harmony import */ var _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @projectstorm/react-canvas-core */ "./node_modules/@projectstorm/react-canvas-core/dist/index.js");
/* harmony import */ var _link_LinkModel__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../link/LinkModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link/LinkModel.js");


class LinkLayerModel extends _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_0__.LayerModel {
    constructor() {
        super({
            type: 'diagram-links',
            isSvg: true,
            transformed: true
        });
    }
    addModel(model) {
        if (!(model instanceof _link_LinkModel__WEBPACK_IMPORTED_MODULE_1__.LinkModel)) {
            throw new Error('Can only add links to this layer');
        }
        model.registerListener({
            entityRemoved: () => {
                this.getParent().removeLink(model);
            }
        });
        super.addModel(model);
    }
    getLinks() {
        return this.getModels();
    }
    getChildModelFactoryBank(engine) {
        return engine.getLinkFactories();
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link-layer/LinkLayerWidget.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/link-layer/LinkLayerWidget.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LinkLayerWidget: () => (/* binding */ LinkLayerWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _emotion_styled__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/styled */ "webpack/sharing/consume/default/@emotion/styled/@emotion/styled?5d9f");
/* harmony import */ var _emotion_styled__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_emotion_styled__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _link_LinkWidget__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../link/LinkWidget */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link/LinkWidget.js");




var S;
(function (S) {
    S.Container = (_emotion_styled__WEBPACK_IMPORTED_MODULE_1___default().div) ``;
})(S || (S = {}));
class LinkLayerWidget extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    render() {
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, 
        //only perform these actions when we have a diagram
        lodash__WEBPACK_IMPORTED_MODULE_2__.map(this.props.layer.getLinks(), (link) => {
            return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_link_LinkWidget__WEBPACK_IMPORTED_MODULE_3__.LinkWidget, { key: link.getID(), link: link, diagramEngine: this.props.engine });
        })));
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link/LinkModel.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/link/LinkModel.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LinkModel: () => (/* binding */ LinkModel)
/* harmony export */ });
/* harmony import */ var _PointModel__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./PointModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link/PointModel.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @projectstorm/geometry */ "webpack/sharing/consume/default/@projectstorm/geometry/@projectstorm/geometry?ae79");
/* harmony import */ var _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_projectstorm_geometry__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @projectstorm/react-canvas-core */ "./node_modules/@projectstorm/react-canvas-core/dist/index.js");




class LinkModel extends _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_3__.BaseModel {
    constructor(options) {
        super(options);
        this.points = [
            new _PointModel__WEBPACK_IMPORTED_MODULE_0__.PointModel({
                link: this
            }),
            new _PointModel__WEBPACK_IMPORTED_MODULE_0__.PointModel({
                link: this
            })
        ];
        this.sourcePort = null;
        this.targetPort = null;
        this.renderedPaths = [];
        this.labels = [];
    }
    getBoundingBox() {
        return new _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_2__.Rectangle((0,_projectstorm_geometry__WEBPACK_IMPORTED_MODULE_2__.boundingBoxFromPoints)(lodash__WEBPACK_IMPORTED_MODULE_1__.map(this.points, (point) => {
            return point.getPosition();
        })));
    }
    getSelectionEntities() {
        if (this.getTargetPort() && this.getSourcePort()) {
            return super.getSelectionEntities().concat(lodash__WEBPACK_IMPORTED_MODULE_1__.slice(this.points, 1, this.points.length - 1));
        }
        // allow selection of the first point
        if (!this.getSourcePort()) {
            return super.getSelectionEntities().concat(lodash__WEBPACK_IMPORTED_MODULE_1__.slice(this.points, 0, this.points.length - 1));
        }
        // allow selection of the last point
        if (!this.getTargetPort()) {
            return super.getSelectionEntities().concat(lodash__WEBPACK_IMPORTED_MODULE_1__.slice(this.points, 1, this.points.length));
        }
        return super.getSelectionEntities().concat(this.points);
    }
    deserialize(event) {
        super.deserialize(event);
        this.points = lodash__WEBPACK_IMPORTED_MODULE_1__.map(event.data.points || [], (point) => {
            var p = new _PointModel__WEBPACK_IMPORTED_MODULE_0__.PointModel({
                link: this,
                position: new _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_2__.Point(point.x, point.y)
            });
            p.deserialize(Object.assign(Object.assign({}, event), { data: point }));
            return p;
        });
        //deserialize labels
        lodash__WEBPACK_IMPORTED_MODULE_1__.forEach(event.data.labels || [], (label) => {
            let labelOb = event.engine.getFactoryForLabel(label.type).generateModel({});
            labelOb.deserialize(Object.assign(Object.assign({}, event), { data: label }));
            this.addLabel(labelOb);
        });
        // these happen async, so we use the promises for these (they need to be done like this without the async keyword
        // because we need the deserailize method to finish for other methods while this happen
        if (event.data.target) {
            event.getModel(event.data.targetPort).then((model) => {
                this.setTargetPort(model);
            });
        }
        if (event.data.source) {
            event.getModel(event.data.sourcePort).then((model) => {
                this.setSourcePort(model);
            });
        }
    }
    getRenderedPath() {
        return this.renderedPaths;
    }
    setRenderedPaths(paths) {
        this.renderedPaths = paths;
    }
    serialize() {
        return Object.assign(Object.assign({}, super.serialize()), { source: this.sourcePort ? this.sourcePort.getParent().getID() : null, sourcePort: this.sourcePort ? this.sourcePort.getID() : null, target: this.targetPort ? this.targetPort.getParent().getID() : null, targetPort: this.targetPort ? this.targetPort.getID() : null, points: lodash__WEBPACK_IMPORTED_MODULE_1__.map(this.points, (point) => {
                return point.serialize();
            }), labels: lodash__WEBPACK_IMPORTED_MODULE_1__.map(this.labels, (label) => {
                return label.serialize();
            }) });
    }
    doClone(lookupTable = {}, clone) {
        clone.setPoints(lodash__WEBPACK_IMPORTED_MODULE_1__.map(this.getPoints(), (point) => {
            return point.clone(lookupTable);
        }));
        if (this.sourcePort) {
            clone.setSourcePort(this.sourcePort.clone(lookupTable));
        }
        if (this.targetPort) {
            clone.setTargetPort(this.targetPort.clone(lookupTable));
        }
    }
    clearPort(port) {
        if (this.sourcePort === port) {
            this.setSourcePort(null);
        }
        else if (this.targetPort === port) {
            this.setTargetPort(null);
        }
    }
    remove() {
        if (this.sourcePort) {
            this.sourcePort.removeLink(this);
            delete this.sourcePort;
        }
        if (this.targetPort) {
            this.targetPort.removeLink(this);
            delete this.targetPort;
        }
        super.remove();
    }
    isLastPoint(point) {
        var index = this.getPointIndex(point);
        return index === this.points.length - 1;
    }
    getPointIndex(point) {
        return this.points.indexOf(point);
    }
    getPointModel(id) {
        for (var i = 0; i < this.points.length; i++) {
            if (this.points[i].getID() === id) {
                return this.points[i];
            }
        }
        return null;
    }
    getPortForPoint(point) {
        if (this.sourcePort !== null && this.getFirstPoint().getID() === point.getID()) {
            return this.sourcePort;
        }
        if (this.targetPort !== null && this.getLastPoint().getID() === point.getID()) {
            return this.targetPort;
        }
        return null;
    }
    getPointForPort(port) {
        if (this.sourcePort !== null && this.sourcePort.getID() === port.getID()) {
            return this.getFirstPoint();
        }
        if (this.targetPort !== null && this.targetPort.getID() === port.getID()) {
            return this.getLastPoint();
        }
        return null;
    }
    getFirstPoint() {
        return this.points[0];
    }
    getLastPoint() {
        return this.points[this.points.length - 1];
    }
    setSourcePort(port) {
        if (port !== null) {
            port.addLink(this);
        }
        if (this.sourcePort !== null) {
            this.sourcePort.removeLink(this);
        }
        this.sourcePort = port;
        this.fireEvent({ port }, 'sourcePortChanged');
        if (port === null || port === void 0 ? void 0 : port.reportedPosition) {
            this.getPointForPort(port).setPosition(port.getCenter());
        }
    }
    getSourcePort() {
        return this.sourcePort;
    }
    getTargetPort() {
        return this.targetPort;
    }
    setTargetPort(port) {
        if (port !== null) {
            port.addLink(this);
        }
        if (this.targetPort !== null) {
            this.targetPort.removeLink(this);
        }
        this.targetPort = port;
        this.fireEvent({ port }, 'targetPortChanged');
        if (port === null || port === void 0 ? void 0 : port.reportedPosition) {
            this.getPointForPort(port).setPosition(port.getCenter());
        }
    }
    point(x, y, index = 1) {
        return this.addPoint(this.generatePoint(x, y), index);
    }
    addLabel(label) {
        label.setParent(this);
        this.labels.push(label);
    }
    getPoints() {
        return this.points;
    }
    getLabels() {
        return this.labels;
    }
    setPoints(points) {
        lodash__WEBPACK_IMPORTED_MODULE_1__.forEach(points, (point) => {
            point.setParent(this);
        });
        this.points = points;
    }
    removePoint(pointModel) {
        if (this.isLastPoint(pointModel))
            this.remove();
        this.points.splice(this.getPointIndex(pointModel), 1);
    }
    removePointsBefore(pointModel) {
        this.points.splice(0, this.getPointIndex(pointModel));
    }
    removePointsAfter(pointModel) {
        this.points.splice(this.getPointIndex(pointModel) + 1);
    }
    removeMiddlePoints() {
        if (this.points.length > 2) {
            this.points.splice(1, this.points.length - 2);
        }
    }
    addPoint(pointModel, index = 1) {
        pointModel.setParent(this);
        this.points.splice(index, 0, pointModel);
        return pointModel;
    }
    generatePoint(x = 0, y = 0) {
        return new _PointModel__WEBPACK_IMPORTED_MODULE_0__.PointModel({
            link: this,
            position: new _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_2__.Point(x, y)
        });
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link/LinkWidget.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/link/LinkWidget.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LinkWidget: () => (/* binding */ LinkWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _label_LabelWidget__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../label/LabelWidget */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/label/LabelWidget.js");
/* harmony import */ var _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @projectstorm/react-canvas-core */ "./node_modules/@projectstorm/react-canvas-core/dist/index.js");




class LinkWidget extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.state = {
            sourcePort: null,
            targetPort: null
        };
    }
    componentWillUnmount() {
        if (this.sourceListener) {
            this.sourceListener.deregister();
        }
        if (this.targetListener) {
            this.targetListener.deregister();
        }
    }
    static getDerivedStateFromProps(nextProps, prevState) {
        return {
            sourcePort: nextProps.link.getSourcePort(),
            targetPort: nextProps.link.getTargetPort()
        };
    }
    installTarget() {
        this.targetListener && this.targetListener.deregister();
        if (!this.props.link.getTargetPort())
            return;
        this.targetListener = this.props.link.getTargetPort().registerListener({
            reportInitialPosition: (event) => {
                this.forceUpdate();
            }
        });
    }
    installSource() {
        this.sourceListener && this.sourceListener.deregister();
        if (!this.props.link.getSourcePort())
            return;
        this.sourceListener = this.props.link.getSourcePort().registerListener({
            reportInitialPosition: (event) => {
                this.forceUpdate();
            }
        });
    }
    componentDidUpdate(prevProps, prevState, snapshot) {
        if (prevState.sourcePort !== this.state.sourcePort) {
            this.installSource();
        }
        if (prevState.targetPort !== this.state.targetPort) {
            this.installTarget();
        }
    }
    static generateLinePath(firstPoint, lastPoint) {
        return `M${firstPoint.getX()},${firstPoint.getY()} L ${lastPoint.getX()},${lastPoint.getY()}`;
    }
    componentDidMount() {
        if (this.props.link.getSourcePort()) {
            this.installSource();
        }
        if (this.props.link.getTargetPort()) {
            this.installTarget();
        }
    }
    render() {
        const { link } = this.props;
        // only draw the link when we have reported positions
        if (link.getSourcePort() && !link.getSourcePort().reportedPosition) {
            return null;
        }
        if (link.getTargetPort() && !link.getTargetPort().reportedPosition) {
            return null;
        }
        //generate links
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_3__.PeformanceWidget, { model: this.props.link, serialized: this.props.link.serialize() }, () => {
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", { "data-linkid": this.props.link.getID() },
                this.props.diagramEngine.generateWidgetForLink(link),
                lodash__WEBPACK_IMPORTED_MODULE_1__.map(this.props.link.getLabels(), (labelModel, index) => {
                    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_label_LabelWidget__WEBPACK_IMPORTED_MODULE_2__.LabelWidget, { key: labelModel.getID(), engine: this.props.diagramEngine, label: labelModel, index: index }));
                })));
        }));
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link/PointModel.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/link/PointModel.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PointModel: () => (/* binding */ PointModel)
/* harmony export */ });
/* harmony import */ var _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @projectstorm/react-canvas-core */ "./node_modules/@projectstorm/react-canvas-core/dist/index.js");

class PointModel extends _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_0__.BasePositionModel {
    constructor(options) {
        super(Object.assign(Object.assign({}, options), { type: 'point' }));
        this.parent = options.link;
    }
    isConnectedToPort() {
        return this.parent.getPortForPoint(this) !== null;
    }
    getLink() {
        return this.getParent();
    }
    remove() {
        //clear references
        if (this.parent) {
            this.parent.removePoint(this);
        }
        super.remove();
    }
    isLocked() {
        return super.isLocked() || this.getParent().isLocked();
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node-layer/NodeLayerFactory.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/node-layer/NodeLayerFactory.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   NodeLayerFactory: () => (/* binding */ NodeLayerFactory)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @projectstorm/react-canvas-core */ "./node_modules/@projectstorm/react-canvas-core/dist/index.js");
/* harmony import */ var _NodeLayerModel__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./NodeLayerModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node-layer/NodeLayerModel.js");
/* harmony import */ var _NodeLayerWidget__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./NodeLayerWidget */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node-layer/NodeLayerWidget.js");




class NodeLayerFactory extends _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_1__.AbstractReactFactory {
    constructor() {
        super('diagram-nodes');
    }
    generateModel(event) {
        return new _NodeLayerModel__WEBPACK_IMPORTED_MODULE_2__.NodeLayerModel();
    }
    generateReactWidget(event) {
        return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_NodeLayerWidget__WEBPACK_IMPORTED_MODULE_3__.NodeLayerWidget, { layer: event.model, engine: this.engine });
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node-layer/NodeLayerModel.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/node-layer/NodeLayerModel.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   NodeLayerModel: () => (/* binding */ NodeLayerModel)
/* harmony export */ });
/* harmony import */ var _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @projectstorm/react-canvas-core */ "./node_modules/@projectstorm/react-canvas-core/dist/index.js");
/* harmony import */ var _node_NodeModel__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node/NodeModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node/NodeModel.js");


class NodeLayerModel extends _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_0__.LayerModel {
    constructor() {
        super({
            type: 'diagram-nodes',
            isSvg: false,
            transformed: true
        });
    }
    addModel(model) {
        if (!(model instanceof _node_NodeModel__WEBPACK_IMPORTED_MODULE_1__.NodeModel)) {
            throw new Error('Can only add nodes to this layer');
        }
        model.registerListener({
            entityRemoved: () => {
                this.getParent().removeNode(model);
            }
        });
        super.addModel(model);
    }
    getChildModelFactoryBank(engine) {
        return engine.getNodeFactories();
    }
    getNodes() {
        return this.getModels();
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node-layer/NodeLayerWidget.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/node-layer/NodeLayerWidget.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   NodeLayerWidget: () => (/* binding */ NodeLayerWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_NodeWidget__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../node/NodeWidget */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node/NodeWidget.js");



class NodeLayerWidget extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    render() {
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, lodash__WEBPACK_IMPORTED_MODULE_1__.map(this.props.layer.getNodes(), (node) => {
            return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_node_NodeWidget__WEBPACK_IMPORTED_MODULE_2__.NodeWidget, { key: node.getID(), diagramEngine: this.props.engine, node: node });
        })));
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node/NodeModel.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/node/NodeModel.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   NodeModel: () => (/* binding */ NodeModel)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @projectstorm/geometry */ "webpack/sharing/consume/default/@projectstorm/geometry/@projectstorm/geometry?ae79");
/* harmony import */ var _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_projectstorm_geometry__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @projectstorm/react-canvas-core */ "./node_modules/@projectstorm/react-canvas-core/dist/index.js");



class NodeModel extends _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_2__.BasePositionModel {
    constructor(options) {
        super(options);
        this.ports = {};
        this.width = 0;
        this.height = 0;
    }
    getBoundingBox() {
        return _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_1__.Rectangle.fromPointAndSize(this.getPosition(), this.width, this.height);
    }
    setPosition(x, y) {
        const old = this.position;
        if (x instanceof _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_1__.Point) {
            super.setPosition(x);
        }
        else {
            super.setPosition(x, y);
        }
        //also update the port co-ordinates (for make glorious speed)
        lodash__WEBPACK_IMPORTED_MODULE_0__.forEach(this.ports, (port) => {
            port.setPosition(port.getX() + this.position.x - old.x, port.getY() + this.position.y - old.y);
        });
    }
    deserialize(event) {
        super.deserialize(event);
        //deserialize ports
        lodash__WEBPACK_IMPORTED_MODULE_0__.forEach(event.data.ports, (port) => {
            let portOb = event.engine.getFactoryForPort(port.type).generateModel({});
            portOb.deserialize(Object.assign(Object.assign({}, event), { data: port }));
            // the links need these
            event.registerModel(portOb);
            this.addPort(portOb);
        });
    }
    serialize() {
        return Object.assign(Object.assign({}, super.serialize()), { ports: lodash__WEBPACK_IMPORTED_MODULE_0__.map(this.ports, (port) => {
                return port.serialize();
            }) });
    }
    doClone(lookupTable = {}, clone) {
        // also clone the ports
        clone.ports = {};
        lodash__WEBPACK_IMPORTED_MODULE_0__.forEach(this.ports, (port) => {
            clone.addPort(port.clone(lookupTable));
        });
    }
    remove() {
        super.remove();
        lodash__WEBPACK_IMPORTED_MODULE_0__.forEach(this.ports, (port) => {
            lodash__WEBPACK_IMPORTED_MODULE_0__.forEach(port.getLinks(), (link) => {
                link.remove();
            });
        });
    }
    getPortFromID(id) {
        for (var i in this.ports) {
            if (this.ports[i].getID() === id) {
                return this.ports[i];
            }
        }
        return null;
    }
    getLink(id) {
        for (let portID in this.ports) {
            const links = this.ports[portID].getLinks();
            if (links[id]) {
                return links[id];
            }
        }
    }
    getPort(name) {
        return this.ports[name];
    }
    getPorts() {
        return this.ports;
    }
    removePort(port) {
        // clear the port from the links
        for (let link of lodash__WEBPACK_IMPORTED_MODULE_0__.values(port.getLinks())) {
            link.clearPort(port);
        }
        //clear the parent node reference
        if (this.ports[port.getName()]) {
            this.ports[port.getName()].setParent(null);
            delete this.ports[port.getName()];
        }
    }
    addPort(port) {
        port.setParent(this);
        this.ports[port.getName()] = port;
        return port;
    }
    updateDimensions({ width, height }) {
        this.width = width;
        this.height = height;
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node/NodeWidget.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/node/NodeWidget.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   NodeWidget: () => (/* binding */ NodeWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @projectstorm/react-canvas-core */ "./node_modules/@projectstorm/react-canvas-core/dist/index.js");
/* harmony import */ var _emotion_styled__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @emotion/styled */ "webpack/sharing/consume/default/@emotion/styled/@emotion/styled?5d9f");
/* harmony import */ var _emotion_styled__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_emotion_styled__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var resize_observer_polyfill__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! resize-observer-polyfill */ "./node_modules/resize-observer-polyfill/dist/ResizeObserver.es.js");





var S;
(function (S) {
    S.Node = (_emotion_styled__WEBPACK_IMPORTED_MODULE_3___default().div) `
		position: absolute;
		-webkit-touch-callout: none; /* iOS Safari */
		-webkit-user-select: none; /* Chrome/Safari/Opera */
		user-select: none;
		cursor: move;
		pointer-events: all;
	`;
})(S || (S = {}));
class NodeWidget extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.ref = react__WEBPACK_IMPORTED_MODULE_0__.createRef();
    }
    componentWillUnmount() {
        var _a;
        this.ob.disconnect();
        this.ob = null;
        (_a = this.listener) === null || _a === void 0 ? void 0 : _a.deregister();
        this.listener = null;
    }
    componentDidUpdate(prevProps, prevState, snapshot) {
        if (this.listener && this.props.node !== prevProps.node) {
            this.listener.deregister();
            this.installSelectionListener();
        }
    }
    installSelectionListener() {
        this.listener = this.props.node.registerListener({
            selectionChanged: (event) => {
                this.forceUpdate();
            }
        });
    }
    updateSize(width, height) {
        this.props.node.updateDimensions({ width, height });
        //now mark the links as dirty
        try {
            lodash__WEBPACK_IMPORTED_MODULE_1__.forEach(this.props.node.getPorts(), (port) => {
                port.updateCoords(this.props.diagramEngine.getPortCoords(port));
            });
        }
        catch (ex) { }
    }
    componentDidMount() {
        // @ts-ignore
        this.ob = new resize_observer_polyfill__WEBPACK_IMPORTED_MODULE_4__["default"]((entities) => {
            const bounds = entities[0].contentRect;
            this.updateSize(bounds.width, bounds.height);
        });
        const b = this.ref.current.getBoundingClientRect();
        this.updateSize(b.width, b.height);
        this.ob.observe(this.ref.current);
        this.installSelectionListener();
    }
    render() {
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_2__.PeformanceWidget, { model: this.props.node, serialized: this.props.node.serialize() }, () => {
            return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(S.Node, { className: "node", ref: this.ref, "data-nodeid": this.props.node.getID(), style: {
                    top: this.props.node.getY(),
                    left: this.props.node.getX()
                } }, this.props.diagramEngine.generateWidgetForNode(this.props.node)));
        }));
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/port/PortModel.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/port/PortModel.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PortModel: () => (/* binding */ PortModel),
/* harmony export */   PortModelAlignment: () => (/* binding */ PortModelAlignment)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @projectstorm/geometry */ "webpack/sharing/consume/default/@projectstorm/geometry/@projectstorm/geometry?ae79");
/* harmony import */ var _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_projectstorm_geometry__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @projectstorm/react-canvas-core */ "./node_modules/@projectstorm/react-canvas-core/dist/index.js");



var PortModelAlignment;
(function (PortModelAlignment) {
    PortModelAlignment["TOP"] = "top";
    PortModelAlignment["LEFT"] = "left";
    PortModelAlignment["BOTTOM"] = "bottom";
    PortModelAlignment["RIGHT"] = "right";
})(PortModelAlignment || (PortModelAlignment = {}));
class PortModel extends _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_2__.BasePositionModel {
    constructor(options) {
        super(options);
        this.links = {};
        this.reportedPosition = false;
    }
    deserialize(event) {
        super.deserialize(event);
        this.reportedPosition = false;
        this.options.name = event.data.name;
        this.options.alignment = event.data.alignment;
    }
    serialize() {
        return Object.assign(Object.assign({}, super.serialize()), { name: this.options.name, alignment: this.options.alignment, parentNode: this.parent.getID(), links: lodash__WEBPACK_IMPORTED_MODULE_0__.map(this.links, (link) => {
                return link.getID();
            }) });
    }
    setPosition(x, y) {
        let old = this.position;
        super.setPosition(x, y);
        lodash__WEBPACK_IMPORTED_MODULE_0__.forEach(this.getLinks(), (link) => {
            let point = link.getPointForPort(this);
            point.setPosition(point.getX() + x - old.x, point.getY() + y - old.y);
        });
    }
    doClone(lookupTable = {}, clone) {
        clone.links = {};
        clone.parent = this.getParent().clone(lookupTable);
    }
    getNode() {
        return this.getParent();
    }
    getName() {
        return this.options.name;
    }
    getMaximumLinks() {
        return this.options.maximumLinks;
    }
    setMaximumLinks(maximumLinks) {
        this.options.maximumLinks = maximumLinks;
    }
    removeLink(link) {
        delete this.links[link.getID()];
    }
    addLink(link) {
        this.links[link.getID()] = link;
    }
    getLinks() {
        return this.links;
    }
    createLinkModel() {
        if (lodash__WEBPACK_IMPORTED_MODULE_0__.isFinite(this.options.maximumLinks)) {
            var numberOfLinks = lodash__WEBPACK_IMPORTED_MODULE_0__.size(this.links);
            if (this.options.maximumLinks === 1 && numberOfLinks >= 1) {
                return lodash__WEBPACK_IMPORTED_MODULE_0__.values(this.links)[0];
            }
            else if (numberOfLinks >= this.options.maximumLinks) {
                return null;
            }
        }
        return null;
    }
    reportPosition() {
        lodash__WEBPACK_IMPORTED_MODULE_0__.forEach(this.getLinks(), (link) => {
            link.getPointForPort(this).setPosition(this.getCenter());
        });
        this.fireEvent({
            entity: this
        }, 'reportInitialPosition');
    }
    getCenter() {
        return new _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_1__.Point(this.getX() + this.width / 2, this.getY() + this.height / 2);
    }
    getBoundingBox() {
        return _projectstorm_geometry__WEBPACK_IMPORTED_MODULE_1__.Rectangle.fromPointAndSize(this.position, this.width, this.height);
    }
    updateCoords(coords) {
        this.width = coords.getWidth();
        this.height = coords.getHeight();
        this.setPosition(coords.getTopLeft());
        this.reportedPosition = true;
        this.reportPosition();
    }
    canLinkToPort(port) {
        return true;
    }
    isLocked() {
        return super.isLocked() || this.getParent().isLocked();
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/port/PortWidget.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/entities/port/PortWidget.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PortWidget: () => (/* binding */ PortWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @projectstorm/react-canvas-core */ "./node_modules/@projectstorm/react-canvas-core/dist/index.js");



class PortWidget extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        this.ref = react__WEBPACK_IMPORTED_MODULE_0__.createRef();
    }
    report() {
        this.props.port.updateCoords(this.props.engine.getPortCoords(this.props.port, this.ref.current));
    }
    componentWillUnmount() {
        this.engineListenerHandle && this.engineListenerHandle.deregister();
    }
    componentDidUpdate(prevProps, prevState, snapshot) {
        if (!this.props.port.reportedPosition) {
            this.report();
        }
    }
    componentDidMount() {
        this.engineListenerHandle = this.props.engine.registerListener({
            canvasReady: () => {
                this.report();
            }
        });
        if (this.props.engine.getCanvas()) {
            this.report();
        }
    }
    getExtraProps() {
        if (_projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_2__.Toolkit.TESTING) {
            const links = lodash__WEBPACK_IMPORTED_MODULE_1__.keys(this.props.port.getNode().getPort(this.props.port.getName()).links).join(',');
            return {
                'data-links': links
            };
        }
        return {};
    }
    render() {
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", Object.assign({ style: this.props.style, ref: this.ref, className: `port ${this.props.className || ''}`, "data-name": this.props.port.getName(), "data-nodeid": this.props.port.getNode().getID() }, this.getExtraProps()), this.props.children));
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/index.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/index.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DefaultDiagramState: () => (/* reexport safe */ _states_DefaultDiagramState__WEBPACK_IMPORTED_MODULE_15__.DefaultDiagramState),
/* harmony export */   DiagramEngine: () => (/* reexport safe */ _DiagramEngine__WEBPACK_IMPORTED_MODULE_18__.DiagramEngine),
/* harmony export */   DiagramModel: () => (/* reexport safe */ _models_DiagramModel__WEBPACK_IMPORTED_MODULE_0__.DiagramModel),
/* harmony export */   DragDiagramItemsState: () => (/* reexport safe */ _states_DragDiagramItemsState__WEBPACK_IMPORTED_MODULE_16__.DragDiagramItemsState),
/* harmony export */   DragNewLinkState: () => (/* reexport safe */ _states_DragNewLinkState__WEBPACK_IMPORTED_MODULE_17__.DragNewLinkState),
/* harmony export */   LabelModel: () => (/* reexport safe */ _entities_label_LabelModel__WEBPACK_IMPORTED_MODULE_1__.LabelModel),
/* harmony export */   LinkLayerFactory: () => (/* reexport safe */ _entities_link_layer_LinkLayerFactory__WEBPACK_IMPORTED_MODULE_7__.LinkLayerFactory),
/* harmony export */   LinkLayerModel: () => (/* reexport safe */ _entities_link_layer_LinkLayerModel__WEBPACK_IMPORTED_MODULE_5__.LinkLayerModel),
/* harmony export */   LinkLayerWidget: () => (/* reexport safe */ _entities_link_layer_LinkLayerWidget__WEBPACK_IMPORTED_MODULE_6__.LinkLayerWidget),
/* harmony export */   LinkModel: () => (/* reexport safe */ _entities_link_LinkModel__WEBPACK_IMPORTED_MODULE_2__.LinkModel),
/* harmony export */   LinkWidget: () => (/* reexport safe */ _entities_link_LinkWidget__WEBPACK_IMPORTED_MODULE_4__.LinkWidget),
/* harmony export */   NodeLayerFactory: () => (/* reexport safe */ _entities_node_layer_NodeLayerFactory__WEBPACK_IMPORTED_MODULE_10__.NodeLayerFactory),
/* harmony export */   NodeLayerModel: () => (/* reexport safe */ _entities_node_layer_NodeLayerModel__WEBPACK_IMPORTED_MODULE_8__.NodeLayerModel),
/* harmony export */   NodeLayerWidget: () => (/* reexport safe */ _entities_node_layer_NodeLayerWidget__WEBPACK_IMPORTED_MODULE_9__.NodeLayerWidget),
/* harmony export */   NodeModel: () => (/* reexport safe */ _entities_node_NodeModel__WEBPACK_IMPORTED_MODULE_11__.NodeModel),
/* harmony export */   NodeWidget: () => (/* reexport safe */ _entities_node_NodeWidget__WEBPACK_IMPORTED_MODULE_12__.NodeWidget),
/* harmony export */   PointModel: () => (/* reexport safe */ _entities_link_PointModel__WEBPACK_IMPORTED_MODULE_3__.PointModel),
/* harmony export */   PortModel: () => (/* reexport safe */ _entities_port_PortModel__WEBPACK_IMPORTED_MODULE_13__.PortModel),
/* harmony export */   PortModelAlignment: () => (/* reexport safe */ _entities_port_PortModel__WEBPACK_IMPORTED_MODULE_13__.PortModelAlignment),
/* harmony export */   PortWidget: () => (/* reexport safe */ _entities_port_PortWidget__WEBPACK_IMPORTED_MODULE_14__.PortWidget)
/* harmony export */ });
/* harmony import */ var _models_DiagramModel__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./models/DiagramModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/models/DiagramModel.js");
/* harmony import */ var _entities_label_LabelModel__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./entities/label/LabelModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/label/LabelModel.js");
/* harmony import */ var _entities_link_LinkModel__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./entities/link/LinkModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link/LinkModel.js");
/* harmony import */ var _entities_link_PointModel__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./entities/link/PointModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link/PointModel.js");
/* harmony import */ var _entities_link_LinkWidget__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./entities/link/LinkWidget */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link/LinkWidget.js");
/* harmony import */ var _entities_link_layer_LinkLayerModel__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./entities/link-layer/LinkLayerModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link-layer/LinkLayerModel.js");
/* harmony import */ var _entities_link_layer_LinkLayerWidget__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./entities/link-layer/LinkLayerWidget */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link-layer/LinkLayerWidget.js");
/* harmony import */ var _entities_link_layer_LinkLayerFactory__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./entities/link-layer/LinkLayerFactory */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link-layer/LinkLayerFactory.js");
/* harmony import */ var _entities_node_layer_NodeLayerModel__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./entities/node-layer/NodeLayerModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node-layer/NodeLayerModel.js");
/* harmony import */ var _entities_node_layer_NodeLayerWidget__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./entities/node-layer/NodeLayerWidget */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node-layer/NodeLayerWidget.js");
/* harmony import */ var _entities_node_layer_NodeLayerFactory__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./entities/node-layer/NodeLayerFactory */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node-layer/NodeLayerFactory.js");
/* harmony import */ var _entities_node_NodeModel__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./entities/node/NodeModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node/NodeModel.js");
/* harmony import */ var _entities_node_NodeWidget__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./entities/node/NodeWidget */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node/NodeWidget.js");
/* harmony import */ var _entities_port_PortModel__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./entities/port/PortModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/port/PortModel.js");
/* harmony import */ var _entities_port_PortWidget__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./entities/port/PortWidget */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/port/PortWidget.js");
/* harmony import */ var _states_DefaultDiagramState__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./states/DefaultDiagramState */ "./node_modules/@projectstorm/react-diagrams-core/dist/states/DefaultDiagramState.js");
/* harmony import */ var _states_DragDiagramItemsState__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./states/DragDiagramItemsState */ "./node_modules/@projectstorm/react-diagrams-core/dist/states/DragDiagramItemsState.js");
/* harmony import */ var _states_DragNewLinkState__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./states/DragNewLinkState */ "./node_modules/@projectstorm/react-diagrams-core/dist/states/DragNewLinkState.js");
/* harmony import */ var _DiagramEngine__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./DiagramEngine */ "./node_modules/@projectstorm/react-diagrams-core/dist/DiagramEngine.js");





















/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/models/DiagramModel.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/models/DiagramModel.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DiagramModel: () => (/* binding */ DiagramModel)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _entities_link_LinkModel__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../entities/link/LinkModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link/LinkModel.js");
/* harmony import */ var _entities_node_NodeModel__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../entities/node/NodeModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node/NodeModel.js");
/* harmony import */ var _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @projectstorm/react-canvas-core */ "./node_modules/@projectstorm/react-canvas-core/dist/index.js");
/* harmony import */ var _entities_node_layer_NodeLayerModel__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../entities/node-layer/NodeLayerModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/node-layer/NodeLayerModel.js");
/* harmony import */ var _entities_link_layer_LinkLayerModel__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../entities/link-layer/LinkLayerModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link-layer/LinkLayerModel.js");






class DiagramModel extends _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_3__.CanvasModel {
    constructor(options = {}) {
        super(options);
        this.addLayer(new _entities_link_layer_LinkLayerModel__WEBPACK_IMPORTED_MODULE_5__.LinkLayerModel());
        this.addLayer(new _entities_node_layer_NodeLayerModel__WEBPACK_IMPORTED_MODULE_4__.NodeLayerModel());
    }
    deserialize(event) {
        this.layers = [];
        super.deserialize(event);
    }
    addLayer(layer) {
        super.addLayer(layer);
        if (layer instanceof _entities_node_layer_NodeLayerModel__WEBPACK_IMPORTED_MODULE_4__.NodeLayerModel) {
            this.activeNodeLayer = layer;
        }
        if (layer instanceof _entities_link_layer_LinkLayerModel__WEBPACK_IMPORTED_MODULE_5__.LinkLayerModel) {
            this.activeLinkLayer = layer;
        }
    }
    getLinkLayers() {
        return lodash__WEBPACK_IMPORTED_MODULE_0__.filter(this.layers, (layer) => {
            return layer instanceof _entities_link_layer_LinkLayerModel__WEBPACK_IMPORTED_MODULE_5__.LinkLayerModel;
        });
    }
    getNodeLayers() {
        return lodash__WEBPACK_IMPORTED_MODULE_0__.filter(this.layers, (layer) => {
            return layer instanceof _entities_node_layer_NodeLayerModel__WEBPACK_IMPORTED_MODULE_4__.NodeLayerModel;
        });
    }
    getActiveNodeLayer() {
        if (!this.activeNodeLayer) {
            const layers = this.getNodeLayers();
            if (layers.length === 0) {
                this.addLayer(new _entities_node_layer_NodeLayerModel__WEBPACK_IMPORTED_MODULE_4__.NodeLayerModel());
            }
            else {
                this.activeNodeLayer = layers[0];
            }
        }
        return this.activeNodeLayer;
    }
    getActiveLinkLayer() {
        if (!this.activeLinkLayer) {
            const layers = this.getLinkLayers();
            if (layers.length === 0) {
                this.addLayer(new _entities_link_layer_LinkLayerModel__WEBPACK_IMPORTED_MODULE_5__.LinkLayerModel());
            }
            else {
                this.activeLinkLayer = layers[0];
            }
        }
        return this.activeLinkLayer;
    }
    getNode(node) {
        for (const layer of this.getNodeLayers()) {
            const model = layer.getModel(node);
            if (model) {
                return model;
            }
        }
    }
    getLink(link) {
        for (const layer of this.getLinkLayers()) {
            const model = layer.getModel(link);
            if (model) {
                return model;
            }
        }
    }
    addAll(...models) {
        lodash__WEBPACK_IMPORTED_MODULE_0__.forEach(models, (model) => {
            if (model instanceof _entities_link_LinkModel__WEBPACK_IMPORTED_MODULE_1__.LinkModel) {
                this.addLink(model);
            }
            else if (model instanceof _entities_node_NodeModel__WEBPACK_IMPORTED_MODULE_2__.NodeModel) {
                this.addNode(model);
            }
        });
        return models;
    }
    addLink(link) {
        this.getActiveLinkLayer().addModel(link);
        this.fireEvent({
            link,
            isCreated: true
        }, 'linksUpdated');
        return link;
    }
    addNode(node) {
        this.getActiveNodeLayer().addModel(node);
        this.fireEvent({ node, isCreated: true }, 'nodesUpdated');
        return node;
    }
    removeLink(link) {
        const removed = lodash__WEBPACK_IMPORTED_MODULE_0__.some(this.getLinkLayers(), (layer) => {
            return layer.removeModel(link);
        });
        if (removed) {
            this.fireEvent({ link, isCreated: false }, 'linksUpdated');
        }
    }
    removeNode(node) {
        const removed = lodash__WEBPACK_IMPORTED_MODULE_0__.some(this.getNodeLayers(), (layer) => {
            return layer.removeModel(node);
        });
        if (removed) {
            this.fireEvent({ node, isCreated: false }, 'nodesUpdated');
        }
    }
    getLinks() {
        return lodash__WEBPACK_IMPORTED_MODULE_0__.flatMap(this.getLinkLayers(), (layer) => {
            return lodash__WEBPACK_IMPORTED_MODULE_0__.values(layer.getModels());
        });
    }
    getNodes() {
        return lodash__WEBPACK_IMPORTED_MODULE_0__.flatMap(this.getNodeLayers(), (layer) => {
            return lodash__WEBPACK_IMPORTED_MODULE_0__.values(layer.getModels());
        });
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/states/DefaultDiagramState.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/states/DefaultDiagramState.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DefaultDiagramState: () => (/* binding */ DefaultDiagramState)
/* harmony export */ });
/* harmony import */ var _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @projectstorm/react-canvas-core */ "./node_modules/@projectstorm/react-canvas-core/dist/index.js");
/* harmony import */ var _entities_port_PortModel__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../entities/port/PortModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/port/PortModel.js");
/* harmony import */ var _DragNewLinkState__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./DragNewLinkState */ "./node_modules/@projectstorm/react-diagrams-core/dist/states/DragNewLinkState.js");
/* harmony import */ var _DragDiagramItemsState__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./DragDiagramItemsState */ "./node_modules/@projectstorm/react-diagrams-core/dist/states/DragDiagramItemsState.js");




class DefaultDiagramState extends _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_0__.State {
    constructor() {
        super({
            name: 'default-diagrams'
        });
        this.childStates = [new _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_0__.SelectingState()];
        this.dragCanvas = new _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_0__.DragCanvasState();
        this.dragNewLink = new _DragNewLinkState__WEBPACK_IMPORTED_MODULE_2__.DragNewLinkState();
        this.dragItems = new _DragDiagramItemsState__WEBPACK_IMPORTED_MODULE_3__.DragDiagramItemsState();
        // determine what was clicked on
        this.registerAction(new _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_0__.Action({
            type: _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_0__.InputType.MOUSE_DOWN,
            fire: (event) => {
                const element = this.engine.getActionEventBus().getModelForEvent(event);
                // the canvas was clicked on, transition to the dragging canvas state
                if (!element) {
                    this.transitionWithEvent(this.dragCanvas, event);
                }
                // initiate dragging a new link
                else if (element instanceof _entities_port_PortModel__WEBPACK_IMPORTED_MODULE_1__.PortModel) {
                    this.transitionWithEvent(this.dragNewLink, event);
                }
                // move the items (and potentially link points)
                else {
                    this.transitionWithEvent(this.dragItems, event);
                }
            }
        }));
        // touch drags the canvas
        this.registerAction(new _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_0__.Action({
            type: _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_0__.InputType.TOUCH_START,
            fire: (event) => {
                this.transitionWithEvent(this.dragCanvas, event);
            }
        }));
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/states/DragDiagramItemsState.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/states/DragDiagramItemsState.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DragDiagramItemsState: () => (/* binding */ DragDiagramItemsState)
/* harmony export */ });
/* harmony import */ var _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @projectstorm/react-canvas-core */ "./node_modules/@projectstorm/react-canvas-core/dist/index.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _entities_link_PointModel__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../entities/link/PointModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/link/PointModel.js");
/* harmony import */ var _entities_port_PortModel__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../entities/port/PortModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/port/PortModel.js");




class DragDiagramItemsState extends _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_0__.MoveItemsState {
    constructor() {
        super();
        this.registerAction(new _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_0__.Action({
            type: _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_0__.InputType.MOUSE_UP,
            fire: (event) => {
                const item = this.engine.getMouseElement(event.event);
                if (item instanceof _entities_port_PortModel__WEBPACK_IMPORTED_MODULE_3__.PortModel) {
                    lodash__WEBPACK_IMPORTED_MODULE_1__.forEach(this.initialPositions, (position) => {
                        if (position.item instanceof _entities_link_PointModel__WEBPACK_IMPORTED_MODULE_2__.PointModel) {
                            const link = position.item.getParent();
                            // only care about the last links
                            if (link.getLastPoint() !== position.item) {
                                return;
                            }
                            if (link.getSourcePort().canLinkToPort(item)) {
                                link.setTargetPort(item);
                                item.reportPosition();
                                this.engine.repaintCanvas();
                            }
                        }
                    });
                }
            }
        }));
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-core/dist/states/DragNewLinkState.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-core/dist/states/DragNewLinkState.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DragNewLinkState: () => (/* binding */ DragNewLinkState)
/* harmony export */ });
/* harmony import */ var _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @projectstorm/react-canvas-core */ "./node_modules/@projectstorm/react-canvas-core/dist/index.js");
/* harmony import */ var _entities_port_PortModel__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../entities/port/PortModel */ "./node_modules/@projectstorm/react-diagrams-core/dist/entities/port/PortModel.js");


class DragNewLinkState extends _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_0__.AbstractDisplacementState {
    constructor(options = {}) {
        super({ name: 'drag-new-link' });
        this.config = Object.assign({ allowLooseLinks: true, allowLinksFromLockedPorts: false }, options);
        this.registerAction(new _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_0__.Action({
            type: _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_0__.InputType.MOUSE_DOWN,
            fire: (event) => {
                this.port = this.engine.getMouseElement(event.event);
                if (!this.config.allowLinksFromLockedPorts && this.port.isLocked()) {
                    this.eject();
                    return;
                }
                this.link = this.port.createLinkModel();
                // if no link is given, just eject the state
                if (!this.link) {
                    this.eject();
                    return;
                }
                this.link.setSelected(true);
                this.link.setSourcePort(this.port);
                this.engine.getModel().addLink(this.link);
                this.port.reportPosition();
            }
        }));
        this.registerAction(new _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_0__.Action({
            type: _projectstorm_react_canvas_core__WEBPACK_IMPORTED_MODULE_0__.InputType.MOUSE_UP,
            fire: (event) => {
                const model = this.engine.getMouseElement(event.event);
                // check to see if we connected to a new port
                if (model instanceof _entities_port_PortModel__WEBPACK_IMPORTED_MODULE_1__.PortModel) {
                    if (this.port.canLinkToPort(model)) {
                        this.link.setTargetPort(model);
                        model.reportPosition();
                        this.engine.repaintCanvas();
                        return;
                    }
                    else {
                        this.link.remove();
                        this.engine.repaintCanvas();
                        return;
                    }
                }
                if (!this.config.allowLooseLinks) {
                    this.link.remove();
                    this.engine.repaintCanvas();
                }
            }
        }));
    }
    /**
     * Calculates the link's far-end point position on mouse move.
     * In order to be as precise as possible the mouse initialXRelative & initialYRelative are taken into account as well
     * as the possible engine offset
     */
    fireMouseMoved(event) {
        const portPos = this.port.getPosition();
        const zoomLevelPercentage = this.engine.getModel().getZoomLevel() / 100;
        const engineOffsetX = this.engine.getModel().getOffsetX() / zoomLevelPercentage;
        const engineOffsetY = this.engine.getModel().getOffsetY() / zoomLevelPercentage;
        const initialXRelative = this.initialXRelative / zoomLevelPercentage;
        const initialYRelative = this.initialYRelative / zoomLevelPercentage;
        const linkNextX = portPos.x - engineOffsetX + (initialXRelative - portPos.x) + event.virtualDisplacementX;
        const linkNextY = portPos.y - engineOffsetY + (initialYRelative - portPos.y) + event.virtualDisplacementY;
        this.link.getLastPoint().setPosition(linkNextX, linkNextY);
        this.engine.repaintCanvas();
    }
}


/***/ }),

/***/ "./node_modules/resize-observer-polyfill/dist/ResizeObserver.es.js":
/*!*************************************************************************!*\
  !*** ./node_modules/resize-observer-polyfill/dist/ResizeObserver.es.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * A collection of shims that provide minimal functionality of the ES6 collections.
 *
 * These implementations are not meant to be used outside of the ResizeObserver
 * modules as they cover only a limited range of use cases.
 */
/* eslint-disable require-jsdoc, valid-jsdoc */
var MapShim = (function () {
    if (typeof Map !== 'undefined') {
        return Map;
    }
    /**
     * Returns index in provided array that matches the specified key.
     *
     * @param {Array<Array>} arr
     * @param {*} key
     * @returns {number}
     */
    function getIndex(arr, key) {
        var result = -1;
        arr.some(function (entry, index) {
            if (entry[0] === key) {
                result = index;
                return true;
            }
            return false;
        });
        return result;
    }
    return /** @class */ (function () {
        function class_1() {
            this.__entries__ = [];
        }
        Object.defineProperty(class_1.prototype, "size", {
            /**
             * @returns {boolean}
             */
            get: function () {
                return this.__entries__.length;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @param {*} key
         * @returns {*}
         */
        class_1.prototype.get = function (key) {
            var index = getIndex(this.__entries__, key);
            var entry = this.__entries__[index];
            return entry && entry[1];
        };
        /**
         * @param {*} key
         * @param {*} value
         * @returns {void}
         */
        class_1.prototype.set = function (key, value) {
            var index = getIndex(this.__entries__, key);
            if (~index) {
                this.__entries__[index][1] = value;
            }
            else {
                this.__entries__.push([key, value]);
            }
        };
        /**
         * @param {*} key
         * @returns {void}
         */
        class_1.prototype.delete = function (key) {
            var entries = this.__entries__;
            var index = getIndex(entries, key);
            if (~index) {
                entries.splice(index, 1);
            }
        };
        /**
         * @param {*} key
         * @returns {void}
         */
        class_1.prototype.has = function (key) {
            return !!~getIndex(this.__entries__, key);
        };
        /**
         * @returns {void}
         */
        class_1.prototype.clear = function () {
            this.__entries__.splice(0);
        };
        /**
         * @param {Function} callback
         * @param {*} [ctx=null]
         * @returns {void}
         */
        class_1.prototype.forEach = function (callback, ctx) {
            if (ctx === void 0) { ctx = null; }
            for (var _i = 0, _a = this.__entries__; _i < _a.length; _i++) {
                var entry = _a[_i];
                callback.call(ctx, entry[1], entry[0]);
            }
        };
        return class_1;
    }());
})();

/**
 * Detects whether window and document objects are available in current environment.
 */
var isBrowser = typeof window !== 'undefined' && typeof document !== 'undefined' && window.document === document;

// Returns global object of a current environment.
var global$1 = (function () {
    if (typeof __webpack_require__.g !== 'undefined' && __webpack_require__.g.Math === Math) {
        return __webpack_require__.g;
    }
    if (typeof self !== 'undefined' && self.Math === Math) {
        return self;
    }
    if (typeof window !== 'undefined' && window.Math === Math) {
        return window;
    }
    // eslint-disable-next-line no-new-func
    return Function('return this')();
})();

/**
 * A shim for the requestAnimationFrame which falls back to the setTimeout if
 * first one is not supported.
 *
 * @returns {number} Requests' identifier.
 */
var requestAnimationFrame$1 = (function () {
    if (typeof requestAnimationFrame === 'function') {
        // It's required to use a bounded function because IE sometimes throws
        // an "Invalid calling object" error if rAF is invoked without the global
        // object on the left hand side.
        return requestAnimationFrame.bind(global$1);
    }
    return function (callback) { return setTimeout(function () { return callback(Date.now()); }, 1000 / 60); };
})();

// Defines minimum timeout before adding a trailing call.
var trailingTimeout = 2;
/**
 * Creates a wrapper function which ensures that provided callback will be
 * invoked only once during the specified delay period.
 *
 * @param {Function} callback - Function to be invoked after the delay period.
 * @param {number} delay - Delay after which to invoke callback.
 * @returns {Function}
 */
function throttle (callback, delay) {
    var leadingCall = false, trailingCall = false, lastCallTime = 0;
    /**
     * Invokes the original callback function and schedules new invocation if
     * the "proxy" was called during current request.
     *
     * @returns {void}
     */
    function resolvePending() {
        if (leadingCall) {
            leadingCall = false;
            callback();
        }
        if (trailingCall) {
            proxy();
        }
    }
    /**
     * Callback invoked after the specified delay. It will further postpone
     * invocation of the original function delegating it to the
     * requestAnimationFrame.
     *
     * @returns {void}
     */
    function timeoutCallback() {
        requestAnimationFrame$1(resolvePending);
    }
    /**
     * Schedules invocation of the original function.
     *
     * @returns {void}
     */
    function proxy() {
        var timeStamp = Date.now();
        if (leadingCall) {
            // Reject immediately following calls.
            if (timeStamp - lastCallTime < trailingTimeout) {
                return;
            }
            // Schedule new call to be in invoked when the pending one is resolved.
            // This is important for "transitions" which never actually start
            // immediately so there is a chance that we might miss one if change
            // happens amids the pending invocation.
            trailingCall = true;
        }
        else {
            leadingCall = true;
            trailingCall = false;
            setTimeout(timeoutCallback, delay);
        }
        lastCallTime = timeStamp;
    }
    return proxy;
}

// Minimum delay before invoking the update of observers.
var REFRESH_DELAY = 20;
// A list of substrings of CSS properties used to find transition events that
// might affect dimensions of observed elements.
var transitionKeys = ['top', 'right', 'bottom', 'left', 'width', 'height', 'size', 'weight'];
// Check if MutationObserver is available.
var mutationObserverSupported = typeof MutationObserver !== 'undefined';
/**
 * Singleton controller class which handles updates of ResizeObserver instances.
 */
var ResizeObserverController = /** @class */ (function () {
    /**
     * Creates a new instance of ResizeObserverController.
     *
     * @private
     */
    function ResizeObserverController() {
        /**
         * Indicates whether DOM listeners have been added.
         *
         * @private {boolean}
         */
        this.connected_ = false;
        /**
         * Tells that controller has subscribed for Mutation Events.
         *
         * @private {boolean}
         */
        this.mutationEventsAdded_ = false;
        /**
         * Keeps reference to the instance of MutationObserver.
         *
         * @private {MutationObserver}
         */
        this.mutationsObserver_ = null;
        /**
         * A list of connected observers.
         *
         * @private {Array<ResizeObserverSPI>}
         */
        this.observers_ = [];
        this.onTransitionEnd_ = this.onTransitionEnd_.bind(this);
        this.refresh = throttle(this.refresh.bind(this), REFRESH_DELAY);
    }
    /**
     * Adds observer to observers list.
     *
     * @param {ResizeObserverSPI} observer - Observer to be added.
     * @returns {void}
     */
    ResizeObserverController.prototype.addObserver = function (observer) {
        if (!~this.observers_.indexOf(observer)) {
            this.observers_.push(observer);
        }
        // Add listeners if they haven't been added yet.
        if (!this.connected_) {
            this.connect_();
        }
    };
    /**
     * Removes observer from observers list.
     *
     * @param {ResizeObserverSPI} observer - Observer to be removed.
     * @returns {void}
     */
    ResizeObserverController.prototype.removeObserver = function (observer) {
        var observers = this.observers_;
        var index = observers.indexOf(observer);
        // Remove observer if it's present in registry.
        if (~index) {
            observers.splice(index, 1);
        }
        // Remove listeners if controller has no connected observers.
        if (!observers.length && this.connected_) {
            this.disconnect_();
        }
    };
    /**
     * Invokes the update of observers. It will continue running updates insofar
     * it detects changes.
     *
     * @returns {void}
     */
    ResizeObserverController.prototype.refresh = function () {
        var changesDetected = this.updateObservers_();
        // Continue running updates if changes have been detected as there might
        // be future ones caused by CSS transitions.
        if (changesDetected) {
            this.refresh();
        }
    };
    /**
     * Updates every observer from observers list and notifies them of queued
     * entries.
     *
     * @private
     * @returns {boolean} Returns "true" if any observer has detected changes in
     *      dimensions of it's elements.
     */
    ResizeObserverController.prototype.updateObservers_ = function () {
        // Collect observers that have active observations.
        var activeObservers = this.observers_.filter(function (observer) {
            return observer.gatherActive(), observer.hasActive();
        });
        // Deliver notifications in a separate cycle in order to avoid any
        // collisions between observers, e.g. when multiple instances of
        // ResizeObserver are tracking the same element and the callback of one
        // of them changes content dimensions of the observed target. Sometimes
        // this may result in notifications being blocked for the rest of observers.
        activeObservers.forEach(function (observer) { return observer.broadcastActive(); });
        return activeObservers.length > 0;
    };
    /**
     * Initializes DOM listeners.
     *
     * @private
     * @returns {void}
     */
    ResizeObserverController.prototype.connect_ = function () {
        // Do nothing if running in a non-browser environment or if listeners
        // have been already added.
        if (!isBrowser || this.connected_) {
            return;
        }
        // Subscription to the "Transitionend" event is used as a workaround for
        // delayed transitions. This way it's possible to capture at least the
        // final state of an element.
        document.addEventListener('transitionend', this.onTransitionEnd_);
        window.addEventListener('resize', this.refresh);
        if (mutationObserverSupported) {
            this.mutationsObserver_ = new MutationObserver(this.refresh);
            this.mutationsObserver_.observe(document, {
                attributes: true,
                childList: true,
                characterData: true,
                subtree: true
            });
        }
        else {
            document.addEventListener('DOMSubtreeModified', this.refresh);
            this.mutationEventsAdded_ = true;
        }
        this.connected_ = true;
    };
    /**
     * Removes DOM listeners.
     *
     * @private
     * @returns {void}
     */
    ResizeObserverController.prototype.disconnect_ = function () {
        // Do nothing if running in a non-browser environment or if listeners
        // have been already removed.
        if (!isBrowser || !this.connected_) {
            return;
        }
        document.removeEventListener('transitionend', this.onTransitionEnd_);
        window.removeEventListener('resize', this.refresh);
        if (this.mutationsObserver_) {
            this.mutationsObserver_.disconnect();
        }
        if (this.mutationEventsAdded_) {
            document.removeEventListener('DOMSubtreeModified', this.refresh);
        }
        this.mutationsObserver_ = null;
        this.mutationEventsAdded_ = false;
        this.connected_ = false;
    };
    /**
     * "Transitionend" event handler.
     *
     * @private
     * @param {TransitionEvent} event
     * @returns {void}
     */
    ResizeObserverController.prototype.onTransitionEnd_ = function (_a) {
        var _b = _a.propertyName, propertyName = _b === void 0 ? '' : _b;
        // Detect whether transition may affect dimensions of an element.
        var isReflowProperty = transitionKeys.some(function (key) {
            return !!~propertyName.indexOf(key);
        });
        if (isReflowProperty) {
            this.refresh();
        }
    };
    /**
     * Returns instance of the ResizeObserverController.
     *
     * @returns {ResizeObserverController}
     */
    ResizeObserverController.getInstance = function () {
        if (!this.instance_) {
            this.instance_ = new ResizeObserverController();
        }
        return this.instance_;
    };
    /**
     * Holds reference to the controller's instance.
     *
     * @private {ResizeObserverController}
     */
    ResizeObserverController.instance_ = null;
    return ResizeObserverController;
}());

/**
 * Defines non-writable/enumerable properties of the provided target object.
 *
 * @param {Object} target - Object for which to define properties.
 * @param {Object} props - Properties to be defined.
 * @returns {Object} Target object.
 */
var defineConfigurable = (function (target, props) {
    for (var _i = 0, _a = Object.keys(props); _i < _a.length; _i++) {
        var key = _a[_i];
        Object.defineProperty(target, key, {
            value: props[key],
            enumerable: false,
            writable: false,
            configurable: true
        });
    }
    return target;
});

/**
 * Returns the global object associated with provided element.
 *
 * @param {Object} target
 * @returns {Object}
 */
var getWindowOf = (function (target) {
    // Assume that the element is an instance of Node, which means that it
    // has the "ownerDocument" property from which we can retrieve a
    // corresponding global object.
    var ownerGlobal = target && target.ownerDocument && target.ownerDocument.defaultView;
    // Return the local global object if it's not possible extract one from
    // provided element.
    return ownerGlobal || global$1;
});

// Placeholder of an empty content rectangle.
var emptyRect = createRectInit(0, 0, 0, 0);
/**
 * Converts provided string to a number.
 *
 * @param {number|string} value
 * @returns {number}
 */
function toFloat(value) {
    return parseFloat(value) || 0;
}
/**
 * Extracts borders size from provided styles.
 *
 * @param {CSSStyleDeclaration} styles
 * @param {...string} positions - Borders positions (top, right, ...)
 * @returns {number}
 */
function getBordersSize(styles) {
    var positions = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        positions[_i - 1] = arguments[_i];
    }
    return positions.reduce(function (size, position) {
        var value = styles['border-' + position + '-width'];
        return size + toFloat(value);
    }, 0);
}
/**
 * Extracts paddings sizes from provided styles.
 *
 * @param {CSSStyleDeclaration} styles
 * @returns {Object} Paddings box.
 */
function getPaddings(styles) {
    var positions = ['top', 'right', 'bottom', 'left'];
    var paddings = {};
    for (var _i = 0, positions_1 = positions; _i < positions_1.length; _i++) {
        var position = positions_1[_i];
        var value = styles['padding-' + position];
        paddings[position] = toFloat(value);
    }
    return paddings;
}
/**
 * Calculates content rectangle of provided SVG element.
 *
 * @param {SVGGraphicsElement} target - Element content rectangle of which needs
 *      to be calculated.
 * @returns {DOMRectInit}
 */
function getSVGContentRect(target) {
    var bbox = target.getBBox();
    return createRectInit(0, 0, bbox.width, bbox.height);
}
/**
 * Calculates content rectangle of provided HTMLElement.
 *
 * @param {HTMLElement} target - Element for which to calculate the content rectangle.
 * @returns {DOMRectInit}
 */
function getHTMLElementContentRect(target) {
    // Client width & height properties can't be
    // used exclusively as they provide rounded values.
    var clientWidth = target.clientWidth, clientHeight = target.clientHeight;
    // By this condition we can catch all non-replaced inline, hidden and
    // detached elements. Though elements with width & height properties less
    // than 0.5 will be discarded as well.
    //
    // Without it we would need to implement separate methods for each of
    // those cases and it's not possible to perform a precise and performance
    // effective test for hidden elements. E.g. even jQuery's ':visible' filter
    // gives wrong results for elements with width & height less than 0.5.
    if (!clientWidth && !clientHeight) {
        return emptyRect;
    }
    var styles = getWindowOf(target).getComputedStyle(target);
    var paddings = getPaddings(styles);
    var horizPad = paddings.left + paddings.right;
    var vertPad = paddings.top + paddings.bottom;
    // Computed styles of width & height are being used because they are the
    // only dimensions available to JS that contain non-rounded values. It could
    // be possible to utilize the getBoundingClientRect if only it's data wasn't
    // affected by CSS transformations let alone paddings, borders and scroll bars.
    var width = toFloat(styles.width), height = toFloat(styles.height);
    // Width & height include paddings and borders when the 'border-box' box
    // model is applied (except for IE).
    if (styles.boxSizing === 'border-box') {
        // Following conditions are required to handle Internet Explorer which
        // doesn't include paddings and borders to computed CSS dimensions.
        //
        // We can say that if CSS dimensions + paddings are equal to the "client"
        // properties then it's either IE, and thus we don't need to subtract
        // anything, or an element merely doesn't have paddings/borders styles.
        if (Math.round(width + horizPad) !== clientWidth) {
            width -= getBordersSize(styles, 'left', 'right') + horizPad;
        }
        if (Math.round(height + vertPad) !== clientHeight) {
            height -= getBordersSize(styles, 'top', 'bottom') + vertPad;
        }
    }
    // Following steps can't be applied to the document's root element as its
    // client[Width/Height] properties represent viewport area of the window.
    // Besides, it's as well not necessary as the <html> itself neither has
    // rendered scroll bars nor it can be clipped.
    if (!isDocumentElement(target)) {
        // In some browsers (only in Firefox, actually) CSS width & height
        // include scroll bars size which can be removed at this step as scroll
        // bars are the only difference between rounded dimensions + paddings
        // and "client" properties, though that is not always true in Chrome.
        var vertScrollbar = Math.round(width + horizPad) - clientWidth;
        var horizScrollbar = Math.round(height + vertPad) - clientHeight;
        // Chrome has a rather weird rounding of "client" properties.
        // E.g. for an element with content width of 314.2px it sometimes gives
        // the client width of 315px and for the width of 314.7px it may give
        // 314px. And it doesn't happen all the time. So just ignore this delta
        // as a non-relevant.
        if (Math.abs(vertScrollbar) !== 1) {
            width -= vertScrollbar;
        }
        if (Math.abs(horizScrollbar) !== 1) {
            height -= horizScrollbar;
        }
    }
    return createRectInit(paddings.left, paddings.top, width, height);
}
/**
 * Checks whether provided element is an instance of the SVGGraphicsElement.
 *
 * @param {Element} target - Element to be checked.
 * @returns {boolean}
 */
var isSVGGraphicsElement = (function () {
    // Some browsers, namely IE and Edge, don't have the SVGGraphicsElement
    // interface.
    if (typeof SVGGraphicsElement !== 'undefined') {
        return function (target) { return target instanceof getWindowOf(target).SVGGraphicsElement; };
    }
    // If it's so, then check that element is at least an instance of the
    // SVGElement and that it has the "getBBox" method.
    // eslint-disable-next-line no-extra-parens
    return function (target) { return (target instanceof getWindowOf(target).SVGElement &&
        typeof target.getBBox === 'function'); };
})();
/**
 * Checks whether provided element is a document element (<html>).
 *
 * @param {Element} target - Element to be checked.
 * @returns {boolean}
 */
function isDocumentElement(target) {
    return target === getWindowOf(target).document.documentElement;
}
/**
 * Calculates an appropriate content rectangle for provided html or svg element.
 *
 * @param {Element} target - Element content rectangle of which needs to be calculated.
 * @returns {DOMRectInit}
 */
function getContentRect(target) {
    if (!isBrowser) {
        return emptyRect;
    }
    if (isSVGGraphicsElement(target)) {
        return getSVGContentRect(target);
    }
    return getHTMLElementContentRect(target);
}
/**
 * Creates rectangle with an interface of the DOMRectReadOnly.
 * Spec: https://drafts.fxtf.org/geometry/#domrectreadonly
 *
 * @param {DOMRectInit} rectInit - Object with rectangle's x/y coordinates and dimensions.
 * @returns {DOMRectReadOnly}
 */
function createReadOnlyRect(_a) {
    var x = _a.x, y = _a.y, width = _a.width, height = _a.height;
    // If DOMRectReadOnly is available use it as a prototype for the rectangle.
    var Constr = typeof DOMRectReadOnly !== 'undefined' ? DOMRectReadOnly : Object;
    var rect = Object.create(Constr.prototype);
    // Rectangle's properties are not writable and non-enumerable.
    defineConfigurable(rect, {
        x: x, y: y, width: width, height: height,
        top: y,
        right: x + width,
        bottom: height + y,
        left: x
    });
    return rect;
}
/**
 * Creates DOMRectInit object based on the provided dimensions and the x/y coordinates.
 * Spec: https://drafts.fxtf.org/geometry/#dictdef-domrectinit
 *
 * @param {number} x - X coordinate.
 * @param {number} y - Y coordinate.
 * @param {number} width - Rectangle's width.
 * @param {number} height - Rectangle's height.
 * @returns {DOMRectInit}
 */
function createRectInit(x, y, width, height) {
    return { x: x, y: y, width: width, height: height };
}

/**
 * Class that is responsible for computations of the content rectangle of
 * provided DOM element and for keeping track of it's changes.
 */
var ResizeObservation = /** @class */ (function () {
    /**
     * Creates an instance of ResizeObservation.
     *
     * @param {Element} target - Element to be observed.
     */
    function ResizeObservation(target) {
        /**
         * Broadcasted width of content rectangle.
         *
         * @type {number}
         */
        this.broadcastWidth = 0;
        /**
         * Broadcasted height of content rectangle.
         *
         * @type {number}
         */
        this.broadcastHeight = 0;
        /**
         * Reference to the last observed content rectangle.
         *
         * @private {DOMRectInit}
         */
        this.contentRect_ = createRectInit(0, 0, 0, 0);
        this.target = target;
    }
    /**
     * Updates content rectangle and tells whether it's width or height properties
     * have changed since the last broadcast.
     *
     * @returns {boolean}
     */
    ResizeObservation.prototype.isActive = function () {
        var rect = getContentRect(this.target);
        this.contentRect_ = rect;
        return (rect.width !== this.broadcastWidth ||
            rect.height !== this.broadcastHeight);
    };
    /**
     * Updates 'broadcastWidth' and 'broadcastHeight' properties with a data
     * from the corresponding properties of the last observed content rectangle.
     *
     * @returns {DOMRectInit} Last observed content rectangle.
     */
    ResizeObservation.prototype.broadcastRect = function () {
        var rect = this.contentRect_;
        this.broadcastWidth = rect.width;
        this.broadcastHeight = rect.height;
        return rect;
    };
    return ResizeObservation;
}());

var ResizeObserverEntry = /** @class */ (function () {
    /**
     * Creates an instance of ResizeObserverEntry.
     *
     * @param {Element} target - Element that is being observed.
     * @param {DOMRectInit} rectInit - Data of the element's content rectangle.
     */
    function ResizeObserverEntry(target, rectInit) {
        var contentRect = createReadOnlyRect(rectInit);
        // According to the specification following properties are not writable
        // and are also not enumerable in the native implementation.
        //
        // Property accessors are not being used as they'd require to define a
        // private WeakMap storage which may cause memory leaks in browsers that
        // don't support this type of collections.
        defineConfigurable(this, { target: target, contentRect: contentRect });
    }
    return ResizeObserverEntry;
}());

var ResizeObserverSPI = /** @class */ (function () {
    /**
     * Creates a new instance of ResizeObserver.
     *
     * @param {ResizeObserverCallback} callback - Callback function that is invoked
     *      when one of the observed elements changes it's content dimensions.
     * @param {ResizeObserverController} controller - Controller instance which
     *      is responsible for the updates of observer.
     * @param {ResizeObserver} callbackCtx - Reference to the public
     *      ResizeObserver instance which will be passed to callback function.
     */
    function ResizeObserverSPI(callback, controller, callbackCtx) {
        /**
         * Collection of resize observations that have detected changes in dimensions
         * of elements.
         *
         * @private {Array<ResizeObservation>}
         */
        this.activeObservations_ = [];
        /**
         * Registry of the ResizeObservation instances.
         *
         * @private {Map<Element, ResizeObservation>}
         */
        this.observations_ = new MapShim();
        if (typeof callback !== 'function') {
            throw new TypeError('The callback provided as parameter 1 is not a function.');
        }
        this.callback_ = callback;
        this.controller_ = controller;
        this.callbackCtx_ = callbackCtx;
    }
    /**
     * Starts observing provided element.
     *
     * @param {Element} target - Element to be observed.
     * @returns {void}
     */
    ResizeObserverSPI.prototype.observe = function (target) {
        if (!arguments.length) {
            throw new TypeError('1 argument required, but only 0 present.');
        }
        // Do nothing if current environment doesn't have the Element interface.
        if (typeof Element === 'undefined' || !(Element instanceof Object)) {
            return;
        }
        if (!(target instanceof getWindowOf(target).Element)) {
            throw new TypeError('parameter 1 is not of type "Element".');
        }
        var observations = this.observations_;
        // Do nothing if element is already being observed.
        if (observations.has(target)) {
            return;
        }
        observations.set(target, new ResizeObservation(target));
        this.controller_.addObserver(this);
        // Force the update of observations.
        this.controller_.refresh();
    };
    /**
     * Stops observing provided element.
     *
     * @param {Element} target - Element to stop observing.
     * @returns {void}
     */
    ResizeObserverSPI.prototype.unobserve = function (target) {
        if (!arguments.length) {
            throw new TypeError('1 argument required, but only 0 present.');
        }
        // Do nothing if current environment doesn't have the Element interface.
        if (typeof Element === 'undefined' || !(Element instanceof Object)) {
            return;
        }
        if (!(target instanceof getWindowOf(target).Element)) {
            throw new TypeError('parameter 1 is not of type "Element".');
        }
        var observations = this.observations_;
        // Do nothing if element is not being observed.
        if (!observations.has(target)) {
            return;
        }
        observations.delete(target);
        if (!observations.size) {
            this.controller_.removeObserver(this);
        }
    };
    /**
     * Stops observing all elements.
     *
     * @returns {void}
     */
    ResizeObserverSPI.prototype.disconnect = function () {
        this.clearActive();
        this.observations_.clear();
        this.controller_.removeObserver(this);
    };
    /**
     * Collects observation instances the associated element of which has changed
     * it's content rectangle.
     *
     * @returns {void}
     */
    ResizeObserverSPI.prototype.gatherActive = function () {
        var _this = this;
        this.clearActive();
        this.observations_.forEach(function (observation) {
            if (observation.isActive()) {
                _this.activeObservations_.push(observation);
            }
        });
    };
    /**
     * Invokes initial callback function with a list of ResizeObserverEntry
     * instances collected from active resize observations.
     *
     * @returns {void}
     */
    ResizeObserverSPI.prototype.broadcastActive = function () {
        // Do nothing if observer doesn't have active observations.
        if (!this.hasActive()) {
            return;
        }
        var ctx = this.callbackCtx_;
        // Create ResizeObserverEntry instance for every active observation.
        var entries = this.activeObservations_.map(function (observation) {
            return new ResizeObserverEntry(observation.target, observation.broadcastRect());
        });
        this.callback_.call(ctx, entries, ctx);
        this.clearActive();
    };
    /**
     * Clears the collection of active observations.
     *
     * @returns {void}
     */
    ResizeObserverSPI.prototype.clearActive = function () {
        this.activeObservations_.splice(0);
    };
    /**
     * Tells whether observer has active observations.
     *
     * @returns {boolean}
     */
    ResizeObserverSPI.prototype.hasActive = function () {
        return this.activeObservations_.length > 0;
    };
    return ResizeObserverSPI;
}());

// Registry of internal observers. If WeakMap is not available use current shim
// for the Map collection as it has all required methods and because WeakMap
// can't be fully polyfilled anyway.
var observers = typeof WeakMap !== 'undefined' ? new WeakMap() : new MapShim();
/**
 * ResizeObserver API. Encapsulates the ResizeObserver SPI implementation
 * exposing only those methods and properties that are defined in the spec.
 */
var ResizeObserver = /** @class */ (function () {
    /**
     * Creates a new instance of ResizeObserver.
     *
     * @param {ResizeObserverCallback} callback - Callback that is invoked when
     *      dimensions of the observed elements change.
     */
    function ResizeObserver(callback) {
        if (!(this instanceof ResizeObserver)) {
            throw new TypeError('Cannot call a class as a function.');
        }
        if (!arguments.length) {
            throw new TypeError('1 argument required, but only 0 present.');
        }
        var controller = ResizeObserverController.getInstance();
        var observer = new ResizeObserverSPI(callback, controller, this);
        observers.set(this, observer);
    }
    return ResizeObserver;
}());
// Expose public methods of ResizeObserver.
[
    'observe',
    'unobserve',
    'disconnect'
].forEach(function (method) {
    ResizeObserver.prototype[method] = function () {
        var _a;
        return (_a = observers.get(this))[method].apply(_a, arguments);
    };
});

var index = (function () {
    // Export existing implementation if available.
    if (typeof global$1.ResizeObserver !== 'undefined') {
        return global$1.ResizeObserver;
    }
    return ResizeObserver;
})();

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (index);


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_projectstorm_react-diagrams-core_dist_index_js.02f8e1328b4f1c3788b7.js.map