"use strict";
(self["webpackChunktvb_ext_xircuits"] = self["webpackChunktvb_ext_xircuits"] || []).push([["vendors-node_modules_projectstorm_react-diagrams-defaults_node_modules_projectstorm_geometry_-6256fb"],{

/***/ "./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/BezierCurve.js":
/*!********************************************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/BezierCurve.js ***!
  \********************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BezierCurve: () => (/* binding */ BezierCurve),
/* harmony export */   BezierCurvepPoints: () => (/* binding */ BezierCurvepPoints)
/* harmony export */ });
/* harmony import */ var _Point__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Point */ "./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/Point.js");
/* harmony import */ var _Polygon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Polygon */ "./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/Polygon.js");


var BezierCurvepPoints;
(function (BezierCurvepPoints) {
    BezierCurvepPoints[BezierCurvepPoints["SOURCE"] = 0] = "SOURCE";
    BezierCurvepPoints[BezierCurvepPoints["SOURCE_CONTROL"] = 1] = "SOURCE_CONTROL";
    BezierCurvepPoints[BezierCurvepPoints["TARGET_CONTROL"] = 2] = "TARGET_CONTROL";
    BezierCurvepPoints[BezierCurvepPoints["TARGET"] = 3] = "TARGET";
})(BezierCurvepPoints || (BezierCurvepPoints = {}));
class BezierCurve extends _Polygon__WEBPACK_IMPORTED_MODULE_1__.Polygon {
    constructor() {
        super([new _Point__WEBPACK_IMPORTED_MODULE_0__.Point(0, 0), new _Point__WEBPACK_IMPORTED_MODULE_0__.Point(0, 0), new _Point__WEBPACK_IMPORTED_MODULE_0__.Point(0, 0), new _Point__WEBPACK_IMPORTED_MODULE_0__.Point(0, 0)]);
    }
    getSVGCurve() {
        return `M${this.getSource().toSVG()} C${this.getSourceControl().toSVG()}, ${this.getTargetControl().toSVG()}, ${this.getTarget().toSVG()}`;
    }
    setPoints(points) {
        if (points.length !== 4) {
            throw new Error('BezierCurve must have extactly 4 points');
        }
        super.setPoints(points);
    }
    getSource() {
        return this.points[BezierCurvepPoints.SOURCE];
    }
    getSourceControl() {
        return this.points[BezierCurvepPoints.SOURCE_CONTROL];
    }
    getTargetControl() {
        return this.points[BezierCurvepPoints.TARGET_CONTROL];
    }
    getTarget() {
        return this.points[BezierCurvepPoints.TARGET];
    }
    setSource(point) {
        this.points[BezierCurvepPoints.SOURCE] = point;
    }
    setSourceControl(point) {
        this.points[BezierCurvepPoints.SOURCE_CONTROL] = point;
    }
    setTargetControl(point) {
        this.points[BezierCurvepPoints.TARGET_CONTROL] = point;
    }
    setTarget(point) {
        this.points[BezierCurvepPoints.TARGET] = point;
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/Bounds.js":
/*!***************************************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/Bounds.js ***!
  \***************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BoundsCorner: () => (/* binding */ BoundsCorner),
/* harmony export */   boundsFromPositionAndSize: () => (/* binding */ boundsFromPositionAndSize),
/* harmony export */   createEmptyBounds: () => (/* binding */ createEmptyBounds)
/* harmony export */ });
/* harmony import */ var _Point__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Point */ "./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/Point.js");

var BoundsCorner;
(function (BoundsCorner) {
    BoundsCorner["TOP_LEFT"] = "TL";
    BoundsCorner["TOP_RIGHT"] = "TR";
    BoundsCorner["BOTTOM_RIGHT"] = "BR";
    BoundsCorner["BOTTOM_LEFT"] = "BL";
})(BoundsCorner || (BoundsCorner = {}));
const boundsFromPositionAndSize = (x, y, width, height) => {
    return {
        [BoundsCorner.TOP_LEFT]: new _Point__WEBPACK_IMPORTED_MODULE_0__.Point(x, y),
        [BoundsCorner.TOP_RIGHT]: new _Point__WEBPACK_IMPORTED_MODULE_0__.Point(x + width, y),
        [BoundsCorner.BOTTOM_RIGHT]: new _Point__WEBPACK_IMPORTED_MODULE_0__.Point(x + width, y + height),
        [BoundsCorner.BOTTOM_LEFT]: new _Point__WEBPACK_IMPORTED_MODULE_0__.Point(x, y + height)
    };
};
const createEmptyBounds = () => {
    return {
        [BoundsCorner.TOP_LEFT]: new _Point__WEBPACK_IMPORTED_MODULE_0__.Point(),
        [BoundsCorner.TOP_RIGHT]: new _Point__WEBPACK_IMPORTED_MODULE_0__.Point(),
        [BoundsCorner.BOTTOM_RIGHT]: new _Point__WEBPACK_IMPORTED_MODULE_0__.Point(),
        [BoundsCorner.BOTTOM_LEFT]: new _Point__WEBPACK_IMPORTED_MODULE_0__.Point()
    };
};


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/Matrix.js":
/*!***************************************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/Matrix.js ***!
  \***************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Matrix: () => (/* binding */ Matrix)
/* harmony export */ });
class Matrix {
    constructor(matrix) {
        this.matrix = matrix;
    }
    mmul(matrix) {
        this.matrix = this.matrix.map((row, i) => matrix.asArray()[0].map((_, j) => row.reduce((acc, _, n) => acc + this.matrix[i][n] * matrix.asArray()[n][j], 0)));
        return this;
    }
    asArray() {
        return this.matrix;
    }
    get(rowIndex, columnIndex) {
        return this.asArray()[rowIndex][columnIndex];
    }
    static multiply(...matrices) {
        let m = matrices[0];
        for (let i = 1; i < matrices.length; i++) {
            m = m.mmul(matrices[i]);
        }
        return m;
    }
    static scaleMatrix(x, y) {
        return new Matrix([
            [x, 0, 0],
            [0, y, 0],
            [0, 0, 1]
        ]);
    }
    static translateMatrix(x, y) {
        return new Matrix([
            [1, 0, x],
            [0, 1, y],
            [0, 0, 1]
        ]);
    }
    static rotateMatrix(deg) {
        return new Matrix([
            [Math.cos(deg), -1 * Math.sin(deg), 0],
            [Math.sin(deg), Math.cos(deg), 0],
            [0, 0, 1]
        ]);
    }
    static createScaleMatrix(x, y, origin) {
        return this.multiply(Matrix.translateMatrix(origin.x, origin.y), Matrix.scaleMatrix(x, y), Matrix.translateMatrix(-origin.x, -origin.y));
    }
    static createRotateMatrix(deg, origin) {
        return this.multiply(Matrix.translateMatrix(origin.x, origin.y), Matrix.rotateMatrix(deg), Matrix.translateMatrix(-origin.x, -origin.y));
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/Point.js":
/*!**************************************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/Point.js ***!
  \**************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Point: () => (/* binding */ Point)
/* harmony export */ });
/* harmony import */ var _Matrix__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Matrix */ "./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/Matrix.js");

class Point {
    constructor(x = 0, y = 0) {
        this.x = x;
        this.y = y;
    }
    translate(x, y) {
        this.x += x;
        this.y += y;
    }
    clone() {
        return new Point(this.x, this.y);
    }
    toSVG() {
        return this.x + ' ' + this.y;
    }
    asMatrix() {
        return new _Matrix__WEBPACK_IMPORTED_MODULE_0__.Matrix([[this.x], [this.y], [1]]);
    }
    transform(matrix) {
        let final = matrix.mmul(this.asMatrix());
        this.x = final.get(0, 0);
        this.y = final.get(1, 0);
    }
    static middlePoint(pointA, pointB) {
        return new Point((pointB.x + pointA.x) / 2, (pointB.y + pointA.y) / 2);
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/Polygon.js":
/*!****************************************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/Polygon.js ***!
  \****************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Polygon: () => (/* binding */ Polygon)
/* harmony export */ });
/* harmony import */ var _Point__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Point */ "./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/Point.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Matrix__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Matrix */ "./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/Matrix.js");
/* harmony import */ var _toolkit__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./toolkit */ "./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/toolkit.js");
/* harmony import */ var _Bounds__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Bounds */ "./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/Bounds.js");





class Polygon {
    constructor(points = []) {
        this.points = points;
    }
    serialize() {
        return lodash__WEBPACK_IMPORTED_MODULE_1__.map(this.points, (point) => {
            return [point.x, point.y];
        });
    }
    deserialize(data) {
        this.points = lodash__WEBPACK_IMPORTED_MODULE_1__.map(data, (point) => {
            return new _Point__WEBPACK_IMPORTED_MODULE_0__.Point(point[0], point[1]);
        });
    }
    scale(x, y, origin) {
        let matrix = _Matrix__WEBPACK_IMPORTED_MODULE_2__.Matrix.createScaleMatrix(x, y, origin);
        lodash__WEBPACK_IMPORTED_MODULE_1__.forEach(this.points, (point) => {
            point.transform(matrix);
        });
    }
    transform(matrix) {
        lodash__WEBPACK_IMPORTED_MODULE_1__.forEach(this.points, (point) => {
            point.transform(matrix);
        });
    }
    setPoints(points) {
        this.points = points;
    }
    getPoints() {
        return this.points;
    }
    rotate(degrees) {
        this.transform(_Matrix__WEBPACK_IMPORTED_MODULE_2__.Matrix.createRotateMatrix(degrees / (180 / Math.PI), this.getOrigin()));
    }
    translate(offsetX, offsetY) {
        lodash__WEBPACK_IMPORTED_MODULE_1__.forEach(this.points, (point) => {
            point.translate(offsetX, offsetY);
        });
    }
    doClone(ob) {
        this.points = lodash__WEBPACK_IMPORTED_MODULE_1__.map(ob.points, (point) => {
            return point.clone();
        });
    }
    clone() {
        let ob = Object.create(this);
        ob.doClone(this);
        return ob;
    }
    getOrigin() {
        if (this.points.length === 0) {
            return null;
        }
        let dimensions = (0,_toolkit__WEBPACK_IMPORTED_MODULE_3__.boundingBoxFromPoints)(this.points);
        return _Point__WEBPACK_IMPORTED_MODULE_0__.Point.middlePoint(dimensions[_Bounds__WEBPACK_IMPORTED_MODULE_4__.BoundsCorner.TOP_LEFT], dimensions[_Bounds__WEBPACK_IMPORTED_MODULE_4__.BoundsCorner.BOTTOM_RIGHT]);
    }
    getBoundingBox() {
        return (0,_toolkit__WEBPACK_IMPORTED_MODULE_3__.boundingBoxFromPoints)(this.points);
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/Rectangle.js":
/*!******************************************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/Rectangle.js ***!
  \******************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Rectangle: () => (/* binding */ Rectangle)
/* harmony export */ });
/* harmony import */ var _Point__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Point */ "./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/Point.js");
/* harmony import */ var _Polygon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Polygon */ "./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/Polygon.js");
/* harmony import */ var _Bounds__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Bounds */ "./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/Bounds.js");



class Rectangle extends _Polygon__WEBPACK_IMPORTED_MODULE_1__.Polygon {
    static fromPositionAndSize(x, y, width, height) {
        return new Rectangle((0,_Bounds__WEBPACK_IMPORTED_MODULE_2__.boundsFromPositionAndSize)(x, y, width, height));
    }
    static fromPointAndSize(position, width, height) {
        return new Rectangle((0,_Bounds__WEBPACK_IMPORTED_MODULE_2__.boundsFromPositionAndSize)(position.x, position.y, width, height));
    }
    constructor(points) {
        if (!points) {
            points = (0,_Bounds__WEBPACK_IMPORTED_MODULE_2__.createEmptyBounds)();
        }
        super([
            points[_Bounds__WEBPACK_IMPORTED_MODULE_2__.BoundsCorner.TOP_LEFT],
            points[_Bounds__WEBPACK_IMPORTED_MODULE_2__.BoundsCorner.TOP_RIGHT],
            points[_Bounds__WEBPACK_IMPORTED_MODULE_2__.BoundsCorner.BOTTOM_RIGHT],
            points[_Bounds__WEBPACK_IMPORTED_MODULE_2__.BoundsCorner.BOTTOM_LEFT]
        ]);
    }
    updateDimensions(x, y, width, height) {
        const points = (0,_Bounds__WEBPACK_IMPORTED_MODULE_2__.boundsFromPositionAndSize)(x, y, width, height);
        this.setPoints([
            points[_Bounds__WEBPACK_IMPORTED_MODULE_2__.BoundsCorner.TOP_LEFT],
            points[_Bounds__WEBPACK_IMPORTED_MODULE_2__.BoundsCorner.TOP_RIGHT],
            points[_Bounds__WEBPACK_IMPORTED_MODULE_2__.BoundsCorner.BOTTOM_RIGHT],
            points[_Bounds__WEBPACK_IMPORTED_MODULE_2__.BoundsCorner.BOTTOM_LEFT]
        ]);
    }
    setPoints(points) {
        if (points.length !== 4) {
            throw 'Rectangles must always have 4 points';
        }
        super.setPoints(points);
    }
    containsPoint(point) {
        const tl = this.getTopLeft();
        const br = this.getBottomRight();
        return point.x >= tl.x && point.x <= br.x && point.y >= tl.y && point.y <= br.y;
    }
    getWidth() {
        return Math.sqrt(Math.pow(this.getTopLeft().x - this.getTopRight().x, 2) + Math.pow(this.getTopLeft().y - this.getTopRight().y, 2));
    }
    getHeight() {
        return Math.sqrt(Math.pow(this.getBottomLeft().x - this.getTopLeft().x, 2) +
            Math.pow(this.getBottomLeft().y - this.getTopLeft().y, 2));
    }
    getTopMiddle() {
        return _Point__WEBPACK_IMPORTED_MODULE_0__.Point.middlePoint(this.getTopLeft(), this.getTopRight());
    }
    getBottomMiddle() {
        return _Point__WEBPACK_IMPORTED_MODULE_0__.Point.middlePoint(this.getBottomLeft(), this.getBottomRight());
    }
    getLeftMiddle() {
        return _Point__WEBPACK_IMPORTED_MODULE_0__.Point.middlePoint(this.getBottomLeft(), this.getTopLeft());
    }
    getRightMiddle() {
        return _Point__WEBPACK_IMPORTED_MODULE_0__.Point.middlePoint(this.getBottomRight(), this.getTopRight());
    }
    getTopLeft() {
        return this.points[0];
    }
    getTopRight() {
        return this.points[1];
    }
    getBottomRight() {
        return this.points[2];
    }
    getBottomLeft() {
        return this.points[3];
    }
}


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/index.js":
/*!**************************************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/index.js ***!
  \**************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BezierCurve: () => (/* reexport safe */ _BezierCurve__WEBPACK_IMPORTED_MODULE_4__.BezierCurve),
/* harmony export */   BezierCurvepPoints: () => (/* reexport safe */ _BezierCurve__WEBPACK_IMPORTED_MODULE_4__.BezierCurvepPoints),
/* harmony export */   BoundsCorner: () => (/* reexport safe */ _Bounds__WEBPACK_IMPORTED_MODULE_6__.BoundsCorner),
/* harmony export */   Matrix: () => (/* reexport safe */ _Matrix__WEBPACK_IMPORTED_MODULE_1__.Matrix),
/* harmony export */   Point: () => (/* reexport safe */ _Point__WEBPACK_IMPORTED_MODULE_0__.Point),
/* harmony export */   Polygon: () => (/* reexport safe */ _Polygon__WEBPACK_IMPORTED_MODULE_2__.Polygon),
/* harmony export */   Rectangle: () => (/* reexport safe */ _Rectangle__WEBPACK_IMPORTED_MODULE_3__.Rectangle),
/* harmony export */   boundingBoxFromPoints: () => (/* reexport safe */ _toolkit__WEBPACK_IMPORTED_MODULE_5__.boundingBoxFromPoints),
/* harmony export */   boundingBoxFromPolygons: () => (/* reexport safe */ _toolkit__WEBPACK_IMPORTED_MODULE_5__.boundingBoxFromPolygons),
/* harmony export */   boundsFromPositionAndSize: () => (/* reexport safe */ _Bounds__WEBPACK_IMPORTED_MODULE_6__.boundsFromPositionAndSize),
/* harmony export */   createEmptyBounds: () => (/* reexport safe */ _Bounds__WEBPACK_IMPORTED_MODULE_6__.createEmptyBounds)
/* harmony export */ });
/* harmony import */ var _Point__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Point */ "./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/Point.js");
/* harmony import */ var _Matrix__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Matrix */ "./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/Matrix.js");
/* harmony import */ var _Polygon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Polygon */ "./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/Polygon.js");
/* harmony import */ var _Rectangle__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Rectangle */ "./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/Rectangle.js");
/* harmony import */ var _BezierCurve__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./BezierCurve */ "./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/BezierCurve.js");
/* harmony import */ var _toolkit__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./toolkit */ "./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/toolkit.js");
/* harmony import */ var _Bounds__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Bounds */ "./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/Bounds.js");









/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/toolkit.js":
/*!****************************************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/toolkit.js ***!
  \****************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   boundingBoxFromPoints: () => (/* binding */ boundingBoxFromPoints),
/* harmony export */   boundingBoxFromPolygons: () => (/* binding */ boundingBoxFromPolygons)
/* harmony export */ });
/* harmony import */ var _Point__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Point */ "./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/Point.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Bounds__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Bounds */ "./node_modules/@projectstorm/react-diagrams-defaults/node_modules/@projectstorm/geometry/dist/Bounds.js");



const boundingBoxFromPoints = (points) => {
    if (points.length === 0) {
        return (0,_Bounds__WEBPACK_IMPORTED_MODULE_2__.createEmptyBounds)();
    }
    let minX = points[0].x;
    let maxX = points[0].x;
    let minY = points[0].y;
    let maxY = points[0].y;
    for (let i = 1; i < points.length; i++) {
        if (points[i].x < minX) {
            minX = points[i].x;
        }
        if (points[i].x > maxX) {
            maxX = points[i].x;
        }
        if (points[i].y < minY) {
            minY = points[i].y;
        }
        if (points[i].y > maxY) {
            maxY = points[i].y;
        }
    }
    return {
        [_Bounds__WEBPACK_IMPORTED_MODULE_2__.BoundsCorner.TOP_LEFT]: new _Point__WEBPACK_IMPORTED_MODULE_0__.Point(minX, minY),
        [_Bounds__WEBPACK_IMPORTED_MODULE_2__.BoundsCorner.TOP_RIGHT]: new _Point__WEBPACK_IMPORTED_MODULE_0__.Point(maxX, minY),
        [_Bounds__WEBPACK_IMPORTED_MODULE_2__.BoundsCorner.BOTTOM_RIGHT]: new _Point__WEBPACK_IMPORTED_MODULE_0__.Point(maxX, maxY),
        [_Bounds__WEBPACK_IMPORTED_MODULE_2__.BoundsCorner.BOTTOM_LEFT]: new _Point__WEBPACK_IMPORTED_MODULE_0__.Point(minX, maxY)
    };
};
const boundingBoxFromPolygons = (polygons) => {
    return boundingBoxFromPoints(lodash__WEBPACK_IMPORTED_MODULE_1__.flatMap(polygons, (polygon) => {
        return polygon.getPoints();
    }));
};


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_projectstorm_react-diagrams-defaults_node_modules_projectstorm_geometry_-6256fb.f479d04e8330a32e6d80.js.map