# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetExecutionActionsResult',
    'AwaitableGetExecutionActionsResult',
    'get_execution_actions',
    'get_execution_actions_output',
]

@pulumi.output_type
class GetExecutionActionsResult:
    """
    A collection of values returned by getExecutionActions.
    """
    def __init__(__self__, compartment_id=None, display_name=None, execution_actions=None, execution_window_id=None, filters=None, id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if execution_actions and not isinstance(execution_actions, list):
            raise TypeError("Expected argument 'execution_actions' to be a list")
        pulumi.set(__self__, "execution_actions", execution_actions)
        if execution_window_id and not isinstance(execution_window_id, str):
            raise TypeError("Expected argument 'execution_window_id' to be a str")
        pulumi.set(__self__, "execution_window_id", execution_window_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The user-friendly name for the execution action. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="executionActions")
    def execution_actions(self) -> Sequence['outputs.GetExecutionActionsExecutionActionResult']:
        """
        The list of execution_actions.
        """
        return pulumi.get(self, "execution_actions")

    @_builtins.property
    @pulumi.getter(name="executionWindowId")
    def execution_window_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the execution window resource the execution action belongs to.
        """
        return pulumi.get(self, "execution_window_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetExecutionActionsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the execution action. Valid states are SCHEDULED, IN_PROGRESS, FAILED, CANCELED, UPDATING, DELETED, SUCCEEDED and PARTIAL_SUCCESS.
        """
        return pulumi.get(self, "state")


class AwaitableGetExecutionActionsResult(GetExecutionActionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExecutionActionsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            execution_actions=self.execution_actions,
            execution_window_id=self.execution_window_id,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_execution_actions(compartment_id: Optional[_builtins.str] = None,
                          display_name: Optional[_builtins.str] = None,
                          execution_window_id: Optional[_builtins.str] = None,
                          filters: Optional[Sequence[Union['GetExecutionActionsFilterArgs', 'GetExecutionActionsFilterArgsDict']]] = None,
                          state: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExecutionActionsResult:
    """
    This data source provides the list of Execution Actions in Oracle Cloud Infrastructure Database service.

    Lists the execution action resources in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_execution_actions = oci.Database.get_execution_actions(compartment_id=compartment_id,
        display_name=execution_action_display_name,
        execution_window_id=test_execution_window["id"],
        state=execution_action_state)
    ```


    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param _builtins.str execution_window_id: A filter to return only resources that match the given execution wondow id.
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['executionWindowId'] = execution_window_id
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getExecutionActions:getExecutionActions', __args__, opts=opts, typ=GetExecutionActionsResult).value

    return AwaitableGetExecutionActionsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        execution_actions=pulumi.get(__ret__, 'execution_actions'),
        execution_window_id=pulumi.get(__ret__, 'execution_window_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_execution_actions_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 execution_window_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetExecutionActionsFilterArgs', 'GetExecutionActionsFilterArgsDict']]]]] = None,
                                 state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExecutionActionsResult]:
    """
    This data source provides the list of Execution Actions in Oracle Cloud Infrastructure Database service.

    Lists the execution action resources in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_execution_actions = oci.Database.get_execution_actions(compartment_id=compartment_id,
        display_name=execution_action_display_name,
        execution_window_id=test_execution_window["id"],
        state=execution_action_state)
    ```


    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param _builtins.str execution_window_id: A filter to return only resources that match the given execution wondow id.
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['executionWindowId'] = execution_window_id
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getExecutionActions:getExecutionActions', __args__, opts=opts, typ=GetExecutionActionsResult)
    return __ret__.apply(lambda __response__: GetExecutionActionsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        execution_actions=pulumi.get(__response__, 'execution_actions'),
        execution_window_id=pulumi.get(__response__, 'execution_window_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
