# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFusionEnvironmentsResult',
    'AwaitableGetFusionEnvironmentsResult',
    'get_fusion_environments',
    'get_fusion_environments_output',
]

@pulumi.output_type
class GetFusionEnvironmentsResult:
    """
    A collection of values returned by getFusionEnvironments.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, fusion_environment_collections=None, fusion_environment_family_id=None, id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fusion_environment_collections and not isinstance(fusion_environment_collections, list):
            raise TypeError("Expected argument 'fusion_environment_collections' to be a list")
        pulumi.set(__self__, "fusion_environment_collections", fusion_environment_collections)
        if fusion_environment_family_id and not isinstance(fusion_environment_family_id, str):
            raise TypeError("Expected argument 'fusion_environment_family_id' to be a str")
        pulumi.set(__self__, "fusion_environment_family_id", fusion_environment_family_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        FusionEnvironment Identifier, can be renamed
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFusionEnvironmentsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="fusionEnvironmentCollections")
    def fusion_environment_collections(self) -> Sequence['outputs.GetFusionEnvironmentsFusionEnvironmentCollectionResult']:
        """
        The list of fusion_environment_collection.
        """
        return pulumi.get(self, "fusion_environment_collections")

    @_builtins.property
    @pulumi.getter(name="fusionEnvironmentFamilyId")
    def fusion_environment_family_id(self) -> Optional[_builtins.str]:
        """
        FusionEnvironmentFamily Identifier
        """
        return pulumi.get(self, "fusion_environment_family_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the ServiceInstance.
        """
        return pulumi.get(self, "state")


class AwaitableGetFusionEnvironmentsResult(GetFusionEnvironmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFusionEnvironmentsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            fusion_environment_collections=self.fusion_environment_collections,
            fusion_environment_family_id=self.fusion_environment_family_id,
            id=self.id,
            state=self.state)


def get_fusion_environments(compartment_id: Optional[_builtins.str] = None,
                            display_name: Optional[_builtins.str] = None,
                            filters: Optional[Sequence[Union['GetFusionEnvironmentsFilterArgs', 'GetFusionEnvironmentsFilterArgsDict']]] = None,
                            fusion_environment_family_id: Optional[_builtins.str] = None,
                            state: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFusionEnvironmentsResult:
    """
    This data source provides the list of Fusion Environments in Oracle Cloud Infrastructure Fusion Apps service.

    Returns a list of FusionEnvironments.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fusion_environments = oci.Functions.get_fusion_environments(compartment_id=compartment_id,
        display_name=fusion_environment_display_name,
        fusion_environment_family_id=test_fusion_environment_family["id"],
        state=fusion_environment_state)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.str fusion_environment_family_id: The ID of the fusion environment family in which to list resources.
    :param _builtins.str state: A filter that returns all resources that match the specified lifecycle state.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['fusionEnvironmentFamilyId'] = fusion_environment_family_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Functions/getFusionEnvironments:getFusionEnvironments', __args__, opts=opts, typ=GetFusionEnvironmentsResult).value

    return AwaitableGetFusionEnvironmentsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        fusion_environment_collections=pulumi.get(__ret__, 'fusion_environment_collections'),
        fusion_environment_family_id=pulumi.get(__ret__, 'fusion_environment_family_id'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_fusion_environments_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[Union['GetFusionEnvironmentsFilterArgs', 'GetFusionEnvironmentsFilterArgsDict']]]]] = None,
                                   fusion_environment_family_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFusionEnvironmentsResult]:
    """
    This data source provides the list of Fusion Environments in Oracle Cloud Infrastructure Fusion Apps service.

    Returns a list of FusionEnvironments.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fusion_environments = oci.Functions.get_fusion_environments(compartment_id=compartment_id,
        display_name=fusion_environment_display_name,
        fusion_environment_family_id=test_fusion_environment_family["id"],
        state=fusion_environment_state)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.str fusion_environment_family_id: The ID of the fusion environment family in which to list resources.
    :param _builtins.str state: A filter that returns all resources that match the specified lifecycle state.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['fusionEnvironmentFamilyId'] = fusion_environment_family_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Functions/getFusionEnvironments:getFusionEnvironments', __args__, opts=opts, typ=GetFusionEnvironmentsResult)
    return __ret__.apply(lambda __response__: GetFusionEnvironmentsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        fusion_environment_collections=pulumi.get(__response__, 'fusion_environment_collections'),
        fusion_environment_family_id=pulumi.get(__response__, 'fusion_environment_family_id'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
