# -*- coding: utf-8 -*-
"""Initial migration of the poppy.pop plugin

Revision ID: poppy_pop_0001_initial
Revises:
Create Date: 2019-01-24 15:18:53.705836

"""

import sqlalchemy as sa
from sqlalchemy.dialects import postgresql
from poppy.pop.alembic.helpers import (
    create_table,
    create_schema,
    execute,
    user,
    drop_table,
)  # added by hand

# revision identifiers, used by Alembic.
revision = "poppy_pop_0001_initial"
down_revision = None
branch_labels = "poppy"
depends_on = None


def upgrade():
    create_schema("poppy")  # added by hand

    ## delete the types if they exist
    execute("DROP TYPE IF EXISTS poppy.job_state_type")
    execute("DROP TYPE IF EXISTS poppy.job_status_type")
    execute("DROP TYPE IF EXISTS poppy.exception_type_type")
    execute("DROP TYPE IF EXISTS poppy.exception_level_type")

    create_table(
        "job_log",
        sa.Column("id_job_log", sa.BIGINT(), nullable=False),
        sa.Column("job_plugin", sa.String(), nullable=False),
        sa.Column("job_task", sa.String(), nullable=False),
        sa.Column("job_name", sa.String(length=256), nullable=False),
        sa.Column("job_uuid", postgresql.UUID(), nullable=False),
        sa.Column("job_starttime", postgresql.TIMESTAMP(), nullable=False),
        sa.Column("job_endtime", postgresql.TIMESTAMP(), nullable=False),
        sa.Column("job_category", sa.String(length=256), nullable=False),
        sa.Column("job_descr", sa.String(length=256), nullable=False),
        sa.Column(
            "job_state",
            postgresql.ENUM(
                "Pending",
                "Terminated",
                "Running",
                name="job_state_type",
                schema="poppy",
            ),
            nullable=False,
        ),
        sa.Column(
            "job_status",
            postgresql.ENUM(
                "OK", "WARNING", "ERROR", name="job_status_type", schema="poppy"
            ),
            nullable=False,
        ),
        sa.Column("job_status_descr", sa.String(), nullable=False),
        sa.Column("job_parent_id", sa.BIGINT(), nullable=True),
        sa.ForeignKeyConstraint(
            ["job_parent_id"],
            ["poppy.job_log.id_job_log"],
        ),
        sa.PrimaryKeyConstraint("id_job_log"),
        sa.UniqueConstraint("job_uuid"),
        schema="poppy",
    )

    create_table(
        "job_exception",
        sa.Column("id_job_exception", sa.BIGINT(), nullable=False),
        sa.Column("job_log_id", sa.BIGINT(), nullable=False),
        sa.Column(
            "exception_type",
            postgresql.ENUM(
                "OK", "WARNING", "ERROR", name="exception_type_type", schema="poppy"
            ),
            nullable=False,
        ),
        sa.Column(
            "exception_level",
            postgresql.ENUM(
                "Low",
                "Normal",
                "High",
                "Critical",
                name="exception_level_type",
                schema="poppy",
            ),
            nullable=False,
        ),
        sa.Column("exception_msg", sa.String(), nullable=False),
        sa.ForeignKeyConstraint(
            ["job_log_id"],
            ["poppy.job_log.id_job_log"],
        ),
        sa.PrimaryKeyConstraint("id_job_exception"),
        schema="poppy",
    )

    # ### end Alembic commands ###

    grant_user_seq_poppy = (
        "GRANT USAGE, SELECT ON ALL SEQUENCES IN " "SCHEMA poppy TO {0}".format(user)
    )

    execute(grant_user_seq_poppy)


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    drop_table("job_exception", schema="poppy")
    drop_table("job_log", schema="poppy")
    execute("DROP TYPE IF EXISTS poppy.job_state_type")
    execute("DROP TYPE IF EXISTS poppy.job_status_type")
    execute("DROP TYPE IF EXISTS poppy.exception_type_type")
    execute("DROP TYPE IF EXISTS poppy.exception_level_type")
    execute("DROP SCHEMA poppy")
    # ### end Alembic commands ###
