# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.10.1, generator: @autorest/python@5.16.0)
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._affinda_api_operations import (
    build_activate_resthook_subscription_request,
    build_create_index_document_request,
    build_create_index_request,
    build_create_invoice_request,
    build_create_job_description_request,
    build_create_job_description_search_embed_url_request,
    build_create_job_description_search_request,
    build_create_redacted_resume_request,
    build_create_resthook_subscription_request,
    build_create_resume_request,
    build_create_resume_search_embed_url_request,
    build_create_resume_search_request,
    build_delete_index_document_request,
    build_delete_index_request,
    build_delete_invoice_request,
    build_delete_job_description_request,
    build_delete_redacted_resume_request,
    build_delete_resthook_subscription_request,
    build_delete_resume_request,
    build_get_all_index_documents_request,
    build_get_all_indexes_request,
    build_get_all_invoices_request,
    build_get_all_job_descriptions_request,
    build_get_all_redacted_resumes_request,
    build_get_all_resthook_subscriptions_request,
    build_get_all_resumes_request,
    build_get_invoice_request,
    build_get_job_description_request,
    build_get_job_description_search_config_request,
    build_get_job_description_search_detail_request,
    build_get_redacted_resume_request,
    build_get_resthook_subscription_request,
    build_get_resume_request,
    build_get_resume_search_config_request,
    build_get_resume_search_detail_request,
    build_get_resume_search_match_request,
    build_get_resume_search_suggestion_job_title_request,
    build_get_resume_search_suggestion_skill_request,
    build_list_occupation_groups_request,
    build_update_index_request,
    build_update_job_description_data_request,
    build_update_job_description_search_config_request,
    build_update_resthook_subscription_request,
    build_update_resume_data_request,
    build_update_resume_search_config_request,
)

T = TypeVar("T")
ClsType = Optional[
    Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]
]


class AffindaAPIOperationsMixin:  # pylint: disable=too-many-public-methods
    async def get_all_resumes(
        self,
        offset: Optional[int] = None,
        limit: Optional[int] = None,
        custom_identifier: Optional[str] = None,
        **kwargs: Any,
    ) -> _models.Paths14VxierV2ResumesGetResponses200ContentApplicationJsonSchema:
        """Get list of all resumes.

        Returns all the resume summaries for that user, limited to 300 per page.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is None.
        :type limit: int
        :param custom_identifier: Filter for documents with this custom identifier. Default value is
         None.
        :type custom_identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Paths14VxierV2ResumesGetResponses200ContentApplicationJsonSchema, or the result of
         cls(response)
        :rtype: ~affinda_v2.models.Paths14VxierV2ResumesGetResponses200ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Paths14VxierV2ResumesGetResponses200ContentApplicationJsonSchema]

        request = build_get_all_resumes_request(
            offset=offset,
            limit=limit,
            custom_identifier=custom_identifier,
            template_url=self.get_all_resumes.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "Paths14VxierV2ResumesGetResponses200ContentApplicationJsonSchema", pipeline_response
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_resumes.metadata = {"url": "/v2/resumes"}  # type: ignore

    async def create_resume(
        self,
        file: Optional[IO] = None,
        url: Optional[str] = None,
        data: Optional[_models.ResumeData] = None,
        identifier: Optional[str] = None,
        custom_identifier: Optional[str] = None,
        file_name: Optional[str] = None,
        wait: Optional[bool] = True,
        reject_duplicates: Optional[bool] = None,
        language: Optional[str] = None,
        expiry_time: Optional[datetime.datetime] = None,
        region_bias: Optional[str] = None,
        low_priority: Optional[bool] = None,
        **kwargs: Any,
    ) -> _models.Resume:
        """Upload a resume for parsing.

        Uploads a resume for parsing. When successful, returns an ``identifier`` in the response for
        subsequent use with the `/resumes/{identifier} <#get-/resumes/-identifier->`_ endpoint to check
        processing status and retrieve results.:code:`<br/>`
        Resumes can be uploaded as a file or a URL. In addition, data can be added directly if users
        want to upload directly without parsing any resume file. For uploading resume data, the
        ``data`` argument provided must be a JSON-encoded string. Data uploads will not impact upon
        parsing credits.

        :param file:  Default value is None.
        :type file: IO
        :param url: URL to download the resume. Default value is None.
        :type url: str
        :param data:  Default value is None.
        :type data: ~affinda_v2.models.ResumeData
        :param identifier: Deprecated in favor of ``customIdentifier``. Default value is None.
        :type identifier: str
        :param custom_identifier: Specify a custom identifier for the document if you need one, not
         required to be unique. Default value is None.
        :type custom_identifier: str
        :param file_name:  Default value is None.
        :type file_name: str
        :param wait:  Default value is True.
        :type wait: bool
        :param reject_duplicates:  Default value is None.
        :type reject_duplicates: bool
        :param language:  Default value is None.
        :type language: str
        :param expiry_time:  Default value is None.
        :type expiry_time: ~datetime.datetime
        :param region_bias:  Default value is None.
        :type region_bias: str
        :param low_priority:  Default value is None.
        :type low_priority: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Resume, or the result of cls(response)
        :rtype: ~affinda_v2.models.Resume
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Resume]

        # Construct form data
        _files = {
            "file": file,
            "url": url,
            "data": data,
            "identifier": identifier,
            "customIdentifier": custom_identifier,
            "fileName": file_name,
            "wait": wait,
            "rejectDuplicates": reject_duplicates,
            "language": language,
            "expiryTime": expiry_time,
            "regionBias": region_bias,
            "lowPriority": low_priority,
        }

        request = build_create_resume_request(
            content_type=content_type,
            files=_files,
            template_url=self.create_resume.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request, _files)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("Resume", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("Resume", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_resume.metadata = {"url": "/v2/resumes"}  # type: ignore

    async def get_resume(
        self, identifier: str, format: Optional[Union[str, "_models.Enum2"]] = None, **kwargs: Any
    ) -> _models.Resume:
        """Get parse results for a specific resume.

        Returns all the parse results for that resume if processing is completed.
        The ``identifier`` is the unique ID returned after POST-ing the resume via the `/resumes
        <#post-/resumes>`_ endpoint.

        :param identifier: Document identifier.
        :type identifier: str
        :param format: Set this to "hr-xml" to get the response in HR-XML format. Currently the only
         supported value for this parameter is "hr-xml". Default value is None.
        :type format: str or ~affinda_v2.models.Enum2
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Resume, or the result of cls(response)
        :rtype: ~affinda_v2.models.Resume
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            403: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            403: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            404: lambda response: ResourceNotFoundError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            404: lambda response: ResourceNotFoundError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Resume]

        request = build_get_resume_request(
            identifier=identifier,
            format=format,
            template_url=self.get_resume.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("Resume", pipeline_response)

        if response.status_code == 200:
            deserialized = self._deserialize("Resume", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resume.metadata = {"url": "/v2/resumes/{identifier}"}  # type: ignore

    async def update_resume_data(
        self, identifier: str, body: _models.ResumeData, **kwargs: Any
    ) -> Optional[_models.ResumeData]:
        """Update a resume's data.

        Update data of a parsed resume.
        The ``identifier`` is the unique ID returned after POST-ing the resume via the `/resumes
        <#post-/resumes>`_ endpoint.

        :param identifier: Resume identifier.
        :type identifier: str
        :param body: Resume data to update.
        :type body: ~affinda_v2.models.ResumeData
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeData or None, or the result of cls(response)
        :rtype: ~affinda_v2.models.ResumeData or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[_models.ResumeData]]

        _json = self._serialize.body(body, "ResumeData")

        request = build_update_resume_data_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.update_resume_data.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ResumeData", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_resume_data.metadata = {"url": "/v2/resumes/{identifier}"}  # type: ignore

    async def delete_resume(  # pylint: disable=inconsistent-return-statements
        self, identifier: str, **kwargs: Any
    ) -> None:
        """Delete a resume.

        Deletes the specified resume from the database.

        :param identifier: Resume identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_resume_request(
            identifier=identifier,
            template_url=self.delete_resume.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_resume.metadata = {"url": "/v2/resumes/{identifier}"}  # type: ignore

    async def get_all_redacted_resumes(
        self,
        offset: Optional[int] = None,
        limit: Optional[int] = None,
        custom_identifier: Optional[str] = None,
        **kwargs: Any,
    ) -> _models.Paths1D957B5V2RedactedResumesGetResponses200ContentApplicationJsonSchema:
        """Get list of all redacted resumes.

        Returns all the redacted resume information for that resume.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is None.
        :type limit: int
        :param custom_identifier: Filter for documents with this custom identifier. Default value is
         None.
        :type custom_identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Paths1D957B5V2RedactedResumesGetResponses200ContentApplicationJsonSchema, or the
         result of cls(response)
        :rtype:
         ~affinda_v2.models.Paths1D957B5V2RedactedResumesGetResponses200ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Paths1D957B5V2RedactedResumesGetResponses200ContentApplicationJsonSchema]

        request = build_get_all_redacted_resumes_request(
            offset=offset,
            limit=limit,
            custom_identifier=custom_identifier,
            template_url=self.get_all_redacted_resumes.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "Paths1D957B5V2RedactedResumesGetResponses200ContentApplicationJsonSchema",
            pipeline_response,
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_redacted_resumes.metadata = {"url": "/v2/redacted_resumes"}  # type: ignore

    async def create_redacted_resume(
        self,
        file: Optional[IO] = None,
        identifier: Optional[str] = None,
        custom_identifier: Optional[str] = None,
        file_name: Optional[str] = None,
        url: Optional[str] = None,
        language: Optional[str] = None,
        wait: Optional[bool] = True,
        redact_headshot: Optional[str] = "true",
        redact_personal_details: Optional[str] = "true",
        redact_work_details: Optional[str] = "true",
        redact_education_details: Optional[str] = "true",
        redact_referees: Optional[str] = "true",
        redact_locations: Optional[str] = "true",
        redact_dates: Optional[str] = "true",
        redact_gender: Optional[str] = "true",
        redact_pdf_metadata: Optional[str] = "true",
        expiry_time: Optional[datetime.datetime] = None,
        **kwargs: Any,
    ) -> _models.RedactedResume:
        """Upload a resume for redacting.

        Uploads a resume for redacting.

        :param file:  Default value is None.
        :type file: IO
        :param identifier: Deprecated in favor of ``customIdentifier``. Default value is None.
        :type identifier: str
        :param custom_identifier: Specify a custom identifier for the document if you need one, not
         required to be unique. Default value is None.
        :type custom_identifier: str
        :param file_name:  Default value is None.
        :type file_name: str
        :param url: URL to download the resume. Default value is None.
        :type url: str
        :param language:  Default value is None.
        :type language: str
        :param wait:  Default value is True.
        :type wait: bool
        :param redact_headshot: Whether to redact headshot. Default value is "true".
        :type redact_headshot: str
        :param redact_personal_details: Whether to redact personal details (e.g. name, address).
         Default value is "true".
        :type redact_personal_details: str
        :param redact_work_details: Whether to redact work details (e.g. company names). Default value
         is "true".
        :type redact_work_details: str
        :param redact_education_details: Whether to redact education details (e.g. university names).
         Default value is "true".
        :type redact_education_details: str
        :param redact_referees: Whether to redact referee details. Default value is "true".
        :type redact_referees: str
        :param redact_locations: Whether to redact location names. Default value is "true".
        :type redact_locations: str
        :param redact_dates: Whether to redact dates. Default value is "true".
        :type redact_dates: str
        :param redact_gender: Whether to redact gender. Default value is "true".
        :type redact_gender: str
        :param redact_pdf_metadata: Whether to redact PDF metadata. Default value is "true".
        :type redact_pdf_metadata: str
        :param expiry_time:  Default value is None.
        :type expiry_time: ~datetime.datetime
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RedactedResume, or the result of cls(response)
        :rtype: ~affinda_v2.models.RedactedResume
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.RedactedResume]

        # Construct form data
        _files = {
            "file": file,
            "identifier": identifier,
            "customIdentifier": custom_identifier,
            "fileName": file_name,
            "url": url,
            "language": language,
            "wait": wait,
            "redactHeadshot": redact_headshot,
            "redactPersonalDetails": redact_personal_details,
            "redactWorkDetails": redact_work_details,
            "redactEducationDetails": redact_education_details,
            "redactReferees": redact_referees,
            "redactLocations": redact_locations,
            "redactDates": redact_dates,
            "redactGender": redact_gender,
            "redactPdfMetadata": redact_pdf_metadata,
            "expiryTime": expiry_time,
        }

        request = build_create_redacted_resume_request(
            content_type=content_type,
            files=_files,
            template_url=self.create_redacted_resume.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request, _files)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("RedactedResume", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("RedactedResume", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_redacted_resume.metadata = {"url": "/v2/redacted_resumes"}  # type: ignore

    async def get_redacted_resume(self, identifier: str, **kwargs: Any) -> _models.RedactedResume:
        """Get redaction results for a specific resume.

        Returns all the redaction results for that resume if processing is completed.
        The ``identifier`` is the unique ID returned after POST-ing the resume via the
        `/redacted_resumes <#post-/redacted_resumes>`_ endpoint.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RedactedResume, or the result of cls(response)
        :rtype: ~affinda_v2.models.RedactedResume
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.RedactedResume]

        request = build_get_redacted_resume_request(
            identifier=identifier,
            template_url=self.get_redacted_resume.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("RedactedResume", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_redacted_resume.metadata = {"url": "/v2/redacted_resumes/{identifier}"}  # type: ignore

    async def delete_redacted_resume(  # pylint: disable=inconsistent-return-statements
        self, identifier: str, **kwargs: Any
    ) -> None:
        """Delete a redacted resume.

        Deletes the specified resume from the database.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_redacted_resume_request(
            identifier=identifier,
            template_url=self.delete_redacted_resume.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_redacted_resume.metadata = {"url": "/v2/redacted_resumes/{identifier}"}  # type: ignore

    async def get_all_invoices(
        self,
        offset: Optional[int] = None,
        limit: Optional[int] = None,
        custom_identifier: Optional[str] = None,
        **kwargs: Any,
    ) -> _models.PathsGfm23QV2InvoicesGetResponses200ContentApplicationJsonSchema:
        """Get list of all invoices.

        Returns all the invoice summaries for that user, limited to 300 per page.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is None.
        :type limit: int
        :param custom_identifier: Filter for documents with this custom identifier. Default value is
         None.
        :type custom_identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PathsGfm23QV2InvoicesGetResponses200ContentApplicationJsonSchema, or the result of
         cls(response)
        :rtype: ~affinda_v2.models.PathsGfm23QV2InvoicesGetResponses200ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.PathsGfm23QV2InvoicesGetResponses200ContentApplicationJsonSchema]

        request = build_get_all_invoices_request(
            offset=offset,
            limit=limit,
            custom_identifier=custom_identifier,
            template_url=self.get_all_invoices.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "PathsGfm23QV2InvoicesGetResponses200ContentApplicationJsonSchema", pipeline_response
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_invoices.metadata = {"url": "/v2/invoices"}  # type: ignore

    async def create_invoice(
        self,
        file: Optional[IO] = None,
        url: Optional[str] = None,
        identifier: Optional[str] = None,
        custom_identifier: Optional[str] = None,
        file_name: Optional[str] = None,
        wait: Optional[bool] = True,
        reject_duplicates: Optional[bool] = None,
        language: Optional[str] = None,
        expiry_time: Optional[datetime.datetime] = None,
        region_bias: Optional[str] = None,
        low_priority: Optional[bool] = None,
        **kwargs: Any,
    ) -> _models.Invoice:
        """Upload an invoice for parsing.

        Uploads an invoice for parsing.
        When successful, returns an ``identifier`` in the response for subsequent use with the
        `/invoices/{identifier} <#get-/invoices/-identifier->`_ endpoint to check processing status and
        retrieve results.

        :param file:  Default value is None.
        :type file: IO
        :param url: URL to download the invoice. Default value is None.
        :type url: str
        :param identifier: Deprecated in favor of ``customIdentifier``. Default value is None.
        :type identifier: str
        :param custom_identifier: Specify a custom identifier for the document if you need one, not
         required to be unique. Default value is None.
        :type custom_identifier: str
        :param file_name:  Default value is None.
        :type file_name: str
        :param wait:  Default value is True.
        :type wait: bool
        :param reject_duplicates:  Default value is None.
        :type reject_duplicates: bool
        :param language:  Default value is None.
        :type language: str
        :param expiry_time:  Default value is None.
        :type expiry_time: ~datetime.datetime
        :param region_bias:  Default value is None.
        :type region_bias: str
        :param low_priority:  Default value is None.
        :type low_priority: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Invoice, or the result of cls(response)
        :rtype: ~affinda_v2.models.Invoice
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Invoice]

        # Construct form data
        _files = {
            "file": file,
            "url": url,
            "identifier": identifier,
            "customIdentifier": custom_identifier,
            "fileName": file_name,
            "wait": wait,
            "rejectDuplicates": reject_duplicates,
            "language": language,
            "expiryTime": expiry_time,
            "regionBias": region_bias,
            "lowPriority": low_priority,
        }

        request = build_create_invoice_request(
            content_type=content_type,
            files=_files,
            template_url=self.create_invoice.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request, _files)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("Invoice", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("Invoice", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_invoice.metadata = {"url": "/v2/invoices"}  # type: ignore

    async def get_invoice(self, identifier: str, **kwargs: Any) -> _models.Invoice:
        """Get parse results for a specific invoice.

        Returns all the parse results for that invoice if processing is completed.
        The ``identifier`` is the unique ID returned after POST-ing the invoice via the `/invoices
        <#post-/invoices>`_ endpoint.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Invoice, or the result of cls(response)
        :rtype: ~affinda_v2.models.Invoice
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Invoice]

        request = build_get_invoice_request(
            identifier=identifier,
            template_url=self.get_invoice.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Invoice", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_invoice.metadata = {"url": "/v2/invoices/{identifier}"}  # type: ignore

    async def delete_invoice(  # pylint: disable=inconsistent-return-statements
        self, identifier: str, **kwargs: Any
    ) -> None:
        """Delete an invoice.

        Delete the specified invoice from the database. Note, any invoices deleted from the database
        will no longer be used in any tailored customer models.

        :param identifier: Invoice identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_invoice_request(
            identifier=identifier,
            template_url=self.delete_invoice.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_invoice.metadata = {"url": "/v2/invoices/{identifier}"}  # type: ignore

    async def get_all_job_descriptions(
        self,
        offset: Optional[int] = None,
        limit: Optional[int] = None,
        custom_identifier: Optional[str] = None,
        **kwargs: Any,
    ) -> _models.PathsChbpqfV2JobDescriptionsGetResponses200ContentApplicationJsonSchema:
        """Get list of all job descriptions.

        Returns all the job descriptions for that user, limited to 300 per page.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is None.
        :type limit: int
        :param custom_identifier: Filter for documents with this custom identifier. Default value is
         None.
        :type custom_identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PathsChbpqfV2JobDescriptionsGetResponses200ContentApplicationJsonSchema, or the result
         of cls(response)
        :rtype: ~affinda_v2.models.PathsChbpqfV2JobDescriptionsGetResponses200ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.PathsChbpqfV2JobDescriptionsGetResponses200ContentApplicationJsonSchema]

        request = build_get_all_job_descriptions_request(
            offset=offset,
            limit=limit,
            custom_identifier=custom_identifier,
            template_url=self.get_all_job_descriptions.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "PathsChbpqfV2JobDescriptionsGetResponses200ContentApplicationJsonSchema",
            pipeline_response,
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_job_descriptions.metadata = {"url": "/v2/job_descriptions"}  # type: ignore

    async def create_job_description(
        self,
        file: Optional[IO] = None,
        url: Optional[str] = None,
        data: Optional[_models.JobDescriptionDataUpdate] = None,
        identifier: Optional[str] = None,
        custom_identifier: Optional[str] = None,
        file_name: Optional[str] = None,
        wait: Optional[bool] = True,
        reject_duplicates: Optional[bool] = None,
        language: Optional[str] = None,
        expiry_time: Optional[datetime.datetime] = None,
        region_bias: Optional[str] = None,
        low_priority: Optional[bool] = None,
        **kwargs: Any,
    ) -> _models.JobDescription:
        """Upload a job description for parsing.

        Uploads a job description for parsing.
        When successful, returns an ``identifier`` in the response for subsequent use with the
        `/job_descriptions/{identifier} <#get-/job_descriptions/-identifier->`_ endpoint to check
        processing status and retrieve results.
        Job Descriptions can be uploaded as a file or a URL. In addition, data can be added directly if
        users want to upload directly without parsing any resume file. For uploading resume data, the
        ``data`` argument provided must be a JSON-encoded string. Data uploads will not impact upon
        parsing credits.

        :param file:  Default value is None.
        :type file: IO
        :param url: URL to download the job description. Default value is None.
        :type url: str
        :param data:  Default value is None.
        :type data: ~affinda_v2.models.JobDescriptionDataUpdate
        :param identifier: Deprecated in favor of ``customIdentifier``. Default value is None.
        :type identifier: str
        :param custom_identifier: Specify a custom identifier for the document if you need one, not
         required to be unique. Default value is None.
        :type custom_identifier: str
        :param file_name:  Default value is None.
        :type file_name: str
        :param wait:  Default value is True.
        :type wait: bool
        :param reject_duplicates:  Default value is None.
        :type reject_duplicates: bool
        :param language:  Default value is None.
        :type language: str
        :param expiry_time:  Default value is None.
        :type expiry_time: ~datetime.datetime
        :param region_bias:  Default value is None.
        :type region_bias: str
        :param low_priority:  Default value is None.
        :type low_priority: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescription, or the result of cls(response)
        :rtype: ~affinda_v2.models.JobDescription
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.JobDescription]

        # Construct form data
        _files = {
            "file": file,
            "url": url,
            "data": data,
            "identifier": identifier,
            "customIdentifier": custom_identifier,
            "fileName": file_name,
            "wait": wait,
            "rejectDuplicates": reject_duplicates,
            "language": language,
            "expiryTime": expiry_time,
            "regionBias": region_bias,
            "lowPriority": low_priority,
        }

        request = build_create_job_description_request(
            content_type=content_type,
            files=_files,
            template_url=self.create_job_description.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request, _files)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("JobDescription", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("JobDescription", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_job_description.metadata = {"url": "/v2/job_descriptions"}  # type: ignore

    async def get_job_description(self, identifier: str, **kwargs: Any) -> _models.JobDescription:
        """Get job description results for a specific job description file.

        Returns all the results for that job description if processing is completed.
        The ``identifier`` is the unique ID returned after POST-ing the resume via the
        `/job_descriptions <#post-/job_descriptions>`_ endpoint.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescription, or the result of cls(response)
        :rtype: ~affinda_v2.models.JobDescription
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.JobDescription]

        request = build_get_job_description_request(
            identifier=identifier,
            template_url=self.get_job_description.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("JobDescription", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_job_description.metadata = {"url": "/v2/job_descriptions/{identifier}"}  # type: ignore

    async def update_job_description_data(
        self, identifier: str, body: _models.JobDescriptionDataUpdate, **kwargs: Any
    ) -> Optional[_models.JobDescriptionData]:
        """Update a job description's data.

        Update data of a job description.
        The ``identifier`` is the unique ID returned after POST-ing the job description via the
        `/job_descriptions <#post-/job_descriptions>`_ endpoint.

        :param identifier: Job description identifier.
        :type identifier: str
        :param body: Job description data to update.
        :type body: ~affinda_v2.models.JobDescriptionDataUpdate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescriptionData or None, or the result of cls(response)
        :rtype: ~affinda_v2.models.JobDescriptionData or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[_models.JobDescriptionData]]

        _json = self._serialize.body(body, "JobDescriptionDataUpdate")

        request = build_update_job_description_data_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.update_job_description_data.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("JobDescriptionData", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_job_description_data.metadata = {"url": "/v2/job_descriptions/{identifier}"}  # type: ignore

    async def delete_job_description(  # pylint: disable=inconsistent-return-statements
        self, identifier: str, **kwargs: Any
    ) -> None:
        """Delete a job description.

        Deletes the specified job description from the database.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_job_description_request(
            identifier=identifier,
            template_url=self.delete_job_description.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_job_description.metadata = {"url": "/v2/job_descriptions/{identifier}"}  # type: ignore

    async def create_job_description_search(
        self,
        body: _models.JobDescriptionSearchParameters,
        offset: Optional[int] = None,
        limit: Optional[int] = None,
        **kwargs: Any,
    ) -> _models.JobDescriptionSearch:
        """Search through parsed job descriptions.

        Searches through parsed job descriptions. You can search with custom criterias or a resume.

        :param body: Search parameters.
        :type body: ~affinda_v2.models.JobDescriptionSearchParameters
        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is None.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescriptionSearch, or the result of cls(response)
        :rtype: ~affinda_v2.models.JobDescriptionSearch
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.JobDescriptionSearch]

        _json = self._serialize.body(body, "JobDescriptionSearchParameters")

        request = build_create_job_description_search_request(
            content_type=content_type,
            json=_json,
            offset=offset,
            limit=limit,
            template_url=self.create_job_description_search.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("JobDescriptionSearch", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_job_description_search.metadata = {"url": "/v2/job_description_search"}  # type: ignore

    async def get_job_description_search_detail(
        self, identifier: str, body: _models.JobDescriptionSearchParameters, **kwargs: Any
    ) -> _models.JobDescriptionSearchDetail:
        """Get search result of specific job description.

        This contains more detailed information about the matching score of the search criteria, or
        which search criteria is missing in this job description.
        The ``identifier`` is the unique ID returned via the `/job_description_search
        <#post-/job_description_search>`_ endpoint.

        :param identifier: Job Description identifier.
        :type identifier: str
        :param body: Search parameters.
        :type body: ~affinda_v2.models.JobDescriptionSearchParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescriptionSearchDetail, or the result of cls(response)
        :rtype: ~affinda_v2.models.JobDescriptionSearchDetail
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.JobDescriptionSearchDetail]

        _json = self._serialize.body(body, "JobDescriptionSearchParameters")

        request = build_get_job_description_search_detail_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.get_job_description_search_detail.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("JobDescriptionSearchDetail", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_job_description_search_detail.metadata = {
        "url": "/v2/job_description_search/details/{identifier}"
    }  # type: ignore

    async def get_job_description_search_config(
        self, **kwargs: Any
    ) -> _models.JobDescriptionSearchConfig:
        """Get the config for the logged in user's embeddable job description search tool.

        Return configurations such as which fields can be displayed in the logged in user's embeddable
        job description search tool, what are their weights, what is the maximum number of results that
        can be returned, etc.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescriptionSearchConfig, or the result of cls(response)
        :rtype: ~affinda_v2.models.JobDescriptionSearchConfig
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.JobDescriptionSearchConfig]

        request = build_get_job_description_search_config_request(
            template_url=self.get_job_description_search_config.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("JobDescriptionSearchConfig", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_job_description_search_config.metadata = {"url": "/v2/job_description_search/config"}  # type: ignore

    async def update_job_description_search_config(
        self, body: _models.JobDescriptionSearchConfig, **kwargs: Any
    ) -> _models.JobDescriptionSearchConfig:
        """Update the config for the logged in user's embeddable job description search tool.

        Update configurations such as which fields can be displayed in the logged in user's embeddable
        job description search tool, what are their weights, what is the maximum number of results that
        can be returned, etc.

        :param body:
        :type body: ~affinda_v2.models.JobDescriptionSearchConfig
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescriptionSearchConfig, or the result of cls(response)
        :rtype: ~affinda_v2.models.JobDescriptionSearchConfig
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.JobDescriptionSearchConfig]

        _json = self._serialize.body(body, "JobDescriptionSearchConfig")

        request = build_update_job_description_search_config_request(
            content_type=content_type,
            json=_json,
            template_url=self.update_job_description_search_config.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("JobDescriptionSearchConfig", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_job_description_search_config.metadata = {"url": "/v2/job_description_search/config"}  # type: ignore

    async def create_job_description_search_embed_url(
        self,
        body: Optional[
            _models.Paths15O3Zn5V2JobDescriptionSearchEmbedPostRequestbodyContentApplicationJsonSchema
        ] = None,
        **kwargs: Any,
    ) -> _models.JobDescriptionSearchEmbed:
        """Create a signed URL for the embeddable job description search tool.

        Create and return a signed URL of the job description search tool which then can be embedded on
        a web page. An optional parameter ``config_override`` can be passed to override the user-level
        configurations of the embeddable search tool.

        :param body:  Default value is None.
        :type body:
         ~affinda_v2.models.Paths15O3Zn5V2JobDescriptionSearchEmbedPostRequestbodyContentApplicationJsonSchema
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescriptionSearchEmbed, or the result of cls(response)
        :rtype: ~affinda_v2.models.JobDescriptionSearchEmbed
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.JobDescriptionSearchEmbed]

        if body is not None:
            _json = self._serialize.body(
                body,
                "Paths15O3Zn5V2JobDescriptionSearchEmbedPostRequestbodyContentApplicationJsonSchema",
            )
        else:
            _json = None

        request = build_create_job_description_search_embed_url_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_job_description_search_embed_url.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("JobDescriptionSearchEmbed", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_job_description_search_embed_url.metadata = {"url": "/v2/job_description_search/embed"}  # type: ignore

    async def create_resume_search(
        self,
        body: _models.ResumeSearchParameters,
        offset: Optional[int] = None,
        limit: Optional[int] = None,
        **kwargs: Any,
    ) -> _models.ResumeSearch:
        """Search through parsed resumes.

        Searches through parsed resumes. Users have 3 options to create a search::code:`<br
        />`:code:`<br />` 1.    Match to a job description - a parsed job description is used to find
        candidates that suit it:code:`<br />` 2.  Match to a resume - a parsed resume is used to find
        other candidates that have similar attributes:code:`<br />` 3.  Search using custom
        criteria:code:`<br />`:code:`<br />` Users should only populate 1 of jobDescription, resume or
        the custom criteria.

        :param body: Search parameters.
        :type body: ~affinda_v2.models.ResumeSearchParameters
        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is None.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearch, or the result of cls(response)
        :rtype: ~affinda_v2.models.ResumeSearch
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResumeSearch]

        _json = self._serialize.body(body, "ResumeSearchParameters")

        request = build_create_resume_search_request(
            content_type=content_type,
            json=_json,
            offset=offset,
            limit=limit,
            template_url=self.create_resume_search.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ResumeSearch", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_resume_search.metadata = {"url": "/v2/resume_search"}  # type: ignore

    async def get_resume_search_detail(
        self, identifier: str, body: _models.ResumeSearchParameters, **kwargs: Any
    ) -> _models.ResumeSearchDetail:
        """Get search result of specific resume.

        This contains more detailed information about the matching score of the search criteria, or
        which search criteria is missing in this resume.
        The ``identifier`` is the unique ID returned via the `/resume_search <#post-/resume_search>`_
        endpoint.

        :param identifier: Resume identifier.
        :type identifier: str
        :param body: Search parameters.
        :type body: ~affinda_v2.models.ResumeSearchParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearchDetail, or the result of cls(response)
        :rtype: ~affinda_v2.models.ResumeSearchDetail
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResumeSearchDetail]

        _json = self._serialize.body(body, "ResumeSearchParameters")

        request = build_get_resume_search_detail_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.get_resume_search_detail.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ResumeSearchDetail", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resume_search_detail.metadata = {"url": "/v2/resume_search/details/{identifier}"}  # type: ignore

    async def get_resume_search_match(
        self,
        resume: str,
        job_description: str,
        index: Optional[str] = None,
        search_expression: Optional[str] = None,
        job_titles_weight: Optional[float] = None,
        years_experience_weight: Optional[float] = None,
        locations_weight: Optional[float] = None,
        languages_weight: Optional[float] = None,
        skills_weight: Optional[float] = None,
        education_weight: Optional[float] = None,
        search_expression_weight: Optional[float] = None,
        soc_codes_weight: Optional[float] = None,
        management_level_weight: Optional[float] = None,
        **kwargs: Any,
    ) -> _models.ResumeSearchMatch:
        """Match a single resume and job description.

        Get the matching score between a resume and a job description. The score ranges between 0 and
        1, with 0 being not a match at all, and 1 being perfect match.:code:`<br/>` Note, this score
        will not directly match the score returned from POST `/resume_search/details/{identifier}
        <#post-/resume_search/details/-identifier->`_.

        :param resume: Identify the resume to match.
        :type resume: str
        :param job_description: Identify the job description to match.
        :type job_description: str
        :param index: Optionally, specify an index to search in. If not specified, will search in all
         indexes. Default value is None.
        :type index: str
        :param search_expression: Add keywords to the search criteria. Default value is None.
        :type search_expression: str
        :param job_titles_weight: How important is this criteria to the matching score, range from 0 to
         1. Default value is None.
        :type job_titles_weight: float
        :param years_experience_weight: How important is this criteria to the matching score, range
         from 0 to 1. Default value is None.
        :type years_experience_weight: float
        :param locations_weight: How important is this criteria to the matching score, range from 0 to
         1. Default value is None.
        :type locations_weight: float
        :param languages_weight: How important is this criteria to the matching score, range from 0 to
         1. Default value is None.
        :type languages_weight: float
        :param skills_weight: How important is this criteria to the matching score, range from 0 to 1.
         Default value is None.
        :type skills_weight: float
        :param education_weight: How important is this criteria to the matching score, range from 0 to
         1. Default value is None.
        :type education_weight: float
        :param search_expression_weight: How important is this criteria to the matching score, range
         from 0 to 1. Default value is None.
        :type search_expression_weight: float
        :param soc_codes_weight: How important is this criteria to the matching score, range from 0 to
         1. Default value is None.
        :type soc_codes_weight: float
        :param management_level_weight: How important is this criteria to the matching score, range
         from 0 to 1. Default value is None.
        :type management_level_weight: float
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearchMatch, or the result of cls(response)
        :rtype: ~affinda_v2.models.ResumeSearchMatch
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResumeSearchMatch]

        request = build_get_resume_search_match_request(
            resume=resume,
            job_description=job_description,
            index=index,
            search_expression=search_expression,
            job_titles_weight=job_titles_weight,
            years_experience_weight=years_experience_weight,
            locations_weight=locations_weight,
            languages_weight=languages_weight,
            skills_weight=skills_weight,
            education_weight=education_weight,
            search_expression_weight=search_expression_weight,
            soc_codes_weight=soc_codes_weight,
            management_level_weight=management_level_weight,
            template_url=self.get_resume_search_match.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ResumeSearchMatch", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resume_search_match.metadata = {"url": "/v2/resume_search/match"}  # type: ignore

    async def get_resume_search_config(self, **kwargs: Any) -> _models.ResumeSearchConfig:
        """Get the config for the logged in user's embeddable resume search tool.

        Return configurations such as which fields can be displayed in the logged in user's embeddable
        resume search tool, what are their weights, what is the maximum number of results that can be
        returned, etc.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearchConfig, or the result of cls(response)
        :rtype: ~affinda_v2.models.ResumeSearchConfig
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResumeSearchConfig]

        request = build_get_resume_search_config_request(
            template_url=self.get_resume_search_config.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ResumeSearchConfig", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resume_search_config.metadata = {"url": "/v2/resume_search/config"}  # type: ignore

    async def update_resume_search_config(
        self, body: _models.ResumeSearchConfig, **kwargs: Any
    ) -> _models.ResumeSearchConfig:
        """Update the config for the logged in user's embeddable resume search tool.

        Update configurations such as which fields can be displayed in the logged in user's embeddable
        resume search tool, what are their weights, what is the maximum number of results that can be
        returned, etc.

        :param body:
        :type body: ~affinda_v2.models.ResumeSearchConfig
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearchConfig, or the result of cls(response)
        :rtype: ~affinda_v2.models.ResumeSearchConfig
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResumeSearchConfig]

        _json = self._serialize.body(body, "ResumeSearchConfig")

        request = build_update_resume_search_config_request(
            content_type=content_type,
            json=_json,
            template_url=self.update_resume_search_config.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ResumeSearchConfig", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_resume_search_config.metadata = {"url": "/v2/resume_search/config"}  # type: ignore

    async def create_resume_search_embed_url(
        self,
        body: Optional[
            _models.Paths23Ubd8V2ResumeSearchEmbedPostRequestbodyContentApplicationJsonSchema
        ] = None,
        **kwargs: Any,
    ) -> _models.ResumeSearchEmbed:
        """Create a signed URL for the embeddable resume search tool.

        Create and return a signed URL of the resume search tool which then can be embedded on a web
        page. An optional parameter ``config_override`` can be passed to override the user-level
        configurations of the embeddable resume search tool.

        :param body:  Default value is None.
        :type body:
         ~affinda_v2.models.Paths23Ubd8V2ResumeSearchEmbedPostRequestbodyContentApplicationJsonSchema
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearchEmbed, or the result of cls(response)
        :rtype: ~affinda_v2.models.ResumeSearchEmbed
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResumeSearchEmbed]

        if body is not None:
            _json = self._serialize.body(
                body, "Paths23Ubd8V2ResumeSearchEmbedPostRequestbodyContentApplicationJsonSchema"
            )
        else:
            _json = None

        request = build_create_resume_search_embed_url_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_resume_search_embed_url.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ResumeSearchEmbed", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_resume_search_embed_url.metadata = {"url": "/v2/resume_search/embed"}  # type: ignore

    async def get_resume_search_suggestion_job_title(
        self, job_titles: List[str], **kwargs: Any
    ) -> List[str]:
        """Get job title suggestions based on provided job title(s).

        Provided one or more job titles, get related suggestions for your search.

        :param job_titles: Job title to query suggestions for.
        :type job_titles: list[str]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of str, or the result of cls(response)
        :rtype: list[str]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[str]]

        request = build_get_resume_search_suggestion_job_title_request(
            job_titles=job_titles,
            template_url=self.get_resume_search_suggestion_job_title.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[str]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resume_search_suggestion_job_title.metadata = {
        "url": "/v2/resume_search/suggestion_job_title"
    }  # type: ignore

    async def get_resume_search_suggestion_skill(
        self, skills: List[str], **kwargs: Any
    ) -> List[str]:
        """Get skill suggestions based on provided skill(s).

        Provided one or more skills, get related suggestions for your search.

        :param skills: Skill to query suggestions for.
        :type skills: list[str]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of str, or the result of cls(response)
        :rtype: list[str]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[str]]

        request = build_get_resume_search_suggestion_skill_request(
            skills=skills,
            template_url=self.get_resume_search_suggestion_skill.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[str]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resume_search_suggestion_skill.metadata = {"url": "/v2/resume_search/suggestion_skill"}  # type: ignore

    async def get_all_indexes(
        self,
        offset: Optional[int] = None,
        limit: Optional[int] = None,
        document_type: Optional[Union[str, "_models.Enum7"]] = None,
        **kwargs: Any,
    ) -> _models.Paths18Iqsr4V2IndexGetResponses200ContentApplicationJsonSchema:
        """Get list of all indexes.

        Returns all the indexes.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is None.
        :type limit: int
        :param document_type: Filter indices by a document type. Default value is None.
        :type document_type: str or ~affinda_v2.models.Enum7
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Paths18Iqsr4V2IndexGetResponses200ContentApplicationJsonSchema, or the result of
         cls(response)
        :rtype: ~affinda_v2.models.Paths18Iqsr4V2IndexGetResponses200ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Paths18Iqsr4V2IndexGetResponses200ContentApplicationJsonSchema]

        request = build_get_all_indexes_request(
            offset=offset,
            limit=limit,
            document_type=document_type,
            template_url=self.get_all_indexes.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "Paths18Iqsr4V2IndexGetResponses200ContentApplicationJsonSchema", pipeline_response
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_indexes.metadata = {"url": "/v2/index"}  # type: ignore

    async def create_index(self, body: _models.IndexCreate, **kwargs: Any) -> _models.Index:
        """Create a new index.

        Create an index for the search tool.

        :param body: Index to create.
        :type body: ~affinda_v2.models.IndexCreate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Index, or the result of cls(response)
        :rtype: ~affinda_v2.models.Index
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Index]

        _json = self._serialize.body(body, "IndexCreate")

        request = build_create_index_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_index.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Index", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_index.metadata = {"url": "/v2/index"}  # type: ignore

    async def update_index(
        self, name: str, body: _models.IndexUpdate, **kwargs: Any
    ) -> _models.Index:
        """Update an index.

        Updates the specified index.

        :param name: Index name.
        :type name: str
        :param body: Index data to update.
        :type body: ~affinda_v2.models.IndexUpdate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Index, or the result of cls(response)
        :rtype: ~affinda_v2.models.Index
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Index]

        _json = self._serialize.body(body, "IndexUpdate")

        request = build_update_index_request(
            name=name,
            content_type=content_type,
            json=_json,
            template_url=self.update_index.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Index", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_index.metadata = {"url": "/v2/index/{name}"}  # type: ignore

    async def delete_index(  # pylint: disable=inconsistent-return-statements
        self, name: str, **kwargs: Any
    ) -> None:
        """Delete an index.

        Deletes the specified index from the database.

        :param name: Index name.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_index_request(
            name=name,
            template_url=self.delete_index.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_index.metadata = {"url": "/v2/index/{name}"}  # type: ignore

    async def get_all_index_documents(
        self, name: str, **kwargs: Any
    ) -> _models.PathsAf7Nd4V2IndexNameDocumentsGetResponses200ContentApplicationJsonSchema:
        """Get indexed documents for a specific index.

        Returns all the indexed documents for that index.

        :param name: Index name.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PathsAf7Nd4V2IndexNameDocumentsGetResponses200ContentApplicationJsonSchema, or the
         result of cls(response)
        :rtype:
         ~affinda_v2.models.PathsAf7Nd4V2IndexNameDocumentsGetResponses200ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.PathsAf7Nd4V2IndexNameDocumentsGetResponses200ContentApplicationJsonSchema]

        request = build_get_all_index_documents_request(
            name=name,
            template_url=self.get_all_index_documents.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "PathsAf7Nd4V2IndexNameDocumentsGetResponses200ContentApplicationJsonSchema",
            pipeline_response,
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_index_documents.metadata = {"url": "/v2/index/{name}/documents"}  # type: ignore

    async def create_index_document(
        self,
        name: str,
        body: _models.PathsYg099PV2IndexNameDocumentsPostRequestbodyContentApplicationJsonSchema,
        **kwargs: Any,
    ) -> _models.Paths14R8PdgV2IndexNameDocumentsPostResponses201ContentApplicationJsonSchema:
        """Index a new document.

        Create an indexed document for the search tool.

        :param name: Index name.
        :type name: str
        :param body: Document to index.
        :type body:
         ~affinda_v2.models.PathsYg099PV2IndexNameDocumentsPostRequestbodyContentApplicationJsonSchema
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Paths14R8PdgV2IndexNameDocumentsPostResponses201ContentApplicationJsonSchema, or the
         result of cls(response)
        :rtype:
         ~affinda_v2.models.Paths14R8PdgV2IndexNameDocumentsPostResponses201ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.Paths14R8PdgV2IndexNameDocumentsPostResponses201ContentApplicationJsonSchema]

        _json = self._serialize.body(
            body, "PathsYg099PV2IndexNameDocumentsPostRequestbodyContentApplicationJsonSchema"
        )

        request = build_create_index_document_request(
            name=name,
            content_type=content_type,
            json=_json,
            template_url=self.create_index_document.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "Paths14R8PdgV2IndexNameDocumentsPostResponses201ContentApplicationJsonSchema",
            pipeline_response,
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_index_document.metadata = {"url": "/v2/index/{name}/documents"}  # type: ignore

    async def delete_index_document(  # pylint: disable=inconsistent-return-statements
        self, name: str, identifier: str, **kwargs: Any
    ) -> None:
        """Delete an indexed document.

        Delete the specified indexed document from the database.

        :param name: Index name.
        :type name: str
        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_index_document_request(
            name=name,
            identifier=identifier,
            template_url=self.delete_index_document.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_index_document.metadata = {"url": "/v2/index/{name}/documents/{identifier}"}  # type: ignore

    async def list_occupation_groups(self, **kwargs: Any) -> List[_models.OccupationGroup]:
        """List occupation groups.

        Returns the list of searchable occupation groups.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of OccupationGroup, or the result of cls(response)
        :rtype: list[~affinda_v2.models.OccupationGroup]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.OccupationGroup]]

        request = build_list_occupation_groups_request(
            template_url=self.list_occupation_groups.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[OccupationGroup]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_occupation_groups.metadata = {"url": "/v2/occupation_groups"}  # type: ignore

    async def get_all_resthook_subscriptions(
        self, offset: Optional[int] = None, limit: Optional[int] = None, **kwargs: Any
    ) -> _models.PathsMda0LlV2ResthookSubscriptionsGetResponses200ContentApplicationJsonSchema:
        """Get list of all resthook subscriptions.

        Returns your resthook subscriptions.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is None.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PathsMda0LlV2ResthookSubscriptionsGetResponses200ContentApplicationJsonSchema, or the
         result of cls(response)
        :rtype:
         ~affinda_v2.models.PathsMda0LlV2ResthookSubscriptionsGetResponses200ContentApplicationJsonSchema
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.PathsMda0LlV2ResthookSubscriptionsGetResponses200ContentApplicationJsonSchema]

        request = build_get_all_resthook_subscriptions_request(
            offset=offset,
            limit=limit,
            template_url=self.get_all_resthook_subscriptions.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize(
            "PathsMda0LlV2ResthookSubscriptionsGetResponses200ContentApplicationJsonSchema",
            pipeline_response,
        )

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_resthook_subscriptions.metadata = {"url": "/v2/resthook_subscriptions"}  # type: ignore

    async def create_resthook_subscription(
        self, body: _models.ResthookSubscriptionCreate, **kwargs: Any
    ) -> _models.ResthookSubscription:
        """Create a resthook subscription.

        After a subscription is successfully created, we'll send a POST request to your target URL with
        a ``X-Hook-Secret`` header. :code:`<br />`
        You need to response to this request with a 200 status code to confirm your subscribe
        intention. :code:`<br />`
        Then, you need to use the ``X-Hook-Secret`` to activate the subscription using the
        `/resthook_subscriptions/activate <#post-/v3/resthook_subscriptions/activate>`_ endpoint.
        :code:`<br />`
        For more information and detailed instructions, `see our webhooks documentation here.
        <https://docs.affinda.com/docs/webhooks>`_.

        :param body:
        :type body: ~affinda_v2.models.ResthookSubscriptionCreate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResthookSubscription, or the result of cls(response)
        :rtype: ~affinda_v2.models.ResthookSubscription
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResthookSubscription]

        _json = self._serialize.body(body, "ResthookSubscriptionCreate")

        request = build_create_resthook_subscription_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_resthook_subscription.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ResthookSubscription", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_resthook_subscription.metadata = {"url": "/v2/resthook_subscriptions"}  # type: ignore

    async def get_resthook_subscription(
        self, id: int, **kwargs: Any
    ) -> _models.ResthookSubscription:
        """Get specific resthook subscription.

        Return a specific resthook subscription.

        :param id: Resthook subscription's ID.
        :type id: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResthookSubscription, or the result of cls(response)
        :rtype: ~affinda_v2.models.ResthookSubscription
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResthookSubscription]

        request = build_get_resthook_subscription_request(
            id=id,
            template_url=self.get_resthook_subscription.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ResthookSubscription", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resthook_subscription.metadata = {"url": "/v2/resthook_subscriptions/{id}"}  # type: ignore

    async def update_resthook_subscription(
        self, id: int, body: _models.ResthookSubscriptionUpdate, **kwargs: Any
    ) -> _models.ResthookSubscription:
        """Update a resthook subscription.

        Update data of a resthook subscription.

        :param id: ResthookSubscription's ID.
        :type id: int
        :param body: ResthookSubscription data to update.
        :type body: ~affinda_v2.models.ResthookSubscriptionUpdate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResthookSubscription, or the result of cls(response)
        :rtype: ~affinda_v2.models.ResthookSubscription
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResthookSubscription]

        _json = self._serialize.body(body, "ResthookSubscriptionUpdate")

        request = build_update_resthook_subscription_request(
            id=id,
            content_type=content_type,
            json=_json,
            template_url=self.update_resthook_subscription.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ResthookSubscription", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_resthook_subscription.metadata = {"url": "/v2/resthook_subscriptions/{id}"}  # type: ignore

    async def delete_resthook_subscription(  # pylint: disable=inconsistent-return-statements
        self, id: int, **kwargs: Any
    ) -> None:
        """Delete a resthook subscription.

        Deletes the specified resthook subscription from the database.

        :param id: ResthookSubscription's ID.
        :type id: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_resthook_subscription_request(
            id=id,
            template_url=self.delete_resthook_subscription.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_resthook_subscription.metadata = {"url": "/v2/resthook_subscriptions/{id}"}  # type: ignore

    async def activate_resthook_subscription(
        self, x_hook_secret: str, **kwargs: Any
    ) -> _models.ResthookSubscription:
        """Activate a resthook subscription.

        After creating a subscription, we'll send a POST request to your target URL with a
        ``X-Hook-Secret`` header.
        You should response to this with a 200 status code, and use the value of the ``X-Hook-Secret``
        header that you received to activate the subscription using this endpoint.

        :param x_hook_secret: The secret received when creating a subscription.
        :type x_hook_secret: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResthookSubscription, or the result of cls(response)
        :rtype: ~affinda_v2.models.ResthookSubscription
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.RequestError, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResthookSubscription]

        request = build_activate_resthook_subscription_request(
            x_hook_secret=x_hook_secret,
            template_url=self.activate_resthook_subscription.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "region": self._serialize.url("self._config.region", self._config.region, "str"),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ResthookSubscription", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    activate_resthook_subscription.metadata = {"url": "/v2/resthook_subscriptions/activate"}  # type: ignore
