#!/usr/bin/env python
# -*- coding: utf-8 -*-

from setuptools import setup

with open('README.rst') as readme_file:
    readme = readme_file.read()

with open('HISTORY.rst') as history_file:
    history = history_file.read()

requirements = [
    'requests',
    'arrow'
]

test_requirements = [
    'pytest'
]

setup(
    name='permutive',
    version='0.4.0',
    description="Python wrapper for Permutive API",
    long_description=readme + '\n\n' + history,
    author="Dinesh Vitharanage",
    author_email='dvitharanage@gmail.com',
    url='https://github.com/tailsdotcom/permutive-sdk',
    packages=[
        'permutive',
    ],
    package_dir={'permutive':
                 'permutive'},
    include_package_data=True,
    install_requires=requirements,
    license="MIT license",
    zip_safe=False,
    keywords='permutive',
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Natural Language :: English',
        "Programming Language :: Python :: 2",
        'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.3',
        'Programming Language :: Python :: 3.4',
        'Programming Language :: Python :: 3.5',
    ],
    test_suite='tests',
    tests_require=test_requirements
)
