"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceAccount = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const constructs_1 = require("constructs");
const base = require("./base");
const k8s = require("./imports/k8s");
const utils_1 = require("./utils");
class ImportedServiceAccount extends constructs_1.Construct {
    constructor(scope, id, name, options = {}) {
        super(scope, id);
        this.resourceType = 'serviceaccounts';
        this._name = name;
        this._namespaceName = options.namespaceName ?? 'default';
    }
    toSubjectConfiguration() {
        return {
            kind: this.kind,
            name: this.name,
            apiGroup: this.apiGroup,
            namespace: this._namespaceName,
        };
    }
    get name() {
        return this._name;
    }
    get apiVersion() {
        return k8s.KubeServiceAccount.GVK.apiVersion;
    }
    get apiGroup() {
        return '';
    }
    get kind() {
        return k8s.KubeServiceAccount.GVK.kind;
    }
    get resourceName() {
        return this.name;
    }
}
/**
 * A service account provides an identity for processes that run in a Pod.
 *
 * When you (a human) access the cluster (for example, using kubectl), you are
 * authenticated by the apiserver as a particular User Account (currently this
 * is usually admin, unless your cluster administrator has customized your
 * cluster). Processes in containers inside pods can also contact the apiserver.
 * When they do, they are authenticated as a particular Service Account (for
 * example, default).
 *
 * @see https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account
 */
class ServiceAccount extends base.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id);
        this.resourceType = 'serviceaccounts';
        this._secrets = props.secrets ?? [];
        this.automountToken = props.automountToken ?? false;
        this.apiObject = new k8s.KubeServiceAccount(this, 'Resource', {
            metadata: props.metadata,
            secrets: cdk8s_1.Lazy.any({ produce: () => utils_1.undefinedIfEmpty(this._secrets.map(s => ({ name: s.name }))) }),
            automountServiceAccountToken: this.automountToken,
        });
    }
    /**
     * Imports a service account from the cluster as a reference.
     * @param name The name of the service account resource.
     * @param options additional options.
     */
    static fromServiceAccountName(scope, id, name, options = {}) {
        return new ImportedServiceAccount(scope, id, name, options);
    }
    /**
     * Allow a secret to be accessed by pods using this service account.
     * @param secr The secret
     */
    addSecret(secr) {
        this._secrets.push(secr);
    }
    /**
     * List of secrets allowed to be used by pods running using this service
     * account.
     *
     * Returns a copy. To add a secret, use `addSecret()`.
     */
    get secrets() {
        return [...this._secrets];
    }
    /**
     * @see ISubect.toSubjectConfiguration()
     */
    toSubjectConfiguration() {
        return {
            kind: this.kind,
            name: this.name,
            apiGroup: this.apiGroup,
            namespace: this.metadata.namespace,
        };
    }
}
exports.ServiceAccount = ServiceAccount;
_a = JSII_RTTI_SYMBOL_1;
ServiceAccount[_a] = { fqn: "cdk8s-plus-23.ServiceAccount", version: "2.4.27" };
//# sourceMappingURL=data:application/json;base64,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