# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRemediationRunsResult',
    'AwaitableGetRemediationRunsResult',
    'get_remediation_runs',
    'get_remediation_runs_output',
]

@pulumi.output_type
class GetRemediationRunsResult:
    """
    A collection of values returned by getRemediationRuns.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, remediation_recipe_id=None, remediation_run_collections=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if remediation_recipe_id and not isinstance(remediation_recipe_id, str):
            raise TypeError("Expected argument 'remediation_recipe_id' to be a str")
        pulumi.set(__self__, "remediation_recipe_id", remediation_recipe_id)
        if remediation_run_collections and not isinstance(remediation_run_collections, list):
            raise TypeError("Expected argument 'remediation_run_collections' to be a list")
        pulumi.set(__self__, "remediation_run_collections", remediation_run_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The compartment Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the remediation run.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The name of the remediation run.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetRemediationRunsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the remediation run.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="remediationRecipeId")
    def remediation_recipe_id(self) -> Optional[str]:
        """
        The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Remediation Recipe.
        """
        return pulumi.get(self, "remediation_recipe_id")

    @property
    @pulumi.getter(name="remediationRunCollections")
    def remediation_run_collections(self) -> Sequence['outputs.GetRemediationRunsRemediationRunCollectionResult']:
        """
        The list of remediation_run_collection.
        """
        return pulumi.get(self, "remediation_run_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current lifecycle state of the remediation run.
        """
        return pulumi.get(self, "state")


class AwaitableGetRemediationRunsResult(GetRemediationRunsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRemediationRunsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            remediation_recipe_id=self.remediation_recipe_id,
            remediation_run_collections=self.remediation_run_collections,
            state=self.state)


def get_remediation_runs(compartment_id: Optional[str] = None,
                         display_name: Optional[str] = None,
                         filters: Optional[Sequence[pulumi.InputType['GetRemediationRunsFilterArgs']]] = None,
                         id: Optional[str] = None,
                         remediation_recipe_id: Optional[str] = None,
                         state: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRemediationRunsResult:
    """
    This data source provides the list of Remediation Runs in Oracle Cloud Infrastructure Adm service.

    Returns a list of remediation runs contained by a compartment.
    The query parameter `compartmentId` is required unless the query parameter `id` is specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_remediation_runs = oci.Adm.get_remediation_runs(compartment_id=compartment_id,
        display_name=remediation_run_display_name,
        id=remediation_run_id,
        remediation_recipe_id=test_remediation_recipe["id"],
        state=remediation_run_state)
    ```


    :param str compartment_id: A filter to return only resources that belong to the specified compartment identifier. Required only if the id query param is not specified.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: A filter to return only resources that match the specified identifier. Required only if the compartmentId query parameter is not specified.
    :param str remediation_recipe_id: A filter to return only resources that match the specified Remediation Recipe identifier.
    :param str state: A filter to return only Remediation Runs that match the specified lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['remediationRecipeId'] = remediation_recipe_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Adm/getRemediationRuns:getRemediationRuns', __args__, opts=opts, typ=GetRemediationRunsResult).value

    return AwaitableGetRemediationRunsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        remediation_recipe_id=pulumi.get(__ret__, 'remediation_recipe_id'),
        remediation_run_collections=pulumi.get(__ret__, 'remediation_run_collections'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_remediation_runs)
def get_remediation_runs_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetRemediationRunsFilterArgs']]]]] = None,
                                id: Optional[pulumi.Input[Optional[str]]] = None,
                                remediation_recipe_id: Optional[pulumi.Input[Optional[str]]] = None,
                                state: Optional[pulumi.Input[Optional[str]]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRemediationRunsResult]:
    """
    This data source provides the list of Remediation Runs in Oracle Cloud Infrastructure Adm service.

    Returns a list of remediation runs contained by a compartment.
    The query parameter `compartmentId` is required unless the query parameter `id` is specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_remediation_runs = oci.Adm.get_remediation_runs(compartment_id=compartment_id,
        display_name=remediation_run_display_name,
        id=remediation_run_id,
        remediation_recipe_id=test_remediation_recipe["id"],
        state=remediation_run_state)
    ```


    :param str compartment_id: A filter to return only resources that belong to the specified compartment identifier. Required only if the id query param is not specified.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: A filter to return only resources that match the specified identifier. Required only if the compartmentId query parameter is not specified.
    :param str remediation_recipe_id: A filter to return only resources that match the specified Remediation Recipe identifier.
    :param str state: A filter to return only Remediation Runs that match the specified lifecycleState.
    """
    ...
