# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAiPrivateEndpointsResult',
    'AwaitableGetAiPrivateEndpointsResult',
    'get_ai_private_endpoints',
    'get_ai_private_endpoints_output',
]

@pulumi.output_type
class GetAiPrivateEndpointsResult:
    """
    A collection of values returned by getAiPrivateEndpoints.
    """
    def __init__(__self__, ai_private_endpoint_collections=None, compartment_id=None, display_name=None, filters=None, id=None, state=None):
        if ai_private_endpoint_collections and not isinstance(ai_private_endpoint_collections, list):
            raise TypeError("Expected argument 'ai_private_endpoint_collections' to be a list")
        pulumi.set(__self__, "ai_private_endpoint_collections", ai_private_endpoint_collections)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="aiPrivateEndpointCollections")
    def ai_private_endpoint_collections(self) -> Sequence['outputs.GetAiPrivateEndpointsAiPrivateEndpointCollectionResult']:
        """
        The list of ai_private_endpoint_collection.
        """
        return pulumi.get(self, "ai_private_endpoint_collections")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment Identifier.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Private Reverse Connection Endpoint display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAiPrivateEndpointsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier that is immutable.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the private endpoint resource.
        """
        return pulumi.get(self, "state")


class AwaitableGetAiPrivateEndpointsResult(GetAiPrivateEndpointsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAiPrivateEndpointsResult(
            ai_private_endpoint_collections=self.ai_private_endpoint_collections,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_ai_private_endpoints(compartment_id: Optional[str] = None,
                             display_name: Optional[str] = None,
                             filters: Optional[Sequence[pulumi.InputType['GetAiPrivateEndpointsFilterArgs']]] = None,
                             id: Optional[str] = None,
                             state: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAiPrivateEndpointsResult:
    """
    This data source provides the list of Ai Private Endpoints in Oracle Cloud Infrastructure Ai Anomaly Detection service.

    Returns a list of all the AI private endpoints in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ai_private_endpoints = oci.AiAnomalyDetection.get_ai_private_endpoints(compartment_id=compartment_id,
        display_name=ai_private_endpoint_display_name,
        id=ai_private_endpoint_id,
        state=ai_private_endpoint_state)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: unique AiPrivateEndpoint identifier
    :param str state: <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:AiAnomalyDetection/getAiPrivateEndpoints:getAiPrivateEndpoints', __args__, opts=opts, typ=GetAiPrivateEndpointsResult).value

    return AwaitableGetAiPrivateEndpointsResult(
        ai_private_endpoint_collections=pulumi.get(__ret__, 'ai_private_endpoint_collections'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_ai_private_endpoints)
def get_ai_private_endpoints_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                    display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                    filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetAiPrivateEndpointsFilterArgs']]]]] = None,
                                    id: Optional[pulumi.Input[Optional[str]]] = None,
                                    state: Optional[pulumi.Input[Optional[str]]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAiPrivateEndpointsResult]:
    """
    This data source provides the list of Ai Private Endpoints in Oracle Cloud Infrastructure Ai Anomaly Detection service.

    Returns a list of all the AI private endpoints in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ai_private_endpoints = oci.AiAnomalyDetection.get_ai_private_endpoints(compartment_id=compartment_id,
        display_name=ai_private_endpoint_display_name,
        id=ai_private_endpoint_id,
        state=ai_private_endpoint_state)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: unique AiPrivateEndpoint identifier
    :param str state: <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
    """
    ...
