# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAnnouncementSubscriptionsResult',
    'AwaitableGetAnnouncementSubscriptionsResult',
    'get_announcement_subscriptions',
    'get_announcement_subscriptions_output',
]

@pulumi.output_type
class GetAnnouncementSubscriptionsResult:
    """
    A collection of values returned by getAnnouncementSubscriptions.
    """
    def __init__(__self__, announcement_subscription_collections=None, compartment_id=None, display_name=None, filters=None, id=None, state=None):
        if announcement_subscription_collections and not isinstance(announcement_subscription_collections, list):
            raise TypeError("Expected argument 'announcement_subscription_collections' to be a list")
        pulumi.set(__self__, "announcement_subscription_collections", announcement_subscription_collections)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="announcementSubscriptionCollections")
    def announcement_subscription_collections(self) -> Sequence['outputs.GetAnnouncementSubscriptionsAnnouncementSubscriptionCollectionResult']:
        """
        The list of announcement_subscription_collection.
        """
        return pulumi.get(self, "announcement_subscription_collections")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the announcement subscription.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name for the announcement subscription. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAnnouncementSubscriptionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the announcement subscription.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current lifecycle state of the announcement subscription.
        """
        return pulumi.get(self, "state")


class AwaitableGetAnnouncementSubscriptionsResult(GetAnnouncementSubscriptionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAnnouncementSubscriptionsResult(
            announcement_subscription_collections=self.announcement_subscription_collections,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_announcement_subscriptions(compartment_id: Optional[str] = None,
                                   display_name: Optional[str] = None,
                                   filters: Optional[Sequence[pulumi.InputType['GetAnnouncementSubscriptionsFilterArgs']]] = None,
                                   id: Optional[str] = None,
                                   state: Optional[str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAnnouncementSubscriptionsResult:
    """
    This data source provides the list of Announcement Subscriptions in Oracle Cloud Infrastructure Announcements Service service.

    Gets a list of all announcement subscriptions in the specified compartment.

    This call is subject to an Announcements limit that applies to the total number of requests across all read or write operations. Announcements might throttle this call to reject an otherwise valid request when the total rate of operations exceeds 20 requests per second for a given user. The service might also throttle this call to reject an otherwise valid request when the total rate of operations exceeds 100 requests per second for a given tenancy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_announcement_subscriptions = oci.AnnouncementsService.get_announcement_subscriptions(compartment_id=compartment_id,
        display_name=announcement_subscription_display_name,
        id=announcement_subscription_id,
        state=announcement_subscription_state)
    ```


    :param str compartment_id: The OCID of the compartment.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: The OCID of the announcement subscription.
    :param str state: A filter to return only announcement subscriptions that match the given lifecycle state.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:AnnouncementsService/getAnnouncementSubscriptions:getAnnouncementSubscriptions', __args__, opts=opts, typ=GetAnnouncementSubscriptionsResult).value

    return AwaitableGetAnnouncementSubscriptionsResult(
        announcement_subscription_collections=pulumi.get(__ret__, 'announcement_subscription_collections'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_announcement_subscriptions)
def get_announcement_subscriptions_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                          display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                          filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetAnnouncementSubscriptionsFilterArgs']]]]] = None,
                                          id: Optional[pulumi.Input[Optional[str]]] = None,
                                          state: Optional[pulumi.Input[Optional[str]]] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAnnouncementSubscriptionsResult]:
    """
    This data source provides the list of Announcement Subscriptions in Oracle Cloud Infrastructure Announcements Service service.

    Gets a list of all announcement subscriptions in the specified compartment.

    This call is subject to an Announcements limit that applies to the total number of requests across all read or write operations. Announcements might throttle this call to reject an otherwise valid request when the total rate of operations exceeds 20 requests per second for a given user. The service might also throttle this call to reject an otherwise valid request when the total rate of operations exceeds 100 requests per second for a given tenancy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_announcement_subscriptions = oci.AnnouncementsService.get_announcement_subscriptions(compartment_id=compartment_id,
        display_name=announcement_subscription_display_name,
        id=announcement_subscription_id,
        state=announcement_subscription_state)
    ```


    :param str compartment_id: The OCID of the compartment.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: The OCID of the announcement subscription.
    :param str state: A filter to return only announcement subscriptions that match the given lifecycle state.
    """
    ...
