# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AssetSourceArgs', 'AssetSource']

@pulumi.input_type
class AssetSourceArgs:
    def __init__(__self__, *,
                 assets_compartment_id: pulumi.Input[str],
                 compartment_id: pulumi.Input[str],
                 discovery_credentials: pulumi.Input['AssetSourceDiscoveryCredentialsArgs'],
                 environment_id: pulumi.Input[str],
                 inventory_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 vcenter_endpoint: pulumi.Input[str],
                 are_historical_metrics_collected: Optional[pulumi.Input[bool]] = None,
                 are_realtime_metrics_collected: Optional[pulumi.Input[bool]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 discovery_schedule_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 replication_credentials: Optional[pulumi.Input['AssetSourceReplicationCredentialsArgs']] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a AssetSource resource.
        :param pulumi.Input[str] assets_compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that is going to be used to create assets.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment for the resource.
        :param pulumi.Input['AssetSourceDiscoveryCredentialsArgs'] discovery_credentials: (Updatable) Credentials for an asset source.
        :param pulumi.Input[str] environment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the environment.
        :param pulumi.Input[str] inventory_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the inventory that will contain created assets.
        :param pulumi.Input[str] type: (Updatable) Asset source type.
        :param pulumi.Input[str] vcenter_endpoint: (Updatable) Endpoint for VMware asset discovery and replication in the form of ```https://<host>:<port>/sdk```
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[bool] are_historical_metrics_collected: (Updatable) Flag indicating whether historical metrics are collected for assets, originating from this asset source.
        :param pulumi.Input[bool] are_realtime_metrics_collected: (Updatable) Flag indicating whether real-time metrics are collected for assets, originating from this asset source.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] discovery_schedule_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the discovery schedule that is going to be attached to the created asset.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name for the asset source. Does not have to be unique, and it's mutable. Avoid entering confidential information. The name is generated by the service if it is not explicitly provided.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input['AssetSourceReplicationCredentialsArgs'] replication_credentials: (Updatable) Credentials for an asset source.
        :param pulumi.Input[Mapping[str, Any]] system_tags: (Updatable) The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        pulumi.set(__self__, "assets_compartment_id", assets_compartment_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "discovery_credentials", discovery_credentials)
        pulumi.set(__self__, "environment_id", environment_id)
        pulumi.set(__self__, "inventory_id", inventory_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vcenter_endpoint", vcenter_endpoint)
        if are_historical_metrics_collected is not None:
            pulumi.set(__self__, "are_historical_metrics_collected", are_historical_metrics_collected)
        if are_realtime_metrics_collected is not None:
            pulumi.set(__self__, "are_realtime_metrics_collected", are_realtime_metrics_collected)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if discovery_schedule_id is not None:
            pulumi.set(__self__, "discovery_schedule_id", discovery_schedule_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if replication_credentials is not None:
            pulumi.set(__self__, "replication_credentials", replication_credentials)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)

    @property
    @pulumi.getter(name="assetsCompartmentId")
    def assets_compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that is going to be used to create assets.
        """
        return pulumi.get(self, "assets_compartment_id")

    @assets_compartment_id.setter
    def assets_compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "assets_compartment_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment for the resource.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="discoveryCredentials")
    def discovery_credentials(self) -> pulumi.Input['AssetSourceDiscoveryCredentialsArgs']:
        """
        (Updatable) Credentials for an asset source.
        """
        return pulumi.get(self, "discovery_credentials")

    @discovery_credentials.setter
    def discovery_credentials(self, value: pulumi.Input['AssetSourceDiscoveryCredentialsArgs']):
        pulumi.set(self, "discovery_credentials", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the environment.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="inventoryId")
    def inventory_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the inventory that will contain created assets.
        """
        return pulumi.get(self, "inventory_id")

    @inventory_id.setter
    def inventory_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "inventory_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        (Updatable) Asset source type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vcenterEndpoint")
    def vcenter_endpoint(self) -> pulumi.Input[str]:
        """
        (Updatable) Endpoint for VMware asset discovery and replication in the form of ```https://<host>:<port>/sdk```


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vcenter_endpoint")

    @vcenter_endpoint.setter
    def vcenter_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "vcenter_endpoint", value)

    @property
    @pulumi.getter(name="areHistoricalMetricsCollected")
    def are_historical_metrics_collected(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Flag indicating whether historical metrics are collected for assets, originating from this asset source.
        """
        return pulumi.get(self, "are_historical_metrics_collected")

    @are_historical_metrics_collected.setter
    def are_historical_metrics_collected(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "are_historical_metrics_collected", value)

    @property
    @pulumi.getter(name="areRealtimeMetricsCollected")
    def are_realtime_metrics_collected(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Flag indicating whether real-time metrics are collected for assets, originating from this asset source.
        """
        return pulumi.get(self, "are_realtime_metrics_collected")

    @are_realtime_metrics_collected.setter
    def are_realtime_metrics_collected(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "are_realtime_metrics_collected", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="discoveryScheduleId")
    def discovery_schedule_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the discovery schedule that is going to be attached to the created asset.
        """
        return pulumi.get(self, "discovery_schedule_id")

    @discovery_schedule_id.setter
    def discovery_schedule_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "discovery_schedule_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name for the asset source. Does not have to be unique, and it's mutable. Avoid entering confidential information. The name is generated by the service if it is not explicitly provided.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="replicationCredentials")
    def replication_credentials(self) -> Optional[pulumi.Input['AssetSourceReplicationCredentialsArgs']]:
        """
        (Updatable) Credentials for an asset source.
        """
        return pulumi.get(self, "replication_credentials")

    @replication_credentials.setter
    def replication_credentials(self, value: Optional[pulumi.Input['AssetSourceReplicationCredentialsArgs']]):
        pulumi.set(self, "replication_credentials", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)


@pulumi.input_type
class _AssetSourceState:
    def __init__(__self__, *,
                 are_historical_metrics_collected: Optional[pulumi.Input[bool]] = None,
                 are_realtime_metrics_collected: Optional[pulumi.Input[bool]] = None,
                 assets_compartment_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 discovery_credentials: Optional[pulumi.Input['AssetSourceDiscoveryCredentialsArgs']] = None,
                 discovery_schedule_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 inventory_id: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 replication_credentials: Optional[pulumi.Input['AssetSourceReplicationCredentialsArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vcenter_endpoint: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AssetSource resources.
        :param pulumi.Input[bool] are_historical_metrics_collected: (Updatable) Flag indicating whether historical metrics are collected for assets, originating from this asset source.
        :param pulumi.Input[bool] are_realtime_metrics_collected: (Updatable) Flag indicating whether real-time metrics are collected for assets, originating from this asset source.
        :param pulumi.Input[str] assets_compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that is going to be used to create assets.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment for the resource.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input['AssetSourceDiscoveryCredentialsArgs'] discovery_credentials: (Updatable) Credentials for an asset source.
        :param pulumi.Input[str] discovery_schedule_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the discovery schedule that is going to be attached to the created asset.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name for the asset source. Does not have to be unique, and it's mutable. Avoid entering confidential information. The name is generated by the service if it is not explicitly provided.
        :param pulumi.Input[str] environment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the environment.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] inventory_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the inventory that will contain created assets.
        :param pulumi.Input[str] lifecycle_details: The detailed state of the asset source.
        :param pulumi.Input['AssetSourceReplicationCredentialsArgs'] replication_credentials: (Updatable) Credentials for an asset source.
        :param pulumi.Input[str] state: The current state of the asset source.
        :param pulumi.Input[Mapping[str, Any]] system_tags: (Updatable) The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param pulumi.Input[str] time_created: The time when the asset source was created in the RFC3339 format.
        :param pulumi.Input[str] time_updated: The point in time that the asset source was last updated in the RFC3339 format.
        :param pulumi.Input[str] type: (Updatable) Asset source type.
        :param pulumi.Input[str] vcenter_endpoint: (Updatable) Endpoint for VMware asset discovery and replication in the form of ```https://<host>:<port>/sdk```
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if are_historical_metrics_collected is not None:
            pulumi.set(__self__, "are_historical_metrics_collected", are_historical_metrics_collected)
        if are_realtime_metrics_collected is not None:
            pulumi.set(__self__, "are_realtime_metrics_collected", are_realtime_metrics_collected)
        if assets_compartment_id is not None:
            pulumi.set(__self__, "assets_compartment_id", assets_compartment_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if discovery_credentials is not None:
            pulumi.set(__self__, "discovery_credentials", discovery_credentials)
        if discovery_schedule_id is not None:
            pulumi.set(__self__, "discovery_schedule_id", discovery_schedule_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if inventory_id is not None:
            pulumi.set(__self__, "inventory_id", inventory_id)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if replication_credentials is not None:
            pulumi.set(__self__, "replication_credentials", replication_credentials)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vcenter_endpoint is not None:
            pulumi.set(__self__, "vcenter_endpoint", vcenter_endpoint)

    @property
    @pulumi.getter(name="areHistoricalMetricsCollected")
    def are_historical_metrics_collected(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Flag indicating whether historical metrics are collected for assets, originating from this asset source.
        """
        return pulumi.get(self, "are_historical_metrics_collected")

    @are_historical_metrics_collected.setter
    def are_historical_metrics_collected(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "are_historical_metrics_collected", value)

    @property
    @pulumi.getter(name="areRealtimeMetricsCollected")
    def are_realtime_metrics_collected(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Flag indicating whether real-time metrics are collected for assets, originating from this asset source.
        """
        return pulumi.get(self, "are_realtime_metrics_collected")

    @are_realtime_metrics_collected.setter
    def are_realtime_metrics_collected(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "are_realtime_metrics_collected", value)

    @property
    @pulumi.getter(name="assetsCompartmentId")
    def assets_compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that is going to be used to create assets.
        """
        return pulumi.get(self, "assets_compartment_id")

    @assets_compartment_id.setter
    def assets_compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "assets_compartment_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment for the resource.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="discoveryCredentials")
    def discovery_credentials(self) -> Optional[pulumi.Input['AssetSourceDiscoveryCredentialsArgs']]:
        """
        (Updatable) Credentials for an asset source.
        """
        return pulumi.get(self, "discovery_credentials")

    @discovery_credentials.setter
    def discovery_credentials(self, value: Optional[pulumi.Input['AssetSourceDiscoveryCredentialsArgs']]):
        pulumi.set(self, "discovery_credentials", value)

    @property
    @pulumi.getter(name="discoveryScheduleId")
    def discovery_schedule_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the discovery schedule that is going to be attached to the created asset.
        """
        return pulumi.get(self, "discovery_schedule_id")

    @discovery_schedule_id.setter
    def discovery_schedule_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "discovery_schedule_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name for the asset source. Does not have to be unique, and it's mutable. Avoid entering confidential information. The name is generated by the service if it is not explicitly provided.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the environment.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="inventoryId")
    def inventory_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the inventory that will contain created assets.
        """
        return pulumi.get(self, "inventory_id")

    @inventory_id.setter
    def inventory_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inventory_id", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        The detailed state of the asset source.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="replicationCredentials")
    def replication_credentials(self) -> Optional[pulumi.Input['AssetSourceReplicationCredentialsArgs']]:
        """
        (Updatable) Credentials for an asset source.
        """
        return pulumi.get(self, "replication_credentials")

    @replication_credentials.setter
    def replication_credentials(self, value: Optional[pulumi.Input['AssetSourceReplicationCredentialsArgs']]):
        pulumi.set(self, "replication_credentials", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the asset source.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the asset source was created in the RFC3339 format.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The point in time that the asset source was last updated in the RFC3339 format.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Asset source type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vcenterEndpoint")
    def vcenter_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Endpoint for VMware asset discovery and replication in the form of ```https://<host>:<port>/sdk```


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vcenter_endpoint")

    @vcenter_endpoint.setter
    def vcenter_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vcenter_endpoint", value)


class AssetSource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 are_historical_metrics_collected: Optional[pulumi.Input[bool]] = None,
                 are_realtime_metrics_collected: Optional[pulumi.Input[bool]] = None,
                 assets_compartment_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 discovery_credentials: Optional[pulumi.Input[pulumi.InputType['AssetSourceDiscoveryCredentialsArgs']]] = None,
                 discovery_schedule_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 inventory_id: Optional[pulumi.Input[str]] = None,
                 replication_credentials: Optional[pulumi.Input[pulumi.InputType['AssetSourceReplicationCredentialsArgs']]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vcenter_endpoint: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Asset Source resource in Oracle Cloud Infrastructure Cloud Bridge service.

        Creates an asset source.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_asset_source = oci.cloud_bridge.AssetSource("test_asset_source",
            assets_compartment_id=test_compartment["id"],
            compartment_id=compartment_id,
            discovery_credentials=oci.cloud_bridge.AssetSourceDiscoveryCredentialsArgs(
                secret_id=test_secret["id"],
                type=asset_source_discovery_credentials_type,
            ),
            environment_id=test_environment["id"],
            inventory_id=test_inventory["id"],
            type=asset_source_type,
            vcenter_endpoint=asset_source_vcenter_endpoint,
            are_historical_metrics_collected=asset_source_are_historical_metrics_collected,
            are_realtime_metrics_collected=asset_source_are_realtime_metrics_collected,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            discovery_schedule_id=test_discovery_schedule["id"],
            display_name=asset_source_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            replication_credentials=oci.cloud_bridge.AssetSourceReplicationCredentialsArgs(
                secret_id=test_secret["id"],
                type=asset_source_replication_credentials_type,
            ),
            system_tags=asset_source_system_tags)
        ```

        ## Import

        AssetSources can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CloudBridge/assetSource:AssetSource test_asset_source "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] are_historical_metrics_collected: (Updatable) Flag indicating whether historical metrics are collected for assets, originating from this asset source.
        :param pulumi.Input[bool] are_realtime_metrics_collected: (Updatable) Flag indicating whether real-time metrics are collected for assets, originating from this asset source.
        :param pulumi.Input[str] assets_compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that is going to be used to create assets.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment for the resource.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[pulumi.InputType['AssetSourceDiscoveryCredentialsArgs']] discovery_credentials: (Updatable) Credentials for an asset source.
        :param pulumi.Input[str] discovery_schedule_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the discovery schedule that is going to be attached to the created asset.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name for the asset source. Does not have to be unique, and it's mutable. Avoid entering confidential information. The name is generated by the service if it is not explicitly provided.
        :param pulumi.Input[str] environment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the environment.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] inventory_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the inventory that will contain created assets.
        :param pulumi.Input[pulumi.InputType['AssetSourceReplicationCredentialsArgs']] replication_credentials: (Updatable) Credentials for an asset source.
        :param pulumi.Input[Mapping[str, Any]] system_tags: (Updatable) The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param pulumi.Input[str] type: (Updatable) Asset source type.
        :param pulumi.Input[str] vcenter_endpoint: (Updatable) Endpoint for VMware asset discovery and replication in the form of ```https://<host>:<port>/sdk```
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AssetSourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Asset Source resource in Oracle Cloud Infrastructure Cloud Bridge service.

        Creates an asset source.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_asset_source = oci.cloud_bridge.AssetSource("test_asset_source",
            assets_compartment_id=test_compartment["id"],
            compartment_id=compartment_id,
            discovery_credentials=oci.cloud_bridge.AssetSourceDiscoveryCredentialsArgs(
                secret_id=test_secret["id"],
                type=asset_source_discovery_credentials_type,
            ),
            environment_id=test_environment["id"],
            inventory_id=test_inventory["id"],
            type=asset_source_type,
            vcenter_endpoint=asset_source_vcenter_endpoint,
            are_historical_metrics_collected=asset_source_are_historical_metrics_collected,
            are_realtime_metrics_collected=asset_source_are_realtime_metrics_collected,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            discovery_schedule_id=test_discovery_schedule["id"],
            display_name=asset_source_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            replication_credentials=oci.cloud_bridge.AssetSourceReplicationCredentialsArgs(
                secret_id=test_secret["id"],
                type=asset_source_replication_credentials_type,
            ),
            system_tags=asset_source_system_tags)
        ```

        ## Import

        AssetSources can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CloudBridge/assetSource:AssetSource test_asset_source "id"
        ```

        :param str resource_name: The name of the resource.
        :param AssetSourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AssetSourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 are_historical_metrics_collected: Optional[pulumi.Input[bool]] = None,
                 are_realtime_metrics_collected: Optional[pulumi.Input[bool]] = None,
                 assets_compartment_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 discovery_credentials: Optional[pulumi.Input[pulumi.InputType['AssetSourceDiscoveryCredentialsArgs']]] = None,
                 discovery_schedule_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 inventory_id: Optional[pulumi.Input[str]] = None,
                 replication_credentials: Optional[pulumi.Input[pulumi.InputType['AssetSourceReplicationCredentialsArgs']]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vcenter_endpoint: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AssetSourceArgs.__new__(AssetSourceArgs)

            __props__.__dict__["are_historical_metrics_collected"] = are_historical_metrics_collected
            __props__.__dict__["are_realtime_metrics_collected"] = are_realtime_metrics_collected
            if assets_compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'assets_compartment_id'")
            __props__.__dict__["assets_compartment_id"] = assets_compartment_id
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if discovery_credentials is None and not opts.urn:
                raise TypeError("Missing required property 'discovery_credentials'")
            __props__.__dict__["discovery_credentials"] = discovery_credentials
            __props__.__dict__["discovery_schedule_id"] = discovery_schedule_id
            __props__.__dict__["display_name"] = display_name
            if environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'environment_id'")
            __props__.__dict__["environment_id"] = environment_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            if inventory_id is None and not opts.urn:
                raise TypeError("Missing required property 'inventory_id'")
            __props__.__dict__["inventory_id"] = inventory_id
            __props__.__dict__["replication_credentials"] = replication_credentials
            __props__.__dict__["system_tags"] = system_tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if vcenter_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'vcenter_endpoint'")
            __props__.__dict__["vcenter_endpoint"] = vcenter_endpoint
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(AssetSource, __self__).__init__(
            'oci:CloudBridge/assetSource:AssetSource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            are_historical_metrics_collected: Optional[pulumi.Input[bool]] = None,
            are_realtime_metrics_collected: Optional[pulumi.Input[bool]] = None,
            assets_compartment_id: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            discovery_credentials: Optional[pulumi.Input[pulumi.InputType['AssetSourceDiscoveryCredentialsArgs']]] = None,
            discovery_schedule_id: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            environment_id: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            inventory_id: Optional[pulumi.Input[str]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            replication_credentials: Optional[pulumi.Input[pulumi.InputType['AssetSourceReplicationCredentialsArgs']]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            vcenter_endpoint: Optional[pulumi.Input[str]] = None) -> 'AssetSource':
        """
        Get an existing AssetSource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] are_historical_metrics_collected: (Updatable) Flag indicating whether historical metrics are collected for assets, originating from this asset source.
        :param pulumi.Input[bool] are_realtime_metrics_collected: (Updatable) Flag indicating whether real-time metrics are collected for assets, originating from this asset source.
        :param pulumi.Input[str] assets_compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that is going to be used to create assets.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment for the resource.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[pulumi.InputType['AssetSourceDiscoveryCredentialsArgs']] discovery_credentials: (Updatable) Credentials for an asset source.
        :param pulumi.Input[str] discovery_schedule_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the discovery schedule that is going to be attached to the created asset.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name for the asset source. Does not have to be unique, and it's mutable. Avoid entering confidential information. The name is generated by the service if it is not explicitly provided.
        :param pulumi.Input[str] environment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the environment.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] inventory_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the inventory that will contain created assets.
        :param pulumi.Input[str] lifecycle_details: The detailed state of the asset source.
        :param pulumi.Input[pulumi.InputType['AssetSourceReplicationCredentialsArgs']] replication_credentials: (Updatable) Credentials for an asset source.
        :param pulumi.Input[str] state: The current state of the asset source.
        :param pulumi.Input[Mapping[str, Any]] system_tags: (Updatable) The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param pulumi.Input[str] time_created: The time when the asset source was created in the RFC3339 format.
        :param pulumi.Input[str] time_updated: The point in time that the asset source was last updated in the RFC3339 format.
        :param pulumi.Input[str] type: (Updatable) Asset source type.
        :param pulumi.Input[str] vcenter_endpoint: (Updatable) Endpoint for VMware asset discovery and replication in the form of ```https://<host>:<port>/sdk```
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AssetSourceState.__new__(_AssetSourceState)

        __props__.__dict__["are_historical_metrics_collected"] = are_historical_metrics_collected
        __props__.__dict__["are_realtime_metrics_collected"] = are_realtime_metrics_collected
        __props__.__dict__["assets_compartment_id"] = assets_compartment_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["discovery_credentials"] = discovery_credentials
        __props__.__dict__["discovery_schedule_id"] = discovery_schedule_id
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["environment_id"] = environment_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["inventory_id"] = inventory_id
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["replication_credentials"] = replication_credentials
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["type"] = type
        __props__.__dict__["vcenter_endpoint"] = vcenter_endpoint
        return AssetSource(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="areHistoricalMetricsCollected")
    def are_historical_metrics_collected(self) -> pulumi.Output[bool]:
        """
        (Updatable) Flag indicating whether historical metrics are collected for assets, originating from this asset source.
        """
        return pulumi.get(self, "are_historical_metrics_collected")

    @property
    @pulumi.getter(name="areRealtimeMetricsCollected")
    def are_realtime_metrics_collected(self) -> pulumi.Output[bool]:
        """
        (Updatable) Flag indicating whether real-time metrics are collected for assets, originating from this asset source.
        """
        return pulumi.get(self, "are_realtime_metrics_collected")

    @property
    @pulumi.getter(name="assetsCompartmentId")
    def assets_compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that is going to be used to create assets.
        """
        return pulumi.get(self, "assets_compartment_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment for the resource.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="discoveryCredentials")
    def discovery_credentials(self) -> pulumi.Output['outputs.AssetSourceDiscoveryCredentials']:
        """
        (Updatable) Credentials for an asset source.
        """
        return pulumi.get(self, "discovery_credentials")

    @property
    @pulumi.getter(name="discoveryScheduleId")
    def discovery_schedule_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the discovery schedule that is going to be attached to the created asset.
        """
        return pulumi.get(self, "discovery_schedule_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly name for the asset source. Does not have to be unique, and it's mutable. Avoid entering confidential information. The name is generated by the service if it is not explicitly provided.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the environment.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="inventoryId")
    def inventory_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the inventory that will contain created assets.
        """
        return pulumi.get(self, "inventory_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        The detailed state of the asset source.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="replicationCredentials")
    def replication_credentials(self) -> pulumi.Output['outputs.AssetSourceReplicationCredentials']:
        """
        (Updatable) Credentials for an asset source.
        """
        return pulumi.get(self, "replication_credentials")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the asset source.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time when the asset source was created in the RFC3339 format.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The point in time that the asset source was last updated in the RFC3339 format.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        (Updatable) Asset source type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vcenterEndpoint")
    def vcenter_endpoint(self) -> pulumi.Output[str]:
        """
        (Updatable) Endpoint for VMware asset discovery and replication in the form of ```https://<host>:<port>/sdk```


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vcenter_endpoint")

