# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetComputeCapacityReservationInstancesResult',
    'AwaitableGetComputeCapacityReservationInstancesResult',
    'get_compute_capacity_reservation_instances',
    'get_compute_capacity_reservation_instances_output',
]

@pulumi.output_type
class GetComputeCapacityReservationInstancesResult:
    """
    A collection of values returned by getComputeCapacityReservationInstances.
    """
    def __init__(__self__, availability_domain=None, capacity_reservation_id=None, capacity_reservation_instances=None, compartment_id=None, filters=None, id=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if capacity_reservation_id and not isinstance(capacity_reservation_id, str):
            raise TypeError("Expected argument 'capacity_reservation_id' to be a str")
        pulumi.set(__self__, "capacity_reservation_id", capacity_reservation_id)
        if capacity_reservation_instances and not isinstance(capacity_reservation_instances, list):
            raise TypeError("Expected argument 'capacity_reservation_instances' to be a list")
        pulumi.set(__self__, "capacity_reservation_instances", capacity_reservation_instances)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[str]:
        """
        The availability domain the instance is running in.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> str:
        return pulumi.get(self, "capacity_reservation_id")

    @property
    @pulumi.getter(name="capacityReservationInstances")
    def capacity_reservation_instances(self) -> Sequence['outputs.GetComputeCapacityReservationInstancesCapacityReservationInstanceResult']:
        """
        The list of capacity_reservation_instances.
        """
        return pulumi.get(self, "capacity_reservation_instances")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The OCID of the compartment that contains the instance.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetComputeCapacityReservationInstancesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetComputeCapacityReservationInstancesResult(GetComputeCapacityReservationInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetComputeCapacityReservationInstancesResult(
            availability_domain=self.availability_domain,
            capacity_reservation_id=self.capacity_reservation_id,
            capacity_reservation_instances=self.capacity_reservation_instances,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id)


def get_compute_capacity_reservation_instances(availability_domain: Optional[str] = None,
                                               capacity_reservation_id: Optional[str] = None,
                                               compartment_id: Optional[str] = None,
                                               filters: Optional[Sequence[pulumi.InputType['GetComputeCapacityReservationInstancesFilterArgs']]] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetComputeCapacityReservationInstancesResult:
    """
    This data source provides the list of Compute Capacity Reservation Instances in Oracle Cloud Infrastructure Core service.

    Lists the instances launched under a capacity reservation. You can filter results by specifying criteria.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compute_capacity_reservation_instances = oci.Core.get_compute_capacity_reservation_instances(capacity_reservation_id=test_capacity_reservation["id"],
        availability_domain=compute_capacity_reservation_instance_availability_domain,
        compartment_id=compartment_id)
    ```


    :param str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param str capacity_reservation_id: The OCID of the compute capacity reservation.
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['capacityReservationId'] = capacity_reservation_id
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getComputeCapacityReservationInstances:getComputeCapacityReservationInstances', __args__, opts=opts, typ=GetComputeCapacityReservationInstancesResult).value

    return AwaitableGetComputeCapacityReservationInstancesResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        capacity_reservation_id=pulumi.get(__ret__, 'capacity_reservation_id'),
        capacity_reservation_instances=pulumi.get(__ret__, 'capacity_reservation_instances'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))


@_utilities.lift_output_func(get_compute_capacity_reservation_instances)
def get_compute_capacity_reservation_instances_output(availability_domain: Optional[pulumi.Input[Optional[str]]] = None,
                                                      capacity_reservation_id: Optional[pulumi.Input[str]] = None,
                                                      compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                      filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetComputeCapacityReservationInstancesFilterArgs']]]]] = None,
                                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetComputeCapacityReservationInstancesResult]:
    """
    This data source provides the list of Compute Capacity Reservation Instances in Oracle Cloud Infrastructure Core service.

    Lists the instances launched under a capacity reservation. You can filter results by specifying criteria.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compute_capacity_reservation_instances = oci.Core.get_compute_capacity_reservation_instances(capacity_reservation_id=test_capacity_reservation["id"],
        availability_domain=compute_capacity_reservation_instance_availability_domain,
        compartment_id=compartment_id)
    ```


    :param str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param str capacity_reservation_id: The OCID of the compute capacity reservation.
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    """
    ...
