# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVolumeBackupPoliciesResult',
    'AwaitableGetVolumeBackupPoliciesResult',
    'get_volume_backup_policies',
    'get_volume_backup_policies_output',
]

@pulumi.output_type
class GetVolumeBackupPoliciesResult:
    """
    A collection of values returned by getVolumeBackupPolicies.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, volume_backup_policies=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if volume_backup_policies and not isinstance(volume_backup_policies, list):
            raise TypeError("Expected argument 'volume_backup_policies' to be a list")
        pulumi.set(__self__, "volume_backup_policies", volume_backup_policies)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The OCID of the compartment that contains the volume backup.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVolumeBackupPoliciesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="volumeBackupPolicies")
    def volume_backup_policies(self) -> Sequence['outputs.GetVolumeBackupPoliciesVolumeBackupPolicyResult']:
        """
        The list of volume_backup_policies.
        """
        return pulumi.get(self, "volume_backup_policies")


class AwaitableGetVolumeBackupPoliciesResult(GetVolumeBackupPoliciesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVolumeBackupPoliciesResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            volume_backup_policies=self.volume_backup_policies)


def get_volume_backup_policies(compartment_id: Optional[str] = None,
                               filters: Optional[Sequence[pulumi.InputType['GetVolumeBackupPoliciesFilterArgs']]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVolumeBackupPoliciesResult:
    """
    This data source provides the list of Volume Backup Policies in Oracle Cloud Infrastructure Core service.

    Lists all the volume backup policies available in the specified compartment.

    For more information about Oracle defined backup policies and user defined backup policies,
    see [Policy-Based Backups](https://docs.cloud.oracle.com/iaas/Content/Block/Tasks/schedulingvolumebackups.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_volume_backup_policies = oci.Core.get_volume_backup_policies(compartment_id=compartment_id)
    ```


    :param str compartment_id: The OCID of the compartment. If no compartment is specified, the Oracle defined backup policies are listed.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getVolumeBackupPolicies:getVolumeBackupPolicies', __args__, opts=opts, typ=GetVolumeBackupPoliciesResult).value

    return AwaitableGetVolumeBackupPoliciesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        volume_backup_policies=pulumi.get(__ret__, 'volume_backup_policies'))


@_utilities.lift_output_func(get_volume_backup_policies)
def get_volume_backup_policies_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                      filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetVolumeBackupPoliciesFilterArgs']]]]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVolumeBackupPoliciesResult]:
    """
    This data source provides the list of Volume Backup Policies in Oracle Cloud Infrastructure Core service.

    Lists all the volume backup policies available in the specified compartment.

    For more information about Oracle defined backup policies and user defined backup policies,
    see [Policy-Based Backups](https://docs.cloud.oracle.com/iaas/Content/Block/Tasks/schedulingvolumebackups.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_volume_backup_policies = oci.Core.get_volume_backup_policies(compartment_id=compartment_id)
    ```


    :param str compartment_id: The OCID of the compartment. If no compartment is specified, the Oracle defined backup policies are listed.
    """
    ...
