# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DeployStageArgs', 'DeployStage']

@pulumi.input_type
class DeployStageArgs:
    def __init__(__self__, *,
                 deploy_pipeline_id: pulumi.Input[str],
                 deploy_stage_predecessor_collection: pulumi.Input['DeployStageDeployStagePredecessorCollectionArgs'],
                 deploy_stage_type: pulumi.Input[str],
                 approval_policy: Optional[pulumi.Input['DeployStageApprovalPolicyArgs']] = None,
                 are_hooks_enabled: Optional[pulumi.Input[bool]] = None,
                 blue_backend_ips: Optional[pulumi.Input['DeployStageBlueBackendIpsArgs']] = None,
                 blue_green_strategy: Optional[pulumi.Input['DeployStageBlueGreenStrategyArgs']] = None,
                 canary_strategy: Optional[pulumi.Input['DeployStageCanaryStrategyArgs']] = None,
                 command_spec_deploy_artifact_id: Optional[pulumi.Input[str]] = None,
                 compute_instance_group_blue_green_deployment_deploy_stage_id: Optional[pulumi.Input[str]] = None,
                 compute_instance_group_canary_deploy_stage_id: Optional[pulumi.Input[str]] = None,
                 compute_instance_group_canary_traffic_shift_deploy_stage_id: Optional[pulumi.Input[str]] = None,
                 compute_instance_group_deploy_environment_id: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 container_config: Optional[pulumi.Input['DeployStageContainerConfigArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deploy_artifact_id: Optional[pulumi.Input[str]] = None,
                 deploy_artifact_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 deploy_environment_id_a: Optional[pulumi.Input[str]] = None,
                 deploy_environment_id_b: Optional[pulumi.Input[str]] = None,
                 deployment_spec_deploy_artifact_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 docker_image_deploy_artifact_id: Optional[pulumi.Input[str]] = None,
                 failure_policy: Optional[pulumi.Input['DeployStageFailurePolicyArgs']] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 function_deploy_environment_id: Optional[pulumi.Input[str]] = None,
                 function_timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 green_backend_ips: Optional[pulumi.Input['DeployStageGreenBackendIpsArgs']] = None,
                 helm_chart_deploy_artifact_id: Optional[pulumi.Input[str]] = None,
                 helm_command_artifact_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_async: Optional[pulumi.Input[bool]] = None,
                 is_debug_enabled: Optional[pulumi.Input[bool]] = None,
                 is_force_enabled: Optional[pulumi.Input[bool]] = None,
                 is_uninstall_on_stage_delete: Optional[pulumi.Input[bool]] = None,
                 is_validation_enabled: Optional[pulumi.Input[bool]] = None,
                 kubernetes_manifest_deploy_artifact_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 load_balancer_config: Optional[pulumi.Input['DeployStageLoadBalancerConfigArgs']] = None,
                 max_history: Optional[pulumi.Input[int]] = None,
                 max_memory_in_mbs: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 oke_blue_green_deploy_stage_id: Optional[pulumi.Input[str]] = None,
                 oke_canary_deploy_stage_id: Optional[pulumi.Input[str]] = None,
                 oke_canary_traffic_shift_deploy_stage_id: Optional[pulumi.Input[str]] = None,
                 oke_cluster_deploy_environment_id: Optional[pulumi.Input[str]] = None,
                 production_load_balancer_config: Optional[pulumi.Input['DeployStageProductionLoadBalancerConfigArgs']] = None,
                 purpose: Optional[pulumi.Input[str]] = None,
                 release_name: Optional[pulumi.Input[str]] = None,
                 rollback_policy: Optional[pulumi.Input['DeployStageRollbackPolicyArgs']] = None,
                 rollout_policy: Optional[pulumi.Input['DeployStageRolloutPolicyArgs']] = None,
                 set_string: Optional[pulumi.Input['DeployStageSetStringArgs']] = None,
                 set_values: Optional[pulumi.Input['DeployStageSetValuesArgs']] = None,
                 should_cleanup_on_fail: Optional[pulumi.Input[bool]] = None,
                 should_not_wait: Optional[pulumi.Input[bool]] = None,
                 should_reset_values: Optional[pulumi.Input[bool]] = None,
                 should_reuse_values: Optional[pulumi.Input[bool]] = None,
                 should_skip_crds: Optional[pulumi.Input[bool]] = None,
                 should_skip_render_subchart_notes: Optional[pulumi.Input[bool]] = None,
                 test_load_balancer_config: Optional[pulumi.Input['DeployStageTestLoadBalancerConfigArgs']] = None,
                 timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 traffic_shift_target: Optional[pulumi.Input[str]] = None,
                 values_artifact_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 wait_criteria: Optional[pulumi.Input['DeployStageWaitCriteriaArgs']] = None):
        """
        The set of arguments for constructing a DeployStage resource.
        :param pulumi.Input[str] deploy_pipeline_id: The OCID of a pipeline.
        :param pulumi.Input['DeployStageDeployStagePredecessorCollectionArgs'] deploy_stage_predecessor_collection: (Updatable) Collection containing the predecessors of a stage.
        :param pulumi.Input[str] deploy_stage_type: (Updatable) Deployment stage type.
        :param pulumi.Input['DeployStageApprovalPolicyArgs'] approval_policy: (Updatable) Specifies the approval policy.
        :param pulumi.Input[bool] are_hooks_enabled: (Updatable) Disable pre/post upgrade hooks. Set to false by default.
        :param pulumi.Input['DeployStageBlueBackendIpsArgs'] blue_backend_ips: (Updatable) Collection of backend environment IP addresses.
        :param pulumi.Input['DeployStageBlueGreenStrategyArgs'] blue_green_strategy: Specifies the required blue green release strategy for OKE deployment.
        :param pulumi.Input['DeployStageCanaryStrategyArgs'] canary_strategy: Specifies the required canary release strategy for OKE deployment.
        :param pulumi.Input[str] command_spec_deploy_artifact_id: (Updatable) The OCID of the artifact that contains the command specification.
        :param pulumi.Input[str] compute_instance_group_blue_green_deployment_deploy_stage_id: The OCID of the upstream compute instance group blue-green deployment stage in this pipeline.
        :param pulumi.Input[str] compute_instance_group_canary_deploy_stage_id: A compute instance group canary stage OCID for load balancer.
        :param pulumi.Input[str] compute_instance_group_canary_traffic_shift_deploy_stage_id: (Updatable) A compute instance group canary traffic shift stage OCID for load balancer.
        :param pulumi.Input[str] compute_instance_group_deploy_environment_id: (Updatable) A compute instance group environment OCID for rolling deployment.
        :param pulumi.Input[Mapping[str, Any]] config: (Updatable) User provided key and value pair configuration, which is assigned through constants or parameter.
        :param pulumi.Input['DeployStageContainerConfigArgs'] container_config: (Updatable) Specifies the container configuration.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] deploy_artifact_id: (Updatable) Optional artifact OCID. The artifact will be included in the body for the function invocation during the stage's execution. If the DeployArtifact.argumentSubstituitionMode is set to SUBSTITUTE_PLACEHOLDERS, then the pipeline parameter values will be used to replace the placeholders in the artifact content.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] deploy_artifact_ids: (Updatable) The list of file artifact OCIDs to deploy.
        :param pulumi.Input[str] deploy_environment_id_a: First compute instance group environment OCID for deployment.
        :param pulumi.Input[str] deploy_environment_id_b: Second compute instance group environment OCID for deployment.
        :param pulumi.Input[str] deployment_spec_deploy_artifact_id: (Updatable) The OCID of the artifact that contains the deployment specification.
        :param pulumi.Input[str] description: (Updatable) Optional description about the deployment stage.
        :param pulumi.Input[str] display_name: (Updatable) Deployment stage display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        :param pulumi.Input[str] docker_image_deploy_artifact_id: (Updatable) A Docker image artifact OCID.
        :param pulumi.Input['DeployStageFailurePolicyArgs'] failure_policy: (Updatable) Specifies a failure policy for a compute instance group rolling deployment stage.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] function_deploy_environment_id: (Updatable) Function environment OCID.
        :param pulumi.Input[int] function_timeout_in_seconds: (Updatable) Timeout for execution of the Function. Value in seconds.
        :param pulumi.Input['DeployStageGreenBackendIpsArgs'] green_backend_ips: (Updatable) Collection of backend environment IP addresses.
        :param pulumi.Input[str] helm_chart_deploy_artifact_id: (Updatable) Helm chart artifact OCID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] helm_command_artifact_ids: (Updatable) List of Helm command artifact OCIDs.
        :param pulumi.Input[bool] is_async: (Updatable) A boolean flag specifies whether this stage executes asynchronously.
        :param pulumi.Input[bool] is_debug_enabled: (Updatable) Enables helm --debug option to stream output to tf stdout. Set to false by default.
        :param pulumi.Input[bool] is_force_enabled: (Updatable) Force resource update through delete; or if required, recreate. Set to false by default.
        :param pulumi.Input[bool] is_uninstall_on_stage_delete: (Updatable) Uninstall the Helm chart release on deleting the stage.
        :param pulumi.Input[bool] is_validation_enabled: (Updatable) A boolean flag specifies whether the invoked function should be validated.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] kubernetes_manifest_deploy_artifact_ids: (Updatable) List of Kubernetes manifest artifact OCIDs.
        :param pulumi.Input['DeployStageLoadBalancerConfigArgs'] load_balancer_config: (Updatable) Specifies config for load balancer traffic shift stages. The Load Balancer specified here should be an Application Load Balancer type. Network Load Balancers are not supported.
        :param pulumi.Input[int] max_history: (Updatable) Limit the maximum number of revisions saved per release. Use 0 for no limit. Set to 10 by default
        :param pulumi.Input[str] max_memory_in_mbs: (Updatable) Maximum usable memory for the Function (in MB).
        :param pulumi.Input[str] namespace: (Updatable) Default namespace to be used for Kubernetes deployment when not specified in the manifest.
        :param pulumi.Input[str] oke_blue_green_deploy_stage_id: The OCID of the upstream OKE blue-green deployment stage in this pipeline.
        :param pulumi.Input[str] oke_canary_deploy_stage_id: The OCID of an upstream OKE canary deployment stage in this pipeline.
        :param pulumi.Input[str] oke_canary_traffic_shift_deploy_stage_id: The OCID of an upstream OKE canary deployment traffic shift stage in this pipeline.
        :param pulumi.Input[str] oke_cluster_deploy_environment_id: (Updatable) Kubernetes cluster environment OCID for deployment.
        :param pulumi.Input['DeployStageProductionLoadBalancerConfigArgs'] production_load_balancer_config: Specifies configuration for load balancer traffic shift stages. The load balancer specified here should be an Application load balancer type. Network load balancers are not supported.
        :param pulumi.Input[str] purpose: (Updatable) The purpose of running this Helm stage
        :param pulumi.Input[str] release_name: (Updatable) Default name of the chart instance. Must be unique within a Kubernetes namespace.
        :param pulumi.Input['DeployStageRollbackPolicyArgs'] rollback_policy: (Updatable) Specifies the rollback policy. This is initiated on the failure of certain stage types.
        :param pulumi.Input['DeployStageRolloutPolicyArgs'] rollout_policy: (Updatable) Description of rollout policy for load balancer traffic shift stage.
        :param pulumi.Input['DeployStageSetStringArgs'] set_string: (Updatable) Specifies the name and value pairs to set helm values.
        :param pulumi.Input['DeployStageSetValuesArgs'] set_values: (Updatable) Specifies the name and value pairs to set helm values.
        :param pulumi.Input[bool] should_cleanup_on_fail: (Updatable) Allow deletion of new resources created during when an upgrade fails. Set to false by default.
        :param pulumi.Input[bool] should_not_wait: (Updatable) Does not wait until all the resources are in a ready state to mark the release as successful if set to true. Set to false by default.
        :param pulumi.Input[bool] should_reset_values: (Updatable) During upgrade, reset the values to the ones built into the chart. It overrides shouldReuseValues. Set to false by default.
        :param pulumi.Input[bool] should_reuse_values: (Updatable) During upgrade, reuse the values of the last release and merge overrides from the command line. Set to false by default.
        :param pulumi.Input[bool] should_skip_crds: (Updatable) If set, no CRDs are installed. By default, CRDs are installed only if they are not present already. Set to false by default.
        :param pulumi.Input[bool] should_skip_render_subchart_notes: (Updatable) If set, renders subchart notes along with the parent. Set to false by default.
        :param pulumi.Input['DeployStageTestLoadBalancerConfigArgs'] test_load_balancer_config: (Updatable) Specifies configuration for load balancer traffic shift stages. The load balancer specified here should be an Application load balancer type. Network load balancers are not supported.
        :param pulumi.Input[int] timeout_in_seconds: (Updatable) Time to wait for execution of a Shell/Helm stage. Defaults to 36000 seconds for Shell and 300 seconds for Helm Stage
        :param pulumi.Input[str] traffic_shift_target: (Updatable) Specifies the target or destination backend set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values_artifact_ids: (Updatable) List of values.yaml file artifact OCIDs.
        :param pulumi.Input['DeployStageWaitCriteriaArgs'] wait_criteria: (Updatable) Specifies wait criteria for the Wait stage.
        """
        pulumi.set(__self__, "deploy_pipeline_id", deploy_pipeline_id)
        pulumi.set(__self__, "deploy_stage_predecessor_collection", deploy_stage_predecessor_collection)
        pulumi.set(__self__, "deploy_stage_type", deploy_stage_type)
        if approval_policy is not None:
            pulumi.set(__self__, "approval_policy", approval_policy)
        if are_hooks_enabled is not None:
            pulumi.set(__self__, "are_hooks_enabled", are_hooks_enabled)
        if blue_backend_ips is not None:
            pulumi.set(__self__, "blue_backend_ips", blue_backend_ips)
        if blue_green_strategy is not None:
            pulumi.set(__self__, "blue_green_strategy", blue_green_strategy)
        if canary_strategy is not None:
            pulumi.set(__self__, "canary_strategy", canary_strategy)
        if command_spec_deploy_artifact_id is not None:
            pulumi.set(__self__, "command_spec_deploy_artifact_id", command_spec_deploy_artifact_id)
        if compute_instance_group_blue_green_deployment_deploy_stage_id is not None:
            pulumi.set(__self__, "compute_instance_group_blue_green_deployment_deploy_stage_id", compute_instance_group_blue_green_deployment_deploy_stage_id)
        if compute_instance_group_canary_deploy_stage_id is not None:
            pulumi.set(__self__, "compute_instance_group_canary_deploy_stage_id", compute_instance_group_canary_deploy_stage_id)
        if compute_instance_group_canary_traffic_shift_deploy_stage_id is not None:
            pulumi.set(__self__, "compute_instance_group_canary_traffic_shift_deploy_stage_id", compute_instance_group_canary_traffic_shift_deploy_stage_id)
        if compute_instance_group_deploy_environment_id is not None:
            pulumi.set(__self__, "compute_instance_group_deploy_environment_id", compute_instance_group_deploy_environment_id)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if container_config is not None:
            pulumi.set(__self__, "container_config", container_config)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if deploy_artifact_id is not None:
            pulumi.set(__self__, "deploy_artifact_id", deploy_artifact_id)
        if deploy_artifact_ids is not None:
            pulumi.set(__self__, "deploy_artifact_ids", deploy_artifact_ids)
        if deploy_environment_id_a is not None:
            pulumi.set(__self__, "deploy_environment_id_a", deploy_environment_id_a)
        if deploy_environment_id_b is not None:
            pulumi.set(__self__, "deploy_environment_id_b", deploy_environment_id_b)
        if deployment_spec_deploy_artifact_id is not None:
            pulumi.set(__self__, "deployment_spec_deploy_artifact_id", deployment_spec_deploy_artifact_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if docker_image_deploy_artifact_id is not None:
            pulumi.set(__self__, "docker_image_deploy_artifact_id", docker_image_deploy_artifact_id)
        if failure_policy is not None:
            pulumi.set(__self__, "failure_policy", failure_policy)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if function_deploy_environment_id is not None:
            pulumi.set(__self__, "function_deploy_environment_id", function_deploy_environment_id)
        if function_timeout_in_seconds is not None:
            pulumi.set(__self__, "function_timeout_in_seconds", function_timeout_in_seconds)
        if green_backend_ips is not None:
            pulumi.set(__self__, "green_backend_ips", green_backend_ips)
        if helm_chart_deploy_artifact_id is not None:
            pulumi.set(__self__, "helm_chart_deploy_artifact_id", helm_chart_deploy_artifact_id)
        if helm_command_artifact_ids is not None:
            pulumi.set(__self__, "helm_command_artifact_ids", helm_command_artifact_ids)
        if is_async is not None:
            pulumi.set(__self__, "is_async", is_async)
        if is_debug_enabled is not None:
            pulumi.set(__self__, "is_debug_enabled", is_debug_enabled)
        if is_force_enabled is not None:
            pulumi.set(__self__, "is_force_enabled", is_force_enabled)
        if is_uninstall_on_stage_delete is not None:
            pulumi.set(__self__, "is_uninstall_on_stage_delete", is_uninstall_on_stage_delete)
        if is_validation_enabled is not None:
            pulumi.set(__self__, "is_validation_enabled", is_validation_enabled)
        if kubernetes_manifest_deploy_artifact_ids is not None:
            pulumi.set(__self__, "kubernetes_manifest_deploy_artifact_ids", kubernetes_manifest_deploy_artifact_ids)
        if load_balancer_config is not None:
            pulumi.set(__self__, "load_balancer_config", load_balancer_config)
        if max_history is not None:
            pulumi.set(__self__, "max_history", max_history)
        if max_memory_in_mbs is not None:
            pulumi.set(__self__, "max_memory_in_mbs", max_memory_in_mbs)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if oke_blue_green_deploy_stage_id is not None:
            pulumi.set(__self__, "oke_blue_green_deploy_stage_id", oke_blue_green_deploy_stage_id)
        if oke_canary_deploy_stage_id is not None:
            pulumi.set(__self__, "oke_canary_deploy_stage_id", oke_canary_deploy_stage_id)
        if oke_canary_traffic_shift_deploy_stage_id is not None:
            pulumi.set(__self__, "oke_canary_traffic_shift_deploy_stage_id", oke_canary_traffic_shift_deploy_stage_id)
        if oke_cluster_deploy_environment_id is not None:
            pulumi.set(__self__, "oke_cluster_deploy_environment_id", oke_cluster_deploy_environment_id)
        if production_load_balancer_config is not None:
            pulumi.set(__self__, "production_load_balancer_config", production_load_balancer_config)
        if purpose is not None:
            pulumi.set(__self__, "purpose", purpose)
        if release_name is not None:
            pulumi.set(__self__, "release_name", release_name)
        if rollback_policy is not None:
            pulumi.set(__self__, "rollback_policy", rollback_policy)
        if rollout_policy is not None:
            pulumi.set(__self__, "rollout_policy", rollout_policy)
        if set_string is not None:
            pulumi.set(__self__, "set_string", set_string)
        if set_values is not None:
            pulumi.set(__self__, "set_values", set_values)
        if should_cleanup_on_fail is not None:
            pulumi.set(__self__, "should_cleanup_on_fail", should_cleanup_on_fail)
        if should_not_wait is not None:
            pulumi.set(__self__, "should_not_wait", should_not_wait)
        if should_reset_values is not None:
            pulumi.set(__self__, "should_reset_values", should_reset_values)
        if should_reuse_values is not None:
            pulumi.set(__self__, "should_reuse_values", should_reuse_values)
        if should_skip_crds is not None:
            pulumi.set(__self__, "should_skip_crds", should_skip_crds)
        if should_skip_render_subchart_notes is not None:
            pulumi.set(__self__, "should_skip_render_subchart_notes", should_skip_render_subchart_notes)
        if test_load_balancer_config is not None:
            pulumi.set(__self__, "test_load_balancer_config", test_load_balancer_config)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        if traffic_shift_target is not None:
            pulumi.set(__self__, "traffic_shift_target", traffic_shift_target)
        if values_artifact_ids is not None:
            pulumi.set(__self__, "values_artifact_ids", values_artifact_ids)
        if wait_criteria is not None:
            pulumi.set(__self__, "wait_criteria", wait_criteria)

    @property
    @pulumi.getter(name="deployPipelineId")
    def deploy_pipeline_id(self) -> pulumi.Input[str]:
        """
        The OCID of a pipeline.
        """
        return pulumi.get(self, "deploy_pipeline_id")

    @deploy_pipeline_id.setter
    def deploy_pipeline_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "deploy_pipeline_id", value)

    @property
    @pulumi.getter(name="deployStagePredecessorCollection")
    def deploy_stage_predecessor_collection(self) -> pulumi.Input['DeployStageDeployStagePredecessorCollectionArgs']:
        """
        (Updatable) Collection containing the predecessors of a stage.
        """
        return pulumi.get(self, "deploy_stage_predecessor_collection")

    @deploy_stage_predecessor_collection.setter
    def deploy_stage_predecessor_collection(self, value: pulumi.Input['DeployStageDeployStagePredecessorCollectionArgs']):
        pulumi.set(self, "deploy_stage_predecessor_collection", value)

    @property
    @pulumi.getter(name="deployStageType")
    def deploy_stage_type(self) -> pulumi.Input[str]:
        """
        (Updatable) Deployment stage type.
        """
        return pulumi.get(self, "deploy_stage_type")

    @deploy_stage_type.setter
    def deploy_stage_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "deploy_stage_type", value)

    @property
    @pulumi.getter(name="approvalPolicy")
    def approval_policy(self) -> Optional[pulumi.Input['DeployStageApprovalPolicyArgs']]:
        """
        (Updatable) Specifies the approval policy.
        """
        return pulumi.get(self, "approval_policy")

    @approval_policy.setter
    def approval_policy(self, value: Optional[pulumi.Input['DeployStageApprovalPolicyArgs']]):
        pulumi.set(self, "approval_policy", value)

    @property
    @pulumi.getter(name="areHooksEnabled")
    def are_hooks_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Disable pre/post upgrade hooks. Set to false by default.
        """
        return pulumi.get(self, "are_hooks_enabled")

    @are_hooks_enabled.setter
    def are_hooks_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "are_hooks_enabled", value)

    @property
    @pulumi.getter(name="blueBackendIps")
    def blue_backend_ips(self) -> Optional[pulumi.Input['DeployStageBlueBackendIpsArgs']]:
        """
        (Updatable) Collection of backend environment IP addresses.
        """
        return pulumi.get(self, "blue_backend_ips")

    @blue_backend_ips.setter
    def blue_backend_ips(self, value: Optional[pulumi.Input['DeployStageBlueBackendIpsArgs']]):
        pulumi.set(self, "blue_backend_ips", value)

    @property
    @pulumi.getter(name="blueGreenStrategy")
    def blue_green_strategy(self) -> Optional[pulumi.Input['DeployStageBlueGreenStrategyArgs']]:
        """
        Specifies the required blue green release strategy for OKE deployment.
        """
        return pulumi.get(self, "blue_green_strategy")

    @blue_green_strategy.setter
    def blue_green_strategy(self, value: Optional[pulumi.Input['DeployStageBlueGreenStrategyArgs']]):
        pulumi.set(self, "blue_green_strategy", value)

    @property
    @pulumi.getter(name="canaryStrategy")
    def canary_strategy(self) -> Optional[pulumi.Input['DeployStageCanaryStrategyArgs']]:
        """
        Specifies the required canary release strategy for OKE deployment.
        """
        return pulumi.get(self, "canary_strategy")

    @canary_strategy.setter
    def canary_strategy(self, value: Optional[pulumi.Input['DeployStageCanaryStrategyArgs']]):
        pulumi.set(self, "canary_strategy", value)

    @property
    @pulumi.getter(name="commandSpecDeployArtifactId")
    def command_spec_deploy_artifact_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the artifact that contains the command specification.
        """
        return pulumi.get(self, "command_spec_deploy_artifact_id")

    @command_spec_deploy_artifact_id.setter
    def command_spec_deploy_artifact_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "command_spec_deploy_artifact_id", value)

    @property
    @pulumi.getter(name="computeInstanceGroupBlueGreenDeploymentDeployStageId")
    def compute_instance_group_blue_green_deployment_deploy_stage_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the upstream compute instance group blue-green deployment stage in this pipeline.
        """
        return pulumi.get(self, "compute_instance_group_blue_green_deployment_deploy_stage_id")

    @compute_instance_group_blue_green_deployment_deploy_stage_id.setter
    def compute_instance_group_blue_green_deployment_deploy_stage_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_instance_group_blue_green_deployment_deploy_stage_id", value)

    @property
    @pulumi.getter(name="computeInstanceGroupCanaryDeployStageId")
    def compute_instance_group_canary_deploy_stage_id(self) -> Optional[pulumi.Input[str]]:
        """
        A compute instance group canary stage OCID for load balancer.
        """
        return pulumi.get(self, "compute_instance_group_canary_deploy_stage_id")

    @compute_instance_group_canary_deploy_stage_id.setter
    def compute_instance_group_canary_deploy_stage_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_instance_group_canary_deploy_stage_id", value)

    @property
    @pulumi.getter(name="computeInstanceGroupCanaryTrafficShiftDeployStageId")
    def compute_instance_group_canary_traffic_shift_deploy_stage_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A compute instance group canary traffic shift stage OCID for load balancer.
        """
        return pulumi.get(self, "compute_instance_group_canary_traffic_shift_deploy_stage_id")

    @compute_instance_group_canary_traffic_shift_deploy_stage_id.setter
    def compute_instance_group_canary_traffic_shift_deploy_stage_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_instance_group_canary_traffic_shift_deploy_stage_id", value)

    @property
    @pulumi.getter(name="computeInstanceGroupDeployEnvironmentId")
    def compute_instance_group_deploy_environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A compute instance group environment OCID for rolling deployment.
        """
        return pulumi.get(self, "compute_instance_group_deploy_environment_id")

    @compute_instance_group_deploy_environment_id.setter
    def compute_instance_group_deploy_environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_instance_group_deploy_environment_id", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) User provided key and value pair configuration, which is assigned through constants or parameter.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="containerConfig")
    def container_config(self) -> Optional[pulumi.Input['DeployStageContainerConfigArgs']]:
        """
        (Updatable) Specifies the container configuration.
        """
        return pulumi.get(self, "container_config")

    @container_config.setter
    def container_config(self, value: Optional[pulumi.Input['DeployStageContainerConfigArgs']]):
        pulumi.set(self, "container_config", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deployArtifactId")
    def deploy_artifact_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Optional artifact OCID. The artifact will be included in the body for the function invocation during the stage's execution. If the DeployArtifact.argumentSubstituitionMode is set to SUBSTITUTE_PLACEHOLDERS, then the pipeline parameter values will be used to replace the placeholders in the artifact content.
        """
        return pulumi.get(self, "deploy_artifact_id")

    @deploy_artifact_id.setter
    def deploy_artifact_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deploy_artifact_id", value)

    @property
    @pulumi.getter(name="deployArtifactIds")
    def deploy_artifact_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The list of file artifact OCIDs to deploy.
        """
        return pulumi.get(self, "deploy_artifact_ids")

    @deploy_artifact_ids.setter
    def deploy_artifact_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "deploy_artifact_ids", value)

    @property
    @pulumi.getter(name="deployEnvironmentIdA")
    def deploy_environment_id_a(self) -> Optional[pulumi.Input[str]]:
        """
        First compute instance group environment OCID for deployment.
        """
        return pulumi.get(self, "deploy_environment_id_a")

    @deploy_environment_id_a.setter
    def deploy_environment_id_a(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deploy_environment_id_a", value)

    @property
    @pulumi.getter(name="deployEnvironmentIdB")
    def deploy_environment_id_b(self) -> Optional[pulumi.Input[str]]:
        """
        Second compute instance group environment OCID for deployment.
        """
        return pulumi.get(self, "deploy_environment_id_b")

    @deploy_environment_id_b.setter
    def deploy_environment_id_b(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deploy_environment_id_b", value)

    @property
    @pulumi.getter(name="deploymentSpecDeployArtifactId")
    def deployment_spec_deploy_artifact_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the artifact that contains the deployment specification.
        """
        return pulumi.get(self, "deployment_spec_deploy_artifact_id")

    @deployment_spec_deploy_artifact_id.setter
    def deployment_spec_deploy_artifact_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_spec_deploy_artifact_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Optional description about the deployment stage.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Deployment stage display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="dockerImageDeployArtifactId")
    def docker_image_deploy_artifact_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A Docker image artifact OCID.
        """
        return pulumi.get(self, "docker_image_deploy_artifact_id")

    @docker_image_deploy_artifact_id.setter
    def docker_image_deploy_artifact_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "docker_image_deploy_artifact_id", value)

    @property
    @pulumi.getter(name="failurePolicy")
    def failure_policy(self) -> Optional[pulumi.Input['DeployStageFailurePolicyArgs']]:
        """
        (Updatable) Specifies a failure policy for a compute instance group rolling deployment stage.
        """
        return pulumi.get(self, "failure_policy")

    @failure_policy.setter
    def failure_policy(self, value: Optional[pulumi.Input['DeployStageFailurePolicyArgs']]):
        pulumi.set(self, "failure_policy", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="functionDeployEnvironmentId")
    def function_deploy_environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Function environment OCID.
        """
        return pulumi.get(self, "function_deploy_environment_id")

    @function_deploy_environment_id.setter
    def function_deploy_environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_deploy_environment_id", value)

    @property
    @pulumi.getter(name="functionTimeoutInSeconds")
    def function_timeout_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Timeout for execution of the Function. Value in seconds.
        """
        return pulumi.get(self, "function_timeout_in_seconds")

    @function_timeout_in_seconds.setter
    def function_timeout_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "function_timeout_in_seconds", value)

    @property
    @pulumi.getter(name="greenBackendIps")
    def green_backend_ips(self) -> Optional[pulumi.Input['DeployStageGreenBackendIpsArgs']]:
        """
        (Updatable) Collection of backend environment IP addresses.
        """
        return pulumi.get(self, "green_backend_ips")

    @green_backend_ips.setter
    def green_backend_ips(self, value: Optional[pulumi.Input['DeployStageGreenBackendIpsArgs']]):
        pulumi.set(self, "green_backend_ips", value)

    @property
    @pulumi.getter(name="helmChartDeployArtifactId")
    def helm_chart_deploy_artifact_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Helm chart artifact OCID.
        """
        return pulumi.get(self, "helm_chart_deploy_artifact_id")

    @helm_chart_deploy_artifact_id.setter
    def helm_chart_deploy_artifact_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "helm_chart_deploy_artifact_id", value)

    @property
    @pulumi.getter(name="helmCommandArtifactIds")
    def helm_command_artifact_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) List of Helm command artifact OCIDs.
        """
        return pulumi.get(self, "helm_command_artifact_ids")

    @helm_command_artifact_ids.setter
    def helm_command_artifact_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "helm_command_artifact_ids", value)

    @property
    @pulumi.getter(name="isAsync")
    def is_async(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) A boolean flag specifies whether this stage executes asynchronously.
        """
        return pulumi.get(self, "is_async")

    @is_async.setter
    def is_async(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_async", value)

    @property
    @pulumi.getter(name="isDebugEnabled")
    def is_debug_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Enables helm --debug option to stream output to tf stdout. Set to false by default.
        """
        return pulumi.get(self, "is_debug_enabled")

    @is_debug_enabled.setter
    def is_debug_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_debug_enabled", value)

    @property
    @pulumi.getter(name="isForceEnabled")
    def is_force_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Force resource update through delete; or if required, recreate. Set to false by default.
        """
        return pulumi.get(self, "is_force_enabled")

    @is_force_enabled.setter
    def is_force_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_force_enabled", value)

    @property
    @pulumi.getter(name="isUninstallOnStageDelete")
    def is_uninstall_on_stage_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Uninstall the Helm chart release on deleting the stage.
        """
        return pulumi.get(self, "is_uninstall_on_stage_delete")

    @is_uninstall_on_stage_delete.setter
    def is_uninstall_on_stage_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_uninstall_on_stage_delete", value)

    @property
    @pulumi.getter(name="isValidationEnabled")
    def is_validation_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) A boolean flag specifies whether the invoked function should be validated.
        """
        return pulumi.get(self, "is_validation_enabled")

    @is_validation_enabled.setter
    def is_validation_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_validation_enabled", value)

    @property
    @pulumi.getter(name="kubernetesManifestDeployArtifactIds")
    def kubernetes_manifest_deploy_artifact_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) List of Kubernetes manifest artifact OCIDs.
        """
        return pulumi.get(self, "kubernetes_manifest_deploy_artifact_ids")

    @kubernetes_manifest_deploy_artifact_ids.setter
    def kubernetes_manifest_deploy_artifact_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "kubernetes_manifest_deploy_artifact_ids", value)

    @property
    @pulumi.getter(name="loadBalancerConfig")
    def load_balancer_config(self) -> Optional[pulumi.Input['DeployStageLoadBalancerConfigArgs']]:
        """
        (Updatable) Specifies config for load balancer traffic shift stages. The Load Balancer specified here should be an Application Load Balancer type. Network Load Balancers are not supported.
        """
        return pulumi.get(self, "load_balancer_config")

    @load_balancer_config.setter
    def load_balancer_config(self, value: Optional[pulumi.Input['DeployStageLoadBalancerConfigArgs']]):
        pulumi.set(self, "load_balancer_config", value)

    @property
    @pulumi.getter(name="maxHistory")
    def max_history(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Limit the maximum number of revisions saved per release. Use 0 for no limit. Set to 10 by default
        """
        return pulumi.get(self, "max_history")

    @max_history.setter
    def max_history(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_history", value)

    @property
    @pulumi.getter(name="maxMemoryInMbs")
    def max_memory_in_mbs(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Maximum usable memory for the Function (in MB).
        """
        return pulumi.get(self, "max_memory_in_mbs")

    @max_memory_in_mbs.setter
    def max_memory_in_mbs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_memory_in_mbs", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Default namespace to be used for Kubernetes deployment when not specified in the manifest.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="okeBlueGreenDeployStageId")
    def oke_blue_green_deploy_stage_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the upstream OKE blue-green deployment stage in this pipeline.
        """
        return pulumi.get(self, "oke_blue_green_deploy_stage_id")

    @oke_blue_green_deploy_stage_id.setter
    def oke_blue_green_deploy_stage_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oke_blue_green_deploy_stage_id", value)

    @property
    @pulumi.getter(name="okeCanaryDeployStageId")
    def oke_canary_deploy_stage_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of an upstream OKE canary deployment stage in this pipeline.
        """
        return pulumi.get(self, "oke_canary_deploy_stage_id")

    @oke_canary_deploy_stage_id.setter
    def oke_canary_deploy_stage_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oke_canary_deploy_stage_id", value)

    @property
    @pulumi.getter(name="okeCanaryTrafficShiftDeployStageId")
    def oke_canary_traffic_shift_deploy_stage_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of an upstream OKE canary deployment traffic shift stage in this pipeline.
        """
        return pulumi.get(self, "oke_canary_traffic_shift_deploy_stage_id")

    @oke_canary_traffic_shift_deploy_stage_id.setter
    def oke_canary_traffic_shift_deploy_stage_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oke_canary_traffic_shift_deploy_stage_id", value)

    @property
    @pulumi.getter(name="okeClusterDeployEnvironmentId")
    def oke_cluster_deploy_environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Kubernetes cluster environment OCID for deployment.
        """
        return pulumi.get(self, "oke_cluster_deploy_environment_id")

    @oke_cluster_deploy_environment_id.setter
    def oke_cluster_deploy_environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oke_cluster_deploy_environment_id", value)

    @property
    @pulumi.getter(name="productionLoadBalancerConfig")
    def production_load_balancer_config(self) -> Optional[pulumi.Input['DeployStageProductionLoadBalancerConfigArgs']]:
        """
        Specifies configuration for load balancer traffic shift stages. The load balancer specified here should be an Application load balancer type. Network load balancers are not supported.
        """
        return pulumi.get(self, "production_load_balancer_config")

    @production_load_balancer_config.setter
    def production_load_balancer_config(self, value: Optional[pulumi.Input['DeployStageProductionLoadBalancerConfigArgs']]):
        pulumi.set(self, "production_load_balancer_config", value)

    @property
    @pulumi.getter
    def purpose(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The purpose of running this Helm stage
        """
        return pulumi.get(self, "purpose")

    @purpose.setter
    def purpose(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "purpose", value)

    @property
    @pulumi.getter(name="releaseName")
    def release_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Default name of the chart instance. Must be unique within a Kubernetes namespace.
        """
        return pulumi.get(self, "release_name")

    @release_name.setter
    def release_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "release_name", value)

    @property
    @pulumi.getter(name="rollbackPolicy")
    def rollback_policy(self) -> Optional[pulumi.Input['DeployStageRollbackPolicyArgs']]:
        """
        (Updatable) Specifies the rollback policy. This is initiated on the failure of certain stage types.
        """
        return pulumi.get(self, "rollback_policy")

    @rollback_policy.setter
    def rollback_policy(self, value: Optional[pulumi.Input['DeployStageRollbackPolicyArgs']]):
        pulumi.set(self, "rollback_policy", value)

    @property
    @pulumi.getter(name="rolloutPolicy")
    def rollout_policy(self) -> Optional[pulumi.Input['DeployStageRolloutPolicyArgs']]:
        """
        (Updatable) Description of rollout policy for load balancer traffic shift stage.
        """
        return pulumi.get(self, "rollout_policy")

    @rollout_policy.setter
    def rollout_policy(self, value: Optional[pulumi.Input['DeployStageRolloutPolicyArgs']]):
        pulumi.set(self, "rollout_policy", value)

    @property
    @pulumi.getter(name="setString")
    def set_string(self) -> Optional[pulumi.Input['DeployStageSetStringArgs']]:
        """
        (Updatable) Specifies the name and value pairs to set helm values.
        """
        return pulumi.get(self, "set_string")

    @set_string.setter
    def set_string(self, value: Optional[pulumi.Input['DeployStageSetStringArgs']]):
        pulumi.set(self, "set_string", value)

    @property
    @pulumi.getter(name="setValues")
    def set_values(self) -> Optional[pulumi.Input['DeployStageSetValuesArgs']]:
        """
        (Updatable) Specifies the name and value pairs to set helm values.
        """
        return pulumi.get(self, "set_values")

    @set_values.setter
    def set_values(self, value: Optional[pulumi.Input['DeployStageSetValuesArgs']]):
        pulumi.set(self, "set_values", value)

    @property
    @pulumi.getter(name="shouldCleanupOnFail")
    def should_cleanup_on_fail(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Allow deletion of new resources created during when an upgrade fails. Set to false by default.
        """
        return pulumi.get(self, "should_cleanup_on_fail")

    @should_cleanup_on_fail.setter
    def should_cleanup_on_fail(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "should_cleanup_on_fail", value)

    @property
    @pulumi.getter(name="shouldNotWait")
    def should_not_wait(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Does not wait until all the resources are in a ready state to mark the release as successful if set to true. Set to false by default.
        """
        return pulumi.get(self, "should_not_wait")

    @should_not_wait.setter
    def should_not_wait(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "should_not_wait", value)

    @property
    @pulumi.getter(name="shouldResetValues")
    def should_reset_values(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) During upgrade, reset the values to the ones built into the chart. It overrides shouldReuseValues. Set to false by default.
        """
        return pulumi.get(self, "should_reset_values")

    @should_reset_values.setter
    def should_reset_values(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "should_reset_values", value)

    @property
    @pulumi.getter(name="shouldReuseValues")
    def should_reuse_values(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) During upgrade, reuse the values of the last release and merge overrides from the command line. Set to false by default.
        """
        return pulumi.get(self, "should_reuse_values")

    @should_reuse_values.setter
    def should_reuse_values(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "should_reuse_values", value)

    @property
    @pulumi.getter(name="shouldSkipCrds")
    def should_skip_crds(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If set, no CRDs are installed. By default, CRDs are installed only if they are not present already. Set to false by default.
        """
        return pulumi.get(self, "should_skip_crds")

    @should_skip_crds.setter
    def should_skip_crds(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "should_skip_crds", value)

    @property
    @pulumi.getter(name="shouldSkipRenderSubchartNotes")
    def should_skip_render_subchart_notes(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If set, renders subchart notes along with the parent. Set to false by default.
        """
        return pulumi.get(self, "should_skip_render_subchart_notes")

    @should_skip_render_subchart_notes.setter
    def should_skip_render_subchart_notes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "should_skip_render_subchart_notes", value)

    @property
    @pulumi.getter(name="testLoadBalancerConfig")
    def test_load_balancer_config(self) -> Optional[pulumi.Input['DeployStageTestLoadBalancerConfigArgs']]:
        """
        (Updatable) Specifies configuration for load balancer traffic shift stages. The load balancer specified here should be an Application load balancer type. Network load balancers are not supported.
        """
        return pulumi.get(self, "test_load_balancer_config")

    @test_load_balancer_config.setter
    def test_load_balancer_config(self, value: Optional[pulumi.Input['DeployStageTestLoadBalancerConfigArgs']]):
        pulumi.set(self, "test_load_balancer_config", value)

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Time to wait for execution of a Shell/Helm stage. Defaults to 36000 seconds for Shell and 300 seconds for Helm Stage
        """
        return pulumi.get(self, "timeout_in_seconds")

    @timeout_in_seconds.setter
    def timeout_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_in_seconds", value)

    @property
    @pulumi.getter(name="trafficShiftTarget")
    def traffic_shift_target(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specifies the target or destination backend set.
        """
        return pulumi.get(self, "traffic_shift_target")

    @traffic_shift_target.setter
    def traffic_shift_target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "traffic_shift_target", value)

    @property
    @pulumi.getter(name="valuesArtifactIds")
    def values_artifact_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) List of values.yaml file artifact OCIDs.
        """
        return pulumi.get(self, "values_artifact_ids")

    @values_artifact_ids.setter
    def values_artifact_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values_artifact_ids", value)

    @property
    @pulumi.getter(name="waitCriteria")
    def wait_criteria(self) -> Optional[pulumi.Input['DeployStageWaitCriteriaArgs']]:
        """
        (Updatable) Specifies wait criteria for the Wait stage.
        """
        return pulumi.get(self, "wait_criteria")

    @wait_criteria.setter
    def wait_criteria(self, value: Optional[pulumi.Input['DeployStageWaitCriteriaArgs']]):
        pulumi.set(self, "wait_criteria", value)


@pulumi.input_type
class _DeployStageState:
    def __init__(__self__, *,
                 approval_policy: Optional[pulumi.Input['DeployStageApprovalPolicyArgs']] = None,
                 are_hooks_enabled: Optional[pulumi.Input[bool]] = None,
                 blue_backend_ips: Optional[pulumi.Input['DeployStageBlueBackendIpsArgs']] = None,
                 blue_green_strategy: Optional[pulumi.Input['DeployStageBlueGreenStrategyArgs']] = None,
                 canary_strategy: Optional[pulumi.Input['DeployStageCanaryStrategyArgs']] = None,
                 command_spec_deploy_artifact_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_instance_group_blue_green_deployment_deploy_stage_id: Optional[pulumi.Input[str]] = None,
                 compute_instance_group_canary_deploy_stage_id: Optional[pulumi.Input[str]] = None,
                 compute_instance_group_canary_traffic_shift_deploy_stage_id: Optional[pulumi.Input[str]] = None,
                 compute_instance_group_deploy_environment_id: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 container_config: Optional[pulumi.Input['DeployStageContainerConfigArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deploy_artifact_id: Optional[pulumi.Input[str]] = None,
                 deploy_artifact_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 deploy_environment_id_a: Optional[pulumi.Input[str]] = None,
                 deploy_environment_id_b: Optional[pulumi.Input[str]] = None,
                 deploy_pipeline_id: Optional[pulumi.Input[str]] = None,
                 deploy_stage_predecessor_collection: Optional[pulumi.Input['DeployStageDeployStagePredecessorCollectionArgs']] = None,
                 deploy_stage_type: Optional[pulumi.Input[str]] = None,
                 deployment_spec_deploy_artifact_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 docker_image_deploy_artifact_id: Optional[pulumi.Input[str]] = None,
                 failure_policy: Optional[pulumi.Input['DeployStageFailurePolicyArgs']] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 function_deploy_environment_id: Optional[pulumi.Input[str]] = None,
                 function_timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 green_backend_ips: Optional[pulumi.Input['DeployStageGreenBackendIpsArgs']] = None,
                 helm_chart_deploy_artifact_id: Optional[pulumi.Input[str]] = None,
                 helm_command_artifact_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_async: Optional[pulumi.Input[bool]] = None,
                 is_debug_enabled: Optional[pulumi.Input[bool]] = None,
                 is_force_enabled: Optional[pulumi.Input[bool]] = None,
                 is_uninstall_on_stage_delete: Optional[pulumi.Input[bool]] = None,
                 is_validation_enabled: Optional[pulumi.Input[bool]] = None,
                 kubernetes_manifest_deploy_artifact_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 load_balancer_config: Optional[pulumi.Input['DeployStageLoadBalancerConfigArgs']] = None,
                 max_history: Optional[pulumi.Input[int]] = None,
                 max_memory_in_mbs: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 oke_blue_green_deploy_stage_id: Optional[pulumi.Input[str]] = None,
                 oke_canary_deploy_stage_id: Optional[pulumi.Input[str]] = None,
                 oke_canary_traffic_shift_deploy_stage_id: Optional[pulumi.Input[str]] = None,
                 oke_cluster_deploy_environment_id: Optional[pulumi.Input[str]] = None,
                 production_load_balancer_config: Optional[pulumi.Input['DeployStageProductionLoadBalancerConfigArgs']] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 purpose: Optional[pulumi.Input[str]] = None,
                 release_name: Optional[pulumi.Input[str]] = None,
                 rollback_policy: Optional[pulumi.Input['DeployStageRollbackPolicyArgs']] = None,
                 rollout_policy: Optional[pulumi.Input['DeployStageRolloutPolicyArgs']] = None,
                 set_string: Optional[pulumi.Input['DeployStageSetStringArgs']] = None,
                 set_values: Optional[pulumi.Input['DeployStageSetValuesArgs']] = None,
                 should_cleanup_on_fail: Optional[pulumi.Input[bool]] = None,
                 should_not_wait: Optional[pulumi.Input[bool]] = None,
                 should_reset_values: Optional[pulumi.Input[bool]] = None,
                 should_reuse_values: Optional[pulumi.Input[bool]] = None,
                 should_skip_crds: Optional[pulumi.Input[bool]] = None,
                 should_skip_render_subchart_notes: Optional[pulumi.Input[bool]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 test_load_balancer_config: Optional[pulumi.Input['DeployStageTestLoadBalancerConfigArgs']] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 traffic_shift_target: Optional[pulumi.Input[str]] = None,
                 values_artifact_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 wait_criteria: Optional[pulumi.Input['DeployStageWaitCriteriaArgs']] = None):
        """
        Input properties used for looking up and filtering DeployStage resources.
        :param pulumi.Input['DeployStageApprovalPolicyArgs'] approval_policy: (Updatable) Specifies the approval policy.
        :param pulumi.Input[bool] are_hooks_enabled: (Updatable) Disable pre/post upgrade hooks. Set to false by default.
        :param pulumi.Input['DeployStageBlueBackendIpsArgs'] blue_backend_ips: (Updatable) Collection of backend environment IP addresses.
        :param pulumi.Input['DeployStageBlueGreenStrategyArgs'] blue_green_strategy: Specifies the required blue green release strategy for OKE deployment.
        :param pulumi.Input['DeployStageCanaryStrategyArgs'] canary_strategy: Specifies the required canary release strategy for OKE deployment.
        :param pulumi.Input[str] command_spec_deploy_artifact_id: (Updatable) The OCID of the artifact that contains the command specification.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment where the ContainerInstance will be created.
        :param pulumi.Input[str] compute_instance_group_blue_green_deployment_deploy_stage_id: The OCID of the upstream compute instance group blue-green deployment stage in this pipeline.
        :param pulumi.Input[str] compute_instance_group_canary_deploy_stage_id: A compute instance group canary stage OCID for load balancer.
        :param pulumi.Input[str] compute_instance_group_canary_traffic_shift_deploy_stage_id: (Updatable) A compute instance group canary traffic shift stage OCID for load balancer.
        :param pulumi.Input[str] compute_instance_group_deploy_environment_id: (Updatable) A compute instance group environment OCID for rolling deployment.
        :param pulumi.Input[Mapping[str, Any]] config: (Updatable) User provided key and value pair configuration, which is assigned through constants or parameter.
        :param pulumi.Input['DeployStageContainerConfigArgs'] container_config: (Updatable) Specifies the container configuration.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] deploy_artifact_id: (Updatable) Optional artifact OCID. The artifact will be included in the body for the function invocation during the stage's execution. If the DeployArtifact.argumentSubstituitionMode is set to SUBSTITUTE_PLACEHOLDERS, then the pipeline parameter values will be used to replace the placeholders in the artifact content.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] deploy_artifact_ids: (Updatable) The list of file artifact OCIDs to deploy.
        :param pulumi.Input[str] deploy_environment_id_a: First compute instance group environment OCID for deployment.
        :param pulumi.Input[str] deploy_environment_id_b: Second compute instance group environment OCID for deployment.
        :param pulumi.Input[str] deploy_pipeline_id: The OCID of a pipeline.
        :param pulumi.Input['DeployStageDeployStagePredecessorCollectionArgs'] deploy_stage_predecessor_collection: (Updatable) Collection containing the predecessors of a stage.
        :param pulumi.Input[str] deploy_stage_type: (Updatable) Deployment stage type.
        :param pulumi.Input[str] deployment_spec_deploy_artifact_id: (Updatable) The OCID of the artifact that contains the deployment specification.
        :param pulumi.Input[str] description: (Updatable) Optional description about the deployment stage.
        :param pulumi.Input[str] display_name: (Updatable) Deployment stage display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        :param pulumi.Input[str] docker_image_deploy_artifact_id: (Updatable) A Docker image artifact OCID.
        :param pulumi.Input['DeployStageFailurePolicyArgs'] failure_policy: (Updatable) Specifies a failure policy for a compute instance group rolling deployment stage.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] function_deploy_environment_id: (Updatable) Function environment OCID.
        :param pulumi.Input[int] function_timeout_in_seconds: (Updatable) Timeout for execution of the Function. Value in seconds.
        :param pulumi.Input['DeployStageGreenBackendIpsArgs'] green_backend_ips: (Updatable) Collection of backend environment IP addresses.
        :param pulumi.Input[str] helm_chart_deploy_artifact_id: (Updatable) Helm chart artifact OCID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] helm_command_artifact_ids: (Updatable) List of Helm command artifact OCIDs.
        :param pulumi.Input[bool] is_async: (Updatable) A boolean flag specifies whether this stage executes asynchronously.
        :param pulumi.Input[bool] is_debug_enabled: (Updatable) Enables helm --debug option to stream output to tf stdout. Set to false by default.
        :param pulumi.Input[bool] is_force_enabled: (Updatable) Force resource update through delete; or if required, recreate. Set to false by default.
        :param pulumi.Input[bool] is_uninstall_on_stage_delete: (Updatable) Uninstall the Helm chart release on deleting the stage.
        :param pulumi.Input[bool] is_validation_enabled: (Updatable) A boolean flag specifies whether the invoked function should be validated.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] kubernetes_manifest_deploy_artifact_ids: (Updatable) List of Kubernetes manifest artifact OCIDs.
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input['DeployStageLoadBalancerConfigArgs'] load_balancer_config: (Updatable) Specifies config for load balancer traffic shift stages. The Load Balancer specified here should be an Application Load Balancer type. Network Load Balancers are not supported.
        :param pulumi.Input[int] max_history: (Updatable) Limit the maximum number of revisions saved per release. Use 0 for no limit. Set to 10 by default
        :param pulumi.Input[str] max_memory_in_mbs: (Updatable) Maximum usable memory for the Function (in MB).
        :param pulumi.Input[str] namespace: (Updatable) Default namespace to be used for Kubernetes deployment when not specified in the manifest.
        :param pulumi.Input[str] oke_blue_green_deploy_stage_id: The OCID of the upstream OKE blue-green deployment stage in this pipeline.
        :param pulumi.Input[str] oke_canary_deploy_stage_id: The OCID of an upstream OKE canary deployment stage in this pipeline.
        :param pulumi.Input[str] oke_canary_traffic_shift_deploy_stage_id: The OCID of an upstream OKE canary deployment traffic shift stage in this pipeline.
        :param pulumi.Input[str] oke_cluster_deploy_environment_id: (Updatable) Kubernetes cluster environment OCID for deployment.
        :param pulumi.Input['DeployStageProductionLoadBalancerConfigArgs'] production_load_balancer_config: Specifies configuration for load balancer traffic shift stages. The load balancer specified here should be an Application load balancer type. Network load balancers are not supported.
        :param pulumi.Input[str] project_id: The OCID of a project.
        :param pulumi.Input[str] purpose: (Updatable) The purpose of running this Helm stage
        :param pulumi.Input[str] release_name: (Updatable) Default name of the chart instance. Must be unique within a Kubernetes namespace.
        :param pulumi.Input['DeployStageRollbackPolicyArgs'] rollback_policy: (Updatable) Specifies the rollback policy. This is initiated on the failure of certain stage types.
        :param pulumi.Input['DeployStageRolloutPolicyArgs'] rollout_policy: (Updatable) Description of rollout policy for load balancer traffic shift stage.
        :param pulumi.Input['DeployStageSetStringArgs'] set_string: (Updatable) Specifies the name and value pairs to set helm values.
        :param pulumi.Input['DeployStageSetValuesArgs'] set_values: (Updatable) Specifies the name and value pairs to set helm values.
        :param pulumi.Input[bool] should_cleanup_on_fail: (Updatable) Allow deletion of new resources created during when an upgrade fails. Set to false by default.
        :param pulumi.Input[bool] should_not_wait: (Updatable) Does not wait until all the resources are in a ready state to mark the release as successful if set to true. Set to false by default.
        :param pulumi.Input[bool] should_reset_values: (Updatable) During upgrade, reset the values to the ones built into the chart. It overrides shouldReuseValues. Set to false by default.
        :param pulumi.Input[bool] should_reuse_values: (Updatable) During upgrade, reuse the values of the last release and merge overrides from the command line. Set to false by default.
        :param pulumi.Input[bool] should_skip_crds: (Updatable) If set, no CRDs are installed. By default, CRDs are installed only if they are not present already. Set to false by default.
        :param pulumi.Input[bool] should_skip_render_subchart_notes: (Updatable) If set, renders subchart notes along with the parent. Set to false by default.
        :param pulumi.Input[str] state: The current state of the deployment stage.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input['DeployStageTestLoadBalancerConfigArgs'] test_load_balancer_config: (Updatable) Specifies configuration for load balancer traffic shift stages. The load balancer specified here should be an Application load balancer type. Network load balancers are not supported.
        :param pulumi.Input[str] time_created: Time the deployment stage was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        :param pulumi.Input[str] time_updated: Time the deployment stage was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        :param pulumi.Input[int] timeout_in_seconds: (Updatable) Time to wait for execution of a Shell/Helm stage. Defaults to 36000 seconds for Shell and 300 seconds for Helm Stage
        :param pulumi.Input[str] traffic_shift_target: (Updatable) Specifies the target or destination backend set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values_artifact_ids: (Updatable) List of values.yaml file artifact OCIDs.
        :param pulumi.Input['DeployStageWaitCriteriaArgs'] wait_criteria: (Updatable) Specifies wait criteria for the Wait stage.
        """
        if approval_policy is not None:
            pulumi.set(__self__, "approval_policy", approval_policy)
        if are_hooks_enabled is not None:
            pulumi.set(__self__, "are_hooks_enabled", are_hooks_enabled)
        if blue_backend_ips is not None:
            pulumi.set(__self__, "blue_backend_ips", blue_backend_ips)
        if blue_green_strategy is not None:
            pulumi.set(__self__, "blue_green_strategy", blue_green_strategy)
        if canary_strategy is not None:
            pulumi.set(__self__, "canary_strategy", canary_strategy)
        if command_spec_deploy_artifact_id is not None:
            pulumi.set(__self__, "command_spec_deploy_artifact_id", command_spec_deploy_artifact_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_instance_group_blue_green_deployment_deploy_stage_id is not None:
            pulumi.set(__self__, "compute_instance_group_blue_green_deployment_deploy_stage_id", compute_instance_group_blue_green_deployment_deploy_stage_id)
        if compute_instance_group_canary_deploy_stage_id is not None:
            pulumi.set(__self__, "compute_instance_group_canary_deploy_stage_id", compute_instance_group_canary_deploy_stage_id)
        if compute_instance_group_canary_traffic_shift_deploy_stage_id is not None:
            pulumi.set(__self__, "compute_instance_group_canary_traffic_shift_deploy_stage_id", compute_instance_group_canary_traffic_shift_deploy_stage_id)
        if compute_instance_group_deploy_environment_id is not None:
            pulumi.set(__self__, "compute_instance_group_deploy_environment_id", compute_instance_group_deploy_environment_id)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if container_config is not None:
            pulumi.set(__self__, "container_config", container_config)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if deploy_artifact_id is not None:
            pulumi.set(__self__, "deploy_artifact_id", deploy_artifact_id)
        if deploy_artifact_ids is not None:
            pulumi.set(__self__, "deploy_artifact_ids", deploy_artifact_ids)
        if deploy_environment_id_a is not None:
            pulumi.set(__self__, "deploy_environment_id_a", deploy_environment_id_a)
        if deploy_environment_id_b is not None:
            pulumi.set(__self__, "deploy_environment_id_b", deploy_environment_id_b)
        if deploy_pipeline_id is not None:
            pulumi.set(__self__, "deploy_pipeline_id", deploy_pipeline_id)
        if deploy_stage_predecessor_collection is not None:
            pulumi.set(__self__, "deploy_stage_predecessor_collection", deploy_stage_predecessor_collection)
        if deploy_stage_type is not None:
            pulumi.set(__self__, "deploy_stage_type", deploy_stage_type)
        if deployment_spec_deploy_artifact_id is not None:
            pulumi.set(__self__, "deployment_spec_deploy_artifact_id", deployment_spec_deploy_artifact_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if docker_image_deploy_artifact_id is not None:
            pulumi.set(__self__, "docker_image_deploy_artifact_id", docker_image_deploy_artifact_id)
        if failure_policy is not None:
            pulumi.set(__self__, "failure_policy", failure_policy)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if function_deploy_environment_id is not None:
            pulumi.set(__self__, "function_deploy_environment_id", function_deploy_environment_id)
        if function_timeout_in_seconds is not None:
            pulumi.set(__self__, "function_timeout_in_seconds", function_timeout_in_seconds)
        if green_backend_ips is not None:
            pulumi.set(__self__, "green_backend_ips", green_backend_ips)
        if helm_chart_deploy_artifact_id is not None:
            pulumi.set(__self__, "helm_chart_deploy_artifact_id", helm_chart_deploy_artifact_id)
        if helm_command_artifact_ids is not None:
            pulumi.set(__self__, "helm_command_artifact_ids", helm_command_artifact_ids)
        if is_async is not None:
            pulumi.set(__self__, "is_async", is_async)
        if is_debug_enabled is not None:
            pulumi.set(__self__, "is_debug_enabled", is_debug_enabled)
        if is_force_enabled is not None:
            pulumi.set(__self__, "is_force_enabled", is_force_enabled)
        if is_uninstall_on_stage_delete is not None:
            pulumi.set(__self__, "is_uninstall_on_stage_delete", is_uninstall_on_stage_delete)
        if is_validation_enabled is not None:
            pulumi.set(__self__, "is_validation_enabled", is_validation_enabled)
        if kubernetes_manifest_deploy_artifact_ids is not None:
            pulumi.set(__self__, "kubernetes_manifest_deploy_artifact_ids", kubernetes_manifest_deploy_artifact_ids)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if load_balancer_config is not None:
            pulumi.set(__self__, "load_balancer_config", load_balancer_config)
        if max_history is not None:
            pulumi.set(__self__, "max_history", max_history)
        if max_memory_in_mbs is not None:
            pulumi.set(__self__, "max_memory_in_mbs", max_memory_in_mbs)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if oke_blue_green_deploy_stage_id is not None:
            pulumi.set(__self__, "oke_blue_green_deploy_stage_id", oke_blue_green_deploy_stage_id)
        if oke_canary_deploy_stage_id is not None:
            pulumi.set(__self__, "oke_canary_deploy_stage_id", oke_canary_deploy_stage_id)
        if oke_canary_traffic_shift_deploy_stage_id is not None:
            pulumi.set(__self__, "oke_canary_traffic_shift_deploy_stage_id", oke_canary_traffic_shift_deploy_stage_id)
        if oke_cluster_deploy_environment_id is not None:
            pulumi.set(__self__, "oke_cluster_deploy_environment_id", oke_cluster_deploy_environment_id)
        if production_load_balancer_config is not None:
            pulumi.set(__self__, "production_load_balancer_config", production_load_balancer_config)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if purpose is not None:
            pulumi.set(__self__, "purpose", purpose)
        if release_name is not None:
            pulumi.set(__self__, "release_name", release_name)
        if rollback_policy is not None:
            pulumi.set(__self__, "rollback_policy", rollback_policy)
        if rollout_policy is not None:
            pulumi.set(__self__, "rollout_policy", rollout_policy)
        if set_string is not None:
            pulumi.set(__self__, "set_string", set_string)
        if set_values is not None:
            pulumi.set(__self__, "set_values", set_values)
        if should_cleanup_on_fail is not None:
            pulumi.set(__self__, "should_cleanup_on_fail", should_cleanup_on_fail)
        if should_not_wait is not None:
            pulumi.set(__self__, "should_not_wait", should_not_wait)
        if should_reset_values is not None:
            pulumi.set(__self__, "should_reset_values", should_reset_values)
        if should_reuse_values is not None:
            pulumi.set(__self__, "should_reuse_values", should_reuse_values)
        if should_skip_crds is not None:
            pulumi.set(__self__, "should_skip_crds", should_skip_crds)
        if should_skip_render_subchart_notes is not None:
            pulumi.set(__self__, "should_skip_render_subchart_notes", should_skip_render_subchart_notes)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if test_load_balancer_config is not None:
            pulumi.set(__self__, "test_load_balancer_config", test_load_balancer_config)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        if traffic_shift_target is not None:
            pulumi.set(__self__, "traffic_shift_target", traffic_shift_target)
        if values_artifact_ids is not None:
            pulumi.set(__self__, "values_artifact_ids", values_artifact_ids)
        if wait_criteria is not None:
            pulumi.set(__self__, "wait_criteria", wait_criteria)

    @property
    @pulumi.getter(name="approvalPolicy")
    def approval_policy(self) -> Optional[pulumi.Input['DeployStageApprovalPolicyArgs']]:
        """
        (Updatable) Specifies the approval policy.
        """
        return pulumi.get(self, "approval_policy")

    @approval_policy.setter
    def approval_policy(self, value: Optional[pulumi.Input['DeployStageApprovalPolicyArgs']]):
        pulumi.set(self, "approval_policy", value)

    @property
    @pulumi.getter(name="areHooksEnabled")
    def are_hooks_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Disable pre/post upgrade hooks. Set to false by default.
        """
        return pulumi.get(self, "are_hooks_enabled")

    @are_hooks_enabled.setter
    def are_hooks_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "are_hooks_enabled", value)

    @property
    @pulumi.getter(name="blueBackendIps")
    def blue_backend_ips(self) -> Optional[pulumi.Input['DeployStageBlueBackendIpsArgs']]:
        """
        (Updatable) Collection of backend environment IP addresses.
        """
        return pulumi.get(self, "blue_backend_ips")

    @blue_backend_ips.setter
    def blue_backend_ips(self, value: Optional[pulumi.Input['DeployStageBlueBackendIpsArgs']]):
        pulumi.set(self, "blue_backend_ips", value)

    @property
    @pulumi.getter(name="blueGreenStrategy")
    def blue_green_strategy(self) -> Optional[pulumi.Input['DeployStageBlueGreenStrategyArgs']]:
        """
        Specifies the required blue green release strategy for OKE deployment.
        """
        return pulumi.get(self, "blue_green_strategy")

    @blue_green_strategy.setter
    def blue_green_strategy(self, value: Optional[pulumi.Input['DeployStageBlueGreenStrategyArgs']]):
        pulumi.set(self, "blue_green_strategy", value)

    @property
    @pulumi.getter(name="canaryStrategy")
    def canary_strategy(self) -> Optional[pulumi.Input['DeployStageCanaryStrategyArgs']]:
        """
        Specifies the required canary release strategy for OKE deployment.
        """
        return pulumi.get(self, "canary_strategy")

    @canary_strategy.setter
    def canary_strategy(self, value: Optional[pulumi.Input['DeployStageCanaryStrategyArgs']]):
        pulumi.set(self, "canary_strategy", value)

    @property
    @pulumi.getter(name="commandSpecDeployArtifactId")
    def command_spec_deploy_artifact_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the artifact that contains the command specification.
        """
        return pulumi.get(self, "command_spec_deploy_artifact_id")

    @command_spec_deploy_artifact_id.setter
    def command_spec_deploy_artifact_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "command_spec_deploy_artifact_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment where the ContainerInstance will be created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="computeInstanceGroupBlueGreenDeploymentDeployStageId")
    def compute_instance_group_blue_green_deployment_deploy_stage_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the upstream compute instance group blue-green deployment stage in this pipeline.
        """
        return pulumi.get(self, "compute_instance_group_blue_green_deployment_deploy_stage_id")

    @compute_instance_group_blue_green_deployment_deploy_stage_id.setter
    def compute_instance_group_blue_green_deployment_deploy_stage_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_instance_group_blue_green_deployment_deploy_stage_id", value)

    @property
    @pulumi.getter(name="computeInstanceGroupCanaryDeployStageId")
    def compute_instance_group_canary_deploy_stage_id(self) -> Optional[pulumi.Input[str]]:
        """
        A compute instance group canary stage OCID for load balancer.
        """
        return pulumi.get(self, "compute_instance_group_canary_deploy_stage_id")

    @compute_instance_group_canary_deploy_stage_id.setter
    def compute_instance_group_canary_deploy_stage_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_instance_group_canary_deploy_stage_id", value)

    @property
    @pulumi.getter(name="computeInstanceGroupCanaryTrafficShiftDeployStageId")
    def compute_instance_group_canary_traffic_shift_deploy_stage_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A compute instance group canary traffic shift stage OCID for load balancer.
        """
        return pulumi.get(self, "compute_instance_group_canary_traffic_shift_deploy_stage_id")

    @compute_instance_group_canary_traffic_shift_deploy_stage_id.setter
    def compute_instance_group_canary_traffic_shift_deploy_stage_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_instance_group_canary_traffic_shift_deploy_stage_id", value)

    @property
    @pulumi.getter(name="computeInstanceGroupDeployEnvironmentId")
    def compute_instance_group_deploy_environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A compute instance group environment OCID for rolling deployment.
        """
        return pulumi.get(self, "compute_instance_group_deploy_environment_id")

    @compute_instance_group_deploy_environment_id.setter
    def compute_instance_group_deploy_environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_instance_group_deploy_environment_id", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) User provided key and value pair configuration, which is assigned through constants or parameter.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="containerConfig")
    def container_config(self) -> Optional[pulumi.Input['DeployStageContainerConfigArgs']]:
        """
        (Updatable) Specifies the container configuration.
        """
        return pulumi.get(self, "container_config")

    @container_config.setter
    def container_config(self, value: Optional[pulumi.Input['DeployStageContainerConfigArgs']]):
        pulumi.set(self, "container_config", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deployArtifactId")
    def deploy_artifact_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Optional artifact OCID. The artifact will be included in the body for the function invocation during the stage's execution. If the DeployArtifact.argumentSubstituitionMode is set to SUBSTITUTE_PLACEHOLDERS, then the pipeline parameter values will be used to replace the placeholders in the artifact content.
        """
        return pulumi.get(self, "deploy_artifact_id")

    @deploy_artifact_id.setter
    def deploy_artifact_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deploy_artifact_id", value)

    @property
    @pulumi.getter(name="deployArtifactIds")
    def deploy_artifact_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The list of file artifact OCIDs to deploy.
        """
        return pulumi.get(self, "deploy_artifact_ids")

    @deploy_artifact_ids.setter
    def deploy_artifact_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "deploy_artifact_ids", value)

    @property
    @pulumi.getter(name="deployEnvironmentIdA")
    def deploy_environment_id_a(self) -> Optional[pulumi.Input[str]]:
        """
        First compute instance group environment OCID for deployment.
        """
        return pulumi.get(self, "deploy_environment_id_a")

    @deploy_environment_id_a.setter
    def deploy_environment_id_a(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deploy_environment_id_a", value)

    @property
    @pulumi.getter(name="deployEnvironmentIdB")
    def deploy_environment_id_b(self) -> Optional[pulumi.Input[str]]:
        """
        Second compute instance group environment OCID for deployment.
        """
        return pulumi.get(self, "deploy_environment_id_b")

    @deploy_environment_id_b.setter
    def deploy_environment_id_b(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deploy_environment_id_b", value)

    @property
    @pulumi.getter(name="deployPipelineId")
    def deploy_pipeline_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of a pipeline.
        """
        return pulumi.get(self, "deploy_pipeline_id")

    @deploy_pipeline_id.setter
    def deploy_pipeline_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deploy_pipeline_id", value)

    @property
    @pulumi.getter(name="deployStagePredecessorCollection")
    def deploy_stage_predecessor_collection(self) -> Optional[pulumi.Input['DeployStageDeployStagePredecessorCollectionArgs']]:
        """
        (Updatable) Collection containing the predecessors of a stage.
        """
        return pulumi.get(self, "deploy_stage_predecessor_collection")

    @deploy_stage_predecessor_collection.setter
    def deploy_stage_predecessor_collection(self, value: Optional[pulumi.Input['DeployStageDeployStagePredecessorCollectionArgs']]):
        pulumi.set(self, "deploy_stage_predecessor_collection", value)

    @property
    @pulumi.getter(name="deployStageType")
    def deploy_stage_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Deployment stage type.
        """
        return pulumi.get(self, "deploy_stage_type")

    @deploy_stage_type.setter
    def deploy_stage_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deploy_stage_type", value)

    @property
    @pulumi.getter(name="deploymentSpecDeployArtifactId")
    def deployment_spec_deploy_artifact_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the artifact that contains the deployment specification.
        """
        return pulumi.get(self, "deployment_spec_deploy_artifact_id")

    @deployment_spec_deploy_artifact_id.setter
    def deployment_spec_deploy_artifact_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_spec_deploy_artifact_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Optional description about the deployment stage.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Deployment stage display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="dockerImageDeployArtifactId")
    def docker_image_deploy_artifact_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A Docker image artifact OCID.
        """
        return pulumi.get(self, "docker_image_deploy_artifact_id")

    @docker_image_deploy_artifact_id.setter
    def docker_image_deploy_artifact_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "docker_image_deploy_artifact_id", value)

    @property
    @pulumi.getter(name="failurePolicy")
    def failure_policy(self) -> Optional[pulumi.Input['DeployStageFailurePolicyArgs']]:
        """
        (Updatable) Specifies a failure policy for a compute instance group rolling deployment stage.
        """
        return pulumi.get(self, "failure_policy")

    @failure_policy.setter
    def failure_policy(self, value: Optional[pulumi.Input['DeployStageFailurePolicyArgs']]):
        pulumi.set(self, "failure_policy", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="functionDeployEnvironmentId")
    def function_deploy_environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Function environment OCID.
        """
        return pulumi.get(self, "function_deploy_environment_id")

    @function_deploy_environment_id.setter
    def function_deploy_environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_deploy_environment_id", value)

    @property
    @pulumi.getter(name="functionTimeoutInSeconds")
    def function_timeout_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Timeout for execution of the Function. Value in seconds.
        """
        return pulumi.get(self, "function_timeout_in_seconds")

    @function_timeout_in_seconds.setter
    def function_timeout_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "function_timeout_in_seconds", value)

    @property
    @pulumi.getter(name="greenBackendIps")
    def green_backend_ips(self) -> Optional[pulumi.Input['DeployStageGreenBackendIpsArgs']]:
        """
        (Updatable) Collection of backend environment IP addresses.
        """
        return pulumi.get(self, "green_backend_ips")

    @green_backend_ips.setter
    def green_backend_ips(self, value: Optional[pulumi.Input['DeployStageGreenBackendIpsArgs']]):
        pulumi.set(self, "green_backend_ips", value)

    @property
    @pulumi.getter(name="helmChartDeployArtifactId")
    def helm_chart_deploy_artifact_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Helm chart artifact OCID.
        """
        return pulumi.get(self, "helm_chart_deploy_artifact_id")

    @helm_chart_deploy_artifact_id.setter
    def helm_chart_deploy_artifact_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "helm_chart_deploy_artifact_id", value)

    @property
    @pulumi.getter(name="helmCommandArtifactIds")
    def helm_command_artifact_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) List of Helm command artifact OCIDs.
        """
        return pulumi.get(self, "helm_command_artifact_ids")

    @helm_command_artifact_ids.setter
    def helm_command_artifact_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "helm_command_artifact_ids", value)

    @property
    @pulumi.getter(name="isAsync")
    def is_async(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) A boolean flag specifies whether this stage executes asynchronously.
        """
        return pulumi.get(self, "is_async")

    @is_async.setter
    def is_async(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_async", value)

    @property
    @pulumi.getter(name="isDebugEnabled")
    def is_debug_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Enables helm --debug option to stream output to tf stdout. Set to false by default.
        """
        return pulumi.get(self, "is_debug_enabled")

    @is_debug_enabled.setter
    def is_debug_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_debug_enabled", value)

    @property
    @pulumi.getter(name="isForceEnabled")
    def is_force_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Force resource update through delete; or if required, recreate. Set to false by default.
        """
        return pulumi.get(self, "is_force_enabled")

    @is_force_enabled.setter
    def is_force_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_force_enabled", value)

    @property
    @pulumi.getter(name="isUninstallOnStageDelete")
    def is_uninstall_on_stage_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Uninstall the Helm chart release on deleting the stage.
        """
        return pulumi.get(self, "is_uninstall_on_stage_delete")

    @is_uninstall_on_stage_delete.setter
    def is_uninstall_on_stage_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_uninstall_on_stage_delete", value)

    @property
    @pulumi.getter(name="isValidationEnabled")
    def is_validation_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) A boolean flag specifies whether the invoked function should be validated.
        """
        return pulumi.get(self, "is_validation_enabled")

    @is_validation_enabled.setter
    def is_validation_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_validation_enabled", value)

    @property
    @pulumi.getter(name="kubernetesManifestDeployArtifactIds")
    def kubernetes_manifest_deploy_artifact_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) List of Kubernetes manifest artifact OCIDs.
        """
        return pulumi.get(self, "kubernetes_manifest_deploy_artifact_ids")

    @kubernetes_manifest_deploy_artifact_ids.setter
    def kubernetes_manifest_deploy_artifact_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "kubernetes_manifest_deploy_artifact_ids", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="loadBalancerConfig")
    def load_balancer_config(self) -> Optional[pulumi.Input['DeployStageLoadBalancerConfigArgs']]:
        """
        (Updatable) Specifies config for load balancer traffic shift stages. The Load Balancer specified here should be an Application Load Balancer type. Network Load Balancers are not supported.
        """
        return pulumi.get(self, "load_balancer_config")

    @load_balancer_config.setter
    def load_balancer_config(self, value: Optional[pulumi.Input['DeployStageLoadBalancerConfigArgs']]):
        pulumi.set(self, "load_balancer_config", value)

    @property
    @pulumi.getter(name="maxHistory")
    def max_history(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Limit the maximum number of revisions saved per release. Use 0 for no limit. Set to 10 by default
        """
        return pulumi.get(self, "max_history")

    @max_history.setter
    def max_history(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_history", value)

    @property
    @pulumi.getter(name="maxMemoryInMbs")
    def max_memory_in_mbs(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Maximum usable memory for the Function (in MB).
        """
        return pulumi.get(self, "max_memory_in_mbs")

    @max_memory_in_mbs.setter
    def max_memory_in_mbs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_memory_in_mbs", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Default namespace to be used for Kubernetes deployment when not specified in the manifest.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="okeBlueGreenDeployStageId")
    def oke_blue_green_deploy_stage_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the upstream OKE blue-green deployment stage in this pipeline.
        """
        return pulumi.get(self, "oke_blue_green_deploy_stage_id")

    @oke_blue_green_deploy_stage_id.setter
    def oke_blue_green_deploy_stage_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oke_blue_green_deploy_stage_id", value)

    @property
    @pulumi.getter(name="okeCanaryDeployStageId")
    def oke_canary_deploy_stage_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of an upstream OKE canary deployment stage in this pipeline.
        """
        return pulumi.get(self, "oke_canary_deploy_stage_id")

    @oke_canary_deploy_stage_id.setter
    def oke_canary_deploy_stage_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oke_canary_deploy_stage_id", value)

    @property
    @pulumi.getter(name="okeCanaryTrafficShiftDeployStageId")
    def oke_canary_traffic_shift_deploy_stage_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of an upstream OKE canary deployment traffic shift stage in this pipeline.
        """
        return pulumi.get(self, "oke_canary_traffic_shift_deploy_stage_id")

    @oke_canary_traffic_shift_deploy_stage_id.setter
    def oke_canary_traffic_shift_deploy_stage_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oke_canary_traffic_shift_deploy_stage_id", value)

    @property
    @pulumi.getter(name="okeClusterDeployEnvironmentId")
    def oke_cluster_deploy_environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Kubernetes cluster environment OCID for deployment.
        """
        return pulumi.get(self, "oke_cluster_deploy_environment_id")

    @oke_cluster_deploy_environment_id.setter
    def oke_cluster_deploy_environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oke_cluster_deploy_environment_id", value)

    @property
    @pulumi.getter(name="productionLoadBalancerConfig")
    def production_load_balancer_config(self) -> Optional[pulumi.Input['DeployStageProductionLoadBalancerConfigArgs']]:
        """
        Specifies configuration for load balancer traffic shift stages. The load balancer specified here should be an Application load balancer type. Network load balancers are not supported.
        """
        return pulumi.get(self, "production_load_balancer_config")

    @production_load_balancer_config.setter
    def production_load_balancer_config(self, value: Optional[pulumi.Input['DeployStageProductionLoadBalancerConfigArgs']]):
        pulumi.set(self, "production_load_balancer_config", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of a project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def purpose(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The purpose of running this Helm stage
        """
        return pulumi.get(self, "purpose")

    @purpose.setter
    def purpose(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "purpose", value)

    @property
    @pulumi.getter(name="releaseName")
    def release_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Default name of the chart instance. Must be unique within a Kubernetes namespace.
        """
        return pulumi.get(self, "release_name")

    @release_name.setter
    def release_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "release_name", value)

    @property
    @pulumi.getter(name="rollbackPolicy")
    def rollback_policy(self) -> Optional[pulumi.Input['DeployStageRollbackPolicyArgs']]:
        """
        (Updatable) Specifies the rollback policy. This is initiated on the failure of certain stage types.
        """
        return pulumi.get(self, "rollback_policy")

    @rollback_policy.setter
    def rollback_policy(self, value: Optional[pulumi.Input['DeployStageRollbackPolicyArgs']]):
        pulumi.set(self, "rollback_policy", value)

    @property
    @pulumi.getter(name="rolloutPolicy")
    def rollout_policy(self) -> Optional[pulumi.Input['DeployStageRolloutPolicyArgs']]:
        """
        (Updatable) Description of rollout policy for load balancer traffic shift stage.
        """
        return pulumi.get(self, "rollout_policy")

    @rollout_policy.setter
    def rollout_policy(self, value: Optional[pulumi.Input['DeployStageRolloutPolicyArgs']]):
        pulumi.set(self, "rollout_policy", value)

    @property
    @pulumi.getter(name="setString")
    def set_string(self) -> Optional[pulumi.Input['DeployStageSetStringArgs']]:
        """
        (Updatable) Specifies the name and value pairs to set helm values.
        """
        return pulumi.get(self, "set_string")

    @set_string.setter
    def set_string(self, value: Optional[pulumi.Input['DeployStageSetStringArgs']]):
        pulumi.set(self, "set_string", value)

    @property
    @pulumi.getter(name="setValues")
    def set_values(self) -> Optional[pulumi.Input['DeployStageSetValuesArgs']]:
        """
        (Updatable) Specifies the name and value pairs to set helm values.
        """
        return pulumi.get(self, "set_values")

    @set_values.setter
    def set_values(self, value: Optional[pulumi.Input['DeployStageSetValuesArgs']]):
        pulumi.set(self, "set_values", value)

    @property
    @pulumi.getter(name="shouldCleanupOnFail")
    def should_cleanup_on_fail(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Allow deletion of new resources created during when an upgrade fails. Set to false by default.
        """
        return pulumi.get(self, "should_cleanup_on_fail")

    @should_cleanup_on_fail.setter
    def should_cleanup_on_fail(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "should_cleanup_on_fail", value)

    @property
    @pulumi.getter(name="shouldNotWait")
    def should_not_wait(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Does not wait until all the resources are in a ready state to mark the release as successful if set to true. Set to false by default.
        """
        return pulumi.get(self, "should_not_wait")

    @should_not_wait.setter
    def should_not_wait(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "should_not_wait", value)

    @property
    @pulumi.getter(name="shouldResetValues")
    def should_reset_values(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) During upgrade, reset the values to the ones built into the chart. It overrides shouldReuseValues. Set to false by default.
        """
        return pulumi.get(self, "should_reset_values")

    @should_reset_values.setter
    def should_reset_values(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "should_reset_values", value)

    @property
    @pulumi.getter(name="shouldReuseValues")
    def should_reuse_values(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) During upgrade, reuse the values of the last release and merge overrides from the command line. Set to false by default.
        """
        return pulumi.get(self, "should_reuse_values")

    @should_reuse_values.setter
    def should_reuse_values(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "should_reuse_values", value)

    @property
    @pulumi.getter(name="shouldSkipCrds")
    def should_skip_crds(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If set, no CRDs are installed. By default, CRDs are installed only if they are not present already. Set to false by default.
        """
        return pulumi.get(self, "should_skip_crds")

    @should_skip_crds.setter
    def should_skip_crds(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "should_skip_crds", value)

    @property
    @pulumi.getter(name="shouldSkipRenderSubchartNotes")
    def should_skip_render_subchart_notes(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If set, renders subchart notes along with the parent. Set to false by default.
        """
        return pulumi.get(self, "should_skip_render_subchart_notes")

    @should_skip_render_subchart_notes.setter
    def should_skip_render_subchart_notes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "should_skip_render_subchart_notes", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the deployment stage.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="testLoadBalancerConfig")
    def test_load_balancer_config(self) -> Optional[pulumi.Input['DeployStageTestLoadBalancerConfigArgs']]:
        """
        (Updatable) Specifies configuration for load balancer traffic shift stages. The load balancer specified here should be an Application load balancer type. Network load balancers are not supported.
        """
        return pulumi.get(self, "test_load_balancer_config")

    @test_load_balancer_config.setter
    def test_load_balancer_config(self, value: Optional[pulumi.Input['DeployStageTestLoadBalancerConfigArgs']]):
        pulumi.set(self, "test_load_balancer_config", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        Time the deployment stage was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        Time the deployment stage was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Time to wait for execution of a Shell/Helm stage. Defaults to 36000 seconds for Shell and 300 seconds for Helm Stage
        """
        return pulumi.get(self, "timeout_in_seconds")

    @timeout_in_seconds.setter
    def timeout_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_in_seconds", value)

    @property
    @pulumi.getter(name="trafficShiftTarget")
    def traffic_shift_target(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specifies the target or destination backend set.
        """
        return pulumi.get(self, "traffic_shift_target")

    @traffic_shift_target.setter
    def traffic_shift_target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "traffic_shift_target", value)

    @property
    @pulumi.getter(name="valuesArtifactIds")
    def values_artifact_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) List of values.yaml file artifact OCIDs.
        """
        return pulumi.get(self, "values_artifact_ids")

    @values_artifact_ids.setter
    def values_artifact_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values_artifact_ids", value)

    @property
    @pulumi.getter(name="waitCriteria")
    def wait_criteria(self) -> Optional[pulumi.Input['DeployStageWaitCriteriaArgs']]:
        """
        (Updatable) Specifies wait criteria for the Wait stage.
        """
        return pulumi.get(self, "wait_criteria")

    @wait_criteria.setter
    def wait_criteria(self, value: Optional[pulumi.Input['DeployStageWaitCriteriaArgs']]):
        pulumi.set(self, "wait_criteria", value)


class DeployStage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approval_policy: Optional[pulumi.Input[pulumi.InputType['DeployStageApprovalPolicyArgs']]] = None,
                 are_hooks_enabled: Optional[pulumi.Input[bool]] = None,
                 blue_backend_ips: Optional[pulumi.Input[pulumi.InputType['DeployStageBlueBackendIpsArgs']]] = None,
                 blue_green_strategy: Optional[pulumi.Input[pulumi.InputType['DeployStageBlueGreenStrategyArgs']]] = None,
                 canary_strategy: Optional[pulumi.Input[pulumi.InputType['DeployStageCanaryStrategyArgs']]] = None,
                 command_spec_deploy_artifact_id: Optional[pulumi.Input[str]] = None,
                 compute_instance_group_blue_green_deployment_deploy_stage_id: Optional[pulumi.Input[str]] = None,
                 compute_instance_group_canary_deploy_stage_id: Optional[pulumi.Input[str]] = None,
                 compute_instance_group_canary_traffic_shift_deploy_stage_id: Optional[pulumi.Input[str]] = None,
                 compute_instance_group_deploy_environment_id: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 container_config: Optional[pulumi.Input[pulumi.InputType['DeployStageContainerConfigArgs']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deploy_artifact_id: Optional[pulumi.Input[str]] = None,
                 deploy_artifact_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 deploy_environment_id_a: Optional[pulumi.Input[str]] = None,
                 deploy_environment_id_b: Optional[pulumi.Input[str]] = None,
                 deploy_pipeline_id: Optional[pulumi.Input[str]] = None,
                 deploy_stage_predecessor_collection: Optional[pulumi.Input[pulumi.InputType['DeployStageDeployStagePredecessorCollectionArgs']]] = None,
                 deploy_stage_type: Optional[pulumi.Input[str]] = None,
                 deployment_spec_deploy_artifact_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 docker_image_deploy_artifact_id: Optional[pulumi.Input[str]] = None,
                 failure_policy: Optional[pulumi.Input[pulumi.InputType['DeployStageFailurePolicyArgs']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 function_deploy_environment_id: Optional[pulumi.Input[str]] = None,
                 function_timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 green_backend_ips: Optional[pulumi.Input[pulumi.InputType['DeployStageGreenBackendIpsArgs']]] = None,
                 helm_chart_deploy_artifact_id: Optional[pulumi.Input[str]] = None,
                 helm_command_artifact_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_async: Optional[pulumi.Input[bool]] = None,
                 is_debug_enabled: Optional[pulumi.Input[bool]] = None,
                 is_force_enabled: Optional[pulumi.Input[bool]] = None,
                 is_uninstall_on_stage_delete: Optional[pulumi.Input[bool]] = None,
                 is_validation_enabled: Optional[pulumi.Input[bool]] = None,
                 kubernetes_manifest_deploy_artifact_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 load_balancer_config: Optional[pulumi.Input[pulumi.InputType['DeployStageLoadBalancerConfigArgs']]] = None,
                 max_history: Optional[pulumi.Input[int]] = None,
                 max_memory_in_mbs: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 oke_blue_green_deploy_stage_id: Optional[pulumi.Input[str]] = None,
                 oke_canary_deploy_stage_id: Optional[pulumi.Input[str]] = None,
                 oke_canary_traffic_shift_deploy_stage_id: Optional[pulumi.Input[str]] = None,
                 oke_cluster_deploy_environment_id: Optional[pulumi.Input[str]] = None,
                 production_load_balancer_config: Optional[pulumi.Input[pulumi.InputType['DeployStageProductionLoadBalancerConfigArgs']]] = None,
                 purpose: Optional[pulumi.Input[str]] = None,
                 release_name: Optional[pulumi.Input[str]] = None,
                 rollback_policy: Optional[pulumi.Input[pulumi.InputType['DeployStageRollbackPolicyArgs']]] = None,
                 rollout_policy: Optional[pulumi.Input[pulumi.InputType['DeployStageRolloutPolicyArgs']]] = None,
                 set_string: Optional[pulumi.Input[pulumi.InputType['DeployStageSetStringArgs']]] = None,
                 set_values: Optional[pulumi.Input[pulumi.InputType['DeployStageSetValuesArgs']]] = None,
                 should_cleanup_on_fail: Optional[pulumi.Input[bool]] = None,
                 should_not_wait: Optional[pulumi.Input[bool]] = None,
                 should_reset_values: Optional[pulumi.Input[bool]] = None,
                 should_reuse_values: Optional[pulumi.Input[bool]] = None,
                 should_skip_crds: Optional[pulumi.Input[bool]] = None,
                 should_skip_render_subchart_notes: Optional[pulumi.Input[bool]] = None,
                 test_load_balancer_config: Optional[pulumi.Input[pulumi.InputType['DeployStageTestLoadBalancerConfigArgs']]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 traffic_shift_target: Optional[pulumi.Input[str]] = None,
                 values_artifact_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 wait_criteria: Optional[pulumi.Input[pulumi.InputType['DeployStageWaitCriteriaArgs']]] = None,
                 __props__=None):
        """
        This resource provides the Deploy Stage resource in Oracle Cloud Infrastructure Devops service.

        Creates a new deployment stage.

        ## Import

        DeployStages can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DevOps/deployStage:DeployStage test_deploy_stage "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['DeployStageApprovalPolicyArgs']] approval_policy: (Updatable) Specifies the approval policy.
        :param pulumi.Input[bool] are_hooks_enabled: (Updatable) Disable pre/post upgrade hooks. Set to false by default.
        :param pulumi.Input[pulumi.InputType['DeployStageBlueBackendIpsArgs']] blue_backend_ips: (Updatable) Collection of backend environment IP addresses.
        :param pulumi.Input[pulumi.InputType['DeployStageBlueGreenStrategyArgs']] blue_green_strategy: Specifies the required blue green release strategy for OKE deployment.
        :param pulumi.Input[pulumi.InputType['DeployStageCanaryStrategyArgs']] canary_strategy: Specifies the required canary release strategy for OKE deployment.
        :param pulumi.Input[str] command_spec_deploy_artifact_id: (Updatable) The OCID of the artifact that contains the command specification.
        :param pulumi.Input[str] compute_instance_group_blue_green_deployment_deploy_stage_id: The OCID of the upstream compute instance group blue-green deployment stage in this pipeline.
        :param pulumi.Input[str] compute_instance_group_canary_deploy_stage_id: A compute instance group canary stage OCID for load balancer.
        :param pulumi.Input[str] compute_instance_group_canary_traffic_shift_deploy_stage_id: (Updatable) A compute instance group canary traffic shift stage OCID for load balancer.
        :param pulumi.Input[str] compute_instance_group_deploy_environment_id: (Updatable) A compute instance group environment OCID for rolling deployment.
        :param pulumi.Input[Mapping[str, Any]] config: (Updatable) User provided key and value pair configuration, which is assigned through constants or parameter.
        :param pulumi.Input[pulumi.InputType['DeployStageContainerConfigArgs']] container_config: (Updatable) Specifies the container configuration.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] deploy_artifact_id: (Updatable) Optional artifact OCID. The artifact will be included in the body for the function invocation during the stage's execution. If the DeployArtifact.argumentSubstituitionMode is set to SUBSTITUTE_PLACEHOLDERS, then the pipeline parameter values will be used to replace the placeholders in the artifact content.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] deploy_artifact_ids: (Updatable) The list of file artifact OCIDs to deploy.
        :param pulumi.Input[str] deploy_environment_id_a: First compute instance group environment OCID for deployment.
        :param pulumi.Input[str] deploy_environment_id_b: Second compute instance group environment OCID for deployment.
        :param pulumi.Input[str] deploy_pipeline_id: The OCID of a pipeline.
        :param pulumi.Input[pulumi.InputType['DeployStageDeployStagePredecessorCollectionArgs']] deploy_stage_predecessor_collection: (Updatable) Collection containing the predecessors of a stage.
        :param pulumi.Input[str] deploy_stage_type: (Updatable) Deployment stage type.
        :param pulumi.Input[str] deployment_spec_deploy_artifact_id: (Updatable) The OCID of the artifact that contains the deployment specification.
        :param pulumi.Input[str] description: (Updatable) Optional description about the deployment stage.
        :param pulumi.Input[str] display_name: (Updatable) Deployment stage display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        :param pulumi.Input[str] docker_image_deploy_artifact_id: (Updatable) A Docker image artifact OCID.
        :param pulumi.Input[pulumi.InputType['DeployStageFailurePolicyArgs']] failure_policy: (Updatable) Specifies a failure policy for a compute instance group rolling deployment stage.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] function_deploy_environment_id: (Updatable) Function environment OCID.
        :param pulumi.Input[int] function_timeout_in_seconds: (Updatable) Timeout for execution of the Function. Value in seconds.
        :param pulumi.Input[pulumi.InputType['DeployStageGreenBackendIpsArgs']] green_backend_ips: (Updatable) Collection of backend environment IP addresses.
        :param pulumi.Input[str] helm_chart_deploy_artifact_id: (Updatable) Helm chart artifact OCID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] helm_command_artifact_ids: (Updatable) List of Helm command artifact OCIDs.
        :param pulumi.Input[bool] is_async: (Updatable) A boolean flag specifies whether this stage executes asynchronously.
        :param pulumi.Input[bool] is_debug_enabled: (Updatable) Enables helm --debug option to stream output to tf stdout. Set to false by default.
        :param pulumi.Input[bool] is_force_enabled: (Updatable) Force resource update through delete; or if required, recreate. Set to false by default.
        :param pulumi.Input[bool] is_uninstall_on_stage_delete: (Updatable) Uninstall the Helm chart release on deleting the stage.
        :param pulumi.Input[bool] is_validation_enabled: (Updatable) A boolean flag specifies whether the invoked function should be validated.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] kubernetes_manifest_deploy_artifact_ids: (Updatable) List of Kubernetes manifest artifact OCIDs.
        :param pulumi.Input[pulumi.InputType['DeployStageLoadBalancerConfigArgs']] load_balancer_config: (Updatable) Specifies config for load balancer traffic shift stages. The Load Balancer specified here should be an Application Load Balancer type. Network Load Balancers are not supported.
        :param pulumi.Input[int] max_history: (Updatable) Limit the maximum number of revisions saved per release. Use 0 for no limit. Set to 10 by default
        :param pulumi.Input[str] max_memory_in_mbs: (Updatable) Maximum usable memory for the Function (in MB).
        :param pulumi.Input[str] namespace: (Updatable) Default namespace to be used for Kubernetes deployment when not specified in the manifest.
        :param pulumi.Input[str] oke_blue_green_deploy_stage_id: The OCID of the upstream OKE blue-green deployment stage in this pipeline.
        :param pulumi.Input[str] oke_canary_deploy_stage_id: The OCID of an upstream OKE canary deployment stage in this pipeline.
        :param pulumi.Input[str] oke_canary_traffic_shift_deploy_stage_id: The OCID of an upstream OKE canary deployment traffic shift stage in this pipeline.
        :param pulumi.Input[str] oke_cluster_deploy_environment_id: (Updatable) Kubernetes cluster environment OCID for deployment.
        :param pulumi.Input[pulumi.InputType['DeployStageProductionLoadBalancerConfigArgs']] production_load_balancer_config: Specifies configuration for load balancer traffic shift stages. The load balancer specified here should be an Application load balancer type. Network load balancers are not supported.
        :param pulumi.Input[str] purpose: (Updatable) The purpose of running this Helm stage
        :param pulumi.Input[str] release_name: (Updatable) Default name of the chart instance. Must be unique within a Kubernetes namespace.
        :param pulumi.Input[pulumi.InputType['DeployStageRollbackPolicyArgs']] rollback_policy: (Updatable) Specifies the rollback policy. This is initiated on the failure of certain stage types.
        :param pulumi.Input[pulumi.InputType['DeployStageRolloutPolicyArgs']] rollout_policy: (Updatable) Description of rollout policy for load balancer traffic shift stage.
        :param pulumi.Input[pulumi.InputType['DeployStageSetStringArgs']] set_string: (Updatable) Specifies the name and value pairs to set helm values.
        :param pulumi.Input[pulumi.InputType['DeployStageSetValuesArgs']] set_values: (Updatable) Specifies the name and value pairs to set helm values.
        :param pulumi.Input[bool] should_cleanup_on_fail: (Updatable) Allow deletion of new resources created during when an upgrade fails. Set to false by default.
        :param pulumi.Input[bool] should_not_wait: (Updatable) Does not wait until all the resources are in a ready state to mark the release as successful if set to true. Set to false by default.
        :param pulumi.Input[bool] should_reset_values: (Updatable) During upgrade, reset the values to the ones built into the chart. It overrides shouldReuseValues. Set to false by default.
        :param pulumi.Input[bool] should_reuse_values: (Updatable) During upgrade, reuse the values of the last release and merge overrides from the command line. Set to false by default.
        :param pulumi.Input[bool] should_skip_crds: (Updatable) If set, no CRDs are installed. By default, CRDs are installed only if they are not present already. Set to false by default.
        :param pulumi.Input[bool] should_skip_render_subchart_notes: (Updatable) If set, renders subchart notes along with the parent. Set to false by default.
        :param pulumi.Input[pulumi.InputType['DeployStageTestLoadBalancerConfigArgs']] test_load_balancer_config: (Updatable) Specifies configuration for load balancer traffic shift stages. The load balancer specified here should be an Application load balancer type. Network load balancers are not supported.
        :param pulumi.Input[int] timeout_in_seconds: (Updatable) Time to wait for execution of a Shell/Helm stage. Defaults to 36000 seconds for Shell and 300 seconds for Helm Stage
        :param pulumi.Input[str] traffic_shift_target: (Updatable) Specifies the target or destination backend set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values_artifact_ids: (Updatable) List of values.yaml file artifact OCIDs.
        :param pulumi.Input[pulumi.InputType['DeployStageWaitCriteriaArgs']] wait_criteria: (Updatable) Specifies wait criteria for the Wait stage.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeployStageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Deploy Stage resource in Oracle Cloud Infrastructure Devops service.

        Creates a new deployment stage.

        ## Import

        DeployStages can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DevOps/deployStage:DeployStage test_deploy_stage "id"
        ```

        :param str resource_name: The name of the resource.
        :param DeployStageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeployStageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approval_policy: Optional[pulumi.Input[pulumi.InputType['DeployStageApprovalPolicyArgs']]] = None,
                 are_hooks_enabled: Optional[pulumi.Input[bool]] = None,
                 blue_backend_ips: Optional[pulumi.Input[pulumi.InputType['DeployStageBlueBackendIpsArgs']]] = None,
                 blue_green_strategy: Optional[pulumi.Input[pulumi.InputType['DeployStageBlueGreenStrategyArgs']]] = None,
                 canary_strategy: Optional[pulumi.Input[pulumi.InputType['DeployStageCanaryStrategyArgs']]] = None,
                 command_spec_deploy_artifact_id: Optional[pulumi.Input[str]] = None,
                 compute_instance_group_blue_green_deployment_deploy_stage_id: Optional[pulumi.Input[str]] = None,
                 compute_instance_group_canary_deploy_stage_id: Optional[pulumi.Input[str]] = None,
                 compute_instance_group_canary_traffic_shift_deploy_stage_id: Optional[pulumi.Input[str]] = None,
                 compute_instance_group_deploy_environment_id: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 container_config: Optional[pulumi.Input[pulumi.InputType['DeployStageContainerConfigArgs']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deploy_artifact_id: Optional[pulumi.Input[str]] = None,
                 deploy_artifact_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 deploy_environment_id_a: Optional[pulumi.Input[str]] = None,
                 deploy_environment_id_b: Optional[pulumi.Input[str]] = None,
                 deploy_pipeline_id: Optional[pulumi.Input[str]] = None,
                 deploy_stage_predecessor_collection: Optional[pulumi.Input[pulumi.InputType['DeployStageDeployStagePredecessorCollectionArgs']]] = None,
                 deploy_stage_type: Optional[pulumi.Input[str]] = None,
                 deployment_spec_deploy_artifact_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 docker_image_deploy_artifact_id: Optional[pulumi.Input[str]] = None,
                 failure_policy: Optional[pulumi.Input[pulumi.InputType['DeployStageFailurePolicyArgs']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 function_deploy_environment_id: Optional[pulumi.Input[str]] = None,
                 function_timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 green_backend_ips: Optional[pulumi.Input[pulumi.InputType['DeployStageGreenBackendIpsArgs']]] = None,
                 helm_chart_deploy_artifact_id: Optional[pulumi.Input[str]] = None,
                 helm_command_artifact_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_async: Optional[pulumi.Input[bool]] = None,
                 is_debug_enabled: Optional[pulumi.Input[bool]] = None,
                 is_force_enabled: Optional[pulumi.Input[bool]] = None,
                 is_uninstall_on_stage_delete: Optional[pulumi.Input[bool]] = None,
                 is_validation_enabled: Optional[pulumi.Input[bool]] = None,
                 kubernetes_manifest_deploy_artifact_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 load_balancer_config: Optional[pulumi.Input[pulumi.InputType['DeployStageLoadBalancerConfigArgs']]] = None,
                 max_history: Optional[pulumi.Input[int]] = None,
                 max_memory_in_mbs: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 oke_blue_green_deploy_stage_id: Optional[pulumi.Input[str]] = None,
                 oke_canary_deploy_stage_id: Optional[pulumi.Input[str]] = None,
                 oke_canary_traffic_shift_deploy_stage_id: Optional[pulumi.Input[str]] = None,
                 oke_cluster_deploy_environment_id: Optional[pulumi.Input[str]] = None,
                 production_load_balancer_config: Optional[pulumi.Input[pulumi.InputType['DeployStageProductionLoadBalancerConfigArgs']]] = None,
                 purpose: Optional[pulumi.Input[str]] = None,
                 release_name: Optional[pulumi.Input[str]] = None,
                 rollback_policy: Optional[pulumi.Input[pulumi.InputType['DeployStageRollbackPolicyArgs']]] = None,
                 rollout_policy: Optional[pulumi.Input[pulumi.InputType['DeployStageRolloutPolicyArgs']]] = None,
                 set_string: Optional[pulumi.Input[pulumi.InputType['DeployStageSetStringArgs']]] = None,
                 set_values: Optional[pulumi.Input[pulumi.InputType['DeployStageSetValuesArgs']]] = None,
                 should_cleanup_on_fail: Optional[pulumi.Input[bool]] = None,
                 should_not_wait: Optional[pulumi.Input[bool]] = None,
                 should_reset_values: Optional[pulumi.Input[bool]] = None,
                 should_reuse_values: Optional[pulumi.Input[bool]] = None,
                 should_skip_crds: Optional[pulumi.Input[bool]] = None,
                 should_skip_render_subchart_notes: Optional[pulumi.Input[bool]] = None,
                 test_load_balancer_config: Optional[pulumi.Input[pulumi.InputType['DeployStageTestLoadBalancerConfigArgs']]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 traffic_shift_target: Optional[pulumi.Input[str]] = None,
                 values_artifact_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 wait_criteria: Optional[pulumi.Input[pulumi.InputType['DeployStageWaitCriteriaArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeployStageArgs.__new__(DeployStageArgs)

            __props__.__dict__["approval_policy"] = approval_policy
            __props__.__dict__["are_hooks_enabled"] = are_hooks_enabled
            __props__.__dict__["blue_backend_ips"] = blue_backend_ips
            __props__.__dict__["blue_green_strategy"] = blue_green_strategy
            __props__.__dict__["canary_strategy"] = canary_strategy
            __props__.__dict__["command_spec_deploy_artifact_id"] = command_spec_deploy_artifact_id
            __props__.__dict__["compute_instance_group_blue_green_deployment_deploy_stage_id"] = compute_instance_group_blue_green_deployment_deploy_stage_id
            __props__.__dict__["compute_instance_group_canary_deploy_stage_id"] = compute_instance_group_canary_deploy_stage_id
            __props__.__dict__["compute_instance_group_canary_traffic_shift_deploy_stage_id"] = compute_instance_group_canary_traffic_shift_deploy_stage_id
            __props__.__dict__["compute_instance_group_deploy_environment_id"] = compute_instance_group_deploy_environment_id
            __props__.__dict__["config"] = config
            __props__.__dict__["container_config"] = container_config
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["deploy_artifact_id"] = deploy_artifact_id
            __props__.__dict__["deploy_artifact_ids"] = deploy_artifact_ids
            __props__.__dict__["deploy_environment_id_a"] = deploy_environment_id_a
            __props__.__dict__["deploy_environment_id_b"] = deploy_environment_id_b
            if deploy_pipeline_id is None and not opts.urn:
                raise TypeError("Missing required property 'deploy_pipeline_id'")
            __props__.__dict__["deploy_pipeline_id"] = deploy_pipeline_id
            if deploy_stage_predecessor_collection is None and not opts.urn:
                raise TypeError("Missing required property 'deploy_stage_predecessor_collection'")
            __props__.__dict__["deploy_stage_predecessor_collection"] = deploy_stage_predecessor_collection
            if deploy_stage_type is None and not opts.urn:
                raise TypeError("Missing required property 'deploy_stage_type'")
            __props__.__dict__["deploy_stage_type"] = deploy_stage_type
            __props__.__dict__["deployment_spec_deploy_artifact_id"] = deployment_spec_deploy_artifact_id
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["docker_image_deploy_artifact_id"] = docker_image_deploy_artifact_id
            __props__.__dict__["failure_policy"] = failure_policy
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["function_deploy_environment_id"] = function_deploy_environment_id
            __props__.__dict__["function_timeout_in_seconds"] = function_timeout_in_seconds
            __props__.__dict__["green_backend_ips"] = green_backend_ips
            __props__.__dict__["helm_chart_deploy_artifact_id"] = helm_chart_deploy_artifact_id
            __props__.__dict__["helm_command_artifact_ids"] = helm_command_artifact_ids
            __props__.__dict__["is_async"] = is_async
            __props__.__dict__["is_debug_enabled"] = is_debug_enabled
            __props__.__dict__["is_force_enabled"] = is_force_enabled
            __props__.__dict__["is_uninstall_on_stage_delete"] = is_uninstall_on_stage_delete
            __props__.__dict__["is_validation_enabled"] = is_validation_enabled
            __props__.__dict__["kubernetes_manifest_deploy_artifact_ids"] = kubernetes_manifest_deploy_artifact_ids
            __props__.__dict__["load_balancer_config"] = load_balancer_config
            __props__.__dict__["max_history"] = max_history
            __props__.__dict__["max_memory_in_mbs"] = max_memory_in_mbs
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["oke_blue_green_deploy_stage_id"] = oke_blue_green_deploy_stage_id
            __props__.__dict__["oke_canary_deploy_stage_id"] = oke_canary_deploy_stage_id
            __props__.__dict__["oke_canary_traffic_shift_deploy_stage_id"] = oke_canary_traffic_shift_deploy_stage_id
            __props__.__dict__["oke_cluster_deploy_environment_id"] = oke_cluster_deploy_environment_id
            __props__.__dict__["production_load_balancer_config"] = production_load_balancer_config
            __props__.__dict__["purpose"] = purpose
            __props__.__dict__["release_name"] = release_name
            __props__.__dict__["rollback_policy"] = rollback_policy
            __props__.__dict__["rollout_policy"] = rollout_policy
            __props__.__dict__["set_string"] = set_string
            __props__.__dict__["set_values"] = set_values
            __props__.__dict__["should_cleanup_on_fail"] = should_cleanup_on_fail
            __props__.__dict__["should_not_wait"] = should_not_wait
            __props__.__dict__["should_reset_values"] = should_reset_values
            __props__.__dict__["should_reuse_values"] = should_reuse_values
            __props__.__dict__["should_skip_crds"] = should_skip_crds
            __props__.__dict__["should_skip_render_subchart_notes"] = should_skip_render_subchart_notes
            __props__.__dict__["test_load_balancer_config"] = test_load_balancer_config
            __props__.__dict__["timeout_in_seconds"] = timeout_in_seconds
            __props__.__dict__["traffic_shift_target"] = traffic_shift_target
            __props__.__dict__["values_artifact_ids"] = values_artifact_ids
            __props__.__dict__["wait_criteria"] = wait_criteria
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["project_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(DeployStage, __self__).__init__(
            'oci:DevOps/deployStage:DeployStage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            approval_policy: Optional[pulumi.Input[pulumi.InputType['DeployStageApprovalPolicyArgs']]] = None,
            are_hooks_enabled: Optional[pulumi.Input[bool]] = None,
            blue_backend_ips: Optional[pulumi.Input[pulumi.InputType['DeployStageBlueBackendIpsArgs']]] = None,
            blue_green_strategy: Optional[pulumi.Input[pulumi.InputType['DeployStageBlueGreenStrategyArgs']]] = None,
            canary_strategy: Optional[pulumi.Input[pulumi.InputType['DeployStageCanaryStrategyArgs']]] = None,
            command_spec_deploy_artifact_id: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            compute_instance_group_blue_green_deployment_deploy_stage_id: Optional[pulumi.Input[str]] = None,
            compute_instance_group_canary_deploy_stage_id: Optional[pulumi.Input[str]] = None,
            compute_instance_group_canary_traffic_shift_deploy_stage_id: Optional[pulumi.Input[str]] = None,
            compute_instance_group_deploy_environment_id: Optional[pulumi.Input[str]] = None,
            config: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            container_config: Optional[pulumi.Input[pulumi.InputType['DeployStageContainerConfigArgs']]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            deploy_artifact_id: Optional[pulumi.Input[str]] = None,
            deploy_artifact_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            deploy_environment_id_a: Optional[pulumi.Input[str]] = None,
            deploy_environment_id_b: Optional[pulumi.Input[str]] = None,
            deploy_pipeline_id: Optional[pulumi.Input[str]] = None,
            deploy_stage_predecessor_collection: Optional[pulumi.Input[pulumi.InputType['DeployStageDeployStagePredecessorCollectionArgs']]] = None,
            deploy_stage_type: Optional[pulumi.Input[str]] = None,
            deployment_spec_deploy_artifact_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            docker_image_deploy_artifact_id: Optional[pulumi.Input[str]] = None,
            failure_policy: Optional[pulumi.Input[pulumi.InputType['DeployStageFailurePolicyArgs']]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            function_deploy_environment_id: Optional[pulumi.Input[str]] = None,
            function_timeout_in_seconds: Optional[pulumi.Input[int]] = None,
            green_backend_ips: Optional[pulumi.Input[pulumi.InputType['DeployStageGreenBackendIpsArgs']]] = None,
            helm_chart_deploy_artifact_id: Optional[pulumi.Input[str]] = None,
            helm_command_artifact_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            is_async: Optional[pulumi.Input[bool]] = None,
            is_debug_enabled: Optional[pulumi.Input[bool]] = None,
            is_force_enabled: Optional[pulumi.Input[bool]] = None,
            is_uninstall_on_stage_delete: Optional[pulumi.Input[bool]] = None,
            is_validation_enabled: Optional[pulumi.Input[bool]] = None,
            kubernetes_manifest_deploy_artifact_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            load_balancer_config: Optional[pulumi.Input[pulumi.InputType['DeployStageLoadBalancerConfigArgs']]] = None,
            max_history: Optional[pulumi.Input[int]] = None,
            max_memory_in_mbs: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            oke_blue_green_deploy_stage_id: Optional[pulumi.Input[str]] = None,
            oke_canary_deploy_stage_id: Optional[pulumi.Input[str]] = None,
            oke_canary_traffic_shift_deploy_stage_id: Optional[pulumi.Input[str]] = None,
            oke_cluster_deploy_environment_id: Optional[pulumi.Input[str]] = None,
            production_load_balancer_config: Optional[pulumi.Input[pulumi.InputType['DeployStageProductionLoadBalancerConfigArgs']]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            purpose: Optional[pulumi.Input[str]] = None,
            release_name: Optional[pulumi.Input[str]] = None,
            rollback_policy: Optional[pulumi.Input[pulumi.InputType['DeployStageRollbackPolicyArgs']]] = None,
            rollout_policy: Optional[pulumi.Input[pulumi.InputType['DeployStageRolloutPolicyArgs']]] = None,
            set_string: Optional[pulumi.Input[pulumi.InputType['DeployStageSetStringArgs']]] = None,
            set_values: Optional[pulumi.Input[pulumi.InputType['DeployStageSetValuesArgs']]] = None,
            should_cleanup_on_fail: Optional[pulumi.Input[bool]] = None,
            should_not_wait: Optional[pulumi.Input[bool]] = None,
            should_reset_values: Optional[pulumi.Input[bool]] = None,
            should_reuse_values: Optional[pulumi.Input[bool]] = None,
            should_skip_crds: Optional[pulumi.Input[bool]] = None,
            should_skip_render_subchart_notes: Optional[pulumi.Input[bool]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            test_load_balancer_config: Optional[pulumi.Input[pulumi.InputType['DeployStageTestLoadBalancerConfigArgs']]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            timeout_in_seconds: Optional[pulumi.Input[int]] = None,
            traffic_shift_target: Optional[pulumi.Input[str]] = None,
            values_artifact_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            wait_criteria: Optional[pulumi.Input[pulumi.InputType['DeployStageWaitCriteriaArgs']]] = None) -> 'DeployStage':
        """
        Get an existing DeployStage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['DeployStageApprovalPolicyArgs']] approval_policy: (Updatable) Specifies the approval policy.
        :param pulumi.Input[bool] are_hooks_enabled: (Updatable) Disable pre/post upgrade hooks. Set to false by default.
        :param pulumi.Input[pulumi.InputType['DeployStageBlueBackendIpsArgs']] blue_backend_ips: (Updatable) Collection of backend environment IP addresses.
        :param pulumi.Input[pulumi.InputType['DeployStageBlueGreenStrategyArgs']] blue_green_strategy: Specifies the required blue green release strategy for OKE deployment.
        :param pulumi.Input[pulumi.InputType['DeployStageCanaryStrategyArgs']] canary_strategy: Specifies the required canary release strategy for OKE deployment.
        :param pulumi.Input[str] command_spec_deploy_artifact_id: (Updatable) The OCID of the artifact that contains the command specification.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment where the ContainerInstance will be created.
        :param pulumi.Input[str] compute_instance_group_blue_green_deployment_deploy_stage_id: The OCID of the upstream compute instance group blue-green deployment stage in this pipeline.
        :param pulumi.Input[str] compute_instance_group_canary_deploy_stage_id: A compute instance group canary stage OCID for load balancer.
        :param pulumi.Input[str] compute_instance_group_canary_traffic_shift_deploy_stage_id: (Updatable) A compute instance group canary traffic shift stage OCID for load balancer.
        :param pulumi.Input[str] compute_instance_group_deploy_environment_id: (Updatable) A compute instance group environment OCID for rolling deployment.
        :param pulumi.Input[Mapping[str, Any]] config: (Updatable) User provided key and value pair configuration, which is assigned through constants or parameter.
        :param pulumi.Input[pulumi.InputType['DeployStageContainerConfigArgs']] container_config: (Updatable) Specifies the container configuration.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] deploy_artifact_id: (Updatable) Optional artifact OCID. The artifact will be included in the body for the function invocation during the stage's execution. If the DeployArtifact.argumentSubstituitionMode is set to SUBSTITUTE_PLACEHOLDERS, then the pipeline parameter values will be used to replace the placeholders in the artifact content.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] deploy_artifact_ids: (Updatable) The list of file artifact OCIDs to deploy.
        :param pulumi.Input[str] deploy_environment_id_a: First compute instance group environment OCID for deployment.
        :param pulumi.Input[str] deploy_environment_id_b: Second compute instance group environment OCID for deployment.
        :param pulumi.Input[str] deploy_pipeline_id: The OCID of a pipeline.
        :param pulumi.Input[pulumi.InputType['DeployStageDeployStagePredecessorCollectionArgs']] deploy_stage_predecessor_collection: (Updatable) Collection containing the predecessors of a stage.
        :param pulumi.Input[str] deploy_stage_type: (Updatable) Deployment stage type.
        :param pulumi.Input[str] deployment_spec_deploy_artifact_id: (Updatable) The OCID of the artifact that contains the deployment specification.
        :param pulumi.Input[str] description: (Updatable) Optional description about the deployment stage.
        :param pulumi.Input[str] display_name: (Updatable) Deployment stage display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        :param pulumi.Input[str] docker_image_deploy_artifact_id: (Updatable) A Docker image artifact OCID.
        :param pulumi.Input[pulumi.InputType['DeployStageFailurePolicyArgs']] failure_policy: (Updatable) Specifies a failure policy for a compute instance group rolling deployment stage.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] function_deploy_environment_id: (Updatable) Function environment OCID.
        :param pulumi.Input[int] function_timeout_in_seconds: (Updatable) Timeout for execution of the Function. Value in seconds.
        :param pulumi.Input[pulumi.InputType['DeployStageGreenBackendIpsArgs']] green_backend_ips: (Updatable) Collection of backend environment IP addresses.
        :param pulumi.Input[str] helm_chart_deploy_artifact_id: (Updatable) Helm chart artifact OCID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] helm_command_artifact_ids: (Updatable) List of Helm command artifact OCIDs.
        :param pulumi.Input[bool] is_async: (Updatable) A boolean flag specifies whether this stage executes asynchronously.
        :param pulumi.Input[bool] is_debug_enabled: (Updatable) Enables helm --debug option to stream output to tf stdout. Set to false by default.
        :param pulumi.Input[bool] is_force_enabled: (Updatable) Force resource update through delete; or if required, recreate. Set to false by default.
        :param pulumi.Input[bool] is_uninstall_on_stage_delete: (Updatable) Uninstall the Helm chart release on deleting the stage.
        :param pulumi.Input[bool] is_validation_enabled: (Updatable) A boolean flag specifies whether the invoked function should be validated.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] kubernetes_manifest_deploy_artifact_ids: (Updatable) List of Kubernetes manifest artifact OCIDs.
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[pulumi.InputType['DeployStageLoadBalancerConfigArgs']] load_balancer_config: (Updatable) Specifies config for load balancer traffic shift stages. The Load Balancer specified here should be an Application Load Balancer type. Network Load Balancers are not supported.
        :param pulumi.Input[int] max_history: (Updatable) Limit the maximum number of revisions saved per release. Use 0 for no limit. Set to 10 by default
        :param pulumi.Input[str] max_memory_in_mbs: (Updatable) Maximum usable memory for the Function (in MB).
        :param pulumi.Input[str] namespace: (Updatable) Default namespace to be used for Kubernetes deployment when not specified in the manifest.
        :param pulumi.Input[str] oke_blue_green_deploy_stage_id: The OCID of the upstream OKE blue-green deployment stage in this pipeline.
        :param pulumi.Input[str] oke_canary_deploy_stage_id: The OCID of an upstream OKE canary deployment stage in this pipeline.
        :param pulumi.Input[str] oke_canary_traffic_shift_deploy_stage_id: The OCID of an upstream OKE canary deployment traffic shift stage in this pipeline.
        :param pulumi.Input[str] oke_cluster_deploy_environment_id: (Updatable) Kubernetes cluster environment OCID for deployment.
        :param pulumi.Input[pulumi.InputType['DeployStageProductionLoadBalancerConfigArgs']] production_load_balancer_config: Specifies configuration for load balancer traffic shift stages. The load balancer specified here should be an Application load balancer type. Network load balancers are not supported.
        :param pulumi.Input[str] project_id: The OCID of a project.
        :param pulumi.Input[str] purpose: (Updatable) The purpose of running this Helm stage
        :param pulumi.Input[str] release_name: (Updatable) Default name of the chart instance. Must be unique within a Kubernetes namespace.
        :param pulumi.Input[pulumi.InputType['DeployStageRollbackPolicyArgs']] rollback_policy: (Updatable) Specifies the rollback policy. This is initiated on the failure of certain stage types.
        :param pulumi.Input[pulumi.InputType['DeployStageRolloutPolicyArgs']] rollout_policy: (Updatable) Description of rollout policy for load balancer traffic shift stage.
        :param pulumi.Input[pulumi.InputType['DeployStageSetStringArgs']] set_string: (Updatable) Specifies the name and value pairs to set helm values.
        :param pulumi.Input[pulumi.InputType['DeployStageSetValuesArgs']] set_values: (Updatable) Specifies the name and value pairs to set helm values.
        :param pulumi.Input[bool] should_cleanup_on_fail: (Updatable) Allow deletion of new resources created during when an upgrade fails. Set to false by default.
        :param pulumi.Input[bool] should_not_wait: (Updatable) Does not wait until all the resources are in a ready state to mark the release as successful if set to true. Set to false by default.
        :param pulumi.Input[bool] should_reset_values: (Updatable) During upgrade, reset the values to the ones built into the chart. It overrides shouldReuseValues. Set to false by default.
        :param pulumi.Input[bool] should_reuse_values: (Updatable) During upgrade, reuse the values of the last release and merge overrides from the command line. Set to false by default.
        :param pulumi.Input[bool] should_skip_crds: (Updatable) If set, no CRDs are installed. By default, CRDs are installed only if they are not present already. Set to false by default.
        :param pulumi.Input[bool] should_skip_render_subchart_notes: (Updatable) If set, renders subchart notes along with the parent. Set to false by default.
        :param pulumi.Input[str] state: The current state of the deployment stage.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[pulumi.InputType['DeployStageTestLoadBalancerConfigArgs']] test_load_balancer_config: (Updatable) Specifies configuration for load balancer traffic shift stages. The load balancer specified here should be an Application load balancer type. Network load balancers are not supported.
        :param pulumi.Input[str] time_created: Time the deployment stage was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        :param pulumi.Input[str] time_updated: Time the deployment stage was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        :param pulumi.Input[int] timeout_in_seconds: (Updatable) Time to wait for execution of a Shell/Helm stage. Defaults to 36000 seconds for Shell and 300 seconds for Helm Stage
        :param pulumi.Input[str] traffic_shift_target: (Updatable) Specifies the target or destination backend set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values_artifact_ids: (Updatable) List of values.yaml file artifact OCIDs.
        :param pulumi.Input[pulumi.InputType['DeployStageWaitCriteriaArgs']] wait_criteria: (Updatable) Specifies wait criteria for the Wait stage.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeployStageState.__new__(_DeployStageState)

        __props__.__dict__["approval_policy"] = approval_policy
        __props__.__dict__["are_hooks_enabled"] = are_hooks_enabled
        __props__.__dict__["blue_backend_ips"] = blue_backend_ips
        __props__.__dict__["blue_green_strategy"] = blue_green_strategy
        __props__.__dict__["canary_strategy"] = canary_strategy
        __props__.__dict__["command_spec_deploy_artifact_id"] = command_spec_deploy_artifact_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compute_instance_group_blue_green_deployment_deploy_stage_id"] = compute_instance_group_blue_green_deployment_deploy_stage_id
        __props__.__dict__["compute_instance_group_canary_deploy_stage_id"] = compute_instance_group_canary_deploy_stage_id
        __props__.__dict__["compute_instance_group_canary_traffic_shift_deploy_stage_id"] = compute_instance_group_canary_traffic_shift_deploy_stage_id
        __props__.__dict__["compute_instance_group_deploy_environment_id"] = compute_instance_group_deploy_environment_id
        __props__.__dict__["config"] = config
        __props__.__dict__["container_config"] = container_config
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["deploy_artifact_id"] = deploy_artifact_id
        __props__.__dict__["deploy_artifact_ids"] = deploy_artifact_ids
        __props__.__dict__["deploy_environment_id_a"] = deploy_environment_id_a
        __props__.__dict__["deploy_environment_id_b"] = deploy_environment_id_b
        __props__.__dict__["deploy_pipeline_id"] = deploy_pipeline_id
        __props__.__dict__["deploy_stage_predecessor_collection"] = deploy_stage_predecessor_collection
        __props__.__dict__["deploy_stage_type"] = deploy_stage_type
        __props__.__dict__["deployment_spec_deploy_artifact_id"] = deployment_spec_deploy_artifact_id
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["docker_image_deploy_artifact_id"] = docker_image_deploy_artifact_id
        __props__.__dict__["failure_policy"] = failure_policy
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["function_deploy_environment_id"] = function_deploy_environment_id
        __props__.__dict__["function_timeout_in_seconds"] = function_timeout_in_seconds
        __props__.__dict__["green_backend_ips"] = green_backend_ips
        __props__.__dict__["helm_chart_deploy_artifact_id"] = helm_chart_deploy_artifact_id
        __props__.__dict__["helm_command_artifact_ids"] = helm_command_artifact_ids
        __props__.__dict__["is_async"] = is_async
        __props__.__dict__["is_debug_enabled"] = is_debug_enabled
        __props__.__dict__["is_force_enabled"] = is_force_enabled
        __props__.__dict__["is_uninstall_on_stage_delete"] = is_uninstall_on_stage_delete
        __props__.__dict__["is_validation_enabled"] = is_validation_enabled
        __props__.__dict__["kubernetes_manifest_deploy_artifact_ids"] = kubernetes_manifest_deploy_artifact_ids
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["load_balancer_config"] = load_balancer_config
        __props__.__dict__["max_history"] = max_history
        __props__.__dict__["max_memory_in_mbs"] = max_memory_in_mbs
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["oke_blue_green_deploy_stage_id"] = oke_blue_green_deploy_stage_id
        __props__.__dict__["oke_canary_deploy_stage_id"] = oke_canary_deploy_stage_id
        __props__.__dict__["oke_canary_traffic_shift_deploy_stage_id"] = oke_canary_traffic_shift_deploy_stage_id
        __props__.__dict__["oke_cluster_deploy_environment_id"] = oke_cluster_deploy_environment_id
        __props__.__dict__["production_load_balancer_config"] = production_load_balancer_config
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["purpose"] = purpose
        __props__.__dict__["release_name"] = release_name
        __props__.__dict__["rollback_policy"] = rollback_policy
        __props__.__dict__["rollout_policy"] = rollout_policy
        __props__.__dict__["set_string"] = set_string
        __props__.__dict__["set_values"] = set_values
        __props__.__dict__["should_cleanup_on_fail"] = should_cleanup_on_fail
        __props__.__dict__["should_not_wait"] = should_not_wait
        __props__.__dict__["should_reset_values"] = should_reset_values
        __props__.__dict__["should_reuse_values"] = should_reuse_values
        __props__.__dict__["should_skip_crds"] = should_skip_crds
        __props__.__dict__["should_skip_render_subchart_notes"] = should_skip_render_subchart_notes
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["test_load_balancer_config"] = test_load_balancer_config
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["timeout_in_seconds"] = timeout_in_seconds
        __props__.__dict__["traffic_shift_target"] = traffic_shift_target
        __props__.__dict__["values_artifact_ids"] = values_artifact_ids
        __props__.__dict__["wait_criteria"] = wait_criteria
        return DeployStage(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="approvalPolicy")
    def approval_policy(self) -> pulumi.Output['outputs.DeployStageApprovalPolicy']:
        """
        (Updatable) Specifies the approval policy.
        """
        return pulumi.get(self, "approval_policy")

    @property
    @pulumi.getter(name="areHooksEnabled")
    def are_hooks_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Disable pre/post upgrade hooks. Set to false by default.
        """
        return pulumi.get(self, "are_hooks_enabled")

    @property
    @pulumi.getter(name="blueBackendIps")
    def blue_backend_ips(self) -> pulumi.Output['outputs.DeployStageBlueBackendIps']:
        """
        (Updatable) Collection of backend environment IP addresses.
        """
        return pulumi.get(self, "blue_backend_ips")

    @property
    @pulumi.getter(name="blueGreenStrategy")
    def blue_green_strategy(self) -> pulumi.Output['outputs.DeployStageBlueGreenStrategy']:
        """
        Specifies the required blue green release strategy for OKE deployment.
        """
        return pulumi.get(self, "blue_green_strategy")

    @property
    @pulumi.getter(name="canaryStrategy")
    def canary_strategy(self) -> pulumi.Output['outputs.DeployStageCanaryStrategy']:
        """
        Specifies the required canary release strategy for OKE deployment.
        """
        return pulumi.get(self, "canary_strategy")

    @property
    @pulumi.getter(name="commandSpecDeployArtifactId")
    def command_spec_deploy_artifact_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the artifact that contains the command specification.
        """
        return pulumi.get(self, "command_spec_deploy_artifact_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the compartment where the ContainerInstance will be created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeInstanceGroupBlueGreenDeploymentDeployStageId")
    def compute_instance_group_blue_green_deployment_deploy_stage_id(self) -> pulumi.Output[str]:
        """
        The OCID of the upstream compute instance group blue-green deployment stage in this pipeline.
        """
        return pulumi.get(self, "compute_instance_group_blue_green_deployment_deploy_stage_id")

    @property
    @pulumi.getter(name="computeInstanceGroupCanaryDeployStageId")
    def compute_instance_group_canary_deploy_stage_id(self) -> pulumi.Output[str]:
        """
        A compute instance group canary stage OCID for load balancer.
        """
        return pulumi.get(self, "compute_instance_group_canary_deploy_stage_id")

    @property
    @pulumi.getter(name="computeInstanceGroupCanaryTrafficShiftDeployStageId")
    def compute_instance_group_canary_traffic_shift_deploy_stage_id(self) -> pulumi.Output[str]:
        """
        (Updatable) A compute instance group canary traffic shift stage OCID for load balancer.
        """
        return pulumi.get(self, "compute_instance_group_canary_traffic_shift_deploy_stage_id")

    @property
    @pulumi.getter(name="computeInstanceGroupDeployEnvironmentId")
    def compute_instance_group_deploy_environment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) A compute instance group environment OCID for rolling deployment.
        """
        return pulumi.get(self, "compute_instance_group_deploy_environment_id")

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        (Updatable) User provided key and value pair configuration, which is assigned through constants or parameter.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="containerConfig")
    def container_config(self) -> pulumi.Output['outputs.DeployStageContainerConfig']:
        """
        (Updatable) Specifies the container configuration.
        """
        return pulumi.get(self, "container_config")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deployArtifactId")
    def deploy_artifact_id(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) Optional artifact OCID. The artifact will be included in the body for the function invocation during the stage's execution. If the DeployArtifact.argumentSubstituitionMode is set to SUBSTITUTE_PLACEHOLDERS, then the pipeline parameter values will be used to replace the placeholders in the artifact content.
        """
        return pulumi.get(self, "deploy_artifact_id")

    @property
    @pulumi.getter(name="deployArtifactIds")
    def deploy_artifact_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        (Updatable) The list of file artifact OCIDs to deploy.
        """
        return pulumi.get(self, "deploy_artifact_ids")

    @property
    @pulumi.getter(name="deployEnvironmentIdA")
    def deploy_environment_id_a(self) -> pulumi.Output[str]:
        """
        First compute instance group environment OCID for deployment.
        """
        return pulumi.get(self, "deploy_environment_id_a")

    @property
    @pulumi.getter(name="deployEnvironmentIdB")
    def deploy_environment_id_b(self) -> pulumi.Output[str]:
        """
        Second compute instance group environment OCID for deployment.
        """
        return pulumi.get(self, "deploy_environment_id_b")

    @property
    @pulumi.getter(name="deployPipelineId")
    def deploy_pipeline_id(self) -> pulumi.Output[str]:
        """
        The OCID of a pipeline.
        """
        return pulumi.get(self, "deploy_pipeline_id")

    @property
    @pulumi.getter(name="deployStagePredecessorCollection")
    def deploy_stage_predecessor_collection(self) -> pulumi.Output['outputs.DeployStageDeployStagePredecessorCollection']:
        """
        (Updatable) Collection containing the predecessors of a stage.
        """
        return pulumi.get(self, "deploy_stage_predecessor_collection")

    @property
    @pulumi.getter(name="deployStageType")
    def deploy_stage_type(self) -> pulumi.Output[str]:
        """
        (Updatable) Deployment stage type.
        """
        return pulumi.get(self, "deploy_stage_type")

    @property
    @pulumi.getter(name="deploymentSpecDeployArtifactId")
    def deployment_spec_deploy_artifact_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the artifact that contains the deployment specification.
        """
        return pulumi.get(self, "deployment_spec_deploy_artifact_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) Optional description about the deployment stage.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Deployment stage display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="dockerImageDeployArtifactId")
    def docker_image_deploy_artifact_id(self) -> pulumi.Output[str]:
        """
        (Updatable) A Docker image artifact OCID.
        """
        return pulumi.get(self, "docker_image_deploy_artifact_id")

    @property
    @pulumi.getter(name="failurePolicy")
    def failure_policy(self) -> pulumi.Output['outputs.DeployStageFailurePolicy']:
        """
        (Updatable) Specifies a failure policy for a compute instance group rolling deployment stage.
        """
        return pulumi.get(self, "failure_policy")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="functionDeployEnvironmentId")
    def function_deploy_environment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Function environment OCID.
        """
        return pulumi.get(self, "function_deploy_environment_id")

    @property
    @pulumi.getter(name="functionTimeoutInSeconds")
    def function_timeout_in_seconds(self) -> pulumi.Output[int]:
        """
        (Updatable) Timeout for execution of the Function. Value in seconds.
        """
        return pulumi.get(self, "function_timeout_in_seconds")

    @property
    @pulumi.getter(name="greenBackendIps")
    def green_backend_ips(self) -> pulumi.Output['outputs.DeployStageGreenBackendIps']:
        """
        (Updatable) Collection of backend environment IP addresses.
        """
        return pulumi.get(self, "green_backend_ips")

    @property
    @pulumi.getter(name="helmChartDeployArtifactId")
    def helm_chart_deploy_artifact_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Helm chart artifact OCID.
        """
        return pulumi.get(self, "helm_chart_deploy_artifact_id")

    @property
    @pulumi.getter(name="helmCommandArtifactIds")
    def helm_command_artifact_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        (Updatable) List of Helm command artifact OCIDs.
        """
        return pulumi.get(self, "helm_command_artifact_ids")

    @property
    @pulumi.getter(name="isAsync")
    def is_async(self) -> pulumi.Output[bool]:
        """
        (Updatable) A boolean flag specifies whether this stage executes asynchronously.
        """
        return pulumi.get(self, "is_async")

    @property
    @pulumi.getter(name="isDebugEnabled")
    def is_debug_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Enables helm --debug option to stream output to tf stdout. Set to false by default.
        """
        return pulumi.get(self, "is_debug_enabled")

    @property
    @pulumi.getter(name="isForceEnabled")
    def is_force_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Force resource update through delete; or if required, recreate. Set to false by default.
        """
        return pulumi.get(self, "is_force_enabled")

    @property
    @pulumi.getter(name="isUninstallOnStageDelete")
    def is_uninstall_on_stage_delete(self) -> pulumi.Output[bool]:
        """
        (Updatable) Uninstall the Helm chart release on deleting the stage.
        """
        return pulumi.get(self, "is_uninstall_on_stage_delete")

    @property
    @pulumi.getter(name="isValidationEnabled")
    def is_validation_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) A boolean flag specifies whether the invoked function should be validated.
        """
        return pulumi.get(self, "is_validation_enabled")

    @property
    @pulumi.getter(name="kubernetesManifestDeployArtifactIds")
    def kubernetes_manifest_deploy_artifact_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        (Updatable) List of Kubernetes manifest artifact OCIDs.
        """
        return pulumi.get(self, "kubernetes_manifest_deploy_artifact_ids")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="loadBalancerConfig")
    def load_balancer_config(self) -> pulumi.Output['outputs.DeployStageLoadBalancerConfig']:
        """
        (Updatable) Specifies config for load balancer traffic shift stages. The Load Balancer specified here should be an Application Load Balancer type. Network Load Balancers are not supported.
        """
        return pulumi.get(self, "load_balancer_config")

    @property
    @pulumi.getter(name="maxHistory")
    def max_history(self) -> pulumi.Output[int]:
        """
        (Updatable) Limit the maximum number of revisions saved per release. Use 0 for no limit. Set to 10 by default
        """
        return pulumi.get(self, "max_history")

    @property
    @pulumi.getter(name="maxMemoryInMbs")
    def max_memory_in_mbs(self) -> pulumi.Output[str]:
        """
        (Updatable) Maximum usable memory for the Function (in MB).
        """
        return pulumi.get(self, "max_memory_in_mbs")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[str]:
        """
        (Updatable) Default namespace to be used for Kubernetes deployment when not specified in the manifest.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="okeBlueGreenDeployStageId")
    def oke_blue_green_deploy_stage_id(self) -> pulumi.Output[str]:
        """
        The OCID of the upstream OKE blue-green deployment stage in this pipeline.
        """
        return pulumi.get(self, "oke_blue_green_deploy_stage_id")

    @property
    @pulumi.getter(name="okeCanaryDeployStageId")
    def oke_canary_deploy_stage_id(self) -> pulumi.Output[str]:
        """
        The OCID of an upstream OKE canary deployment stage in this pipeline.
        """
        return pulumi.get(self, "oke_canary_deploy_stage_id")

    @property
    @pulumi.getter(name="okeCanaryTrafficShiftDeployStageId")
    def oke_canary_traffic_shift_deploy_stage_id(self) -> pulumi.Output[str]:
        """
        The OCID of an upstream OKE canary deployment traffic shift stage in this pipeline.
        """
        return pulumi.get(self, "oke_canary_traffic_shift_deploy_stage_id")

    @property
    @pulumi.getter(name="okeClusterDeployEnvironmentId")
    def oke_cluster_deploy_environment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Kubernetes cluster environment OCID for deployment.
        """
        return pulumi.get(self, "oke_cluster_deploy_environment_id")

    @property
    @pulumi.getter(name="productionLoadBalancerConfig")
    def production_load_balancer_config(self) -> pulumi.Output['outputs.DeployStageProductionLoadBalancerConfig']:
        """
        Specifies configuration for load balancer traffic shift stages. The load balancer specified here should be an Application load balancer type. Network load balancers are not supported.
        """
        return pulumi.get(self, "production_load_balancer_config")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The OCID of a project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def purpose(self) -> pulumi.Output[str]:
        """
        (Updatable) The purpose of running this Helm stage
        """
        return pulumi.get(self, "purpose")

    @property
    @pulumi.getter(name="releaseName")
    def release_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Default name of the chart instance. Must be unique within a Kubernetes namespace.
        """
        return pulumi.get(self, "release_name")

    @property
    @pulumi.getter(name="rollbackPolicy")
    def rollback_policy(self) -> pulumi.Output['outputs.DeployStageRollbackPolicy']:
        """
        (Updatable) Specifies the rollback policy. This is initiated on the failure of certain stage types.
        """
        return pulumi.get(self, "rollback_policy")

    @property
    @pulumi.getter(name="rolloutPolicy")
    def rollout_policy(self) -> pulumi.Output['outputs.DeployStageRolloutPolicy']:
        """
        (Updatable) Description of rollout policy for load balancer traffic shift stage.
        """
        return pulumi.get(self, "rollout_policy")

    @property
    @pulumi.getter(name="setString")
    def set_string(self) -> pulumi.Output['outputs.DeployStageSetString']:
        """
        (Updatable) Specifies the name and value pairs to set helm values.
        """
        return pulumi.get(self, "set_string")

    @property
    @pulumi.getter(name="setValues")
    def set_values(self) -> pulumi.Output['outputs.DeployStageSetValues']:
        """
        (Updatable) Specifies the name and value pairs to set helm values.
        """
        return pulumi.get(self, "set_values")

    @property
    @pulumi.getter(name="shouldCleanupOnFail")
    def should_cleanup_on_fail(self) -> pulumi.Output[bool]:
        """
        (Updatable) Allow deletion of new resources created during when an upgrade fails. Set to false by default.
        """
        return pulumi.get(self, "should_cleanup_on_fail")

    @property
    @pulumi.getter(name="shouldNotWait")
    def should_not_wait(self) -> pulumi.Output[bool]:
        """
        (Updatable) Does not wait until all the resources are in a ready state to mark the release as successful if set to true. Set to false by default.
        """
        return pulumi.get(self, "should_not_wait")

    @property
    @pulumi.getter(name="shouldResetValues")
    def should_reset_values(self) -> pulumi.Output[bool]:
        """
        (Updatable) During upgrade, reset the values to the ones built into the chart. It overrides shouldReuseValues. Set to false by default.
        """
        return pulumi.get(self, "should_reset_values")

    @property
    @pulumi.getter(name="shouldReuseValues")
    def should_reuse_values(self) -> pulumi.Output[bool]:
        """
        (Updatable) During upgrade, reuse the values of the last release and merge overrides from the command line. Set to false by default.
        """
        return pulumi.get(self, "should_reuse_values")

    @property
    @pulumi.getter(name="shouldSkipCrds")
    def should_skip_crds(self) -> pulumi.Output[bool]:
        """
        (Updatable) If set, no CRDs are installed. By default, CRDs are installed only if they are not present already. Set to false by default.
        """
        return pulumi.get(self, "should_skip_crds")

    @property
    @pulumi.getter(name="shouldSkipRenderSubchartNotes")
    def should_skip_render_subchart_notes(self) -> pulumi.Output[bool]:
        """
        (Updatable) If set, renders subchart notes along with the parent. Set to false by default.
        """
        return pulumi.get(self, "should_skip_render_subchart_notes")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the deployment stage.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="testLoadBalancerConfig")
    def test_load_balancer_config(self) -> pulumi.Output['outputs.DeployStageTestLoadBalancerConfig']:
        """
        (Updatable) Specifies configuration for load balancer traffic shift stages. The load balancer specified here should be an Application load balancer type. Network load balancers are not supported.
        """
        return pulumi.get(self, "test_load_balancer_config")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        Time the deployment stage was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        Time the deployment stage was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> pulumi.Output[int]:
        """
        (Updatable) Time to wait for execution of a Shell/Helm stage. Defaults to 36000 seconds for Shell and 300 seconds for Helm Stage
        """
        return pulumi.get(self, "timeout_in_seconds")

    @property
    @pulumi.getter(name="trafficShiftTarget")
    def traffic_shift_target(self) -> pulumi.Output[str]:
        """
        (Updatable) Specifies the target or destination backend set.
        """
        return pulumi.get(self, "traffic_shift_target")

    @property
    @pulumi.getter(name="valuesArtifactIds")
    def values_artifact_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        (Updatable) List of values.yaml file artifact OCIDs.
        """
        return pulumi.get(self, "values_artifact_ids")

    @property
    @pulumi.getter(name="waitCriteria")
    def wait_criteria(self) -> pulumi.Output['outputs.DeployStageWaitCriteria']:
        """
        (Updatable) Specifies wait criteria for the Wait stage.
        """
        return pulumi.get(self, "wait_criteria")

