# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetRepositoryFileDiffResult',
    'AwaitableGetRepositoryFileDiffResult',
    'get_repository_file_diff',
    'get_repository_file_diff_output',
]

@pulumi.output_type
class GetRepositoryFileDiffResult:
    """
    A collection of values returned by getRepositoryFileDiff.
    """
    def __init__(__self__, are_conflicts_in_file=None, base_version=None, changes=None, file_path=None, id=None, is_binary=None, is_comparison_from_merge_base=None, is_large=None, new_id=None, new_path=None, old_id=None, old_path=None, repository_id=None, target_version=None):
        if are_conflicts_in_file and not isinstance(are_conflicts_in_file, bool):
            raise TypeError("Expected argument 'are_conflicts_in_file' to be a bool")
        pulumi.set(__self__, "are_conflicts_in_file", are_conflicts_in_file)
        if base_version and not isinstance(base_version, str):
            raise TypeError("Expected argument 'base_version' to be a str")
        pulumi.set(__self__, "base_version", base_version)
        if changes and not isinstance(changes, list):
            raise TypeError("Expected argument 'changes' to be a list")
        pulumi.set(__self__, "changes", changes)
        if file_path and not isinstance(file_path, str):
            raise TypeError("Expected argument 'file_path' to be a str")
        pulumi.set(__self__, "file_path", file_path)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_binary and not isinstance(is_binary, bool):
            raise TypeError("Expected argument 'is_binary' to be a bool")
        pulumi.set(__self__, "is_binary", is_binary)
        if is_comparison_from_merge_base and not isinstance(is_comparison_from_merge_base, bool):
            raise TypeError("Expected argument 'is_comparison_from_merge_base' to be a bool")
        pulumi.set(__self__, "is_comparison_from_merge_base", is_comparison_from_merge_base)
        if is_large and not isinstance(is_large, bool):
            raise TypeError("Expected argument 'is_large' to be a bool")
        pulumi.set(__self__, "is_large", is_large)
        if new_id and not isinstance(new_id, str):
            raise TypeError("Expected argument 'new_id' to be a str")
        pulumi.set(__self__, "new_id", new_id)
        if new_path and not isinstance(new_path, str):
            raise TypeError("Expected argument 'new_path' to be a str")
        pulumi.set(__self__, "new_path", new_path)
        if old_id and not isinstance(old_id, str):
            raise TypeError("Expected argument 'old_id' to be a str")
        pulumi.set(__self__, "old_id", old_id)
        if old_path and not isinstance(old_path, str):
            raise TypeError("Expected argument 'old_path' to be a str")
        pulumi.set(__self__, "old_path", old_path)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)
        if target_version and not isinstance(target_version, str):
            raise TypeError("Expected argument 'target_version' to be a str")
        pulumi.set(__self__, "target_version", target_version)

    @property
    @pulumi.getter(name="areConflictsInFile")
    def are_conflicts_in_file(self) -> bool:
        """
        Indicates whether the changed file contains conflicts.
        """
        return pulumi.get(self, "are_conflicts_in_file")

    @property
    @pulumi.getter(name="baseVersion")
    def base_version(self) -> str:
        return pulumi.get(self, "base_version")

    @property
    @pulumi.getter
    def changes(self) -> Sequence['outputs.GetRepositoryFileDiffChangeResult']:
        """
        List of changed section in the file.
        """
        return pulumi.get(self, "changes")

    @property
    @pulumi.getter(name="filePath")
    def file_path(self) -> str:
        return pulumi.get(self, "file_path")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isBinary")
    def is_binary(self) -> bool:
        """
        Indicates whether the file is binary.
        """
        return pulumi.get(self, "is_binary")

    @property
    @pulumi.getter(name="isComparisonFromMergeBase")
    def is_comparison_from_merge_base(self) -> Optional[bool]:
        return pulumi.get(self, "is_comparison_from_merge_base")

    @property
    @pulumi.getter(name="isLarge")
    def is_large(self) -> bool:
        """
        Indicates whether the file is large.
        """
        return pulumi.get(self, "is_large")

    @property
    @pulumi.getter(name="newId")
    def new_id(self) -> str:
        """
        The ID of the changed object on the target version.
        """
        return pulumi.get(self, "new_id")

    @property
    @pulumi.getter(name="newPath")
    def new_path(self) -> str:
        """
        The path on the target version to the changed object.
        """
        return pulumi.get(self, "new_path")

    @property
    @pulumi.getter(name="oldId")
    def old_id(self) -> str:
        """
        The ID of the changed object on the base version.
        """
        return pulumi.get(self, "old_id")

    @property
    @pulumi.getter(name="oldPath")
    def old_path(self) -> str:
        """
        The path on the base version to the changed object.
        """
        return pulumi.get(self, "old_path")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> str:
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter(name="targetVersion")
    def target_version(self) -> str:
        return pulumi.get(self, "target_version")


class AwaitableGetRepositoryFileDiffResult(GetRepositoryFileDiffResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoryFileDiffResult(
            are_conflicts_in_file=self.are_conflicts_in_file,
            base_version=self.base_version,
            changes=self.changes,
            file_path=self.file_path,
            id=self.id,
            is_binary=self.is_binary,
            is_comparison_from_merge_base=self.is_comparison_from_merge_base,
            is_large=self.is_large,
            new_id=self.new_id,
            new_path=self.new_path,
            old_id=self.old_id,
            old_path=self.old_path,
            repository_id=self.repository_id,
            target_version=self.target_version)


def get_repository_file_diff(base_version: Optional[str] = None,
                             file_path: Optional[str] = None,
                             is_comparison_from_merge_base: Optional[bool] = None,
                             repository_id: Optional[str] = None,
                             target_version: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoryFileDiffResult:
    """
    This data source provides details about a specific Repository File Diff resource in Oracle Cloud Infrastructure Devops service.

    Gets the line-by-line difference between file on different commits.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository_file_diff = oci.DevOps.get_repository_file_diff(base_version=repository_file_diff_base_version,
        repository_id=test_repository["id"],
        target_version=repository_file_diff_target_version,
        file_path=repository_file_diff_file_path,
        is_comparison_from_merge_base=repository_file_diff_is_comparison_from_merge_base)
    ```


    :param str base_version: The branch to compare changes against.
    :param str file_path: A filter to return only commits that affect any of the specified paths.
    :param bool is_comparison_from_merge_base: Boolean to indicate whether to use merge base or most recent revision.
    :param str repository_id: Unique repository identifier.
    :param str target_version: The branch where changes are coming from.
    """
    __args__ = dict()
    __args__['baseVersion'] = base_version
    __args__['filePath'] = file_path
    __args__['isComparisonFromMergeBase'] = is_comparison_from_merge_base
    __args__['repositoryId'] = repository_id
    __args__['targetVersion'] = target_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DevOps/getRepositoryFileDiff:getRepositoryFileDiff', __args__, opts=opts, typ=GetRepositoryFileDiffResult).value

    return AwaitableGetRepositoryFileDiffResult(
        are_conflicts_in_file=pulumi.get(__ret__, 'are_conflicts_in_file'),
        base_version=pulumi.get(__ret__, 'base_version'),
        changes=pulumi.get(__ret__, 'changes'),
        file_path=pulumi.get(__ret__, 'file_path'),
        id=pulumi.get(__ret__, 'id'),
        is_binary=pulumi.get(__ret__, 'is_binary'),
        is_comparison_from_merge_base=pulumi.get(__ret__, 'is_comparison_from_merge_base'),
        is_large=pulumi.get(__ret__, 'is_large'),
        new_id=pulumi.get(__ret__, 'new_id'),
        new_path=pulumi.get(__ret__, 'new_path'),
        old_id=pulumi.get(__ret__, 'old_id'),
        old_path=pulumi.get(__ret__, 'old_path'),
        repository_id=pulumi.get(__ret__, 'repository_id'),
        target_version=pulumi.get(__ret__, 'target_version'))


@_utilities.lift_output_func(get_repository_file_diff)
def get_repository_file_diff_output(base_version: Optional[pulumi.Input[str]] = None,
                                    file_path: Optional[pulumi.Input[str]] = None,
                                    is_comparison_from_merge_base: Optional[pulumi.Input[Optional[bool]]] = None,
                                    repository_id: Optional[pulumi.Input[str]] = None,
                                    target_version: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRepositoryFileDiffResult]:
    """
    This data source provides details about a specific Repository File Diff resource in Oracle Cloud Infrastructure Devops service.

    Gets the line-by-line difference between file on different commits.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository_file_diff = oci.DevOps.get_repository_file_diff(base_version=repository_file_diff_base_version,
        repository_id=test_repository["id"],
        target_version=repository_file_diff_target_version,
        file_path=repository_file_diff_file_path,
        is_comparison_from_merge_base=repository_file_diff_is_comparison_from_merge_base)
    ```


    :param str base_version: The branch to compare changes against.
    :param str file_path: A filter to return only commits that affect any of the specified paths.
    :param bool is_comparison_from_merge_base: Boolean to indicate whether to use merge base or most recent revision.
    :param str repository_id: Unique repository identifier.
    :param str target_version: The branch where changes are coming from.
    """
    ...
