# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FusionEnvironmentAdminUserArgs', 'FusionEnvironmentAdminUser']

@pulumi.input_type
class FusionEnvironmentAdminUserArgs:
    def __init__(__self__, *,
                 email_address: pulumi.Input[str],
                 first_name: pulumi.Input[str],
                 fusion_environment_id: pulumi.Input[str],
                 last_name: pulumi.Input[str],
                 password: pulumi.Input[str],
                 username: pulumi.Input[str]):
        """
        The set of arguments for constructing a FusionEnvironmentAdminUser resource.
        :param pulumi.Input[str] email_address: The email address for the administrator.
        :param pulumi.Input[str] first_name: The administrator's first name.
        :param pulumi.Input[str] fusion_environment_id: unique FusionEnvironment identifier
        :param pulumi.Input[str] last_name: The administrator's last name.
        :param pulumi.Input[str] password: The password for the administrator.
        :param pulumi.Input[str] username: The username for the administrator.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "email_address", email_address)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "fusion_environment_id", fusion_environment_id)
        pulumi.set(__self__, "last_name", last_name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> pulumi.Input[str]:
        """
        The email address for the administrator.
        """
        return pulumi.get(self, "email_address")

    @email_address.setter
    def email_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "email_address", value)

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> pulumi.Input[str]:
        """
        The administrator's first name.
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "first_name", value)

    @property
    @pulumi.getter(name="fusionEnvironmentId")
    def fusion_environment_id(self) -> pulumi.Input[str]:
        """
        unique FusionEnvironment identifier
        """
        return pulumi.get(self, "fusion_environment_id")

    @fusion_environment_id.setter
    def fusion_environment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "fusion_environment_id", value)

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> pulumi.Input[str]:
        """
        The administrator's last name.
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "last_name", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The password for the administrator.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        The username for the administrator.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class _FusionEnvironmentAdminUserState:
    def __init__(__self__, *,
                 email_address: Optional[pulumi.Input[str]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 fusion_environment_id: Optional[pulumi.Input[str]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['FusionEnvironmentAdminUserItemArgs']]]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FusionEnvironmentAdminUser resources.
        :param pulumi.Input[str] email_address: The email address for the administrator.
        :param pulumi.Input[str] first_name: The administrator's first name.
        :param pulumi.Input[str] fusion_environment_id: unique FusionEnvironment identifier
        :param pulumi.Input[Sequence[pulumi.Input['FusionEnvironmentAdminUserItemArgs']]] items: A page of AdminUserSummary objects.
        :param pulumi.Input[str] last_name: The administrator's last name.
        :param pulumi.Input[str] password: The password for the administrator.
        :param pulumi.Input[str] username: The username for the administrator.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if email_address is not None:
            pulumi.set(__self__, "email_address", email_address)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if fusion_environment_id is not None:
            pulumi.set(__self__, "fusion_environment_id", fusion_environment_id)
        if items is not None:
            pulumi.set(__self__, "items", items)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> Optional[pulumi.Input[str]]:
        """
        The email address for the administrator.
        """
        return pulumi.get(self, "email_address")

    @email_address.setter
    def email_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_address", value)

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[str]]:
        """
        The administrator's first name.
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "first_name", value)

    @property
    @pulumi.getter(name="fusionEnvironmentId")
    def fusion_environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        unique FusionEnvironment identifier
        """
        return pulumi.get(self, "fusion_environment_id")

    @fusion_environment_id.setter
    def fusion_environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fusion_environment_id", value)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionEnvironmentAdminUserItemArgs']]]]:
        """
        A page of AdminUserSummary objects.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionEnvironmentAdminUserItemArgs']]]]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[str]]:
        """
        The administrator's last name.
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password for the administrator.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The username for the administrator.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


class FusionEnvironmentAdminUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email_address: Optional[pulumi.Input[str]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 fusion_environment_id: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Fusion Environment Admin User resource in Oracle Cloud Infrastructure Fusion Apps service.

        Create a FusionEnvironment admin user

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_fusion_environment_admin_user = oci.fusion_apps.FusionEnvironmentAdminUser("test_fusion_environment_admin_user",
            email_address=fusion_environment_admin_user_email_address,
            first_name=fusion_environment_admin_user_first_name,
            fusion_environment_id=test_fusion_environment["id"],
            last_name=fusion_environment_admin_user_last_name,
            password=fusion_environment_admin_user_password,
            username=fusion_environment_admin_user_username)
        ```

        ## Import

        FusionEnvironmentAdminUsers can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FusionApps/fusionEnvironmentAdminUser:FusionEnvironmentAdminUser test_fusion_environment_admin_user "fusionEnvironments/{fusionEnvironmentId}/adminUsers/{adminUsername}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] email_address: The email address for the administrator.
        :param pulumi.Input[str] first_name: The administrator's first name.
        :param pulumi.Input[str] fusion_environment_id: unique FusionEnvironment identifier
        :param pulumi.Input[str] last_name: The administrator's last name.
        :param pulumi.Input[str] password: The password for the administrator.
        :param pulumi.Input[str] username: The username for the administrator.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FusionEnvironmentAdminUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Fusion Environment Admin User resource in Oracle Cloud Infrastructure Fusion Apps service.

        Create a FusionEnvironment admin user

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_fusion_environment_admin_user = oci.fusion_apps.FusionEnvironmentAdminUser("test_fusion_environment_admin_user",
            email_address=fusion_environment_admin_user_email_address,
            first_name=fusion_environment_admin_user_first_name,
            fusion_environment_id=test_fusion_environment["id"],
            last_name=fusion_environment_admin_user_last_name,
            password=fusion_environment_admin_user_password,
            username=fusion_environment_admin_user_username)
        ```

        ## Import

        FusionEnvironmentAdminUsers can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FusionApps/fusionEnvironmentAdminUser:FusionEnvironmentAdminUser test_fusion_environment_admin_user "fusionEnvironments/{fusionEnvironmentId}/adminUsers/{adminUsername}"
        ```

        :param str resource_name: The name of the resource.
        :param FusionEnvironmentAdminUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FusionEnvironmentAdminUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email_address: Optional[pulumi.Input[str]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 fusion_environment_id: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FusionEnvironmentAdminUserArgs.__new__(FusionEnvironmentAdminUserArgs)

            if email_address is None and not opts.urn:
                raise TypeError("Missing required property 'email_address'")
            __props__.__dict__["email_address"] = email_address
            if first_name is None and not opts.urn:
                raise TypeError("Missing required property 'first_name'")
            __props__.__dict__["first_name"] = first_name
            if fusion_environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'fusion_environment_id'")
            __props__.__dict__["fusion_environment_id"] = fusion_environment_id
            if last_name is None and not opts.urn:
                raise TypeError("Missing required property 'last_name'")
            __props__.__dict__["last_name"] = last_name
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
            __props__.__dict__["items"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(FusionEnvironmentAdminUser, __self__).__init__(
            'oci:FusionApps/fusionEnvironmentAdminUser:FusionEnvironmentAdminUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            email_address: Optional[pulumi.Input[str]] = None,
            first_name: Optional[pulumi.Input[str]] = None,
            fusion_environment_id: Optional[pulumi.Input[str]] = None,
            items: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionEnvironmentAdminUserItemArgs']]]]] = None,
            last_name: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None) -> 'FusionEnvironmentAdminUser':
        """
        Get an existing FusionEnvironmentAdminUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] email_address: The email address for the administrator.
        :param pulumi.Input[str] first_name: The administrator's first name.
        :param pulumi.Input[str] fusion_environment_id: unique FusionEnvironment identifier
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionEnvironmentAdminUserItemArgs']]]] items: A page of AdminUserSummary objects.
        :param pulumi.Input[str] last_name: The administrator's last name.
        :param pulumi.Input[str] password: The password for the administrator.
        :param pulumi.Input[str] username: The username for the administrator.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FusionEnvironmentAdminUserState.__new__(_FusionEnvironmentAdminUserState)

        __props__.__dict__["email_address"] = email_address
        __props__.__dict__["first_name"] = first_name
        __props__.__dict__["fusion_environment_id"] = fusion_environment_id
        __props__.__dict__["items"] = items
        __props__.__dict__["last_name"] = last_name
        __props__.__dict__["password"] = password
        __props__.__dict__["username"] = username
        return FusionEnvironmentAdminUser(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> pulumi.Output[str]:
        """
        The email address for the administrator.
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> pulumi.Output[str]:
        """
        The administrator's first name.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="fusionEnvironmentId")
    def fusion_environment_id(self) -> pulumi.Output[str]:
        """
        unique FusionEnvironment identifier
        """
        return pulumi.get(self, "fusion_environment_id")

    @property
    @pulumi.getter
    def items(self) -> pulumi.Output[Sequence['outputs.FusionEnvironmentAdminUserItem']]:
        """
        A page of AdminUserSummary objects.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> pulumi.Output[str]:
        """
        The administrator's last name.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        The password for the administrator.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        The username for the administrator.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "username")

