# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainsIdentitySettingArgs', 'DomainsIdentitySetting']

@pulumi.input_type
class DomainsIdentitySettingArgs:
    def __init__(__self__, *,
                 idcs_endpoint: pulumi.Input[str],
                 identity_setting_id: pulumi.Input[str],
                 schemas: pulumi.Input[Sequence[pulumi.Input[str]]],
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 emit_locked_message_when_user_is_locked: Optional[pulumi.Input[bool]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 my_profile: Optional[pulumi.Input['DomainsIdentitySettingMyProfileArgs']] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 posix_gid: Optional[pulumi.Input['DomainsIdentitySettingPosixGidArgs']] = None,
                 posix_uid: Optional[pulumi.Input['DomainsIdentitySettingPosixUidArgs']] = None,
                 primary_email_required: Optional[pulumi.Input[bool]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 return_inactive_over_locked_message: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentitySettingTagArgs']]]] = None,
                 tokens: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentitySettingTokenArgs']]]] = None,
                 user_allowed_to_set_recovery_email: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a DomainsIdentitySetting resource.
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[str] identity_setting_id: ID of the resource
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[bool] emit_locked_message_when_user_is_locked: (Updatable) Indicates whether to show the 'user-is-locked' message during authentication if the user is already locked. The default value is false, which tells the system to show a generic 'authentication-failure' message. This is the most secure behavior. If the option is set to true, the system shows a more detailed 'error-message' that says the user is locked. This is more helpful but is less secure, for example, because the difference in error-messages could be used to determine which usernames exist and which do not.
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input['DomainsIdentitySettingMyProfileArgs'] my_profile: (Updatable) Whether to allow users to update their own profile.
               
               **Added In:** 2207040824
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * required: false
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input['DomainsIdentitySettingPosixGidArgs'] posix_gid: (Updatable) A list of Posix Gid settings.
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * required: false
               * type: complex
               * uniqueness: none
        :param pulumi.Input['DomainsIdentitySettingPosixUidArgs'] posix_uid: (Updatable) A list of Posix Uid settings.
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * required: false
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] primary_email_required: (Updatable) Indicates whether the primary email is required.
               
               **Added In:** 19.1.4
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[bool] return_inactive_over_locked_message: (Updatable) **Added In:** 2302092332
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none Determines the PasswordAuthenticator API response when a user is both 'locked' and 'inactive.' If false (default), a 'locked' message is shown. If true, an 'inactive' message is shown.
        :param pulumi.Input[Sequence[pulumi.Input['DomainsIdentitySettingTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsIdentitySettingTokenArgs']]] tokens: (Updatable) A list of tokens and their expiry length.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [type]
               * multiValued: true
               * required: false
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] user_allowed_to_set_recovery_email: (Updatable) Indicates whether a user is allowed to change their own recovery email.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        pulumi.set(__self__, "identity_setting_id", identity_setting_id)
        pulumi.set(__self__, "schemas", schemas)
        if attribute_sets is not None:
            pulumi.set(__self__, "attribute_sets", attribute_sets)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if emit_locked_message_when_user_is_locked is not None:
            pulumi.set(__self__, "emit_locked_message_when_user_is_locked", emit_locked_message_when_user_is_locked)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if my_profile is not None:
            pulumi.set(__self__, "my_profile", my_profile)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if posix_gid is not None:
            pulumi.set(__self__, "posix_gid", posix_gid)
        if posix_uid is not None:
            pulumi.set(__self__, "posix_uid", posix_uid)
        if primary_email_required is not None:
            pulumi.set(__self__, "primary_email_required", primary_email_required)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if return_inactive_over_locked_message is not None:
            pulumi.set(__self__, "return_inactive_over_locked_message", return_inactive_over_locked_message)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tokens is not None:
            pulumi.set(__self__, "tokens", tokens)
        if user_allowed_to_set_recovery_email is not None:
            pulumi.set(__self__, "user_allowed_to_set_recovery_email", user_allowed_to_set_recovery_email)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Input[str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter(name="identitySettingId")
    def identity_setting_id(self) -> pulumi.Input[str]:
        """
        ID of the resource
        """
        return pulumi.get(self, "identity_setting_id")

    @identity_setting_id.setter
    def identity_setting_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "identity_setting_id", value)

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="emitLockedMessageWhenUserIsLocked")
    def emit_locked_message_when_user_is_locked(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates whether to show the 'user-is-locked' message during authentication if the user is already locked. The default value is false, which tells the system to show a generic 'authentication-failure' message. This is the most secure behavior. If the option is set to true, the system shows a more detailed 'error-message' that says the user is locked. This is more helpful but is less secure, for example, because the difference in error-messages could be used to determine which usernames exist and which do not.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "emit_locked_message_when_user_is_locked")

    @emit_locked_message_when_user_is_locked.setter
    def emit_locked_message_when_user_is_locked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "emit_locked_message_when_user_is_locked", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="myProfile")
    def my_profile(self) -> Optional[pulumi.Input['DomainsIdentitySettingMyProfileArgs']]:
        """
        (Updatable) Whether to allow users to update their own profile.

        **Added In:** 2207040824

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * required: false
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "my_profile")

    @my_profile.setter
    def my_profile(self, value: Optional[pulumi.Input['DomainsIdentitySettingMyProfileArgs']]):
        pulumi.set(self, "my_profile", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="posixGid")
    def posix_gid(self) -> Optional[pulumi.Input['DomainsIdentitySettingPosixGidArgs']]:
        """
        (Updatable) A list of Posix Gid settings.

        **Added In:** 17.4.6

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * required: false
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "posix_gid")

    @posix_gid.setter
    def posix_gid(self, value: Optional[pulumi.Input['DomainsIdentitySettingPosixGidArgs']]):
        pulumi.set(self, "posix_gid", value)

    @property
    @pulumi.getter(name="posixUid")
    def posix_uid(self) -> Optional[pulumi.Input['DomainsIdentitySettingPosixUidArgs']]:
        """
        (Updatable) A list of Posix Uid settings.

        **Added In:** 17.4.6

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * required: false
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "posix_uid")

    @posix_uid.setter
    def posix_uid(self, value: Optional[pulumi.Input['DomainsIdentitySettingPosixUidArgs']]):
        pulumi.set(self, "posix_uid", value)

    @property
    @pulumi.getter(name="primaryEmailRequired")
    def primary_email_required(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates whether the primary email is required.

        **Added In:** 19.1.4

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "primary_email_required")

    @primary_email_required.setter
    def primary_email_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "primary_email_required", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter(name="returnInactiveOverLockedMessage")
    def return_inactive_over_locked_message(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) **Added In:** 2302092332

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none Determines the PasswordAuthenticator API response when a user is both 'locked' and 'inactive.' If false (default), a 'locked' message is shown. If true, an 'inactive' message is shown.
        """
        return pulumi.get(self, "return_inactive_over_locked_message")

    @return_inactive_over_locked_message.setter
    def return_inactive_over_locked_message(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "return_inactive_over_locked_message", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentitySettingTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentitySettingTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def tokens(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentitySettingTokenArgs']]]]:
        """
        (Updatable) A list of tokens and their expiry length.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCompositeKey: [type]
        * multiValued: true
        * required: false
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tokens")

    @tokens.setter
    def tokens(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentitySettingTokenArgs']]]]):
        pulumi.set(self, "tokens", value)

    @property
    @pulumi.getter(name="userAllowedToSetRecoveryEmail")
    def user_allowed_to_set_recovery_email(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates whether a user is allowed to change their own recovery email.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "user_allowed_to_set_recovery_email")

    @user_allowed_to_set_recovery_email.setter
    def user_allowed_to_set_recovery_email(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "user_allowed_to_set_recovery_email", value)


@pulumi.input_type
class _DomainsIdentitySettingState:
    def __init__(__self__, *,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 compartment_ocid: Optional[pulumi.Input[str]] = None,
                 delete_in_progress: Optional[pulumi.Input[bool]] = None,
                 domain_ocid: Optional[pulumi.Input[str]] = None,
                 emit_locked_message_when_user_is_locked: Optional[pulumi.Input[bool]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentitySettingIdcsCreatedByArgs']]]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentitySettingIdcsLastModifiedByArgs']]]] = None,
                 idcs_last_upgraded_in_release: Optional[pulumi.Input[str]] = None,
                 idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 identity_setting_id: Optional[pulumi.Input[str]] = None,
                 metas: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentitySettingMetaArgs']]]] = None,
                 my_profile: Optional[pulumi.Input['DomainsIdentitySettingMyProfileArgs']] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 posix_gid: Optional[pulumi.Input['DomainsIdentitySettingPosixGidArgs']] = None,
                 posix_uid: Optional[pulumi.Input['DomainsIdentitySettingPosixUidArgs']] = None,
                 primary_email_required: Optional[pulumi.Input[bool]] = None,
                 remove_invalid_emails: Optional[pulumi.Input[bool]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 return_inactive_over_locked_message: Optional[pulumi.Input[bool]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentitySettingTagArgs']]]] = None,
                 tenancy_ocid: Optional[pulumi.Input[str]] = None,
                 tokens: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentitySettingTokenArgs']]]] = None,
                 user_allowed_to_set_recovery_email: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering DomainsIdentitySetting resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] emit_locked_message_when_user_is_locked: (Updatable) Indicates whether to show the 'user-is-locked' message during authentication if the user is already locked. The default value is false, which tells the system to show a generic 'authentication-failure' message. This is the most secure behavior. If the option is set to true, the system shows a more detailed 'error-message' that says the user is locked. This is more helpful but is less secure, for example, because the difference in error-messages could be used to determine which usernames exist and which do not.
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsIdentitySettingIdcsCreatedByArgs']]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input['DomainsIdentitySettingIdcsLastModifiedByArgs']]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] identity_setting_id: ID of the resource
        :param pulumi.Input[Sequence[pulumi.Input['DomainsIdentitySettingMetaArgs']]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input['DomainsIdentitySettingMyProfileArgs'] my_profile: (Updatable) Whether to allow users to update their own profile.
               
               **Added In:** 2207040824
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * required: false
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input['DomainsIdentitySettingPosixGidArgs'] posix_gid: (Updatable) A list of Posix Gid settings.
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * required: false
               * type: complex
               * uniqueness: none
        :param pulumi.Input['DomainsIdentitySettingPosixUidArgs'] posix_uid: (Updatable) A list of Posix Uid settings.
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * required: false
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] primary_email_required: (Updatable) Indicates whether the primary email is required.
               
               **Added In:** 19.1.4
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] remove_invalid_emails: (Updatable) Indicates whether to remove non-RFC5322 compliant emails before creating a user.
               
               **Added In:** 2106170416
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[bool] return_inactive_over_locked_message: (Updatable) **Added In:** 2302092332
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none Determines the PasswordAuthenticator API response when a user is both 'locked' and 'inactive.' If false (default), a 'locked' message is shown. If true, an 'inactive' message is shown.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsIdentitySettingTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsIdentitySettingTokenArgs']]] tokens: (Updatable) A list of tokens and their expiry length.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [type]
               * multiValued: true
               * required: false
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] user_allowed_to_set_recovery_email: (Updatable) Indicates whether a user is allowed to change their own recovery email.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if attribute_sets is not None:
            pulumi.set(__self__, "attribute_sets", attribute_sets)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if compartment_ocid is not None:
            pulumi.set(__self__, "compartment_ocid", compartment_ocid)
        if delete_in_progress is not None:
            pulumi.set(__self__, "delete_in_progress", delete_in_progress)
        if domain_ocid is not None:
            pulumi.set(__self__, "domain_ocid", domain_ocid)
        if emit_locked_message_when_user_is_locked is not None:
            pulumi.set(__self__, "emit_locked_message_when_user_is_locked", emit_locked_message_when_user_is_locked)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if idcs_created_bies is not None:
            pulumi.set(__self__, "idcs_created_bies", idcs_created_bies)
        if idcs_endpoint is not None:
            pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        if idcs_last_modified_bies is not None:
            pulumi.set(__self__, "idcs_last_modified_bies", idcs_last_modified_bies)
        if idcs_last_upgraded_in_release is not None:
            pulumi.set(__self__, "idcs_last_upgraded_in_release", idcs_last_upgraded_in_release)
        if idcs_prevented_operations is not None:
            pulumi.set(__self__, "idcs_prevented_operations", idcs_prevented_operations)
        if identity_setting_id is not None:
            pulumi.set(__self__, "identity_setting_id", identity_setting_id)
        if metas is not None:
            pulumi.set(__self__, "metas", metas)
        if my_profile is not None:
            pulumi.set(__self__, "my_profile", my_profile)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if posix_gid is not None:
            pulumi.set(__self__, "posix_gid", posix_gid)
        if posix_uid is not None:
            pulumi.set(__self__, "posix_uid", posix_uid)
        if primary_email_required is not None:
            pulumi.set(__self__, "primary_email_required", primary_email_required)
        if remove_invalid_emails is not None:
            pulumi.set(__self__, "remove_invalid_emails", remove_invalid_emails)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if return_inactive_over_locked_message is not None:
            pulumi.set(__self__, "return_inactive_over_locked_message", return_inactive_over_locked_message)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenancy_ocid is not None:
            pulumi.set(__self__, "tenancy_ocid", tenancy_ocid)
        if tokens is not None:
            pulumi.set(__self__, "tokens", tokens)
        if user_allowed_to_set_recovery_email is not None:
            pulumi.set(__self__, "user_allowed_to_set_recovery_email", user_allowed_to_set_recovery_email)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @compartment_ocid.setter
    def compartment_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_ocid", value)

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @delete_in_progress.setter
    def delete_in_progress(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_in_progress", value)

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @domain_ocid.setter
    def domain_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_ocid", value)

    @property
    @pulumi.getter(name="emitLockedMessageWhenUserIsLocked")
    def emit_locked_message_when_user_is_locked(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates whether to show the 'user-is-locked' message during authentication if the user is already locked. The default value is false, which tells the system to show a generic 'authentication-failure' message. This is the most secure behavior. If the option is set to true, the system shows a more detailed 'error-message' that says the user is locked. This is more helpful but is less secure, for example, because the difference in error-messages could be used to determine which usernames exist and which do not.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "emit_locked_message_when_user_is_locked")

    @emit_locked_message_when_user_is_locked.setter
    def emit_locked_message_when_user_is_locked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "emit_locked_message_when_user_is_locked", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentitySettingIdcsCreatedByArgs']]]]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @idcs_created_bies.setter
    def idcs_created_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentitySettingIdcsCreatedByArgs']]]]):
        pulumi.set(self, "idcs_created_bies", value)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentitySettingIdcsLastModifiedByArgs']]]]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @idcs_last_modified_bies.setter
    def idcs_last_modified_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentitySettingIdcsLastModifiedByArgs']]]]):
        pulumi.set(self, "idcs_last_modified_bies", value)

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idcs_last_upgraded_in_release", value)

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "idcs_prevented_operations", value)

    @property
    @pulumi.getter(name="identitySettingId")
    def identity_setting_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the resource
        """
        return pulumi.get(self, "identity_setting_id")

    @identity_setting_id.setter
    def identity_setting_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_setting_id", value)

    @property
    @pulumi.getter
    def metas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentitySettingMetaArgs']]]]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @metas.setter
    def metas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentitySettingMetaArgs']]]]):
        pulumi.set(self, "metas", value)

    @property
    @pulumi.getter(name="myProfile")
    def my_profile(self) -> Optional[pulumi.Input['DomainsIdentitySettingMyProfileArgs']]:
        """
        (Updatable) Whether to allow users to update their own profile.

        **Added In:** 2207040824

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * required: false
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "my_profile")

    @my_profile.setter
    def my_profile(self, value: Optional[pulumi.Input['DomainsIdentitySettingMyProfileArgs']]):
        pulumi.set(self, "my_profile", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="posixGid")
    def posix_gid(self) -> Optional[pulumi.Input['DomainsIdentitySettingPosixGidArgs']]:
        """
        (Updatable) A list of Posix Gid settings.

        **Added In:** 17.4.6

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * required: false
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "posix_gid")

    @posix_gid.setter
    def posix_gid(self, value: Optional[pulumi.Input['DomainsIdentitySettingPosixGidArgs']]):
        pulumi.set(self, "posix_gid", value)

    @property
    @pulumi.getter(name="posixUid")
    def posix_uid(self) -> Optional[pulumi.Input['DomainsIdentitySettingPosixUidArgs']]:
        """
        (Updatable) A list of Posix Uid settings.

        **Added In:** 17.4.6

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * required: false
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "posix_uid")

    @posix_uid.setter
    def posix_uid(self, value: Optional[pulumi.Input['DomainsIdentitySettingPosixUidArgs']]):
        pulumi.set(self, "posix_uid", value)

    @property
    @pulumi.getter(name="primaryEmailRequired")
    def primary_email_required(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates whether the primary email is required.

        **Added In:** 19.1.4

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "primary_email_required")

    @primary_email_required.setter
    def primary_email_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "primary_email_required", value)

    @property
    @pulumi.getter(name="removeInvalidEmails")
    def remove_invalid_emails(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates whether to remove non-RFC5322 compliant emails before creating a user.

        **Added In:** 2106170416

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "remove_invalid_emails")

    @remove_invalid_emails.setter
    def remove_invalid_emails(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remove_invalid_emails", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter(name="returnInactiveOverLockedMessage")
    def return_inactive_over_locked_message(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) **Added In:** 2302092332

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none Determines the PasswordAuthenticator API response when a user is both 'locked' and 'inactive.' If false (default), a 'locked' message is shown. If true, an 'inactive' message is shown.
        """
        return pulumi.get(self, "return_inactive_over_locked_message")

    @return_inactive_over_locked_message.setter
    def return_inactive_over_locked_message(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "return_inactive_over_locked_message", value)

    @property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentitySettingTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentitySettingTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "tenancy_ocid")

    @tenancy_ocid.setter
    def tenancy_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenancy_ocid", value)

    @property
    @pulumi.getter
    def tokens(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentitySettingTokenArgs']]]]:
        """
        (Updatable) A list of tokens and their expiry length.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCompositeKey: [type]
        * multiValued: true
        * required: false
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tokens")

    @tokens.setter
    def tokens(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentitySettingTokenArgs']]]]):
        pulumi.set(self, "tokens", value)

    @property
    @pulumi.getter(name="userAllowedToSetRecoveryEmail")
    def user_allowed_to_set_recovery_email(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates whether a user is allowed to change their own recovery email.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "user_allowed_to_set_recovery_email")

    @user_allowed_to_set_recovery_email.setter
    def user_allowed_to_set_recovery_email(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "user_allowed_to_set_recovery_email", value)


class DomainsIdentitySetting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 emit_locked_message_when_user_is_locked: Optional[pulumi.Input[bool]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 identity_setting_id: Optional[pulumi.Input[str]] = None,
                 my_profile: Optional[pulumi.Input[pulumi.InputType['DomainsIdentitySettingMyProfileArgs']]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 posix_gid: Optional[pulumi.Input[pulumi.InputType['DomainsIdentitySettingPosixGidArgs']]] = None,
                 posix_uid: Optional[pulumi.Input[pulumi.InputType['DomainsIdentitySettingPosixUidArgs']]] = None,
                 primary_email_required: Optional[pulumi.Input[bool]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 return_inactive_over_locked_message: Optional[pulumi.Input[bool]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentitySettingTagArgs']]]]] = None,
                 tokens: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentitySettingTokenArgs']]]]] = None,
                 user_allowed_to_set_recovery_email: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        This resource provides the Identity Setting resource in Oracle Cloud Infrastructure Identity Domains service.

        Replace an Identity setting.

        ## Import

        IdentitySettings can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsIdentitySetting:DomainsIdentitySetting test_identity_setting "idcsEndpoint/{idcsEndpoint}/identitySettings/{identitySettingId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[bool] emit_locked_message_when_user_is_locked: (Updatable) Indicates whether to show the 'user-is-locked' message during authentication if the user is already locked. The default value is false, which tells the system to show a generic 'authentication-failure' message. This is the most secure behavior. If the option is set to true, the system shows a more detailed 'error-message' that says the user is locked. This is more helpful but is less secure, for example, because the difference in error-messages could be used to determine which usernames exist and which do not.
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[str] identity_setting_id: ID of the resource
        :param pulumi.Input[pulumi.InputType['DomainsIdentitySettingMyProfileArgs']] my_profile: (Updatable) Whether to allow users to update their own profile.
               
               **Added In:** 2207040824
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * required: false
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[pulumi.InputType['DomainsIdentitySettingPosixGidArgs']] posix_gid: (Updatable) A list of Posix Gid settings.
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * required: false
               * type: complex
               * uniqueness: none
        :param pulumi.Input[pulumi.InputType['DomainsIdentitySettingPosixUidArgs']] posix_uid: (Updatable) A list of Posix Uid settings.
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * required: false
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] primary_email_required: (Updatable) Indicates whether the primary email is required.
               
               **Added In:** 19.1.4
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[bool] return_inactive_over_locked_message: (Updatable) **Added In:** 2302092332
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none Determines the PasswordAuthenticator API response when a user is both 'locked' and 'inactive.' If false (default), a 'locked' message is shown. If true, an 'inactive' message is shown.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentitySettingTagArgs']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentitySettingTokenArgs']]]] tokens: (Updatable) A list of tokens and their expiry length.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [type]
               * multiValued: true
               * required: false
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] user_allowed_to_set_recovery_email: (Updatable) Indicates whether a user is allowed to change their own recovery email.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainsIdentitySettingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Identity Setting resource in Oracle Cloud Infrastructure Identity Domains service.

        Replace an Identity setting.

        ## Import

        IdentitySettings can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsIdentitySetting:DomainsIdentitySetting test_identity_setting "idcsEndpoint/{idcsEndpoint}/identitySettings/{identitySettingId}"
        ```

        :param str resource_name: The name of the resource.
        :param DomainsIdentitySettingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainsIdentitySettingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 emit_locked_message_when_user_is_locked: Optional[pulumi.Input[bool]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 identity_setting_id: Optional[pulumi.Input[str]] = None,
                 my_profile: Optional[pulumi.Input[pulumi.InputType['DomainsIdentitySettingMyProfileArgs']]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 posix_gid: Optional[pulumi.Input[pulumi.InputType['DomainsIdentitySettingPosixGidArgs']]] = None,
                 posix_uid: Optional[pulumi.Input[pulumi.InputType['DomainsIdentitySettingPosixUidArgs']]] = None,
                 primary_email_required: Optional[pulumi.Input[bool]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 return_inactive_over_locked_message: Optional[pulumi.Input[bool]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentitySettingTagArgs']]]]] = None,
                 tokens: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentitySettingTokenArgs']]]]] = None,
                 user_allowed_to_set_recovery_email: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainsIdentitySettingArgs.__new__(DomainsIdentitySettingArgs)

            __props__.__dict__["attribute_sets"] = attribute_sets
            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["authorization"] = authorization
            __props__.__dict__["emit_locked_message_when_user_is_locked"] = emit_locked_message_when_user_is_locked
            __props__.__dict__["external_id"] = external_id
            if idcs_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'idcs_endpoint'")
            __props__.__dict__["idcs_endpoint"] = idcs_endpoint
            if identity_setting_id is None and not opts.urn:
                raise TypeError("Missing required property 'identity_setting_id'")
            __props__.__dict__["identity_setting_id"] = identity_setting_id
            __props__.__dict__["my_profile"] = my_profile
            __props__.__dict__["ocid"] = ocid
            __props__.__dict__["posix_gid"] = posix_gid
            __props__.__dict__["posix_uid"] = posix_uid
            __props__.__dict__["primary_email_required"] = primary_email_required
            __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
            __props__.__dict__["return_inactive_over_locked_message"] = return_inactive_over_locked_message
            if schemas is None and not opts.urn:
                raise TypeError("Missing required property 'schemas'")
            __props__.__dict__["schemas"] = schemas
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tokens"] = tokens
            __props__.__dict__["user_allowed_to_set_recovery_email"] = user_allowed_to_set_recovery_email
            __props__.__dict__["compartment_ocid"] = None
            __props__.__dict__["delete_in_progress"] = None
            __props__.__dict__["domain_ocid"] = None
            __props__.__dict__["idcs_created_bies"] = None
            __props__.__dict__["idcs_last_modified_bies"] = None
            __props__.__dict__["idcs_last_upgraded_in_release"] = None
            __props__.__dict__["idcs_prevented_operations"] = None
            __props__.__dict__["metas"] = None
            __props__.__dict__["remove_invalid_emails"] = None
            __props__.__dict__["tenancy_ocid"] = None
        super(DomainsIdentitySetting, __self__).__init__(
            'oci:Identity/domainsIdentitySetting:DomainsIdentitySetting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            attributes: Optional[pulumi.Input[str]] = None,
            authorization: Optional[pulumi.Input[str]] = None,
            compartment_ocid: Optional[pulumi.Input[str]] = None,
            delete_in_progress: Optional[pulumi.Input[bool]] = None,
            domain_ocid: Optional[pulumi.Input[str]] = None,
            emit_locked_message_when_user_is_locked: Optional[pulumi.Input[bool]] = None,
            external_id: Optional[pulumi.Input[str]] = None,
            idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentitySettingIdcsCreatedByArgs']]]]] = None,
            idcs_endpoint: Optional[pulumi.Input[str]] = None,
            idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentitySettingIdcsLastModifiedByArgs']]]]] = None,
            idcs_last_upgraded_in_release: Optional[pulumi.Input[str]] = None,
            idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            identity_setting_id: Optional[pulumi.Input[str]] = None,
            metas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentitySettingMetaArgs']]]]] = None,
            my_profile: Optional[pulumi.Input[pulumi.InputType['DomainsIdentitySettingMyProfileArgs']]] = None,
            ocid: Optional[pulumi.Input[str]] = None,
            posix_gid: Optional[pulumi.Input[pulumi.InputType['DomainsIdentitySettingPosixGidArgs']]] = None,
            posix_uid: Optional[pulumi.Input[pulumi.InputType['DomainsIdentitySettingPosixUidArgs']]] = None,
            primary_email_required: Optional[pulumi.Input[bool]] = None,
            remove_invalid_emails: Optional[pulumi.Input[bool]] = None,
            resource_type_schema_version: Optional[pulumi.Input[str]] = None,
            return_inactive_over_locked_message: Optional[pulumi.Input[bool]] = None,
            schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentitySettingTagArgs']]]]] = None,
            tenancy_ocid: Optional[pulumi.Input[str]] = None,
            tokens: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentitySettingTokenArgs']]]]] = None,
            user_allowed_to_set_recovery_email: Optional[pulumi.Input[bool]] = None) -> 'DomainsIdentitySetting':
        """
        Get an existing DomainsIdentitySetting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] emit_locked_message_when_user_is_locked: (Updatable) Indicates whether to show the 'user-is-locked' message during authentication if the user is already locked. The default value is false, which tells the system to show a generic 'authentication-failure' message. This is the most secure behavior. If the option is set to true, the system shows a more detailed 'error-message' that says the user is locked. This is more helpful but is less secure, for example, because the difference in error-messages could be used to determine which usernames exist and which do not.
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentitySettingIdcsCreatedByArgs']]]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentitySettingIdcsLastModifiedByArgs']]]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] identity_setting_id: ID of the resource
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentitySettingMetaArgs']]]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[pulumi.InputType['DomainsIdentitySettingMyProfileArgs']] my_profile: (Updatable) Whether to allow users to update their own profile.
               
               **Added In:** 2207040824
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * required: false
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[pulumi.InputType['DomainsIdentitySettingPosixGidArgs']] posix_gid: (Updatable) A list of Posix Gid settings.
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * required: false
               * type: complex
               * uniqueness: none
        :param pulumi.Input[pulumi.InputType['DomainsIdentitySettingPosixUidArgs']] posix_uid: (Updatable) A list of Posix Uid settings.
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * required: false
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] primary_email_required: (Updatable) Indicates whether the primary email is required.
               
               **Added In:** 19.1.4
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] remove_invalid_emails: (Updatable) Indicates whether to remove non-RFC5322 compliant emails before creating a user.
               
               **Added In:** 2106170416
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[bool] return_inactive_over_locked_message: (Updatable) **Added In:** 2302092332
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none Determines the PasswordAuthenticator API response when a user is both 'locked' and 'inactive.' If false (default), a 'locked' message is shown. If true, an 'inactive' message is shown.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentitySettingTagArgs']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsIdentitySettingTokenArgs']]]] tokens: (Updatable) A list of tokens and their expiry length.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [type]
               * multiValued: true
               * required: false
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] user_allowed_to_set_recovery_email: (Updatable) Indicates whether a user is allowed to change their own recovery email.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainsIdentitySettingState.__new__(_DomainsIdentitySettingState)

        __props__.__dict__["attribute_sets"] = attribute_sets
        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["compartment_ocid"] = compartment_ocid
        __props__.__dict__["delete_in_progress"] = delete_in_progress
        __props__.__dict__["domain_ocid"] = domain_ocid
        __props__.__dict__["emit_locked_message_when_user_is_locked"] = emit_locked_message_when_user_is_locked
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["idcs_created_bies"] = idcs_created_bies
        __props__.__dict__["idcs_endpoint"] = idcs_endpoint
        __props__.__dict__["idcs_last_modified_bies"] = idcs_last_modified_bies
        __props__.__dict__["idcs_last_upgraded_in_release"] = idcs_last_upgraded_in_release
        __props__.__dict__["idcs_prevented_operations"] = idcs_prevented_operations
        __props__.__dict__["identity_setting_id"] = identity_setting_id
        __props__.__dict__["metas"] = metas
        __props__.__dict__["my_profile"] = my_profile
        __props__.__dict__["ocid"] = ocid
        __props__.__dict__["posix_gid"] = posix_gid
        __props__.__dict__["posix_uid"] = posix_uid
        __props__.__dict__["primary_email_required"] = primary_email_required
        __props__.__dict__["remove_invalid_emails"] = remove_invalid_emails
        __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
        __props__.__dict__["return_inactive_over_locked_message"] = return_inactive_over_locked_message
        __props__.__dict__["schemas"] = schemas
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenancy_ocid"] = tenancy_ocid
        __props__.__dict__["tokens"] = tokens
        __props__.__dict__["user_allowed_to_set_recovery_email"] = user_allowed_to_set_recovery_email
        return DomainsIdentitySetting(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> pulumi.Output[bool]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @property
    @pulumi.getter(name="emitLockedMessageWhenUserIsLocked")
    def emit_locked_message_when_user_is_locked(self) -> pulumi.Output[bool]:
        """
        (Updatable) Indicates whether to show the 'user-is-locked' message during authentication if the user is already locked. The default value is false, which tells the system to show a generic 'authentication-failure' message. This is the most secure behavior. If the option is set to true, the system shows a more detailed 'error-message' that says the user is locked. This is more helpful but is less secure, for example, because the difference in error-messages could be used to determine which usernames exist and which do not.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "emit_locked_message_when_user_is_locked")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[str]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> pulumi.Output[Sequence['outputs.DomainsIdentitySettingIdcsCreatedBy']]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Output[str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> pulumi.Output[Sequence['outputs.DomainsIdentitySettingIdcsLastModifiedBy']]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> pulumi.Output[str]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @property
    @pulumi.getter(name="identitySettingId")
    def identity_setting_id(self) -> pulumi.Output[str]:
        """
        ID of the resource
        """
        return pulumi.get(self, "identity_setting_id")

    @property
    @pulumi.getter
    def metas(self) -> pulumi.Output[Sequence['outputs.DomainsIdentitySettingMeta']]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @property
    @pulumi.getter(name="myProfile")
    def my_profile(self) -> pulumi.Output['outputs.DomainsIdentitySettingMyProfile']:
        """
        (Updatable) Whether to allow users to update their own profile.

        **Added In:** 2207040824

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * required: false
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "my_profile")

    @property
    @pulumi.getter
    def ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @property
    @pulumi.getter(name="posixGid")
    def posix_gid(self) -> pulumi.Output['outputs.DomainsIdentitySettingPosixGid']:
        """
        (Updatable) A list of Posix Gid settings.

        **Added In:** 17.4.6

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * required: false
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "posix_gid")

    @property
    @pulumi.getter(name="posixUid")
    def posix_uid(self) -> pulumi.Output['outputs.DomainsIdentitySettingPosixUid']:
        """
        (Updatable) A list of Posix Uid settings.

        **Added In:** 17.4.6

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * required: false
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "posix_uid")

    @property
    @pulumi.getter(name="primaryEmailRequired")
    def primary_email_required(self) -> pulumi.Output[bool]:
        """
        (Updatable) Indicates whether the primary email is required.

        **Added In:** 19.1.4

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "primary_email_required")

    @property
    @pulumi.getter(name="removeInvalidEmails")
    def remove_invalid_emails(self) -> pulumi.Output[bool]:
        """
        (Updatable) Indicates whether to remove non-RFC5322 compliant emails before creating a user.

        **Added In:** 2106170416

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "remove_invalid_emails")

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @property
    @pulumi.getter(name="returnInactiveOverLockedMessage")
    def return_inactive_over_locked_message(self) -> pulumi.Output[bool]:
        """
        (Updatable) **Added In:** 2302092332

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none Determines the PasswordAuthenticator API response when a user is both 'locked' and 'inactive.' If false (default), a 'locked' message is shown. If true, an 'inactive' message is shown.
        """
        return pulumi.get(self, "return_inactive_over_locked_message")

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.DomainsIdentitySettingTag']]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "tenancy_ocid")

    @property
    @pulumi.getter
    def tokens(self) -> pulumi.Output[Sequence['outputs.DomainsIdentitySettingToken']]:
        """
        (Updatable) A list of tokens and their expiry length.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCompositeKey: [type]
        * multiValued: true
        * required: false
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tokens")

    @property
    @pulumi.getter(name="userAllowedToSetRecoveryEmail")
    def user_allowed_to_set_recovery_email(self) -> pulumi.Output[bool]:
        """
        (Updatable) Indicates whether a user is allowed to change their own recovery email.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "user_allowed_to_set_recovery_email")

