# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'LogConfiguration',
    'LogConfigurationSource',
    'UnifiedAgentConfigurationGroupAssociation',
    'UnifiedAgentConfigurationServiceConfiguration',
    'UnifiedAgentConfigurationServiceConfigurationApplicationConfiguration',
    'UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationDestination',
    'UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSource',
    'UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceAdvancedOptions',
    'UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParser',
    'UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserNestedParser',
    'UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserPattern',
    'UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserRecordInput',
    'UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationUnifiedAgentConfigurationFilter',
    'UnifiedAgentConfigurationServiceConfigurationDestination',
    'UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfiguration',
    'UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationDestination',
    'UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSource',
    'UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceRecordInput',
    'UnifiedAgentConfigurationServiceConfigurationSource',
    'UnifiedAgentConfigurationServiceConfigurationSourceAdvancedOptions',
    'UnifiedAgentConfigurationServiceConfigurationSourceParser',
    'UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParser',
    'UnifiedAgentConfigurationServiceConfigurationSourceParserPattern',
    'UnifiedAgentConfigurationServiceConfigurationSourceParserRecordInput',
    'UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilter',
    'UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterAllowList',
    'UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterCustomSection',
    'UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterDenyList',
    'UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParser',
    'UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserNestedParser',
    'UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserPattern',
    'UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserRecordInput',
    'UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterRecordList',
    'GetLogConfigurationResult',
    'GetLogConfigurationSourceResult',
    'GetLogGroupsFilterResult',
    'GetLogGroupsLogGroupResult',
    'GetLogSavedSearchesFilterResult',
    'GetLogSavedSearchesLogSavedSearchSummaryCollectionResult',
    'GetLogSavedSearchesLogSavedSearchSummaryCollectionItemResult',
    'GetLogsFilterResult',
    'GetLogsLogResult',
    'GetLogsLogConfigurationResult',
    'GetLogsLogConfigurationSourceResult',
    'GetUnifiedAgentConfigurationGroupAssociationResult',
    'GetUnifiedAgentConfigurationServiceConfigurationResult',
    'GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationResult',
    'GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationDestinationResult',
    'GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceResult',
    'GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceAdvancedOptionResult',
    'GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserResult',
    'GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserNestedParserResult',
    'GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserPatternResult',
    'GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserRecordInputResult',
    'GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationUnifiedAgentConfigurationFilterResult',
    'GetUnifiedAgentConfigurationServiceConfigurationDestinationResult',
    'GetUnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationResult',
    'GetUnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationDestinationResult',
    'GetUnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceResult',
    'GetUnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceRecordInputResult',
    'GetUnifiedAgentConfigurationServiceConfigurationSourceResult',
    'GetUnifiedAgentConfigurationServiceConfigurationSourceAdvancedOptionResult',
    'GetUnifiedAgentConfigurationServiceConfigurationSourceParserResult',
    'GetUnifiedAgentConfigurationServiceConfigurationSourceParserNestedParserResult',
    'GetUnifiedAgentConfigurationServiceConfigurationSourceParserPatternResult',
    'GetUnifiedAgentConfigurationServiceConfigurationSourceParserRecordInputResult',
    'GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterResult',
    'GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterAllowListResult',
    'GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterCustomSectionResult',
    'GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterDenyListResult',
    'GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserResult',
    'GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserNestedParserResult',
    'GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserPatternResult',
    'GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserRecordInputResult',
    'GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterRecordListResult',
    'GetUnifiedAgentConfigurationsFilterResult',
    'GetUnifiedAgentConfigurationsUnifiedAgentConfigurationCollectionResult',
    'GetUnifiedAgentConfigurationsUnifiedAgentConfigurationCollectionItemResult',
]

@pulumi.output_type
class LogConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compartmentId":
            suggest = "compartment_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source: 'outputs.LogConfigurationSource',
                 compartment_id: Optional[str] = None):
        """
        :param 'LogConfigurationSourceArgs' source: The source the log object comes from.
        :param str compartment_id: The OCID of the compartment that the resource belongs to.
        """
        pulumi.set(__self__, "source", source)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)

    @property
    @pulumi.getter
    def source(self) -> 'outputs.LogConfigurationSource':
        """
        The source the log object comes from.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The OCID of the compartment that the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")


@pulumi.output_type
class LogConfigurationSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceType":
            suggest = "source_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogConfigurationSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogConfigurationSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogConfigurationSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 category: str,
                 resource: str,
                 service: str,
                 source_type: str,
                 parameters: Optional[Mapping[str, Any]] = None):
        """
        :param str category: Log object category.
        :param str resource: The unique identifier of the resource emitting the log.
        :param str service: Service generating log.
        :param str source_type: The log source.
               * **OCISERVICE:** Oracle Service.
        :param Mapping[str, Any] parameters: (Updatable) Log category parameters are stored here.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "source_type", source_type)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        Log object category.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def resource(self) -> str:
        """
        The unique identifier of the resource emitting the log.
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Service generating log.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        The log source.
        * **OCISERVICE:** Oracle Service.
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, Any]]:
        """
        (Updatable) Log category parameters are stored here.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class UnifiedAgentConfigurationGroupAssociation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupLists":
            suggest = "group_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationGroupAssociation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationGroupAssociation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationGroupAssociation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_lists: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] group_lists: (Updatable) list of group/dynamic group ids associated with this configuration.
        """
        if group_lists is not None:
            pulumi.set(__self__, "group_lists", group_lists)

    @property
    @pulumi.getter(name="groupLists")
    def group_lists(self) -> Optional[Sequence[str]]:
        """
        (Updatable) list of group/dynamic group ids associated with this configuration.
        """
        return pulumi.get(self, "group_lists")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configurationType":
            suggest = "configuration_type"
        elif key == "applicationConfigurations":
            suggest = "application_configurations"
        elif key == "unifiedAgentConfigurationFilters":
            suggest = "unified_agent_configuration_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration_type: str,
                 application_configurations: Optional[Sequence['outputs.UnifiedAgentConfigurationServiceConfigurationApplicationConfiguration']] = None,
                 destination: Optional['outputs.UnifiedAgentConfigurationServiceConfigurationDestination'] = None,
                 sources: Optional[Sequence['outputs.UnifiedAgentConfigurationServiceConfigurationSource']] = None,
                 unified_agent_configuration_filters: Optional[Sequence['outputs.UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilter']] = None):
        """
        :param str configuration_type: (Updatable) Type of Unified Agent service configuration.
        :param Sequence['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationArgs'] application_configurations: (Updatable) Unified Agent monitoring application configuration details.
        :param 'UnifiedAgentConfigurationServiceConfigurationDestinationArgs' destination: (Updatable) Unified monitoring agent operational metrics destination object.
        :param Sequence['UnifiedAgentConfigurationServiceConfigurationSourceArgs'] sources: (Updatable) Logging source object.
        :param Sequence['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterArgs'] unified_agent_configuration_filters: (Updatable) Logging filter object.
        """
        pulumi.set(__self__, "configuration_type", configuration_type)
        if application_configurations is not None:
            pulumi.set(__self__, "application_configurations", application_configurations)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if unified_agent_configuration_filters is not None:
            pulumi.set(__self__, "unified_agent_configuration_filters", unified_agent_configuration_filters)

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> str:
        """
        (Updatable) Type of Unified Agent service configuration.
        """
        return pulumi.get(self, "configuration_type")

    @property
    @pulumi.getter(name="applicationConfigurations")
    def application_configurations(self) -> Optional[Sequence['outputs.UnifiedAgentConfigurationServiceConfigurationApplicationConfiguration']]:
        """
        (Updatable) Unified Agent monitoring application configuration details.
        """
        return pulumi.get(self, "application_configurations")

    @property
    @pulumi.getter
    def destination(self) -> Optional['outputs.UnifiedAgentConfigurationServiceConfigurationDestination']:
        """
        (Updatable) Unified monitoring agent operational metrics destination object.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def sources(self) -> Optional[Sequence['outputs.UnifiedAgentConfigurationServiceConfigurationSource']]:
        """
        (Updatable) Logging source object.
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter(name="unifiedAgentConfigurationFilters")
    def unified_agent_configuration_filters(self) -> Optional[Sequence['outputs.UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilter']]:
        """
        (Updatable) Logging filter object.
        """
        return pulumi.get(self, "unified_agent_configuration_filters")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationApplicationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceType":
            suggest = "source_type"
        elif key == "unifiedAgentConfigurationFilter":
            suggest = "unified_agent_configuration_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfigurationApplicationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfigurationApplicationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfigurationApplicationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: 'outputs.UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationDestination',
                 source_type: str,
                 source: Optional['outputs.UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSource'] = None,
                 sources: Optional[Sequence['outputs.UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSource']] = None,
                 unified_agent_configuration_filter: Optional['outputs.UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationUnifiedAgentConfigurationFilter'] = None):
        """
        :param 'UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationDestinationArgs' destination: (Updatable) Unified monitoring agent operational metrics destination object.
        :param str source_type: (Updatable) Unified schema logging source type.
        :param 'UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceArgs' source: (Updatable) Unified monitoring agent operational metrics source object.
        :param Sequence['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceArgs'] sources: (Updatable) Logging source object.
        :param 'UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationUnifiedAgentConfigurationFilterArgs' unified_agent_configuration_filter: (Updatable) Logging filter object.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "source_type", source_type)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if unified_agent_configuration_filter is not None:
            pulumi.set(__self__, "unified_agent_configuration_filter", unified_agent_configuration_filter)

    @property
    @pulumi.getter
    def destination(self) -> 'outputs.UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationDestination':
        """
        (Updatable) Unified monitoring agent operational metrics destination object.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        (Updatable) Unified schema logging source type.
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter
    def source(self) -> Optional['outputs.UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSource']:
        """
        (Updatable) Unified monitoring agent operational metrics source object.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def sources(self) -> Optional[Sequence['outputs.UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSource']]:
        """
        (Updatable) Logging source object.
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter(name="unifiedAgentConfigurationFilter")
    def unified_agent_configuration_filter(self) -> Optional['outputs.UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationUnifiedAgentConfigurationFilter']:
        """
        (Updatable) Logging filter object.
        """
        return pulumi.get(self, "unified_agent_configuration_filter")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compartmentId":
            suggest = "compartment_id"
        elif key == "metricsNamespace":
            suggest = "metrics_namespace"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compartment_id: Optional[str] = None,
                 metrics_namespace: Optional[str] = None):
        """
        :param str compartment_id: (Updatable) The OCID of the compartment that the resource belongs to.
        :param str metrics_namespace: (Updatable) Namespace to which metrics will be emitted.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if metrics_namespace is not None:
            pulumi.set(__self__, "metrics_namespace", metrics_namespace)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        (Updatable) The OCID of the compartment that the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="metricsNamespace")
    def metrics_namespace(self) -> Optional[str]:
        """
        (Updatable) Namespace to which metrics will be emitted.
        """
        return pulumi.get(self, "metrics_namespace")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "advancedOptions":
            suggest = "advanced_options"
        elif key == "sourceType":
            suggest = "source_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 advanced_options: Optional['outputs.UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceAdvancedOptions'] = None,
                 name: Optional[str] = None,
                 parser: Optional['outputs.UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParser'] = None,
                 paths: Optional[Sequence[str]] = None,
                 source_type: Optional[str] = None):
        """
        :param 'UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceAdvancedOptionsArgs' advanced_options: (Updatable) Advanced options for logging configuration
        :param str name: (Updatable) The name key to tag this Grok pattern.
        :param 'UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserArgs' parser: (Updatable) Source parser object.
        :param Sequence[str] paths: (Updatable) Absolute paths for log source files. Wildcards can be used.
        :param str source_type: (Updatable) Unified schema logging source type.
        """
        if advanced_options is not None:
            pulumi.set(__self__, "advanced_options", advanced_options)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parser is not None:
            pulumi.set(__self__, "parser", parser)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="advancedOptions")
    def advanced_options(self) -> Optional['outputs.UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceAdvancedOptions']:
        """
        (Updatable) Advanced options for logging configuration
        """
        return pulumi.get(self, "advanced_options")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        (Updatable) The name key to tag this Grok pattern.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parser(self) -> Optional['outputs.UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParser']:
        """
        (Updatable) Source parser object.
        """
        return pulumi.get(self, "parser")

    @property
    @pulumi.getter
    def paths(self) -> Optional[Sequence[str]]:
        """
        (Updatable) Absolute paths for log source files. Wildcards can be used.
        """
        return pulumi.get(self, "paths")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[str]:
        """
        (Updatable) Unified schema logging source type.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceAdvancedOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isReadFromHead":
            suggest = "is_read_from_head"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceAdvancedOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceAdvancedOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceAdvancedOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_read_from_head: Optional[bool] = None):
        """
        :param bool is_read_from_head: (Updatable) Starts to read the logs from the head of the file or the last read position recorded in pos_file, not tail.
        """
        if is_read_from_head is not None:
            pulumi.set(__self__, "is_read_from_head", is_read_from_head)

    @property
    @pulumi.getter(name="isReadFromHead")
    def is_read_from_head(self) -> Optional[bool]:
        """
        (Updatable) Starts to read the logs from the head of the file or the last read position recorded in pos_file, not tail.
        """
        return pulumi.get(self, "is_read_from_head")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParser(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parserType":
            suggest = "parser_type"
        elif key == "fieldTimeKey":
            suggest = "field_time_key"
        elif key == "formatFirstline":
            suggest = "format_firstline"
        elif key == "grokFailureKey":
            suggest = "grok_failure_key"
        elif key == "grokNameKey":
            suggest = "grok_name_key"
        elif key == "isEstimateCurrentEvent":
            suggest = "is_estimate_current_event"
        elif key == "isKeepTimeKey":
            suggest = "is_keep_time_key"
        elif key == "isMergeCriFields":
            suggest = "is_merge_cri_fields"
        elif key == "isNullEmptyString":
            suggest = "is_null_empty_string"
        elif key == "isSupportColonlessIdent":
            suggest = "is_support_colonless_ident"
        elif key == "isWithPriority":
            suggest = "is_with_priority"
        elif key == "messageFormat":
            suggest = "message_format"
        elif key == "messageKey":
            suggest = "message_key"
        elif key == "multiLineStartRegexp":
            suggest = "multi_line_start_regexp"
        elif key == "nestedParser":
            suggest = "nested_parser"
        elif key == "nullValuePattern":
            suggest = "null_value_pattern"
        elif key == "parseNested":
            suggest = "parse_nested"
        elif key == "recordInput":
            suggest = "record_input"
        elif key == "rfc5424timeFormat":
            suggest = "rfc5424time_format"
        elif key == "syslogParserType":
            suggest = "syslog_parser_type"
        elif key == "timeFormat":
            suggest = "time_format"
        elif key == "timeType":
            suggest = "time_type"
        elif key == "timeoutInMilliseconds":
            suggest = "timeout_in_milliseconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParser. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParser.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParser.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parser_type: str,
                 delimiter: Optional[str] = None,
                 expression: Optional[str] = None,
                 field_time_key: Optional[str] = None,
                 format_firstline: Optional[str] = None,
                 formats: Optional[Sequence[str]] = None,
                 grok_failure_key: Optional[str] = None,
                 grok_name_key: Optional[str] = None,
                 is_estimate_current_event: Optional[bool] = None,
                 is_keep_time_key: Optional[bool] = None,
                 is_merge_cri_fields: Optional[bool] = None,
                 is_null_empty_string: Optional[bool] = None,
                 is_support_colonless_ident: Optional[bool] = None,
                 is_with_priority: Optional[bool] = None,
                 keys: Optional[Sequence[str]] = None,
                 message_format: Optional[str] = None,
                 message_key: Optional[str] = None,
                 multi_line_start_regexp: Optional[str] = None,
                 nested_parser: Optional['outputs.UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserNestedParser'] = None,
                 null_value_pattern: Optional[str] = None,
                 parse_nested: Optional[bool] = None,
                 patterns: Optional[Sequence['outputs.UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserPattern']] = None,
                 record_input: Optional['outputs.UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserRecordInput'] = None,
                 rfc5424time_format: Optional[str] = None,
                 separator: Optional[str] = None,
                 syslog_parser_type: Optional[str] = None,
                 time_format: Optional[str] = None,
                 time_type: Optional[str] = None,
                 timeout_in_milliseconds: Optional[int] = None,
                 types: Optional[Mapping[str, Any]] = None):
        """
        :param str parser_type: (Updatable) Type of fluent parser.
        :param str delimiter: (Updatable) CSV delimiter.
        :param str expression: (Updatable) Regex pattern.
        :param str field_time_key: (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param str format_firstline: (Updatable) First line pattern format.
        :param Sequence[str] formats: (Updatable) Mutiline pattern format.
        :param str grok_failure_key: (Updatable) Grok failure key.
        :param str grok_name_key: (Updatable) Grok name key.
        :param bool is_estimate_current_event: (Updatable) If true, use Fluent::EventTime.now(current time) as a timestamp when the time_key is specified.
        :param bool is_keep_time_key: (Updatable) If true, keep the time field in the record.
        :param bool is_merge_cri_fields: (Updatable) If you don't need stream or logtag fields, set this to false.
        :param bool is_null_empty_string: (Updatable) If true, an empty string field is replaced with a null value.
        :param bool is_support_colonless_ident: (Updatable) Specifies whether or not to support colonless ident. Corresponds to the Fluentd support_colonless_ident parameter.
        :param bool is_with_priority: (Updatable) Specifies with priority or not. Corresponds to the Fluentd with_priority parameter.
        :param Sequence[str] keys: (Updatable) CSV keys.
        :param str message_format: (Updatable) Syslog message format.
        :param str message_key: (Updatable) Specifies the field name to contain logs.
        :param str multi_line_start_regexp: (Updatable) Multiline start regexp pattern.
        :param 'UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserNestedParserArgs' nested_parser: (Updatable) Optional nested JSON Parser for CRI. Supported fields are fieldTimeKey, timeFormat, and isKeepTimeKey.
        :param str null_value_pattern: (Updatable) Specify the null value pattern.
        :param bool parse_nested: (Updatable) If true, a separator parameter can be further defined.
        :param Sequence['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserPatternArgs'] patterns: (Updatable) Grok pattern object.
        :param 'UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserRecordInputArgs' record_input: (Updatable) record section of openmetrics parser.
        :param str rfc5424time_format: (Updatable) RFC 5424 time format.
        :param str separator: (Updatable) Keys of adjacent levels are joined by the separator.
        :param str syslog_parser_type: (Updatable) Syslog parser type.
        :param str time_format: (Updatable) Process time value using the specified format.
        :param str time_type: (Updatable) JSON parser time type.
        :param int timeout_in_milliseconds: (Updatable) Specify the timeout for parse processing. This is mainly for detecting an incorrect regexp pattern.
        :param Mapping[str, Any] types: (Updatable) Specify types for converting a field into another type. For example, With this configuration: <parse> @type csv keys time,host,req_id,user time_key time </parse>
               
               This incoming event: "2013/02/28 12:00:00,192.168.0.1,111,-"
               
               is parsed as: 1362020400 (2013/02/28/ 12:00:00)
               
               record: { "host"   : "192.168.0.1", "req_id" : "111", "user"   : "-" }
        """
        pulumi.set(__self__, "parser_type", parser_type)
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if field_time_key is not None:
            pulumi.set(__self__, "field_time_key", field_time_key)
        if format_firstline is not None:
            pulumi.set(__self__, "format_firstline", format_firstline)
        if formats is not None:
            pulumi.set(__self__, "formats", formats)
        if grok_failure_key is not None:
            pulumi.set(__self__, "grok_failure_key", grok_failure_key)
        if grok_name_key is not None:
            pulumi.set(__self__, "grok_name_key", grok_name_key)
        if is_estimate_current_event is not None:
            pulumi.set(__self__, "is_estimate_current_event", is_estimate_current_event)
        if is_keep_time_key is not None:
            pulumi.set(__self__, "is_keep_time_key", is_keep_time_key)
        if is_merge_cri_fields is not None:
            pulumi.set(__self__, "is_merge_cri_fields", is_merge_cri_fields)
        if is_null_empty_string is not None:
            pulumi.set(__self__, "is_null_empty_string", is_null_empty_string)
        if is_support_colonless_ident is not None:
            pulumi.set(__self__, "is_support_colonless_ident", is_support_colonless_ident)
        if is_with_priority is not None:
            pulumi.set(__self__, "is_with_priority", is_with_priority)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if message_format is not None:
            pulumi.set(__self__, "message_format", message_format)
        if message_key is not None:
            pulumi.set(__self__, "message_key", message_key)
        if multi_line_start_regexp is not None:
            pulumi.set(__self__, "multi_line_start_regexp", multi_line_start_regexp)
        if nested_parser is not None:
            pulumi.set(__self__, "nested_parser", nested_parser)
        if null_value_pattern is not None:
            pulumi.set(__self__, "null_value_pattern", null_value_pattern)
        if parse_nested is not None:
            pulumi.set(__self__, "parse_nested", parse_nested)
        if patterns is not None:
            pulumi.set(__self__, "patterns", patterns)
        if record_input is not None:
            pulumi.set(__self__, "record_input", record_input)
        if rfc5424time_format is not None:
            pulumi.set(__self__, "rfc5424time_format", rfc5424time_format)
        if separator is not None:
            pulumi.set(__self__, "separator", separator)
        if syslog_parser_type is not None:
            pulumi.set(__self__, "syslog_parser_type", syslog_parser_type)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)
        if time_type is not None:
            pulumi.set(__self__, "time_type", time_type)
        if timeout_in_milliseconds is not None:
            pulumi.set(__self__, "timeout_in_milliseconds", timeout_in_milliseconds)
        if types is not None:
            pulumi.set(__self__, "types", types)

    @property
    @pulumi.getter(name="parserType")
    def parser_type(self) -> str:
        """
        (Updatable) Type of fluent parser.
        """
        return pulumi.get(self, "parser_type")

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[str]:
        """
        (Updatable) CSV delimiter.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter
    def expression(self) -> Optional[str]:
        """
        (Updatable) Regex pattern.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> Optional[str]:
        """
        (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @property
    @pulumi.getter(name="formatFirstline")
    def format_firstline(self) -> Optional[str]:
        """
        (Updatable) First line pattern format.
        """
        return pulumi.get(self, "format_firstline")

    @property
    @pulumi.getter
    def formats(self) -> Optional[Sequence[str]]:
        """
        (Updatable) Mutiline pattern format.
        """
        return pulumi.get(self, "formats")

    @property
    @pulumi.getter(name="grokFailureKey")
    def grok_failure_key(self) -> Optional[str]:
        """
        (Updatable) Grok failure key.
        """
        return pulumi.get(self, "grok_failure_key")

    @property
    @pulumi.getter(name="grokNameKey")
    def grok_name_key(self) -> Optional[str]:
        """
        (Updatable) Grok name key.
        """
        return pulumi.get(self, "grok_name_key")

    @property
    @pulumi.getter(name="isEstimateCurrentEvent")
    def is_estimate_current_event(self) -> Optional[bool]:
        """
        (Updatable) If true, use Fluent::EventTime.now(current time) as a timestamp when the time_key is specified.
        """
        return pulumi.get(self, "is_estimate_current_event")

    @property
    @pulumi.getter(name="isKeepTimeKey")
    def is_keep_time_key(self) -> Optional[bool]:
        """
        (Updatable) If true, keep the time field in the record.
        """
        return pulumi.get(self, "is_keep_time_key")

    @property
    @pulumi.getter(name="isMergeCriFields")
    def is_merge_cri_fields(self) -> Optional[bool]:
        """
        (Updatable) If you don't need stream or logtag fields, set this to false.
        """
        return pulumi.get(self, "is_merge_cri_fields")

    @property
    @pulumi.getter(name="isNullEmptyString")
    def is_null_empty_string(self) -> Optional[bool]:
        """
        (Updatable) If true, an empty string field is replaced with a null value.
        """
        return pulumi.get(self, "is_null_empty_string")

    @property
    @pulumi.getter(name="isSupportColonlessIdent")
    def is_support_colonless_ident(self) -> Optional[bool]:
        """
        (Updatable) Specifies whether or not to support colonless ident. Corresponds to the Fluentd support_colonless_ident parameter.
        """
        return pulumi.get(self, "is_support_colonless_ident")

    @property
    @pulumi.getter(name="isWithPriority")
    def is_with_priority(self) -> Optional[bool]:
        """
        (Updatable) Specifies with priority or not. Corresponds to the Fluentd with_priority parameter.
        """
        return pulumi.get(self, "is_with_priority")

    @property
    @pulumi.getter
    def keys(self) -> Optional[Sequence[str]]:
        """
        (Updatable) CSV keys.
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> Optional[str]:
        """
        (Updatable) Syslog message format.
        """
        return pulumi.get(self, "message_format")

    @property
    @pulumi.getter(name="messageKey")
    def message_key(self) -> Optional[str]:
        """
        (Updatable) Specifies the field name to contain logs.
        """
        return pulumi.get(self, "message_key")

    @property
    @pulumi.getter(name="multiLineStartRegexp")
    def multi_line_start_regexp(self) -> Optional[str]:
        """
        (Updatable) Multiline start regexp pattern.
        """
        return pulumi.get(self, "multi_line_start_regexp")

    @property
    @pulumi.getter(name="nestedParser")
    def nested_parser(self) -> Optional['outputs.UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserNestedParser']:
        """
        (Updatable) Optional nested JSON Parser for CRI. Supported fields are fieldTimeKey, timeFormat, and isKeepTimeKey.
        """
        return pulumi.get(self, "nested_parser")

    @property
    @pulumi.getter(name="nullValuePattern")
    def null_value_pattern(self) -> Optional[str]:
        """
        (Updatable) Specify the null value pattern.
        """
        return pulumi.get(self, "null_value_pattern")

    @property
    @pulumi.getter(name="parseNested")
    def parse_nested(self) -> Optional[bool]:
        """
        (Updatable) If true, a separator parameter can be further defined.
        """
        return pulumi.get(self, "parse_nested")

    @property
    @pulumi.getter
    def patterns(self) -> Optional[Sequence['outputs.UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserPattern']]:
        """
        (Updatable) Grok pattern object.
        """
        return pulumi.get(self, "patterns")

    @property
    @pulumi.getter(name="recordInput")
    def record_input(self) -> Optional['outputs.UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserRecordInput']:
        """
        (Updatable) record section of openmetrics parser.
        """
        return pulumi.get(self, "record_input")

    @property
    @pulumi.getter(name="rfc5424timeFormat")
    def rfc5424time_format(self) -> Optional[str]:
        """
        (Updatable) RFC 5424 time format.
        """
        return pulumi.get(self, "rfc5424time_format")

    @property
    @pulumi.getter
    def separator(self) -> Optional[str]:
        """
        (Updatable) Keys of adjacent levels are joined by the separator.
        """
        return pulumi.get(self, "separator")

    @property
    @pulumi.getter(name="syslogParserType")
    def syslog_parser_type(self) -> Optional[str]:
        """
        (Updatable) Syslog parser type.
        """
        return pulumi.get(self, "syslog_parser_type")

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[str]:
        """
        (Updatable) Process time value using the specified format.
        """
        return pulumi.get(self, "time_format")

    @property
    @pulumi.getter(name="timeType")
    def time_type(self) -> Optional[str]:
        """
        (Updatable) JSON parser time type.
        """
        return pulumi.get(self, "time_type")

    @property
    @pulumi.getter(name="timeoutInMilliseconds")
    def timeout_in_milliseconds(self) -> Optional[int]:
        """
        (Updatable) Specify the timeout for parse processing. This is mainly for detecting an incorrect regexp pattern.
        """
        return pulumi.get(self, "timeout_in_milliseconds")

    @property
    @pulumi.getter
    def types(self) -> Optional[Mapping[str, Any]]:
        """
        (Updatable) Specify types for converting a field into another type. For example, With this configuration: <parse> @type csv keys time,host,req_id,user time_key time </parse>

        This incoming event: "2013/02/28 12:00:00,192.168.0.1,111,-"

        is parsed as: 1362020400 (2013/02/28/ 12:00:00)

        record: { "host"   : "192.168.0.1", "req_id" : "111", "user"   : "-" }
        """
        return pulumi.get(self, "types")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserNestedParser(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldTimeKey":
            suggest = "field_time_key"
        elif key == "isKeepTimeKey":
            suggest = "is_keep_time_key"
        elif key == "parseNested":
            suggest = "parse_nested"
        elif key == "timeFormat":
            suggest = "time_format"
        elif key == "timeType":
            suggest = "time_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserNestedParser. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserNestedParser.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserNestedParser.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_time_key: Optional[str] = None,
                 is_keep_time_key: Optional[bool] = None,
                 parse_nested: Optional[bool] = None,
                 separator: Optional[str] = None,
                 time_format: Optional[str] = None,
                 time_type: Optional[str] = None):
        """
        :param str field_time_key: (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param bool is_keep_time_key: (Updatable) If true, keep the time field in the record.
        :param bool parse_nested: (Updatable) If true, a separator parameter can be further defined.
        :param str separator: (Updatable) Keys of adjacent levels are joined by the separator.
        :param str time_format: (Updatable) Process time value using the specified format.
        :param str time_type: (Updatable) JSON parser time type.
        """
        if field_time_key is not None:
            pulumi.set(__self__, "field_time_key", field_time_key)
        if is_keep_time_key is not None:
            pulumi.set(__self__, "is_keep_time_key", is_keep_time_key)
        if parse_nested is not None:
            pulumi.set(__self__, "parse_nested", parse_nested)
        if separator is not None:
            pulumi.set(__self__, "separator", separator)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)
        if time_type is not None:
            pulumi.set(__self__, "time_type", time_type)

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> Optional[str]:
        """
        (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @property
    @pulumi.getter(name="isKeepTimeKey")
    def is_keep_time_key(self) -> Optional[bool]:
        """
        (Updatable) If true, keep the time field in the record.
        """
        return pulumi.get(self, "is_keep_time_key")

    @property
    @pulumi.getter(name="parseNested")
    def parse_nested(self) -> Optional[bool]:
        """
        (Updatable) If true, a separator parameter can be further defined.
        """
        return pulumi.get(self, "parse_nested")

    @property
    @pulumi.getter
    def separator(self) -> Optional[str]:
        """
        (Updatable) Keys of adjacent levels are joined by the separator.
        """
        return pulumi.get(self, "separator")

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[str]:
        """
        (Updatable) Process time value using the specified format.
        """
        return pulumi.get(self, "time_format")

    @property
    @pulumi.getter(name="timeType")
    def time_type(self) -> Optional[str]:
        """
        (Updatable) JSON parser time type.
        """
        return pulumi.get(self, "time_type")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserPattern(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldTimeFormat":
            suggest = "field_time_format"
        elif key == "fieldTimeKey":
            suggest = "field_time_key"
        elif key == "fieldTimeZone":
            suggest = "field_time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserPattern. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserPattern.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserPattern.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_time_format: Optional[str] = None,
                 field_time_key: Optional[str] = None,
                 field_time_zone: Optional[str] = None,
                 name: Optional[str] = None,
                 pattern: Optional[str] = None):
        """
        :param str field_time_format: (Updatable) Process value using the specified format. This is available only when time_type is a string.
        :param str field_time_key: (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param str field_time_zone: (Updatable) Use the specified time zone. The time value can be parsed or formatted in the specified time zone.
        :param str name: (Updatable) The name key to tag this Grok pattern.
        :param str pattern: (Updatable) The Grok pattern.
        """
        if field_time_format is not None:
            pulumi.set(__self__, "field_time_format", field_time_format)
        if field_time_key is not None:
            pulumi.set(__self__, "field_time_key", field_time_key)
        if field_time_zone is not None:
            pulumi.set(__self__, "field_time_zone", field_time_zone)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)

    @property
    @pulumi.getter(name="fieldTimeFormat")
    def field_time_format(self) -> Optional[str]:
        """
        (Updatable) Process value using the specified format. This is available only when time_type is a string.
        """
        return pulumi.get(self, "field_time_format")

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> Optional[str]:
        """
        (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @property
    @pulumi.getter(name="fieldTimeZone")
    def field_time_zone(self) -> Optional[str]:
        """
        (Updatable) Use the specified time zone. The time value can be parsed or formatted in the specified time zone.
        """
        return pulumi.get(self, "field_time_zone")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        (Updatable) The name key to tag this Grok pattern.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def pattern(self) -> Optional[str]:
        """
        (Updatable) The Grok pattern.
        """
        return pulumi.get(self, "pattern")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserRecordInput(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceGroup":
            suggest = "resource_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserRecordInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserRecordInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserRecordInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimensions: Optional[Mapping[str, Any]] = None,
                 namespace: Optional[str] = None,
                 resource_group: Optional[str] = None):
        """
        :param Mapping[str, Any] dimensions: (Updatable) Dimensions to be added for metrics.
        :param str namespace: (Updatable) Namespace to emit metrics.
        :param str resource_group: (Updatable) Resource group to emit metrics.
        """
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Mapping[str, Any]]:
        """
        (Updatable) Dimensions to be added for metrics.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        (Updatable) Namespace to emit metrics.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        (Updatable) Resource group to emit metrics.
        """
        return pulumi.get(self, "resource_group")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationUnifiedAgentConfigurationFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowLists":
            suggest = "allow_lists"
        elif key == "denyLists":
            suggest = "deny_lists"
        elif key == "filterType":
            suggest = "filter_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationUnifiedAgentConfigurationFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationUnifiedAgentConfigurationFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationUnifiedAgentConfigurationFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_lists: Optional[Sequence[str]] = None,
                 deny_lists: Optional[Sequence[str]] = None,
                 filter_type: Optional[str] = None,
                 name: Optional[str] = None):
        """
        :param Sequence[str] allow_lists: (Updatable) A list of filtering rules to include logs
        :param Sequence[str] deny_lists: (Updatable) A list of filtering rules to reject logs
        :param str filter_type: (Updatable) Unified schema logging filter type.
        :param str name: (Updatable) The name key to tag this Grok pattern.
        """
        if allow_lists is not None:
            pulumi.set(__self__, "allow_lists", allow_lists)
        if deny_lists is not None:
            pulumi.set(__self__, "deny_lists", deny_lists)
        if filter_type is not None:
            pulumi.set(__self__, "filter_type", filter_type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="allowLists")
    def allow_lists(self) -> Optional[Sequence[str]]:
        """
        (Updatable) A list of filtering rules to include logs
        """
        return pulumi.get(self, "allow_lists")

    @property
    @pulumi.getter(name="denyLists")
    def deny_lists(self) -> Optional[Sequence[str]]:
        """
        (Updatable) A list of filtering rules to reject logs
        """
        return pulumi.get(self, "deny_lists")

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> Optional[str]:
        """
        (Updatable) Unified schema logging filter type.
        """
        return pulumi.get(self, "filter_type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        (Updatable) The name key to tag this Grok pattern.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logObjectId":
            suggest = "log_object_id"
        elif key == "operationalMetricsConfiguration":
            suggest = "operational_metrics_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfigurationDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfigurationDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfigurationDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_object_id: str,
                 operational_metrics_configuration: Optional['outputs.UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfiguration'] = None):
        """
        :param str log_object_id: (Updatable) The OCID of the resource.
        :param 'UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationArgs' operational_metrics_configuration: (Updatable) Unified monitoring agent operational metrics configuration object.
        """
        pulumi.set(__self__, "log_object_id", log_object_id)
        if operational_metrics_configuration is not None:
            pulumi.set(__self__, "operational_metrics_configuration", operational_metrics_configuration)

    @property
    @pulumi.getter(name="logObjectId")
    def log_object_id(self) -> str:
        """
        (Updatable) The OCID of the resource.
        """
        return pulumi.get(self, "log_object_id")

    @property
    @pulumi.getter(name="operationalMetricsConfiguration")
    def operational_metrics_configuration(self) -> Optional['outputs.UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfiguration']:
        """
        (Updatable) Unified monitoring agent operational metrics configuration object.
        """
        return pulumi.get(self, "operational_metrics_configuration")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfiguration(dict):
    def __init__(__self__, *,
                 destination: 'outputs.UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationDestination',
                 source: 'outputs.UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSource'):
        """
        :param 'UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationDestinationArgs' destination: (Updatable) Unified monitoring agent operational metrics destination object.
        :param 'UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceArgs' source: (Updatable) Unified monitoring agent operational metrics source object.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def destination(self) -> 'outputs.UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationDestination':
        """
        (Updatable) Unified monitoring agent operational metrics destination object.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def source(self) -> 'outputs.UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSource':
        """
        (Updatable) Unified monitoring agent operational metrics source object.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compartmentId":
            suggest = "compartment_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compartment_id: str):
        """
        :param str compartment_id: (Updatable) The OCID of the compartment that the resource belongs to.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        (Updatable) The OCID of the compartment that the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordInput":
            suggest = "record_input"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 record_input: 'outputs.UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceRecordInput',
                 type: str,
                 metrics: Optional[Sequence[str]] = None):
        """
        :param 'UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceRecordInputArgs' record_input: (Updatable) record section of openmetrics parser.
        :param str type: (Updatable) Type of the unified monitoring agent operational metrics source object.
        :param Sequence[str] metrics: (Updatable) List of unified monitoring agent operational metrics.
        """
        pulumi.set(__self__, "record_input", record_input)
        pulumi.set(__self__, "type", type)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)

    @property
    @pulumi.getter(name="recordInput")
    def record_input(self) -> 'outputs.UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceRecordInput':
        """
        (Updatable) record section of openmetrics parser.
        """
        return pulumi.get(self, "record_input")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        (Updatable) Type of the unified monitoring agent operational metrics source object.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence[str]]:
        """
        (Updatable) List of unified monitoring agent operational metrics.
        """
        return pulumi.get(self, "metrics")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceRecordInput(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceGroup":
            suggest = "resource_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceRecordInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceRecordInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceRecordInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 namespace: str,
                 resource_group: Optional[str] = None):
        """
        :param str namespace: (Updatable) Namespace to emit metrics.
        :param str resource_group: (Updatable) Resource group to emit metrics.
        """
        pulumi.set(__self__, "namespace", namespace)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        (Updatable) Namespace to emit metrics.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        (Updatable) Resource group to emit metrics.
        """
        return pulumi.get(self, "resource_group")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceType":
            suggest = "source_type"
        elif key == "advancedOptions":
            suggest = "advanced_options"
        elif key == "customPlugin":
            suggest = "custom_plugin"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfigurationSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfigurationSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfigurationSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_type: str,
                 advanced_options: Optional['outputs.UnifiedAgentConfigurationServiceConfigurationSourceAdvancedOptions'] = None,
                 channels: Optional[Sequence[str]] = None,
                 custom_plugin: Optional[str] = None,
                 name: Optional[str] = None,
                 parser: Optional['outputs.UnifiedAgentConfigurationServiceConfigurationSourceParser'] = None,
                 paths: Optional[Sequence[str]] = None):
        """
        :param str source_type: (Updatable) Unified schema logging source type.
        :param 'UnifiedAgentConfigurationServiceConfigurationSourceAdvancedOptionsArgs' advanced_options: (Updatable) Advanced options for logging configuration
        :param Sequence[str] channels: (Updatable) Windows event log channels.
        :param str custom_plugin: (Updatable) User customized source plugin.
        :param str name: (Updatable) The name key to tag this Grok pattern.
        :param 'UnifiedAgentConfigurationServiceConfigurationSourceParserArgs' parser: (Updatable) Source parser object.
        :param Sequence[str] paths: (Updatable) Absolute paths for log source files. Wildcards can be used.
        """
        pulumi.set(__self__, "source_type", source_type)
        if advanced_options is not None:
            pulumi.set(__self__, "advanced_options", advanced_options)
        if channels is not None:
            pulumi.set(__self__, "channels", channels)
        if custom_plugin is not None:
            pulumi.set(__self__, "custom_plugin", custom_plugin)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parser is not None:
            pulumi.set(__self__, "parser", parser)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        (Updatable) Unified schema logging source type.
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter(name="advancedOptions")
    def advanced_options(self) -> Optional['outputs.UnifiedAgentConfigurationServiceConfigurationSourceAdvancedOptions']:
        """
        (Updatable) Advanced options for logging configuration
        """
        return pulumi.get(self, "advanced_options")

    @property
    @pulumi.getter
    def channels(self) -> Optional[Sequence[str]]:
        """
        (Updatable) Windows event log channels.
        """
        return pulumi.get(self, "channels")

    @property
    @pulumi.getter(name="customPlugin")
    def custom_plugin(self) -> Optional[str]:
        """
        (Updatable) User customized source plugin.
        """
        return pulumi.get(self, "custom_plugin")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        (Updatable) The name key to tag this Grok pattern.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parser(self) -> Optional['outputs.UnifiedAgentConfigurationServiceConfigurationSourceParser']:
        """
        (Updatable) Source parser object.
        """
        return pulumi.get(self, "parser")

    @property
    @pulumi.getter
    def paths(self) -> Optional[Sequence[str]]:
        """
        (Updatable) Absolute paths for log source files. Wildcards can be used.
        """
        return pulumi.get(self, "paths")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationSourceAdvancedOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isReadFromHead":
            suggest = "is_read_from_head"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfigurationSourceAdvancedOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfigurationSourceAdvancedOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfigurationSourceAdvancedOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_read_from_head: Optional[bool] = None):
        """
        :param bool is_read_from_head: (Updatable) Starts to read the logs from the head of the file or the last read position recorded in pos_file, not tail.
        """
        if is_read_from_head is not None:
            pulumi.set(__self__, "is_read_from_head", is_read_from_head)

    @property
    @pulumi.getter(name="isReadFromHead")
    def is_read_from_head(self) -> Optional[bool]:
        """
        (Updatable) Starts to read the logs from the head of the file or the last read position recorded in pos_file, not tail.
        """
        return pulumi.get(self, "is_read_from_head")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationSourceParser(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parserType":
            suggest = "parser_type"
        elif key == "fieldTimeKey":
            suggest = "field_time_key"
        elif key == "formatFirstline":
            suggest = "format_firstline"
        elif key == "grokFailureKey":
            suggest = "grok_failure_key"
        elif key == "grokNameKey":
            suggest = "grok_name_key"
        elif key == "isEstimateCurrentEvent":
            suggest = "is_estimate_current_event"
        elif key == "isKeepTimeKey":
            suggest = "is_keep_time_key"
        elif key == "isMergeCriFields":
            suggest = "is_merge_cri_fields"
        elif key == "isNullEmptyString":
            suggest = "is_null_empty_string"
        elif key == "isSupportColonlessIdent":
            suggest = "is_support_colonless_ident"
        elif key == "isWithPriority":
            suggest = "is_with_priority"
        elif key == "messageFormat":
            suggest = "message_format"
        elif key == "messageKey":
            suggest = "message_key"
        elif key == "multiLineStartRegexp":
            suggest = "multi_line_start_regexp"
        elif key == "nestedParser":
            suggest = "nested_parser"
        elif key == "nullValuePattern":
            suggest = "null_value_pattern"
        elif key == "parseNested":
            suggest = "parse_nested"
        elif key == "recordInput":
            suggest = "record_input"
        elif key == "rfc5424timeFormat":
            suggest = "rfc5424time_format"
        elif key == "syslogParserType":
            suggest = "syslog_parser_type"
        elif key == "timeFormat":
            suggest = "time_format"
        elif key == "timeType":
            suggest = "time_type"
        elif key == "timeoutInMilliseconds":
            suggest = "timeout_in_milliseconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfigurationSourceParser. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfigurationSourceParser.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfigurationSourceParser.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parser_type: str,
                 delimiter: Optional[str] = None,
                 expression: Optional[str] = None,
                 field_time_key: Optional[str] = None,
                 format_firstline: Optional[str] = None,
                 formats: Optional[Sequence[str]] = None,
                 grok_failure_key: Optional[str] = None,
                 grok_name_key: Optional[str] = None,
                 is_estimate_current_event: Optional[bool] = None,
                 is_keep_time_key: Optional[bool] = None,
                 is_merge_cri_fields: Optional[bool] = None,
                 is_null_empty_string: Optional[bool] = None,
                 is_support_colonless_ident: Optional[bool] = None,
                 is_with_priority: Optional[bool] = None,
                 keys: Optional[Sequence[str]] = None,
                 message_format: Optional[str] = None,
                 message_key: Optional[str] = None,
                 multi_line_start_regexp: Optional[str] = None,
                 nested_parser: Optional['outputs.UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParser'] = None,
                 null_value_pattern: Optional[str] = None,
                 parse_nested: Optional[bool] = None,
                 patterns: Optional[Sequence['outputs.UnifiedAgentConfigurationServiceConfigurationSourceParserPattern']] = None,
                 record_input: Optional['outputs.UnifiedAgentConfigurationServiceConfigurationSourceParserRecordInput'] = None,
                 rfc5424time_format: Optional[str] = None,
                 separator: Optional[str] = None,
                 syslog_parser_type: Optional[str] = None,
                 time_format: Optional[str] = None,
                 time_type: Optional[str] = None,
                 timeout_in_milliseconds: Optional[int] = None,
                 types: Optional[Mapping[str, Any]] = None):
        """
        :param str parser_type: (Updatable) Type of fluent parser.
        :param str delimiter: (Updatable) CSV delimiter.
        :param str expression: (Updatable) Regex pattern.
        :param str field_time_key: (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param str format_firstline: (Updatable) First line pattern format.
        :param Sequence[str] formats: (Updatable) Mutiline pattern format.
        :param str grok_failure_key: (Updatable) Grok failure key.
        :param str grok_name_key: (Updatable) Grok name key.
        :param bool is_estimate_current_event: (Updatable) If true, use Fluent::EventTime.now(current time) as a timestamp when the time_key is specified.
        :param bool is_keep_time_key: (Updatable) If true, keep the time field in the record.
        :param bool is_merge_cri_fields: (Updatable) If you don't need stream or logtag fields, set this to false.
        :param bool is_null_empty_string: (Updatable) If true, an empty string field is replaced with a null value.
        :param bool is_support_colonless_ident: (Updatable) Specifies whether or not to support colonless ident. Corresponds to the Fluentd support_colonless_ident parameter.
        :param bool is_with_priority: (Updatable) Specifies with priority or not. Corresponds to the Fluentd with_priority parameter.
        :param Sequence[str] keys: (Updatable) CSV keys.
        :param str message_format: (Updatable) Syslog message format.
        :param str message_key: (Updatable) Specifies the field name to contain logs.
        :param str multi_line_start_regexp: (Updatable) Multiline start regexp pattern.
        :param 'UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParserArgs' nested_parser: (Updatable) Optional nested JSON Parser for CRI. Supported fields are fieldTimeKey, timeFormat, and isKeepTimeKey.
        :param str null_value_pattern: (Updatable) Specify the null value pattern.
        :param bool parse_nested: (Updatable) If true, a separator parameter can be further defined.
        :param Sequence['UnifiedAgentConfigurationServiceConfigurationSourceParserPatternArgs'] patterns: (Updatable) Grok pattern object.
        :param 'UnifiedAgentConfigurationServiceConfigurationSourceParserRecordInputArgs' record_input: (Updatable) record section of openmetrics parser.
        :param str rfc5424time_format: (Updatable) RFC 5424 time format.
        :param str separator: (Updatable) Keys of adjacent levels are joined by the separator.
        :param str syslog_parser_type: (Updatable) Syslog parser type.
        :param str time_format: (Updatable) Process time value using the specified format.
        :param str time_type: (Updatable) JSON parser time type.
        :param int timeout_in_milliseconds: (Updatable) Specify the timeout for parse processing. This is mainly for detecting an incorrect regexp pattern.
        :param Mapping[str, Any] types: (Updatable) Specify types for converting a field into another type. For example, With this configuration: <parse> @type csv keys time,host,req_id,user time_key time </parse>
               
               This incoming event: "2013/02/28 12:00:00,192.168.0.1,111,-"
               
               is parsed as: 1362020400 (2013/02/28/ 12:00:00)
               
               record: { "host"   : "192.168.0.1", "req_id" : "111", "user"   : "-" }
        """
        pulumi.set(__self__, "parser_type", parser_type)
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if field_time_key is not None:
            pulumi.set(__self__, "field_time_key", field_time_key)
        if format_firstline is not None:
            pulumi.set(__self__, "format_firstline", format_firstline)
        if formats is not None:
            pulumi.set(__self__, "formats", formats)
        if grok_failure_key is not None:
            pulumi.set(__self__, "grok_failure_key", grok_failure_key)
        if grok_name_key is not None:
            pulumi.set(__self__, "grok_name_key", grok_name_key)
        if is_estimate_current_event is not None:
            pulumi.set(__self__, "is_estimate_current_event", is_estimate_current_event)
        if is_keep_time_key is not None:
            pulumi.set(__self__, "is_keep_time_key", is_keep_time_key)
        if is_merge_cri_fields is not None:
            pulumi.set(__self__, "is_merge_cri_fields", is_merge_cri_fields)
        if is_null_empty_string is not None:
            pulumi.set(__self__, "is_null_empty_string", is_null_empty_string)
        if is_support_colonless_ident is not None:
            pulumi.set(__self__, "is_support_colonless_ident", is_support_colonless_ident)
        if is_with_priority is not None:
            pulumi.set(__self__, "is_with_priority", is_with_priority)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if message_format is not None:
            pulumi.set(__self__, "message_format", message_format)
        if message_key is not None:
            pulumi.set(__self__, "message_key", message_key)
        if multi_line_start_regexp is not None:
            pulumi.set(__self__, "multi_line_start_regexp", multi_line_start_regexp)
        if nested_parser is not None:
            pulumi.set(__self__, "nested_parser", nested_parser)
        if null_value_pattern is not None:
            pulumi.set(__self__, "null_value_pattern", null_value_pattern)
        if parse_nested is not None:
            pulumi.set(__self__, "parse_nested", parse_nested)
        if patterns is not None:
            pulumi.set(__self__, "patterns", patterns)
        if record_input is not None:
            pulumi.set(__self__, "record_input", record_input)
        if rfc5424time_format is not None:
            pulumi.set(__self__, "rfc5424time_format", rfc5424time_format)
        if separator is not None:
            pulumi.set(__self__, "separator", separator)
        if syslog_parser_type is not None:
            pulumi.set(__self__, "syslog_parser_type", syslog_parser_type)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)
        if time_type is not None:
            pulumi.set(__self__, "time_type", time_type)
        if timeout_in_milliseconds is not None:
            pulumi.set(__self__, "timeout_in_milliseconds", timeout_in_milliseconds)
        if types is not None:
            pulumi.set(__self__, "types", types)

    @property
    @pulumi.getter(name="parserType")
    def parser_type(self) -> str:
        """
        (Updatable) Type of fluent parser.
        """
        return pulumi.get(self, "parser_type")

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[str]:
        """
        (Updatable) CSV delimiter.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter
    def expression(self) -> Optional[str]:
        """
        (Updatable) Regex pattern.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> Optional[str]:
        """
        (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @property
    @pulumi.getter(name="formatFirstline")
    def format_firstline(self) -> Optional[str]:
        """
        (Updatable) First line pattern format.
        """
        return pulumi.get(self, "format_firstline")

    @property
    @pulumi.getter
    def formats(self) -> Optional[Sequence[str]]:
        """
        (Updatable) Mutiline pattern format.
        """
        return pulumi.get(self, "formats")

    @property
    @pulumi.getter(name="grokFailureKey")
    def grok_failure_key(self) -> Optional[str]:
        """
        (Updatable) Grok failure key.
        """
        return pulumi.get(self, "grok_failure_key")

    @property
    @pulumi.getter(name="grokNameKey")
    def grok_name_key(self) -> Optional[str]:
        """
        (Updatable) Grok name key.
        """
        return pulumi.get(self, "grok_name_key")

    @property
    @pulumi.getter(name="isEstimateCurrentEvent")
    def is_estimate_current_event(self) -> Optional[bool]:
        """
        (Updatable) If true, use Fluent::EventTime.now(current time) as a timestamp when the time_key is specified.
        """
        return pulumi.get(self, "is_estimate_current_event")

    @property
    @pulumi.getter(name="isKeepTimeKey")
    def is_keep_time_key(self) -> Optional[bool]:
        """
        (Updatable) If true, keep the time field in the record.
        """
        return pulumi.get(self, "is_keep_time_key")

    @property
    @pulumi.getter(name="isMergeCriFields")
    def is_merge_cri_fields(self) -> Optional[bool]:
        """
        (Updatable) If you don't need stream or logtag fields, set this to false.
        """
        return pulumi.get(self, "is_merge_cri_fields")

    @property
    @pulumi.getter(name="isNullEmptyString")
    def is_null_empty_string(self) -> Optional[bool]:
        """
        (Updatable) If true, an empty string field is replaced with a null value.
        """
        return pulumi.get(self, "is_null_empty_string")

    @property
    @pulumi.getter(name="isSupportColonlessIdent")
    def is_support_colonless_ident(self) -> Optional[bool]:
        """
        (Updatable) Specifies whether or not to support colonless ident. Corresponds to the Fluentd support_colonless_ident parameter.
        """
        return pulumi.get(self, "is_support_colonless_ident")

    @property
    @pulumi.getter(name="isWithPriority")
    def is_with_priority(self) -> Optional[bool]:
        """
        (Updatable) Specifies with priority or not. Corresponds to the Fluentd with_priority parameter.
        """
        return pulumi.get(self, "is_with_priority")

    @property
    @pulumi.getter
    def keys(self) -> Optional[Sequence[str]]:
        """
        (Updatable) CSV keys.
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> Optional[str]:
        """
        (Updatable) Syslog message format.
        """
        return pulumi.get(self, "message_format")

    @property
    @pulumi.getter(name="messageKey")
    def message_key(self) -> Optional[str]:
        """
        (Updatable) Specifies the field name to contain logs.
        """
        return pulumi.get(self, "message_key")

    @property
    @pulumi.getter(name="multiLineStartRegexp")
    def multi_line_start_regexp(self) -> Optional[str]:
        """
        (Updatable) Multiline start regexp pattern.
        """
        return pulumi.get(self, "multi_line_start_regexp")

    @property
    @pulumi.getter(name="nestedParser")
    def nested_parser(self) -> Optional['outputs.UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParser']:
        """
        (Updatable) Optional nested JSON Parser for CRI. Supported fields are fieldTimeKey, timeFormat, and isKeepTimeKey.
        """
        return pulumi.get(self, "nested_parser")

    @property
    @pulumi.getter(name="nullValuePattern")
    def null_value_pattern(self) -> Optional[str]:
        """
        (Updatable) Specify the null value pattern.
        """
        return pulumi.get(self, "null_value_pattern")

    @property
    @pulumi.getter(name="parseNested")
    def parse_nested(self) -> Optional[bool]:
        """
        (Updatable) If true, a separator parameter can be further defined.
        """
        return pulumi.get(self, "parse_nested")

    @property
    @pulumi.getter
    def patterns(self) -> Optional[Sequence['outputs.UnifiedAgentConfigurationServiceConfigurationSourceParserPattern']]:
        """
        (Updatable) Grok pattern object.
        """
        return pulumi.get(self, "patterns")

    @property
    @pulumi.getter(name="recordInput")
    def record_input(self) -> Optional['outputs.UnifiedAgentConfigurationServiceConfigurationSourceParserRecordInput']:
        """
        (Updatable) record section of openmetrics parser.
        """
        return pulumi.get(self, "record_input")

    @property
    @pulumi.getter(name="rfc5424timeFormat")
    def rfc5424time_format(self) -> Optional[str]:
        """
        (Updatable) RFC 5424 time format.
        """
        return pulumi.get(self, "rfc5424time_format")

    @property
    @pulumi.getter
    def separator(self) -> Optional[str]:
        """
        (Updatable) Keys of adjacent levels are joined by the separator.
        """
        return pulumi.get(self, "separator")

    @property
    @pulumi.getter(name="syslogParserType")
    def syslog_parser_type(self) -> Optional[str]:
        """
        (Updatable) Syslog parser type.
        """
        return pulumi.get(self, "syslog_parser_type")

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[str]:
        """
        (Updatable) Process time value using the specified format.
        """
        return pulumi.get(self, "time_format")

    @property
    @pulumi.getter(name="timeType")
    def time_type(self) -> Optional[str]:
        """
        (Updatable) JSON parser time type.
        """
        return pulumi.get(self, "time_type")

    @property
    @pulumi.getter(name="timeoutInMilliseconds")
    def timeout_in_milliseconds(self) -> Optional[int]:
        """
        (Updatable) Specify the timeout for parse processing. This is mainly for detecting an incorrect regexp pattern.
        """
        return pulumi.get(self, "timeout_in_milliseconds")

    @property
    @pulumi.getter
    def types(self) -> Optional[Mapping[str, Any]]:
        """
        (Updatable) Specify types for converting a field into another type. For example, With this configuration: <parse> @type csv keys time,host,req_id,user time_key time </parse>

        This incoming event: "2013/02/28 12:00:00,192.168.0.1,111,-"

        is parsed as: 1362020400 (2013/02/28/ 12:00:00)

        record: { "host"   : "192.168.0.1", "req_id" : "111", "user"   : "-" }
        """
        return pulumi.get(self, "types")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParser(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldTimeKey":
            suggest = "field_time_key"
        elif key == "isKeepTimeKey":
            suggest = "is_keep_time_key"
        elif key == "parseNested":
            suggest = "parse_nested"
        elif key == "timeFormat":
            suggest = "time_format"
        elif key == "timeType":
            suggest = "time_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParser. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParser.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParser.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_time_key: Optional[str] = None,
                 is_keep_time_key: Optional[bool] = None,
                 parse_nested: Optional[bool] = None,
                 separator: Optional[str] = None,
                 time_format: Optional[str] = None,
                 time_type: Optional[str] = None):
        """
        :param str field_time_key: (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param bool is_keep_time_key: (Updatable) If true, keep the time field in the record.
        :param bool parse_nested: (Updatable) If true, a separator parameter can be further defined.
        :param str separator: (Updatable) Keys of adjacent levels are joined by the separator.
        :param str time_format: (Updatable) Process time value using the specified format.
        :param str time_type: (Updatable) JSON parser time type.
        """
        if field_time_key is not None:
            pulumi.set(__self__, "field_time_key", field_time_key)
        if is_keep_time_key is not None:
            pulumi.set(__self__, "is_keep_time_key", is_keep_time_key)
        if parse_nested is not None:
            pulumi.set(__self__, "parse_nested", parse_nested)
        if separator is not None:
            pulumi.set(__self__, "separator", separator)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)
        if time_type is not None:
            pulumi.set(__self__, "time_type", time_type)

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> Optional[str]:
        """
        (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @property
    @pulumi.getter(name="isKeepTimeKey")
    def is_keep_time_key(self) -> Optional[bool]:
        """
        (Updatable) If true, keep the time field in the record.
        """
        return pulumi.get(self, "is_keep_time_key")

    @property
    @pulumi.getter(name="parseNested")
    def parse_nested(self) -> Optional[bool]:
        """
        (Updatable) If true, a separator parameter can be further defined.
        """
        return pulumi.get(self, "parse_nested")

    @property
    @pulumi.getter
    def separator(self) -> Optional[str]:
        """
        (Updatable) Keys of adjacent levels are joined by the separator.
        """
        return pulumi.get(self, "separator")

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[str]:
        """
        (Updatable) Process time value using the specified format.
        """
        return pulumi.get(self, "time_format")

    @property
    @pulumi.getter(name="timeType")
    def time_type(self) -> Optional[str]:
        """
        (Updatable) JSON parser time type.
        """
        return pulumi.get(self, "time_type")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationSourceParserPattern(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldTimeFormat":
            suggest = "field_time_format"
        elif key == "fieldTimeKey":
            suggest = "field_time_key"
        elif key == "fieldTimeZone":
            suggest = "field_time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfigurationSourceParserPattern. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfigurationSourceParserPattern.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfigurationSourceParserPattern.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_time_format: Optional[str] = None,
                 field_time_key: Optional[str] = None,
                 field_time_zone: Optional[str] = None,
                 name: Optional[str] = None,
                 pattern: Optional[str] = None):
        """
        :param str field_time_format: (Updatable) Process value using the specified format. This is available only when time_type is a string.
        :param str field_time_key: (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param str field_time_zone: (Updatable) Use the specified time zone. The time value can be parsed or formatted in the specified time zone.
        :param str name: (Updatable) The name key to tag this Grok pattern.
        :param str pattern: (Updatable) The Grok pattern.
        """
        if field_time_format is not None:
            pulumi.set(__self__, "field_time_format", field_time_format)
        if field_time_key is not None:
            pulumi.set(__self__, "field_time_key", field_time_key)
        if field_time_zone is not None:
            pulumi.set(__self__, "field_time_zone", field_time_zone)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)

    @property
    @pulumi.getter(name="fieldTimeFormat")
    def field_time_format(self) -> Optional[str]:
        """
        (Updatable) Process value using the specified format. This is available only when time_type is a string.
        """
        return pulumi.get(self, "field_time_format")

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> Optional[str]:
        """
        (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @property
    @pulumi.getter(name="fieldTimeZone")
    def field_time_zone(self) -> Optional[str]:
        """
        (Updatable) Use the specified time zone. The time value can be parsed or formatted in the specified time zone.
        """
        return pulumi.get(self, "field_time_zone")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        (Updatable) The name key to tag this Grok pattern.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def pattern(self) -> Optional[str]:
        """
        (Updatable) The Grok pattern.
        """
        return pulumi.get(self, "pattern")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationSourceParserRecordInput(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceGroup":
            suggest = "resource_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfigurationSourceParserRecordInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfigurationSourceParserRecordInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfigurationSourceParserRecordInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimensions: Optional[Mapping[str, Any]] = None,
                 namespace: Optional[str] = None,
                 resource_group: Optional[str] = None):
        """
        :param Mapping[str, Any] dimensions: (Updatable) Dimensions to be added for metrics.
        :param str namespace: (Updatable) Namespace to emit metrics.
        :param str resource_group: (Updatable) Resource group to emit metrics.
        """
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Mapping[str, Any]]:
        """
        (Updatable) Dimensions to be added for metrics.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        (Updatable) Namespace to emit metrics.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        (Updatable) Resource group to emit metrics.
        """
        return pulumi.get(self, "resource_group")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filterType":
            suggest = "filter_type"
        elif key == "allowLists":
            suggest = "allow_lists"
        elif key == "customFilterType":
            suggest = "custom_filter_type"
        elif key == "customSections":
            suggest = "custom_sections"
        elif key == "denyLists":
            suggest = "deny_lists"
        elif key == "emitInvalidRecordToError":
            suggest = "emit_invalid_record_to_error"
        elif key == "hashValueField":
            suggest = "hash_value_field"
        elif key == "injectKeyPrefix":
            suggest = "inject_key_prefix"
        elif key == "isAutoTypecastEnabled":
            suggest = "is_auto_typecast_enabled"
        elif key == "isRenewRecordEnabled":
            suggest = "is_renew_record_enabled"
        elif key == "isRubyEnabled":
            suggest = "is_ruby_enabled"
        elif key == "keepKeys":
            suggest = "keep_keys"
        elif key == "keyName":
            suggest = "key_name"
        elif key == "recordLists":
            suggest = "record_lists"
        elif key == "removeKeyNameField":
            suggest = "remove_key_name_field"
        elif key == "removeKeys":
            suggest = "remove_keys"
        elif key == "renewTimeKey":
            suggest = "renew_time_key"
        elif key == "replaceInvalidSequence":
            suggest = "replace_invalid_sequence"
        elif key == "reserveData":
            suggest = "reserve_data"
        elif key == "reserveTime":
            suggest = "reserve_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filter_type: str,
                 name: str,
                 allow_lists: Optional[Sequence['outputs.UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterAllowList']] = None,
                 custom_filter_type: Optional[str] = None,
                 custom_sections: Optional[Sequence['outputs.UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterCustomSection']] = None,
                 deny_lists: Optional[Sequence['outputs.UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterDenyList']] = None,
                 emit_invalid_record_to_error: Optional[bool] = None,
                 hash_value_field: Optional[str] = None,
                 inject_key_prefix: Optional[str] = None,
                 is_auto_typecast_enabled: Optional[bool] = None,
                 is_renew_record_enabled: Optional[bool] = None,
                 is_ruby_enabled: Optional[bool] = None,
                 keep_keys: Optional[Sequence[str]] = None,
                 key_name: Optional[str] = None,
                 params: Optional[Mapping[str, Any]] = None,
                 parser: Optional['outputs.UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParser'] = None,
                 record_lists: Optional[Sequence['outputs.UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterRecordList']] = None,
                 remove_key_name_field: Optional[bool] = None,
                 remove_keys: Optional[Sequence[str]] = None,
                 renew_time_key: Optional[str] = None,
                 replace_invalid_sequence: Optional[bool] = None,
                 reserve_data: Optional[bool] = None,
                 reserve_time: Optional[bool] = None):
        """
        :param str filter_type: (Updatable) Unified schema logging filter type.
        :param str name: (Updatable) The name key to tag this Grok pattern.
        :param Sequence['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterAllowListArgs'] allow_lists: (Updatable) A list of filtering rules to include logs
        :param str custom_filter_type: (Updatable) Type of the custom filter
        :param Sequence['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterCustomSectionArgs'] custom_sections: (Updatable) List of custom sections in custom filter
        :param Sequence['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterDenyListArgs'] deny_lists: (Updatable) A list of filtering rules to reject logs
        :param bool emit_invalid_record_to_error: (Updatable) If true, emit invalid record to @ERROR label. Invalid cases are: 1) key does not exist; 2) the format does not match; or 3) an unexpected error. You can rescue unexpected format logs in the @ERROR lable. If you want to ignore these errors, set this to false.
        :param str hash_value_field: (Updatable) Store the parsed values as a hash value in a field.
        :param str inject_key_prefix: (Updatable) Store the parsed values with the specified key name prefix.
        :param bool is_auto_typecast_enabled: (Updatable) If true, automatically casts the field types.
        :param bool is_renew_record_enabled: (Updatable) If true, it modifies a new empty hash
        :param bool is_ruby_enabled: (Updatable) When set to true, the full Ruby syntax is enabled in the ${} expression.
        :param Sequence[str] keep_keys: (Updatable) A list of keys to keep. Only relevant if isRenewRecordEnabled is set to true
        :param str key_name: (Updatable) The field name in the record to parse.
        :param Mapping[str, Any] params: (Updatable) Parameters of the custom filter
        :param 'UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserArgs' parser: (Updatable) Source parser object.
        :param Sequence['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterRecordListArgs'] record_lists: (Updatable) Add new key-value pairs in logs
        :param bool remove_key_name_field: (Updatable) If true, remove the keyName field when parsing is succeeded.
        :param Sequence[str] remove_keys: (Updatable) A list of keys to delete
        :param str renew_time_key: (Updatable) Overwrites the time of logs with this value, this value must be a Unix timestamp.
        :param bool replace_invalid_sequence: (Updatable) If true, the invalid string is replaced with safe characters and is re-parsed.
        :param bool reserve_data: (Updatable) If true, keep the original key-value pair in the parsed result.
        :param bool reserve_time: (Updatable) If true, keep the original event time in the parsed result.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "filter_type", filter_type)
        pulumi.set(__self__, "name", name)
        if allow_lists is not None:
            pulumi.set(__self__, "allow_lists", allow_lists)
        if custom_filter_type is not None:
            pulumi.set(__self__, "custom_filter_type", custom_filter_type)
        if custom_sections is not None:
            pulumi.set(__self__, "custom_sections", custom_sections)
        if deny_lists is not None:
            pulumi.set(__self__, "deny_lists", deny_lists)
        if emit_invalid_record_to_error is not None:
            pulumi.set(__self__, "emit_invalid_record_to_error", emit_invalid_record_to_error)
        if hash_value_field is not None:
            pulumi.set(__self__, "hash_value_field", hash_value_field)
        if inject_key_prefix is not None:
            pulumi.set(__self__, "inject_key_prefix", inject_key_prefix)
        if is_auto_typecast_enabled is not None:
            pulumi.set(__self__, "is_auto_typecast_enabled", is_auto_typecast_enabled)
        if is_renew_record_enabled is not None:
            pulumi.set(__self__, "is_renew_record_enabled", is_renew_record_enabled)
        if is_ruby_enabled is not None:
            pulumi.set(__self__, "is_ruby_enabled", is_ruby_enabled)
        if keep_keys is not None:
            pulumi.set(__self__, "keep_keys", keep_keys)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if params is not None:
            pulumi.set(__self__, "params", params)
        if parser is not None:
            pulumi.set(__self__, "parser", parser)
        if record_lists is not None:
            pulumi.set(__self__, "record_lists", record_lists)
        if remove_key_name_field is not None:
            pulumi.set(__self__, "remove_key_name_field", remove_key_name_field)
        if remove_keys is not None:
            pulumi.set(__self__, "remove_keys", remove_keys)
        if renew_time_key is not None:
            pulumi.set(__self__, "renew_time_key", renew_time_key)
        if replace_invalid_sequence is not None:
            pulumi.set(__self__, "replace_invalid_sequence", replace_invalid_sequence)
        if reserve_data is not None:
            pulumi.set(__self__, "reserve_data", reserve_data)
        if reserve_time is not None:
            pulumi.set(__self__, "reserve_time", reserve_time)

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> str:
        """
        (Updatable) Unified schema logging filter type.
        """
        return pulumi.get(self, "filter_type")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        (Updatable) The name key to tag this Grok pattern.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="allowLists")
    def allow_lists(self) -> Optional[Sequence['outputs.UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterAllowList']]:
        """
        (Updatable) A list of filtering rules to include logs
        """
        return pulumi.get(self, "allow_lists")

    @property
    @pulumi.getter(name="customFilterType")
    def custom_filter_type(self) -> Optional[str]:
        """
        (Updatable) Type of the custom filter
        """
        return pulumi.get(self, "custom_filter_type")

    @property
    @pulumi.getter(name="customSections")
    def custom_sections(self) -> Optional[Sequence['outputs.UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterCustomSection']]:
        """
        (Updatable) List of custom sections in custom filter
        """
        return pulumi.get(self, "custom_sections")

    @property
    @pulumi.getter(name="denyLists")
    def deny_lists(self) -> Optional[Sequence['outputs.UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterDenyList']]:
        """
        (Updatable) A list of filtering rules to reject logs
        """
        return pulumi.get(self, "deny_lists")

    @property
    @pulumi.getter(name="emitInvalidRecordToError")
    def emit_invalid_record_to_error(self) -> Optional[bool]:
        """
        (Updatable) If true, emit invalid record to @ERROR label. Invalid cases are: 1) key does not exist; 2) the format does not match; or 3) an unexpected error. You can rescue unexpected format logs in the @ERROR lable. If you want to ignore these errors, set this to false.
        """
        return pulumi.get(self, "emit_invalid_record_to_error")

    @property
    @pulumi.getter(name="hashValueField")
    def hash_value_field(self) -> Optional[str]:
        """
        (Updatable) Store the parsed values as a hash value in a field.
        """
        return pulumi.get(self, "hash_value_field")

    @property
    @pulumi.getter(name="injectKeyPrefix")
    def inject_key_prefix(self) -> Optional[str]:
        """
        (Updatable) Store the parsed values with the specified key name prefix.
        """
        return pulumi.get(self, "inject_key_prefix")

    @property
    @pulumi.getter(name="isAutoTypecastEnabled")
    def is_auto_typecast_enabled(self) -> Optional[bool]:
        """
        (Updatable) If true, automatically casts the field types.
        """
        return pulumi.get(self, "is_auto_typecast_enabled")

    @property
    @pulumi.getter(name="isRenewRecordEnabled")
    def is_renew_record_enabled(self) -> Optional[bool]:
        """
        (Updatable) If true, it modifies a new empty hash
        """
        return pulumi.get(self, "is_renew_record_enabled")

    @property
    @pulumi.getter(name="isRubyEnabled")
    def is_ruby_enabled(self) -> Optional[bool]:
        """
        (Updatable) When set to true, the full Ruby syntax is enabled in the ${} expression.
        """
        return pulumi.get(self, "is_ruby_enabled")

    @property
    @pulumi.getter(name="keepKeys")
    def keep_keys(self) -> Optional[Sequence[str]]:
        """
        (Updatable) A list of keys to keep. Only relevant if isRenewRecordEnabled is set to true
        """
        return pulumi.get(self, "keep_keys")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[str]:
        """
        (Updatable) The field name in the record to parse.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter
    def params(self) -> Optional[Mapping[str, Any]]:
        """
        (Updatable) Parameters of the custom filter
        """
        return pulumi.get(self, "params")

    @property
    @pulumi.getter
    def parser(self) -> Optional['outputs.UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParser']:
        """
        (Updatable) Source parser object.
        """
        return pulumi.get(self, "parser")

    @property
    @pulumi.getter(name="recordLists")
    def record_lists(self) -> Optional[Sequence['outputs.UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterRecordList']]:
        """
        (Updatable) Add new key-value pairs in logs
        """
        return pulumi.get(self, "record_lists")

    @property
    @pulumi.getter(name="removeKeyNameField")
    def remove_key_name_field(self) -> Optional[bool]:
        """
        (Updatable) If true, remove the keyName field when parsing is succeeded.
        """
        return pulumi.get(self, "remove_key_name_field")

    @property
    @pulumi.getter(name="removeKeys")
    def remove_keys(self) -> Optional[Sequence[str]]:
        """
        (Updatable) A list of keys to delete
        """
        return pulumi.get(self, "remove_keys")

    @property
    @pulumi.getter(name="renewTimeKey")
    def renew_time_key(self) -> Optional[str]:
        """
        (Updatable) Overwrites the time of logs with this value, this value must be a Unix timestamp.
        """
        return pulumi.get(self, "renew_time_key")

    @property
    @pulumi.getter(name="replaceInvalidSequence")
    def replace_invalid_sequence(self) -> Optional[bool]:
        """
        (Updatable) If true, the invalid string is replaced with safe characters and is re-parsed.
        """
        return pulumi.get(self, "replace_invalid_sequence")

    @property
    @pulumi.getter(name="reserveData")
    def reserve_data(self) -> Optional[bool]:
        """
        (Updatable) If true, keep the original key-value pair in the parsed result.
        """
        return pulumi.get(self, "reserve_data")

    @property
    @pulumi.getter(name="reserveTime")
    def reserve_time(self) -> Optional[bool]:
        """
        (Updatable) If true, keep the original event time in the parsed result.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "reserve_time")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterAllowList(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 pattern: Optional[str] = None):
        """
        :param str key: (Updatable) A new key
        :param str pattern: (Updatable) The Grok pattern.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        (Updatable) A new key
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def pattern(self) -> Optional[str]:
        """
        (Updatable) The Grok pattern.
        """
        return pulumi.get(self, "pattern")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterCustomSection(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 params: Optional[Mapping[str, Any]] = None):
        """
        :param str name: (Updatable) The name key to tag this Grok pattern.
        :param Mapping[str, Any] params: (Updatable) Parameters of the custom filter
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if params is not None:
            pulumi.set(__self__, "params", params)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        (Updatable) The name key to tag this Grok pattern.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def params(self) -> Optional[Mapping[str, Any]]:
        """
        (Updatable) Parameters of the custom filter
        """
        return pulumi.get(self, "params")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterDenyList(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 pattern: Optional[str] = None):
        """
        :param str key: (Updatable) A new key
        :param str pattern: (Updatable) The Grok pattern.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        (Updatable) A new key
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def pattern(self) -> Optional[str]:
        """
        (Updatable) The Grok pattern.
        """
        return pulumi.get(self, "pattern")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParser(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parserType":
            suggest = "parser_type"
        elif key == "fieldTimeKey":
            suggest = "field_time_key"
        elif key == "formatFirstline":
            suggest = "format_firstline"
        elif key == "grokFailureKey":
            suggest = "grok_failure_key"
        elif key == "grokNameKey":
            suggest = "grok_name_key"
        elif key == "isEstimateCurrentEvent":
            suggest = "is_estimate_current_event"
        elif key == "isKeepTimeKey":
            suggest = "is_keep_time_key"
        elif key == "isMergeCriFields":
            suggest = "is_merge_cri_fields"
        elif key == "isNullEmptyString":
            suggest = "is_null_empty_string"
        elif key == "isSupportColonlessIdent":
            suggest = "is_support_colonless_ident"
        elif key == "isWithPriority":
            suggest = "is_with_priority"
        elif key == "messageFormat":
            suggest = "message_format"
        elif key == "messageKey":
            suggest = "message_key"
        elif key == "multiLineStartRegexp":
            suggest = "multi_line_start_regexp"
        elif key == "nestedParser":
            suggest = "nested_parser"
        elif key == "nullValuePattern":
            suggest = "null_value_pattern"
        elif key == "parseNested":
            suggest = "parse_nested"
        elif key == "recordInput":
            suggest = "record_input"
        elif key == "rfc5424timeFormat":
            suggest = "rfc5424time_format"
        elif key == "syslogParserType":
            suggest = "syslog_parser_type"
        elif key == "timeFormat":
            suggest = "time_format"
        elif key == "timeType":
            suggest = "time_type"
        elif key == "timeoutInMilliseconds":
            suggest = "timeout_in_milliseconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParser. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParser.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParser.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parser_type: str,
                 delimiter: Optional[str] = None,
                 expression: Optional[str] = None,
                 field_time_key: Optional[str] = None,
                 format_firstline: Optional[str] = None,
                 formats: Optional[Sequence[str]] = None,
                 grok_failure_key: Optional[str] = None,
                 grok_name_key: Optional[str] = None,
                 is_estimate_current_event: Optional[bool] = None,
                 is_keep_time_key: Optional[bool] = None,
                 is_merge_cri_fields: Optional[bool] = None,
                 is_null_empty_string: Optional[bool] = None,
                 is_support_colonless_ident: Optional[bool] = None,
                 is_with_priority: Optional[bool] = None,
                 keys: Optional[Sequence[str]] = None,
                 message_format: Optional[str] = None,
                 message_key: Optional[str] = None,
                 multi_line_start_regexp: Optional[str] = None,
                 nested_parser: Optional['outputs.UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserNestedParser'] = None,
                 null_value_pattern: Optional[str] = None,
                 parse_nested: Optional[bool] = None,
                 patterns: Optional[Sequence['outputs.UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserPattern']] = None,
                 record_input: Optional['outputs.UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserRecordInput'] = None,
                 rfc5424time_format: Optional[str] = None,
                 separator: Optional[str] = None,
                 syslog_parser_type: Optional[str] = None,
                 time_format: Optional[str] = None,
                 time_type: Optional[str] = None,
                 timeout_in_milliseconds: Optional[int] = None,
                 types: Optional[Mapping[str, Any]] = None):
        """
        :param str parser_type: (Updatable) Type of fluent parser.
        :param str delimiter: (Updatable) CSV delimiter.
        :param str expression: (Updatable) Regex pattern.
        :param str field_time_key: (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param str format_firstline: (Updatable) First line pattern format.
        :param Sequence[str] formats: (Updatable) Mutiline pattern format.
        :param str grok_failure_key: (Updatable) Grok failure key.
        :param str grok_name_key: (Updatable) Grok name key.
        :param bool is_estimate_current_event: (Updatable) If true, use Fluent::EventTime.now(current time) as a timestamp when the time_key is specified.
        :param bool is_keep_time_key: (Updatable) If true, keep the time field in the record.
        :param bool is_merge_cri_fields: (Updatable) If you don't need stream or logtag fields, set this to false.
        :param bool is_null_empty_string: (Updatable) If true, an empty string field is replaced with a null value.
        :param bool is_support_colonless_ident: (Updatable) Specifies whether or not to support colonless ident. Corresponds to the Fluentd support_colonless_ident parameter.
        :param bool is_with_priority: (Updatable) Specifies with priority or not. Corresponds to the Fluentd with_priority parameter.
        :param Sequence[str] keys: (Updatable) CSV keys.
        :param str message_format: (Updatable) Syslog message format.
        :param str message_key: (Updatable) Specifies the field name to contain logs.
        :param str multi_line_start_regexp: (Updatable) Multiline start regexp pattern.
        :param 'UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserNestedParserArgs' nested_parser: (Updatable) Optional nested JSON Parser for CRI. Supported fields are fieldTimeKey, timeFormat, and isKeepTimeKey.
        :param str null_value_pattern: (Updatable) Specify the null value pattern.
        :param bool parse_nested: (Updatable) If true, a separator parameter can be further defined.
        :param Sequence['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserPatternArgs'] patterns: (Updatable) Grok pattern object.
        :param 'UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserRecordInputArgs' record_input: (Updatable) record section of openmetrics parser.
        :param str rfc5424time_format: (Updatable) RFC 5424 time format.
        :param str separator: (Updatable) Keys of adjacent levels are joined by the separator.
        :param str syslog_parser_type: (Updatable) Syslog parser type.
        :param str time_format: (Updatable) Process time value using the specified format.
        :param str time_type: (Updatable) JSON parser time type.
        :param int timeout_in_milliseconds: (Updatable) Specify the timeout for parse processing. This is mainly for detecting an incorrect regexp pattern.
        :param Mapping[str, Any] types: (Updatable) Specify types for converting a field into another type. For example, With this configuration: <parse> @type csv keys time,host,req_id,user time_key time </parse>
               
               This incoming event: "2013/02/28 12:00:00,192.168.0.1,111,-"
               
               is parsed as: 1362020400 (2013/02/28/ 12:00:00)
               
               record: { "host"   : "192.168.0.1", "req_id" : "111", "user"   : "-" }
        """
        pulumi.set(__self__, "parser_type", parser_type)
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if field_time_key is not None:
            pulumi.set(__self__, "field_time_key", field_time_key)
        if format_firstline is not None:
            pulumi.set(__self__, "format_firstline", format_firstline)
        if formats is not None:
            pulumi.set(__self__, "formats", formats)
        if grok_failure_key is not None:
            pulumi.set(__self__, "grok_failure_key", grok_failure_key)
        if grok_name_key is not None:
            pulumi.set(__self__, "grok_name_key", grok_name_key)
        if is_estimate_current_event is not None:
            pulumi.set(__self__, "is_estimate_current_event", is_estimate_current_event)
        if is_keep_time_key is not None:
            pulumi.set(__self__, "is_keep_time_key", is_keep_time_key)
        if is_merge_cri_fields is not None:
            pulumi.set(__self__, "is_merge_cri_fields", is_merge_cri_fields)
        if is_null_empty_string is not None:
            pulumi.set(__self__, "is_null_empty_string", is_null_empty_string)
        if is_support_colonless_ident is not None:
            pulumi.set(__self__, "is_support_colonless_ident", is_support_colonless_ident)
        if is_with_priority is not None:
            pulumi.set(__self__, "is_with_priority", is_with_priority)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if message_format is not None:
            pulumi.set(__self__, "message_format", message_format)
        if message_key is not None:
            pulumi.set(__self__, "message_key", message_key)
        if multi_line_start_regexp is not None:
            pulumi.set(__self__, "multi_line_start_regexp", multi_line_start_regexp)
        if nested_parser is not None:
            pulumi.set(__self__, "nested_parser", nested_parser)
        if null_value_pattern is not None:
            pulumi.set(__self__, "null_value_pattern", null_value_pattern)
        if parse_nested is not None:
            pulumi.set(__self__, "parse_nested", parse_nested)
        if patterns is not None:
            pulumi.set(__self__, "patterns", patterns)
        if record_input is not None:
            pulumi.set(__self__, "record_input", record_input)
        if rfc5424time_format is not None:
            pulumi.set(__self__, "rfc5424time_format", rfc5424time_format)
        if separator is not None:
            pulumi.set(__self__, "separator", separator)
        if syslog_parser_type is not None:
            pulumi.set(__self__, "syslog_parser_type", syslog_parser_type)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)
        if time_type is not None:
            pulumi.set(__self__, "time_type", time_type)
        if timeout_in_milliseconds is not None:
            pulumi.set(__self__, "timeout_in_milliseconds", timeout_in_milliseconds)
        if types is not None:
            pulumi.set(__self__, "types", types)

    @property
    @pulumi.getter(name="parserType")
    def parser_type(self) -> str:
        """
        (Updatable) Type of fluent parser.
        """
        return pulumi.get(self, "parser_type")

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[str]:
        """
        (Updatable) CSV delimiter.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter
    def expression(self) -> Optional[str]:
        """
        (Updatable) Regex pattern.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> Optional[str]:
        """
        (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @property
    @pulumi.getter(name="formatFirstline")
    def format_firstline(self) -> Optional[str]:
        """
        (Updatable) First line pattern format.
        """
        return pulumi.get(self, "format_firstline")

    @property
    @pulumi.getter
    def formats(self) -> Optional[Sequence[str]]:
        """
        (Updatable) Mutiline pattern format.
        """
        return pulumi.get(self, "formats")

    @property
    @pulumi.getter(name="grokFailureKey")
    def grok_failure_key(self) -> Optional[str]:
        """
        (Updatable) Grok failure key.
        """
        return pulumi.get(self, "grok_failure_key")

    @property
    @pulumi.getter(name="grokNameKey")
    def grok_name_key(self) -> Optional[str]:
        """
        (Updatable) Grok name key.
        """
        return pulumi.get(self, "grok_name_key")

    @property
    @pulumi.getter(name="isEstimateCurrentEvent")
    def is_estimate_current_event(self) -> Optional[bool]:
        """
        (Updatable) If true, use Fluent::EventTime.now(current time) as a timestamp when the time_key is specified.
        """
        return pulumi.get(self, "is_estimate_current_event")

    @property
    @pulumi.getter(name="isKeepTimeKey")
    def is_keep_time_key(self) -> Optional[bool]:
        """
        (Updatable) If true, keep the time field in the record.
        """
        return pulumi.get(self, "is_keep_time_key")

    @property
    @pulumi.getter(name="isMergeCriFields")
    def is_merge_cri_fields(self) -> Optional[bool]:
        """
        (Updatable) If you don't need stream or logtag fields, set this to false.
        """
        return pulumi.get(self, "is_merge_cri_fields")

    @property
    @pulumi.getter(name="isNullEmptyString")
    def is_null_empty_string(self) -> Optional[bool]:
        """
        (Updatable) If true, an empty string field is replaced with a null value.
        """
        return pulumi.get(self, "is_null_empty_string")

    @property
    @pulumi.getter(name="isSupportColonlessIdent")
    def is_support_colonless_ident(self) -> Optional[bool]:
        """
        (Updatable) Specifies whether or not to support colonless ident. Corresponds to the Fluentd support_colonless_ident parameter.
        """
        return pulumi.get(self, "is_support_colonless_ident")

    @property
    @pulumi.getter(name="isWithPriority")
    def is_with_priority(self) -> Optional[bool]:
        """
        (Updatable) Specifies with priority or not. Corresponds to the Fluentd with_priority parameter.
        """
        return pulumi.get(self, "is_with_priority")

    @property
    @pulumi.getter
    def keys(self) -> Optional[Sequence[str]]:
        """
        (Updatable) CSV keys.
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> Optional[str]:
        """
        (Updatable) Syslog message format.
        """
        return pulumi.get(self, "message_format")

    @property
    @pulumi.getter(name="messageKey")
    def message_key(self) -> Optional[str]:
        """
        (Updatable) Specifies the field name to contain logs.
        """
        return pulumi.get(self, "message_key")

    @property
    @pulumi.getter(name="multiLineStartRegexp")
    def multi_line_start_regexp(self) -> Optional[str]:
        """
        (Updatable) Multiline start regexp pattern.
        """
        return pulumi.get(self, "multi_line_start_regexp")

    @property
    @pulumi.getter(name="nestedParser")
    def nested_parser(self) -> Optional['outputs.UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserNestedParser']:
        """
        (Updatable) Optional nested JSON Parser for CRI. Supported fields are fieldTimeKey, timeFormat, and isKeepTimeKey.
        """
        return pulumi.get(self, "nested_parser")

    @property
    @pulumi.getter(name="nullValuePattern")
    def null_value_pattern(self) -> Optional[str]:
        """
        (Updatable) Specify the null value pattern.
        """
        return pulumi.get(self, "null_value_pattern")

    @property
    @pulumi.getter(name="parseNested")
    def parse_nested(self) -> Optional[bool]:
        """
        (Updatable) If true, a separator parameter can be further defined.
        """
        return pulumi.get(self, "parse_nested")

    @property
    @pulumi.getter
    def patterns(self) -> Optional[Sequence['outputs.UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserPattern']]:
        """
        (Updatable) Grok pattern object.
        """
        return pulumi.get(self, "patterns")

    @property
    @pulumi.getter(name="recordInput")
    def record_input(self) -> Optional['outputs.UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserRecordInput']:
        """
        (Updatable) record section of openmetrics parser.
        """
        return pulumi.get(self, "record_input")

    @property
    @pulumi.getter(name="rfc5424timeFormat")
    def rfc5424time_format(self) -> Optional[str]:
        """
        (Updatable) RFC 5424 time format.
        """
        return pulumi.get(self, "rfc5424time_format")

    @property
    @pulumi.getter
    def separator(self) -> Optional[str]:
        """
        (Updatable) Keys of adjacent levels are joined by the separator.
        """
        return pulumi.get(self, "separator")

    @property
    @pulumi.getter(name="syslogParserType")
    def syslog_parser_type(self) -> Optional[str]:
        """
        (Updatable) Syslog parser type.
        """
        return pulumi.get(self, "syslog_parser_type")

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[str]:
        """
        (Updatable) Process time value using the specified format.
        """
        return pulumi.get(self, "time_format")

    @property
    @pulumi.getter(name="timeType")
    def time_type(self) -> Optional[str]:
        """
        (Updatable) JSON parser time type.
        """
        return pulumi.get(self, "time_type")

    @property
    @pulumi.getter(name="timeoutInMilliseconds")
    def timeout_in_milliseconds(self) -> Optional[int]:
        """
        (Updatable) Specify the timeout for parse processing. This is mainly for detecting an incorrect regexp pattern.
        """
        return pulumi.get(self, "timeout_in_milliseconds")

    @property
    @pulumi.getter
    def types(self) -> Optional[Mapping[str, Any]]:
        """
        (Updatable) Specify types for converting a field into another type. For example, With this configuration: <parse> @type csv keys time,host,req_id,user time_key time </parse>

        This incoming event: "2013/02/28 12:00:00,192.168.0.1,111,-"

        is parsed as: 1362020400 (2013/02/28/ 12:00:00)

        record: { "host"   : "192.168.0.1", "req_id" : "111", "user"   : "-" }
        """
        return pulumi.get(self, "types")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserNestedParser(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldTimeKey":
            suggest = "field_time_key"
        elif key == "isKeepTimeKey":
            suggest = "is_keep_time_key"
        elif key == "parseNested":
            suggest = "parse_nested"
        elif key == "timeFormat":
            suggest = "time_format"
        elif key == "timeType":
            suggest = "time_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserNestedParser. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserNestedParser.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserNestedParser.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_time_key: Optional[str] = None,
                 is_keep_time_key: Optional[bool] = None,
                 parse_nested: Optional[bool] = None,
                 separator: Optional[str] = None,
                 time_format: Optional[str] = None,
                 time_type: Optional[str] = None):
        """
        :param str field_time_key: (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param bool is_keep_time_key: (Updatable) If true, keep the time field in the record.
        :param bool parse_nested: (Updatable) If true, a separator parameter can be further defined.
        :param str separator: (Updatable) Keys of adjacent levels are joined by the separator.
        :param str time_format: (Updatable) Process time value using the specified format.
        :param str time_type: (Updatable) JSON parser time type.
        """
        if field_time_key is not None:
            pulumi.set(__self__, "field_time_key", field_time_key)
        if is_keep_time_key is not None:
            pulumi.set(__self__, "is_keep_time_key", is_keep_time_key)
        if parse_nested is not None:
            pulumi.set(__self__, "parse_nested", parse_nested)
        if separator is not None:
            pulumi.set(__self__, "separator", separator)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)
        if time_type is not None:
            pulumi.set(__self__, "time_type", time_type)

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> Optional[str]:
        """
        (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @property
    @pulumi.getter(name="isKeepTimeKey")
    def is_keep_time_key(self) -> Optional[bool]:
        """
        (Updatable) If true, keep the time field in the record.
        """
        return pulumi.get(self, "is_keep_time_key")

    @property
    @pulumi.getter(name="parseNested")
    def parse_nested(self) -> Optional[bool]:
        """
        (Updatable) If true, a separator parameter can be further defined.
        """
        return pulumi.get(self, "parse_nested")

    @property
    @pulumi.getter
    def separator(self) -> Optional[str]:
        """
        (Updatable) Keys of adjacent levels are joined by the separator.
        """
        return pulumi.get(self, "separator")

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[str]:
        """
        (Updatable) Process time value using the specified format.
        """
        return pulumi.get(self, "time_format")

    @property
    @pulumi.getter(name="timeType")
    def time_type(self) -> Optional[str]:
        """
        (Updatable) JSON parser time type.
        """
        return pulumi.get(self, "time_type")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserPattern(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldTimeFormat":
            suggest = "field_time_format"
        elif key == "fieldTimeKey":
            suggest = "field_time_key"
        elif key == "fieldTimeZone":
            suggest = "field_time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserPattern. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserPattern.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserPattern.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_time_format: Optional[str] = None,
                 field_time_key: Optional[str] = None,
                 field_time_zone: Optional[str] = None,
                 name: Optional[str] = None,
                 pattern: Optional[str] = None):
        """
        :param str field_time_format: (Updatable) Process value using the specified format. This is available only when time_type is a string.
        :param str field_time_key: (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param str field_time_zone: (Updatable) Use the specified time zone. The time value can be parsed or formatted in the specified time zone.
        :param str name: (Updatable) The name key to tag this Grok pattern.
        :param str pattern: (Updatable) The Grok pattern.
        """
        if field_time_format is not None:
            pulumi.set(__self__, "field_time_format", field_time_format)
        if field_time_key is not None:
            pulumi.set(__self__, "field_time_key", field_time_key)
        if field_time_zone is not None:
            pulumi.set(__self__, "field_time_zone", field_time_zone)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)

    @property
    @pulumi.getter(name="fieldTimeFormat")
    def field_time_format(self) -> Optional[str]:
        """
        (Updatable) Process value using the specified format. This is available only when time_type is a string.
        """
        return pulumi.get(self, "field_time_format")

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> Optional[str]:
        """
        (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @property
    @pulumi.getter(name="fieldTimeZone")
    def field_time_zone(self) -> Optional[str]:
        """
        (Updatable) Use the specified time zone. The time value can be parsed or formatted in the specified time zone.
        """
        return pulumi.get(self, "field_time_zone")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        (Updatable) The name key to tag this Grok pattern.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def pattern(self) -> Optional[str]:
        """
        (Updatable) The Grok pattern.
        """
        return pulumi.get(self, "pattern")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserRecordInput(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceGroup":
            suggest = "resource_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserRecordInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserRecordInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserRecordInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimensions: Optional[Mapping[str, Any]] = None,
                 namespace: Optional[str] = None,
                 resource_group: Optional[str] = None):
        """
        :param Mapping[str, Any] dimensions: (Updatable) Dimensions to be added for metrics.
        :param str namespace: (Updatable) Namespace to emit metrics.
        :param str resource_group: (Updatable) Resource group to emit metrics.
        """
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Mapping[str, Any]]:
        """
        (Updatable) Dimensions to be added for metrics.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        (Updatable) Namespace to emit metrics.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        (Updatable) Resource group to emit metrics.
        """
        return pulumi.get(self, "resource_group")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterRecordList(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str key: (Updatable) A new key
        :param str value: (Updatable) A new value
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        (Updatable) A new key
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        (Updatable) A new value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetLogConfigurationResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 sources: Sequence['outputs.GetLogConfigurationSourceResult']):
        """
        :param str compartment_id: The OCID of the compartment that the resource belongs to.
        :param Sequence['GetLogConfigurationSourceArgs'] sources: The source the log object comes from.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "sources", sources)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetLogConfigurationSourceResult']:
        """
        The source the log object comes from.
        """
        return pulumi.get(self, "sources")


@pulumi.output_type
class GetLogConfigurationSourceResult(dict):
    def __init__(__self__, *,
                 category: str,
                 parameters: Mapping[str, Any],
                 resource: str,
                 service: str,
                 source_type: str):
        """
        :param str category: Log object category.
        :param Mapping[str, Any] parameters: Log category parameters are stored here.
        :param str resource: The unique identifier of the resource emitting the log.
        :param str service: Service generating log.
        :param str source_type: The log source.
               * **OCISERVICE:** Oracle Service.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        Log object category.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def parameters(self) -> Mapping[str, Any]:
        """
        Log category parameters are stored here.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def resource(self) -> str:
        """
        The unique identifier of the resource emitting the log.
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Service generating log.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        The log source.
        * **OCISERVICE:** Oracle Service.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetLogGroupsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetLogGroupsLogGroupResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 state: str,
                 time_created: str,
                 time_last_modified: str):
        """
        :param str compartment_id: Compartment OCID to list resources in. See compartmentIdInSubtree for nested compartments traversal.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param str description: Description for this resource.
        :param str display_name: Resource name.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: The OCID of the resource.
        :param str state: The log group object state.
        :param str time_created: Time the resource was created.
        :param str time_last_modified: Time the resource was last modified.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_last_modified", time_last_modified)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment OCID to list resources in. See compartmentIdInSubtree for nested compartments traversal.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description for this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The log group object state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Time the resource was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastModified")
    def time_last_modified(self) -> str:
        """
        Time the resource was last modified.
        """
        return pulumi.get(self, "time_last_modified")


@pulumi.output_type
class GetLogSavedSearchesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Resource name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetLogSavedSearchesLogSavedSearchSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetLogSavedSearchesLogSavedSearchSummaryCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetLogSavedSearchesLogSavedSearchSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetLogSavedSearchesLogSavedSearchSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 name: str,
                 query: str,
                 state: str,
                 time_created: str,
                 time_last_modified: str):
        """
        :param str compartment_id: Compartment OCID to list resources in. See compartmentIdInSubtree for nested compartments traversal.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param str description: Description for this resource.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: The OCID of the resource.
        :param str name: Resource name.
        :param str query: The search query that is saved.
        :param str state: The state of the LogSavedSearch
        :param str time_created: Time the resource was created.
        :param str time_last_modified: Time the resource was last modified.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_last_modified", time_last_modified)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment OCID to list resources in. See compartmentIdInSubtree for nested compartments traversal.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description for this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        The search query that is saved.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the LogSavedSearch
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Time the resource was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastModified")
    def time_last_modified(self) -> str:
        """
        Time the resource was last modified.
        """
        return pulumi.get(self, "time_last_modified")


@pulumi.output_type
class GetLogsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetLogsLogResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 configurations: Sequence['outputs.GetLogsLogConfigurationResult'],
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_enabled: bool,
                 log_group_id: str,
                 log_type: str,
                 retention_duration: int,
                 state: str,
                 tenancy_id: str,
                 time_created: str,
                 time_last_modified: str):
        """
        :param str compartment_id: The OCID of the compartment that the resource belongs to.
        :param Sequence['GetLogsLogConfigurationArgs'] configurations: Log object configuration.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param str display_name: Resource name.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: The OCID of the resource.
        :param bool is_enabled: Whether or not this resource is currently enabled.
        :param str log_group_id: OCID of a log group to work with.
        :param str log_type: The logType that the log object is for, whether custom or service.
        :param int retention_duration: Log retention duration in 30-day increments (30, 60, 90 and so on until 180).
        :param str state: Lifecycle state of the log object
        :param str tenancy_id: The OCID of the tenancy.
        :param str time_created: Time the resource was created.
        :param str time_last_modified: Time the resource was last modified.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "configurations", configurations)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "log_group_id", log_group_id)
        pulumi.set(__self__, "log_type", log_type)
        pulumi.set(__self__, "retention_duration", retention_duration)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "tenancy_id", tenancy_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_last_modified", time_last_modified)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def configurations(self) -> Sequence['outputs.GetLogsLogConfigurationResult']:
        """
        Log object configuration.
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether or not this resource is currently enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> str:
        """
        OCID of a log group to work with.
        """
        return pulumi.get(self, "log_group_id")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The logType that the log object is for, whether custom or service.
        """
        return pulumi.get(self, "log_type")

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> int:
        """
        Log retention duration in 30-day increments (30, 60, 90 and so on until 180).
        """
        return pulumi.get(self, "retention_duration")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Lifecycle state of the log object
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> str:
        """
        The OCID of the tenancy.
        """
        return pulumi.get(self, "tenancy_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Time the resource was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastModified")
    def time_last_modified(self) -> str:
        """
        Time the resource was last modified.
        """
        return pulumi.get(self, "time_last_modified")


@pulumi.output_type
class GetLogsLogConfigurationResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 sources: Sequence['outputs.GetLogsLogConfigurationSourceResult']):
        """
        :param str compartment_id: The OCID of the compartment that the resource belongs to.
        :param Sequence['GetLogsLogConfigurationSourceArgs'] sources: The source the log object comes from.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "sources", sources)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetLogsLogConfigurationSourceResult']:
        """
        The source the log object comes from.
        """
        return pulumi.get(self, "sources")


@pulumi.output_type
class GetLogsLogConfigurationSourceResult(dict):
    def __init__(__self__, *,
                 category: str,
                 parameters: Mapping[str, Any],
                 resource: str,
                 service: str,
                 source_type: str):
        """
        :param str category: Log object category.
        :param Mapping[str, Any] parameters: Log category parameters are stored here.
        :param str resource: The unique identifier of the resource emitting the log.
        :param str service: Service generating log.
        :param str source_type: The log source.
               * **OCISERVICE:** Oracle Service.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        Log object category.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def parameters(self) -> Mapping[str, Any]:
        """
        Log category parameters are stored here.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def resource(self) -> str:
        """
        The unique identifier of the resource emitting the log.
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Service generating log.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        The log source.
        * **OCISERVICE:** Oracle Service.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetUnifiedAgentConfigurationGroupAssociationResult(dict):
    def __init__(__self__, *,
                 group_lists: Sequence[str]):
        """
        :param Sequence[str] group_lists: list of group/dynamic group ids associated with this configuration.
        """
        pulumi.set(__self__, "group_lists", group_lists)

    @property
    @pulumi.getter(name="groupLists")
    def group_lists(self) -> Sequence[str]:
        """
        list of group/dynamic group ids associated with this configuration.
        """
        return pulumi.get(self, "group_lists")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationResult(dict):
    def __init__(__self__, *,
                 application_configurations: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationResult'],
                 configuration_type: str,
                 destinations: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationDestinationResult'],
                 sources: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationSourceResult'],
                 unified_agent_configuration_filters: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterResult']):
        """
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationArgs'] application_configurations: Unified Agent monitoring application configuration details.
        :param str configuration_type: Type of Unified Agent service configuration.
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationDestinationArgs'] destinations: Unified monitoring agent operational metrics destination object.
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationSourceArgs'] sources: Logging source object.
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterArgs'] unified_agent_configuration_filters: Logging filter object.
        """
        pulumi.set(__self__, "application_configurations", application_configurations)
        pulumi.set(__self__, "configuration_type", configuration_type)
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "unified_agent_configuration_filters", unified_agent_configuration_filters)

    @property
    @pulumi.getter(name="applicationConfigurations")
    def application_configurations(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationResult']:
        """
        Unified Agent monitoring application configuration details.
        """
        return pulumi.get(self, "application_configurations")

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> str:
        """
        Type of Unified Agent service configuration.
        """
        return pulumi.get(self, "configuration_type")

    @property
    @pulumi.getter
    def destinations(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationDestinationResult']:
        """
        Unified monitoring agent operational metrics destination object.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationSourceResult']:
        """
        Logging source object.
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter(name="unifiedAgentConfigurationFilters")
    def unified_agent_configuration_filters(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterResult']:
        """
        Logging filter object.
        """
        return pulumi.get(self, "unified_agent_configuration_filters")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationResult(dict):
    def __init__(__self__, *,
                 destinations: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationDestinationResult'],
                 source: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceResult'],
                 source_type: str,
                 sources: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceResult'],
                 unified_agent_configuration_filters: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationUnifiedAgentConfigurationFilterResult']):
        """
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationDestinationArgs'] destinations: Unified monitoring agent operational metrics destination object.
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceArgs'] source: Unified monitoring agent operational metrics source object.
        :param str source_type: Unified schema logging source type.
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceArgs'] sources: Logging source object.
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationUnifiedAgentConfigurationFilterArgs'] unified_agent_configuration_filters: Logging filter object.
        """
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "source_type", source_type)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "unified_agent_configuration_filters", unified_agent_configuration_filters)

    @property
    @pulumi.getter
    def destinations(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationDestinationResult']:
        """
        Unified monitoring agent operational metrics destination object.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def source(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceResult']:
        """
        Unified monitoring agent operational metrics source object.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        Unified schema logging source type.
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceResult']:
        """
        Logging source object.
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter(name="unifiedAgentConfigurationFilters")
    def unified_agent_configuration_filters(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationUnifiedAgentConfigurationFilterResult']:
        """
        Logging filter object.
        """
        return pulumi.get(self, "unified_agent_configuration_filters")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationDestinationResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 metrics_namespace: str):
        """
        :param str compartment_id: The OCID of the compartment that the resource belongs to.
        :param str metrics_namespace: Namespace to which metrics will be emitted.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "metrics_namespace", metrics_namespace)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="metricsNamespace")
    def metrics_namespace(self) -> str:
        """
        Namespace to which metrics will be emitted.
        """
        return pulumi.get(self, "metrics_namespace")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceResult(dict):
    def __init__(__self__, *,
                 advanced_options: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceAdvancedOptionResult'],
                 name: str,
                 parsers: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserResult'],
                 paths: Sequence[str],
                 source_type: str):
        """
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceAdvancedOptionArgs'] advanced_options: Advanced options for logging configuration
        :param str name: The name key to tag this Grok pattern.
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserArgs'] parsers: Source parser object.
        :param Sequence[str] paths: Absolute paths for log source files. Wildcards can be used.
        :param str source_type: Unified schema logging source type.
        """
        pulumi.set(__self__, "advanced_options", advanced_options)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parsers", parsers)
        pulumi.set(__self__, "paths", paths)
        pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="advancedOptions")
    def advanced_options(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceAdvancedOptionResult']:
        """
        Advanced options for logging configuration
        """
        return pulumi.get(self, "advanced_options")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name key to tag this Grok pattern.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parsers(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserResult']:
        """
        Source parser object.
        """
        return pulumi.get(self, "parsers")

    @property
    @pulumi.getter
    def paths(self) -> Sequence[str]:
        """
        Absolute paths for log source files. Wildcards can be used.
        """
        return pulumi.get(self, "paths")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        Unified schema logging source type.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceAdvancedOptionResult(dict):
    def __init__(__self__, *,
                 is_read_from_head: bool):
        """
        :param bool is_read_from_head: Starts to read the logs from the head of the file or the last read position recorded in pos_file, not tail.
        """
        pulumi.set(__self__, "is_read_from_head", is_read_from_head)

    @property
    @pulumi.getter(name="isReadFromHead")
    def is_read_from_head(self) -> bool:
        """
        Starts to read the logs from the head of the file or the last read position recorded in pos_file, not tail.
        """
        return pulumi.get(self, "is_read_from_head")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserResult(dict):
    def __init__(__self__, *,
                 delimiter: str,
                 expression: str,
                 field_time_key: str,
                 format_firstline: str,
                 formats: Sequence[str],
                 grok_failure_key: str,
                 grok_name_key: str,
                 is_estimate_current_event: bool,
                 is_keep_time_key: bool,
                 is_merge_cri_fields: bool,
                 is_null_empty_string: bool,
                 is_support_colonless_ident: bool,
                 is_with_priority: bool,
                 keys: Sequence[str],
                 message_format: str,
                 message_key: str,
                 multi_line_start_regexp: str,
                 nested_parsers: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserNestedParserResult'],
                 null_value_pattern: str,
                 parse_nested: bool,
                 parser_type: str,
                 patterns: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserPatternResult'],
                 record_inputs: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserRecordInputResult'],
                 rfc5424time_format: str,
                 separator: str,
                 syslog_parser_type: str,
                 time_format: str,
                 time_type: str,
                 timeout_in_milliseconds: int,
                 types: Mapping[str, Any]):
        """
        :param str delimiter: CSV delimiter.
        :param str expression: Regex pattern.
        :param str field_time_key: Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param str format_firstline: First line pattern format.
        :param Sequence[str] formats: Mutiline pattern format.
        :param str grok_failure_key: Grok failure key.
        :param str grok_name_key: Grok name key.
        :param bool is_estimate_current_event: If true, use Fluent::EventTime.now(current time) as a timestamp when the time_key is specified.
        :param bool is_keep_time_key: If true, keep the time field in the record.
        :param bool is_merge_cri_fields: If you don't need stream or logtag fields, set this to false.
        :param bool is_null_empty_string: If true, an empty string field is replaced with a null value.
        :param bool is_support_colonless_ident: Specifies whether or not to support colonless ident. Corresponds to the Fluentd support_colonless_ident parameter.
        :param bool is_with_priority: Specifies with priority or not. Corresponds to the Fluentd with_priority parameter.
        :param Sequence[str] keys: CSV keys.
        :param str message_format: Syslog message format.
        :param str message_key: Specifies the field name to contain logs.
        :param str multi_line_start_regexp: Multiline start regexp pattern.
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserNestedParserArgs'] nested_parsers: Optional nested JSON Parser for CRI. Supported fields are fieldTimeKey, timeFormat, and isKeepTimeKey.
        :param str null_value_pattern: Specify the null value pattern.
        :param bool parse_nested: If true, a separator parameter can be further defined.
        :param str parser_type: Type of fluent parser.
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserPatternArgs'] patterns: Grok pattern object.
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserRecordInputArgs'] record_inputs: record section of openmetrics parser.
        :param str rfc5424time_format: RFC 5424 time format.
        :param str separator: Keys of adjacent levels are joined by the separator.
        :param str syslog_parser_type: Syslog parser type.
        :param str time_format: Process time value using the specified format.
        :param str time_type: JSON parser time type.
        :param int timeout_in_milliseconds: Specify the timeout for parse processing. This is mainly for detecting an incorrect regexp pattern.
        :param Mapping[str, Any] types: Specify types for converting a field into another type. For example, With this configuration: <parse> @type csv keys time,host,req_id,user time_key time </parse>
        """
        pulumi.set(__self__, "delimiter", delimiter)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "field_time_key", field_time_key)
        pulumi.set(__self__, "format_firstline", format_firstline)
        pulumi.set(__self__, "formats", formats)
        pulumi.set(__self__, "grok_failure_key", grok_failure_key)
        pulumi.set(__self__, "grok_name_key", grok_name_key)
        pulumi.set(__self__, "is_estimate_current_event", is_estimate_current_event)
        pulumi.set(__self__, "is_keep_time_key", is_keep_time_key)
        pulumi.set(__self__, "is_merge_cri_fields", is_merge_cri_fields)
        pulumi.set(__self__, "is_null_empty_string", is_null_empty_string)
        pulumi.set(__self__, "is_support_colonless_ident", is_support_colonless_ident)
        pulumi.set(__self__, "is_with_priority", is_with_priority)
        pulumi.set(__self__, "keys", keys)
        pulumi.set(__self__, "message_format", message_format)
        pulumi.set(__self__, "message_key", message_key)
        pulumi.set(__self__, "multi_line_start_regexp", multi_line_start_regexp)
        pulumi.set(__self__, "nested_parsers", nested_parsers)
        pulumi.set(__self__, "null_value_pattern", null_value_pattern)
        pulumi.set(__self__, "parse_nested", parse_nested)
        pulumi.set(__self__, "parser_type", parser_type)
        pulumi.set(__self__, "patterns", patterns)
        pulumi.set(__self__, "record_inputs", record_inputs)
        pulumi.set(__self__, "rfc5424time_format", rfc5424time_format)
        pulumi.set(__self__, "separator", separator)
        pulumi.set(__self__, "syslog_parser_type", syslog_parser_type)
        pulumi.set(__self__, "time_format", time_format)
        pulumi.set(__self__, "time_type", time_type)
        pulumi.set(__self__, "timeout_in_milliseconds", timeout_in_milliseconds)
        pulumi.set(__self__, "types", types)

    @property
    @pulumi.getter
    def delimiter(self) -> str:
        """
        CSV delimiter.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Regex pattern.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> str:
        """
        Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @property
    @pulumi.getter(name="formatFirstline")
    def format_firstline(self) -> str:
        """
        First line pattern format.
        """
        return pulumi.get(self, "format_firstline")

    @property
    @pulumi.getter
    def formats(self) -> Sequence[str]:
        """
        Mutiline pattern format.
        """
        return pulumi.get(self, "formats")

    @property
    @pulumi.getter(name="grokFailureKey")
    def grok_failure_key(self) -> str:
        """
        Grok failure key.
        """
        return pulumi.get(self, "grok_failure_key")

    @property
    @pulumi.getter(name="grokNameKey")
    def grok_name_key(self) -> str:
        """
        Grok name key.
        """
        return pulumi.get(self, "grok_name_key")

    @property
    @pulumi.getter(name="isEstimateCurrentEvent")
    def is_estimate_current_event(self) -> bool:
        """
        If true, use Fluent::EventTime.now(current time) as a timestamp when the time_key is specified.
        """
        return pulumi.get(self, "is_estimate_current_event")

    @property
    @pulumi.getter(name="isKeepTimeKey")
    def is_keep_time_key(self) -> bool:
        """
        If true, keep the time field in the record.
        """
        return pulumi.get(self, "is_keep_time_key")

    @property
    @pulumi.getter(name="isMergeCriFields")
    def is_merge_cri_fields(self) -> bool:
        """
        If you don't need stream or logtag fields, set this to false.
        """
        return pulumi.get(self, "is_merge_cri_fields")

    @property
    @pulumi.getter(name="isNullEmptyString")
    def is_null_empty_string(self) -> bool:
        """
        If true, an empty string field is replaced with a null value.
        """
        return pulumi.get(self, "is_null_empty_string")

    @property
    @pulumi.getter(name="isSupportColonlessIdent")
    def is_support_colonless_ident(self) -> bool:
        """
        Specifies whether or not to support colonless ident. Corresponds to the Fluentd support_colonless_ident parameter.
        """
        return pulumi.get(self, "is_support_colonless_ident")

    @property
    @pulumi.getter(name="isWithPriority")
    def is_with_priority(self) -> bool:
        """
        Specifies with priority or not. Corresponds to the Fluentd with_priority parameter.
        """
        return pulumi.get(self, "is_with_priority")

    @property
    @pulumi.getter
    def keys(self) -> Sequence[str]:
        """
        CSV keys.
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> str:
        """
        Syslog message format.
        """
        return pulumi.get(self, "message_format")

    @property
    @pulumi.getter(name="messageKey")
    def message_key(self) -> str:
        """
        Specifies the field name to contain logs.
        """
        return pulumi.get(self, "message_key")

    @property
    @pulumi.getter(name="multiLineStartRegexp")
    def multi_line_start_regexp(self) -> str:
        """
        Multiline start regexp pattern.
        """
        return pulumi.get(self, "multi_line_start_regexp")

    @property
    @pulumi.getter(name="nestedParsers")
    def nested_parsers(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserNestedParserResult']:
        """
        Optional nested JSON Parser for CRI. Supported fields are fieldTimeKey, timeFormat, and isKeepTimeKey.
        """
        return pulumi.get(self, "nested_parsers")

    @property
    @pulumi.getter(name="nullValuePattern")
    def null_value_pattern(self) -> str:
        """
        Specify the null value pattern.
        """
        return pulumi.get(self, "null_value_pattern")

    @property
    @pulumi.getter(name="parseNested")
    def parse_nested(self) -> bool:
        """
        If true, a separator parameter can be further defined.
        """
        return pulumi.get(self, "parse_nested")

    @property
    @pulumi.getter(name="parserType")
    def parser_type(self) -> str:
        """
        Type of fluent parser.
        """
        return pulumi.get(self, "parser_type")

    @property
    @pulumi.getter
    def patterns(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserPatternResult']:
        """
        Grok pattern object.
        """
        return pulumi.get(self, "patterns")

    @property
    @pulumi.getter(name="recordInputs")
    def record_inputs(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserRecordInputResult']:
        """
        record section of openmetrics parser.
        """
        return pulumi.get(self, "record_inputs")

    @property
    @pulumi.getter(name="rfc5424timeFormat")
    def rfc5424time_format(self) -> str:
        """
        RFC 5424 time format.
        """
        return pulumi.get(self, "rfc5424time_format")

    @property
    @pulumi.getter
    def separator(self) -> str:
        """
        Keys of adjacent levels are joined by the separator.
        """
        return pulumi.get(self, "separator")

    @property
    @pulumi.getter(name="syslogParserType")
    def syslog_parser_type(self) -> str:
        """
        Syslog parser type.
        """
        return pulumi.get(self, "syslog_parser_type")

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> str:
        """
        Process time value using the specified format.
        """
        return pulumi.get(self, "time_format")

    @property
    @pulumi.getter(name="timeType")
    def time_type(self) -> str:
        """
        JSON parser time type.
        """
        return pulumi.get(self, "time_type")

    @property
    @pulumi.getter(name="timeoutInMilliseconds")
    def timeout_in_milliseconds(self) -> int:
        """
        Specify the timeout for parse processing. This is mainly for detecting an incorrect regexp pattern.
        """
        return pulumi.get(self, "timeout_in_milliseconds")

    @property
    @pulumi.getter
    def types(self) -> Mapping[str, Any]:
        """
        Specify types for converting a field into another type. For example, With this configuration: <parse> @type csv keys time,host,req_id,user time_key time </parse>
        """
        return pulumi.get(self, "types")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserNestedParserResult(dict):
    def __init__(__self__, *,
                 field_time_key: str,
                 is_keep_time_key: bool,
                 parse_nested: bool,
                 separator: str,
                 time_format: str,
                 time_type: str):
        """
        :param str field_time_key: Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param bool is_keep_time_key: If true, keep the time field in the record.
        :param bool parse_nested: If true, a separator parameter can be further defined.
        :param str separator: Keys of adjacent levels are joined by the separator.
        :param str time_format: Process time value using the specified format.
        :param str time_type: JSON parser time type.
        """
        pulumi.set(__self__, "field_time_key", field_time_key)
        pulumi.set(__self__, "is_keep_time_key", is_keep_time_key)
        pulumi.set(__self__, "parse_nested", parse_nested)
        pulumi.set(__self__, "separator", separator)
        pulumi.set(__self__, "time_format", time_format)
        pulumi.set(__self__, "time_type", time_type)

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> str:
        """
        Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @property
    @pulumi.getter(name="isKeepTimeKey")
    def is_keep_time_key(self) -> bool:
        """
        If true, keep the time field in the record.
        """
        return pulumi.get(self, "is_keep_time_key")

    @property
    @pulumi.getter(name="parseNested")
    def parse_nested(self) -> bool:
        """
        If true, a separator parameter can be further defined.
        """
        return pulumi.get(self, "parse_nested")

    @property
    @pulumi.getter
    def separator(self) -> str:
        """
        Keys of adjacent levels are joined by the separator.
        """
        return pulumi.get(self, "separator")

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> str:
        """
        Process time value using the specified format.
        """
        return pulumi.get(self, "time_format")

    @property
    @pulumi.getter(name="timeType")
    def time_type(self) -> str:
        """
        JSON parser time type.
        """
        return pulumi.get(self, "time_type")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserPatternResult(dict):
    def __init__(__self__, *,
                 field_time_format: str,
                 field_time_key: str,
                 field_time_zone: str,
                 name: str,
                 pattern: str):
        """
        :param str field_time_format: Process value using the specified format. This is available only when time_type is a string.
        :param str field_time_key: Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param str field_time_zone: Use the specified time zone. The time value can be parsed or formatted in the specified time zone.
        :param str name: The name key to tag this Grok pattern.
        :param str pattern: The Grok pattern.
        """
        pulumi.set(__self__, "field_time_format", field_time_format)
        pulumi.set(__self__, "field_time_key", field_time_key)
        pulumi.set(__self__, "field_time_zone", field_time_zone)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "pattern", pattern)

    @property
    @pulumi.getter(name="fieldTimeFormat")
    def field_time_format(self) -> str:
        """
        Process value using the specified format. This is available only when time_type is a string.
        """
        return pulumi.get(self, "field_time_format")

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> str:
        """
        Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @property
    @pulumi.getter(name="fieldTimeZone")
    def field_time_zone(self) -> str:
        """
        Use the specified time zone. The time value can be parsed or formatted in the specified time zone.
        """
        return pulumi.get(self, "field_time_zone")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name key to tag this Grok pattern.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def pattern(self) -> str:
        """
        The Grok pattern.
        """
        return pulumi.get(self, "pattern")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserRecordInputResult(dict):
    def __init__(__self__, *,
                 dimensions: Mapping[str, Any],
                 namespace: str,
                 resource_group: str):
        """
        :param Mapping[str, Any] dimensions: Dimensions to be added for metrics.
        :param str namespace: Namespace to emit metrics.
        :param str resource_group: Resource group to emit metrics.
        """
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "resource_group", resource_group)

    @property
    @pulumi.getter
    def dimensions(self) -> Mapping[str, Any]:
        """
        Dimensions to be added for metrics.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Namespace to emit metrics.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> str:
        """
        Resource group to emit metrics.
        """
        return pulumi.get(self, "resource_group")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationApplicationConfigurationUnifiedAgentConfigurationFilterResult(dict):
    def __init__(__self__, *,
                 allow_lists: Sequence[str],
                 deny_lists: Sequence[str],
                 filter_type: str,
                 name: str):
        """
        :param Sequence[str] allow_lists: A list of filtering rules to include logs
        :param Sequence[str] deny_lists: A list of filtering rules to reject logs
        :param str filter_type: Unified schema logging filter type.
        :param str name: The name key to tag this Grok pattern.
        """
        pulumi.set(__self__, "allow_lists", allow_lists)
        pulumi.set(__self__, "deny_lists", deny_lists)
        pulumi.set(__self__, "filter_type", filter_type)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="allowLists")
    def allow_lists(self) -> Sequence[str]:
        """
        A list of filtering rules to include logs
        """
        return pulumi.get(self, "allow_lists")

    @property
    @pulumi.getter(name="denyLists")
    def deny_lists(self) -> Sequence[str]:
        """
        A list of filtering rules to reject logs
        """
        return pulumi.get(self, "deny_lists")

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> str:
        """
        Unified schema logging filter type.
        """
        return pulumi.get(self, "filter_type")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name key to tag this Grok pattern.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationDestinationResult(dict):
    def __init__(__self__, *,
                 log_object_id: str,
                 operational_metrics_configurations: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationResult']):
        """
        :param str log_object_id: The OCID of the resource.
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationArgs'] operational_metrics_configurations: Unified monitoring agent operational metrics configuration object.
        """
        pulumi.set(__self__, "log_object_id", log_object_id)
        pulumi.set(__self__, "operational_metrics_configurations", operational_metrics_configurations)

    @property
    @pulumi.getter(name="logObjectId")
    def log_object_id(self) -> str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "log_object_id")

    @property
    @pulumi.getter(name="operationalMetricsConfigurations")
    def operational_metrics_configurations(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationResult']:
        """
        Unified monitoring agent operational metrics configuration object.
        """
        return pulumi.get(self, "operational_metrics_configurations")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationResult(dict):
    def __init__(__self__, *,
                 destinations: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationDestinationResult'],
                 sources: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceResult']):
        """
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationDestinationArgs'] destinations: Unified monitoring agent operational metrics destination object.
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceArgs'] sources: Unified monitoring agent operational metrics source object.
        """
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "sources", sources)

    @property
    @pulumi.getter
    def destinations(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationDestinationResult']:
        """
        Unified monitoring agent operational metrics destination object.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceResult']:
        """
        Unified monitoring agent operational metrics source object.
        """
        return pulumi.get(self, "sources")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationDestinationResult(dict):
    def __init__(__self__, *,
                 compartment_id: str):
        """
        :param str compartment_id: The OCID of the compartment that the resource belongs to.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceResult(dict):
    def __init__(__self__, *,
                 metrics: Sequence[str],
                 record_inputs: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceRecordInputResult'],
                 type: str):
        """
        :param Sequence[str] metrics: List of unified monitoring agent operational metrics.
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceRecordInputArgs'] record_inputs: record section of openmetrics parser.
        :param str type: Type of the unified monitoring agent operational metrics source object.
        """
        pulumi.set(__self__, "metrics", metrics)
        pulumi.set(__self__, "record_inputs", record_inputs)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def metrics(self) -> Sequence[str]:
        """
        List of unified monitoring agent operational metrics.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="recordInputs")
    def record_inputs(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceRecordInputResult']:
        """
        record section of openmetrics parser.
        """
        return pulumi.get(self, "record_inputs")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the unified monitoring agent operational metrics source object.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceRecordInputResult(dict):
    def __init__(__self__, *,
                 namespace: str,
                 resource_group: str):
        """
        :param str namespace: Namespace to emit metrics.
        :param str resource_group: Resource group to emit metrics.
        """
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "resource_group", resource_group)

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Namespace to emit metrics.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> str:
        """
        Resource group to emit metrics.
        """
        return pulumi.get(self, "resource_group")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationSourceResult(dict):
    def __init__(__self__, *,
                 advanced_options: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationSourceAdvancedOptionResult'],
                 channels: Sequence[str],
                 custom_plugin: str,
                 name: str,
                 parsers: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationSourceParserResult'],
                 paths: Sequence[str],
                 source_type: str):
        """
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationSourceAdvancedOptionArgs'] advanced_options: Advanced options for logging configuration
        :param Sequence[str] channels: Windows event log channels.
        :param str custom_plugin: User customized source plugin.
        :param str name: The name key to tag this Grok pattern.
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationSourceParserArgs'] parsers: Source parser object.
        :param Sequence[str] paths: Absolute paths for log source files. Wildcards can be used.
        :param str source_type: Unified schema logging source type.
        """
        pulumi.set(__self__, "advanced_options", advanced_options)
        pulumi.set(__self__, "channels", channels)
        pulumi.set(__self__, "custom_plugin", custom_plugin)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parsers", parsers)
        pulumi.set(__self__, "paths", paths)
        pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="advancedOptions")
    def advanced_options(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationSourceAdvancedOptionResult']:
        """
        Advanced options for logging configuration
        """
        return pulumi.get(self, "advanced_options")

    @property
    @pulumi.getter
    def channels(self) -> Sequence[str]:
        """
        Windows event log channels.
        """
        return pulumi.get(self, "channels")

    @property
    @pulumi.getter(name="customPlugin")
    def custom_plugin(self) -> str:
        """
        User customized source plugin.
        """
        return pulumi.get(self, "custom_plugin")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name key to tag this Grok pattern.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parsers(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationSourceParserResult']:
        """
        Source parser object.
        """
        return pulumi.get(self, "parsers")

    @property
    @pulumi.getter
    def paths(self) -> Sequence[str]:
        """
        Absolute paths for log source files. Wildcards can be used.
        """
        return pulumi.get(self, "paths")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        Unified schema logging source type.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationSourceAdvancedOptionResult(dict):
    def __init__(__self__, *,
                 is_read_from_head: bool):
        """
        :param bool is_read_from_head: Starts to read the logs from the head of the file or the last read position recorded in pos_file, not tail.
        """
        pulumi.set(__self__, "is_read_from_head", is_read_from_head)

    @property
    @pulumi.getter(name="isReadFromHead")
    def is_read_from_head(self) -> bool:
        """
        Starts to read the logs from the head of the file or the last read position recorded in pos_file, not tail.
        """
        return pulumi.get(self, "is_read_from_head")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationSourceParserResult(dict):
    def __init__(__self__, *,
                 delimiter: str,
                 expression: str,
                 field_time_key: str,
                 format_firstline: str,
                 formats: Sequence[str],
                 grok_failure_key: str,
                 grok_name_key: str,
                 is_estimate_current_event: bool,
                 is_keep_time_key: bool,
                 is_merge_cri_fields: bool,
                 is_null_empty_string: bool,
                 is_support_colonless_ident: bool,
                 is_with_priority: bool,
                 keys: Sequence[str],
                 message_format: str,
                 message_key: str,
                 multi_line_start_regexp: str,
                 nested_parsers: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationSourceParserNestedParserResult'],
                 null_value_pattern: str,
                 parse_nested: bool,
                 parser_type: str,
                 patterns: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationSourceParserPatternResult'],
                 record_inputs: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationSourceParserRecordInputResult'],
                 rfc5424time_format: str,
                 separator: str,
                 syslog_parser_type: str,
                 time_format: str,
                 time_type: str,
                 timeout_in_milliseconds: int,
                 types: Mapping[str, Any]):
        """
        :param str delimiter: CSV delimiter.
        :param str expression: Regex pattern.
        :param str field_time_key: Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param str format_firstline: First line pattern format.
        :param Sequence[str] formats: Mutiline pattern format.
        :param str grok_failure_key: Grok failure key.
        :param str grok_name_key: Grok name key.
        :param bool is_estimate_current_event: If true, use Fluent::EventTime.now(current time) as a timestamp when the time_key is specified.
        :param bool is_keep_time_key: If true, keep the time field in the record.
        :param bool is_merge_cri_fields: If you don't need stream or logtag fields, set this to false.
        :param bool is_null_empty_string: If true, an empty string field is replaced with a null value.
        :param bool is_support_colonless_ident: Specifies whether or not to support colonless ident. Corresponds to the Fluentd support_colonless_ident parameter.
        :param bool is_with_priority: Specifies with priority or not. Corresponds to the Fluentd with_priority parameter.
        :param Sequence[str] keys: CSV keys.
        :param str message_format: Syslog message format.
        :param str message_key: Specifies the field name to contain logs.
        :param str multi_line_start_regexp: Multiline start regexp pattern.
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationSourceParserNestedParserArgs'] nested_parsers: Optional nested JSON Parser for CRI. Supported fields are fieldTimeKey, timeFormat, and isKeepTimeKey.
        :param str null_value_pattern: Specify the null value pattern.
        :param bool parse_nested: If true, a separator parameter can be further defined.
        :param str parser_type: Type of fluent parser.
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationSourceParserPatternArgs'] patterns: Grok pattern object.
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationSourceParserRecordInputArgs'] record_inputs: record section of openmetrics parser.
        :param str rfc5424time_format: RFC 5424 time format.
        :param str separator: Keys of adjacent levels are joined by the separator.
        :param str syslog_parser_type: Syslog parser type.
        :param str time_format: Process time value using the specified format.
        :param str time_type: JSON parser time type.
        :param int timeout_in_milliseconds: Specify the timeout for parse processing. This is mainly for detecting an incorrect regexp pattern.
        :param Mapping[str, Any] types: Specify types for converting a field into another type. For example, With this configuration: <parse> @type csv keys time,host,req_id,user time_key time </parse>
        """
        pulumi.set(__self__, "delimiter", delimiter)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "field_time_key", field_time_key)
        pulumi.set(__self__, "format_firstline", format_firstline)
        pulumi.set(__self__, "formats", formats)
        pulumi.set(__self__, "grok_failure_key", grok_failure_key)
        pulumi.set(__self__, "grok_name_key", grok_name_key)
        pulumi.set(__self__, "is_estimate_current_event", is_estimate_current_event)
        pulumi.set(__self__, "is_keep_time_key", is_keep_time_key)
        pulumi.set(__self__, "is_merge_cri_fields", is_merge_cri_fields)
        pulumi.set(__self__, "is_null_empty_string", is_null_empty_string)
        pulumi.set(__self__, "is_support_colonless_ident", is_support_colonless_ident)
        pulumi.set(__self__, "is_with_priority", is_with_priority)
        pulumi.set(__self__, "keys", keys)
        pulumi.set(__self__, "message_format", message_format)
        pulumi.set(__self__, "message_key", message_key)
        pulumi.set(__self__, "multi_line_start_regexp", multi_line_start_regexp)
        pulumi.set(__self__, "nested_parsers", nested_parsers)
        pulumi.set(__self__, "null_value_pattern", null_value_pattern)
        pulumi.set(__self__, "parse_nested", parse_nested)
        pulumi.set(__self__, "parser_type", parser_type)
        pulumi.set(__self__, "patterns", patterns)
        pulumi.set(__self__, "record_inputs", record_inputs)
        pulumi.set(__self__, "rfc5424time_format", rfc5424time_format)
        pulumi.set(__self__, "separator", separator)
        pulumi.set(__self__, "syslog_parser_type", syslog_parser_type)
        pulumi.set(__self__, "time_format", time_format)
        pulumi.set(__self__, "time_type", time_type)
        pulumi.set(__self__, "timeout_in_milliseconds", timeout_in_milliseconds)
        pulumi.set(__self__, "types", types)

    @property
    @pulumi.getter
    def delimiter(self) -> str:
        """
        CSV delimiter.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Regex pattern.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> str:
        """
        Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @property
    @pulumi.getter(name="formatFirstline")
    def format_firstline(self) -> str:
        """
        First line pattern format.
        """
        return pulumi.get(self, "format_firstline")

    @property
    @pulumi.getter
    def formats(self) -> Sequence[str]:
        """
        Mutiline pattern format.
        """
        return pulumi.get(self, "formats")

    @property
    @pulumi.getter(name="grokFailureKey")
    def grok_failure_key(self) -> str:
        """
        Grok failure key.
        """
        return pulumi.get(self, "grok_failure_key")

    @property
    @pulumi.getter(name="grokNameKey")
    def grok_name_key(self) -> str:
        """
        Grok name key.
        """
        return pulumi.get(self, "grok_name_key")

    @property
    @pulumi.getter(name="isEstimateCurrentEvent")
    def is_estimate_current_event(self) -> bool:
        """
        If true, use Fluent::EventTime.now(current time) as a timestamp when the time_key is specified.
        """
        return pulumi.get(self, "is_estimate_current_event")

    @property
    @pulumi.getter(name="isKeepTimeKey")
    def is_keep_time_key(self) -> bool:
        """
        If true, keep the time field in the record.
        """
        return pulumi.get(self, "is_keep_time_key")

    @property
    @pulumi.getter(name="isMergeCriFields")
    def is_merge_cri_fields(self) -> bool:
        """
        If you don't need stream or logtag fields, set this to false.
        """
        return pulumi.get(self, "is_merge_cri_fields")

    @property
    @pulumi.getter(name="isNullEmptyString")
    def is_null_empty_string(self) -> bool:
        """
        If true, an empty string field is replaced with a null value.
        """
        return pulumi.get(self, "is_null_empty_string")

    @property
    @pulumi.getter(name="isSupportColonlessIdent")
    def is_support_colonless_ident(self) -> bool:
        """
        Specifies whether or not to support colonless ident. Corresponds to the Fluentd support_colonless_ident parameter.
        """
        return pulumi.get(self, "is_support_colonless_ident")

    @property
    @pulumi.getter(name="isWithPriority")
    def is_with_priority(self) -> bool:
        """
        Specifies with priority or not. Corresponds to the Fluentd with_priority parameter.
        """
        return pulumi.get(self, "is_with_priority")

    @property
    @pulumi.getter
    def keys(self) -> Sequence[str]:
        """
        CSV keys.
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> str:
        """
        Syslog message format.
        """
        return pulumi.get(self, "message_format")

    @property
    @pulumi.getter(name="messageKey")
    def message_key(self) -> str:
        """
        Specifies the field name to contain logs.
        """
        return pulumi.get(self, "message_key")

    @property
    @pulumi.getter(name="multiLineStartRegexp")
    def multi_line_start_regexp(self) -> str:
        """
        Multiline start regexp pattern.
        """
        return pulumi.get(self, "multi_line_start_regexp")

    @property
    @pulumi.getter(name="nestedParsers")
    def nested_parsers(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationSourceParserNestedParserResult']:
        """
        Optional nested JSON Parser for CRI. Supported fields are fieldTimeKey, timeFormat, and isKeepTimeKey.
        """
        return pulumi.get(self, "nested_parsers")

    @property
    @pulumi.getter(name="nullValuePattern")
    def null_value_pattern(self) -> str:
        """
        Specify the null value pattern.
        """
        return pulumi.get(self, "null_value_pattern")

    @property
    @pulumi.getter(name="parseNested")
    def parse_nested(self) -> bool:
        """
        If true, a separator parameter can be further defined.
        """
        return pulumi.get(self, "parse_nested")

    @property
    @pulumi.getter(name="parserType")
    def parser_type(self) -> str:
        """
        Type of fluent parser.
        """
        return pulumi.get(self, "parser_type")

    @property
    @pulumi.getter
    def patterns(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationSourceParserPatternResult']:
        """
        Grok pattern object.
        """
        return pulumi.get(self, "patterns")

    @property
    @pulumi.getter(name="recordInputs")
    def record_inputs(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationSourceParserRecordInputResult']:
        """
        record section of openmetrics parser.
        """
        return pulumi.get(self, "record_inputs")

    @property
    @pulumi.getter(name="rfc5424timeFormat")
    def rfc5424time_format(self) -> str:
        """
        RFC 5424 time format.
        """
        return pulumi.get(self, "rfc5424time_format")

    @property
    @pulumi.getter
    def separator(self) -> str:
        """
        Keys of adjacent levels are joined by the separator.
        """
        return pulumi.get(self, "separator")

    @property
    @pulumi.getter(name="syslogParserType")
    def syslog_parser_type(self) -> str:
        """
        Syslog parser type.
        """
        return pulumi.get(self, "syslog_parser_type")

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> str:
        """
        Process time value using the specified format.
        """
        return pulumi.get(self, "time_format")

    @property
    @pulumi.getter(name="timeType")
    def time_type(self) -> str:
        """
        JSON parser time type.
        """
        return pulumi.get(self, "time_type")

    @property
    @pulumi.getter(name="timeoutInMilliseconds")
    def timeout_in_milliseconds(self) -> int:
        """
        Specify the timeout for parse processing. This is mainly for detecting an incorrect regexp pattern.
        """
        return pulumi.get(self, "timeout_in_milliseconds")

    @property
    @pulumi.getter
    def types(self) -> Mapping[str, Any]:
        """
        Specify types for converting a field into another type. For example, With this configuration: <parse> @type csv keys time,host,req_id,user time_key time </parse>
        """
        return pulumi.get(self, "types")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationSourceParserNestedParserResult(dict):
    def __init__(__self__, *,
                 field_time_key: str,
                 is_keep_time_key: bool,
                 parse_nested: bool,
                 separator: str,
                 time_format: str,
                 time_type: str):
        """
        :param str field_time_key: Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param bool is_keep_time_key: If true, keep the time field in the record.
        :param bool parse_nested: If true, a separator parameter can be further defined.
        :param str separator: Keys of adjacent levels are joined by the separator.
        :param str time_format: Process time value using the specified format.
        :param str time_type: JSON parser time type.
        """
        pulumi.set(__self__, "field_time_key", field_time_key)
        pulumi.set(__self__, "is_keep_time_key", is_keep_time_key)
        pulumi.set(__self__, "parse_nested", parse_nested)
        pulumi.set(__self__, "separator", separator)
        pulumi.set(__self__, "time_format", time_format)
        pulumi.set(__self__, "time_type", time_type)

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> str:
        """
        Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @property
    @pulumi.getter(name="isKeepTimeKey")
    def is_keep_time_key(self) -> bool:
        """
        If true, keep the time field in the record.
        """
        return pulumi.get(self, "is_keep_time_key")

    @property
    @pulumi.getter(name="parseNested")
    def parse_nested(self) -> bool:
        """
        If true, a separator parameter can be further defined.
        """
        return pulumi.get(self, "parse_nested")

    @property
    @pulumi.getter
    def separator(self) -> str:
        """
        Keys of adjacent levels are joined by the separator.
        """
        return pulumi.get(self, "separator")

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> str:
        """
        Process time value using the specified format.
        """
        return pulumi.get(self, "time_format")

    @property
    @pulumi.getter(name="timeType")
    def time_type(self) -> str:
        """
        JSON parser time type.
        """
        return pulumi.get(self, "time_type")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationSourceParserPatternResult(dict):
    def __init__(__self__, *,
                 field_time_format: str,
                 field_time_key: str,
                 field_time_zone: str,
                 name: str,
                 pattern: str):
        """
        :param str field_time_format: Process value using the specified format. This is available only when time_type is a string.
        :param str field_time_key: Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param str field_time_zone: Use the specified time zone. The time value can be parsed or formatted in the specified time zone.
        :param str name: The name key to tag this Grok pattern.
        :param str pattern: The Grok pattern.
        """
        pulumi.set(__self__, "field_time_format", field_time_format)
        pulumi.set(__self__, "field_time_key", field_time_key)
        pulumi.set(__self__, "field_time_zone", field_time_zone)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "pattern", pattern)

    @property
    @pulumi.getter(name="fieldTimeFormat")
    def field_time_format(self) -> str:
        """
        Process value using the specified format. This is available only when time_type is a string.
        """
        return pulumi.get(self, "field_time_format")

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> str:
        """
        Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @property
    @pulumi.getter(name="fieldTimeZone")
    def field_time_zone(self) -> str:
        """
        Use the specified time zone. The time value can be parsed or formatted in the specified time zone.
        """
        return pulumi.get(self, "field_time_zone")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name key to tag this Grok pattern.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def pattern(self) -> str:
        """
        The Grok pattern.
        """
        return pulumi.get(self, "pattern")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationSourceParserRecordInputResult(dict):
    def __init__(__self__, *,
                 dimensions: Mapping[str, Any],
                 namespace: str,
                 resource_group: str):
        """
        :param Mapping[str, Any] dimensions: Dimensions to be added for metrics.
        :param str namespace: Namespace to emit metrics.
        :param str resource_group: Resource group to emit metrics.
        """
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "resource_group", resource_group)

    @property
    @pulumi.getter
    def dimensions(self) -> Mapping[str, Any]:
        """
        Dimensions to be added for metrics.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Namespace to emit metrics.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> str:
        """
        Resource group to emit metrics.
        """
        return pulumi.get(self, "resource_group")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterResult(dict):
    def __init__(__self__, *,
                 allow_lists: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterAllowListResult'],
                 custom_filter_type: str,
                 custom_sections: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterCustomSectionResult'],
                 deny_lists: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterDenyListResult'],
                 emit_invalid_record_to_error: bool,
                 filter_type: str,
                 hash_value_field: str,
                 inject_key_prefix: str,
                 is_auto_typecast_enabled: bool,
                 is_renew_record_enabled: bool,
                 is_ruby_enabled: bool,
                 keep_keys: Sequence[str],
                 key_name: str,
                 name: str,
                 params: Mapping[str, Any],
                 parsers: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserResult'],
                 record_lists: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterRecordListResult'],
                 remove_key_name_field: bool,
                 remove_keys: Sequence[str],
                 renew_time_key: str,
                 replace_invalid_sequence: bool,
                 reserve_data: bool,
                 reserve_time: bool):
        """
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterAllowListArgs'] allow_lists: A list of filtering rules to include logs
        :param str custom_filter_type: Type of the custom filter
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterCustomSectionArgs'] custom_sections: List of custom sections in custom filter
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterDenyListArgs'] deny_lists: A list of filtering rules to reject logs
        :param bool emit_invalid_record_to_error: If true, emit invalid record to @ERROR label. Invalid cases are: 1) key does not exist; 2) the format does not match; or 3) an unexpected error. You can rescue unexpected format logs in the @ERROR lable. If you want to ignore these errors, set this to false.
        :param str filter_type: Unified schema logging filter type.
        :param str hash_value_field: Store the parsed values as a hash value in a field.
        :param str inject_key_prefix: Store the parsed values with the specified key name prefix.
        :param bool is_auto_typecast_enabled: If true, automatically casts the field types.
        :param bool is_renew_record_enabled: If true, it modifies a new empty hash
        :param bool is_ruby_enabled: When set to true, the full Ruby syntax is enabled in the ${} expression.
        :param Sequence[str] keep_keys: A list of keys to keep. Only relevant if isRenewRecordEnabled is set to true
        :param str key_name: The field name in the record to parse.
        :param str name: The name key to tag this Grok pattern.
        :param Mapping[str, Any] params: Parameters of the custom filter
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserArgs'] parsers: Source parser object.
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterRecordListArgs'] record_lists: Add new key-value pairs in logs
        :param bool remove_key_name_field: If true, remove the keyName field when parsing is succeeded.
        :param Sequence[str] remove_keys: A list of keys to delete
        :param str renew_time_key: Overwrites the time of logs with this value, this value must be a Unix timestamp.
        :param bool replace_invalid_sequence: If true, the invalid string is replaced with safe characters and is re-parsed.
        :param bool reserve_data: If true, keep the original key-value pair in the parsed result.
        :param bool reserve_time: If true, keep the original event time in the parsed result.
        """
        pulumi.set(__self__, "allow_lists", allow_lists)
        pulumi.set(__self__, "custom_filter_type", custom_filter_type)
        pulumi.set(__self__, "custom_sections", custom_sections)
        pulumi.set(__self__, "deny_lists", deny_lists)
        pulumi.set(__self__, "emit_invalid_record_to_error", emit_invalid_record_to_error)
        pulumi.set(__self__, "filter_type", filter_type)
        pulumi.set(__self__, "hash_value_field", hash_value_field)
        pulumi.set(__self__, "inject_key_prefix", inject_key_prefix)
        pulumi.set(__self__, "is_auto_typecast_enabled", is_auto_typecast_enabled)
        pulumi.set(__self__, "is_renew_record_enabled", is_renew_record_enabled)
        pulumi.set(__self__, "is_ruby_enabled", is_ruby_enabled)
        pulumi.set(__self__, "keep_keys", keep_keys)
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "params", params)
        pulumi.set(__self__, "parsers", parsers)
        pulumi.set(__self__, "record_lists", record_lists)
        pulumi.set(__self__, "remove_key_name_field", remove_key_name_field)
        pulumi.set(__self__, "remove_keys", remove_keys)
        pulumi.set(__self__, "renew_time_key", renew_time_key)
        pulumi.set(__self__, "replace_invalid_sequence", replace_invalid_sequence)
        pulumi.set(__self__, "reserve_data", reserve_data)
        pulumi.set(__self__, "reserve_time", reserve_time)

    @property
    @pulumi.getter(name="allowLists")
    def allow_lists(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterAllowListResult']:
        """
        A list of filtering rules to include logs
        """
        return pulumi.get(self, "allow_lists")

    @property
    @pulumi.getter(name="customFilterType")
    def custom_filter_type(self) -> str:
        """
        Type of the custom filter
        """
        return pulumi.get(self, "custom_filter_type")

    @property
    @pulumi.getter(name="customSections")
    def custom_sections(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterCustomSectionResult']:
        """
        List of custom sections in custom filter
        """
        return pulumi.get(self, "custom_sections")

    @property
    @pulumi.getter(name="denyLists")
    def deny_lists(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterDenyListResult']:
        """
        A list of filtering rules to reject logs
        """
        return pulumi.get(self, "deny_lists")

    @property
    @pulumi.getter(name="emitInvalidRecordToError")
    def emit_invalid_record_to_error(self) -> bool:
        """
        If true, emit invalid record to @ERROR label. Invalid cases are: 1) key does not exist; 2) the format does not match; or 3) an unexpected error. You can rescue unexpected format logs in the @ERROR lable. If you want to ignore these errors, set this to false.
        """
        return pulumi.get(self, "emit_invalid_record_to_error")

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> str:
        """
        Unified schema logging filter type.
        """
        return pulumi.get(self, "filter_type")

    @property
    @pulumi.getter(name="hashValueField")
    def hash_value_field(self) -> str:
        """
        Store the parsed values as a hash value in a field.
        """
        return pulumi.get(self, "hash_value_field")

    @property
    @pulumi.getter(name="injectKeyPrefix")
    def inject_key_prefix(self) -> str:
        """
        Store the parsed values with the specified key name prefix.
        """
        return pulumi.get(self, "inject_key_prefix")

    @property
    @pulumi.getter(name="isAutoTypecastEnabled")
    def is_auto_typecast_enabled(self) -> bool:
        """
        If true, automatically casts the field types.
        """
        return pulumi.get(self, "is_auto_typecast_enabled")

    @property
    @pulumi.getter(name="isRenewRecordEnabled")
    def is_renew_record_enabled(self) -> bool:
        """
        If true, it modifies a new empty hash
        """
        return pulumi.get(self, "is_renew_record_enabled")

    @property
    @pulumi.getter(name="isRubyEnabled")
    def is_ruby_enabled(self) -> bool:
        """
        When set to true, the full Ruby syntax is enabled in the ${} expression.
        """
        return pulumi.get(self, "is_ruby_enabled")

    @property
    @pulumi.getter(name="keepKeys")
    def keep_keys(self) -> Sequence[str]:
        """
        A list of keys to keep. Only relevant if isRenewRecordEnabled is set to true
        """
        return pulumi.get(self, "keep_keys")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        """
        The field name in the record to parse.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name key to tag this Grok pattern.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def params(self) -> Mapping[str, Any]:
        """
        Parameters of the custom filter
        """
        return pulumi.get(self, "params")

    @property
    @pulumi.getter
    def parsers(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserResult']:
        """
        Source parser object.
        """
        return pulumi.get(self, "parsers")

    @property
    @pulumi.getter(name="recordLists")
    def record_lists(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterRecordListResult']:
        """
        Add new key-value pairs in logs
        """
        return pulumi.get(self, "record_lists")

    @property
    @pulumi.getter(name="removeKeyNameField")
    def remove_key_name_field(self) -> bool:
        """
        If true, remove the keyName field when parsing is succeeded.
        """
        return pulumi.get(self, "remove_key_name_field")

    @property
    @pulumi.getter(name="removeKeys")
    def remove_keys(self) -> Sequence[str]:
        """
        A list of keys to delete
        """
        return pulumi.get(self, "remove_keys")

    @property
    @pulumi.getter(name="renewTimeKey")
    def renew_time_key(self) -> str:
        """
        Overwrites the time of logs with this value, this value must be a Unix timestamp.
        """
        return pulumi.get(self, "renew_time_key")

    @property
    @pulumi.getter(name="replaceInvalidSequence")
    def replace_invalid_sequence(self) -> bool:
        """
        If true, the invalid string is replaced with safe characters and is re-parsed.
        """
        return pulumi.get(self, "replace_invalid_sequence")

    @property
    @pulumi.getter(name="reserveData")
    def reserve_data(self) -> bool:
        """
        If true, keep the original key-value pair in the parsed result.
        """
        return pulumi.get(self, "reserve_data")

    @property
    @pulumi.getter(name="reserveTime")
    def reserve_time(self) -> bool:
        """
        If true, keep the original event time in the parsed result.
        """
        return pulumi.get(self, "reserve_time")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterAllowListResult(dict):
    def __init__(__self__, *,
                 key: str,
                 pattern: str):
        """
        :param str key: A new key
        :param str pattern: The Grok pattern.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "pattern", pattern)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        A new key
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def pattern(self) -> str:
        """
        The Grok pattern.
        """
        return pulumi.get(self, "pattern")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterCustomSectionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 params: Mapping[str, Any]):
        """
        :param str name: The name key to tag this Grok pattern.
        :param Mapping[str, Any] params: Parameters of the custom filter
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "params", params)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name key to tag this Grok pattern.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def params(self) -> Mapping[str, Any]:
        """
        Parameters of the custom filter
        """
        return pulumi.get(self, "params")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterDenyListResult(dict):
    def __init__(__self__, *,
                 key: str,
                 pattern: str):
        """
        :param str key: A new key
        :param str pattern: The Grok pattern.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "pattern", pattern)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        A new key
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def pattern(self) -> str:
        """
        The Grok pattern.
        """
        return pulumi.get(self, "pattern")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserResult(dict):
    def __init__(__self__, *,
                 delimiter: str,
                 expression: str,
                 field_time_key: str,
                 format_firstline: str,
                 formats: Sequence[str],
                 grok_failure_key: str,
                 grok_name_key: str,
                 is_estimate_current_event: bool,
                 is_keep_time_key: bool,
                 is_merge_cri_fields: bool,
                 is_null_empty_string: bool,
                 is_support_colonless_ident: bool,
                 is_with_priority: bool,
                 keys: Sequence[str],
                 message_format: str,
                 message_key: str,
                 multi_line_start_regexp: str,
                 nested_parsers: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserNestedParserResult'],
                 null_value_pattern: str,
                 parse_nested: bool,
                 parser_type: str,
                 patterns: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserPatternResult'],
                 record_inputs: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserRecordInputResult'],
                 rfc5424time_format: str,
                 separator: str,
                 syslog_parser_type: str,
                 time_format: str,
                 time_type: str,
                 timeout_in_milliseconds: int,
                 types: Mapping[str, Any]):
        """
        :param str delimiter: CSV delimiter.
        :param str expression: Regex pattern.
        :param str field_time_key: Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param str format_firstline: First line pattern format.
        :param Sequence[str] formats: Mutiline pattern format.
        :param str grok_failure_key: Grok failure key.
        :param str grok_name_key: Grok name key.
        :param bool is_estimate_current_event: If true, use Fluent::EventTime.now(current time) as a timestamp when the time_key is specified.
        :param bool is_keep_time_key: If true, keep the time field in the record.
        :param bool is_merge_cri_fields: If you don't need stream or logtag fields, set this to false.
        :param bool is_null_empty_string: If true, an empty string field is replaced with a null value.
        :param bool is_support_colonless_ident: Specifies whether or not to support colonless ident. Corresponds to the Fluentd support_colonless_ident parameter.
        :param bool is_with_priority: Specifies with priority or not. Corresponds to the Fluentd with_priority parameter.
        :param Sequence[str] keys: CSV keys.
        :param str message_format: Syslog message format.
        :param str message_key: Specifies the field name to contain logs.
        :param str multi_line_start_regexp: Multiline start regexp pattern.
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserNestedParserArgs'] nested_parsers: Optional nested JSON Parser for CRI. Supported fields are fieldTimeKey, timeFormat, and isKeepTimeKey.
        :param str null_value_pattern: Specify the null value pattern.
        :param bool parse_nested: If true, a separator parameter can be further defined.
        :param str parser_type: Type of fluent parser.
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserPatternArgs'] patterns: Grok pattern object.
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserRecordInputArgs'] record_inputs: record section of openmetrics parser.
        :param str rfc5424time_format: RFC 5424 time format.
        :param str separator: Keys of adjacent levels are joined by the separator.
        :param str syslog_parser_type: Syslog parser type.
        :param str time_format: Process time value using the specified format.
        :param str time_type: JSON parser time type.
        :param int timeout_in_milliseconds: Specify the timeout for parse processing. This is mainly for detecting an incorrect regexp pattern.
        :param Mapping[str, Any] types: Specify types for converting a field into another type. For example, With this configuration: <parse> @type csv keys time,host,req_id,user time_key time </parse>
        """
        pulumi.set(__self__, "delimiter", delimiter)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "field_time_key", field_time_key)
        pulumi.set(__self__, "format_firstline", format_firstline)
        pulumi.set(__self__, "formats", formats)
        pulumi.set(__self__, "grok_failure_key", grok_failure_key)
        pulumi.set(__self__, "grok_name_key", grok_name_key)
        pulumi.set(__self__, "is_estimate_current_event", is_estimate_current_event)
        pulumi.set(__self__, "is_keep_time_key", is_keep_time_key)
        pulumi.set(__self__, "is_merge_cri_fields", is_merge_cri_fields)
        pulumi.set(__self__, "is_null_empty_string", is_null_empty_string)
        pulumi.set(__self__, "is_support_colonless_ident", is_support_colonless_ident)
        pulumi.set(__self__, "is_with_priority", is_with_priority)
        pulumi.set(__self__, "keys", keys)
        pulumi.set(__self__, "message_format", message_format)
        pulumi.set(__self__, "message_key", message_key)
        pulumi.set(__self__, "multi_line_start_regexp", multi_line_start_regexp)
        pulumi.set(__self__, "nested_parsers", nested_parsers)
        pulumi.set(__self__, "null_value_pattern", null_value_pattern)
        pulumi.set(__self__, "parse_nested", parse_nested)
        pulumi.set(__self__, "parser_type", parser_type)
        pulumi.set(__self__, "patterns", patterns)
        pulumi.set(__self__, "record_inputs", record_inputs)
        pulumi.set(__self__, "rfc5424time_format", rfc5424time_format)
        pulumi.set(__self__, "separator", separator)
        pulumi.set(__self__, "syslog_parser_type", syslog_parser_type)
        pulumi.set(__self__, "time_format", time_format)
        pulumi.set(__self__, "time_type", time_type)
        pulumi.set(__self__, "timeout_in_milliseconds", timeout_in_milliseconds)
        pulumi.set(__self__, "types", types)

    @property
    @pulumi.getter
    def delimiter(self) -> str:
        """
        CSV delimiter.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Regex pattern.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> str:
        """
        Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @property
    @pulumi.getter(name="formatFirstline")
    def format_firstline(self) -> str:
        """
        First line pattern format.
        """
        return pulumi.get(self, "format_firstline")

    @property
    @pulumi.getter
    def formats(self) -> Sequence[str]:
        """
        Mutiline pattern format.
        """
        return pulumi.get(self, "formats")

    @property
    @pulumi.getter(name="grokFailureKey")
    def grok_failure_key(self) -> str:
        """
        Grok failure key.
        """
        return pulumi.get(self, "grok_failure_key")

    @property
    @pulumi.getter(name="grokNameKey")
    def grok_name_key(self) -> str:
        """
        Grok name key.
        """
        return pulumi.get(self, "grok_name_key")

    @property
    @pulumi.getter(name="isEstimateCurrentEvent")
    def is_estimate_current_event(self) -> bool:
        """
        If true, use Fluent::EventTime.now(current time) as a timestamp when the time_key is specified.
        """
        return pulumi.get(self, "is_estimate_current_event")

    @property
    @pulumi.getter(name="isKeepTimeKey")
    def is_keep_time_key(self) -> bool:
        """
        If true, keep the time field in the record.
        """
        return pulumi.get(self, "is_keep_time_key")

    @property
    @pulumi.getter(name="isMergeCriFields")
    def is_merge_cri_fields(self) -> bool:
        """
        If you don't need stream or logtag fields, set this to false.
        """
        return pulumi.get(self, "is_merge_cri_fields")

    @property
    @pulumi.getter(name="isNullEmptyString")
    def is_null_empty_string(self) -> bool:
        """
        If true, an empty string field is replaced with a null value.
        """
        return pulumi.get(self, "is_null_empty_string")

    @property
    @pulumi.getter(name="isSupportColonlessIdent")
    def is_support_colonless_ident(self) -> bool:
        """
        Specifies whether or not to support colonless ident. Corresponds to the Fluentd support_colonless_ident parameter.
        """
        return pulumi.get(self, "is_support_colonless_ident")

    @property
    @pulumi.getter(name="isWithPriority")
    def is_with_priority(self) -> bool:
        """
        Specifies with priority or not. Corresponds to the Fluentd with_priority parameter.
        """
        return pulumi.get(self, "is_with_priority")

    @property
    @pulumi.getter
    def keys(self) -> Sequence[str]:
        """
        CSV keys.
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> str:
        """
        Syslog message format.
        """
        return pulumi.get(self, "message_format")

    @property
    @pulumi.getter(name="messageKey")
    def message_key(self) -> str:
        """
        Specifies the field name to contain logs.
        """
        return pulumi.get(self, "message_key")

    @property
    @pulumi.getter(name="multiLineStartRegexp")
    def multi_line_start_regexp(self) -> str:
        """
        Multiline start regexp pattern.
        """
        return pulumi.get(self, "multi_line_start_regexp")

    @property
    @pulumi.getter(name="nestedParsers")
    def nested_parsers(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserNestedParserResult']:
        """
        Optional nested JSON Parser for CRI. Supported fields are fieldTimeKey, timeFormat, and isKeepTimeKey.
        """
        return pulumi.get(self, "nested_parsers")

    @property
    @pulumi.getter(name="nullValuePattern")
    def null_value_pattern(self) -> str:
        """
        Specify the null value pattern.
        """
        return pulumi.get(self, "null_value_pattern")

    @property
    @pulumi.getter(name="parseNested")
    def parse_nested(self) -> bool:
        """
        If true, a separator parameter can be further defined.
        """
        return pulumi.get(self, "parse_nested")

    @property
    @pulumi.getter(name="parserType")
    def parser_type(self) -> str:
        """
        Type of fluent parser.
        """
        return pulumi.get(self, "parser_type")

    @property
    @pulumi.getter
    def patterns(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserPatternResult']:
        """
        Grok pattern object.
        """
        return pulumi.get(self, "patterns")

    @property
    @pulumi.getter(name="recordInputs")
    def record_inputs(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserRecordInputResult']:
        """
        record section of openmetrics parser.
        """
        return pulumi.get(self, "record_inputs")

    @property
    @pulumi.getter(name="rfc5424timeFormat")
    def rfc5424time_format(self) -> str:
        """
        RFC 5424 time format.
        """
        return pulumi.get(self, "rfc5424time_format")

    @property
    @pulumi.getter
    def separator(self) -> str:
        """
        Keys of adjacent levels are joined by the separator.
        """
        return pulumi.get(self, "separator")

    @property
    @pulumi.getter(name="syslogParserType")
    def syslog_parser_type(self) -> str:
        """
        Syslog parser type.
        """
        return pulumi.get(self, "syslog_parser_type")

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> str:
        """
        Process time value using the specified format.
        """
        return pulumi.get(self, "time_format")

    @property
    @pulumi.getter(name="timeType")
    def time_type(self) -> str:
        """
        JSON parser time type.
        """
        return pulumi.get(self, "time_type")

    @property
    @pulumi.getter(name="timeoutInMilliseconds")
    def timeout_in_milliseconds(self) -> int:
        """
        Specify the timeout for parse processing. This is mainly for detecting an incorrect regexp pattern.
        """
        return pulumi.get(self, "timeout_in_milliseconds")

    @property
    @pulumi.getter
    def types(self) -> Mapping[str, Any]:
        """
        Specify types for converting a field into another type. For example, With this configuration: <parse> @type csv keys time,host,req_id,user time_key time </parse>
        """
        return pulumi.get(self, "types")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserNestedParserResult(dict):
    def __init__(__self__, *,
                 field_time_key: str,
                 is_keep_time_key: bool,
                 parse_nested: bool,
                 separator: str,
                 time_format: str,
                 time_type: str):
        """
        :param str field_time_key: Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param bool is_keep_time_key: If true, keep the time field in the record.
        :param bool parse_nested: If true, a separator parameter can be further defined.
        :param str separator: Keys of adjacent levels are joined by the separator.
        :param str time_format: Process time value using the specified format.
        :param str time_type: JSON parser time type.
        """
        pulumi.set(__self__, "field_time_key", field_time_key)
        pulumi.set(__self__, "is_keep_time_key", is_keep_time_key)
        pulumi.set(__self__, "parse_nested", parse_nested)
        pulumi.set(__self__, "separator", separator)
        pulumi.set(__self__, "time_format", time_format)
        pulumi.set(__self__, "time_type", time_type)

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> str:
        """
        Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @property
    @pulumi.getter(name="isKeepTimeKey")
    def is_keep_time_key(self) -> bool:
        """
        If true, keep the time field in the record.
        """
        return pulumi.get(self, "is_keep_time_key")

    @property
    @pulumi.getter(name="parseNested")
    def parse_nested(self) -> bool:
        """
        If true, a separator parameter can be further defined.
        """
        return pulumi.get(self, "parse_nested")

    @property
    @pulumi.getter
    def separator(self) -> str:
        """
        Keys of adjacent levels are joined by the separator.
        """
        return pulumi.get(self, "separator")

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> str:
        """
        Process time value using the specified format.
        """
        return pulumi.get(self, "time_format")

    @property
    @pulumi.getter(name="timeType")
    def time_type(self) -> str:
        """
        JSON parser time type.
        """
        return pulumi.get(self, "time_type")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserPatternResult(dict):
    def __init__(__self__, *,
                 field_time_format: str,
                 field_time_key: str,
                 field_time_zone: str,
                 name: str,
                 pattern: str):
        """
        :param str field_time_format: Process value using the specified format. This is available only when time_type is a string.
        :param str field_time_key: Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param str field_time_zone: Use the specified time zone. The time value can be parsed or formatted in the specified time zone.
        :param str name: The name key to tag this Grok pattern.
        :param str pattern: The Grok pattern.
        """
        pulumi.set(__self__, "field_time_format", field_time_format)
        pulumi.set(__self__, "field_time_key", field_time_key)
        pulumi.set(__self__, "field_time_zone", field_time_zone)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "pattern", pattern)

    @property
    @pulumi.getter(name="fieldTimeFormat")
    def field_time_format(self) -> str:
        """
        Process value using the specified format. This is available only when time_type is a string.
        """
        return pulumi.get(self, "field_time_format")

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> str:
        """
        Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @property
    @pulumi.getter(name="fieldTimeZone")
    def field_time_zone(self) -> str:
        """
        Use the specified time zone. The time value can be parsed or formatted in the specified time zone.
        """
        return pulumi.get(self, "field_time_zone")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name key to tag this Grok pattern.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def pattern(self) -> str:
        """
        The Grok pattern.
        """
        return pulumi.get(self, "pattern")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserRecordInputResult(dict):
    def __init__(__self__, *,
                 dimensions: Mapping[str, Any],
                 namespace: str,
                 resource_group: str):
        """
        :param Mapping[str, Any] dimensions: Dimensions to be added for metrics.
        :param str namespace: Namespace to emit metrics.
        :param str resource_group: Resource group to emit metrics.
        """
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "resource_group", resource_group)

    @property
    @pulumi.getter
    def dimensions(self) -> Mapping[str, Any]:
        """
        Dimensions to be added for metrics.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Namespace to emit metrics.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> str:
        """
        Resource group to emit metrics.
        """
        return pulumi.get(self, "resource_group")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterRecordListResult(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: A new key
        :param str value: A new value
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        A new key
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        A new value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetUnifiedAgentConfigurationsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name key to tag this Grok pattern.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name key to tag this Grok pattern.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetUnifiedAgentConfigurationsUnifiedAgentConfigurationCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetUnifiedAgentConfigurationsUnifiedAgentConfigurationCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetUnifiedAgentConfigurationsUnifiedAgentConfigurationCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetUnifiedAgentConfigurationsUnifiedAgentConfigurationCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 configuration_state: str,
                 configuration_type: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_enabled: bool,
                 state: str,
                 time_created: str,
                 time_last_modified: str):
        """
        :param str compartment_id: Compartment OCID to list resources in. See compartmentIdInSubtree for nested compartments traversal.
        :param str configuration_state: State of unified agent service configuration.
        :param str configuration_type: Type of Unified Agent service configuration.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param str description: Description for this resource.
        :param str display_name: Resource name.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: The OCID of the resource.
        :param bool is_enabled: Whether or not this resource is currently enabled.
        :param str state: Lifecycle state of the log object
        :param str time_created: Time the resource was created.
        :param str time_last_modified: Time the resource was last modified.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "configuration_state", configuration_state)
        pulumi.set(__self__, "configuration_type", configuration_type)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_last_modified", time_last_modified)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment OCID to list resources in. See compartmentIdInSubtree for nested compartments traversal.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="configurationState")
    def configuration_state(self) -> str:
        """
        State of unified agent service configuration.
        """
        return pulumi.get(self, "configuration_state")

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> str:
        """
        Type of Unified Agent service configuration.
        """
        return pulumi.get(self, "configuration_type")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description for this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether or not this resource is currently enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Lifecycle state of the log object
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Time the resource was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastModified")
    def time_last_modified(self) -> str:
        """
        Time the resource was last modified.
        """
        return pulumi.get(self, "time_last_modified")


