# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetClusterResult',
    'AwaitableGetClusterResult',
    'get_cluster',
    'get_cluster_output',
]

@pulumi.output_type
class GetClusterResult:
    """
    A collection of values returned by getCluster.
    """
    def __init__(__self__, actual_esxi_hosts_count=None, capacity_reservation_id=None, cluster_id=None, compartment_id=None, compute_availability_domain=None, datastores=None, defined_tags=None, display_name=None, esxi_hosts_count=None, esxi_software_version=None, freeform_tags=None, id=None, initial_commitment=None, initial_host_ocpu_count=None, initial_host_shape_name=None, instance_display_name_prefix=None, is_shielded_instance_enabled=None, network_configurations=None, sddc_id=None, state=None, time_created=None, time_updated=None, upgrade_licenses=None, vmware_software_version=None, vsphere_type=None, vsphere_upgrade_objects=None, workload_network_cidr=None):
        if actual_esxi_hosts_count and not isinstance(actual_esxi_hosts_count, int):
            raise TypeError("Expected argument 'actual_esxi_hosts_count' to be a int")
        pulumi.set(__self__, "actual_esxi_hosts_count", actual_esxi_hosts_count)
        if capacity_reservation_id and not isinstance(capacity_reservation_id, str):
            raise TypeError("Expected argument 'capacity_reservation_id' to be a str")
        pulumi.set(__self__, "capacity_reservation_id", capacity_reservation_id)
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_availability_domain and not isinstance(compute_availability_domain, str):
            raise TypeError("Expected argument 'compute_availability_domain' to be a str")
        pulumi.set(__self__, "compute_availability_domain", compute_availability_domain)
        if datastores and not isinstance(datastores, list):
            raise TypeError("Expected argument 'datastores' to be a list")
        pulumi.set(__self__, "datastores", datastores)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if esxi_hosts_count and not isinstance(esxi_hosts_count, int):
            raise TypeError("Expected argument 'esxi_hosts_count' to be a int")
        pulumi.set(__self__, "esxi_hosts_count", esxi_hosts_count)
        if esxi_software_version and not isinstance(esxi_software_version, str):
            raise TypeError("Expected argument 'esxi_software_version' to be a str")
        pulumi.set(__self__, "esxi_software_version", esxi_software_version)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if initial_commitment and not isinstance(initial_commitment, str):
            raise TypeError("Expected argument 'initial_commitment' to be a str")
        pulumi.set(__self__, "initial_commitment", initial_commitment)
        if initial_host_ocpu_count and not isinstance(initial_host_ocpu_count, float):
            raise TypeError("Expected argument 'initial_host_ocpu_count' to be a float")
        pulumi.set(__self__, "initial_host_ocpu_count", initial_host_ocpu_count)
        if initial_host_shape_name and not isinstance(initial_host_shape_name, str):
            raise TypeError("Expected argument 'initial_host_shape_name' to be a str")
        pulumi.set(__self__, "initial_host_shape_name", initial_host_shape_name)
        if instance_display_name_prefix and not isinstance(instance_display_name_prefix, str):
            raise TypeError("Expected argument 'instance_display_name_prefix' to be a str")
        pulumi.set(__self__, "instance_display_name_prefix", instance_display_name_prefix)
        if is_shielded_instance_enabled and not isinstance(is_shielded_instance_enabled, bool):
            raise TypeError("Expected argument 'is_shielded_instance_enabled' to be a bool")
        pulumi.set(__self__, "is_shielded_instance_enabled", is_shielded_instance_enabled)
        if network_configurations and not isinstance(network_configurations, list):
            raise TypeError("Expected argument 'network_configurations' to be a list")
        pulumi.set(__self__, "network_configurations", network_configurations)
        if sddc_id and not isinstance(sddc_id, str):
            raise TypeError("Expected argument 'sddc_id' to be a str")
        pulumi.set(__self__, "sddc_id", sddc_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if upgrade_licenses and not isinstance(upgrade_licenses, list):
            raise TypeError("Expected argument 'upgrade_licenses' to be a list")
        pulumi.set(__self__, "upgrade_licenses", upgrade_licenses)
        if vmware_software_version and not isinstance(vmware_software_version, str):
            raise TypeError("Expected argument 'vmware_software_version' to be a str")
        pulumi.set(__self__, "vmware_software_version", vmware_software_version)
        if vsphere_type and not isinstance(vsphere_type, str):
            raise TypeError("Expected argument 'vsphere_type' to be a str")
        pulumi.set(__self__, "vsphere_type", vsphere_type)
        if vsphere_upgrade_objects and not isinstance(vsphere_upgrade_objects, list):
            raise TypeError("Expected argument 'vsphere_upgrade_objects' to be a list")
        pulumi.set(__self__, "vsphere_upgrade_objects", vsphere_upgrade_objects)
        if workload_network_cidr and not isinstance(workload_network_cidr, str):
            raise TypeError("Expected argument 'workload_network_cidr' to be a str")
        pulumi.set(__self__, "workload_network_cidr", workload_network_cidr)

    @property
    @pulumi.getter(name="actualEsxiHostsCount")
    def actual_esxi_hosts_count(self) -> int:
        return pulumi.get(self, "actual_esxi_hosts_count")

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        """
        return pulumi.get(self, "capacity_reservation_id")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Cluster.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeAvailabilityDomain")
    def compute_availability_domain(self) -> str:
        """
        The availability domain the ESXi hosts are running in. For Multi-AD Cluster, it is `multi-AD`.  Example: `Uocm:PHX-AD-1`, `multi-AD`
        """
        return pulumi.get(self, "compute_availability_domain")

    @property
    @pulumi.getter
    def datastores(self) -> Sequence['outputs.GetClusterDatastoreResult']:
        """
        Datastores used for the Cluster.
        """
        return pulumi.get(self, "datastores")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A descriptive name for the Cluster. It must be unique, start with a letter, and contain only letters, digits, whitespaces, dashes and underscores. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="esxiHostsCount")
    def esxi_hosts_count(self) -> int:
        """
        The number of ESXi hosts in the Cluster.
        """
        return pulumi.get(self, "esxi_hosts_count")

    @property
    @pulumi.getter(name="esxiSoftwareVersion")
    def esxi_software_version(self) -> str:
        """
        In general, this is a specific version of bundled ESXi software supported by Oracle Cloud VMware Solution (see [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions)).
        """
        return pulumi.get(self, "esxi_software_version")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Cluster.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="initialCommitment")
    def initial_commitment(self) -> str:
        """
        The billing option selected during Cluster creation. [ListSupportedCommitments](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedCommitmentSummary/ListSupportedCommitments).
        """
        return pulumi.get(self, "initial_commitment")

    @property
    @pulumi.getter(name="initialHostOcpuCount")
    def initial_host_ocpu_count(self) -> float:
        """
        The initial OCPU count of the Cluster's ESXi hosts.
        """
        return pulumi.get(self, "initial_host_ocpu_count")

    @property
    @pulumi.getter(name="initialHostShapeName")
    def initial_host_shape_name(self) -> str:
        """
        The initial compute shape of the Cluster's ESXi hosts. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        """
        return pulumi.get(self, "initial_host_shape_name")

    @property
    @pulumi.getter(name="instanceDisplayNamePrefix")
    def instance_display_name_prefix(self) -> str:
        """
        A prefix used in the name of each ESXi host and Compute instance in the Cluster. If this isn't set, the Cluster's `displayName` is used as the prefix.
        """
        return pulumi.get(self, "instance_display_name_prefix")

    @property
    @pulumi.getter(name="isShieldedInstanceEnabled")
    def is_shielded_instance_enabled(self) -> bool:
        """
        Indicates whether shielded instance is enabled at the Cluster level.
        """
        return pulumi.get(self, "is_shielded_instance_enabled")

    @property
    @pulumi.getter(name="networkConfigurations")
    def network_configurations(self) -> Sequence['outputs.GetClusterNetworkConfigurationResult']:
        """
        The network configurations used by Cluster, including [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet and VLANs.
        """
        return pulumi.get(self, "network_configurations")

    @property
    @pulumi.getter(name="sddcId")
    def sddc_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC that the Cluster belongs to.
        """
        return pulumi.get(self, "sddc_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Cluster.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the Cluster was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the Cluster was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="upgradeLicenses")
    def upgrade_licenses(self) -> Sequence['outputs.GetClusterUpgradeLicenseResult']:
        """
        The vSphere licenses to use when upgrading the Cluster.
        """
        return pulumi.get(self, "upgrade_licenses")

    @property
    @pulumi.getter(name="vmwareSoftwareVersion")
    def vmware_software_version(self) -> str:
        """
        In general, this is a specific version of bundled VMware software supported by Oracle Cloud VMware Solution (see [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions)).
        """
        return pulumi.get(self, "vmware_software_version")

    @property
    @pulumi.getter(name="vsphereType")
    def vsphere_type(self) -> str:
        """
        vSphere Cluster types.
        """
        return pulumi.get(self, "vsphere_type")

    @property
    @pulumi.getter(name="vsphereUpgradeObjects")
    def vsphere_upgrade_objects(self) -> Sequence['outputs.GetClusterVsphereUpgradeObjectResult']:
        """
        The links to binary objects needed to upgrade vSphere.
        """
        return pulumi.get(self, "vsphere_upgrade_objects")

    @property
    @pulumi.getter(name="workloadNetworkCidr")
    def workload_network_cidr(self) -> str:
        """
        The CIDR block for the IP addresses that VMware VMs in the SDDC use to run application workloads.
        """
        return pulumi.get(self, "workload_network_cidr")


class AwaitableGetClusterResult(GetClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterResult(
            actual_esxi_hosts_count=self.actual_esxi_hosts_count,
            capacity_reservation_id=self.capacity_reservation_id,
            cluster_id=self.cluster_id,
            compartment_id=self.compartment_id,
            compute_availability_domain=self.compute_availability_domain,
            datastores=self.datastores,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            esxi_hosts_count=self.esxi_hosts_count,
            esxi_software_version=self.esxi_software_version,
            freeform_tags=self.freeform_tags,
            id=self.id,
            initial_commitment=self.initial_commitment,
            initial_host_ocpu_count=self.initial_host_ocpu_count,
            initial_host_shape_name=self.initial_host_shape_name,
            instance_display_name_prefix=self.instance_display_name_prefix,
            is_shielded_instance_enabled=self.is_shielded_instance_enabled,
            network_configurations=self.network_configurations,
            sddc_id=self.sddc_id,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated,
            upgrade_licenses=self.upgrade_licenses,
            vmware_software_version=self.vmware_software_version,
            vsphere_type=self.vsphere_type,
            vsphere_upgrade_objects=self.vsphere_upgrade_objects,
            workload_network_cidr=self.workload_network_cidr)


def get_cluster(cluster_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterResult:
    """
    This data source provides details about a specific Cluster resource in Oracle Cloud Infrastructure Oracle Cloud VMware Solution service.

    Gets the specified Cluster's information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cluster = oci.Ocvp.get_cluster(cluster_id=test_cluster_oci_ocvp_cluster["id"])
    ```


    :param str cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Cluster.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Ocvp/getCluster:getCluster', __args__, opts=opts, typ=GetClusterResult).value

    return AwaitableGetClusterResult(
        actual_esxi_hosts_count=pulumi.get(__ret__, 'actual_esxi_hosts_count'),
        capacity_reservation_id=pulumi.get(__ret__, 'capacity_reservation_id'),
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compute_availability_domain=pulumi.get(__ret__, 'compute_availability_domain'),
        datastores=pulumi.get(__ret__, 'datastores'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        esxi_hosts_count=pulumi.get(__ret__, 'esxi_hosts_count'),
        esxi_software_version=pulumi.get(__ret__, 'esxi_software_version'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        initial_commitment=pulumi.get(__ret__, 'initial_commitment'),
        initial_host_ocpu_count=pulumi.get(__ret__, 'initial_host_ocpu_count'),
        initial_host_shape_name=pulumi.get(__ret__, 'initial_host_shape_name'),
        instance_display_name_prefix=pulumi.get(__ret__, 'instance_display_name_prefix'),
        is_shielded_instance_enabled=pulumi.get(__ret__, 'is_shielded_instance_enabled'),
        network_configurations=pulumi.get(__ret__, 'network_configurations'),
        sddc_id=pulumi.get(__ret__, 'sddc_id'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        upgrade_licenses=pulumi.get(__ret__, 'upgrade_licenses'),
        vmware_software_version=pulumi.get(__ret__, 'vmware_software_version'),
        vsphere_type=pulumi.get(__ret__, 'vsphere_type'),
        vsphere_upgrade_objects=pulumi.get(__ret__, 'vsphere_upgrade_objects'),
        workload_network_cidr=pulumi.get(__ret__, 'workload_network_cidr'))


@_utilities.lift_output_func(get_cluster)
def get_cluster_output(cluster_id: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetClusterResult]:
    """
    This data source provides details about a specific Cluster resource in Oracle Cloud Infrastructure Oracle Cloud VMware Solution service.

    Gets the specified Cluster's information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cluster = oci.Ocvp.get_cluster(cluster_id=test_cluster_oci_ocvp_cluster["id"])
    ```


    :param str cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Cluster.
    """
    ...
