# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'LifecycleEnvironmentManagedInstanceIdArgs',
    'LifecycleEnvironmentStageArgs',
    'LifecycleEnvironmentStageManagedInstanceIdArgs',
    'LifecycleEnvironmentStageSoftwareSourceIdArgs',
    'ManagedInstanceGroupSoftwareSourceArgs',
    'ManagementStationMirrorArgs',
    'ManagementStationMirrorSyncStatusArgs',
    'ManagementStationProxyArgs',
    'ProfileLifecycleEnvironmentArgs',
    'ProfileLifecycleStageArgs',
    'ProfileManagedInstanceGroupArgs',
    'ProfileSoftwareSourceArgs',
    'SoftwareSourceCustomSoftwareSourceFilterArgs',
    'SoftwareSourceCustomSoftwareSourceFilterModuleStreamProfileFilterArgs',
    'SoftwareSourceCustomSoftwareSourceFilterPackageFilterArgs',
    'SoftwareSourceCustomSoftwareSourceFilterPackageGroupFilterArgs',
    'SoftwareSourceVendorSoftwareSourceArgs',
    'GetLifecycleEnvironmentsFilterArgs',
    'GetLifecycleStagesFilterArgs',
    'GetManagedInstanceGroupAvailableModulesFilterArgs',
    'GetManagedInstanceGroupAvailablePackagesFilterArgs',
    'GetManagedInstanceGroupAvailableSoftwareSourcesFilterArgs',
    'GetManagedInstanceGroupsFilterArgs',
    'GetManagementStationMirrorsFilterArgs',
    'GetManagementStationsFilterArgs',
    'GetProfilesFilterArgs',
    'GetSoftwareSourceModuleStreamProfilesFilterArgs',
    'GetSoftwareSourceModuleStreamsFilterArgs',
    'GetSoftwareSourcePackageGroupsFilterArgs',
    'GetSoftwareSourceSoftwarePackagesFilterArgs',
    'GetSoftwareSourceVendorsFilterArgs',
    'GetSoftwareSourcesFilterArgs',
]

@pulumi.input_type
class LifecycleEnvironmentManagedInstanceIdArgs:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] id: The OCID of the software source.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the software source.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class LifecycleEnvironmentStageArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[str],
                 rank: pulumi.Input[int],
                 arch_type: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 lifecycle_environment_id: Optional[pulumi.Input[str]] = None,
                 managed_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input['LifecycleEnvironmentStageManagedInstanceIdArgs']]]] = None,
                 os_family: Optional[pulumi.Input[str]] = None,
                 software_source_ids: Optional[pulumi.Input[Sequence[pulumi.Input['LifecycleEnvironmentStageSoftwareSourceIdArgs']]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_modified: Optional[pulumi.Input[str]] = None,
                 vendor_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[int] rank: User specified rank for the lifecycle stage. Rank determines the hierarchy of the lifecycle stages for a given lifecycle environment.
        :param pulumi.Input[str] arch_type: The CPU architecture of the managed instance(s) in the lifecycle environment.
        :param pulumi.Input[str] compartment_id: The OCID of the tenancy containing the lifecycle environment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] id: The OCID of the software source.
        :param pulumi.Input[str] lifecycle_environment_id: The OCID of the lifecycle environment for the lifecycle stage.
        :param pulumi.Input[Sequence[pulumi.Input['LifecycleEnvironmentStageManagedInstanceIdArgs']]] managed_instance_ids: The list of managed instances specified lifecycle stage.
        :param pulumi.Input[str] os_family: The operating system type of the managed instance(s) in the lifecycle environment.
        :param pulumi.Input[Sequence[pulumi.Input['LifecycleEnvironmentStageSoftwareSourceIdArgs']]] software_source_ids: Identifying information for the specified software source.
        :param pulumi.Input[str] state: The current state of the lifecycle environment.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time the lifecycle environment was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_modified: The time the lifecycle environment was last modified. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] vendor_name: The software source vendor name.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "rank", rank)
        if arch_type is not None:
            pulumi.set(__self__, "arch_type", arch_type)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if lifecycle_environment_id is not None:
            pulumi.set(__self__, "lifecycle_environment_id", lifecycle_environment_id)
        if managed_instance_ids is not None:
            pulumi.set(__self__, "managed_instance_ids", managed_instance_ids)
        if os_family is not None:
            pulumi.set(__self__, "os_family", os_family)
        if software_source_ids is not None:
            pulumi.set(__self__, "software_source_ids", software_source_ids)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_modified is not None:
            pulumi.set(__self__, "time_modified", time_modified)
        if vendor_name is not None:
            pulumi.set(__self__, "vendor_name", vendor_name)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def rank(self) -> pulumi.Input[int]:
        """
        User specified rank for the lifecycle stage. Rank determines the hierarchy of the lifecycle stages for a given lifecycle environment.
        """
        return pulumi.get(self, "rank")

    @rank.setter
    def rank(self, value: pulumi.Input[int]):
        pulumi.set(self, "rank", value)

    @property
    @pulumi.getter(name="archType")
    def arch_type(self) -> Optional[pulumi.Input[str]]:
        """
        The CPU architecture of the managed instance(s) in the lifecycle environment.
        """
        return pulumi.get(self, "arch_type")

    @arch_type.setter
    def arch_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arch_type", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the tenancy containing the lifecycle environment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the software source.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="lifecycleEnvironmentId")
    def lifecycle_environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the lifecycle environment for the lifecycle stage.
        """
        return pulumi.get(self, "lifecycle_environment_id")

    @lifecycle_environment_id.setter
    def lifecycle_environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_environment_id", value)

    @property
    @pulumi.getter(name="managedInstanceIds")
    def managed_instance_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LifecycleEnvironmentStageManagedInstanceIdArgs']]]]:
        """
        The list of managed instances specified lifecycle stage.
        """
        return pulumi.get(self, "managed_instance_ids")

    @managed_instance_ids.setter
    def managed_instance_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LifecycleEnvironmentStageManagedInstanceIdArgs']]]]):
        pulumi.set(self, "managed_instance_ids", value)

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> Optional[pulumi.Input[str]]:
        """
        The operating system type of the managed instance(s) in the lifecycle environment.
        """
        return pulumi.get(self, "os_family")

    @os_family.setter
    def os_family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_family", value)

    @property
    @pulumi.getter(name="softwareSourceIds")
    def software_source_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LifecycleEnvironmentStageSoftwareSourceIdArgs']]]]:
        """
        Identifying information for the specified software source.
        """
        return pulumi.get(self, "software_source_ids")

    @software_source_ids.setter
    def software_source_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LifecycleEnvironmentStageSoftwareSourceIdArgs']]]]):
        pulumi.set(self, "software_source_ids", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the lifecycle environment.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the lifecycle environment was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeModified")
    def time_modified(self) -> Optional[pulumi.Input[str]]:
        """
        The time the lifecycle environment was last modified. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_modified")

    @time_modified.setter
    def time_modified(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_modified", value)

    @property
    @pulumi.getter(name="vendorName")
    def vendor_name(self) -> Optional[pulumi.Input[str]]:
        """
        The software source vendor name.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vendor_name")

    @vendor_name.setter
    def vendor_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vendor_name", value)


@pulumi.input_type
class LifecycleEnvironmentStageManagedInstanceIdArgs:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] id: The OCID of the software source.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the software source.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class LifecycleEnvironmentStageSoftwareSourceIdArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 software_source_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] description: (Updatable) User specified information about the lifecycle environment.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] id: The OCID of the software source.
        :param pulumi.Input[str] software_source_type: Type of the software source.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if software_source_type is not None:
            pulumi.set(__self__, "software_source_type", software_source_type)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User specified information about the lifecycle environment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the software source.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="softwareSourceType")
    def software_source_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the software source.
        """
        return pulumi.get(self, "software_source_type")

    @software_source_type.setter
    def software_source_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "software_source_type", value)


@pulumi.input_type
class ManagedInstanceGroupSoftwareSourceArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 software_source_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] description: (Updatable) Details about the managed instance group.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name for the managed instance group. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] id: The OCID of the software source.
        :param pulumi.Input[str] software_source_type: Type of the software source.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if software_source_type is not None:
            pulumi.set(__self__, "software_source_type", software_source_type)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Details about the managed instance group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name for the managed instance group. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the software source.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="softwareSourceType")
    def software_source_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the software source.
        """
        return pulumi.get(self, "software_source_type")

    @software_source_type.setter
    def software_source_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "software_source_type", value)


@pulumi.input_type
class ManagementStationMirrorArgs:
    def __init__(__self__, *,
                 directory: pulumi.Input[str],
                 port: pulumi.Input[str],
                 sslport: pulumi.Input[str],
                 sslcert: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] directory: (Updatable) Directory for the mirroring
        :param pulumi.Input[str] port: (Updatable) Port that the proxy will use
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] sslport: (Updatable) Default sslport for the mirror
        :param pulumi.Input[str] sslcert: (Updatable) Local path for the sslcert
        """
        pulumi.set(__self__, "directory", directory)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "sslport", sslport)
        if sslcert is not None:
            pulumi.set(__self__, "sslcert", sslcert)

    @property
    @pulumi.getter
    def directory(self) -> pulumi.Input[str]:
        """
        (Updatable) Directory for the mirroring
        """
        return pulumi.get(self, "directory")

    @directory.setter
    def directory(self, value: pulumi.Input[str]):
        pulumi.set(self, "directory", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[str]:
        """
        (Updatable) Port that the proxy will use


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[str]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def sslport(self) -> pulumi.Input[str]:
        """
        (Updatable) Default sslport for the mirror
        """
        return pulumi.get(self, "sslport")

    @sslport.setter
    def sslport(self, value: pulumi.Input[str]):
        pulumi.set(self, "sslport", value)

    @property
    @pulumi.getter
    def sslcert(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Local path for the sslcert
        """
        return pulumi.get(self, "sslcert")

    @sslcert.setter
    def sslcert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sslcert", value)


@pulumi.input_type
class ManagementStationMirrorSyncStatusArgs:
    def __init__(__self__, *,
                 failed: Optional[pulumi.Input[int]] = None,
                 queued: Optional[pulumi.Input[int]] = None,
                 synced: Optional[pulumi.Input[int]] = None,
                 syncing: Optional[pulumi.Input[int]] = None,
                 unsynced: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] failed: Total of mirrors in 'failed' state
        :param pulumi.Input[int] queued: Total of mirrors in 'queued' state
        :param pulumi.Input[int] synced: Total of mirrors in 'synced' state
        :param pulumi.Input[int] syncing: Total of mirrors in 'syncing' state
        :param pulumi.Input[int] unsynced: Total of mirrors in 'failed' state
        """
        if failed is not None:
            pulumi.set(__self__, "failed", failed)
        if queued is not None:
            pulumi.set(__self__, "queued", queued)
        if synced is not None:
            pulumi.set(__self__, "synced", synced)
        if syncing is not None:
            pulumi.set(__self__, "syncing", syncing)
        if unsynced is not None:
            pulumi.set(__self__, "unsynced", unsynced)

    @property
    @pulumi.getter
    def failed(self) -> Optional[pulumi.Input[int]]:
        """
        Total of mirrors in 'failed' state
        """
        return pulumi.get(self, "failed")

    @failed.setter
    def failed(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failed", value)

    @property
    @pulumi.getter
    def queued(self) -> Optional[pulumi.Input[int]]:
        """
        Total of mirrors in 'queued' state
        """
        return pulumi.get(self, "queued")

    @queued.setter
    def queued(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "queued", value)

    @property
    @pulumi.getter
    def synced(self) -> Optional[pulumi.Input[int]]:
        """
        Total of mirrors in 'synced' state
        """
        return pulumi.get(self, "synced")

    @synced.setter
    def synced(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "synced", value)

    @property
    @pulumi.getter
    def syncing(self) -> Optional[pulumi.Input[int]]:
        """
        Total of mirrors in 'syncing' state
        """
        return pulumi.get(self, "syncing")

    @syncing.setter
    def syncing(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "syncing", value)

    @property
    @pulumi.getter
    def unsynced(self) -> Optional[pulumi.Input[int]]:
        """
        Total of mirrors in 'failed' state
        """
        return pulumi.get(self, "unsynced")

    @unsynced.setter
    def unsynced(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "unsynced", value)


@pulumi.input_type
class ManagementStationProxyArgs:
    def __init__(__self__, *,
                 is_enabled: pulumi.Input[bool],
                 forward: Optional[pulumi.Input[str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 port: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] is_enabled: (Updatable) To enable or disable the proxy (default true)
        :param pulumi.Input[str] forward: (Updatable) URL that the proxy will forward to
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hosts: (Updatable) List of hosts
        :param pulumi.Input[str] port: (Updatable) Port that the proxy will use
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        if forward is not None:
            pulumi.set(__self__, "forward", forward)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        (Updatable) To enable or disable the proxy (default true)
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter
    def forward(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) URL that the proxy will forward to
        """
        return pulumi.get(self, "forward")

    @forward.setter
    def forward(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "forward", value)

    @property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) List of hosts
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "hosts", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Port that the proxy will use


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class ProfileLifecycleEnvironmentArgs:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] id: The OCID of the software source.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the software source.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class ProfileLifecycleStageArgs:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] id: The OCID of the software source.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the software source.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class ProfileManagedInstanceGroupArgs:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] id: The OCID of the software source.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the software source.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class ProfileSoftwareSourceArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 software_source_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] description: (Updatable) The description of the registration profile.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] id: The OCID of the software source.
        :param pulumi.Input[str] software_source_type: Type of the software source.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if software_source_type is not None:
            pulumi.set(__self__, "software_source_type", software_source_type)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the registration profile.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the software source.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="softwareSourceType")
    def software_source_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the software source.
        """
        return pulumi.get(self, "software_source_type")

    @software_source_type.setter
    def software_source_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "software_source_type", value)


@pulumi.input_type
class SoftwareSourceCustomSoftwareSourceFilterArgs:
    def __init__(__self__, *,
                 module_stream_profile_filters: Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareSourceCustomSoftwareSourceFilterModuleStreamProfileFilterArgs']]]] = None,
                 package_filters: Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareSourceCustomSoftwareSourceFilterPackageFilterArgs']]]] = None,
                 package_group_filters: Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareSourceCustomSoftwareSourceFilterPackageGroupFilterArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['SoftwareSourceCustomSoftwareSourceFilterModuleStreamProfileFilterArgs']]] module_stream_profile_filters: (Updatable) The list of module stream/profile filters.
        :param pulumi.Input[Sequence[pulumi.Input['SoftwareSourceCustomSoftwareSourceFilterPackageFilterArgs']]] package_filters: (Updatable) The list of package filters.
        :param pulumi.Input[Sequence[pulumi.Input['SoftwareSourceCustomSoftwareSourceFilterPackageGroupFilterArgs']]] package_group_filters: (Updatable) The list of group filters.
        """
        if module_stream_profile_filters is not None:
            pulumi.set(__self__, "module_stream_profile_filters", module_stream_profile_filters)
        if package_filters is not None:
            pulumi.set(__self__, "package_filters", package_filters)
        if package_group_filters is not None:
            pulumi.set(__self__, "package_group_filters", package_group_filters)

    @property
    @pulumi.getter(name="moduleStreamProfileFilters")
    def module_stream_profile_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareSourceCustomSoftwareSourceFilterModuleStreamProfileFilterArgs']]]]:
        """
        (Updatable) The list of module stream/profile filters.
        """
        return pulumi.get(self, "module_stream_profile_filters")

    @module_stream_profile_filters.setter
    def module_stream_profile_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareSourceCustomSoftwareSourceFilterModuleStreamProfileFilterArgs']]]]):
        pulumi.set(self, "module_stream_profile_filters", value)

    @property
    @pulumi.getter(name="packageFilters")
    def package_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareSourceCustomSoftwareSourceFilterPackageFilterArgs']]]]:
        """
        (Updatable) The list of package filters.
        """
        return pulumi.get(self, "package_filters")

    @package_filters.setter
    def package_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareSourceCustomSoftwareSourceFilterPackageFilterArgs']]]]):
        pulumi.set(self, "package_filters", value)

    @property
    @pulumi.getter(name="packageGroupFilters")
    def package_group_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareSourceCustomSoftwareSourceFilterPackageGroupFilterArgs']]]]:
        """
        (Updatable) The list of group filters.
        """
        return pulumi.get(self, "package_group_filters")

    @package_group_filters.setter
    def package_group_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SoftwareSourceCustomSoftwareSourceFilterPackageGroupFilterArgs']]]]):
        pulumi.set(self, "package_group_filters", value)


@pulumi.input_type
class SoftwareSourceCustomSoftwareSourceFilterModuleStreamProfileFilterArgs:
    def __init__(__self__, *,
                 filter_type: pulumi.Input[str],
                 module_name: pulumi.Input[str],
                 profile_name: Optional[pulumi.Input[str]] = None,
                 stream_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] filter_type: (Updatable) The type of the filter, which can be of two types - INCLUDE or EXCLUDE.
        :param pulumi.Input[str] module_name: (Updatable) Module name.
        :param pulumi.Input[str] profile_name: (Updatable) Profile name.
        :param pulumi.Input[str] stream_name: (Updatable) Stream name.
        """
        pulumi.set(__self__, "filter_type", filter_type)
        pulumi.set(__self__, "module_name", module_name)
        if profile_name is not None:
            pulumi.set(__self__, "profile_name", profile_name)
        if stream_name is not None:
            pulumi.set(__self__, "stream_name", stream_name)

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> pulumi.Input[str]:
        """
        (Updatable) The type of the filter, which can be of two types - INCLUDE or EXCLUDE.
        """
        return pulumi.get(self, "filter_type")

    @filter_type.setter
    def filter_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "filter_type", value)

    @property
    @pulumi.getter(name="moduleName")
    def module_name(self) -> pulumi.Input[str]:
        """
        (Updatable) Module name.
        """
        return pulumi.get(self, "module_name")

    @module_name.setter
    def module_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "module_name", value)

    @property
    @pulumi.getter(name="profileName")
    def profile_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Profile name.
        """
        return pulumi.get(self, "profile_name")

    @profile_name.setter
    def profile_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile_name", value)

    @property
    @pulumi.getter(name="streamName")
    def stream_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Stream name.
        """
        return pulumi.get(self, "stream_name")

    @stream_name.setter
    def stream_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stream_name", value)


@pulumi.input_type
class SoftwareSourceCustomSoftwareSourceFilterPackageFilterArgs:
    def __init__(__self__, *,
                 filter_type: pulumi.Input[str],
                 package_name: Optional[pulumi.Input[str]] = None,
                 package_name_pattern: Optional[pulumi.Input[str]] = None,
                 package_version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] filter_type: (Updatable) The type of the filter, which can be of two types - INCLUDE or EXCLUDE.
        :param pulumi.Input[str] package_name: (Updatable) The package name.
        :param pulumi.Input[str] package_name_pattern: (Updatable) The package name pattern.
        :param pulumi.Input[str] package_version: (Updatable) The package version, which is denoted by 'version-release', or 'epoch:version-release'.
        """
        pulumi.set(__self__, "filter_type", filter_type)
        if package_name is not None:
            pulumi.set(__self__, "package_name", package_name)
        if package_name_pattern is not None:
            pulumi.set(__self__, "package_name_pattern", package_name_pattern)
        if package_version is not None:
            pulumi.set(__self__, "package_version", package_version)

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> pulumi.Input[str]:
        """
        (Updatable) The type of the filter, which can be of two types - INCLUDE or EXCLUDE.
        """
        return pulumi.get(self, "filter_type")

    @filter_type.setter
    def filter_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "filter_type", value)

    @property
    @pulumi.getter(name="packageName")
    def package_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The package name.
        """
        return pulumi.get(self, "package_name")

    @package_name.setter
    def package_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_name", value)

    @property
    @pulumi.getter(name="packageNamePattern")
    def package_name_pattern(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The package name pattern.
        """
        return pulumi.get(self, "package_name_pattern")

    @package_name_pattern.setter
    def package_name_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_name_pattern", value)

    @property
    @pulumi.getter(name="packageVersion")
    def package_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The package version, which is denoted by 'version-release', or 'epoch:version-release'.
        """
        return pulumi.get(self, "package_version")

    @package_version.setter
    def package_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_version", value)


@pulumi.input_type
class SoftwareSourceCustomSoftwareSourceFilterPackageGroupFilterArgs:
    def __init__(__self__, *,
                 filter_type: pulumi.Input[str],
                 package_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] filter_type: (Updatable) The type of the filter, which can be of two types - INCLUDE or EXCLUDE.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] package_groups: (Updatable) List of package group names.
        """
        pulumi.set(__self__, "filter_type", filter_type)
        if package_groups is not None:
            pulumi.set(__self__, "package_groups", package_groups)

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> pulumi.Input[str]:
        """
        (Updatable) The type of the filter, which can be of two types - INCLUDE or EXCLUDE.
        """
        return pulumi.get(self, "filter_type")

    @filter_type.setter
    def filter_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "filter_type", value)

    @property
    @pulumi.getter(name="packageGroups")
    def package_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) List of package group names.
        """
        return pulumi.get(self, "package_groups")

    @package_groups.setter
    def package_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "package_groups", value)


@pulumi.input_type
class SoftwareSourceVendorSoftwareSourceArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[str],
                 id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] display_name: (Updatable) User friendly name.
        :param pulumi.Input[str] id: (Updatable) The OCID of the resource that is immutable on creation.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) User friendly name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the resource that is immutable on creation.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class GetLifecycleEnvironmentsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetLifecycleStagesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetManagedInstanceGroupAvailableModulesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The resource name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetManagedInstanceGroupAvailablePackagesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Unique identifier for the package. NOTE - This is not an OCID.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique identifier for the package. NOTE - This is not an OCID.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetManagedInstanceGroupAvailableSoftwareSourcesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetManagedInstanceGroupsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetManagementStationMirrorsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetManagementStationsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetProfilesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetSoftwareSourceModuleStreamProfilesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name of the entity to be queried.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the entity to be queried.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetSoftwareSourceModuleStreamsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name of the entity to be queried.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the entity to be queried.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetSoftwareSourcePackageGroupsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name of the entity to be queried.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the entity to be queried.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetSoftwareSourceSoftwarePackagesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Unique identifier for the package. NOTE - This is not an OCID.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique identifier for the package. NOTE - This is not an OCID.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetSoftwareSourceVendorsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name of the entity to be queried.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the entity to be queried.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetSoftwareSourcesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


