# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagedInstanceGroupAvailableSoftwareSourcesResult',
    'AwaitableGetManagedInstanceGroupAvailableSoftwareSourcesResult',
    'get_managed_instance_group_available_software_sources',
    'get_managed_instance_group_available_software_sources_output',
]

@pulumi.output_type
class GetManagedInstanceGroupAvailableSoftwareSourcesResult:
    """
    A collection of values returned by getManagedInstanceGroupAvailableSoftwareSources.
    """
    def __init__(__self__, available_software_source_collections=None, compartment_id=None, display_name_contains=None, display_names=None, filters=None, id=None, managed_instance_group_id=None):
        if available_software_source_collections and not isinstance(available_software_source_collections, list):
            raise TypeError("Expected argument 'available_software_source_collections' to be a list")
        pulumi.set(__self__, "available_software_source_collections", available_software_source_collections)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name_contains and not isinstance(display_name_contains, str):
            raise TypeError("Expected argument 'display_name_contains' to be a str")
        pulumi.set(__self__, "display_name_contains", display_name_contains)
        if display_names and not isinstance(display_names, list):
            raise TypeError("Expected argument 'display_names' to be a list")
        pulumi.set(__self__, "display_names", display_names)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_instance_group_id and not isinstance(managed_instance_group_id, str):
            raise TypeError("Expected argument 'managed_instance_group_id' to be a str")
        pulumi.set(__self__, "managed_instance_group_id", managed_instance_group_id)

    @property
    @pulumi.getter(name="availableSoftwareSourceCollections")
    def available_software_source_collections(self) -> Sequence['outputs.GetManagedInstanceGroupAvailableSoftwareSourcesAvailableSoftwareSourceCollectionResult']:
        """
        The list of available_software_source_collection.
        """
        return pulumi.get(self, "available_software_source_collections")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The OCID for the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayNameContains")
    def display_name_contains(self) -> Optional[str]:
        return pulumi.get(self, "display_name_contains")

    @property
    @pulumi.getter(name="displayNames")
    def display_names(self) -> Optional[Sequence[str]]:
        """
        User friendly name for the software source.
        """
        return pulumi.get(self, "display_names")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagedInstanceGroupAvailableSoftwareSourcesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> str:
        return pulumi.get(self, "managed_instance_group_id")


class AwaitableGetManagedInstanceGroupAvailableSoftwareSourcesResult(GetManagedInstanceGroupAvailableSoftwareSourcesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedInstanceGroupAvailableSoftwareSourcesResult(
            available_software_source_collections=self.available_software_source_collections,
            compartment_id=self.compartment_id,
            display_name_contains=self.display_name_contains,
            display_names=self.display_names,
            filters=self.filters,
            id=self.id,
            managed_instance_group_id=self.managed_instance_group_id)


def get_managed_instance_group_available_software_sources(compartment_id: Optional[str] = None,
                                                          display_name_contains: Optional[str] = None,
                                                          display_names: Optional[Sequence[str]] = None,
                                                          filters: Optional[Sequence[pulumi.InputType['GetManagedInstanceGroupAvailableSoftwareSourcesFilterArgs']]] = None,
                                                          managed_instance_group_id: Optional[str] = None,
                                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedInstanceGroupAvailableSoftwareSourcesResult:
    """
    This data source provides the list of Managed Instance Group Available Software Sources in Oracle Cloud Infrastructure Os Management Hub service.

    Lists available software sources for a specified managed instance group. Filter the list against a variety of
    criteria including but not limited to its name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instance_group_available_software_sources = oci.OsManagementHub.get_managed_instance_group_available_software_sources(managed_instance_group_id=test_managed_instance_group["id"],
        compartment_id=compartment_id,
        display_names=managed_instance_group_available_software_source_display_name,
        display_name_contains=managed_instance_group_available_software_source_display_name_contains)
    ```


    :param str compartment_id: The OCID of the compartment that contains the resources to list.
    :param str display_name_contains: A filter to return resources that may partially match the given display name.
    :param Sequence[str] display_names: A filter to return resources that match the given display names.
    :param str managed_instance_group_id: The managed instance group OCID.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayNameContains'] = display_name_contains
    __args__['displayNames'] = display_names
    __args__['filters'] = filters
    __args__['managedInstanceGroupId'] = managed_instance_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getManagedInstanceGroupAvailableSoftwareSources:getManagedInstanceGroupAvailableSoftwareSources', __args__, opts=opts, typ=GetManagedInstanceGroupAvailableSoftwareSourcesResult).value

    return AwaitableGetManagedInstanceGroupAvailableSoftwareSourcesResult(
        available_software_source_collections=pulumi.get(__ret__, 'available_software_source_collections'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name_contains=pulumi.get(__ret__, 'display_name_contains'),
        display_names=pulumi.get(__ret__, 'display_names'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        managed_instance_group_id=pulumi.get(__ret__, 'managed_instance_group_id'))


@_utilities.lift_output_func(get_managed_instance_group_available_software_sources)
def get_managed_instance_group_available_software_sources_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                                 display_name_contains: Optional[pulumi.Input[Optional[str]]] = None,
                                                                 display_names: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                                                 filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetManagedInstanceGroupAvailableSoftwareSourcesFilterArgs']]]]] = None,
                                                                 managed_instance_group_id: Optional[pulumi.Input[str]] = None,
                                                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagedInstanceGroupAvailableSoftwareSourcesResult]:
    """
    This data source provides the list of Managed Instance Group Available Software Sources in Oracle Cloud Infrastructure Os Management Hub service.

    Lists available software sources for a specified managed instance group. Filter the list against a variety of
    criteria including but not limited to its name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instance_group_available_software_sources = oci.OsManagementHub.get_managed_instance_group_available_software_sources(managed_instance_group_id=test_managed_instance_group["id"],
        compartment_id=compartment_id,
        display_names=managed_instance_group_available_software_source_display_name,
        display_name_contains=managed_instance_group_available_software_source_display_name_contains)
    ```


    :param str compartment_id: The OCID of the compartment that contains the resources to list.
    :param str display_name_contains: A filter to return resources that may partially match the given display name.
    :param Sequence[str] display_names: A filter to return resources that match the given display names.
    :param str managed_instance_group_id: The managed instance group OCID.
    """
    ...
